package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInstanceEx invokes the cloudcallcenter.CreateInstanceEx API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createinstanceex.html
func (client *Client) CreateInstanceEx(request *CreateInstanceExRequest) (response *CreateInstanceExResponse, err error) {
	response = CreateCreateInstanceExResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInstanceExWithChan invokes the cloudcallcenter.CreateInstanceEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createinstanceex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateInstanceExWithChan(request *CreateInstanceExRequest) (<-chan *CreateInstanceExResponse, <-chan error) {
	responseChan := make(chan *CreateInstanceExResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInstanceEx(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInstanceExWithCallback invokes the cloudcallcenter.CreateInstanceEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createinstanceex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateInstanceExWithCallback(request *CreateInstanceExRequest, callback func(response *CreateInstanceExResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInstanceExResponse
		var err error
		defer close(result)
		response, err = client.CreateInstanceEx(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInstanceExRequest is the request struct for api CreateInstanceEx
type CreateInstanceExRequest struct {
	*requests.RpcRequest
	CreateInstanceParam string `position:"Query" name:"CreateInstanceParam"`
}

// CreateInstanceExResponse is the response struct for api CreateInstanceEx
type CreateInstanceExResponse struct {
	*responses.BaseResponse
	RequestId      string                     `json:"RequestId" xml:"RequestId"`
	Success        bool                       `json:"Success" xml:"Success"`
	Code           string                     `json:"Code" xml:"Code"`
	Message        string                     `json:"Message" xml:"Message"`
	HttpStatusCode int                        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Instance       InstanceInCreateInstanceEx `json:"Instance" xml:"Instance"`
}

// CreateCreateInstanceExRequest creates a request to invoke CreateInstanceEx API
func CreateCreateInstanceExRequest() (request *CreateInstanceExRequest) {
	request = &CreateInstanceExRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateInstanceEx", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateInstanceExResponse creates a response to parse from CreateInstanceEx response
func CreateCreateInstanceExResponse() (response *CreateInstanceExResponse) {
	response = &CreateInstanceExResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
