package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MobileOnlineTime invokes the cloudauth.MobileOnlineTime API synchronously
func (client *Client) MobileOnlineTime(request *MobileOnlineTimeRequest) (response *MobileOnlineTimeResponse, err error) {
	response = CreateMobileOnlineTimeResponse()
	err = client.DoAction(request, response)
	return
}

// MobileOnlineTimeWithChan invokes the cloudauth.MobileOnlineTime API asynchronously
func (client *Client) MobileOnlineTimeWithChan(request *MobileOnlineTimeRequest) (<-chan *MobileOnlineTimeResponse, <-chan error) {
	responseChan := make(chan *MobileOnlineTimeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MobileOnlineTime(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MobileOnlineTimeWithCallback invokes the cloudauth.MobileOnlineTime API asynchronously
func (client *Client) MobileOnlineTimeWithCallback(request *MobileOnlineTimeRequest, callback func(response *MobileOnlineTimeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MobileOnlineTimeResponse
		var err error
		defer close(result)
		response, err = client.MobileOnlineTime(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MobileOnlineTimeRequest is the request struct for api MobileOnlineTime
type MobileOnlineTimeRequest struct {
	*requests.RpcRequest
	ParamType string `position:"Body" name:"ParamType"`
	Mobile    string `position:"Body" name:"Mobile"`
}

// MobileOnlineTimeResponse is the response struct for api MobileOnlineTime
type MobileOnlineTimeResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateMobileOnlineTimeRequest creates a request to invoke MobileOnlineTime API
func CreateMobileOnlineTimeRequest() (request *MobileOnlineTimeRequest) {
	request = &MobileOnlineTimeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "MobileOnlineTime", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMobileOnlineTimeResponse creates a response to parse from MobileOnlineTime response
func CreateMobileOnlineTimeResponse() (response *MobileOnlineTimeResponse) {
	response = &MobileOnlineTimeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
