package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePluginTemplates invokes the cloudapi.DescribePluginTemplates API synchronously
func (client *Client) DescribePluginTemplates(request *DescribePluginTemplatesRequest) (response *DescribePluginTemplatesResponse, err error) {
	response = CreateDescribePluginTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePluginTemplatesWithChan invokes the cloudapi.DescribePluginTemplates API asynchronously
func (client *Client) DescribePluginTemplatesWithChan(request *DescribePluginTemplatesRequest) (<-chan *DescribePluginTemplatesResponse, <-chan error) {
	responseChan := make(chan *DescribePluginTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePluginTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePluginTemplatesWithCallback invokes the cloudapi.DescribePluginTemplates API asynchronously
func (client *Client) DescribePluginTemplatesWithCallback(request *DescribePluginTemplatesRequest, callback func(response *DescribePluginTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePluginTemplatesResponse
		var err error
		defer close(result)
		response, err = client.DescribePluginTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePluginTemplatesRequest is the request struct for api DescribePluginTemplates
type DescribePluginTemplatesRequest struct {
	*requests.RpcRequest
	PluginName    string `position:"Query" name:"PluginName"`
	Language      string `position:"Query" name:"Language"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribePluginTemplatesResponse is the response struct for api DescribePluginTemplates
type DescribePluginTemplatesResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Templates Templates `json:"Templates" xml:"Templates"`
}

// CreateDescribePluginTemplatesRequest creates a request to invoke DescribePluginTemplates API
func CreateDescribePluginTemplatesRequest() (request *DescribePluginTemplatesRequest) {
	request = &DescribePluginTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribePluginTemplates", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePluginTemplatesResponse creates a response to parse from DescribePluginTemplates response
func CreateDescribePluginTemplatesResponse() (response *DescribePluginTemplatesResponse) {
	response = &DescribePluginTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
