package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetStorage invokes the cloud_siem.SetStorage API synchronously
func (client *Client) SetStorage(request *SetStorageRequest) (response *SetStorageResponse, err error) {
	response = CreateSetStorageResponse()
	err = client.DoAction(request, response)
	return
}

// SetStorageWithChan invokes the cloud_siem.SetStorage API asynchronously
func (client *Client) SetStorageWithChan(request *SetStorageRequest) (<-chan *SetStorageResponse, <-chan error) {
	responseChan := make(chan *SetStorageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetStorage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetStorageWithCallback invokes the cloud_siem.SetStorage API asynchronously
func (client *Client) SetStorageWithCallback(request *SetStorageRequest, callback func(response *SetStorageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetStorageResponse
		var err error
		defer close(result)
		response, err = client.SetStorage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetStorageRequest is the request struct for api SetStorage
type SetStorageRequest struct {
	*requests.RpcRequest
	Ttl    requests.Integer `position:"Body" name:"Ttl"`
	Region string           `position:"Body" name:"Region"`
}

// SetStorageResponse is the response struct for api SetStorage
type SetStorageResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetStorageRequest creates a request to invoke SetStorage API
func CreateSetStorageRequest() (request *SetStorageRequest) {
	request = &SetStorageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "SetStorage", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetStorageResponse creates a response to parse from SetStorage response
func CreateSetStorageResponse() (response *SetStorageResponse) {
	response = &SetStorageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
