package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDelivery invokes the cloud_siem.ListDelivery API synchronously
func (client *Client) ListDelivery(request *ListDeliveryRequest) (response *ListDeliveryResponse, err error) {
	response = CreateListDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeliveryWithChan invokes the cloud_siem.ListDelivery API asynchronously
func (client *Client) ListDeliveryWithChan(request *ListDeliveryRequest) (<-chan *ListDeliveryResponse, <-chan error) {
	responseChan := make(chan *ListDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeliveryWithCallback invokes the cloud_siem.ListDelivery API asynchronously
func (client *Client) ListDeliveryWithCallback(request *ListDeliveryRequest, callback func(response *ListDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeliveryResponse
		var err error
		defer close(result)
		response, err = client.ListDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeliveryRequest is the request struct for api ListDelivery
type ListDeliveryRequest struct {
	*requests.RpcRequest
}

// ListDeliveryResponse is the response struct for api ListDelivery
type ListDeliveryResponse struct {
	*responses.BaseResponse
}

// CreateListDeliveryRequest creates a request to invoke ListDelivery API
func CreateListDeliveryRequest() (request *ListDeliveryRequest) {
	request = &ListDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "ListDelivery", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDeliveryResponse creates a response to parse from ListDelivery response
func CreateListDeliveryResponse() (response *ListDeliveryResponse) {
	response = &ListDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
