package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAlertSceneByEvent invokes the cloud_siem.DescribeAlertSceneByEvent API synchronously
func (client *Client) DescribeAlertSceneByEvent(request *DescribeAlertSceneByEventRequest) (response *DescribeAlertSceneByEventResponse, err error) {
	response = CreateDescribeAlertSceneByEventResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAlertSceneByEventWithChan invokes the cloud_siem.DescribeAlertSceneByEvent API asynchronously
func (client *Client) DescribeAlertSceneByEventWithChan(request *DescribeAlertSceneByEventRequest) (<-chan *DescribeAlertSceneByEventResponse, <-chan error) {
	responseChan := make(chan *DescribeAlertSceneByEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAlertSceneByEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAlertSceneByEventWithCallback invokes the cloud_siem.DescribeAlertSceneByEvent API asynchronously
func (client *Client) DescribeAlertSceneByEventWithCallback(request *DescribeAlertSceneByEventRequest, callback func(response *DescribeAlertSceneByEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAlertSceneByEventResponse
		var err error
		defer close(result)
		response, err = client.DescribeAlertSceneByEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAlertSceneByEventRequest is the request struct for api DescribeAlertSceneByEvent
type DescribeAlertSceneByEventRequest struct {
	*requests.RpcRequest
	IncidentUuid string `position:"Body" name:"IncidentUuid"`
}

// DescribeAlertSceneByEventResponse is the response struct for api DescribeAlertSceneByEvent
type DescribeAlertSceneByEventResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeAlertSceneByEventRequest creates a request to invoke DescribeAlertSceneByEvent API
func CreateDescribeAlertSceneByEventRequest() (request *DescribeAlertSceneByEventRequest) {
	request = &DescribeAlertSceneByEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeAlertSceneByEvent", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAlertSceneByEventResponse creates a response to parse from DescribeAlertSceneByEvent response
func CreateDescribeAlertSceneByEventResponse() (response *DescribeAlertSceneByEventResponse) {
	response = &DescribeAlertSceneByEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
