package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOSSStorage invokes the clickhouse.DescribeOSSStorage API synchronously
func (client *Client) DescribeOSSStorage(request *DescribeOSSStorageRequest) (response *DescribeOSSStorageResponse, err error) {
	response = CreateDescribeOSSStorageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOSSStorageWithChan invokes the clickhouse.DescribeOSSStorage API asynchronously
func (client *Client) DescribeOSSStorageWithChan(request *DescribeOSSStorageRequest) (<-chan *DescribeOSSStorageResponse, <-chan error) {
	responseChan := make(chan *DescribeOSSStorageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOSSStorage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOSSStorageWithCallback invokes the clickhouse.DescribeOSSStorage API asynchronously
func (client *Client) DescribeOSSStorageWithCallback(request *DescribeOSSStorageRequest, callback func(response *DescribeOSSStorageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOSSStorageResponse
		var err error
		defer close(result)
		response, err = client.DescribeOSSStorage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOSSStorageRequest is the request struct for api DescribeOSSStorage
type DescribeOSSStorageRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeOSSStorageResponse is the response struct for api DescribeOSSStorage
type DescribeOSSStorageResponse struct {
	*responses.BaseResponse
	Policy       string `json:"Policy" xml:"Policy"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	State        string `json:"State" xml:"State"`
	ColdStorage  bool   `json:"ColdStorage" xml:"ColdStorage"`
	StorageUsage string `json:"StorageUsage" xml:"StorageUsage"`
}

// CreateDescribeOSSStorageRequest creates a request to invoke DescribeOSSStorage API
func CreateDescribeOSSStorageRequest() (request *DescribeOSSStorageRequest) {
	request = &DescribeOSSStorageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeOSSStorage", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOSSStorageResponse creates a response to parse from DescribeOSSStorage response
func CreateDescribeOSSStorageResponse() (response *DescribeOSSStorageResponse) {
	response = &DescribeOSSStorageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
