package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSQLAccount invokes the clickhouse.CreateSQLAccount API synchronously
func (client *Client) CreateSQLAccount(request *CreateSQLAccountRequest) (response *CreateSQLAccountResponse, err error) {
	response = CreateCreateSQLAccountResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSQLAccountWithChan invokes the clickhouse.CreateSQLAccount API asynchronously
func (client *Client) CreateSQLAccountWithChan(request *CreateSQLAccountRequest) (<-chan *CreateSQLAccountResponse, <-chan error) {
	responseChan := make(chan *CreateSQLAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSQLAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSQLAccountWithCallback invokes the clickhouse.CreateSQLAccount API asynchronously
func (client *Client) CreateSQLAccountWithCallback(request *CreateSQLAccountRequest, callback func(response *CreateSQLAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSQLAccountResponse
		var err error
		defer close(result)
		response, err = client.CreateSQLAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSQLAccountRequest is the request struct for api CreateSQLAccount
type CreateSQLAccountRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AccountType          string           `position:"Query" name:"AccountType"`
	AccountDescription   string           `position:"Query" name:"AccountDescription"`
	AccountName          string           `position:"Query" name:"AccountName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	AccountPassword      string           `position:"Query" name:"AccountPassword"`
}

// CreateSQLAccountResponse is the response struct for api CreateSQLAccount
type CreateSQLAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateSQLAccountRequest creates a request to invoke CreateSQLAccount API
func CreateCreateSQLAccountRequest() (request *CreateSQLAccountRequest) {
	request = &CreateSQLAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "CreateSQLAccount", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSQLAccountResponse creates a response to parse from CreateSQLAccount response
func CreateCreateSQLAccountResponse() (response *CreateSQLAccountResponse) {
	response = &CreateSQLAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
