package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopCdrsMonitor invokes the cdrs.StopCdrsMonitor API synchronously
func (client *Client) StopCdrsMonitor(request *StopCdrsMonitorRequest) (response *StopCdrsMonitorResponse, err error) {
	response = CreateStopCdrsMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// StopCdrsMonitorWithChan invokes the cdrs.StopCdrsMonitor API asynchronously
func (client *Client) StopCdrsMonitorWithChan(request *StopCdrsMonitorRequest) (<-chan *StopCdrsMonitorResponse, <-chan error) {
	responseChan := make(chan *StopCdrsMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopCdrsMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopCdrsMonitorWithCallback invokes the cdrs.StopCdrsMonitor API asynchronously
func (client *Client) StopCdrsMonitorWithCallback(request *StopCdrsMonitorRequest, callback func(response *StopCdrsMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopCdrsMonitorResponse
		var err error
		defer close(result)
		response, err = client.StopCdrsMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopCdrsMonitorRequest is the request struct for api StopCdrsMonitor
type StopCdrsMonitorRequest struct {
	*requests.RpcRequest
	CorpId          string `position:"Body" name:"CorpId"`
	BizId           string `position:"Body" name:"BizId"`
	AlgorithmVendor string `position:"Body" name:"AlgorithmVendor"`
	TaskId          string `position:"Body" name:"TaskId"`
}

// StopCdrsMonitorResponse is the response struct for api StopCdrsMonitor
type StopCdrsMonitorResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopCdrsMonitorRequest creates a request to invoke StopCdrsMonitor API
func CreateStopCdrsMonitorRequest() (request *StopCdrsMonitorRequest) {
	request = &StopCdrsMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "StopCdrsMonitor", "", "")
	request.Method = requests.POST
	return
}

// CreateStopCdrsMonitorResponse creates a response to parse from StopCdrsMonitor response
func CreateStopCdrsMonitorResponse() (response *StopCdrsMonitorResponse) {
	response = &StopCdrsMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
