package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRealTimeLogLogstore invokes the cdn.DeleteRealTimeLogLogstore API synchronously
func (client *Client) DeleteRealTimeLogLogstore(request *DeleteRealTimeLogLogstoreRequest) (response *DeleteRealTimeLogLogstoreResponse, err error) {
	response = CreateDeleteRealTimeLogLogstoreResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRealTimeLogLogstoreWithChan invokes the cdn.DeleteRealTimeLogLogstore API asynchronously
func (client *Client) DeleteRealTimeLogLogstoreWithChan(request *DeleteRealTimeLogLogstoreRequest) (<-chan *DeleteRealTimeLogLogstoreResponse, <-chan error) {
	responseChan := make(chan *DeleteRealTimeLogLogstoreResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRealTimeLogLogstore(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRealTimeLogLogstoreWithCallback invokes the cdn.DeleteRealTimeLogLogstore API asynchronously
func (client *Client) DeleteRealTimeLogLogstoreWithCallback(request *DeleteRealTimeLogLogstoreRequest, callback func(response *DeleteRealTimeLogLogstoreResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRealTimeLogLogstoreResponse
		var err error
		defer close(result)
		response, err = client.DeleteRealTimeLogLogstore(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRealTimeLogLogstoreRequest is the request struct for api DeleteRealTimeLogLogstore
type DeleteRealTimeLogLogstoreRequest struct {
	*requests.RpcRequest
	Project  string `position:"Query" name:"Project"`
	Region   string `position:"Query" name:"Region"`
	Logstore string `position:"Query" name:"Logstore"`
}

// DeleteRealTimeLogLogstoreResponse is the response struct for api DeleteRealTimeLogLogstore
type DeleteRealTimeLogLogstoreResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteRealTimeLogLogstoreRequest creates a request to invoke DeleteRealTimeLogLogstore API
func CreateDeleteRealTimeLogLogstoreRequest() (request *DeleteRealTimeLogLogstoreRequest) {
	request = &DeleteRealTimeLogLogstoreRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DeleteRealTimeLogLogstore", "", "")
	request.Method = requests.GET
	return
}

// CreateDeleteRealTimeLogLogstoreResponse creates a response to parse from DeleteRealTimeLogLogstore response
func CreateDeleteRealTimeLogLogstoreResponse() (response *DeleteRealTimeLogLogstoreResponse) {
	response = &DeleteRealTimeLogLogstoreResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
