package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveUsers invokes the ccc.RemoveUsers API synchronously
func (client *Client) RemoveUsers(request *RemoveUsersRequest) (response *RemoveUsersResponse, err error) {
	response = CreateRemoveUsersResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveUsersWithChan invokes the ccc.RemoveUsers API asynchronously
func (client *Client) RemoveUsersWithChan(request *RemoveUsersRequest) (<-chan *RemoveUsersResponse, <-chan error) {
	responseChan := make(chan *RemoveUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveUsersWithCallback invokes the ccc.RemoveUsers API asynchronously
func (client *Client) RemoveUsersWithCallback(request *RemoveUsersRequest, callback func(response *RemoveUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveUsersResponse
		var err error
		defer close(result)
		response, err = client.RemoveUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveUsersRequest is the request struct for api RemoveUsers
type RemoveUsersRequest struct {
	*requests.RpcRequest
	UserIdList string           `position:"Query" name:"UserIdList"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	Force      requests.Boolean `position:"Query" name:"Force"`
}

// RemoveUsersResponse is the response struct for api RemoveUsers
type RemoveUsersResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
}

// CreateRemoveUsersRequest creates a request to invoke RemoveUsers API
func CreateRemoveUsersRequest() (request *RemoveUsersRequest) {
	request = &RemoveUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "RemoveUsers", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveUsersResponse creates a response to parse from RemoveUsers response
func CreateRemoveUsersResponse() (response *RemoveUsersResponse) {
	response = &RemoveUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
