package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCustomCallTagging invokes the ccc.ModifyCustomCallTagging API synchronously
func (client *Client) ModifyCustomCallTagging(request *ModifyCustomCallTaggingRequest) (response *ModifyCustomCallTaggingResponse, err error) {
	response = CreateModifyCustomCallTaggingResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCustomCallTaggingWithChan invokes the ccc.ModifyCustomCallTagging API asynchronously
func (client *Client) ModifyCustomCallTaggingWithChan(request *ModifyCustomCallTaggingRequest) (<-chan *ModifyCustomCallTaggingResponse, <-chan error) {
	responseChan := make(chan *ModifyCustomCallTaggingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCustomCallTagging(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCustomCallTaggingWithCallback invokes the ccc.ModifyCustomCallTagging API asynchronously
func (client *Client) ModifyCustomCallTaggingWithCallback(request *ModifyCustomCallTaggingRequest, callback func(response *ModifyCustomCallTaggingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCustomCallTaggingResponse
		var err error
		defer close(result)
		response, err = client.ModifyCustomCallTagging(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCustomCallTaggingRequest is the request struct for api ModifyCustomCallTagging
type ModifyCustomCallTaggingRequest struct {
	*requests.RpcRequest
	Description     string `position:"Query" name:"Description"`
	Number          string `position:"Query" name:"Number"`
	InstanceId      string `position:"Query" name:"InstanceId"`
	CallTagNameList string `position:"Query" name:"CallTagNameList"`
}

// ModifyCustomCallTaggingResponse is the response struct for api ModifyCustomCallTagging
type ModifyCustomCallTaggingResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
}

// CreateModifyCustomCallTaggingRequest creates a request to invoke ModifyCustomCallTagging API
func CreateModifyCustomCallTaggingRequest() (request *ModifyCustomCallTaggingRequest) {
	request = &ModifyCustomCallTaggingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ModifyCustomCallTagging", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCustomCallTaggingResponse creates a response to parse from ModifyCustomCallTagging response
func CreateModifyCustomCallTaggingResponse() (response *ModifyCustomCallTaggingResponse) {
	response = &ModifyCustomCallTaggingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
