package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConversationDetail invokes the ccc.GetConversationDetail API synchronously
func (client *Client) GetConversationDetail(request *GetConversationDetailRequest) (response *GetConversationDetailResponse, err error) {
	response = CreateGetConversationDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetConversationDetailWithChan invokes the ccc.GetConversationDetail API asynchronously
func (client *Client) GetConversationDetailWithChan(request *GetConversationDetailRequest) (<-chan *GetConversationDetailResponse, <-chan error) {
	responseChan := make(chan *GetConversationDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConversationDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConversationDetailWithCallback invokes the ccc.GetConversationDetail API asynchronously
func (client *Client) GetConversationDetailWithCallback(request *GetConversationDetailRequest, callback func(response *GetConversationDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConversationDetailResponse
		var err error
		defer close(result)
		response, err = client.GetConversationDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConversationDetailRequest is the request struct for api GetConversationDetail
type GetConversationDetailRequest struct {
	*requests.RpcRequest
	ContactId  string `position:"Query" name:"ContactId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetConversationDetailResponse is the response struct for api GetConversationDetail
type GetConversationDetailResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Phrases        []Phrase `json:"Phrases" xml:"Phrases"`
}

// CreateGetConversationDetailRequest creates a request to invoke GetConversationDetail API
func CreateGetConversationDetailRequest() (request *GetConversationDetailRequest) {
	request = &GetConversationDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetConversationDetail", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetConversationDetailResponse creates a response to parse from GetConversationDetail response
func CreateGetConversationDetailResponse() (response *GetConversationDetailResponse) {
	response = &GetConversationDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
