package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddUsersToSkillGroup invokes the ccc.AddUsersToSkillGroup API synchronously
func (client *Client) AddUsersToSkillGroup(request *AddUsersToSkillGroupRequest) (response *AddUsersToSkillGroupResponse, err error) {
	response = CreateAddUsersToSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddUsersToSkillGroupWithChan invokes the ccc.AddUsersToSkillGroup API asynchronously
func (client *Client) AddUsersToSkillGroupWithChan(request *AddUsersToSkillGroupRequest) (<-chan *AddUsersToSkillGroupResponse, <-chan error) {
	responseChan := make(chan *AddUsersToSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddUsersToSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddUsersToSkillGroupWithCallback invokes the ccc.AddUsersToSkillGroup API asynchronously
func (client *Client) AddUsersToSkillGroupWithCallback(request *AddUsersToSkillGroupRequest, callback func(response *AddUsersToSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddUsersToSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.AddUsersToSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddUsersToSkillGroupRequest is the request struct for api AddUsersToSkillGroup
type AddUsersToSkillGroupRequest struct {
	*requests.RpcRequest
	InstanceId         string `position:"Query" name:"InstanceId"`
	UserSkillLevelList string `position:"Query" name:"UserSkillLevelList"`
	SkillGroupId       string `position:"Query" name:"SkillGroupId"`
}

// AddUsersToSkillGroupResponse is the response struct for api AddUsersToSkillGroup
type AddUsersToSkillGroupResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateAddUsersToSkillGroupRequest creates a request to invoke AddUsersToSkillGroup API
func CreateAddUsersToSkillGroupRequest() (request *AddUsersToSkillGroupRequest) {
	request = &AddUsersToSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "AddUsersToSkillGroup", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddUsersToSkillGroupResponse creates a response to parse from AddUsersToSkillGroup response
func CreateAddUsersToSkillGroupResponse() (response *AddUsersToSkillGroupResponse) {
	response = &AddUsersToSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
