package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitDiagnoseTaskForSingleCard invokes the cc5g.SubmitDiagnoseTaskForSingleCard API synchronously
func (client *Client) SubmitDiagnoseTaskForSingleCard(request *SubmitDiagnoseTaskForSingleCardRequest) (response *SubmitDiagnoseTaskForSingleCardResponse, err error) {
	response = CreateSubmitDiagnoseTaskForSingleCardResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitDiagnoseTaskForSingleCardWithChan invokes the cc5g.SubmitDiagnoseTaskForSingleCard API asynchronously
func (client *Client) SubmitDiagnoseTaskForSingleCardWithChan(request *SubmitDiagnoseTaskForSingleCardRequest) (<-chan *SubmitDiagnoseTaskForSingleCardResponse, <-chan error) {
	responseChan := make(chan *SubmitDiagnoseTaskForSingleCardResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitDiagnoseTaskForSingleCard(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitDiagnoseTaskForSingleCardWithCallback invokes the cc5g.SubmitDiagnoseTaskForSingleCard API asynchronously
func (client *Client) SubmitDiagnoseTaskForSingleCardWithCallback(request *SubmitDiagnoseTaskForSingleCardRequest, callback func(response *SubmitDiagnoseTaskForSingleCardResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitDiagnoseTaskForSingleCardResponse
		var err error
		defer close(result)
		response, err = client.SubmitDiagnoseTaskForSingleCard(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitDiagnoseTaskForSingleCardRequest is the request struct for api SubmitDiagnoseTaskForSingleCard
type SubmitDiagnoseTaskForSingleCardRequest struct {
	*requests.RpcRequest
	Destination              string           `position:"Query" name:"Destination"`
	Source                   string           `position:"Query" name:"Source"`
	ResourceUid              requests.Integer `position:"Query" name:"ResourceUid"`
	EndTime                  requests.Integer `position:"Query" name:"EndTime"`
	BeginTime                requests.Integer `position:"Query" name:"BeginTime"`
	RegionNo                 string           `position:"Query" name:"RegionNo"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
}

// SubmitDiagnoseTaskForSingleCardResponse is the response struct for api SubmitDiagnoseTaskForSingleCard
type SubmitDiagnoseTaskForSingleCardResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	DiagnoseTaskId string `json:"DiagnoseTaskId" xml:"DiagnoseTaskId"`
}

// CreateSubmitDiagnoseTaskForSingleCardRequest creates a request to invoke SubmitDiagnoseTaskForSingleCard API
func CreateSubmitDiagnoseTaskForSingleCardRequest() (request *SubmitDiagnoseTaskForSingleCardRequest) {
	request = &SubmitDiagnoseTaskForSingleCardRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "SubmitDiagnoseTaskForSingleCard", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitDiagnoseTaskForSingleCardResponse creates a response to parse from SubmitDiagnoseTaskForSingleCard response
func CreateSubmitDiagnoseTaskForSingleCardResponse() (response *SubmitDiagnoseTaskForSingleCardResponse) {
	response = &SubmitDiagnoseTaskForSingleCardResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
