package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataPackages invokes the cc5g.ListDataPackages API synchronously
func (client *Client) ListDataPackages(request *ListDataPackagesRequest) (response *ListDataPackagesResponse, err error) {
	response = CreateListDataPackagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataPackagesWithChan invokes the cc5g.ListDataPackages API asynchronously
func (client *Client) ListDataPackagesWithChan(request *ListDataPackagesRequest) (<-chan *ListDataPackagesResponse, <-chan error) {
	responseChan := make(chan *ListDataPackagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataPackages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataPackagesWithCallback invokes the cc5g.ListDataPackages API asynchronously
func (client *Client) ListDataPackagesWithCallback(request *ListDataPackagesRequest, callback func(response *ListDataPackagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataPackagesResponse
		var err error
		defer close(result)
		response, err = client.ListDataPackages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataPackagesRequest is the request struct for api ListDataPackages
type ListDataPackagesRequest struct {
	*requests.RpcRequest
	NextToken                string           `position:"Query" name:"NextToken"`
	DataPackageIds           *[]string        `position:"Query" name:"DataPackageIds"  type:"Repeated"`
	Names                    *[]string        `position:"Query" name:"Names"  type:"Repeated"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
	MaxResults               requests.Integer `position:"Query" name:"MaxResults"`
	Statuses                 *[]string        `position:"Query" name:"Statuses"  type:"Repeated"`
}

// ListDataPackagesResponse is the response struct for api ListDataPackages
type ListDataPackagesResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	NextToken    string        `json:"NextToken" xml:"NextToken"`
	MaxResults   string        `json:"MaxResults" xml:"MaxResults"`
	TotalCount   string        `json:"TotalCount" xml:"TotalCount"`
	DataPackages []DataPackage `json:"DataPackages" xml:"DataPackages"`
}

// CreateListDataPackagesRequest creates a request to invoke ListDataPackages API
func CreateListDataPackagesRequest() (request *ListDataPackagesRequest) {
	request = &ListDataPackagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "ListDataPackages", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDataPackagesResponse creates a response to parse from ListDataPackages response
func CreateListDataPackagesResponse() (response *ListDataPackagesResponse) {
	response = &ListDataPackagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
