package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGroupDnsAuthorizationRule invokes the cc5g.AddGroupDnsAuthorizationRule API synchronously
func (client *Client) AddGroupDnsAuthorizationRule(request *AddGroupDnsAuthorizationRuleRequest) (response *AddGroupDnsAuthorizationRuleResponse, err error) {
	response = CreateAddGroupDnsAuthorizationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// AddGroupDnsAuthorizationRuleWithChan invokes the cc5g.AddGroupDnsAuthorizationRule API asynchronously
func (client *Client) AddGroupDnsAuthorizationRuleWithChan(request *AddGroupDnsAuthorizationRuleRequest) (<-chan *AddGroupDnsAuthorizationRuleResponse, <-chan error) {
	responseChan := make(chan *AddGroupDnsAuthorizationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGroupDnsAuthorizationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGroupDnsAuthorizationRuleWithCallback invokes the cc5g.AddGroupDnsAuthorizationRule API asynchronously
func (client *Client) AddGroupDnsAuthorizationRuleWithCallback(request *AddGroupDnsAuthorizationRuleRequest, callback func(response *AddGroupDnsAuthorizationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGroupDnsAuthorizationRuleResponse
		var err error
		defer close(result)
		response, err = client.AddGroupDnsAuthorizationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGroupDnsAuthorizationRuleRequest is the request struct for api AddGroupDnsAuthorizationRule
type AddGroupDnsAuthorizationRuleRequest struct {
	*requests.RpcRequest
	WirelessCloudConnectorGroupId string           `position:"Query" name:"WirelessCloudConnectorGroupId"`
	ClientToken                   string           `position:"Query" name:"ClientToken"`
	Description                   string           `position:"Query" name:"Description"`
	DryRun                        requests.Boolean `position:"Query" name:"DryRun"`
	SourceDNSIp                   string           `position:"Query" name:"SourceDNSIp"`
	DestinationIp                 string           `position:"Query" name:"DestinationIp"`
	Name                          string           `position:"Query" name:"Name"`
}

// AddGroupDnsAuthorizationRuleResponse is the response struct for api AddGroupDnsAuthorizationRule
type AddGroupDnsAuthorizationRuleResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	AuthorizationRuleId string `json:"AuthorizationRuleId" xml:"AuthorizationRuleId"`
}

// CreateAddGroupDnsAuthorizationRuleRequest creates a request to invoke AddGroupDnsAuthorizationRule API
func CreateAddGroupDnsAuthorizationRuleRequest() (request *AddGroupDnsAuthorizationRuleRequest) {
	request = &AddGroupDnsAuthorizationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "AddGroupDnsAuthorizationRule", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddGroupDnsAuthorizationRuleResponse creates a response to parse from AddGroupDnsAuthorizationRule response
func CreateAddGroupDnsAuthorizationRuleResponse() (response *AddGroupDnsAuthorizationRuleResponse) {
	response = &AddGroupDnsAuthorizationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
