package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTransitRouterMulticastDomain invokes the cbn.DeleteTransitRouterMulticastDomain API synchronously
func (client *Client) DeleteTransitRouterMulticastDomain(request *DeleteTransitRouterMulticastDomainRequest) (response *DeleteTransitRouterMulticastDomainResponse, err error) {
	response = CreateDeleteTransitRouterMulticastDomainResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTransitRouterMulticastDomainWithChan invokes the cbn.DeleteTransitRouterMulticastDomain API asynchronously
func (client *Client) DeleteTransitRouterMulticastDomainWithChan(request *DeleteTransitRouterMulticastDomainRequest) (<-chan *DeleteTransitRouterMulticastDomainResponse, <-chan error) {
	responseChan := make(chan *DeleteTransitRouterMulticastDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTransitRouterMulticastDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTransitRouterMulticastDomainWithCallback invokes the cbn.DeleteTransitRouterMulticastDomain API asynchronously
func (client *Client) DeleteTransitRouterMulticastDomainWithCallback(request *DeleteTransitRouterMulticastDomainRequest, callback func(response *DeleteTransitRouterMulticastDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTransitRouterMulticastDomainResponse
		var err error
		defer close(result)
		response, err = client.DeleteTransitRouterMulticastDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTransitRouterMulticastDomainRequest is the request struct for api DeleteTransitRouterMulticastDomain
type DeleteTransitRouterMulticastDomainRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                    string           `position:"Query" name:"ClientToken"`
	TransitRouterMulticastDomainId string           `position:"Query" name:"TransitRouterMulticastDomainId"`
	DryRun                         requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount           string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                   string           `position:"Query" name:"OwnerAccount"`
	OwnerId                        requests.Integer `position:"Query" name:"OwnerId"`
	Version                        string           `position:"Query" name:"Version"`
}

// DeleteTransitRouterMulticastDomainResponse is the response struct for api DeleteTransitRouterMulticastDomain
type DeleteTransitRouterMulticastDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTransitRouterMulticastDomainRequest creates a request to invoke DeleteTransitRouterMulticastDomain API
func CreateDeleteTransitRouterMulticastDomainRequest() (request *DeleteTransitRouterMulticastDomainRequest) {
	request = &DeleteTransitRouterMulticastDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DeleteTransitRouterMulticastDomain", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTransitRouterMulticastDomainResponse creates a response to parse from DeleteTransitRouterMulticastDomain response
func CreateDeleteTransitRouterMulticastDomainResponse() (response *DeleteTransitRouterMulticastDomainResponse) {
	response = &DeleteTransitRouterMulticastDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
