package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIpWhitelistGroups invokes the cassandra.DescribeIpWhitelistGroups API synchronously
func (client *Client) DescribeIpWhitelistGroups(request *DescribeIpWhitelistGroupsRequest) (response *DescribeIpWhitelistGroupsResponse, err error) {
	response = CreateDescribeIpWhitelistGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIpWhitelistGroupsWithChan invokes the cassandra.DescribeIpWhitelistGroups API asynchronously
func (client *Client) DescribeIpWhitelistGroupsWithChan(request *DescribeIpWhitelistGroupsRequest) (<-chan *DescribeIpWhitelistGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeIpWhitelistGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIpWhitelistGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIpWhitelistGroupsWithCallback invokes the cassandra.DescribeIpWhitelistGroups API asynchronously
func (client *Client) DescribeIpWhitelistGroupsWithCallback(request *DescribeIpWhitelistGroupsRequest, callback func(response *DescribeIpWhitelistGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIpWhitelistGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeIpWhitelistGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIpWhitelistGroupsRequest is the request struct for api DescribeIpWhitelistGroups
type DescribeIpWhitelistGroupsRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeIpWhitelistGroupsResponse is the response struct for api DescribeIpWhitelistGroups
type DescribeIpWhitelistGroupsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Groups    Groups `json:"Groups" xml:"Groups"`
}

// CreateDescribeIpWhitelistGroupsRequest creates a request to invoke DescribeIpWhitelistGroups API
func CreateDescribeIpWhitelistGroupsRequest() (request *DescribeIpWhitelistGroupsRequest) {
	request = &DescribeIpWhitelistGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "DescribeIpWhitelistGroups", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIpWhitelistGroupsResponse creates a response to parse from DescribeIpWhitelistGroups response
func CreateDescribeIpWhitelistGroupsResponse() (response *DescribeIpWhitelistGroupsResponse) {
	response = &DescribeIpWhitelistGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
