package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackup invokes the cassandra.DescribeBackup API synchronously
func (client *Client) DescribeBackup(request *DescribeBackupRequest) (response *DescribeBackupResponse, err error) {
	response = CreateDescribeBackupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackupWithChan invokes the cassandra.DescribeBackup API asynchronously
func (client *Client) DescribeBackupWithChan(request *DescribeBackupRequest) (<-chan *DescribeBackupResponse, <-chan error) {
	responseChan := make(chan *DescribeBackupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackupWithCallback invokes the cassandra.DescribeBackup API asynchronously
func (client *Client) DescribeBackupWithCallback(request *DescribeBackupRequest, callback func(response *DescribeBackupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackupResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackupRequest is the request struct for api DescribeBackup
type DescribeBackupRequest struct {
	*requests.RpcRequest
	BackupType   string `position:"Query" name:"BackupType"`
	BackupId     string `position:"Query" name:"BackupId"`
	DataCenterId string `position:"Query" name:"DataCenterId"`
	ClusterId    string `position:"Query" name:"ClusterId"`
}

// DescribeBackupResponse is the response struct for api DescribeBackup
type DescribeBackupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Backup    Backup `json:"Backup" xml:"Backup"`
}

// CreateDescribeBackupRequest creates a request to invoke DescribeBackup API
func CreateDescribeBackupRequest() (request *DescribeBackupRequest) {
	request = &DescribeBackupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "DescribeBackup", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBackupResponse creates a response to parse from DescribeBackup response
func CreateDescribeBackupResponse() (response *DescribeBackupResponse) {
	response = &DescribeBackupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
