package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceAmortizedCostByAmortizationPeriod invokes the bssopenapi.DescribeInstanceAmortizedCostByAmortizationPeriod API synchronously
func (client *Client) DescribeInstanceAmortizedCostByAmortizationPeriod(request *DescribeInstanceAmortizedCostByAmortizationPeriodRequest) (response *DescribeInstanceAmortizedCostByAmortizationPeriodResponse, err error) {
	response = CreateDescribeInstanceAmortizedCostByAmortizationPeriodResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceAmortizedCostByAmortizationPeriodWithChan invokes the bssopenapi.DescribeInstanceAmortizedCostByAmortizationPeriod API asynchronously
func (client *Client) DescribeInstanceAmortizedCostByAmortizationPeriodWithChan(request *DescribeInstanceAmortizedCostByAmortizationPeriodRequest) (<-chan *DescribeInstanceAmortizedCostByAmortizationPeriodResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceAmortizedCostByAmortizationPeriodResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceAmortizedCostByAmortizationPeriod(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceAmortizedCostByAmortizationPeriodWithCallback invokes the bssopenapi.DescribeInstanceAmortizedCostByAmortizationPeriod API asynchronously
func (client *Client) DescribeInstanceAmortizedCostByAmortizationPeriodWithCallback(request *DescribeInstanceAmortizedCostByAmortizationPeriodRequest, callback func(response *DescribeInstanceAmortizedCostByAmortizationPeriodResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceAmortizedCostByAmortizationPeriodResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceAmortizedCostByAmortizationPeriod(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceAmortizedCostByAmortizationPeriodRequest is the request struct for api DescribeInstanceAmortizedCostByAmortizationPeriod
type DescribeInstanceAmortizedCostByAmortizationPeriodRequest struct {
	*requests.RpcRequest
	ProductDetail       string           `position:"Body" name:"ProductDetail"`
	ProductCode         string           `position:"Body" name:"ProductCode"`
	BillOwnerIdList     *[]string        `position:"Body" name:"BillOwnerIdList"  type:"Repeated"`
	SubscriptionType    string           `position:"Body" name:"SubscriptionType"`
	BillingCycle        string           `position:"Body" name:"BillingCycle"`
	CostUnitCode        string           `position:"Body" name:"CostUnitCode"`
	ConsumePeriodFilter *[]string        `position:"Body" name:"ConsumePeriodFilter"  type:"Repeated"`
	NextToken           string           `position:"Body" name:"NextToken"`
	BillUserIdList      *[]string        `position:"Body" name:"BillUserIdList"  type:"Repeated"`
	InstanceIdList      *[]string        `position:"Body" name:"InstanceIdList"  type:"Repeated"`
	MaxResults          requests.Integer `position:"Body" name:"MaxResults"`
}

// DescribeInstanceAmortizedCostByAmortizationPeriodResponse is the response struct for api DescribeInstanceAmortizedCostByAmortizationPeriod
type DescribeInstanceAmortizedCostByAmortizationPeriodResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeInstanceAmortizedCostByAmortizationPeriodRequest creates a request to invoke DescribeInstanceAmortizedCostByAmortizationPeriod API
func CreateDescribeInstanceAmortizedCostByAmortizationPeriodRequest() (request *DescribeInstanceAmortizedCostByAmortizationPeriodRequest) {
	request = &DescribeInstanceAmortizedCostByAmortizationPeriodRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "DescribeInstanceAmortizedCostByAmortizationPeriod", "bssopenapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceAmortizedCostByAmortizationPeriodResponse creates a response to parse from DescribeInstanceAmortizedCostByAmortizationPeriod response
func CreateDescribeInstanceAmortizedCostByAmortizationPeriodResponse() (response *DescribeInstanceAmortizedCostByAmortizationPeriodResponse) {
	response = &DescribeInstanceAmortizedCostByAmortizationPeriodResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
