package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryIpSegmentByNodeType invokes the biz_ipdb.QueryIpSegmentByNodeType API synchronously
func (client *Client) QueryIpSegmentByNodeType(request *QueryIpSegmentByNodeTypeRequest) (response *QueryIpSegmentByNodeTypeResponse, err error) {
	response = CreateQueryIpSegmentByNodeTypeResponse()
	err = client.DoAction(request, response)
	return
}

// QueryIpSegmentByNodeTypeWithChan invokes the biz_ipdb.QueryIpSegmentByNodeType API asynchronously
func (client *Client) QueryIpSegmentByNodeTypeWithChan(request *QueryIpSegmentByNodeTypeRequest) (<-chan *QueryIpSegmentByNodeTypeResponse, <-chan error) {
	responseChan := make(chan *QueryIpSegmentByNodeTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryIpSegmentByNodeType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryIpSegmentByNodeTypeWithCallback invokes the biz_ipdb.QueryIpSegmentByNodeType API asynchronously
func (client *Client) QueryIpSegmentByNodeTypeWithCallback(request *QueryIpSegmentByNodeTypeRequest, callback func(response *QueryIpSegmentByNodeTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryIpSegmentByNodeTypeResponse
		var err error
		defer close(result)
		response, err = client.QueryIpSegmentByNodeType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryIpSegmentByNodeTypeRequest is the request struct for api QueryIpSegmentByNodeType
type QueryIpSegmentByNodeTypeRequest struct {
	*requests.RpcRequest
	NodeType     string `position:"Query" name:"NodeType"`
	PageNumber   string `position:"Query" name:"PageNumber"`
	NetworkScope string `position:"Query" name:"NetworkScope"`
	NodeName     string `position:"Query" name:"NodeName"`
	PageSize     string `position:"Query" name:"PageSize"`
	IpVersion    string `position:"Query" name:"IpVersion"`
	BizLine      string `position:"Query" name:"BizLine"`
}

// QueryIpSegmentByNodeTypeResponse is the response struct for api QueryIpSegmentByNodeType
type QueryIpSegmentByNodeTypeResponse struct {
	*responses.BaseResponse
	RequestId  string                               `json:"RequestId" xml:"RequestId"`
	PageNumber int                                  `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                                  `json:"PageSize" xml:"PageSize"`
	TotalCount int                                  `json:"TotalCount" xml:"TotalCount"`
	IpSegments IpSegmentsInQueryIpSegmentByNodeType `json:"IpSegments" xml:"IpSegments"`
}

// CreateQueryIpSegmentByNodeTypeRequest creates a request to invoke QueryIpSegmentByNodeType API
func CreateQueryIpSegmentByNodeTypeRequest() (request *QueryIpSegmentByNodeTypeRequest) {
	request = &QueryIpSegmentByNodeTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "QueryIpSegmentByNodeType", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryIpSegmentByNodeTypeResponse creates a response to parse from QueryIpSegmentByNodeType response
func CreateQueryIpSegmentByNodeTypeResponse() (response *QueryIpSegmentByNodeTypeResponse) {
	response = &QueryIpSegmentByNodeTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
