package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIpType invokes the biz_ipdb.CreateIpType API synchronously
func (client *Client) CreateIpType(request *CreateIpTypeRequest) (response *CreateIpTypeResponse, err error) {
	response = CreateCreateIpTypeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIpTypeWithChan invokes the biz_ipdb.CreateIpType API asynchronously
func (client *Client) CreateIpTypeWithChan(request *CreateIpTypeRequest) (<-chan *CreateIpTypeResponse, <-chan error) {
	responseChan := make(chan *CreateIpTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIpType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIpTypeWithCallback invokes the biz_ipdb.CreateIpType API asynchronously
func (client *Client) CreateIpTypeWithCallback(request *CreateIpTypeRequest, callback func(response *CreateIpTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIpTypeResponse
		var err error
		defer close(result)
		response, err = client.CreateIpType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIpTypeRequest is the request struct for api CreateIpType
type CreateIpTypeRequest struct {
	*requests.RpcRequest
	NetIpType   string           `position:"Query" name:"NetIpType"`
	NodeType    string           `position:"Query" name:"NodeType"`
	IpPublic    requests.Boolean `position:"Query" name:"IpPublic"`
	CheckPod    requests.Boolean `position:"Query" name:"CheckPod"`
	Description string           `position:"Query" name:"Description"`
	IpType      string           `position:"Query" name:"IpType"`
	SysOwner    string           `position:"Query" name:"SysOwner"`
	BizLine     string           `position:"Query" name:"BizLine"`
}

// CreateIpTypeResponse is the response struct for api CreateIpType
type CreateIpTypeResponse struct {
	*responses.BaseResponse
	Id        int64  `json:"Id" xml:"Id"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateIpTypeRequest creates a request to invoke CreateIpType API
func CreateCreateIpTypeRequest() (request *CreateIpTypeRequest) {
	request = &CreateIpTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "CreateIpType", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateIpTypeResponse creates a response to parse from CreateIpType response
func CreateCreateIpTypeResponse() (response *CreateIpTypeResponse) {
	response = &CreateIpTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
