package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIpSegment invokes the biz_ipdb.CreateIpSegment API synchronously
func (client *Client) CreateIpSegment(request *CreateIpSegmentRequest) (response *CreateIpSegmentResponse, err error) {
	response = CreateCreateIpSegmentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIpSegmentWithChan invokes the biz_ipdb.CreateIpSegment API asynchronously
func (client *Client) CreateIpSegmentWithChan(request *CreateIpSegmentRequest) (<-chan *CreateIpSegmentResponse, <-chan error) {
	responseChan := make(chan *CreateIpSegmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIpSegment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIpSegmentWithCallback invokes the biz_ipdb.CreateIpSegment API asynchronously
func (client *Client) CreateIpSegmentWithCallback(request *CreateIpSegmentRequest, callback func(response *CreateIpSegmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIpSegmentResponse
		var err error
		defer close(result)
		response, err = client.CreateIpSegment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIpSegmentRequest is the request struct for api CreateIpSegment
type CreateIpSegmentRequest struct {
	*requests.RpcRequest
	Cluster     string           `position:"Query" name:"Cluster"`
	Pod         string           `position:"Query" name:"Pod"`
	Description string           `position:"Query" name:"Description"`
	IpType      string           `position:"Query" name:"IpType"`
	House       string           `position:"Query" name:"House"`
	ThirdParty  requests.Boolean `position:"Query" name:"ThirdParty"`
	Vlan        string           `position:"Query" name:"Vlan"`
	LocationId  string           `position:"Query" name:"LocationId"`
	Force       requests.Boolean `position:"Query" name:"Force"`
	Id          requests.Integer `position:"Query" name:"Id"`
	Value       string           `position:"Query" name:"Value"`
	BizLine     string           `position:"Query" name:"BizLine"`
}

// CreateIpSegmentResponse is the response struct for api CreateIpSegment
type CreateIpSegmentResponse struct {
	*responses.BaseResponse
	Id        int64  `json:"Id" xml:"Id"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateIpSegmentRequest creates a request to invoke CreateIpSegment API
func CreateCreateIpSegmentRequest() (request *CreateIpSegmentRequest) {
	request = &CreateIpSegmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "CreateIpSegment", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateIpSegmentResponse creates a response to parse from CreateIpSegment response
func CreateCreateIpSegmentResponse() (response *CreateIpSegmentResponse) {
	response = &CreateIpSegmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
