package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricConsortiumDeletable invokes the baas.DescribeFabricConsortiumDeletable API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumdeletable.html
func (client *Client) DescribeFabricConsortiumDeletable(request *DescribeFabricConsortiumDeletableRequest) (response *DescribeFabricConsortiumDeletableResponse, err error) {
	response = CreateDescribeFabricConsortiumDeletableResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricConsortiumDeletableWithChan invokes the baas.DescribeFabricConsortiumDeletable API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumdeletable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumDeletableWithChan(request *DescribeFabricConsortiumDeletableRequest) (<-chan *DescribeFabricConsortiumDeletableResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricConsortiumDeletableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricConsortiumDeletable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricConsortiumDeletableWithCallback invokes the baas.DescribeFabricConsortiumDeletable API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiumdeletable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumDeletableWithCallback(request *DescribeFabricConsortiumDeletableRequest, callback func(response *DescribeFabricConsortiumDeletableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricConsortiumDeletableResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricConsortiumDeletable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricConsortiumDeletableRequest is the request struct for api DescribeFabricConsortiumDeletable
type DescribeFabricConsortiumDeletableRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Query" name:"ConsortiumId"`
}

// DescribeFabricConsortiumDeletableResponse is the response struct for api DescribeFabricConsortiumDeletable
type DescribeFabricConsortiumDeletableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeFabricConsortiumDeletableRequest creates a request to invoke DescribeFabricConsortiumDeletable API
func CreateDescribeFabricConsortiumDeletableRequest() (request *DescribeFabricConsortiumDeletableRequest) {
	request = &DescribeFabricConsortiumDeletableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricConsortiumDeletable", "baas", "openAPI")
	return
}

// CreateDescribeFabricConsortiumDeletableResponse creates a response to parse from DescribeFabricConsortiumDeletable response
func CreateDescribeFabricConsortiumDeletableResponse() (response *DescribeFabricConsortiumDeletableResponse) {
	response = &DescribeFabricConsortiumDeletableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
