package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendMeetingCommand invokes the aliyuncvc.SendMeetingCommand API synchronously
func (client *Client) SendMeetingCommand(request *SendMeetingCommandRequest) (response *SendMeetingCommandResponse, err error) {
	response = CreateSendMeetingCommandResponse()
	err = client.DoAction(request, response)
	return
}

// SendMeetingCommandWithChan invokes the aliyuncvc.SendMeetingCommand API asynchronously
func (client *Client) SendMeetingCommandWithChan(request *SendMeetingCommandRequest) (<-chan *SendMeetingCommandResponse, <-chan error) {
	responseChan := make(chan *SendMeetingCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendMeetingCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendMeetingCommandWithCallback invokes the aliyuncvc.SendMeetingCommand API asynchronously
func (client *Client) SendMeetingCommandWithCallback(request *SendMeetingCommandRequest, callback func(response *SendMeetingCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendMeetingCommandResponse
		var err error
		defer close(result)
		response, err = client.SendMeetingCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendMeetingCommandRequest is the request struct for api SendMeetingCommand
type SendMeetingCommandRequest struct {
	*requests.RpcRequest
	OperatorMemberUUID string           `position:"Body" name:"OperatorMemberUUID"`
	MemberUUID         string           `position:"Query" name:"MemberUUID"`
	SendType           requests.Integer `position:"Body" name:"SendType"`
	Command            string           `position:"Body" name:"Command"`
	MeetingUUID        string           `position:"Query" name:"MeetingUUID"`
}

// SendMeetingCommandResponse is the response struct for api SendMeetingCommand
type SendMeetingCommandResponse struct {
	*responses.BaseResponse
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSendMeetingCommandRequest creates a request to invoke SendMeetingCommand API
func CreateSendMeetingCommandRequest() (request *SendMeetingCommandRequest) {
	request = &SendMeetingCommandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "SendMeetingCommand", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendMeetingCommandResponse creates a response to parse from SendMeetingCommand response
func CreateSendMeetingCommandResponse() (response *SendMeetingCommandResponse) {
	response = &SendMeetingCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
