package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertCustom invokes the alinlp.InsertCustom API synchronously
func (client *Client) InsertCustom(request *InsertCustomRequest) (response *InsertCustomResponse, err error) {
	response = CreateInsertCustomResponse()
	err = client.DoAction(request, response)
	return
}

// InsertCustomWithChan invokes the alinlp.InsertCustom API asynchronously
func (client *Client) InsertCustomWithChan(request *InsertCustomRequest) (<-chan *InsertCustomResponse, <-chan error) {
	responseChan := make(chan *InsertCustomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertCustom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertCustomWithCallback invokes the alinlp.InsertCustom API asynchronously
func (client *Client) InsertCustomWithCallback(request *InsertCustomRequest, callback func(response *InsertCustomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertCustomResponse
		var err error
		defer close(result)
		response, err = client.InsertCustom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertCustomRequest is the request struct for api InsertCustom
type InsertCustomRequest struct {
	*requests.RpcRequest
	CustomUrl      string           `position:"Body" name:"CustomUrl"`
	RegUrl         string           `position:"Body" name:"RegUrl"`
	ServiceCode    string           `position:"Body" name:"ServiceCode"`
	RegFileName    string           `position:"Body" name:"RegFileName"`
	CustomFileName string           `position:"Body" name:"CustomFileName"`
	ApiId          requests.Integer `position:"Body" name:"ApiId"`
}

// InsertCustomResponse is the response struct for api InsertCustom
type InsertCustomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateInsertCustomRequest creates a request to invoke InsertCustom API
func CreateInsertCustomRequest() (request *InsertCustomRequest) {
	request = &InsertCustomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "InsertCustom", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInsertCustomResponse creates a response to parse from InsertCustom response
func CreateInsertCustomResponse() (response *InsertCustomResponse) {
	response = &InsertCustomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
