package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWeChSearch invokes the alinlp.GetWeChSearch API synchronously
func (client *Client) GetWeChSearch(request *GetWeChSearchRequest) (response *GetWeChSearchResponse, err error) {
	response = CreateGetWeChSearchResponse()
	err = client.DoAction(request, response)
	return
}

// GetWeChSearchWithChan invokes the alinlp.GetWeChSearch API asynchronously
func (client *Client) GetWeChSearchWithChan(request *GetWeChSearchRequest) (<-chan *GetWeChSearchResponse, <-chan error) {
	responseChan := make(chan *GetWeChSearchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWeChSearch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWeChSearchWithCallback invokes the alinlp.GetWeChSearch API asynchronously
func (client *Client) GetWeChSearchWithCallback(request *GetWeChSearchRequest, callback func(response *GetWeChSearchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWeChSearchResponse
		var err error
		defer close(result)
		response, err = client.GetWeChSearch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWeChSearchRequest is the request struct for api GetWeChSearch
type GetWeChSearchRequest struct {
	*requests.RpcRequest
	Type        string `position:"Body" name:"Type"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Size        string `position:"Body" name:"Size"`
	TokenizerId string `position:"Body" name:"TokenizerId"`
	Text        string `position:"Body" name:"Text"`
	Operation   string `position:"Body" name:"Operation"`
}

// GetWeChSearchResponse is the response struct for api GetWeChSearch
type GetWeChSearchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetWeChSearchRequest creates a request to invoke GetWeChSearch API
func CreateGetWeChSearchRequest() (request *GetWeChSearchRequest) {
	request = &GetWeChSearchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetWeChSearch", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetWeChSearchResponse creates a response to parse from GetWeChSearch response
func CreateGetWeChSearchResponse() (response *GetWeChSearchResponse) {
	response = &GetWeChSearchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
