package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishImage invokes the aiworkspace.PublishImage API synchronously
func (client *Client) PublishImage(request *PublishImageRequest) (response *PublishImageResponse, err error) {
	response = CreatePublishImageResponse()
	err = client.DoAction(request, response)
	return
}

// PublishImageWithChan invokes the aiworkspace.PublishImage API asynchronously
func (client *Client) PublishImageWithChan(request *PublishImageRequest) (<-chan *PublishImageResponse, <-chan error) {
	responseChan := make(chan *PublishImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishImageWithCallback invokes the aiworkspace.PublishImage API asynchronously
func (client *Client) PublishImageWithCallback(request *PublishImageRequest, callback func(response *PublishImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishImageResponse
		var err error
		defer close(result)
		response, err = client.PublishImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishImageRequest is the request struct for api PublishImage
type PublishImageRequest struct {
	*requests.RoaRequest
	ImageId string `position:"Path" name:"ImageId"`
}

// PublishImageResponse is the response struct for api PublishImage
type PublishImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ImageId   string `json:"ImageId" xml:"ImageId"`
}

// CreatePublishImageRequest creates a request to invoke PublishImage API
func CreatePublishImageRequest() (request *PublishImageRequest) {
	request = &PublishImageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "PublishImage", "/api/v1/images/[ImageId]/publish", "", "")
	request.Method = requests.PUT
	return
}

// CreatePublishImageResponse creates a response to parse from PublishImage response
func CreatePublishImageResponse() (response *PublishImageResponse) {
	response = &PublishImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
