package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListQuotas invokes the aiworkspace.ListQuotas API synchronously
func (client *Client) ListQuotas(request *ListQuotasRequest) (response *ListQuotasResponse, err error) {
	response = CreateListQuotasResponse()
	err = client.DoAction(request, response)
	return
}

// ListQuotasWithChan invokes the aiworkspace.ListQuotas API asynchronously
func (client *Client) ListQuotasWithChan(request *ListQuotasRequest) (<-chan *ListQuotasResponse, <-chan error) {
	responseChan := make(chan *ListQuotasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListQuotas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListQuotasWithCallback invokes the aiworkspace.ListQuotas API asynchronously
func (client *Client) ListQuotasWithCallback(request *ListQuotasRequest, callback func(response *ListQuotasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListQuotasResponse
		var err error
		defer close(result)
		response, err = client.ListQuotas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListQuotasRequest is the request struct for api ListQuotas
type ListQuotasRequest struct {
	*requests.RoaRequest
	Name string `position:"Query" name:"Name"`
}

// ListQuotasResponse is the response struct for api ListQuotas
type ListQuotasResponse struct {
	*responses.BaseResponse
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	TotalCount int64        `json:"TotalCount" xml:"TotalCount"`
	Quotas     []QuotasItem `json:"Quotas" xml:"Quotas"`
}

// CreateListQuotasRequest creates a request to invoke ListQuotas API
func CreateListQuotasRequest() (request *ListQuotasRequest) {
	request = &ListQuotasRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "ListQuotas", "/api/v1/quotas", "", "")
	request.Method = requests.GET
	return
}

// CreateListQuotasResponse creates a response to parse from ListQuotas response
func CreateListQuotasResponse() (response *ListQuotasResponse) {
	response = &ListQuotasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
