package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Recommend invokes the airec.Recommend API synchronously
func (client *Client) Recommend(request *RecommendRequest) (response *RecommendResponse, err error) {
	response = CreateRecommendResponse()
	err = client.DoAction(request, response)
	return
}

// RecommendWithChan invokes the airec.Recommend API asynchronously
func (client *Client) RecommendWithChan(request *RecommendRequest) (<-chan *RecommendResponse, <-chan error) {
	responseChan := make(chan *RecommendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Recommend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecommendWithCallback invokes the airec.Recommend API asynchronously
func (client *Client) RecommendWithCallback(request *RecommendRequest, callback func(response *RecommendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecommendResponse
		var err error
		defer close(result)
		response, err = client.Recommend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecommendRequest is the request struct for api Recommend
type RecommendRequest struct {
	*requests.RoaRequest
	ReturnCount  requests.Integer `position:"Query" name:"returnCount"`
	ServiceType  string           `position:"Query" name:"serviceType"`
	InstanceId   string           `position:"Path" name:"instanceId"`
	Debug        string           `position:"Query" name:"debug"`
	Ip           string           `position:"Query" name:"ip"`
	LogLevel     string           `position:"Query" name:"logLevel"`
	SceneId      string           `position:"Query" name:"sceneId"`
	Imei         string           `position:"Query" name:"imei"`
	ExperimentId string           `position:"Query" name:"experimentId"`
	UserId       string           `position:"Query" name:"userId"`
	Items        string           `position:"Query" name:"items"`
	UserInfo     string           `position:"Query" name:"userInfo"`
}

// RecommendResponse is the response struct for api Recommend
type RecommendResponse struct {
	*responses.BaseResponse
	Code      string       `json:"code" xml:"code"`
	Message   string       `json:"message" xml:"message"`
	RequestId string       `json:"requestId" xml:"requestId"`
	Result    []ResultItem `json:"result" xml:"result"`
}

// CreateRecommendRequest creates a request to invoke Recommend API
func CreateRecommendRequest() (request *RecommendRequest) {
	request = &RecommendRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "Recommend", "/v2/openapi/instances/[instanceId]/actions/recommend", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateRecommendResponse creates a response to parse from Recommend response
func CreateRecommendResponse() (response *RecommendResponse) {
	response = &RecommendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
