package aigen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateTextDeformation invokes the aigen.GenerateTextDeformation API synchronously
func (client *Client) GenerateTextDeformation(request *GenerateTextDeformationRequest) (response *GenerateTextDeformationResponse, err error) {
	response = CreateGenerateTextDeformationResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateTextDeformationWithChan invokes the aigen.GenerateTextDeformation API asynchronously
func (client *Client) GenerateTextDeformationWithChan(request *GenerateTextDeformationRequest) (<-chan *GenerateTextDeformationResponse, <-chan error) {
	responseChan := make(chan *GenerateTextDeformationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateTextDeformation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateTextDeformationWithCallback invokes the aigen.GenerateTextDeformation API asynchronously
func (client *Client) GenerateTextDeformationWithCallback(request *GenerateTextDeformationRequest, callback func(response *GenerateTextDeformationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateTextDeformationResponse
		var err error
		defer close(result)
		response, err = client.GenerateTextDeformation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateTextDeformationRequest is the request struct for api GenerateTextDeformation
type GenerateTextDeformationRequest struct {
	*requests.RpcRequest
	TextContent      string           `position:"Body" name:"TextContent"`
	FontName         string           `position:"Body" name:"FontName"`
	TtfUrl           string           `position:"Body" name:"TtfUrl"`
	N                requests.Integer `position:"Body" name:"N"`
	Async            requests.Boolean `position:"Body" name:"Async"`
	Prompt           string           `position:"Body" name:"Prompt"`
	OutputImageRatio string           `position:"Body" name:"OutputImageRatio"`
}

// GenerateTextDeformationResponse is the response struct for api GenerateTextDeformation
type GenerateTextDeformationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGenerateTextDeformationRequest creates a request to invoke GenerateTextDeformation API
func CreateGenerateTextDeformationRequest() (request *GenerateTextDeformationRequest) {
	request = &GenerateTextDeformationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aigen", "2024-01-11", "GenerateTextDeformation", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateTextDeformationResponse creates a response to parse from GenerateTextDeformation response
func CreateGenerateTextDeformationResponse() (response *GenerateTextDeformationResponse) {
	response = &GenerateTextDeformationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
