package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PageableQueryUserExperiment invokes the ahas_openapi.PageableQueryUserExperiment API synchronously
func (client *Client) PageableQueryUserExperiment(request *PageableQueryUserExperimentRequest) (response *PageableQueryUserExperimentResponse, err error) {
	response = CreatePageableQueryUserExperimentResponse()
	err = client.DoAction(request, response)
	return
}

// PageableQueryUserExperimentWithChan invokes the ahas_openapi.PageableQueryUserExperiment API asynchronously
func (client *Client) PageableQueryUserExperimentWithChan(request *PageableQueryUserExperimentRequest) (<-chan *PageableQueryUserExperimentResponse, <-chan error) {
	responseChan := make(chan *PageableQueryUserExperimentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PageableQueryUserExperiment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PageableQueryUserExperimentWithCallback invokes the ahas_openapi.PageableQueryUserExperiment API asynchronously
func (client *Client) PageableQueryUserExperimentWithCallback(request *PageableQueryUserExperimentRequest, callback func(response *PageableQueryUserExperimentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PageableQueryUserExperimentResponse
		var err error
		defer close(result)
		response, err = client.PageableQueryUserExperiment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PageableQueryUserExperimentRequest is the request struct for api PageableQueryUserExperiment
type PageableQueryUserExperimentRequest struct {
	*requests.RpcRequest
	SearchKey    string           `position:"Query" name:"SearchKey"`
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	Tags         *[]string        `position:"Query" name:"Tags"  type:"Repeated"`
	Size         requests.Integer `position:"Query" name:"Size"`
	Namespace    string           `position:"Query" name:"Namespace"`
	State        string           `position:"Query" name:"State"`
	Page         requests.Integer `position:"Query" name:"Page"`
	Results      *[]string        `position:"Query" name:"Results"  type:"Repeated"`
	WorkspaceId  string           `position:"Query" name:"WorkspaceId"`
}

// PageableQueryUserExperimentResponse is the response struct for api PageableQueryUserExperiment
type PageableQueryUserExperimentResponse struct {
	*responses.BaseResponse
	Pages          int              `json:"Pages" xml:"Pages"`
	RequestId      string           `json:"RequestId" xml:"RequestId"`
	Message        string           `json:"Message" xml:"Message"`
	PageSize       int              `json:"PageSize" xml:"PageSize"`
	CurrentPage    int              `json:"CurrentPage" xml:"CurrentPage"`
	Total          int              `json:"Total" xml:"Total"`
	HttpStatusCode int              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string           `json:"Code" xml:"Code"`
	Success        bool             `json:"Success" xml:"Success"`
	ExperimentList []ExperimentInfo `json:"ExperimentList" xml:"ExperimentList"`
}

// CreatePageableQueryUserExperimentRequest creates a request to invoke PageableQueryUserExperiment API
func CreatePageableQueryUserExperimentRequest() (request *PageableQueryUserExperimentRequest) {
	request = &PageableQueryUserExperimentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "PageableQueryUserExperiment", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePageableQueryUserExperimentResponse creates a response to parse from PageableQueryUserExperiment response
func CreatePageableQueryUserExperimentResponse() (response *PageableQueryUserExperimentResponse) {
	response = &PageableQueryUserExperimentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
