package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSuspEventUserSetting invokes the aegis.DescribeSuspEventUserSetting API synchronously
// api document: https://help.aliyun.com/api/aegis/describesuspeventusersetting.html
func (client *Client) DescribeSuspEventUserSetting(request *DescribeSuspEventUserSettingRequest) (response *DescribeSuspEventUserSettingResponse, err error) {
	response = CreateDescribeSuspEventUserSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSuspEventUserSettingWithChan invokes the aegis.DescribeSuspEventUserSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesuspeventusersetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSuspEventUserSettingWithChan(request *DescribeSuspEventUserSettingRequest) (<-chan *DescribeSuspEventUserSettingResponse, <-chan error) {
	responseChan := make(chan *DescribeSuspEventUserSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSuspEventUserSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSuspEventUserSettingWithCallback invokes the aegis.DescribeSuspEventUserSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/describesuspeventusersetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSuspEventUserSettingWithCallback(request *DescribeSuspEventUserSettingRequest, callback func(response *DescribeSuspEventUserSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSuspEventUserSettingResponse
		var err error
		defer close(result)
		response, err = client.DescribeSuspEventUserSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSuspEventUserSettingRequest is the request struct for api DescribeSuspEventUserSetting
type DescribeSuspEventUserSettingRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	From     string           `position:"Query" name:"From"`
	Id       requests.Integer `position:"Query" name:"Id"`
}

// DescribeSuspEventUserSettingResponse is the response struct for api DescribeSuspEventUserSetting
type DescribeSuspEventUserSettingResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	LevelsOn  []string `json:"LevelsOn" xml:"LevelsOn"`
}

// CreateDescribeSuspEventUserSettingRequest creates a request to invoke DescribeSuspEventUserSetting API
func CreateDescribeSuspEventUserSettingRequest() (request *DescribeSuspEventUserSettingRequest) {
	request = &DescribeSuspEventUserSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeSuspEventUserSetting", "vipaegis", "openAPI")
	return
}

// CreateDescribeSuspEventUserSettingResponse creates a response to parse from DescribeSuspEventUserSetting response
func CreateDescribeSuspEventUserSettingResponse() (response *DescribeSuspEventUserSettingResponse) {
	response = &DescribeSuspEventUserSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
