package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEventCountCurve invokes the aegis.DescribeEventCountCurve API synchronously
// api document: https://help.aliyun.com/api/aegis/describeeventcountcurve.html
func (client *Client) DescribeEventCountCurve(request *DescribeEventCountCurveRequest) (response *DescribeEventCountCurveResponse, err error) {
	response = CreateDescribeEventCountCurveResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEventCountCurveWithChan invokes the aegis.DescribeEventCountCurve API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeeventcountcurve.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEventCountCurveWithChan(request *DescribeEventCountCurveRequest) (<-chan *DescribeEventCountCurveResponse, <-chan error) {
	responseChan := make(chan *DescribeEventCountCurveResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEventCountCurve(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEventCountCurveWithCallback invokes the aegis.DescribeEventCountCurve API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeeventcountcurve.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEventCountCurveWithCallback(request *DescribeEventCountCurveRequest, callback func(response *DescribeEventCountCurveResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEventCountCurveResponse
		var err error
		defer close(result)
		response, err = client.DescribeEventCountCurve(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEventCountCurveRequest is the request struct for api DescribeEventCountCurve
type DescribeEventCountCurveRequest struct {
	*requests.RpcRequest
	Types                 string           `position:"Query" name:"Types"`
	SourceIp              string           `position:"Query" name:"SourceIp"`
	VulEventLevels        string           `position:"Query" name:"VulEventLevels"`
	LastDays              requests.Integer `position:"Query" name:"LastDays"`
	HealthEventLevels     string           `position:"Query" name:"HealthEventLevels"`
	SuspiciousEventLevels string           `position:"Query" name:"SuspiciousEventLevels"`
}

// DescribeEventCountCurveResponse is the response struct for api DescribeEventCountCurve
type DescribeEventCountCurveResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Success   bool      `json:"Success" xml:"Success"`
	CurveData CurveData `json:"CurveData" xml:"CurveData"`
}

// CreateDescribeEventCountCurveRequest creates a request to invoke DescribeEventCountCurve API
func CreateDescribeEventCountCurveRequest() (request *DescribeEventCountCurveRequest) {
	request = &DescribeEventCountCurveRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeEventCountCurve", "vipaegis", "openAPI")
	return
}

// CreateDescribeEventCountCurveResponse creates a response to parse from DescribeEventCountCurve response
func CreateDescribeEventCountCurveResponse() (response *DescribeEventCountCurveResponse) {
	response = &DescribeEventCountCurveResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
