package address_purification

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAddressSimilarity invokes the address_purification.GetAddressSimilarity API synchronously
func (client *Client) GetAddressSimilarity(request *GetAddressSimilarityRequest) (response *GetAddressSimilarityResponse, err error) {
	response = CreateGetAddressSimilarityResponse()
	err = client.DoAction(request, response)
	return
}

// GetAddressSimilarityWithChan invokes the address_purification.GetAddressSimilarity API asynchronously
func (client *Client) GetAddressSimilarityWithChan(request *GetAddressSimilarityRequest) (<-chan *GetAddressSimilarityResponse, <-chan error) {
	responseChan := make(chan *GetAddressSimilarityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAddressSimilarity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAddressSimilarityWithCallback invokes the address_purification.GetAddressSimilarity API asynchronously
func (client *Client) GetAddressSimilarityWithCallback(request *GetAddressSimilarityRequest, callback func(response *GetAddressSimilarityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAddressSimilarityResponse
		var err error
		defer close(result)
		response, err = client.GetAddressSimilarity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAddressSimilarityRequest is the request struct for api GetAddressSimilarity
type GetAddressSimilarityRequest struct {
	*requests.RpcRequest
	DefaultProvince string `position:"Body" name:"DefaultProvince"`
	ServiceCode     string `position:"Body" name:"ServiceCode"`
	DefaultCity     string `position:"Body" name:"DefaultCity"`
	DefaultDistrict string `position:"Body" name:"DefaultDistrict"`
	AppKey          string `position:"Body" name:"AppKey"`
	Text            string `position:"Body" name:"Text"`
}

// GetAddressSimilarityResponse is the response struct for api GetAddressSimilarity
type GetAddressSimilarityResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetAddressSimilarityRequest creates a request to invoke GetAddressSimilarity API
func CreateGetAddressSimilarityRequest() (request *GetAddressSimilarityRequest) {
	request = &GetAddressSimilarityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("address-purification", "2019-11-18", "GetAddressSimilarity", "addrp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAddressSimilarityResponse creates a response to parse from GetAddressSimilarity response
func CreateGetAddressSimilarityResponse() (response *GetAddressSimilarityResponse) {
	response = &GetAddressSimilarityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
