package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMaintenanceAction invokes the adb.DescribeMaintenanceAction API synchronously
func (client *Client) DescribeMaintenanceAction(request *DescribeMaintenanceActionRequest) (response *DescribeMaintenanceActionResponse, err error) {
	response = CreateDescribeMaintenanceActionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMaintenanceActionWithChan invokes the adb.DescribeMaintenanceAction API asynchronously
func (client *Client) DescribeMaintenanceActionWithChan(request *DescribeMaintenanceActionRequest) (<-chan *DescribeMaintenanceActionResponse, <-chan error) {
	responseChan := make(chan *DescribeMaintenanceActionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMaintenanceAction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMaintenanceActionWithCallback invokes the adb.DescribeMaintenanceAction API asynchronously
func (client *Client) DescribeMaintenanceActionWithCallback(request *DescribeMaintenanceActionRequest, callback func(response *DescribeMaintenanceActionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMaintenanceActionResponse
		var err error
		defer close(result)
		response, err = client.DescribeMaintenanceAction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMaintenanceActionRequest is the request struct for api DescribeMaintenanceAction
type DescribeMaintenanceActionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	IsHistory            requests.Integer `position:"Query" name:"IsHistory"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	TaskType             string           `position:"Query" name:"TaskType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Region               string           `position:"Query" name:"Region"`
}

// DescribeMaintenanceActionResponse is the response struct for api DescribeMaintenanceAction
type DescribeMaintenanceActionResponse struct {
	*responses.BaseResponse
	PageNumber       int         `json:"PageNumber" xml:"PageNumber"`
	RequestId        string      `json:"RequestId" xml:"RequestId"`
	PageSize         int         `json:"PageSize" xml:"PageSize"`
	TotalRecordCount int         `json:"TotalRecordCount" xml:"TotalRecordCount"`
	Items            []ItemsItem `json:"Items" xml:"Items"`
}

// CreateDescribeMaintenanceActionRequest creates a request to invoke DescribeMaintenanceAction API
func CreateDescribeMaintenanceActionRequest() (request *DescribeMaintenanceActionRequest) {
	request = &DescribeMaintenanceActionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeMaintenanceAction", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMaintenanceActionResponse creates a response to parse from DescribeMaintenanceAction response
func CreateDescribeMaintenanceActionResponse() (response *DescribeMaintenanceActionResponse) {
	response = &DescribeMaintenanceActionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
