package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInclinedTables invokes the adb.DescribeInclinedTables API synchronously
func (client *Client) DescribeInclinedTables(request *DescribeInclinedTablesRequest) (response *DescribeInclinedTablesResponse, err error) {
	response = CreateDescribeInclinedTablesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInclinedTablesWithChan invokes the adb.DescribeInclinedTables API asynchronously
func (client *Client) DescribeInclinedTablesWithChan(request *DescribeInclinedTablesRequest) (<-chan *DescribeInclinedTablesResponse, <-chan error) {
	responseChan := make(chan *DescribeInclinedTablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInclinedTables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInclinedTablesWithCallback invokes the adb.DescribeInclinedTables API asynchronously
func (client *Client) DescribeInclinedTablesWithCallback(request *DescribeInclinedTablesRequest, callback func(response *DescribeInclinedTablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInclinedTablesResponse
		var err error
		defer close(result)
		response, err = client.DescribeInclinedTables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInclinedTablesRequest is the request struct for api DescribeInclinedTables
type DescribeInclinedTablesRequest struct {
	*requests.RpcRequest
	TableType            string           `position:"Query" name:"TableType"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	Order                string           `position:"Query" name:"Order"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeInclinedTablesResponse is the response struct for api DescribeInclinedTables
type DescribeInclinedTablesResponse struct {
	*responses.BaseResponse
	TotalCount string                        `json:"TotalCount" xml:"TotalCount"`
	PageSize   string                        `json:"PageSize" xml:"PageSize"`
	RequestId  string                        `json:"RequestId" xml:"RequestId"`
	PageNumber string                        `json:"PageNumber" xml:"PageNumber"`
	Items      ItemsInDescribeInclinedTables `json:"Items" xml:"Items"`
}

// CreateDescribeInclinedTablesRequest creates a request to invoke DescribeInclinedTables API
func CreateDescribeInclinedTablesRequest() (request *DescribeInclinedTablesRequest) {
	request = &DescribeInclinedTablesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeInclinedTables", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInclinedTablesResponse creates a response to parse from DescribeInclinedTables response
func CreateDescribeInclinedTablesResponse() (response *DescribeInclinedTablesResponse) {
	response = &DescribeInclinedTablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
