package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterStatus invokes the adb.DescribeDBClusterStatus API synchronously
func (client *Client) DescribeDBClusterStatus(request *DescribeDBClusterStatusRequest) (response *DescribeDBClusterStatusResponse, err error) {
	response = CreateDescribeDBClusterStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterStatusWithChan invokes the adb.DescribeDBClusterStatus API asynchronously
func (client *Client) DescribeDBClusterStatusWithChan(request *DescribeDBClusterStatusRequest) (<-chan *DescribeDBClusterStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterStatusWithCallback invokes the adb.DescribeDBClusterStatus API asynchronously
func (client *Client) DescribeDBClusterStatusWithCallback(request *DescribeDBClusterStatusRequest, callback func(response *DescribeDBClusterStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterStatusRequest is the request struct for api DescribeDBClusterStatus
type DescribeDBClusterStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBClusterStatusResponse is the response struct for api DescribeDBClusterStatus
type DescribeDBClusterStatusResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Status    []string `json:"Status" xml:"Status"`
}

// CreateDescribeDBClusterStatusRequest creates a request to invoke DescribeDBClusterStatus API
func CreateDescribeDBClusterStatusRequest() (request *DescribeDBClusterStatusRequest) {
	request = &DescribeDBClusterStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeDBClusterStatus", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterStatusResponse creates a response to parse from DescribeDBClusterStatus response
func CreateDescribeDBClusterStatusResponse() (response *DescribeDBClusterStatusResponse) {
	response = &DescribeDBClusterStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
