package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeComputeResource invokes the adb.DescribeComputeResource API synchronously
func (client *Client) DescribeComputeResource(request *DescribeComputeResourceRequest) (response *DescribeComputeResourceResponse, err error) {
	response = CreateDescribeComputeResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeComputeResourceWithChan invokes the adb.DescribeComputeResource API asynchronously
func (client *Client) DescribeComputeResourceWithChan(request *DescribeComputeResourceRequest) (<-chan *DescribeComputeResourceResponse, <-chan error) {
	responseChan := make(chan *DescribeComputeResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeComputeResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeComputeResourceWithCallback invokes the adb.DescribeComputeResource API asynchronously
func (client *Client) DescribeComputeResourceWithCallback(request *DescribeComputeResourceRequest, callback func(response *DescribeComputeResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeComputeResourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeComputeResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeComputeResourceRequest is the request struct for api DescribeComputeResource
type DescribeComputeResourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DBClusterVersion     string           `position:"Query" name:"DBClusterVersion"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
	Migrate              requests.Boolean `position:"Query" name:"Migrate"`
}

// DescribeComputeResourceResponse is the response struct for api DescribeComputeResource
type DescribeComputeResourceResponse struct {
	*responses.BaseResponse
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	ComputeResource []ComputeResourceItem `json:"ComputeResource" xml:"ComputeResource"`
}

// CreateDescribeComputeResourceRequest creates a request to invoke DescribeComputeResource API
func CreateDescribeComputeResourceRequest() (request *DescribeComputeResourceRequest) {
	request = &DescribeComputeResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeComputeResource", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeComputeResourceResponse creates a response to parse from DescribeComputeResource response
func CreateDescribeComputeResourceResponse() (response *DescribeComputeResourceResponse) {
	response = &DescribeComputeResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
