// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v2/connection.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// IANA Internet Protocol Number such as TCP(6) and UDP(17).
type Connection_Protocol int32

const (
	// Unspecified protocol (not HOPOPT).
	Connection_PROTOCOL_UNSPECIFIED Connection_Protocol = 0
	// Internet Control Message Protocol.
	Connection_ICMP Connection_Protocol = 1
	// Transmission Control Protocol.
	Connection_TCP Connection_Protocol = 6
	// User Datagram Protocol.
	Connection_UDP Connection_Protocol = 17
	// Generic Routing Encapsulation.
	Connection_GRE Connection_Protocol = 47
	// Encap Security Payload.
	Connection_ESP Connection_Protocol = 50
)

// Enum value maps for Connection_Protocol.
var (
	Connection_Protocol_name = map[int32]string{
		0:  "PROTOCOL_UNSPECIFIED",
		1:  "ICMP",
		6:  "TCP",
		17: "UDP",
		47: "GRE",
		50: "ESP",
	}
	Connection_Protocol_value = map[string]int32{
		"PROTOCOL_UNSPECIFIED": 0,
		"ICMP":                 1,
		"TCP":                  6,
		"UDP":                  17,
		"GRE":                  47,
		"ESP":                  50,
	}
)

func (x Connection_Protocol) Enum() *Connection_Protocol {
	p := new(Connection_Protocol)
	*p = x
	return p
}

func (x Connection_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Connection_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_connection_proto_enumTypes[0].Descriptor()
}

func (Connection_Protocol) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_connection_proto_enumTypes[0]
}

func (x Connection_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Connection_Protocol.Descriptor instead.
func (Connection_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_connection_proto_rawDescGZIP(), []int{0, 0}
}

// Contains information about the IP connection associated with the finding.
type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Destination IP address. Not present for sockets that are listening and not
	// connected.
	DestinationIp string `protobuf:"bytes,1,opt,name=destination_ip,json=destinationIp,proto3" json:"destination_ip,omitempty"`
	// Destination port. Not present for sockets that are listening and not
	// connected.
	DestinationPort int32 `protobuf:"varint,2,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	// Source IP address.
	SourceIp string `protobuf:"bytes,3,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Source port.
	SourcePort int32 `protobuf:"varint,4,opt,name=source_port,json=sourcePort,proto3" json:"source_port,omitempty"`
	// IANA Internet Protocol Number such as TCP(6) and UDP(17).
	Protocol Connection_Protocol `protobuf:"varint,5,opt,name=protocol,proto3,enum=google.cloud.securitycenter.v2.Connection_Protocol" json:"protocol,omitempty"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	mi := &file_google_cloud_securitycenter_v2_connection_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_connection_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_connection_proto_rawDescGZIP(), []int{0}
}

func (x *Connection) GetDestinationIp() string {
	if x != nil {
		return x.DestinationIp
	}
	return ""
}

func (x *Connection) GetDestinationPort() int32 {
	if x != nil {
		return x.DestinationPort
	}
	return 0
}

func (x *Connection) GetSourceIp() string {
	if x != nil {
		return x.SourceIp
	}
	return ""
}

func (x *Connection) GetSourcePort() int32 {
	if x != nil {
		return x.SourcePort
	}
	return 0
}

func (x *Connection) GetProtocol() Connection_Protocol {
	if x != nil {
		return x.Protocol
	}
	return Connection_PROTOCOL_UNSPECIFIED
}

var File_google_cloud_securitycenter_v2_connection_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_connection_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x22, 0xc1, 0x02, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x25, 0x0a, 0x0e, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x70, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x72, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x70, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x72, 0x74,
	0x12, 0x4f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x22, 0x52, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x18, 0x0a,
	0x14, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x43, 0x4d, 0x50, 0x10,
	0x01, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x43, 0x50, 0x10, 0x06, 0x12, 0x07, 0x0a, 0x03, 0x55, 0x44,
	0x50, 0x10, 0x11, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x52, 0x45, 0x10, 0x2f, 0x12, 0x07, 0x0a, 0x03,
	0x45, 0x53, 0x50, 0x10, 0x32, 0x42, 0xe9, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x42, 0x0f, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x21,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56,
	0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_connection_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_connection_proto_rawDescData = file_google_cloud_securitycenter_v2_connection_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_connection_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_connection_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_connection_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_connection_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_connection_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_connection_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securitycenter_v2_connection_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_securitycenter_v2_connection_proto_goTypes = []any{
	(Connection_Protocol)(0), // 0: google.cloud.securitycenter.v2.Connection.Protocol
	(*Connection)(nil),       // 1: google.cloud.securitycenter.v2.Connection
}
var file_google_cloud_securitycenter_v2_connection_proto_depIdxs = []int32{
	0, // 0: google.cloud.securitycenter.v2.Connection.protocol:type_name -> google.cloud.securitycenter.v2.Connection.Protocol
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_connection_proto_init() }
func file_google_cloud_securitycenter_v2_connection_proto_init() {
	if File_google_cloud_securitycenter_v2_connection_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_connection_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_connection_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_connection_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_connection_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_connection_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_connection_proto = out.File
	file_google_cloud_securitycenter_v2_connection_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_connection_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_connection_proto_depIdxs = nil
}
