// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/retail/v2beta/conversational_search_service.proto

package retailpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum to control Conversational Filtering mode.
// A single conversation session including multiple turns supports modes for
// Conversational Search OR Conversational Filtering without
// Conversational Search, but not both.
type ConversationalSearchRequest_ConversationalFilteringSpec_Mode int32

const (
	// Default value.
	ConversationalSearchRequest_ConversationalFilteringSpec_MODE_UNSPECIFIED ConversationalSearchRequest_ConversationalFilteringSpec_Mode = 0
	// Disables Conversational Filtering when using Conversational Search.
	ConversationalSearchRequest_ConversationalFilteringSpec_DISABLED ConversationalSearchRequest_ConversationalFilteringSpec_Mode = 1
	// Enables Conversational Filtering when using Conversational Search.
	ConversationalSearchRequest_ConversationalFilteringSpec_ENABLED ConversationalSearchRequest_ConversationalFilteringSpec_Mode = 2
	// Enables Conversational Filtering without Conversational Search.
	ConversationalSearchRequest_ConversationalFilteringSpec_CONVERSATIONAL_FILTER_ONLY ConversationalSearchRequest_ConversationalFilteringSpec_Mode = 3
)

// Enum value maps for ConversationalSearchRequest_ConversationalFilteringSpec_Mode.
var (
	ConversationalSearchRequest_ConversationalFilteringSpec_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "ENABLED",
		3: "CONVERSATIONAL_FILTER_ONLY",
	}
	ConversationalSearchRequest_ConversationalFilteringSpec_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED":           0,
		"DISABLED":                   1,
		"ENABLED":                    2,
		"CONVERSATIONAL_FILTER_ONLY": 3,
	}
)

func (x ConversationalSearchRequest_ConversationalFilteringSpec_Mode) Enum() *ConversationalSearchRequest_ConversationalFilteringSpec_Mode {
	p := new(ConversationalSearchRequest_ConversationalFilteringSpec_Mode)
	*p = x
	return p
}

func (x ConversationalSearchRequest_ConversationalFilteringSpec_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConversationalSearchRequest_ConversationalFilteringSpec_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_enumTypes[0].Descriptor()
}

func (ConversationalSearchRequest_ConversationalFilteringSpec_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2beta_conversational_search_service_proto_enumTypes[0]
}

func (x ConversationalSearchRequest_ConversationalFilteringSpec_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConversationalSearchRequest_ConversationalFilteringSpec_Mode.Descriptor instead.
func (ConversationalSearchRequest_ConversationalFilteringSpec_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{0, 2, 0}
}

// The state of the response generation.
type ConversationalSearchResponse_State int32

const (
	// Unknown.
	ConversationalSearchResponse_STATE_UNSPECIFIED ConversationalSearchResponse_State = 0
	// Response generation is being streamed.
	ConversationalSearchResponse_STREAMING ConversationalSearchResponse_State = 1
	// Response generation has succeeded.
	ConversationalSearchResponse_SUCCEEDED ConversationalSearchResponse_State = 2
)

// Enum value maps for ConversationalSearchResponse_State.
var (
	ConversationalSearchResponse_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STREAMING",
		2: "SUCCEEDED",
	}
	ConversationalSearchResponse_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STREAMING":         1,
		"SUCCEEDED":         2,
	}
)

func (x ConversationalSearchResponse_State) Enum() *ConversationalSearchResponse_State {
	p := new(ConversationalSearchResponse_State)
	*p = x
	return p
}

func (x ConversationalSearchResponse_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConversationalSearchResponse_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_enumTypes[1].Descriptor()
}

func (ConversationalSearchResponse_State) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2beta_conversational_search_service_proto_enumTypes[1]
}

func (x ConversationalSearchResponse_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConversationalSearchResponse_State.Descriptor instead.
func (ConversationalSearchResponse_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{1, 0}
}

// Request message for
// [ConversationalSearchService.ConversationalSearch][google.cloud.retail.v2beta.ConversationalSearchService.ConversationalSearch]
// method.
type ConversationalSearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the search engine placement, such as
	// `projects/*/locations/global/catalogs/default_catalog/placements/default_search`
	// or
	// `projects/*/locations/global/catalogs/default_catalog/servingConfigs/default_serving_config`
	// This field is used to identify the serving config name and the set
	// of models that will be used to make the search.
	Placement string `protobuf:"bytes,1,opt,name=placement,proto3" json:"placement,omitempty"`
	// Required. The branch resource name, such as
	// `projects/*/locations/global/catalogs/default_catalog/branches/0`.
	//
	// Use "default_branch" as the branch ID or leave this field empty, to search
	// products under the default branch.
	Branch string `protobuf:"bytes,2,opt,name=branch,proto3" json:"branch,omitempty"`
	// Optional. Raw search query to be searched for.
	//
	// If this field is empty, the request is considered a category browsing
	// request.
	Query string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The categories associated with a category page. Must be set for
	// category navigation queries to achieve good search quality. The format
	// should be the same as
	// [UserEvent.page_categories][google.cloud.retail.v2beta.UserEvent.page_categories];
	//
	// To represent full path of category, use '>' sign to separate different
	// hierarchies. If '>' is part of the category name, replace it with
	// other character(s).
	//
	// Category pages include special pages such as sales or promotions. For
	// instance, a special sale page may have the category hierarchy:
	// "pageCategories" : ["Sales > 2017 Black Friday Deals"].
	PageCategories []string `protobuf:"bytes,4,rep,name=page_categories,json=pageCategories,proto3" json:"page_categories,omitempty"`
	// Optional. This field specifies the conversation id, which maintains the
	// state of the conversation between client side and server side. Use the
	// value from the previous
	// [ConversationalSearchResponse.conversation_id][google.cloud.retail.v2beta.ConversationalSearchResponse.conversation_id].
	// For the initial request, this should be empty.
	ConversationId string `protobuf:"bytes,5,opt,name=conversation_id,json=conversationId,proto3" json:"conversation_id,omitempty"`
	// Optional. Search parameters.
	SearchParams *ConversationalSearchRequest_SearchParams `protobuf:"bytes,6,opt,name=search_params,json=searchParams,proto3" json:"search_params,omitempty"`
	// Required. A unique identifier for tracking visitors. For example, this
	// could be implemented with an HTTP cookie, which should be able to uniquely
	// identify a visitor on a single device. This unique identifier should not
	// change if the visitor logs in or out of the website.
	//
	// This should be the same identifier as
	// [UserEvent.visitor_id][google.cloud.retail.v2beta.UserEvent.visitor_id].
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an INVALID_ARGUMENT error is returned.
	VisitorId string `protobuf:"bytes,9,opt,name=visitor_id,json=visitorId,proto3" json:"visitor_id,omitempty"`
	// Optional. User information.
	UserInfo *UserInfo `protobuf:"bytes,7,opt,name=user_info,json=userInfo,proto3" json:"user_info,omitempty"`
	// Optional. This field specifies all conversational filtering related
	// parameters.
	ConversationalFilteringSpec *ConversationalSearchRequest_ConversationalFilteringSpec `protobuf:"bytes,8,opt,name=conversational_filtering_spec,json=conversationalFilteringSpec,proto3" json:"conversational_filtering_spec,omitempty"`
	// Optional. The user labels applied to a resource must meet the following
	// requirements:
	//
	//   - Each resource can have multiple labels, up to a maximum of 64.
	//   - Each label must be a key-value pair.
	//   - Keys have a minimum length of 1 character and a maximum length of 63
	//     characters and cannot be empty. Values can be empty and have a maximum
	//     length of 63 characters.
	//   - Keys and values can contain only lowercase letters, numeric characters,
	//     underscores, and dashes. All characters must use UTF-8 encoding, and
	//     international characters are allowed.
	//   - The key portion of a label must be unique. However, you can use the same
	//     key with multiple resources.
	//   - Keys must start with a lowercase letter or international character.
	//
	// See [Google Cloud
	// Document](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements)
	// for more details.
	UserLabels map[string]string `protobuf:"bytes,12,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The safety settings to be applied to the generated content.
	SafetySettings []*SafetySetting `protobuf:"bytes,14,rep,name=safety_settings,json=safetySettings,proto3" json:"safety_settings,omitempty"`
}

func (x *ConversationalSearchRequest) Reset() {
	*x = ConversationalSearchRequest{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchRequest) ProtoMessage() {}

func (x *ConversationalSearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchRequest.ProtoReflect.Descriptor instead.
func (*ConversationalSearchRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{0}
}

func (x *ConversationalSearchRequest) GetPlacement() string {
	if x != nil {
		return x.Placement
	}
	return ""
}

func (x *ConversationalSearchRequest) GetBranch() string {
	if x != nil {
		return x.Branch
	}
	return ""
}

func (x *ConversationalSearchRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *ConversationalSearchRequest) GetPageCategories() []string {
	if x != nil {
		return x.PageCategories
	}
	return nil
}

func (x *ConversationalSearchRequest) GetConversationId() string {
	if x != nil {
		return x.ConversationId
	}
	return ""
}

func (x *ConversationalSearchRequest) GetSearchParams() *ConversationalSearchRequest_SearchParams {
	if x != nil {
		return x.SearchParams
	}
	return nil
}

func (x *ConversationalSearchRequest) GetVisitorId() string {
	if x != nil {
		return x.VisitorId
	}
	return ""
}

func (x *ConversationalSearchRequest) GetUserInfo() *UserInfo {
	if x != nil {
		return x.UserInfo
	}
	return nil
}

func (x *ConversationalSearchRequest) GetConversationalFilteringSpec() *ConversationalSearchRequest_ConversationalFilteringSpec {
	if x != nil {
		return x.ConversationalFilteringSpec
	}
	return nil
}

func (x *ConversationalSearchRequest) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

func (x *ConversationalSearchRequest) GetSafetySettings() []*SafetySetting {
	if x != nil {
		return x.SafetySettings
	}
	return nil
}

// Response message for
// [ConversationalSearchService.ConversationalSearch][google.cloud.retail.v2beta.ConversationalSearchService.ConversationalSearch]
// method.
type ConversationalSearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The types Retail classifies the search query as.
	//
	// Supported values are:
	//
	// - "ORDER_SUPPORT"
	// - "SIMPLE_PRODUCT_SEARCH"
	// - "INTENT_REFINEMENT"
	// - "PRODUCT_DETAILS"
	// - "PRODUCT_COMPARISON"
	// - "DEALS_AND_COUPONS"
	// - "STORE_RELEVANT"
	// - "BLOCKLISTED"
	// - "BEST_PRODUCT"
	// - "RETAIL_SUPPORT"
	// - "DISABLED"
	UserQueryTypes []string `protobuf:"bytes,10,rep,name=user_query_types,json=userQueryTypes,proto3" json:"user_query_types,omitempty"`
	// The conversational answer-based text response generated by the Server.
	ConversationalTextResponse string `protobuf:"bytes,2,opt,name=conversational_text_response,json=conversationalTextResponse,proto3" json:"conversational_text_response,omitempty"`
	// The conversational followup question generated for Intent refinement.
	FollowupQuestion *ConversationalSearchResponse_FollowupQuestion `protobuf:"bytes,3,opt,name=followup_question,json=followupQuestion,proto3" json:"followup_question,omitempty"`
	// Conversation UUID. This field will be stored in client side storage to
	// maintain the conversation session with server and will be used for next
	// search request's
	// [ConversationalSearchRequest.conversation_id][google.cloud.retail.v2beta.ConversationalSearchRequest.conversation_id]
	// to restore conversation state in server.
	ConversationId string `protobuf:"bytes,4,opt,name=conversation_id,json=conversationId,proto3" json:"conversation_id,omitempty"`
	// The proposed refined search queries. They can be used to fetch the relevant
	// search results. When using CONVERSATIONAL_FILTER_ONLY mode, the
	// refined_query from search response will be populated here.
	RefinedSearch []*ConversationalSearchResponse_RefinedSearch `protobuf:"bytes,6,rep,name=refined_search,json=refinedSearch,proto3" json:"refined_search,omitempty"`
	// This field specifies all related information that is needed on client
	// side for UI rendering of conversational filtering search.
	ConversationalFilteringResult *ConversationalSearchResponse_ConversationalFilteringResult `protobuf:"bytes,7,opt,name=conversational_filtering_result,json=conversationalFilteringResult,proto3" json:"conversational_filtering_result,omitempty"`
	// Output only. The state of the response generation.
	State ConversationalSearchResponse_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.retail.v2beta.ConversationalSearchResponse_State" json:"state,omitempty"`
}

func (x *ConversationalSearchResponse) Reset() {
	*x = ConversationalSearchResponse{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchResponse) ProtoMessage() {}

func (x *ConversationalSearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchResponse.ProtoReflect.Descriptor instead.
func (*ConversationalSearchResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{1}
}

func (x *ConversationalSearchResponse) GetUserQueryTypes() []string {
	if x != nil {
		return x.UserQueryTypes
	}
	return nil
}

func (x *ConversationalSearchResponse) GetConversationalTextResponse() string {
	if x != nil {
		return x.ConversationalTextResponse
	}
	return ""
}

func (x *ConversationalSearchResponse) GetFollowupQuestion() *ConversationalSearchResponse_FollowupQuestion {
	if x != nil {
		return x.FollowupQuestion
	}
	return nil
}

func (x *ConversationalSearchResponse) GetConversationId() string {
	if x != nil {
		return x.ConversationId
	}
	return ""
}

func (x *ConversationalSearchResponse) GetRefinedSearch() []*ConversationalSearchResponse_RefinedSearch {
	if x != nil {
		return x.RefinedSearch
	}
	return nil
}

func (x *ConversationalSearchResponse) GetConversationalFilteringResult() *ConversationalSearchResponse_ConversationalFilteringResult {
	if x != nil {
		return x.ConversationalFilteringResult
	}
	return nil
}

func (x *ConversationalSearchResponse) GetState() ConversationalSearchResponse_State {
	if x != nil {
		return x.State
	}
	return ConversationalSearchResponse_STATE_UNSPECIFIED
}

// Search parameters.
type ConversationalSearchRequest_SearchParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The filter string to restrict search results.
	//
	// The syntax of the filter string is the same as
	// [SearchRequest.filter][google.cloud.retail.v2beta.SearchRequest.filter].
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The canonical filter string to restrict search results.
	//
	// The syntax of the canonical filter string is the same as
	// [SearchRequest.canonical_filter][google.cloud.retail.v2beta.SearchRequest.canonical_filter].
	CanonicalFilter string `protobuf:"bytes,2,opt,name=canonical_filter,json=canonicalFilter,proto3" json:"canonical_filter,omitempty"`
	// Optional. The sort string to specify the sorting of search results.
	//
	// The syntax of the sort string is the same as
	// [SearchRequest.sort][].
	SortBy string `protobuf:"bytes,3,opt,name=sort_by,json=sortBy,proto3" json:"sort_by,omitempty"`
	// Optional. The boost spec to specify the boosting of search results.
	//
	// The syntax of the boost spec is the same as
	// [SearchRequest.boost_spec][google.cloud.retail.v2beta.SearchRequest.boost_spec].
	BoostSpec *SearchRequest_BoostSpec `protobuf:"bytes,4,opt,name=boost_spec,json=boostSpec,proto3" json:"boost_spec,omitempty"`
}

func (x *ConversationalSearchRequest_SearchParams) Reset() {
	*x = ConversationalSearchRequest_SearchParams{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchRequest_SearchParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchRequest_SearchParams) ProtoMessage() {}

func (x *ConversationalSearchRequest_SearchParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchRequest_SearchParams.ProtoReflect.Descriptor instead.
func (*ConversationalSearchRequest_SearchParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ConversationalSearchRequest_SearchParams) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ConversationalSearchRequest_SearchParams) GetCanonicalFilter() string {
	if x != nil {
		return x.CanonicalFilter
	}
	return ""
}

func (x *ConversationalSearchRequest_SearchParams) GetSortBy() string {
	if x != nil {
		return x.SortBy
	}
	return ""
}

func (x *ConversationalSearchRequest_SearchParams) GetBoostSpec() *SearchRequest_BoostSpec {
	if x != nil {
		return x.BoostSpec
	}
	return nil
}

// This field specifies the current user answer during the conversational
// filtering search. This can be either user selected from suggested answers
// or user input plain text.
type ConversationalSearchRequest_UserAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field specifies the type of user answer.
	//
	// Types that are assignable to Type:
	//
	//	*ConversationalSearchRequest_UserAnswer_TextAnswer
	//	*ConversationalSearchRequest_UserAnswer_SelectedAnswer_
	Type isConversationalSearchRequest_UserAnswer_Type `protobuf_oneof:"type"`
}

func (x *ConversationalSearchRequest_UserAnswer) Reset() {
	*x = ConversationalSearchRequest_UserAnswer{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchRequest_UserAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchRequest_UserAnswer) ProtoMessage() {}

func (x *ConversationalSearchRequest_UserAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchRequest_UserAnswer.ProtoReflect.Descriptor instead.
func (*ConversationalSearchRequest_UserAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{0, 1}
}

func (m *ConversationalSearchRequest_UserAnswer) GetType() isConversationalSearchRequest_UserAnswer_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *ConversationalSearchRequest_UserAnswer) GetTextAnswer() string {
	if x, ok := x.GetType().(*ConversationalSearchRequest_UserAnswer_TextAnswer); ok {
		return x.TextAnswer
	}
	return ""
}

func (x *ConversationalSearchRequest_UserAnswer) GetSelectedAnswer() *ConversationalSearchRequest_UserAnswer_SelectedAnswer {
	if x, ok := x.GetType().(*ConversationalSearchRequest_UserAnswer_SelectedAnswer_); ok {
		return x.SelectedAnswer
	}
	return nil
}

type isConversationalSearchRequest_UserAnswer_Type interface {
	isConversationalSearchRequest_UserAnswer_Type()
}

type ConversationalSearchRequest_UserAnswer_TextAnswer struct {
	// This field specifies the incremental input text from the user during
	// the conversational search.
	TextAnswer string `protobuf:"bytes,1,opt,name=text_answer,json=textAnswer,proto3,oneof"`
}

type ConversationalSearchRequest_UserAnswer_SelectedAnswer_ struct {
	// Optional. This field specifies the selected answer during the
	// conversational search. This should be a subset of
	// [ConversationalSearchResponse.followup_question.suggested_answers][].
	SelectedAnswer *ConversationalSearchRequest_UserAnswer_SelectedAnswer `protobuf:"bytes,2,opt,name=selected_answer,json=selectedAnswer,proto3,oneof"`
}

func (*ConversationalSearchRequest_UserAnswer_TextAnswer) isConversationalSearchRequest_UserAnswer_Type() {
}

func (*ConversationalSearchRequest_UserAnswer_SelectedAnswer_) isConversationalSearchRequest_UserAnswer_Type() {
}

// This field specifies all conversational filtering related parameters
// addition to conversational retail search.
type ConversationalSearchRequest_ConversationalFilteringSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. This field is deprecated. Please use
	// [ConversationalFilteringSpec.conversational_filtering_mode][google.cloud.retail.v2beta.ConversationalSearchRequest.ConversationalFilteringSpec.conversational_filtering_mode]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/retail/v2beta/conversational_search_service.proto.
	EnableConversationalFiltering bool `protobuf:"varint,1,opt,name=enable_conversational_filtering,json=enableConversationalFiltering,proto3" json:"enable_conversational_filtering,omitempty"`
	// Optional. This field specifies the current user answer during the
	// conversational filtering search. It can be either user selected from
	// suggested answers or user input plain text.
	UserAnswer *ConversationalSearchRequest_UserAnswer `protobuf:"bytes,2,opt,name=user_answer,json=userAnswer,proto3" json:"user_answer,omitempty"`
	// Optional. Mode to control Conversational Filtering.
	// Defaults to
	// [Mode.DISABLED][google.cloud.retail.v2beta.ConversationalSearchRequest.ConversationalFilteringSpec.Mode.DISABLED]
	// if it's unset.
	ConversationalFilteringMode ConversationalSearchRequest_ConversationalFilteringSpec_Mode `protobuf:"varint,4,opt,name=conversational_filtering_mode,json=conversationalFilteringMode,proto3,enum=google.cloud.retail.v2beta.ConversationalSearchRequest_ConversationalFilteringSpec_Mode" json:"conversational_filtering_mode,omitempty"`
}

func (x *ConversationalSearchRequest_ConversationalFilteringSpec) Reset() {
	*x = ConversationalSearchRequest_ConversationalFilteringSpec{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchRequest_ConversationalFilteringSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchRequest_ConversationalFilteringSpec) ProtoMessage() {}

func (x *ConversationalSearchRequest_ConversationalFilteringSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchRequest_ConversationalFilteringSpec.ProtoReflect.Descriptor instead.
func (*ConversationalSearchRequest_ConversationalFilteringSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{0, 2}
}

// Deprecated: Marked as deprecated in google/cloud/retail/v2beta/conversational_search_service.proto.
func (x *ConversationalSearchRequest_ConversationalFilteringSpec) GetEnableConversationalFiltering() bool {
	if x != nil {
		return x.EnableConversationalFiltering
	}
	return false
}

func (x *ConversationalSearchRequest_ConversationalFilteringSpec) GetUserAnswer() *ConversationalSearchRequest_UserAnswer {
	if x != nil {
		return x.UserAnswer
	}
	return nil
}

func (x *ConversationalSearchRequest_ConversationalFilteringSpec) GetConversationalFilteringMode() ConversationalSearchRequest_ConversationalFilteringSpec_Mode {
	if x != nil {
		return x.ConversationalFilteringMode
	}
	return ConversationalSearchRequest_ConversationalFilteringSpec_MODE_UNSPECIFIED
}

// This field specifies the selected answers during the conversational
// search.
type ConversationalSearchRequest_UserAnswer_SelectedAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. This field specifies the selected answer which is a attribute
	// key-value.
	ProductAttributeValue *ProductAttributeValue `protobuf:"bytes,1,opt,name=product_attribute_value,json=productAttributeValue,proto3" json:"product_attribute_value,omitempty"`
}

func (x *ConversationalSearchRequest_UserAnswer_SelectedAnswer) Reset() {
	*x = ConversationalSearchRequest_UserAnswer_SelectedAnswer{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchRequest_UserAnswer_SelectedAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchRequest_UserAnswer_SelectedAnswer) ProtoMessage() {}

func (x *ConversationalSearchRequest_UserAnswer_SelectedAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchRequest_UserAnswer_SelectedAnswer.ProtoReflect.Descriptor instead.
func (*ConversationalSearchRequest_UserAnswer_SelectedAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *ConversationalSearchRequest_UserAnswer_SelectedAnswer) GetProductAttributeValue() *ProductAttributeValue {
	if x != nil {
		return x.ProductAttributeValue
	}
	return nil
}

// The conversational followup question generated for Intent refinement.
type ConversationalSearchResponse_FollowupQuestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The conversational followup question generated for Intent refinement.
	FollowupQuestion string `protobuf:"bytes,1,opt,name=followup_question,json=followupQuestion,proto3" json:"followup_question,omitempty"`
	// The answer options provided to client for the follow-up question.
	SuggestedAnswers []*ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer `protobuf:"bytes,2,rep,name=suggested_answers,json=suggestedAnswers,proto3" json:"suggested_answers,omitempty"`
}

func (x *ConversationalSearchResponse_FollowupQuestion) Reset() {
	*x = ConversationalSearchResponse_FollowupQuestion{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchResponse_FollowupQuestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchResponse_FollowupQuestion) ProtoMessage() {}

func (x *ConversationalSearchResponse_FollowupQuestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchResponse_FollowupQuestion.ProtoReflect.Descriptor instead.
func (*ConversationalSearchResponse_FollowupQuestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ConversationalSearchResponse_FollowupQuestion) GetFollowupQuestion() string {
	if x != nil {
		return x.FollowupQuestion
	}
	return ""
}

func (x *ConversationalSearchResponse_FollowupQuestion) GetSuggestedAnswers() []*ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer {
	if x != nil {
		return x.SuggestedAnswers
	}
	return nil
}

// The proposed refined search for intent-refinement/bundled shopping
// conversation. When using CONVERSATIONAL_FILTER_ONLY mode, the
// refined_query from search response will be populated here.
type ConversationalSearchResponse_RefinedSearch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The query to be used for search.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *ConversationalSearchResponse_RefinedSearch) Reset() {
	*x = ConversationalSearchResponse_RefinedSearch{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchResponse_RefinedSearch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchResponse_RefinedSearch) ProtoMessage() {}

func (x *ConversationalSearchResponse_RefinedSearch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchResponse_RefinedSearch.ProtoReflect.Descriptor instead.
func (*ConversationalSearchResponse_RefinedSearch) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{1, 1}
}

func (x *ConversationalSearchResponse_RefinedSearch) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

// This field specifies all related information that is needed on client
// side for UI rendering of conversational filtering search.
type ConversationalSearchResponse_ConversationalFilteringResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The conversational filtering question.
	FollowupQuestion *ConversationalSearchResponse_FollowupQuestion `protobuf:"bytes,1,opt,name=followup_question,json=followupQuestion,proto3" json:"followup_question,omitempty"`
	// This is the incremental additional filters implied from the current
	// user answer. User should add the suggested addition filters to the
	// previous [ConversationalSearchRequest.search_params.filter][] and
	// [SearchRequest.filter][google.cloud.retail.v2beta.SearchRequest.filter],
	// and use the merged filter in the follow up requests.
	AdditionalFilter *ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter `protobuf:"bytes,2,opt,name=additional_filter,json=additionalFilter,proto3" json:"additional_filter,omitempty"`
}

func (x *ConversationalSearchResponse_ConversationalFilteringResult) Reset() {
	*x = ConversationalSearchResponse_ConversationalFilteringResult{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchResponse_ConversationalFilteringResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchResponse_ConversationalFilteringResult) ProtoMessage() {}

func (x *ConversationalSearchResponse_ConversationalFilteringResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchResponse_ConversationalFilteringResult.ProtoReflect.Descriptor instead.
func (*ConversationalSearchResponse_ConversationalFilteringResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{1, 2}
}

func (x *ConversationalSearchResponse_ConversationalFilteringResult) GetFollowupQuestion() *ConversationalSearchResponse_FollowupQuestion {
	if x != nil {
		return x.FollowupQuestion
	}
	return nil
}

func (x *ConversationalSearchResponse_ConversationalFilteringResult) GetAdditionalFilter() *ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter {
	if x != nil {
		return x.AdditionalFilter
	}
	return nil
}

// Suggested answers to the follow-up question.
// If it's numerical attribute, only ProductAttributeInterval will be set.
// If it's textual attribute, only productAttributeValue will be set.
type ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Product attribute value, including an attribute key and an
	// attribute value. Other types can be added here in the future.
	ProductAttributeValue *ProductAttributeValue `protobuf:"bytes,1,opt,name=product_attribute_value,json=productAttributeValue,proto3" json:"product_attribute_value,omitempty"`
}

func (x *ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer) Reset() {
	*x = ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer) ProtoMessage() {}

func (x *ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer.ProtoReflect.Descriptor instead.
func (*ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer) GetProductAttributeValue() *ProductAttributeValue {
	if x != nil {
		return x.ProductAttributeValue
	}
	return nil
}

// Additional filter that client side need to apply.
type ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Product attribute value, including an attribute key and an
	// attribute value. Other types can be added here in the future.
	ProductAttributeValue *ProductAttributeValue `protobuf:"bytes,1,opt,name=product_attribute_value,json=productAttributeValue,proto3" json:"product_attribute_value,omitempty"`
}

func (x *ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter) Reset() {
	*x = ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter{}
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter) ProtoMessage() {}

func (x *ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter.ProtoReflect.Descriptor instead.
func (*ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP(), []int{1, 2, 0}
}

func (x *ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter) GetProductAttributeValue() *ProductAttributeValue {
	if x != nil {
		return x.ProductAttributeValue
	}
	return nil
}

var File_google_cloud_retail_v2beta_conversational_search_service_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xe3, 0x0e, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x62, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2c,
	0x0a, 0x0f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x61,
	0x67, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x0f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x6e, 0x0a, 0x0d, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x76, 0x69,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x76, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x46,
	0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55,
	0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x9c, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53,
	0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6d, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x57, 0x0a, 0x0f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0xd2, 0x01,
	0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x1b,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x10, 0x63,
	0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x61, 0x6e, 0x6f,
	0x6e, 0x69, 0x63, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x07, 0x73,
	0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x73, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x12, 0x57, 0x0a, 0x0a, 0x62, 0x6f, 0x6f,
	0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x1a, 0xbe, 0x02, 0x0a, 0x0a, 0x55, 0x73, 0x65, 0x72, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x12, 0x21, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x1a, 0x80, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x6e, 0x0a, 0x17, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x1a, 0xd3, 0x03, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x4d, 0x0a, 0x1f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x05, 0xe0, 0x41,
	0x01, 0x18, 0x01, 0x52, 0x1d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x12, 0x68, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0xa1, 0x01, 0x0a,
	0x1d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x1b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65,
	0x22, 0x57, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4f, 0x4e,
	0x56, 0x45, 0x52, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x46, 0x49, 0x4c, 0x54,
	0x45, 0x52, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x03, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xf4, 0x0b, 0x0a, 0x1c, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x1c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x54, 0x65, 0x78, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x76, 0x0a, 0x11, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75,
	0x70, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x6f, 0x6c, 0x6c, 0x6f,
	0x77, 0x75, 0x70, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x66, 0x6f, 0x6c,
	0x6c, 0x6f, 0x77, 0x75, 0x70, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a,
	0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x6d, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x69, 0x6e, 0x65,
	0x64, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x0d, 0x72, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x9e, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x1d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x59, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x1a, 0xc6, 0x02, 0x0a, 0x10, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77,
	0x75, 0x70, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x51, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x86, 0x01, 0x0a, 0x11, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77,
	0x75, 0x70, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x10, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x1a, 0x7c, 0x0a, 0x0f,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12,
	0x69, 0x0a, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x15, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x25, 0x0a, 0x0d, 0x52, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x1a, 0xad, 0x03, 0x0a, 0x1d, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x76, 0x0a, 0x11, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x5f,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75,
	0x70, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
	0x77, 0x75, 0x70, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x94, 0x01, 0x0a, 0x11,
	0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x10, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x1a, 0x7d, 0x0a, 0x10, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x69, 0x0a, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x3c, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x32,
	0xbe, 0x03, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0xd3, 0x02, 0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc5, 0x01, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0xbe, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x60, 0x3a, 0x01, 0x2a, 0x22, 0x5b, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x57, 0x2f, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x30, 0x01, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xdf, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x42, 0x20, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2,
	0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56,
	0x32, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32, 0x62, 0x65,
	0x74, 0x61, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescData = file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDesc
)

func file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescData)
	})
	return file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDescData
}

var file_google_cloud_retail_v2beta_conversational_search_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_retail_v2beta_conversational_search_service_proto_goTypes = []any{
	(ConversationalSearchRequest_ConversationalFilteringSpec_Mode)(0), // 0: google.cloud.retail.v2beta.ConversationalSearchRequest.ConversationalFilteringSpec.Mode
	(ConversationalSearchResponse_State)(0),                           // 1: google.cloud.retail.v2beta.ConversationalSearchResponse.State
	(*ConversationalSearchRequest)(nil),                               // 2: google.cloud.retail.v2beta.ConversationalSearchRequest
	(*ConversationalSearchResponse)(nil),                              // 3: google.cloud.retail.v2beta.ConversationalSearchResponse
	(*ConversationalSearchRequest_SearchParams)(nil),                  // 4: google.cloud.retail.v2beta.ConversationalSearchRequest.SearchParams
	(*ConversationalSearchRequest_UserAnswer)(nil),                    // 5: google.cloud.retail.v2beta.ConversationalSearchRequest.UserAnswer
	(*ConversationalSearchRequest_ConversationalFilteringSpec)(nil),   // 6: google.cloud.retail.v2beta.ConversationalSearchRequest.ConversationalFilteringSpec
	nil, // 7: google.cloud.retail.v2beta.ConversationalSearchRequest.UserLabelsEntry
	(*ConversationalSearchRequest_UserAnswer_SelectedAnswer)(nil),                       // 8: google.cloud.retail.v2beta.ConversationalSearchRequest.UserAnswer.SelectedAnswer
	(*ConversationalSearchResponse_FollowupQuestion)(nil),                               // 9: google.cloud.retail.v2beta.ConversationalSearchResponse.FollowupQuestion
	(*ConversationalSearchResponse_RefinedSearch)(nil),                                  // 10: google.cloud.retail.v2beta.ConversationalSearchResponse.RefinedSearch
	(*ConversationalSearchResponse_ConversationalFilteringResult)(nil),                  // 11: google.cloud.retail.v2beta.ConversationalSearchResponse.ConversationalFilteringResult
	(*ConversationalSearchResponse_FollowupQuestion_SuggestedAnswer)(nil),               // 12: google.cloud.retail.v2beta.ConversationalSearchResponse.FollowupQuestion.SuggestedAnswer
	(*ConversationalSearchResponse_ConversationalFilteringResult_AdditionalFilter)(nil), // 13: google.cloud.retail.v2beta.ConversationalSearchResponse.ConversationalFilteringResult.AdditionalFilter
	(*UserInfo)(nil),                // 14: google.cloud.retail.v2beta.UserInfo
	(*SafetySetting)(nil),           // 15: google.cloud.retail.v2beta.SafetySetting
	(*SearchRequest_BoostSpec)(nil), // 16: google.cloud.retail.v2beta.SearchRequest.BoostSpec
	(*ProductAttributeValue)(nil),   // 17: google.cloud.retail.v2beta.ProductAttributeValue
}
var file_google_cloud_retail_v2beta_conversational_search_service_proto_depIdxs = []int32{
	4,  // 0: google.cloud.retail.v2beta.ConversationalSearchRequest.search_params:type_name -> google.cloud.retail.v2beta.ConversationalSearchRequest.SearchParams
	14, // 1: google.cloud.retail.v2beta.ConversationalSearchRequest.user_info:type_name -> google.cloud.retail.v2beta.UserInfo
	6,  // 2: google.cloud.retail.v2beta.ConversationalSearchRequest.conversational_filtering_spec:type_name -> google.cloud.retail.v2beta.ConversationalSearchRequest.ConversationalFilteringSpec
	7,  // 3: google.cloud.retail.v2beta.ConversationalSearchRequest.user_labels:type_name -> google.cloud.retail.v2beta.ConversationalSearchRequest.UserLabelsEntry
	15, // 4: google.cloud.retail.v2beta.ConversationalSearchRequest.safety_settings:type_name -> google.cloud.retail.v2beta.SafetySetting
	9,  // 5: google.cloud.retail.v2beta.ConversationalSearchResponse.followup_question:type_name -> google.cloud.retail.v2beta.ConversationalSearchResponse.FollowupQuestion
	10, // 6: google.cloud.retail.v2beta.ConversationalSearchResponse.refined_search:type_name -> google.cloud.retail.v2beta.ConversationalSearchResponse.RefinedSearch
	11, // 7: google.cloud.retail.v2beta.ConversationalSearchResponse.conversational_filtering_result:type_name -> google.cloud.retail.v2beta.ConversationalSearchResponse.ConversationalFilteringResult
	1,  // 8: google.cloud.retail.v2beta.ConversationalSearchResponse.state:type_name -> google.cloud.retail.v2beta.ConversationalSearchResponse.State
	16, // 9: google.cloud.retail.v2beta.ConversationalSearchRequest.SearchParams.boost_spec:type_name -> google.cloud.retail.v2beta.SearchRequest.BoostSpec
	8,  // 10: google.cloud.retail.v2beta.ConversationalSearchRequest.UserAnswer.selected_answer:type_name -> google.cloud.retail.v2beta.ConversationalSearchRequest.UserAnswer.SelectedAnswer
	5,  // 11: google.cloud.retail.v2beta.ConversationalSearchRequest.ConversationalFilteringSpec.user_answer:type_name -> google.cloud.retail.v2beta.ConversationalSearchRequest.UserAnswer
	0,  // 12: google.cloud.retail.v2beta.ConversationalSearchRequest.ConversationalFilteringSpec.conversational_filtering_mode:type_name -> google.cloud.retail.v2beta.ConversationalSearchRequest.ConversationalFilteringSpec.Mode
	17, // 13: google.cloud.retail.v2beta.ConversationalSearchRequest.UserAnswer.SelectedAnswer.product_attribute_value:type_name -> google.cloud.retail.v2beta.ProductAttributeValue
	12, // 14: google.cloud.retail.v2beta.ConversationalSearchResponse.FollowupQuestion.suggested_answers:type_name -> google.cloud.retail.v2beta.ConversationalSearchResponse.FollowupQuestion.SuggestedAnswer
	9,  // 15: google.cloud.retail.v2beta.ConversationalSearchResponse.ConversationalFilteringResult.followup_question:type_name -> google.cloud.retail.v2beta.ConversationalSearchResponse.FollowupQuestion
	13, // 16: google.cloud.retail.v2beta.ConversationalSearchResponse.ConversationalFilteringResult.additional_filter:type_name -> google.cloud.retail.v2beta.ConversationalSearchResponse.ConversationalFilteringResult.AdditionalFilter
	17, // 17: google.cloud.retail.v2beta.ConversationalSearchResponse.FollowupQuestion.SuggestedAnswer.product_attribute_value:type_name -> google.cloud.retail.v2beta.ProductAttributeValue
	17, // 18: google.cloud.retail.v2beta.ConversationalSearchResponse.ConversationalFilteringResult.AdditionalFilter.product_attribute_value:type_name -> google.cloud.retail.v2beta.ProductAttributeValue
	2,  // 19: google.cloud.retail.v2beta.ConversationalSearchService.ConversationalSearch:input_type -> google.cloud.retail.v2beta.ConversationalSearchRequest
	3,  // 20: google.cloud.retail.v2beta.ConversationalSearchService.ConversationalSearch:output_type -> google.cloud.retail.v2beta.ConversationalSearchResponse
	20, // [20:21] is the sub-list for method output_type
	19, // [19:20] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2beta_conversational_search_service_proto_init() }
func file_google_cloud_retail_v2beta_conversational_search_service_proto_init() {
	if File_google_cloud_retail_v2beta_conversational_search_service_proto != nil {
		return
	}
	file_google_cloud_retail_v2beta_common_proto_init()
	file_google_cloud_retail_v2beta_safety_proto_init()
	file_google_cloud_retail_v2beta_search_service_proto_init()
	file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes[3].OneofWrappers = []any{
		(*ConversationalSearchRequest_UserAnswer_TextAnswer)(nil),
		(*ConversationalSearchRequest_UserAnswer_SelectedAnswer_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_retail_v2beta_conversational_search_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2beta_conversational_search_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_retail_v2beta_conversational_search_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_retail_v2beta_conversational_search_service_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2beta_conversational_search_service_proto = out.File
	file_google_cloud_retail_v2beta_conversational_search_service_proto_rawDesc = nil
	file_google_cloud_retail_v2beta_conversational_search_service_proto_goTypes = nil
	file_google_cloud_retail_v2beta_conversational_search_service_proto_depIdxs = nil
}
