// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/maps/areainsights/v1/area_insights_service.proto

package areainsightspb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AreaInsights_ComputeInsights_FullMethodName = "/google.maps.areainsights.v1.AreaInsights/ComputeInsights"
)

// AreaInsightsClient is the client API for AreaInsights service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AreaInsightsClient interface {
	// This method lets you retrieve insights about areas using a variety of
	// filter such as: area, place type, operating status, price level
	// and ratings. Currently "count" and "places" insights are supported. With
	// "count" insights you can answer questions such as "How many restaurant are
	// located in California that are operational, are inexpensive and have an
	// average rating of at least 4 stars" (see `insight` enum for more details).
	// With "places" insights, you can determine which places match the
	// requested filter. Clients can then use those place resource names to fetch
	// more details about each individual place using the Places API.
	ComputeInsights(ctx context.Context, in *ComputeInsightsRequest, opts ...grpc.CallOption) (*ComputeInsightsResponse, error)
}

type areaInsightsClient struct {
	cc grpc.ClientConnInterface
}

func NewAreaInsightsClient(cc grpc.ClientConnInterface) AreaInsightsClient {
	return &areaInsightsClient{cc}
}

func (c *areaInsightsClient) ComputeInsights(ctx context.Context, in *ComputeInsightsRequest, opts ...grpc.CallOption) (*ComputeInsightsResponse, error) {
	out := new(ComputeInsightsResponse)
	err := c.cc.Invoke(ctx, AreaInsights_ComputeInsights_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AreaInsightsServer is the server API for AreaInsights service.
// All implementations should embed UnimplementedAreaInsightsServer
// for forward compatibility
type AreaInsightsServer interface {
	// This method lets you retrieve insights about areas using a variety of
	// filter such as: area, place type, operating status, price level
	// and ratings. Currently "count" and "places" insights are supported. With
	// "count" insights you can answer questions such as "How many restaurant are
	// located in California that are operational, are inexpensive and have an
	// average rating of at least 4 stars" (see `insight` enum for more details).
	// With "places" insights, you can determine which places match the
	// requested filter. Clients can then use those place resource names to fetch
	// more details about each individual place using the Places API.
	ComputeInsights(context.Context, *ComputeInsightsRequest) (*ComputeInsightsResponse, error)
}

// UnimplementedAreaInsightsServer should be embedded to have forward compatible implementations.
type UnimplementedAreaInsightsServer struct {
}

func (UnimplementedAreaInsightsServer) ComputeInsights(context.Context, *ComputeInsightsRequest) (*ComputeInsightsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeInsights not implemented")
}

// UnsafeAreaInsightsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AreaInsightsServer will
// result in compilation errors.
type UnsafeAreaInsightsServer interface {
	mustEmbedUnimplementedAreaInsightsServer()
}

func RegisterAreaInsightsServer(s grpc.ServiceRegistrar, srv AreaInsightsServer) {
	s.RegisterService(&AreaInsights_ServiceDesc, srv)
}

func _AreaInsights_ComputeInsights_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeInsightsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AreaInsightsServer).ComputeInsights(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AreaInsights_ComputeInsights_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AreaInsightsServer).ComputeInsights(ctx, req.(*ComputeInsightsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AreaInsights_ServiceDesc is the grpc.ServiceDesc for AreaInsights service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AreaInsights_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.areainsights.v1.AreaInsights",
	HandlerType: (*AreaInsightsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ComputeInsights",
			Handler:    _AreaInsights_ComputeInsights_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/areainsights/v1/area_insights_service.proto",
}
