// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/maps/addressvalidation/v1/address_validation_service.proto

package addressvalidationpb

import (
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	postaladdress "google.golang.org/genproto/googleapis/type/postaladdress"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The possible final outcomes of the sequence of address validation requests
// needed to validate an address.
type ProvideValidationFeedbackRequest_ValidationConclusion int32

const (
	// This value is unused.
	// If the `ProvideValidationFeedbackRequest.conclusion` field is set to
	// `VALIDATION_CONCLUSION_UNSPECIFIED`, an `INVALID_ARGUMENT` error will be
	// returned.
	ProvideValidationFeedbackRequest_VALIDATION_CONCLUSION_UNSPECIFIED ProvideValidationFeedbackRequest_ValidationConclusion = 0
	// The version of the address returned by the Address Validation API was
	// used for the transaction.
	ProvideValidationFeedbackRequest_VALIDATED_VERSION_USED ProvideValidationFeedbackRequest_ValidationConclusion = 1
	// The version of the address provided by the user was used for the
	// transaction
	ProvideValidationFeedbackRequest_USER_VERSION_USED ProvideValidationFeedbackRequest_ValidationConclusion = 2
	// A version of the address that was entered after the last validation
	// attempt but that was not re-validated was used for the transaction.
	ProvideValidationFeedbackRequest_UNVALIDATED_VERSION_USED ProvideValidationFeedbackRequest_ValidationConclusion = 3
	// The transaction was abandoned and the address was not used.
	ProvideValidationFeedbackRequest_UNUSED ProvideValidationFeedbackRequest_ValidationConclusion = 4
)

// Enum value maps for ProvideValidationFeedbackRequest_ValidationConclusion.
var (
	ProvideValidationFeedbackRequest_ValidationConclusion_name = map[int32]string{
		0: "VALIDATION_CONCLUSION_UNSPECIFIED",
		1: "VALIDATED_VERSION_USED",
		2: "USER_VERSION_USED",
		3: "UNVALIDATED_VERSION_USED",
		4: "UNUSED",
	}
	ProvideValidationFeedbackRequest_ValidationConclusion_value = map[string]int32{
		"VALIDATION_CONCLUSION_UNSPECIFIED": 0,
		"VALIDATED_VERSION_USED":            1,
		"USER_VERSION_USED":                 2,
		"UNVALIDATED_VERSION_USED":          3,
		"UNUSED":                            4,
	}
)

func (x ProvideValidationFeedbackRequest_ValidationConclusion) Enum() *ProvideValidationFeedbackRequest_ValidationConclusion {
	p := new(ProvideValidationFeedbackRequest_ValidationConclusion)
	*p = x
	return p
}

func (x ProvideValidationFeedbackRequest_ValidationConclusion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProvideValidationFeedbackRequest_ValidationConclusion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_enumTypes[0].Descriptor()
}

func (ProvideValidationFeedbackRequest_ValidationConclusion) Type() protoreflect.EnumType {
	return &file_google_maps_addressvalidation_v1_address_validation_service_proto_enumTypes[0]
}

func (x ProvideValidationFeedbackRequest_ValidationConclusion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProvideValidationFeedbackRequest_ValidationConclusion.Descriptor instead.
func (ProvideValidationFeedbackRequest_ValidationConclusion) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescGZIP(), []int{2, 0}
}

// The various granularities that an address or a geocode can have.
// When used to indicate granularity for an *address*, these values indicate
// with how fine a granularity the address identifies a mailing destination.
// For example, an address such as "123 Main Street, Redwood City, CA, 94061"
// identifies a `PREMISE` while something like "Redwood City, CA, 94061"
// identifies a `LOCALITY`. However, if we are unable to find a geocode for
// "123 Main Street" in Redwood City, the geocode returned might be of
// `LOCALITY` granularity even though the address is more granular.
type Verdict_Granularity int32

const (
	// Default value. This value is unused.
	Verdict_GRANULARITY_UNSPECIFIED Verdict_Granularity = 0
	// Below-building level result, such as an apartment.
	Verdict_SUB_PREMISE Verdict_Granularity = 1
	// Building-level result.
	Verdict_PREMISE Verdict_Granularity = 2
	// A geocode that approximates the building-level location of the address.
	Verdict_PREMISE_PROXIMITY Verdict_Granularity = 3
	// The address or geocode indicates a block. Only used in regions which
	// have block-level addressing, such as Japan.
	Verdict_BLOCK Verdict_Granularity = 4
	// The geocode or address is granular to route, such as a street, road, or
	// highway.
	Verdict_ROUTE Verdict_Granularity = 5
	// All other granularities, which are bucketed together since they are not
	// deliverable.
	Verdict_OTHER Verdict_Granularity = 6
)

// Enum value maps for Verdict_Granularity.
var (
	Verdict_Granularity_name = map[int32]string{
		0: "GRANULARITY_UNSPECIFIED",
		1: "SUB_PREMISE",
		2: "PREMISE",
		3: "PREMISE_PROXIMITY",
		4: "BLOCK",
		5: "ROUTE",
		6: "OTHER",
	}
	Verdict_Granularity_value = map[string]int32{
		"GRANULARITY_UNSPECIFIED": 0,
		"SUB_PREMISE":             1,
		"PREMISE":                 2,
		"PREMISE_PROXIMITY":       3,
		"BLOCK":                   4,
		"ROUTE":                   5,
		"OTHER":                   6,
	}
)

func (x Verdict_Granularity) Enum() *Verdict_Granularity {
	p := new(Verdict_Granularity)
	*p = x
	return p
}

func (x Verdict_Granularity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Verdict_Granularity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_enumTypes[1].Descriptor()
}

func (Verdict_Granularity) Type() protoreflect.EnumType {
	return &file_google_maps_addressvalidation_v1_address_validation_service_proto_enumTypes[1]
}

func (x Verdict_Granularity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Verdict_Granularity.Descriptor instead.
func (Verdict_Granularity) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescGZIP(), []int{5, 0}
}

// The request for validating an address.
type ValidateAddressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The address being validated. Unformatted addresses should be
	// submitted via [`address_lines`][google.type.PostalAddress.address_lines].
	//
	// The total length of the fields in this input must not exceed 280
	// characters.
	//
	// Supported regions can be found
	// [here](https://developers.google.com/maps/documentation/address-validation/coverage).
	//
	// The [language_code][google.type.PostalAddress.language_code] value in the
	// input address is reserved for future uses and is ignored today. The
	// validated address result will be populated based on the preferred language
	// for the given address, as identified by the system.
	//
	// The Address Validation API ignores the values in
	// [recipients][google.type.PostalAddress.recipients] and
	// [organization][google.type.PostalAddress.organization]. Any values in those
	// fields will be discarded and not returned. Please do not set them.
	Address *postaladdress.PostalAddress `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// This field must be empty for the first address validation request. If
	// more requests are necessary to fully validate a single address (for
	// example if the changes the user makes after the initial validation need to
	// be re-validated), then each followup request must populate this field with
	// the
	// [response_id][google.maps.addressvalidation.v1.ValidateAddressResponse.response_id]
	// from the very first response in the validation sequence.
	PreviousResponseId string `protobuf:"bytes,2,opt,name=previous_response_id,json=previousResponseId,proto3" json:"previous_response_id,omitempty"`
	// Enables USPS CASS compatible mode. This affects _only_ the
	// [google.maps.addressvalidation.v1.ValidationResult.usps_data] field of
	// [google.maps.addressvalidation.v1.ValidationResult]. Note: for USPS CASS
	// enabled requests for addresses in Puerto Rico, a
	// [google.type.PostalAddress.region_code] of the `address` must be provided
	// as "PR", or an [google.type.PostalAddress.administrative_area] of the
	// `address` must be provided as "Puerto Rico" (case-insensitive) or "PR".
	//
	// It's recommended to use a componentized `address`, or alternatively specify
	// at least two [google.type.PostalAddress.address_lines] where the first line
	// contains the street number and name and the second line contains the city,
	// state, and zip code.
	EnableUspsCass bool `protobuf:"varint,3,opt,name=enable_usps_cass,json=enableUspsCass,proto3" json:"enable_usps_cass,omitempty"`
	// Optional. A string which identifies an Autocomplete session for billing
	// purposes. Must be a URL and filename safe base64 string with at most 36
	// ASCII characters in length. Otherwise an INVALID_ARGUMENT error is
	// returned.
	//
	// The session begins when the user starts typing a query, and concludes when
	// they select a place and a call to Place Details or Address Validation is
	// made. Each session can have multiple autocomplete queries, followed by one
	// Place Details or Address Validation request. The credentials used for each
	// request within a session must belong to the same Google Cloud Console
	// project. Once a session has concluded, the token is no longer valid; your
	// app must generate a fresh token for each session. If the `session_token`
	// parameter is omitted, or if you reuse a session token, the session is
	// charged as if no session token was provided (each request is billed
	// separately).
	//
	// Note: Address Validation can only be used in sessions with the
	// Autocomplete (New) API, not the old Autocomplete API. See
	// https://developers.google.com/maps/documentation/places/web-service/session-pricing
	// for more details.
	SessionToken string `protobuf:"bytes,5,opt,name=session_token,json=sessionToken,proto3" json:"session_token,omitempty"`
}

func (x *ValidateAddressRequest) Reset() {
	*x = ValidateAddressRequest{}
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateAddressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateAddressRequest) ProtoMessage() {}

func (x *ValidateAddressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateAddressRequest.ProtoReflect.Descriptor instead.
func (*ValidateAddressRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescGZIP(), []int{0}
}

func (x *ValidateAddressRequest) GetAddress() *postaladdress.PostalAddress {
	if x != nil {
		return x.Address
	}
	return nil
}

func (x *ValidateAddressRequest) GetPreviousResponseId() string {
	if x != nil {
		return x.PreviousResponseId
	}
	return ""
}

func (x *ValidateAddressRequest) GetEnableUspsCass() bool {
	if x != nil {
		return x.EnableUspsCass
	}
	return false
}

func (x *ValidateAddressRequest) GetSessionToken() string {
	if x != nil {
		return x.SessionToken
	}
	return ""
}

// The response to an address validation request.
type ValidateAddressResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of the address validation.
	Result *ValidationResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	// The UUID that identifies this response. If the address needs to be
	// re-validated, this UUID *must* accompany the new request.
	ResponseId string `protobuf:"bytes,2,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
}

func (x *ValidateAddressResponse) Reset() {
	*x = ValidateAddressResponse{}
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateAddressResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateAddressResponse) ProtoMessage() {}

func (x *ValidateAddressResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateAddressResponse.ProtoReflect.Descriptor instead.
func (*ValidateAddressResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescGZIP(), []int{1}
}

func (x *ValidateAddressResponse) GetResult() *ValidationResult {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *ValidateAddressResponse) GetResponseId() string {
	if x != nil {
		return x.ResponseId
	}
	return ""
}

// The request for sending validation feedback.
type ProvideValidationFeedbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The outcome of the sequence of validation attempts.
	//
	// If this field is set to `VALIDATION_CONCLUSION_UNSPECIFIED`, an
	// `INVALID_ARGUMENT` error will be returned.
	Conclusion ProvideValidationFeedbackRequest_ValidationConclusion `protobuf:"varint,1,opt,name=conclusion,proto3,enum=google.maps.addressvalidation.v1.ProvideValidationFeedbackRequest_ValidationConclusion" json:"conclusion,omitempty"`
	// Required. The ID of the response that this feedback is for. This should be
	// the
	// [response_id][google.maps.addressvalidation.v1.ValidateAddressRequest.response_id]
	// from the first response in a series of address validation attempts.
	ResponseId string `protobuf:"bytes,2,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
}

func (x *ProvideValidationFeedbackRequest) Reset() {
	*x = ProvideValidationFeedbackRequest{}
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProvideValidationFeedbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvideValidationFeedbackRequest) ProtoMessage() {}

func (x *ProvideValidationFeedbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvideValidationFeedbackRequest.ProtoReflect.Descriptor instead.
func (*ProvideValidationFeedbackRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescGZIP(), []int{2}
}

func (x *ProvideValidationFeedbackRequest) GetConclusion() ProvideValidationFeedbackRequest_ValidationConclusion {
	if x != nil {
		return x.Conclusion
	}
	return ProvideValidationFeedbackRequest_VALIDATION_CONCLUSION_UNSPECIFIED
}

func (x *ProvideValidationFeedbackRequest) GetResponseId() string {
	if x != nil {
		return x.ResponseId
	}
	return ""
}

// The response for validation feedback.
//
// The response is empty if the feedback is sent successfully.
type ProvideValidationFeedbackResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ProvideValidationFeedbackResponse) Reset() {
	*x = ProvideValidationFeedbackResponse{}
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProvideValidationFeedbackResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvideValidationFeedbackResponse) ProtoMessage() {}

func (x *ProvideValidationFeedbackResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvideValidationFeedbackResponse.ProtoReflect.Descriptor instead.
func (*ProvideValidationFeedbackResponse) Descriptor() ([]byte, []int) {
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescGZIP(), []int{3}
}

// The result of validating an address.
type ValidationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Overall verdict flags
	Verdict *Verdict `protobuf:"bytes,1,opt,name=verdict,proto3" json:"verdict,omitempty"`
	// Information about the address itself as opposed to the geocode.
	Address *Address `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Information about the location and place that the address geocoded to.
	Geocode *Geocode `protobuf:"bytes,3,opt,name=geocode,proto3" json:"geocode,omitempty"`
	// Other information relevant to deliverability. `metadata` is not guaranteed
	// to be fully populated for every address sent to the Address Validation API.
	Metadata *AddressMetadata `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Extra deliverability flags provided by USPS. Only provided in region `US`
	// and `PR`.
	UspsData *UspsData `protobuf:"bytes,5,opt,name=usps_data,json=uspsData,proto3" json:"usps_data,omitempty"`
}

func (x *ValidationResult) Reset() {
	*x = ValidationResult{}
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidationResult) ProtoMessage() {}

func (x *ValidationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidationResult.ProtoReflect.Descriptor instead.
func (*ValidationResult) Descriptor() ([]byte, []int) {
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescGZIP(), []int{4}
}

func (x *ValidationResult) GetVerdict() *Verdict {
	if x != nil {
		return x.Verdict
	}
	return nil
}

func (x *ValidationResult) GetAddress() *Address {
	if x != nil {
		return x.Address
	}
	return nil
}

func (x *ValidationResult) GetGeocode() *Geocode {
	if x != nil {
		return x.Geocode
	}
	return nil
}

func (x *ValidationResult) GetMetadata() *AddressMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ValidationResult) GetUspsData() *UspsData {
	if x != nil {
		return x.UspsData
	}
	return nil
}

// High level overview of the address validation result and geocode.
type Verdict struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The granularity of the **input** address. This is the result of parsing the
	// input address and does not give any validation signals. For validation
	// signals, refer to `validation_granularity` below.
	//
	// For example, if the input address includes a specific apartment number,
	// then the `input_granularity` here will be `SUB_PREMISE`. If we cannot match
	// the apartment number in the databases or the apartment number is invalid,
	// the `validation_granularity` will likely be `PREMISE` or below.
	InputGranularity Verdict_Granularity `protobuf:"varint,1,opt,name=input_granularity,json=inputGranularity,proto3,enum=google.maps.addressvalidation.v1.Verdict_Granularity" json:"input_granularity,omitempty"`
	// The granularity level that the API can fully **validate** the address to.
	// For example, an `validation_granularity` of `PREMISE` indicates all address
	// components at the level of `PREMISE` or more coarse can be validated.
	//
	// Per address component validation result can be found in
	// [google.maps.addressvalidation.v1.Address.address_components].
	ValidationGranularity Verdict_Granularity `protobuf:"varint,2,opt,name=validation_granularity,json=validationGranularity,proto3,enum=google.maps.addressvalidation.v1.Verdict_Granularity" json:"validation_granularity,omitempty"`
	// Information about the granularity of the
	// [`geocode`][google.maps.addressvalidation.v1.ValidationResult.geocode].
	// This can be understood as the semantic meaning of how coarse or fine the
	// geocoded location is.
	//
	// This can differ from the `validation_granularity` above occasionally. For
	// example, our database might record the existence of an apartment number but
	// do not have a precise location for the apartment within a big apartment
	// complex. In that case, the `validation_granularity` will be `SUB_PREMISE`
	// but the `geocode_granularity` will be `PREMISE`.
	GeocodeGranularity Verdict_Granularity `protobuf:"varint,3,opt,name=geocode_granularity,json=geocodeGranularity,proto3,enum=google.maps.addressvalidation.v1.Verdict_Granularity" json:"geocode_granularity,omitempty"`
	// The address is considered complete if there are no unresolved tokens, no
	// unexpected or missing address components. See
	// [`missing_component_types`][google.maps.addressvalidation.v1.Address.missing_component_types],
	// [`unresolved_tokens`][google.maps.addressvalidation.v1.Address.unresolved_tokens]
	// or
	// [`unexpected`][google.maps.addressvalidation.v1.AddressComponent.unexpected]
	// fields for more details.
	AddressComplete bool `protobuf:"varint,4,opt,name=address_complete,json=addressComplete,proto3" json:"address_complete,omitempty"`
	// At least one address component cannot be categorized or validated, see
	// [google.maps.addressvalidation.v1.Address.address_components] for
	// details.
	HasUnconfirmedComponents bool `protobuf:"varint,5,opt,name=has_unconfirmed_components,json=hasUnconfirmedComponents,proto3" json:"has_unconfirmed_components,omitempty"`
	// At least one address component was inferred (added) that wasn't in the
	// input, see
	// [google.maps.addressvalidation.v1.Address.address_components] for
	// details.
	HasInferredComponents bool `protobuf:"varint,6,opt,name=has_inferred_components,json=hasInferredComponents,proto3" json:"has_inferred_components,omitempty"`
	// At least one address component was replaced, see
	// [google.maps.addressvalidation.v1.Address.address_components] for
	// details.
	HasReplacedComponents bool `protobuf:"varint,7,opt,name=has_replaced_components,json=hasReplacedComponents,proto3" json:"has_replaced_components,omitempty"`
}

func (x *Verdict) Reset() {
	*x = Verdict{}
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Verdict) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Verdict) ProtoMessage() {}

func (x *Verdict) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Verdict.ProtoReflect.Descriptor instead.
func (*Verdict) Descriptor() ([]byte, []int) {
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescGZIP(), []int{5}
}

func (x *Verdict) GetInputGranularity() Verdict_Granularity {
	if x != nil {
		return x.InputGranularity
	}
	return Verdict_GRANULARITY_UNSPECIFIED
}

func (x *Verdict) GetValidationGranularity() Verdict_Granularity {
	if x != nil {
		return x.ValidationGranularity
	}
	return Verdict_GRANULARITY_UNSPECIFIED
}

func (x *Verdict) GetGeocodeGranularity() Verdict_Granularity {
	if x != nil {
		return x.GeocodeGranularity
	}
	return Verdict_GRANULARITY_UNSPECIFIED
}

func (x *Verdict) GetAddressComplete() bool {
	if x != nil {
		return x.AddressComplete
	}
	return false
}

func (x *Verdict) GetHasUnconfirmedComponents() bool {
	if x != nil {
		return x.HasUnconfirmedComponents
	}
	return false
}

func (x *Verdict) GetHasInferredComponents() bool {
	if x != nil {
		return x.HasInferredComponents
	}
	return false
}

func (x *Verdict) GetHasReplacedComponents() bool {
	if x != nil {
		return x.HasReplacedComponents
	}
	return false
}

var File_google_maps_addressvalidation_v1_address_validation_service_proto protoreflect.FileDescriptor

var file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDesc = []byte{
	0x0a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x31, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f,
	0x67, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31,
	0x2f, 0x75, 0x73, 0x70, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x70, 0x6f,
	0x73, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xd9, 0x01, 0x0a, 0x16, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a,
	0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x6f, 0x73,
	0x74, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x72, 0x65, 0x76,
	0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x75, 0x73, 0x70, 0x73, 0x5f, 0x63, 0x61, 0x73, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x73, 0x70, 0x73,
	0x43, 0x61, 0x73, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x86,
	0x01, 0x0a, 0x17, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x64, 0x22, 0xe3, 0x02, 0x0a, 0x20, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7c, 0x0a, 0x0a,
	0x63, 0x6f, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x63, 0x6f, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x64,
	0x22, 0x9a, 0x01, 0x0a, 0x14, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x56, 0x41, 0x4c,
	0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x43, 0x4c, 0x55, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x1a, 0x0a, 0x16, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x56, 0x45,
	0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x53, 0x45, 0x44, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11,
	0x55, 0x53, 0x45, 0x52, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x53, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54,
	0x45, 0x44, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x53, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x4e, 0x55, 0x53, 0x45, 0x44, 0x10, 0x04, 0x22, 0x23, 0x0a,
	0x21, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0xf9, 0x02, 0x0a, 0x10, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x64, 0x69,
	0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x64,
	0x69, 0x63, 0x74, 0x52, 0x07, 0x76, 0x65, 0x72, 0x64, 0x69, 0x63, 0x74, 0x12, 0x43, 0x0a, 0x07,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x43, 0x0a, 0x07, 0x67, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x65, 0x52, 0x07, 0x67,
	0x65, 0x6f, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x4d, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x47, 0x0a, 0x09, 0x75, 0x73, 0x70, 0x73, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x70, 0x73,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x08, 0x75, 0x73, 0x70, 0x73, 0x44, 0x61, 0x74, 0x61, 0x22, 0x9f,
	0x05, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x64, 0x69, 0x63, 0x74, 0x12, 0x62, 0x0a, 0x11, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x64, 0x69, 0x63, 0x74,
	0x2e, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x52, 0x10, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x6c,
	0x0a, 0x16, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x67, 0x72, 0x61,
	0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x65, 0x72, 0x64, 0x69, 0x63, 0x74, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c,
	0x61, 0x72, 0x69, 0x74, 0x79, 0x52, 0x15, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x66, 0x0a, 0x13,
	0x67, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72,
	0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72,
	0x64, 0x69, 0x63, 0x74, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79,
	0x52, 0x12, 0x67, 0x65, 0x6f, 0x63, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61,
	0x72, 0x69, 0x74, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x12,
	0x3c, 0x0a, 0x1a, 0x68, 0x61, 0x73, 0x5f, 0x75, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x18, 0x68, 0x61, 0x73, 0x55, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72,
	0x6d, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x36, 0x0a,
	0x17, 0x68, 0x61, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15,
	0x68, 0x61, 0x73, 0x49, 0x6e, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x68, 0x61, 0x73, 0x5f, 0x72, 0x65, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x68, 0x61, 0x73, 0x52, 0x65, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x80, 0x01,
	0x0a, 0x0b, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a,
	0x17, 0x47, 0x52, 0x41, 0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x55,
	0x42, 0x5f, 0x50, 0x52, 0x45, 0x4d, 0x49, 0x53, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x52, 0x45, 0x4d, 0x49, 0x53, 0x45, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x52, 0x45, 0x4d,
	0x49, 0x53, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x49, 0x4d, 0x49, 0x54, 0x59, 0x10, 0x03, 0x12,
	0x09, 0x0a, 0x05, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x4f,
	0x55, 0x54, 0x45, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x06,
	0x32, 0xb2, 0x03, 0x0a, 0x11, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xa6, 0x01, 0x0a, 0x0f, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x1e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x3a, 0x01, 0x2a, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x3a,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12,
	0xce, 0x01, 0x0a, 0x19, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x28, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x3a, 0x01,
	0x2a, 0x22, 0x1d, 0x2f, 0x76, 0x31, 0x3a, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x1a, 0x23, 0xca, 0x41, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0x9a, 0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x1d,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x58, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x07, 0x47,
	0x4d, 0x50, 0x41, 0x56, 0x56, 0x31, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x4d, 0x61, 0x70, 0x73, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70, 0x73, 0x5c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x23, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x4d, 0x61, 0x70, 0x73, 0x3a, 0x3a, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescOnce sync.Once
	file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescData = file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDesc
)

func file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescGZIP() []byte {
	file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescOnce.Do(func() {
		file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescData)
	})
	return file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDescData
}

var file_google_maps_addressvalidation_v1_address_validation_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_maps_addressvalidation_v1_address_validation_service_proto_goTypes = []any{
	(ProvideValidationFeedbackRequest_ValidationConclusion)(0), // 0: google.maps.addressvalidation.v1.ProvideValidationFeedbackRequest.ValidationConclusion
	(Verdict_Granularity)(0),                                   // 1: google.maps.addressvalidation.v1.Verdict.Granularity
	(*ValidateAddressRequest)(nil),                             // 2: google.maps.addressvalidation.v1.ValidateAddressRequest
	(*ValidateAddressResponse)(nil),                            // 3: google.maps.addressvalidation.v1.ValidateAddressResponse
	(*ProvideValidationFeedbackRequest)(nil),                   // 4: google.maps.addressvalidation.v1.ProvideValidationFeedbackRequest
	(*ProvideValidationFeedbackResponse)(nil),                  // 5: google.maps.addressvalidation.v1.ProvideValidationFeedbackResponse
	(*ValidationResult)(nil),                                   // 6: google.maps.addressvalidation.v1.ValidationResult
	(*Verdict)(nil),                                            // 7: google.maps.addressvalidation.v1.Verdict
	(*postaladdress.PostalAddress)(nil),                        // 8: google.type.PostalAddress
	(*Address)(nil),                                            // 9: google.maps.addressvalidation.v1.Address
	(*Geocode)(nil),                                            // 10: google.maps.addressvalidation.v1.Geocode
	(*AddressMetadata)(nil),                                    // 11: google.maps.addressvalidation.v1.AddressMetadata
	(*UspsData)(nil),                                           // 12: google.maps.addressvalidation.v1.UspsData
}
var file_google_maps_addressvalidation_v1_address_validation_service_proto_depIdxs = []int32{
	8,  // 0: google.maps.addressvalidation.v1.ValidateAddressRequest.address:type_name -> google.type.PostalAddress
	6,  // 1: google.maps.addressvalidation.v1.ValidateAddressResponse.result:type_name -> google.maps.addressvalidation.v1.ValidationResult
	0,  // 2: google.maps.addressvalidation.v1.ProvideValidationFeedbackRequest.conclusion:type_name -> google.maps.addressvalidation.v1.ProvideValidationFeedbackRequest.ValidationConclusion
	7,  // 3: google.maps.addressvalidation.v1.ValidationResult.verdict:type_name -> google.maps.addressvalidation.v1.Verdict
	9,  // 4: google.maps.addressvalidation.v1.ValidationResult.address:type_name -> google.maps.addressvalidation.v1.Address
	10, // 5: google.maps.addressvalidation.v1.ValidationResult.geocode:type_name -> google.maps.addressvalidation.v1.Geocode
	11, // 6: google.maps.addressvalidation.v1.ValidationResult.metadata:type_name -> google.maps.addressvalidation.v1.AddressMetadata
	12, // 7: google.maps.addressvalidation.v1.ValidationResult.usps_data:type_name -> google.maps.addressvalidation.v1.UspsData
	1,  // 8: google.maps.addressvalidation.v1.Verdict.input_granularity:type_name -> google.maps.addressvalidation.v1.Verdict.Granularity
	1,  // 9: google.maps.addressvalidation.v1.Verdict.validation_granularity:type_name -> google.maps.addressvalidation.v1.Verdict.Granularity
	1,  // 10: google.maps.addressvalidation.v1.Verdict.geocode_granularity:type_name -> google.maps.addressvalidation.v1.Verdict.Granularity
	2,  // 11: google.maps.addressvalidation.v1.AddressValidation.ValidateAddress:input_type -> google.maps.addressvalidation.v1.ValidateAddressRequest
	4,  // 12: google.maps.addressvalidation.v1.AddressValidation.ProvideValidationFeedback:input_type -> google.maps.addressvalidation.v1.ProvideValidationFeedbackRequest
	3,  // 13: google.maps.addressvalidation.v1.AddressValidation.ValidateAddress:output_type -> google.maps.addressvalidation.v1.ValidateAddressResponse
	5,  // 14: google.maps.addressvalidation.v1.AddressValidation.ProvideValidationFeedback:output_type -> google.maps.addressvalidation.v1.ProvideValidationFeedbackResponse
	13, // [13:15] is the sub-list for method output_type
	11, // [11:13] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_maps_addressvalidation_v1_address_validation_service_proto_init() }
func file_google_maps_addressvalidation_v1_address_validation_service_proto_init() {
	if File_google_maps_addressvalidation_v1_address_validation_service_proto != nil {
		return
	}
	file_google_maps_addressvalidation_v1_address_proto_init()
	file_google_maps_addressvalidation_v1_geocode_proto_init()
	file_google_maps_addressvalidation_v1_metadata_proto_init()
	file_google_maps_addressvalidation_v1_usps_data_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_maps_addressvalidation_v1_address_validation_service_proto_goTypes,
		DependencyIndexes: file_google_maps_addressvalidation_v1_address_validation_service_proto_depIdxs,
		EnumInfos:         file_google_maps_addressvalidation_v1_address_validation_service_proto_enumTypes,
		MessageInfos:      file_google_maps_addressvalidation_v1_address_validation_service_proto_msgTypes,
	}.Build()
	File_google_maps_addressvalidation_v1_address_validation_service_proto = out.File
	file_google_maps_addressvalidation_v1_address_validation_service_proto_rawDesc = nil
	file_google_maps_addressvalidation_v1_address_validation_service_proto_goTypes = nil
	file_google_maps_addressvalidation_v1_address_validation_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AddressValidationClient is the client API for AddressValidation service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AddressValidationClient interface {
	// Validates an address.
	ValidateAddress(ctx context.Context, in *ValidateAddressRequest, opts ...grpc.CallOption) (*ValidateAddressResponse, error)
	// Feedback about the outcome of the sequence of validation attempts. This
	// should be the last call made after a sequence of validation calls for the
	// same address, and should be called once the transaction is concluded. This
	// should only be sent once for the sequence of `ValidateAddress` requests
	// needed to validate an address fully.
	ProvideValidationFeedback(ctx context.Context, in *ProvideValidationFeedbackRequest, opts ...grpc.CallOption) (*ProvideValidationFeedbackResponse, error)
}

type addressValidationClient struct {
	cc grpc.ClientConnInterface
}

func NewAddressValidationClient(cc grpc.ClientConnInterface) AddressValidationClient {
	return &addressValidationClient{cc}
}

func (c *addressValidationClient) ValidateAddress(ctx context.Context, in *ValidateAddressRequest, opts ...grpc.CallOption) (*ValidateAddressResponse, error) {
	out := new(ValidateAddressResponse)
	err := c.cc.Invoke(ctx, "/google.maps.addressvalidation.v1.AddressValidation/ValidateAddress", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *addressValidationClient) ProvideValidationFeedback(ctx context.Context, in *ProvideValidationFeedbackRequest, opts ...grpc.CallOption) (*ProvideValidationFeedbackResponse, error) {
	out := new(ProvideValidationFeedbackResponse)
	err := c.cc.Invoke(ctx, "/google.maps.addressvalidation.v1.AddressValidation/ProvideValidationFeedback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AddressValidationServer is the server API for AddressValidation service.
type AddressValidationServer interface {
	// Validates an address.
	ValidateAddress(context.Context, *ValidateAddressRequest) (*ValidateAddressResponse, error)
	// Feedback about the outcome of the sequence of validation attempts. This
	// should be the last call made after a sequence of validation calls for the
	// same address, and should be called once the transaction is concluded. This
	// should only be sent once for the sequence of `ValidateAddress` requests
	// needed to validate an address fully.
	ProvideValidationFeedback(context.Context, *ProvideValidationFeedbackRequest) (*ProvideValidationFeedbackResponse, error)
}

// UnimplementedAddressValidationServer can be embedded to have forward compatible implementations.
type UnimplementedAddressValidationServer struct {
}

func (*UnimplementedAddressValidationServer) ValidateAddress(context.Context, *ValidateAddressRequest) (*ValidateAddressResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateAddress not implemented")
}
func (*UnimplementedAddressValidationServer) ProvideValidationFeedback(context.Context, *ProvideValidationFeedbackRequest) (*ProvideValidationFeedbackResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvideValidationFeedback not implemented")
}

func RegisterAddressValidationServer(s *grpc.Server, srv AddressValidationServer) {
	s.RegisterService(&_AddressValidation_serviceDesc, srv)
}

func _AddressValidation_ValidateAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressValidationServer).ValidateAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.addressvalidation.v1.AddressValidation/ValidateAddress",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressValidationServer).ValidateAddress(ctx, req.(*ValidateAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AddressValidation_ProvideValidationFeedback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvideValidationFeedbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressValidationServer).ProvideValidationFeedback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.maps.addressvalidation.v1.AddressValidation/ProvideValidationFeedback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressValidationServer).ProvideValidationFeedback(ctx, req.(*ProvideValidationFeedbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AddressValidation_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.addressvalidation.v1.AddressValidation",
	HandlerType: (*AddressValidationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ValidateAddress",
			Handler:    _AddressValidation_ValidateAddress_Handler,
		},
		{
			MethodName: "ProvideValidationFeedback",
			Handler:    _AddressValidation_ProvideValidationFeedback_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/addressvalidation/v1/address_validation_service.proto",
}
