// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/maps/places/v1/routing_summary.proto

package placespb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The duration and distance from the routing origin to a place in the
// response, and a second leg from that place to the destination, if requested.
// **Note:** Adding `routingSummaries` in the field mask without also including
// either the `routingParameters.origin` parameter or the
// `searchAlongRouteParameters.polyline.encodedPolyline` parameter in the
// request causes an error.
type RoutingSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The legs of the trip.
	//
	// When you calculate travel duration and distance from a set origin, `legs`
	// contains a single leg containing the duration and distance from the origin
	// to the destination.  When you do a search along route, `legs` contains two
	// legs: one from the origin to place, and one from the place to the
	// destination.
	Legs []*RoutingSummary_Leg `protobuf:"bytes,1,rep,name=legs,proto3" json:"legs,omitempty"`
	// A link to show directions on Google Maps using the waypoints from the given
	// routing summary. The route generated by this link is not guaranteed to be
	// the same as the route used to generate the routing summary.
	// The link uses information provided in the request, from fields including
	// `routingParameters` and `searchAlongRouteParameters` when applicable, to
	// generate the directions link.
	DirectionsUri string `protobuf:"bytes,2,opt,name=directions_uri,json=directionsUri,proto3" json:"directions_uri,omitempty"`
}

func (x *RoutingSummary) Reset() {
	*x = RoutingSummary{}
	mi := &file_google_maps_places_v1_routing_summary_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RoutingSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoutingSummary) ProtoMessage() {}

func (x *RoutingSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_routing_summary_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoutingSummary.ProtoReflect.Descriptor instead.
func (*RoutingSummary) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_routing_summary_proto_rawDescGZIP(), []int{0}
}

func (x *RoutingSummary) GetLegs() []*RoutingSummary_Leg {
	if x != nil {
		return x.Legs
	}
	return nil
}

func (x *RoutingSummary) GetDirectionsUri() string {
	if x != nil {
		return x.DirectionsUri
	}
	return ""
}

// A leg is a single portion of a journey from one location to another.
type RoutingSummary_Leg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time it takes to complete this leg of the trip.
	Duration *durationpb.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
	// The distance of this leg of the trip.
	DistanceMeters int32 `protobuf:"varint,2,opt,name=distance_meters,json=distanceMeters,proto3" json:"distance_meters,omitempty"`
}

func (x *RoutingSummary_Leg) Reset() {
	*x = RoutingSummary_Leg{}
	mi := &file_google_maps_places_v1_routing_summary_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RoutingSummary_Leg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoutingSummary_Leg) ProtoMessage() {}

func (x *RoutingSummary_Leg) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_routing_summary_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoutingSummary_Leg.ProtoReflect.Descriptor instead.
func (*RoutingSummary_Leg) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_routing_summary_proto_rawDescGZIP(), []int{0, 0}
}

func (x *RoutingSummary_Leg) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *RoutingSummary_Leg) GetDistanceMeters() int32 {
	if x != nil {
		return x.DistanceMeters
	}
	return 0
}

var File_google_maps_places_v1_routing_summary_proto protoreflect.FileDescriptor

var file_google_maps_places_v1_routing_summary_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdd, 0x01, 0x0a, 0x0e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x3d, 0x0a, 0x04, 0x6c, 0x65, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x2e, 0x4c, 0x65, 0x67,
	0x52, 0x04, 0x6c, 0x65, 0x67, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x55, 0x72, 0x69, 0x1a, 0x65, 0x0a,
	0x03, 0x4c, 0x65, 0x67, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x64,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x42, 0xa4, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x42, 0x13, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d,
	0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x70, 0x62, 0xa2, 0x02, 0x06, 0x47, 0x4d, 0x50, 0x53, 0x56, 0x31, 0xaa, 0x02, 0x15, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x4d, 0x61, 0x70,
	0x73, 0x5c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_maps_places_v1_routing_summary_proto_rawDescOnce sync.Once
	file_google_maps_places_v1_routing_summary_proto_rawDescData = file_google_maps_places_v1_routing_summary_proto_rawDesc
)

func file_google_maps_places_v1_routing_summary_proto_rawDescGZIP() []byte {
	file_google_maps_places_v1_routing_summary_proto_rawDescOnce.Do(func() {
		file_google_maps_places_v1_routing_summary_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_places_v1_routing_summary_proto_rawDescData)
	})
	return file_google_maps_places_v1_routing_summary_proto_rawDescData
}

var file_google_maps_places_v1_routing_summary_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_maps_places_v1_routing_summary_proto_goTypes = []any{
	(*RoutingSummary)(nil),      // 0: google.maps.places.v1.RoutingSummary
	(*RoutingSummary_Leg)(nil),  // 1: google.maps.places.v1.RoutingSummary.Leg
	(*durationpb.Duration)(nil), // 2: google.protobuf.Duration
}
var file_google_maps_places_v1_routing_summary_proto_depIdxs = []int32{
	1, // 0: google.maps.places.v1.RoutingSummary.legs:type_name -> google.maps.places.v1.RoutingSummary.Leg
	2, // 1: google.maps.places.v1.RoutingSummary.Leg.duration:type_name -> google.protobuf.Duration
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_maps_places_v1_routing_summary_proto_init() }
func file_google_maps_places_v1_routing_summary_proto_init() {
	if File_google_maps_places_v1_routing_summary_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_places_v1_routing_summary_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_places_v1_routing_summary_proto_goTypes,
		DependencyIndexes: file_google_maps_places_v1_routing_summary_proto_depIdxs,
		MessageInfos:      file_google_maps_places_v1_routing_summary_proto_msgTypes,
	}.Build()
	File_google_maps_places_v1_routing_summary_proto = out.File
	file_google_maps_places_v1_routing_summary_proto_rawDesc = nil
	file_google_maps_places_v1_routing_summary_proto_goTypes = nil
	file_google_maps_places_v1_routing_summary_proto_depIdxs = nil
}
