// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/maps/addressvalidation/v1/address_validation_service.proto

package addressvalidationpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AddressValidation_ValidateAddress_FullMethodName           = "/google.maps.addressvalidation.v1.AddressValidation/ValidateAddress"
	AddressValidation_ProvideValidationFeedback_FullMethodName = "/google.maps.addressvalidation.v1.AddressValidation/ProvideValidationFeedback"
)

// AddressValidationClient is the client API for AddressValidation service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AddressValidationClient interface {
	// Validates an address.
	ValidateAddress(ctx context.Context, in *ValidateAddressRequest, opts ...grpc.CallOption) (*ValidateAddressResponse, error)
	// Feedback about the outcome of the sequence of validation attempts. This
	// should be the last call made after a sequence of validation calls for the
	// same address, and should be called once the transaction is concluded. This
	// should only be sent once for the sequence of `ValidateAddress` requests
	// needed to validate an address fully.
	ProvideValidationFeedback(ctx context.Context, in *ProvideValidationFeedbackRequest, opts ...grpc.CallOption) (*ProvideValidationFeedbackResponse, error)
}

type addressValidationClient struct {
	cc grpc.ClientConnInterface
}

func NewAddressValidationClient(cc grpc.ClientConnInterface) AddressValidationClient {
	return &addressValidationClient{cc}
}

func (c *addressValidationClient) ValidateAddress(ctx context.Context, in *ValidateAddressRequest, opts ...grpc.CallOption) (*ValidateAddressResponse, error) {
	out := new(ValidateAddressResponse)
	err := c.cc.Invoke(ctx, AddressValidation_ValidateAddress_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *addressValidationClient) ProvideValidationFeedback(ctx context.Context, in *ProvideValidationFeedbackRequest, opts ...grpc.CallOption) (*ProvideValidationFeedbackResponse, error) {
	out := new(ProvideValidationFeedbackResponse)
	err := c.cc.Invoke(ctx, AddressValidation_ProvideValidationFeedback_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AddressValidationServer is the server API for AddressValidation service.
// All implementations should embed UnimplementedAddressValidationServer
// for forward compatibility
type AddressValidationServer interface {
	// Validates an address.
	ValidateAddress(context.Context, *ValidateAddressRequest) (*ValidateAddressResponse, error)
	// Feedback about the outcome of the sequence of validation attempts. This
	// should be the last call made after a sequence of validation calls for the
	// same address, and should be called once the transaction is concluded. This
	// should only be sent once for the sequence of `ValidateAddress` requests
	// needed to validate an address fully.
	ProvideValidationFeedback(context.Context, *ProvideValidationFeedbackRequest) (*ProvideValidationFeedbackResponse, error)
}

// UnimplementedAddressValidationServer should be embedded to have forward compatible implementations.
type UnimplementedAddressValidationServer struct {
}

func (UnimplementedAddressValidationServer) ValidateAddress(context.Context, *ValidateAddressRequest) (*ValidateAddressResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateAddress not implemented")
}
func (UnimplementedAddressValidationServer) ProvideValidationFeedback(context.Context, *ProvideValidationFeedbackRequest) (*ProvideValidationFeedbackResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvideValidationFeedback not implemented")
}

// UnsafeAddressValidationServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AddressValidationServer will
// result in compilation errors.
type UnsafeAddressValidationServer interface {
	mustEmbedUnimplementedAddressValidationServer()
}

func RegisterAddressValidationServer(s grpc.ServiceRegistrar, srv AddressValidationServer) {
	s.RegisterService(&AddressValidation_ServiceDesc, srv)
}

func _AddressValidation_ValidateAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressValidationServer).ValidateAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AddressValidation_ValidateAddress_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressValidationServer).ValidateAddress(ctx, req.(*ValidateAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AddressValidation_ProvideValidationFeedback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvideValidationFeedbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressValidationServer).ProvideValidationFeedback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AddressValidation_ProvideValidationFeedback_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressValidationServer).ProvideValidationFeedback(ctx, req.(*ProvideValidationFeedbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AddressValidation_ServiceDesc is the grpc.ServiceDesc for AddressValidation service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AddressValidation_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.addressvalidation.v1.AddressValidation",
	HandlerType: (*AddressValidationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ValidateAddress",
			Handler:    _AddressValidation_ValidateAddress_Handler,
		},
		{
			MethodName: "ProvideValidationFeedback",
			Handler:    _AddressValidation_ProvideValidationFeedback_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/addressvalidation/v1/address_validation_service.proto",
}
