// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/generative_settings.proto

package cxpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The input token limits for 1 LLM call. For the limit of each model, see
// https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models for
// more information.
type LlmModelSettings_Parameters_InputTokenLimit int32

const (
	// Limit not specified. Treated as 'INPUT_TOKEN_LIMIT_SHORT'.
	LlmModelSettings_Parameters_INPUT_TOKEN_LIMIT_UNSPECIFIED LlmModelSettings_Parameters_InputTokenLimit = 0
	// Input token limit up to 8k.
	LlmModelSettings_Parameters_INPUT_TOKEN_LIMIT_SHORT LlmModelSettings_Parameters_InputTokenLimit = 1
	// Input token limit up to 32k.
	LlmModelSettings_Parameters_INPUT_TOKEN_LIMIT_MEDIUM LlmModelSettings_Parameters_InputTokenLimit = 2
	// Input token limit up to 100k.
	LlmModelSettings_Parameters_INPUT_TOKEN_LIMIT_LONG LlmModelSettings_Parameters_InputTokenLimit = 3
)

// Enum value maps for LlmModelSettings_Parameters_InputTokenLimit.
var (
	LlmModelSettings_Parameters_InputTokenLimit_name = map[int32]string{
		0: "INPUT_TOKEN_LIMIT_UNSPECIFIED",
		1: "INPUT_TOKEN_LIMIT_SHORT",
		2: "INPUT_TOKEN_LIMIT_MEDIUM",
		3: "INPUT_TOKEN_LIMIT_LONG",
	}
	LlmModelSettings_Parameters_InputTokenLimit_value = map[string]int32{
		"INPUT_TOKEN_LIMIT_UNSPECIFIED": 0,
		"INPUT_TOKEN_LIMIT_SHORT":       1,
		"INPUT_TOKEN_LIMIT_MEDIUM":      2,
		"INPUT_TOKEN_LIMIT_LONG":        3,
	}
)

func (x LlmModelSettings_Parameters_InputTokenLimit) Enum() *LlmModelSettings_Parameters_InputTokenLimit {
	p := new(LlmModelSettings_Parameters_InputTokenLimit)
	*p = x
	return p
}

func (x LlmModelSettings_Parameters_InputTokenLimit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LlmModelSettings_Parameters_InputTokenLimit) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_enumTypes[0].Descriptor()
}

func (LlmModelSettings_Parameters_InputTokenLimit) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_enumTypes[0]
}

func (x LlmModelSettings_Parameters_InputTokenLimit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LlmModelSettings_Parameters_InputTokenLimit.Descriptor instead.
func (LlmModelSettings_Parameters_InputTokenLimit) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescGZIP(), []int{1, 0, 0}
}

// The output token limits for 1 LLM call. The limits are subject to change.
// For the limit of each model, see
// https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models for
// more information.
type LlmModelSettings_Parameters_OutputTokenLimit int32

const (
	// Limit not specified.
	LlmModelSettings_Parameters_OUTPUT_TOKEN_LIMIT_UNSPECIFIED LlmModelSettings_Parameters_OutputTokenLimit = 0
	// Input token limit up to 512 tokens.
	LlmModelSettings_Parameters_OUTPUT_TOKEN_LIMIT_SHORT LlmModelSettings_Parameters_OutputTokenLimit = 1
	// Input token limit up to 1k.
	LlmModelSettings_Parameters_OUTPUT_TOKEN_LIMIT_MEDIUM LlmModelSettings_Parameters_OutputTokenLimit = 2
	// Input token limit up to 2k.
	LlmModelSettings_Parameters_OUTPUT_TOKEN_LIMIT_LONG LlmModelSettings_Parameters_OutputTokenLimit = 3
)

// Enum value maps for LlmModelSettings_Parameters_OutputTokenLimit.
var (
	LlmModelSettings_Parameters_OutputTokenLimit_name = map[int32]string{
		0: "OUTPUT_TOKEN_LIMIT_UNSPECIFIED",
		1: "OUTPUT_TOKEN_LIMIT_SHORT",
		2: "OUTPUT_TOKEN_LIMIT_MEDIUM",
		3: "OUTPUT_TOKEN_LIMIT_LONG",
	}
	LlmModelSettings_Parameters_OutputTokenLimit_value = map[string]int32{
		"OUTPUT_TOKEN_LIMIT_UNSPECIFIED": 0,
		"OUTPUT_TOKEN_LIMIT_SHORT":       1,
		"OUTPUT_TOKEN_LIMIT_MEDIUM":      2,
		"OUTPUT_TOKEN_LIMIT_LONG":        3,
	}
)

func (x LlmModelSettings_Parameters_OutputTokenLimit) Enum() *LlmModelSettings_Parameters_OutputTokenLimit {
	p := new(LlmModelSettings_Parameters_OutputTokenLimit)
	*p = x
	return p
}

func (x LlmModelSettings_Parameters_OutputTokenLimit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LlmModelSettings_Parameters_OutputTokenLimit) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_enumTypes[1].Descriptor()
}

func (LlmModelSettings_Parameters_OutputTokenLimit) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_enumTypes[1]
}

func (x LlmModelSettings_Parameters_OutputTokenLimit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LlmModelSettings_Parameters_OutputTokenLimit.Descriptor instead.
func (LlmModelSettings_Parameters_OutputTokenLimit) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescGZIP(), []int{1, 0, 1}
}

// Settings for Generative AI.
type GenerativeSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generativeSettings`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Settings for Generative Fallback.
	FallbackSettings *GenerativeSettings_FallbackSettings `protobuf:"bytes,1,opt,name=fallback_settings,json=fallbackSettings,proto3" json:"fallback_settings,omitempty"`
	// Settings for Generative Safety.
	GenerativeSafetySettings *SafetySettings `protobuf:"bytes,3,opt,name=generative_safety_settings,json=generativeSafetySettings,proto3" json:"generative_safety_settings,omitempty"`
	// Settings for knowledge connector.
	KnowledgeConnectorSettings *GenerativeSettings_KnowledgeConnectorSettings `protobuf:"bytes,7,opt,name=knowledge_connector_settings,json=knowledgeConnectorSettings,proto3" json:"knowledge_connector_settings,omitempty"`
	// Language for this settings.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// LLM model settings.
	LlmModelSettings *LlmModelSettings `protobuf:"bytes,8,opt,name=llm_model_settings,json=llmModelSettings,proto3" json:"llm_model_settings,omitempty"`
}

func (x *GenerativeSettings) Reset() {
	*x = GenerativeSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerativeSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerativeSettings) ProtoMessage() {}

func (x *GenerativeSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerativeSettings.ProtoReflect.Descriptor instead.
func (*GenerativeSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescGZIP(), []int{0}
}

func (x *GenerativeSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GenerativeSettings) GetFallbackSettings() *GenerativeSettings_FallbackSettings {
	if x != nil {
		return x.FallbackSettings
	}
	return nil
}

func (x *GenerativeSettings) GetGenerativeSafetySettings() *SafetySettings {
	if x != nil {
		return x.GenerativeSafetySettings
	}
	return nil
}

func (x *GenerativeSettings) GetKnowledgeConnectorSettings() *GenerativeSettings_KnowledgeConnectorSettings {
	if x != nil {
		return x.KnowledgeConnectorSettings
	}
	return nil
}

func (x *GenerativeSettings) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *GenerativeSettings) GetLlmModelSettings() *LlmModelSettings {
	if x != nil {
		return x.LlmModelSettings
	}
	return nil
}

// Settings for LLM models.
type LlmModelSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The selected LLM model.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// The custom prompt to use.
	PromptText string `protobuf:"bytes,2,opt,name=prompt_text,json=promptText,proto3" json:"prompt_text,omitempty"`
	// Generative model parameters.
	Parameters *LlmModelSettings_Parameters `protobuf:"bytes,4,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *LlmModelSettings) Reset() {
	*x = LlmModelSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LlmModelSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LlmModelSettings) ProtoMessage() {}

func (x *LlmModelSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LlmModelSettings.ProtoReflect.Descriptor instead.
func (*LlmModelSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescGZIP(), []int{1}
}

func (x *LlmModelSettings) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *LlmModelSettings) GetPromptText() string {
	if x != nil {
		return x.PromptText
	}
	return ""
}

func (x *LlmModelSettings) GetParameters() *LlmModelSettings_Parameters {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Settings for Generative Fallback.
type GenerativeSettings_FallbackSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display name of the selected prompt.
	SelectedPrompt string `protobuf:"bytes,3,opt,name=selected_prompt,json=selectedPrompt,proto3" json:"selected_prompt,omitempty"`
	// Stored prompts that can be selected, for example default templates like
	// "conservative" or "chatty", or user defined ones.
	PromptTemplates []*GenerativeSettings_FallbackSettings_PromptTemplate `protobuf:"bytes,4,rep,name=prompt_templates,json=promptTemplates,proto3" json:"prompt_templates,omitempty"`
}

func (x *GenerativeSettings_FallbackSettings) Reset() {
	*x = GenerativeSettings_FallbackSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerativeSettings_FallbackSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerativeSettings_FallbackSettings) ProtoMessage() {}

func (x *GenerativeSettings_FallbackSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerativeSettings_FallbackSettings.ProtoReflect.Descriptor instead.
func (*GenerativeSettings_FallbackSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescGZIP(), []int{0, 0}
}

func (x *GenerativeSettings_FallbackSettings) GetSelectedPrompt() string {
	if x != nil {
		return x.SelectedPrompt
	}
	return ""
}

func (x *GenerativeSettings_FallbackSettings) GetPromptTemplates() []*GenerativeSettings_FallbackSettings_PromptTemplate {
	if x != nil {
		return x.PromptTemplates
	}
	return nil
}

// Settings for knowledge connector. These parameters are used for LLM prompt
// like "You are <agent>. You are a helpful and verbose <agent_identity> at
// <business>, <business_description>. Your task is to help humans on
// <agent_scope>".
type GenerativeSettings_KnowledgeConnectorSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `protobuf:"bytes,1,opt,name=business,proto3" json:"business,omitempty"`
	// Name of the virtual agent. Used for LLM prompt. Can be left empty.
	Agent string `protobuf:"bytes,2,opt,name=agent,proto3" json:"agent,omitempty"`
	// Identity of the agent, e.g. "virtual agent", "AI assistant".
	AgentIdentity string `protobuf:"bytes,3,opt,name=agent_identity,json=agentIdentity,proto3" json:"agent_identity,omitempty"`
	// Company description, used for LLM prompt, e.g. "a family company selling
	// freshly roasted coffee beans".
	BusinessDescription string `protobuf:"bytes,4,opt,name=business_description,json=businessDescription,proto3" json:"business_description,omitempty"`
	// Agent scope, e.g. "Example company website", "internal Example
	// company website for employees", "manual of car owner".
	AgentScope string `protobuf:"bytes,5,opt,name=agent_scope,json=agentScope,proto3" json:"agent_scope,omitempty"`
	// Whether to disable fallback to Data Store search results (in case the LLM
	// couldn't pick a proper answer). Per default the feature is enabled.
	DisableDataStoreFallback bool `protobuf:"varint,8,opt,name=disable_data_store_fallback,json=disableDataStoreFallback,proto3" json:"disable_data_store_fallback,omitempty"`
}

func (x *GenerativeSettings_KnowledgeConnectorSettings) Reset() {
	*x = GenerativeSettings_KnowledgeConnectorSettings{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerativeSettings_KnowledgeConnectorSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerativeSettings_KnowledgeConnectorSettings) ProtoMessage() {}

func (x *GenerativeSettings_KnowledgeConnectorSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerativeSettings_KnowledgeConnectorSettings.ProtoReflect.Descriptor instead.
func (*GenerativeSettings_KnowledgeConnectorSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescGZIP(), []int{0, 1}
}

func (x *GenerativeSettings_KnowledgeConnectorSettings) GetBusiness() string {
	if x != nil {
		return x.Business
	}
	return ""
}

func (x *GenerativeSettings_KnowledgeConnectorSettings) GetAgent() string {
	if x != nil {
		return x.Agent
	}
	return ""
}

func (x *GenerativeSettings_KnowledgeConnectorSettings) GetAgentIdentity() string {
	if x != nil {
		return x.AgentIdentity
	}
	return ""
}

func (x *GenerativeSettings_KnowledgeConnectorSettings) GetBusinessDescription() string {
	if x != nil {
		return x.BusinessDescription
	}
	return ""
}

func (x *GenerativeSettings_KnowledgeConnectorSettings) GetAgentScope() string {
	if x != nil {
		return x.AgentScope
	}
	return ""
}

func (x *GenerativeSettings_KnowledgeConnectorSettings) GetDisableDataStoreFallback() bool {
	if x != nil {
		return x.DisableDataStoreFallback
	}
	return false
}

// Prompt template.
type GenerativeSettings_FallbackSettings_PromptTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Prompt name.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Prompt text that is sent to a LLM on no-match default, placeholders are
	// filled downstream. For example: "Here is a conversation $conversation,
	// a response is: "
	PromptText string `protobuf:"bytes,2,opt,name=prompt_text,json=promptText,proto3" json:"prompt_text,omitempty"`
	// If the flag is true, the prompt is frozen and cannot be modified by
	// users.
	Frozen bool `protobuf:"varint,3,opt,name=frozen,proto3" json:"frozen,omitempty"`
}

func (x *GenerativeSettings_FallbackSettings_PromptTemplate) Reset() {
	*x = GenerativeSettings_FallbackSettings_PromptTemplate{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerativeSettings_FallbackSettings_PromptTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerativeSettings_FallbackSettings_PromptTemplate) ProtoMessage() {}

func (x *GenerativeSettings_FallbackSettings_PromptTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerativeSettings_FallbackSettings_PromptTemplate.ProtoReflect.Descriptor instead.
func (*GenerativeSettings_FallbackSettings_PromptTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *GenerativeSettings_FallbackSettings_PromptTemplate) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *GenerativeSettings_FallbackSettings_PromptTemplate) GetPromptText() string {
	if x != nil {
		return x.PromptText
	}
	return ""
}

func (x *GenerativeSettings_FallbackSettings_PromptTemplate) GetFrozen() bool {
	if x != nil {
		return x.Frozen
	}
	return false
}

// Generative model parameters to control the model behavior.
type LlmModelSettings_Parameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The temperature used for sampling during response generation. Value
	// ranges from 0 to 1. Temperature controls the degree of randomness in
	// token selection. Lower temperature means less randomness, while higher
	// temperature means more randomness.
	// Valid range: [0.0, 1.0]
	Temperature *float32 `protobuf:"fixed32,1,opt,name=temperature,proto3,oneof" json:"temperature,omitempty"`
	// The input token limit.
	// This setting is currently only supported by playbooks.
	InputTokenLimit *LlmModelSettings_Parameters_InputTokenLimit `protobuf:"varint,2,opt,name=input_token_limit,json=inputTokenLimit,proto3,enum=google.cloud.dialogflow.cx.v3beta1.LlmModelSettings_Parameters_InputTokenLimit,oneof" json:"input_token_limit,omitempty"`
	// The output token limit.
	// This setting is currently only supported by playbooks.
	// Only one of output_token_limit and max_output_tokens is allowed to be
	// set.
	OutputTokenLimit *LlmModelSettings_Parameters_OutputTokenLimit `protobuf:"varint,3,opt,name=output_token_limit,json=outputTokenLimit,proto3,enum=google.cloud.dialogflow.cx.v3beta1.LlmModelSettings_Parameters_OutputTokenLimit,oneof" json:"output_token_limit,omitempty"`
}

func (x *LlmModelSettings_Parameters) Reset() {
	*x = LlmModelSettings_Parameters{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LlmModelSettings_Parameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LlmModelSettings_Parameters) ProtoMessage() {}

func (x *LlmModelSettings_Parameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LlmModelSettings_Parameters.ProtoReflect.Descriptor instead.
func (*LlmModelSettings_Parameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescGZIP(), []int{1, 0}
}

func (x *LlmModelSettings_Parameters) GetTemperature() float32 {
	if x != nil && x.Temperature != nil {
		return *x.Temperature
	}
	return 0
}

func (x *LlmModelSettings_Parameters) GetInputTokenLimit() LlmModelSettings_Parameters_InputTokenLimit {
	if x != nil && x.InputTokenLimit != nil {
		return *x.InputTokenLimit
	}
	return LlmModelSettings_Parameters_INPUT_TOKEN_LIMIT_UNSPECIFIED
}

func (x *LlmModelSettings_Parameters) GetOutputTokenLimit() LlmModelSettings_Parameters_OutputTokenLimit {
	if x != nil && x.OutputTokenLimit != nil {
		return *x.OutputTokenLimit
	}
	return LlmModelSettings_Parameters_OUTPUT_TOKEN_LIMIT_UNSPECIFIED
}

var File_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x09, 0x0a, 0x12, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x74, 0x0a, 0x11, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x10, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x70, 0x0a, 0x1a, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x18, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x61, 0x66, 0x65,
	0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x93, 0x01, 0x0a, 0x1c, 0x6b,
	0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65,
	0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x1a, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x62, 0x0a, 0x12, 0x6c, 0x6c, 0x6d, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6c, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x10, 0x6c, 0x6c, 0x6d, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0xad, 0x02, 0x0a, 0x10, 0x46, 0x61,
	0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0x81, 0x01, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x46, 0x61, 0x6c, 0x6c, 0x62,
	0x61, 0x63, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x1a, 0x6c, 0x0a, 0x0e, 0x50,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x65, 0x78,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x72, 0x6f, 0x7a, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x06, 0x66, 0x72, 0x6f, 0x7a, 0x65, 0x6e, 0x1a, 0x88, 0x02, 0x0a, 0x1a, 0x4b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x75, 0x73, 0x69,
	0x6e, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x75, 0x73, 0x69,
	0x6e, 0x65, 0x73, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x31, 0x0a, 0x14, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x13, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x3d, 0x0a, 0x1b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x66, 0x61, 0x6c, 0x6c,
	0x62, 0x61, 0x63, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x46, 0x61, 0x6c, 0x6c,
	0x62, 0x61, 0x63, 0x6b, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x31, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x49, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xc7, 0x06, 0x0a, 0x10, 0x4c, 0x6c, 0x6d,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x14, 0x0a,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74,
	0x54, 0x65, 0x78, 0x74, 0x12, 0x5f, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6c,
	0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x9a, 0x05, 0x0a, 0x0a, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x65, 0x6d,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x80, 0x01, 0x0a, 0x11,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6c, 0x6d,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x48, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x88, 0x01, 0x01, 0x12, 0x83,
	0x01, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x6c, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x48, 0x02, 0x52,
	0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x88, 0x01, 0x01, 0x22, 0x8b, 0x01, 0x0a, 0x0f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x50, 0x55,
	0x54, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x49,
	0x4e, 0x50, 0x55, 0x54, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54,
	0x5f, 0x53, 0x48, 0x4f, 0x52, 0x54, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x49, 0x4e, 0x50, 0x55,
	0x54, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x4d, 0x45,
	0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f,
	0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x4c, 0x4f, 0x4e, 0x47,
	0x10, 0x03, 0x22, 0x90, 0x01, 0x0a, 0x10, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x22, 0x0a, 0x1e, 0x4f, 0x55, 0x54, 0x50, 0x55,
	0x54, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x4f,
	0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49,
	0x54, 0x5f, 0x53, 0x48, 0x4f, 0x52, 0x54, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x4f, 0x55, 0x54,
	0x50, 0x55, 0x54, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f,
	0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17, 0x4f, 0x55, 0x54, 0x50,
	0x55, 0x54, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x5f, 0x4c,
	0x4f, 0x4e, 0x47, 0x10, 0x03, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x15, 0x0a, 0x13, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x42, 0xce, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x17, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62,
	0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_goTypes = []any{
	(LlmModelSettings_Parameters_InputTokenLimit)(0),           // 0: google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Parameters.InputTokenLimit
	(LlmModelSettings_Parameters_OutputTokenLimit)(0),          // 1: google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Parameters.OutputTokenLimit
	(*GenerativeSettings)(nil),                                 // 2: google.cloud.dialogflow.cx.v3beta1.GenerativeSettings
	(*LlmModelSettings)(nil),                                   // 3: google.cloud.dialogflow.cx.v3beta1.LlmModelSettings
	(*GenerativeSettings_FallbackSettings)(nil),                // 4: google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.FallbackSettings
	(*GenerativeSettings_KnowledgeConnectorSettings)(nil),      // 5: google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.KnowledgeConnectorSettings
	(*GenerativeSettings_FallbackSettings_PromptTemplate)(nil), // 6: google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.FallbackSettings.PromptTemplate
	(*LlmModelSettings_Parameters)(nil),                        // 7: google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Parameters
	(*SafetySettings)(nil),                                     // 8: google.cloud.dialogflow.cx.v3beta1.SafetySettings
}
var file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_depIdxs = []int32{
	4, // 0: google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.fallback_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.FallbackSettings
	8, // 1: google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.generative_safety_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.SafetySettings
	5, // 2: google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.knowledge_connector_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.KnowledgeConnectorSettings
	3, // 3: google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.llm_model_settings:type_name -> google.cloud.dialogflow.cx.v3beta1.LlmModelSettings
	7, // 4: google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.parameters:type_name -> google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Parameters
	6, // 5: google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.FallbackSettings.prompt_templates:type_name -> google.cloud.dialogflow.cx.v3beta1.GenerativeSettings.FallbackSettings.PromptTemplate
	0, // 6: google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Parameters.input_token_limit:type_name -> google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Parameters.InputTokenLimit
	1, // 7: google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Parameters.output_token_limit:type_name -> google.cloud.dialogflow.cx.v3beta1.LlmModelSettings.Parameters.OutputTokenLimit
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_safety_settings_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes[5].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_generative_settings_proto_depIdxs = nil
}
