// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataproc/v1/session_templates.proto

package dataprocpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SessionTemplateController_CreateSessionTemplate_FullMethodName = "/google.cloud.dataproc.v1.SessionTemplateController/CreateSessionTemplate"
	SessionTemplateController_UpdateSessionTemplate_FullMethodName = "/google.cloud.dataproc.v1.SessionTemplateController/UpdateSessionTemplate"
	SessionTemplateController_GetSessionTemplate_FullMethodName    = "/google.cloud.dataproc.v1.SessionTemplateController/GetSessionTemplate"
	SessionTemplateController_ListSessionTemplates_FullMethodName  = "/google.cloud.dataproc.v1.SessionTemplateController/ListSessionTemplates"
	SessionTemplateController_DeleteSessionTemplate_FullMethodName = "/google.cloud.dataproc.v1.SessionTemplateController/DeleteSessionTemplate"
)

// SessionTemplateControllerClient is the client API for SessionTemplateController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SessionTemplateControllerClient interface {
	// Create a session template synchronously.
	CreateSessionTemplate(ctx context.Context, in *CreateSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error)
	// Updates the session template synchronously.
	UpdateSessionTemplate(ctx context.Context, in *UpdateSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error)
	// Gets the resource representation for a session template.
	GetSessionTemplate(ctx context.Context, in *GetSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error)
	// Lists session templates.
	ListSessionTemplates(ctx context.Context, in *ListSessionTemplatesRequest, opts ...grpc.CallOption) (*ListSessionTemplatesResponse, error)
	// Deletes a session template.
	DeleteSessionTemplate(ctx context.Context, in *DeleteSessionTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type sessionTemplateControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewSessionTemplateControllerClient(cc grpc.ClientConnInterface) SessionTemplateControllerClient {
	return &sessionTemplateControllerClient{cc}
}

func (c *sessionTemplateControllerClient) CreateSessionTemplate(ctx context.Context, in *CreateSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error) {
	out := new(SessionTemplate)
	err := c.cc.Invoke(ctx, SessionTemplateController_CreateSessionTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionTemplateControllerClient) UpdateSessionTemplate(ctx context.Context, in *UpdateSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error) {
	out := new(SessionTemplate)
	err := c.cc.Invoke(ctx, SessionTemplateController_UpdateSessionTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionTemplateControllerClient) GetSessionTemplate(ctx context.Context, in *GetSessionTemplateRequest, opts ...grpc.CallOption) (*SessionTemplate, error) {
	out := new(SessionTemplate)
	err := c.cc.Invoke(ctx, SessionTemplateController_GetSessionTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionTemplateControllerClient) ListSessionTemplates(ctx context.Context, in *ListSessionTemplatesRequest, opts ...grpc.CallOption) (*ListSessionTemplatesResponse, error) {
	out := new(ListSessionTemplatesResponse)
	err := c.cc.Invoke(ctx, SessionTemplateController_ListSessionTemplates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionTemplateControllerClient) DeleteSessionTemplate(ctx context.Context, in *DeleteSessionTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SessionTemplateController_DeleteSessionTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SessionTemplateControllerServer is the server API for SessionTemplateController service.
// All implementations should embed UnimplementedSessionTemplateControllerServer
// for forward compatibility
type SessionTemplateControllerServer interface {
	// Create a session template synchronously.
	CreateSessionTemplate(context.Context, *CreateSessionTemplateRequest) (*SessionTemplate, error)
	// Updates the session template synchronously.
	UpdateSessionTemplate(context.Context, *UpdateSessionTemplateRequest) (*SessionTemplate, error)
	// Gets the resource representation for a session template.
	GetSessionTemplate(context.Context, *GetSessionTemplateRequest) (*SessionTemplate, error)
	// Lists session templates.
	ListSessionTemplates(context.Context, *ListSessionTemplatesRequest) (*ListSessionTemplatesResponse, error)
	// Deletes a session template.
	DeleteSessionTemplate(context.Context, *DeleteSessionTemplateRequest) (*emptypb.Empty, error)
}

// UnimplementedSessionTemplateControllerServer should be embedded to have forward compatible implementations.
type UnimplementedSessionTemplateControllerServer struct {
}

func (UnimplementedSessionTemplateControllerServer) CreateSessionTemplate(context.Context, *CreateSessionTemplateRequest) (*SessionTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSessionTemplate not implemented")
}
func (UnimplementedSessionTemplateControllerServer) UpdateSessionTemplate(context.Context, *UpdateSessionTemplateRequest) (*SessionTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSessionTemplate not implemented")
}
func (UnimplementedSessionTemplateControllerServer) GetSessionTemplate(context.Context, *GetSessionTemplateRequest) (*SessionTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSessionTemplate not implemented")
}
func (UnimplementedSessionTemplateControllerServer) ListSessionTemplates(context.Context, *ListSessionTemplatesRequest) (*ListSessionTemplatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSessionTemplates not implemented")
}
func (UnimplementedSessionTemplateControllerServer) DeleteSessionTemplate(context.Context, *DeleteSessionTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSessionTemplate not implemented")
}

// UnsafeSessionTemplateControllerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SessionTemplateControllerServer will
// result in compilation errors.
type UnsafeSessionTemplateControllerServer interface {
	mustEmbedUnimplementedSessionTemplateControllerServer()
}

func RegisterSessionTemplateControllerServer(s grpc.ServiceRegistrar, srv SessionTemplateControllerServer) {
	s.RegisterService(&SessionTemplateController_ServiceDesc, srv)
}

func _SessionTemplateController_CreateSessionTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionTemplateControllerServer).CreateSessionTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SessionTemplateController_CreateSessionTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionTemplateControllerServer).CreateSessionTemplate(ctx, req.(*CreateSessionTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionTemplateController_UpdateSessionTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSessionTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionTemplateControllerServer).UpdateSessionTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SessionTemplateController_UpdateSessionTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionTemplateControllerServer).UpdateSessionTemplate(ctx, req.(*UpdateSessionTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionTemplateController_GetSessionTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSessionTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionTemplateControllerServer).GetSessionTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SessionTemplateController_GetSessionTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionTemplateControllerServer).GetSessionTemplate(ctx, req.(*GetSessionTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionTemplateController_ListSessionTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionTemplateControllerServer).ListSessionTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SessionTemplateController_ListSessionTemplates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionTemplateControllerServer).ListSessionTemplates(ctx, req.(*ListSessionTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SessionTemplateController_DeleteSessionTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSessionTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionTemplateControllerServer).DeleteSessionTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SessionTemplateController_DeleteSessionTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionTemplateControllerServer).DeleteSessionTemplate(ctx, req.(*DeleteSessionTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SessionTemplateController_ServiceDesc is the grpc.ServiceDesc for SessionTemplateController service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SessionTemplateController_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.SessionTemplateController",
	HandlerType: (*SessionTemplateControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSessionTemplate",
			Handler:    _SessionTemplateController_CreateSessionTemplate_Handler,
		},
		{
			MethodName: "UpdateSessionTemplate",
			Handler:    _SessionTemplateController_UpdateSessionTemplate_Handler,
		},
		{
			MethodName: "GetSessionTemplate",
			Handler:    _SessionTemplateController_GetSessionTemplate_Handler,
		},
		{
			MethodName: "ListSessionTemplates",
			Handler:    _SessionTemplateController_ListSessionTemplates_Handler,
		},
		{
			MethodName: "DeleteSessionTemplate",
			Handler:    _SessionTemplateController_DeleteSessionTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/session_templates.proto",
}
