// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/dataform/v1beta1/dataform.proto

package dataformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	interval "google.golang.org/genproto/googleapis/type/interval"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Repository_GitRemoteSettings_TokenStatus int32

const (
	// Default value. This value is unused.
	Repository_GitRemoteSettings_TOKEN_STATUS_UNSPECIFIED Repository_GitRemoteSettings_TokenStatus = 0
	// The token could not be found in Secret Manager (or the Dataform
	// Service Account did not have permission to access it).
	Repository_GitRemoteSettings_NOT_FOUND Repository_GitRemoteSettings_TokenStatus = 1
	// The token could not be used to authenticate against the Git remote.
	Repository_GitRemoteSettings_INVALID Repository_GitRemoteSettings_TokenStatus = 2
	// The token was used successfully to authenticate against the Git remote.
	Repository_GitRemoteSettings_VALID Repository_GitRemoteSettings_TokenStatus = 3
)

// Enum value maps for Repository_GitRemoteSettings_TokenStatus.
var (
	Repository_GitRemoteSettings_TokenStatus_name = map[int32]string{
		0: "TOKEN_STATUS_UNSPECIFIED",
		1: "NOT_FOUND",
		2: "INVALID",
		3: "VALID",
	}
	Repository_GitRemoteSettings_TokenStatus_value = map[string]int32{
		"TOKEN_STATUS_UNSPECIFIED": 0,
		"NOT_FOUND":                1,
		"INVALID":                  2,
		"VALID":                    3,
	}
)

func (x Repository_GitRemoteSettings_TokenStatus) Enum() *Repository_GitRemoteSettings_TokenStatus {
	p := new(Repository_GitRemoteSettings_TokenStatus)
	*p = x
	return p
}

func (x Repository_GitRemoteSettings_TokenStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Repository_GitRemoteSettings_TokenStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[0].Descriptor()
}

func (Repository_GitRemoteSettings_TokenStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[0]
}

func (x Repository_GitRemoteSettings_TokenStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Repository_GitRemoteSettings_TokenStatus.Descriptor instead.
func (Repository_GitRemoteSettings_TokenStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Indicates the status of a Git authentication token.
type ComputeRepositoryAccessTokenStatusResponse_TokenStatus int32

const (
	// Default value. This value is unused.
	ComputeRepositoryAccessTokenStatusResponse_TOKEN_STATUS_UNSPECIFIED ComputeRepositoryAccessTokenStatusResponse_TokenStatus = 0
	// The token could not be found in Secret Manager (or the Dataform
	// Service Account did not have permission to access it).
	ComputeRepositoryAccessTokenStatusResponse_NOT_FOUND ComputeRepositoryAccessTokenStatusResponse_TokenStatus = 1
	// The token could not be used to authenticate against the Git remote.
	ComputeRepositoryAccessTokenStatusResponse_INVALID ComputeRepositoryAccessTokenStatusResponse_TokenStatus = 2
	// The token was used successfully to authenticate against the Git remote.
	ComputeRepositoryAccessTokenStatusResponse_VALID ComputeRepositoryAccessTokenStatusResponse_TokenStatus = 3
)

// Enum value maps for ComputeRepositoryAccessTokenStatusResponse_TokenStatus.
var (
	ComputeRepositoryAccessTokenStatusResponse_TokenStatus_name = map[int32]string{
		0: "TOKEN_STATUS_UNSPECIFIED",
		1: "NOT_FOUND",
		2: "INVALID",
		3: "VALID",
	}
	ComputeRepositoryAccessTokenStatusResponse_TokenStatus_value = map[string]int32{
		"TOKEN_STATUS_UNSPECIFIED": 0,
		"NOT_FOUND":                1,
		"INVALID":                  2,
		"VALID":                    3,
	}
)

func (x ComputeRepositoryAccessTokenStatusResponse_TokenStatus) Enum() *ComputeRepositoryAccessTokenStatusResponse_TokenStatus {
	p := new(ComputeRepositoryAccessTokenStatusResponse_TokenStatus)
	*p = x
	return p
}

func (x ComputeRepositoryAccessTokenStatusResponse_TokenStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeRepositoryAccessTokenStatusResponse_TokenStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[1].Descriptor()
}

func (ComputeRepositoryAccessTokenStatusResponse_TokenStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[1]
}

func (x ComputeRepositoryAccessTokenStatusResponse_TokenStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeRepositoryAccessTokenStatusResponse_TokenStatus.Descriptor instead.
func (ComputeRepositoryAccessTokenStatusResponse_TokenStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{17, 0}
}

// Indicates the status of an uncommitted file change.
type FetchFileGitStatusesResponse_UncommittedFileChange_State int32

const (
	// Default value. This value is unused.
	FetchFileGitStatusesResponse_UncommittedFileChange_STATE_UNSPECIFIED FetchFileGitStatusesResponse_UncommittedFileChange_State = 0
	// The file has been newly added.
	FetchFileGitStatusesResponse_UncommittedFileChange_ADDED FetchFileGitStatusesResponse_UncommittedFileChange_State = 1
	// The file has been deleted.
	FetchFileGitStatusesResponse_UncommittedFileChange_DELETED FetchFileGitStatusesResponse_UncommittedFileChange_State = 2
	// The file has been modified.
	FetchFileGitStatusesResponse_UncommittedFileChange_MODIFIED FetchFileGitStatusesResponse_UncommittedFileChange_State = 3
	// The file contains merge conflicts.
	FetchFileGitStatusesResponse_UncommittedFileChange_HAS_CONFLICTS FetchFileGitStatusesResponse_UncommittedFileChange_State = 4
)

// Enum value maps for FetchFileGitStatusesResponse_UncommittedFileChange_State.
var (
	FetchFileGitStatusesResponse_UncommittedFileChange_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ADDED",
		2: "DELETED",
		3: "MODIFIED",
		4: "HAS_CONFLICTS",
	}
	FetchFileGitStatusesResponse_UncommittedFileChange_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ADDED":             1,
		"DELETED":           2,
		"MODIFIED":          3,
		"HAS_CONFLICTS":     4,
	}
)

func (x FetchFileGitStatusesResponse_UncommittedFileChange_State) Enum() *FetchFileGitStatusesResponse_UncommittedFileChange_State {
	p := new(FetchFileGitStatusesResponse_UncommittedFileChange_State)
	*p = x
	return p
}

func (x FetchFileGitStatusesResponse_UncommittedFileChange_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FetchFileGitStatusesResponse_UncommittedFileChange_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[2].Descriptor()
}

func (FetchFileGitStatusesResponse_UncommittedFileChange_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[2]
}

func (x FetchFileGitStatusesResponse_UncommittedFileChange_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FetchFileGitStatusesResponse_UncommittedFileChange_State.Descriptor instead.
func (FetchFileGitStatusesResponse_UncommittedFileChange_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{30, 0, 0}
}

// Indicates the type of this relation.
type CompilationResultAction_Relation_RelationType int32

const (
	// Default value. This value is unused.
	CompilationResultAction_Relation_RELATION_TYPE_UNSPECIFIED CompilationResultAction_Relation_RelationType = 0
	// The relation is a table.
	CompilationResultAction_Relation_TABLE CompilationResultAction_Relation_RelationType = 1
	// The relation is a view.
	CompilationResultAction_Relation_VIEW CompilationResultAction_Relation_RelationType = 2
	// The relation is an incrementalized table.
	CompilationResultAction_Relation_INCREMENTAL_TABLE CompilationResultAction_Relation_RelationType = 3
	// The relation is a materialized view.
	CompilationResultAction_Relation_MATERIALIZED_VIEW CompilationResultAction_Relation_RelationType = 4
)

// Enum value maps for CompilationResultAction_Relation_RelationType.
var (
	CompilationResultAction_Relation_RelationType_name = map[int32]string{
		0: "RELATION_TYPE_UNSPECIFIED",
		1: "TABLE",
		2: "VIEW",
		3: "INCREMENTAL_TABLE",
		4: "MATERIALIZED_VIEW",
	}
	CompilationResultAction_Relation_RelationType_value = map[string]int32{
		"RELATION_TYPE_UNSPECIFIED": 0,
		"TABLE":                     1,
		"VIEW":                      2,
		"INCREMENTAL_TABLE":         3,
		"MATERIALIZED_VIEW":         4,
	}
)

func (x CompilationResultAction_Relation_RelationType) Enum() *CompilationResultAction_Relation_RelationType {
	p := new(CompilationResultAction_Relation_RelationType)
	*p = x
	return p
}

func (x CompilationResultAction_Relation_RelationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompilationResultAction_Relation_RelationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[3].Descriptor()
}

func (CompilationResultAction_Relation_RelationType) Type() protoreflect.EnumType {
	return &file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[3]
}

func (x CompilationResultAction_Relation_RelationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompilationResultAction_Relation_RelationType.Descriptor instead.
func (CompilationResultAction_Relation_RelationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{69, 0, 0}
}

// Represents the current state of a workflow invocation.
type WorkflowInvocation_State int32

const (
	// Default value. This value is unused.
	WorkflowInvocation_STATE_UNSPECIFIED WorkflowInvocation_State = 0
	// The workflow invocation is currently running.
	WorkflowInvocation_RUNNING WorkflowInvocation_State = 1
	// The workflow invocation succeeded. A terminal state.
	WorkflowInvocation_SUCCEEDED WorkflowInvocation_State = 2
	// The workflow invocation was cancelled. A terminal state.
	WorkflowInvocation_CANCELLED WorkflowInvocation_State = 3
	// The workflow invocation failed. A terminal state.
	WorkflowInvocation_FAILED WorkflowInvocation_State = 4
	// The workflow invocation is being cancelled, but some actions are still
	// running.
	WorkflowInvocation_CANCELING WorkflowInvocation_State = 5
)

// Enum value maps for WorkflowInvocation_State.
var (
	WorkflowInvocation_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "SUCCEEDED",
		3: "CANCELLED",
		4: "FAILED",
		5: "CANCELING",
	}
	WorkflowInvocation_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"SUCCEEDED":         2,
		"CANCELLED":         3,
		"FAILED":            4,
		"CANCELING":         5,
	}
)

func (x WorkflowInvocation_State) Enum() *WorkflowInvocation_State {
	p := new(WorkflowInvocation_State)
	*p = x
	return p
}

func (x WorkflowInvocation_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkflowInvocation_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[4].Descriptor()
}

func (WorkflowInvocation_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[4]
}

func (x WorkflowInvocation_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkflowInvocation_State.Descriptor instead.
func (WorkflowInvocation_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{80, 0}
}

// Represents the current state of a workflow invocation action.
type WorkflowInvocationAction_State int32

const (
	// The action has not yet been considered for invocation.
	WorkflowInvocationAction_PENDING WorkflowInvocationAction_State = 0
	// The action is currently running.
	WorkflowInvocationAction_RUNNING WorkflowInvocationAction_State = 1
	// Execution of the action was skipped because upstream dependencies did not
	// all complete successfully. A terminal state.
	WorkflowInvocationAction_SKIPPED WorkflowInvocationAction_State = 2
	// Execution of the action was disabled as per the configuration of the
	// corresponding compilation result action. A terminal state.
	WorkflowInvocationAction_DISABLED WorkflowInvocationAction_State = 3
	// The action succeeded. A terminal state.
	WorkflowInvocationAction_SUCCEEDED WorkflowInvocationAction_State = 4
	// The action was cancelled. A terminal state.
	WorkflowInvocationAction_CANCELLED WorkflowInvocationAction_State = 5
	// The action failed. A terminal state.
	WorkflowInvocationAction_FAILED WorkflowInvocationAction_State = 6
)

// Enum value maps for WorkflowInvocationAction_State.
var (
	WorkflowInvocationAction_State_name = map[int32]string{
		0: "PENDING",
		1: "RUNNING",
		2: "SKIPPED",
		3: "DISABLED",
		4: "SUCCEEDED",
		5: "CANCELLED",
		6: "FAILED",
	}
	WorkflowInvocationAction_State_value = map[string]int32{
		"PENDING":   0,
		"RUNNING":   1,
		"SKIPPED":   2,
		"DISABLED":  3,
		"SUCCEEDED": 4,
		"CANCELLED": 5,
		"FAILED":    6,
	}
)

func (x WorkflowInvocationAction_State) Enum() *WorkflowInvocationAction_State {
	p := new(WorkflowInvocationAction_State)
	*p = x
	return p
}

func (x WorkflowInvocationAction_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkflowInvocationAction_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[5].Descriptor()
}

func (WorkflowInvocationAction_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes[5]
}

func (x WorkflowInvocationAction_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkflowInvocationAction_State.Descriptor instead.
func (WorkflowInvocationAction_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{87, 0}
}

// Represents a Dataform Git repository.
type Repository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The repository's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The repository's user-friendly name.
	DisplayName string `protobuf:"bytes,8,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. If set, configures this repository to be linked to a Git remote.
	GitRemoteSettings *Repository_GitRemoteSettings `protobuf:"bytes,2,opt,name=git_remote_settings,json=gitRemoteSettings,proto3" json:"git_remote_settings,omitempty"`
	// Optional. The name of the Secret Manager secret version to be used to
	// interpolate variables into the .npmrc file for package installation
	// operations. Must be in the format `projects/*/secrets/*/versions/*`. The
	// file itself must be in a JSON format.
	NpmrcEnvironmentVariablesSecretVersion string `protobuf:"bytes,3,opt,name=npmrc_environment_variables_secret_version,json=npmrcEnvironmentVariablesSecretVersion,proto3" json:"npmrc_environment_variables_secret_version,omitempty"`
	// Optional. If set, fields of `workspace_compilation_overrides` override the
	// default compilation settings that are specified in dataform.json when
	// creating workspace-scoped compilation results. See documentation for
	// `WorkspaceCompilationOverrides` for more information.
	WorkspaceCompilationOverrides *Repository_WorkspaceCompilationOverrides `protobuf:"bytes,4,opt,name=workspace_compilation_overrides,json=workspaceCompilationOverrides,proto3" json:"workspace_compilation_overrides,omitempty"`
	// Optional. Repository user labels.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Input only. If set to true, the authenticated user will be
	// granted the roles/dataform.admin role on the created repository. To modify
	// access to the created repository later apply setIamPolicy from
	// https://cloud.google.com/dataform/reference/rest#rest-resource:-v1beta1.projects.locations.repositories
	SetAuthenticatedUserAdmin bool `protobuf:"varint,9,opt,name=set_authenticated_user_admin,json=setAuthenticatedUserAdmin,proto3" json:"set_authenticated_user_admin,omitempty"`
	// Optional. The service account to run workflow invocations under.
	ServiceAccount string `protobuf:"bytes,10,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *Repository) Reset() {
	*x = Repository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Repository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repository) ProtoMessage() {}

func (x *Repository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Repository.ProtoReflect.Descriptor instead.
func (*Repository) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{0}
}

func (x *Repository) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Repository) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Repository) GetGitRemoteSettings() *Repository_GitRemoteSettings {
	if x != nil {
		return x.GitRemoteSettings
	}
	return nil
}

func (x *Repository) GetNpmrcEnvironmentVariablesSecretVersion() string {
	if x != nil {
		return x.NpmrcEnvironmentVariablesSecretVersion
	}
	return ""
}

func (x *Repository) GetWorkspaceCompilationOverrides() *Repository_WorkspaceCompilationOverrides {
	if x != nil {
		return x.WorkspaceCompilationOverrides
	}
	return nil
}

func (x *Repository) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Repository) GetSetAuthenticatedUserAdmin() bool {
	if x != nil {
		return x.SetAuthenticatedUserAdmin
	}
	return false
}

func (x *Repository) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

// `ListRepositories` request message.
type ListRepositoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location in which to list repositories. Must be in the format
	// `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of repositories to return. The server may return
	// fewer items than requested. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListRepositories` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListRepositories`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. This field only supports ordering by `name`. If unspecified, the
	// server will choose the ordering. If specified, the default order is
	// ascending for the `name` field.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. Filter for the returned list.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListRepositoriesRequest) Reset() {
	*x = ListRepositoriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesRequest) ProtoMessage() {}

func (x *ListRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRepositoriesRequest.ProtoReflect.Descriptor instead.
func (*ListRepositoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{1}
}

func (x *ListRepositoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRepositoriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRepositoriesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListRepositoriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// `ListRepositories` response message.
type ListRepositoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of repositories.
	Repositories []*Repository `protobuf:"bytes,1,rep,name=repositories,proto3" json:"repositories,omitempty"`
	// A token which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations which could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRepositoriesResponse) Reset() {
	*x = ListRepositoriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesResponse) ProtoMessage() {}

func (x *ListRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRepositoriesResponse.ProtoReflect.Descriptor instead.
func (*ListRepositoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{2}
}

func (x *ListRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		return x.Repositories
	}
	return nil
}

func (x *ListRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRepositoriesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// `GetRepository` request message.
type GetRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRepositoryRequest) Reset() {
	*x = GetRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryRequest) ProtoMessage() {}

func (x *GetRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRepositoryRequest.ProtoReflect.Descriptor instead.
func (*GetRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{3}
}

func (x *GetRepositoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `CreateRepository` request message.
type CreateRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location in which to create the repository. Must be in the
	// format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The repository to create.
	Repository *Repository `protobuf:"bytes,2,opt,name=repository,proto3" json:"repository,omitempty"`
	// Required. The ID to use for the repository, which will become the final
	// component of the repository's resource name.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
}

func (x *CreateRepositoryRequest) Reset() {
	*x = CreateRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRepositoryRequest) ProtoMessage() {}

func (x *CreateRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRepositoryRequest.ProtoReflect.Descriptor instead.
func (*CreateRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{4}
}

func (x *CreateRepositoryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRepositoryRequest) GetRepository() *Repository {
	if x != nil {
		return x.Repository
	}
	return nil
}

func (x *CreateRepositoryRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

// `UpdateRepository` request message.
type UpdateRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the fields to be updated in the repository. If left
	// unset, all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The repository to update.
	Repository *Repository `protobuf:"bytes,2,opt,name=repository,proto3" json:"repository,omitempty"`
}

func (x *UpdateRepositoryRequest) Reset() {
	*x = UpdateRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRepositoryRequest) ProtoMessage() {}

func (x *UpdateRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRepositoryRequest.ProtoReflect.Descriptor instead.
func (*UpdateRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateRepositoryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateRepositoryRequest) GetRepository() *Repository {
	if x != nil {
		return x.Repository
	}
	return nil
}

// `DeleteRepository` request message.
type DeleteRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, any child resources of this repository will also be
	// deleted. (Otherwise, the request will only succeed if the repository has no
	// child resources.)
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteRepositoryRequest) Reset() {
	*x = DeleteRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryRequest) ProtoMessage() {}

func (x *DeleteRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRepositoryRequest.ProtoReflect.Descriptor instead.
func (*DeleteRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteRepositoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRepositoryRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// `CommitRepositoryChanges` request message.
type CommitRepositoryChangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The changes to commit to the repository.
	CommitMetadata *CommitMetadata `protobuf:"bytes,2,opt,name=commit_metadata,json=commitMetadata,proto3" json:"commit_metadata,omitempty"`
	// Optional. The commit SHA which must be the repository's current HEAD before
	// applying this commit; otherwise this request will fail. If unset, no
	// validation on the current HEAD commit SHA is performed.
	RequiredHeadCommitSha string `protobuf:"bytes,4,opt,name=required_head_commit_sha,json=requiredHeadCommitSha,proto3" json:"required_head_commit_sha,omitempty"`
	// A map to the path of the file to the operation. The path is the full file
	// path including filename, from repository root.
	FileOperations map[string]*CommitRepositoryChangesRequest_FileOperation `protobuf:"bytes,3,rep,name=file_operations,json=fileOperations,proto3" json:"file_operations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CommitRepositoryChangesRequest) Reset() {
	*x = CommitRepositoryChangesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRepositoryChangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRepositoryChangesRequest) ProtoMessage() {}

func (x *CommitRepositoryChangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRepositoryChangesRequest.ProtoReflect.Descriptor instead.
func (*CommitRepositoryChangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{7}
}

func (x *CommitRepositoryChangesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CommitRepositoryChangesRequest) GetCommitMetadata() *CommitMetadata {
	if x != nil {
		return x.CommitMetadata
	}
	return nil
}

func (x *CommitRepositoryChangesRequest) GetRequiredHeadCommitSha() string {
	if x != nil {
		return x.RequiredHeadCommitSha
	}
	return ""
}

func (x *CommitRepositoryChangesRequest) GetFileOperations() map[string]*CommitRepositoryChangesRequest_FileOperation {
	if x != nil {
		return x.FileOperations
	}
	return nil
}

// `ReadRepositoryFile` request message.
type ReadRepositoryFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The commit SHA for the commit to read from. If unset, the file
	// will be read from HEAD.
	CommitSha string `protobuf:"bytes,2,opt,name=commit_sha,json=commitSha,proto3" json:"commit_sha,omitempty"`
	// Required. Full file path to read including filename, from repository root.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *ReadRepositoryFileRequest) Reset() {
	*x = ReadRepositoryFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRepositoryFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRepositoryFileRequest) ProtoMessage() {}

func (x *ReadRepositoryFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRepositoryFileRequest.ProtoReflect.Descriptor instead.
func (*ReadRepositoryFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{8}
}

func (x *ReadRepositoryFileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReadRepositoryFileRequest) GetCommitSha() string {
	if x != nil {
		return x.CommitSha
	}
	return ""
}

func (x *ReadRepositoryFileRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// `ReadRepositoryFile` response message.
type ReadRepositoryFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The file's contents.
	Contents []byte `protobuf:"bytes,1,opt,name=contents,proto3" json:"contents,omitempty"`
}

func (x *ReadRepositoryFileResponse) Reset() {
	*x = ReadRepositoryFileResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRepositoryFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRepositoryFileResponse) ProtoMessage() {}

func (x *ReadRepositoryFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRepositoryFileResponse.ProtoReflect.Descriptor instead.
func (*ReadRepositoryFileResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{9}
}

func (x *ReadRepositoryFileResponse) GetContents() []byte {
	if x != nil {
		return x.Contents
	}
	return nil
}

// `QueryRepositoryDirectoryContents` request message.
type QueryRepositoryDirectoryContentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The Commit SHA for the commit to query from. If unset, the
	// directory will be queried from HEAD.
	CommitSha string `protobuf:"bytes,2,opt,name=commit_sha,json=commitSha,proto3" json:"commit_sha,omitempty"`
	// Optional. The directory's full path including directory name, relative to
	// root. If left unset, the root is used.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// Optional. Maximum number of paths to return. The server may return fewer
	// items than requested. If unspecified, the server will pick an appropriate
	// default.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous
	// `QueryRepositoryDirectoryContents` call. Provide this to retrieve the
	// subsequent page.
	//
	// When paginating, all other parameters provided to
	// `QueryRepositoryDirectoryContents` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *QueryRepositoryDirectoryContentsRequest) Reset() {
	*x = QueryRepositoryDirectoryContentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryRepositoryDirectoryContentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryRepositoryDirectoryContentsRequest) ProtoMessage() {}

func (x *QueryRepositoryDirectoryContentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryRepositoryDirectoryContentsRequest.ProtoReflect.Descriptor instead.
func (*QueryRepositoryDirectoryContentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{10}
}

func (x *QueryRepositoryDirectoryContentsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryRepositoryDirectoryContentsRequest) GetCommitSha() string {
	if x != nil {
		return x.CommitSha
	}
	return ""
}

func (x *QueryRepositoryDirectoryContentsRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *QueryRepositoryDirectoryContentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *QueryRepositoryDirectoryContentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// `QueryRepositoryDirectoryContents` response message.
type QueryRepositoryDirectoryContentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of entries in the directory.
	DirectoryEntries []*DirectoryEntry `protobuf:"bytes,1,rep,name=directory_entries,json=directoryEntries,proto3" json:"directory_entries,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *QueryRepositoryDirectoryContentsResponse) Reset() {
	*x = QueryRepositoryDirectoryContentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryRepositoryDirectoryContentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryRepositoryDirectoryContentsResponse) ProtoMessage() {}

func (x *QueryRepositoryDirectoryContentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryRepositoryDirectoryContentsResponse.ProtoReflect.Descriptor instead.
func (*QueryRepositoryDirectoryContentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{11}
}

func (x *QueryRepositoryDirectoryContentsResponse) GetDirectoryEntries() []*DirectoryEntry {
	if x != nil {
		return x.DirectoryEntries
	}
	return nil
}

func (x *QueryRepositoryDirectoryContentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// `FetchRepositoryHistory` request message.
type FetchRepositoryHistoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Maximum number of commits to return. The server may return fewer
	// items than requested. If unspecified, the server will pick an appropriate
	// default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `FetchRepositoryHistory`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `FetchRepositoryHistory`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *FetchRepositoryHistoryRequest) Reset() {
	*x = FetchRepositoryHistoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchRepositoryHistoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchRepositoryHistoryRequest) ProtoMessage() {}

func (x *FetchRepositoryHistoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchRepositoryHistoryRequest.ProtoReflect.Descriptor instead.
func (*FetchRepositoryHistoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{12}
}

func (x *FetchRepositoryHistoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FetchRepositoryHistoryRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *FetchRepositoryHistoryRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// `FetchRepositoryHistory` response message.
type FetchRepositoryHistoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of commit logs, ordered by 'git log' default order.
	Commits []*CommitLogEntry `protobuf:"bytes,1,rep,name=commits,proto3" json:"commits,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *FetchRepositoryHistoryResponse) Reset() {
	*x = FetchRepositoryHistoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchRepositoryHistoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchRepositoryHistoryResponse) ProtoMessage() {}

func (x *FetchRepositoryHistoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchRepositoryHistoryResponse.ProtoReflect.Descriptor instead.
func (*FetchRepositoryHistoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{13}
}

func (x *FetchRepositoryHistoryResponse) GetCommits() []*CommitLogEntry {
	if x != nil {
		return x.Commits
	}
	return nil
}

func (x *FetchRepositoryHistoryResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents a single commit log.
type CommitLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Commit timestamp.
	CommitTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=commit_time,json=commitTime,proto3" json:"commit_time,omitempty"`
	// The commit SHA for this commit log entry.
	CommitSha string `protobuf:"bytes,2,opt,name=commit_sha,json=commitSha,proto3" json:"commit_sha,omitempty"`
	// The commit author for this commit log entry.
	Author *CommitAuthor `protobuf:"bytes,3,opt,name=author,proto3" json:"author,omitempty"`
	// The commit message for this commit log entry.
	CommitMessage string `protobuf:"bytes,4,opt,name=commit_message,json=commitMessage,proto3" json:"commit_message,omitempty"`
}

func (x *CommitLogEntry) Reset() {
	*x = CommitLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitLogEntry) ProtoMessage() {}

func (x *CommitLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitLogEntry.ProtoReflect.Descriptor instead.
func (*CommitLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{14}
}

func (x *CommitLogEntry) GetCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTime
	}
	return nil
}

func (x *CommitLogEntry) GetCommitSha() string {
	if x != nil {
		return x.CommitSha
	}
	return ""
}

func (x *CommitLogEntry) GetAuthor() *CommitAuthor {
	if x != nil {
		return x.Author
	}
	return nil
}

func (x *CommitLogEntry) GetCommitMessage() string {
	if x != nil {
		return x.CommitMessage
	}
	return ""
}

// Represents a Dataform Git commit.
type CommitMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The commit's author.
	Author *CommitAuthor `protobuf:"bytes,1,opt,name=author,proto3" json:"author,omitempty"`
	// Optional. The commit's message.
	CommitMessage string `protobuf:"bytes,2,opt,name=commit_message,json=commitMessage,proto3" json:"commit_message,omitempty"`
}

func (x *CommitMetadata) Reset() {
	*x = CommitMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitMetadata) ProtoMessage() {}

func (x *CommitMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitMetadata.ProtoReflect.Descriptor instead.
func (*CommitMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{15}
}

func (x *CommitMetadata) GetAuthor() *CommitAuthor {
	if x != nil {
		return x.Author
	}
	return nil
}

func (x *CommitMetadata) GetCommitMessage() string {
	if x != nil {
		return x.CommitMessage
	}
	return ""
}

// `ComputeRepositoryAccessTokenStatus` request message.
type ComputeRepositoryAccessTokenStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ComputeRepositoryAccessTokenStatusRequest) Reset() {
	*x = ComputeRepositoryAccessTokenStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeRepositoryAccessTokenStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeRepositoryAccessTokenStatusRequest) ProtoMessage() {}

func (x *ComputeRepositoryAccessTokenStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeRepositoryAccessTokenStatusRequest.ProtoReflect.Descriptor instead.
func (*ComputeRepositoryAccessTokenStatusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{16}
}

func (x *ComputeRepositoryAccessTokenStatusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `ComputeRepositoryAccessTokenStatus` response message.
type ComputeRepositoryAccessTokenStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the status of the Git access token.
	TokenStatus ComputeRepositoryAccessTokenStatusResponse_TokenStatus `protobuf:"varint,1,opt,name=token_status,json=tokenStatus,proto3,enum=google.cloud.dataform.v1beta1.ComputeRepositoryAccessTokenStatusResponse_TokenStatus" json:"token_status,omitempty"`
}

func (x *ComputeRepositoryAccessTokenStatusResponse) Reset() {
	*x = ComputeRepositoryAccessTokenStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeRepositoryAccessTokenStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeRepositoryAccessTokenStatusResponse) ProtoMessage() {}

func (x *ComputeRepositoryAccessTokenStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeRepositoryAccessTokenStatusResponse.ProtoReflect.Descriptor instead.
func (*ComputeRepositoryAccessTokenStatusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{17}
}

func (x *ComputeRepositoryAccessTokenStatusResponse) GetTokenStatus() ComputeRepositoryAccessTokenStatusResponse_TokenStatus {
	if x != nil {
		return x.TokenStatus
	}
	return ComputeRepositoryAccessTokenStatusResponse_TOKEN_STATUS_UNSPECIFIED
}

// `FetchRemoteBranches` request message.
type FetchRemoteBranchesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FetchRemoteBranchesRequest) Reset() {
	*x = FetchRemoteBranchesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchRemoteBranchesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchRemoteBranchesRequest) ProtoMessage() {}

func (x *FetchRemoteBranchesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchRemoteBranchesRequest.ProtoReflect.Descriptor instead.
func (*FetchRemoteBranchesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{18}
}

func (x *FetchRemoteBranchesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `FetchRemoteBranches` response message.
type FetchRemoteBranchesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The remote repository's branch names.
	Branches []string `protobuf:"bytes,1,rep,name=branches,proto3" json:"branches,omitempty"`
}

func (x *FetchRemoteBranchesResponse) Reset() {
	*x = FetchRemoteBranchesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchRemoteBranchesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchRemoteBranchesResponse) ProtoMessage() {}

func (x *FetchRemoteBranchesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchRemoteBranchesResponse.ProtoReflect.Descriptor instead.
func (*FetchRemoteBranchesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{19}
}

func (x *FetchRemoteBranchesResponse) GetBranches() []string {
	if x != nil {
		return x.Branches
	}
	return nil
}

// Represents a Dataform Git workspace.
type Workspace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The workspace's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Workspace) Reset() {
	*x = Workspace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Workspace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workspace) ProtoMessage() {}

func (x *Workspace) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workspace.ProtoReflect.Descriptor instead.
func (*Workspace) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{20}
}

func (x *Workspace) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `ListWorkspaces` request message.
type ListWorkspacesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository in which to list workspaces. Must be in the
	// format `projects/*/locations/*/repositories/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of workspaces to return. The server may return
	// fewer items than requested. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListWorkspaces` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListWorkspaces`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. This field only supports ordering by `name`. If unspecified, the
	// server will choose the ordering. If specified, the default order is
	// ascending for the `name` field.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. Filter for the returned list.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListWorkspacesRequest) Reset() {
	*x = ListWorkspacesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkspacesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkspacesRequest) ProtoMessage() {}

func (x *ListWorkspacesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkspacesRequest.ProtoReflect.Descriptor instead.
func (*ListWorkspacesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{21}
}

func (x *ListWorkspacesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkspacesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkspacesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListWorkspacesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListWorkspacesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// `ListWorkspaces` response message.
type ListWorkspacesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of workspaces.
	Workspaces []*Workspace `protobuf:"bytes,1,rep,name=workspaces,proto3" json:"workspaces,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations which could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListWorkspacesResponse) Reset() {
	*x = ListWorkspacesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkspacesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkspacesResponse) ProtoMessage() {}

func (x *ListWorkspacesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkspacesResponse.ProtoReflect.Descriptor instead.
func (*ListWorkspacesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{22}
}

func (x *ListWorkspacesResponse) GetWorkspaces() []*Workspace {
	if x != nil {
		return x.Workspaces
	}
	return nil
}

func (x *ListWorkspacesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListWorkspacesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// `GetWorkspace` request message.
type GetWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkspaceRequest) Reset() {
	*x = GetWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkspaceRequest) ProtoMessage() {}

func (x *GetWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*GetWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{23}
}

func (x *GetWorkspaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `CreateWorkspace` request message.
type CreateWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository in which to create the workspace. Must be in the
	// format `projects/*/locations/*/repositories/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The workspace to create.
	Workspace *Workspace `protobuf:"bytes,2,opt,name=workspace,proto3" json:"workspace,omitempty"`
	// Required. The ID to use for the workspace, which will become the final
	// component of the workspace's resource name.
	WorkspaceId string `protobuf:"bytes,3,opt,name=workspace_id,json=workspaceId,proto3" json:"workspace_id,omitempty"`
}

func (x *CreateWorkspaceRequest) Reset() {
	*x = CreateWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkspaceRequest) ProtoMessage() {}

func (x *CreateWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{24}
}

func (x *CreateWorkspaceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkspaceRequest) GetWorkspace() *Workspace {
	if x != nil {
		return x.Workspace
	}
	return nil
}

func (x *CreateWorkspaceRequest) GetWorkspaceId() string {
	if x != nil {
		return x.WorkspaceId
	}
	return ""
}

// `DeleteWorkspace` request message.
type DeleteWorkspaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteWorkspaceRequest) Reset() {
	*x = DeleteWorkspaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWorkspaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkspaceRequest) ProtoMessage() {}

func (x *DeleteWorkspaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkspaceRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkspaceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{25}
}

func (x *DeleteWorkspaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents the author of a Git commit.
type CommitAuthor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The commit author's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The commit author's email address.
	EmailAddress string `protobuf:"bytes,2,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
}

func (x *CommitAuthor) Reset() {
	*x = CommitAuthor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitAuthor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitAuthor) ProtoMessage() {}

func (x *CommitAuthor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitAuthor.ProtoReflect.Descriptor instead.
func (*CommitAuthor) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{26}
}

func (x *CommitAuthor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CommitAuthor) GetEmailAddress() string {
	if x != nil {
		return x.EmailAddress
	}
	return ""
}

// `PullGitCommits` request message.
type PullGitCommitsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The name of the branch in the Git remote from which to pull
	// commits. If left unset, the repository's default branch name will be used.
	RemoteBranch string `protobuf:"bytes,2,opt,name=remote_branch,json=remoteBranch,proto3" json:"remote_branch,omitempty"`
	// Required. The author of any merge commit which may be created as a result
	// of merging fetched Git commits into this workspace.
	Author *CommitAuthor `protobuf:"bytes,3,opt,name=author,proto3" json:"author,omitempty"`
}

func (x *PullGitCommitsRequest) Reset() {
	*x = PullGitCommitsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PullGitCommitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullGitCommitsRequest) ProtoMessage() {}

func (x *PullGitCommitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullGitCommitsRequest.ProtoReflect.Descriptor instead.
func (*PullGitCommitsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{27}
}

func (x *PullGitCommitsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PullGitCommitsRequest) GetRemoteBranch() string {
	if x != nil {
		return x.RemoteBranch
	}
	return ""
}

func (x *PullGitCommitsRequest) GetAuthor() *CommitAuthor {
	if x != nil {
		return x.Author
	}
	return nil
}

// `PushGitCommits` request message.
type PushGitCommitsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The name of the branch in the Git remote to which commits should
	// be pushed. If left unset, the repository's default branch name will be
	// used.
	RemoteBranch string `protobuf:"bytes,2,opt,name=remote_branch,json=remoteBranch,proto3" json:"remote_branch,omitempty"`
}

func (x *PushGitCommitsRequest) Reset() {
	*x = PushGitCommitsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PushGitCommitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushGitCommitsRequest) ProtoMessage() {}

func (x *PushGitCommitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushGitCommitsRequest.ProtoReflect.Descriptor instead.
func (*PushGitCommitsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{28}
}

func (x *PushGitCommitsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PushGitCommitsRequest) GetRemoteBranch() string {
	if x != nil {
		return x.RemoteBranch
	}
	return ""
}

// `FetchFileGitStatuses` request message.
type FetchFileGitStatusesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FetchFileGitStatusesRequest) Reset() {
	*x = FetchFileGitStatusesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchFileGitStatusesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchFileGitStatusesRequest) ProtoMessage() {}

func (x *FetchFileGitStatusesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchFileGitStatusesRequest.ProtoReflect.Descriptor instead.
func (*FetchFileGitStatusesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{29}
}

func (x *FetchFileGitStatusesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `FetchFileGitStatuses` response message.
type FetchFileGitStatusesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of all files which have uncommitted Git changes. There will only be
	// a single entry for any given file.
	UncommittedFileChanges []*FetchFileGitStatusesResponse_UncommittedFileChange `protobuf:"bytes,1,rep,name=uncommitted_file_changes,json=uncommittedFileChanges,proto3" json:"uncommitted_file_changes,omitempty"`
}

func (x *FetchFileGitStatusesResponse) Reset() {
	*x = FetchFileGitStatusesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchFileGitStatusesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchFileGitStatusesResponse) ProtoMessage() {}

func (x *FetchFileGitStatusesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchFileGitStatusesResponse.ProtoReflect.Descriptor instead.
func (*FetchFileGitStatusesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{30}
}

func (x *FetchFileGitStatusesResponse) GetUncommittedFileChanges() []*FetchFileGitStatusesResponse_UncommittedFileChange {
	if x != nil {
		return x.UncommittedFileChanges
	}
	return nil
}

// `FetchGitAheadBehind` request message.
type FetchGitAheadBehindRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The name of the branch in the Git remote against which this
	// workspace should be compared. If left unset, the repository's default
	// branch name will be used.
	RemoteBranch string `protobuf:"bytes,2,opt,name=remote_branch,json=remoteBranch,proto3" json:"remote_branch,omitempty"`
}

func (x *FetchGitAheadBehindRequest) Reset() {
	*x = FetchGitAheadBehindRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchGitAheadBehindRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchGitAheadBehindRequest) ProtoMessage() {}

func (x *FetchGitAheadBehindRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchGitAheadBehindRequest.ProtoReflect.Descriptor instead.
func (*FetchGitAheadBehindRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{31}
}

func (x *FetchGitAheadBehindRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FetchGitAheadBehindRequest) GetRemoteBranch() string {
	if x != nil {
		return x.RemoteBranch
	}
	return ""
}

// `FetchGitAheadBehind` response message.
type FetchGitAheadBehindResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of commits in the remote branch that are not in the workspace.
	CommitsAhead int32 `protobuf:"varint,1,opt,name=commits_ahead,json=commitsAhead,proto3" json:"commits_ahead,omitempty"`
	// The number of commits in the workspace that are not in the remote branch.
	CommitsBehind int32 `protobuf:"varint,2,opt,name=commits_behind,json=commitsBehind,proto3" json:"commits_behind,omitempty"`
}

func (x *FetchGitAheadBehindResponse) Reset() {
	*x = FetchGitAheadBehindResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchGitAheadBehindResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchGitAheadBehindResponse) ProtoMessage() {}

func (x *FetchGitAheadBehindResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchGitAheadBehindResponse.ProtoReflect.Descriptor instead.
func (*FetchGitAheadBehindResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{32}
}

func (x *FetchGitAheadBehindResponse) GetCommitsAhead() int32 {
	if x != nil {
		return x.CommitsAhead
	}
	return 0
}

func (x *FetchGitAheadBehindResponse) GetCommitsBehind() int32 {
	if x != nil {
		return x.CommitsBehind
	}
	return 0
}

// `CommitWorkspaceChanges` request message.
type CommitWorkspaceChangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The commit's author.
	Author *CommitAuthor `protobuf:"bytes,4,opt,name=author,proto3" json:"author,omitempty"`
	// Optional. The commit's message.
	CommitMessage string `protobuf:"bytes,2,opt,name=commit_message,json=commitMessage,proto3" json:"commit_message,omitempty"`
	// Optional. Full file paths to commit including filename, rooted at workspace
	// root. If left empty, all files will be committed.
	Paths []string `protobuf:"bytes,3,rep,name=paths,proto3" json:"paths,omitempty"`
}

func (x *CommitWorkspaceChangesRequest) Reset() {
	*x = CommitWorkspaceChangesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitWorkspaceChangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitWorkspaceChangesRequest) ProtoMessage() {}

func (x *CommitWorkspaceChangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitWorkspaceChangesRequest.ProtoReflect.Descriptor instead.
func (*CommitWorkspaceChangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{33}
}

func (x *CommitWorkspaceChangesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CommitWorkspaceChangesRequest) GetAuthor() *CommitAuthor {
	if x != nil {
		return x.Author
	}
	return nil
}

func (x *CommitWorkspaceChangesRequest) GetCommitMessage() string {
	if x != nil {
		return x.CommitMessage
	}
	return ""
}

func (x *CommitWorkspaceChangesRequest) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

// `ResetWorkspaceChanges` request message.
type ResetWorkspaceChangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Full file paths to reset back to their committed state including
	// filename, rooted at workspace root. If left empty, all files will be reset.
	Paths []string `protobuf:"bytes,2,rep,name=paths,proto3" json:"paths,omitempty"`
	// Optional. If set to true, untracked files will be deleted.
	Clean bool `protobuf:"varint,3,opt,name=clean,proto3" json:"clean,omitempty"`
}

func (x *ResetWorkspaceChangesRequest) Reset() {
	*x = ResetWorkspaceChangesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetWorkspaceChangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetWorkspaceChangesRequest) ProtoMessage() {}

func (x *ResetWorkspaceChangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetWorkspaceChangesRequest.ProtoReflect.Descriptor instead.
func (*ResetWorkspaceChangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{34}
}

func (x *ResetWorkspaceChangesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResetWorkspaceChangesRequest) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

func (x *ResetWorkspaceChangesRequest) GetClean() bool {
	if x != nil {
		return x.Clean
	}
	return false
}

// `FetchFileDiff` request message.
type FetchFileDiffRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Workspace string `protobuf:"bytes,1,opt,name=workspace,proto3" json:"workspace,omitempty"`
	// Required. The file's full path including filename, relative to the
	// workspace root.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *FetchFileDiffRequest) Reset() {
	*x = FetchFileDiffRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchFileDiffRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchFileDiffRequest) ProtoMessage() {}

func (x *FetchFileDiffRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchFileDiffRequest.ProtoReflect.Descriptor instead.
func (*FetchFileDiffRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{35}
}

func (x *FetchFileDiffRequest) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

func (x *FetchFileDiffRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// `FetchFileDiff` response message.
type FetchFileDiffResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The raw formatted Git diff for the file.
	FormattedDiff string `protobuf:"bytes,1,opt,name=formatted_diff,json=formattedDiff,proto3" json:"formatted_diff,omitempty"`
}

func (x *FetchFileDiffResponse) Reset() {
	*x = FetchFileDiffResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchFileDiffResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchFileDiffResponse) ProtoMessage() {}

func (x *FetchFileDiffResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchFileDiffResponse.ProtoReflect.Descriptor instead.
func (*FetchFileDiffResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{36}
}

func (x *FetchFileDiffResponse) GetFormattedDiff() string {
	if x != nil {
		return x.FormattedDiff
	}
	return ""
}

// `QueryDirectoryContents` request message.
type QueryDirectoryContentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Workspace string `protobuf:"bytes,1,opt,name=workspace,proto3" json:"workspace,omitempty"`
	// Optional. The directory's full path including directory name, relative to
	// the workspace root. If left unset, the workspace root is used.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Optional. Maximum number of paths to return. The server may return fewer
	// items than requested. If unspecified, the server will pick an appropriate
	// default.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `QueryDirectoryContents`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `QueryDirectoryContents` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *QueryDirectoryContentsRequest) Reset() {
	*x = QueryDirectoryContentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryDirectoryContentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryDirectoryContentsRequest) ProtoMessage() {}

func (x *QueryDirectoryContentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryDirectoryContentsRequest.ProtoReflect.Descriptor instead.
func (*QueryDirectoryContentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{37}
}

func (x *QueryDirectoryContentsRequest) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

func (x *QueryDirectoryContentsRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *QueryDirectoryContentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *QueryDirectoryContentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// `QueryDirectoryContents` response message.
type QueryDirectoryContentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of entries in the directory.
	DirectoryEntries []*DirectoryEntry `protobuf:"bytes,1,rep,name=directory_entries,json=directoryEntries,proto3" json:"directory_entries,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *QueryDirectoryContentsResponse) Reset() {
	*x = QueryDirectoryContentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryDirectoryContentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryDirectoryContentsResponse) ProtoMessage() {}

func (x *QueryDirectoryContentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryDirectoryContentsResponse.ProtoReflect.Descriptor instead.
func (*QueryDirectoryContentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{38}
}

func (x *QueryDirectoryContentsResponse) GetDirectoryEntries() []*DirectoryEntry {
	if x != nil {
		return x.DirectoryEntries
	}
	return nil
}

func (x *QueryDirectoryContentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents a single entry in a directory.
type DirectoryEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Entry:
	//
	//	*DirectoryEntry_File
	//	*DirectoryEntry_Directory
	Entry isDirectoryEntry_Entry `protobuf_oneof:"entry"`
}

func (x *DirectoryEntry) Reset() {
	*x = DirectoryEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectoryEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectoryEntry) ProtoMessage() {}

func (x *DirectoryEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectoryEntry.ProtoReflect.Descriptor instead.
func (*DirectoryEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{39}
}

func (m *DirectoryEntry) GetEntry() isDirectoryEntry_Entry {
	if m != nil {
		return m.Entry
	}
	return nil
}

func (x *DirectoryEntry) GetFile() string {
	if x, ok := x.GetEntry().(*DirectoryEntry_File); ok {
		return x.File
	}
	return ""
}

func (x *DirectoryEntry) GetDirectory() string {
	if x, ok := x.GetEntry().(*DirectoryEntry_Directory); ok {
		return x.Directory
	}
	return ""
}

type isDirectoryEntry_Entry interface {
	isDirectoryEntry_Entry()
}

type DirectoryEntry_File struct {
	// A file in the directory.
	File string `protobuf:"bytes,1,opt,name=file,proto3,oneof"`
}

type DirectoryEntry_Directory struct {
	// A child directory in the directory.
	Directory string `protobuf:"bytes,2,opt,name=directory,proto3,oneof"`
}

func (*DirectoryEntry_File) isDirectoryEntry_Entry() {}

func (*DirectoryEntry_Directory) isDirectoryEntry_Entry() {}

// `MakeDirectory` request message.
type MakeDirectoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Workspace string `protobuf:"bytes,1,opt,name=workspace,proto3" json:"workspace,omitempty"`
	// Required. The directory's full path including directory name, relative to
	// the workspace root.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *MakeDirectoryRequest) Reset() {
	*x = MakeDirectoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MakeDirectoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MakeDirectoryRequest) ProtoMessage() {}

func (x *MakeDirectoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MakeDirectoryRequest.ProtoReflect.Descriptor instead.
func (*MakeDirectoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{40}
}

func (x *MakeDirectoryRequest) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

func (x *MakeDirectoryRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// `MakeDirectory` response message.
type MakeDirectoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MakeDirectoryResponse) Reset() {
	*x = MakeDirectoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MakeDirectoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MakeDirectoryResponse) ProtoMessage() {}

func (x *MakeDirectoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MakeDirectoryResponse.ProtoReflect.Descriptor instead.
func (*MakeDirectoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{41}
}

// `RemoveDirectory` request message.
type RemoveDirectoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Workspace string `protobuf:"bytes,1,opt,name=workspace,proto3" json:"workspace,omitempty"`
	// Required. The directory's full path including directory name, relative to
	// the workspace root.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *RemoveDirectoryRequest) Reset() {
	*x = RemoveDirectoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveDirectoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveDirectoryRequest) ProtoMessage() {}

func (x *RemoveDirectoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveDirectoryRequest.ProtoReflect.Descriptor instead.
func (*RemoveDirectoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{42}
}

func (x *RemoveDirectoryRequest) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

func (x *RemoveDirectoryRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// `MoveDirectory` request message.
type MoveDirectoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Workspace string `protobuf:"bytes,1,opt,name=workspace,proto3" json:"workspace,omitempty"`
	// Required. The directory's full path including directory name, relative to
	// the workspace root.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Required. The new path for the directory including directory name, rooted
	// at workspace root.
	NewPath string `protobuf:"bytes,3,opt,name=new_path,json=newPath,proto3" json:"new_path,omitempty"`
}

func (x *MoveDirectoryRequest) Reset() {
	*x = MoveDirectoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveDirectoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveDirectoryRequest) ProtoMessage() {}

func (x *MoveDirectoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveDirectoryRequest.ProtoReflect.Descriptor instead.
func (*MoveDirectoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{43}
}

func (x *MoveDirectoryRequest) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

func (x *MoveDirectoryRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *MoveDirectoryRequest) GetNewPath() string {
	if x != nil {
		return x.NewPath
	}
	return ""
}

// `MoveDirectory` response message.
type MoveDirectoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MoveDirectoryResponse) Reset() {
	*x = MoveDirectoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveDirectoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveDirectoryResponse) ProtoMessage() {}

func (x *MoveDirectoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveDirectoryResponse.ProtoReflect.Descriptor instead.
func (*MoveDirectoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{44}
}

// `ReadFile` request message.
type ReadFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Workspace string `protobuf:"bytes,1,opt,name=workspace,proto3" json:"workspace,omitempty"`
	// Required. The file's full path including filename, relative to the
	// workspace root.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *ReadFileRequest) Reset() {
	*x = ReadFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadFileRequest) ProtoMessage() {}

func (x *ReadFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadFileRequest.ProtoReflect.Descriptor instead.
func (*ReadFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{45}
}

func (x *ReadFileRequest) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

func (x *ReadFileRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// `ReadFile` response message.
type ReadFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The file's contents.
	FileContents []byte `protobuf:"bytes,1,opt,name=file_contents,json=fileContents,proto3" json:"file_contents,omitempty"`
}

func (x *ReadFileResponse) Reset() {
	*x = ReadFileResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadFileResponse) ProtoMessage() {}

func (x *ReadFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadFileResponse.ProtoReflect.Descriptor instead.
func (*ReadFileResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{46}
}

func (x *ReadFileResponse) GetFileContents() []byte {
	if x != nil {
		return x.FileContents
	}
	return nil
}

// `RemoveFile` request message.
type RemoveFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Workspace string `protobuf:"bytes,1,opt,name=workspace,proto3" json:"workspace,omitempty"`
	// Required. The file's full path including filename, relative to the
	// workspace root.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *RemoveFileRequest) Reset() {
	*x = RemoveFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoveFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveFileRequest) ProtoMessage() {}

func (x *RemoveFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveFileRequest.ProtoReflect.Descriptor instead.
func (*RemoveFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{47}
}

func (x *RemoveFileRequest) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

func (x *RemoveFileRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// `MoveFile` request message.
type MoveFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Workspace string `protobuf:"bytes,1,opt,name=workspace,proto3" json:"workspace,omitempty"`
	// Required. The file's full path including filename, relative to the
	// workspace root.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Required. The file's new path including filename, relative to the workspace
	// root.
	NewPath string `protobuf:"bytes,3,opt,name=new_path,json=newPath,proto3" json:"new_path,omitempty"`
}

func (x *MoveFileRequest) Reset() {
	*x = MoveFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveFileRequest) ProtoMessage() {}

func (x *MoveFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveFileRequest.ProtoReflect.Descriptor instead.
func (*MoveFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{48}
}

func (x *MoveFileRequest) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

func (x *MoveFileRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *MoveFileRequest) GetNewPath() string {
	if x != nil {
		return x.NewPath
	}
	return ""
}

// `MoveFile` response message.
type MoveFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MoveFileResponse) Reset() {
	*x = MoveFileResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveFileResponse) ProtoMessage() {}

func (x *MoveFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveFileResponse.ProtoReflect.Descriptor instead.
func (*MoveFileResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{49}
}

// `WriteFile` request message.
type WriteFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Workspace string `protobuf:"bytes,1,opt,name=workspace,proto3" json:"workspace,omitempty"`
	// Required. The file.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Required. The file's contents.
	Contents []byte `protobuf:"bytes,3,opt,name=contents,proto3" json:"contents,omitempty"`
}

func (x *WriteFileRequest) Reset() {
	*x = WriteFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteFileRequest) ProtoMessage() {}

func (x *WriteFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteFileRequest.ProtoReflect.Descriptor instead.
func (*WriteFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{50}
}

func (x *WriteFileRequest) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

func (x *WriteFileRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *WriteFileRequest) GetContents() []byte {
	if x != nil {
		return x.Contents
	}
	return nil
}

// `WriteFile` response message.
type WriteFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WriteFileResponse) Reset() {
	*x = WriteFileResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteFileResponse) ProtoMessage() {}

func (x *WriteFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteFileResponse.ProtoReflect.Descriptor instead.
func (*WriteFileResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{51}
}

// `InstallNpmPackages` request message.
type InstallNpmPackagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workspace's name.
	Workspace string `protobuf:"bytes,1,opt,name=workspace,proto3" json:"workspace,omitempty"`
}

func (x *InstallNpmPackagesRequest) Reset() {
	*x = InstallNpmPackagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallNpmPackagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallNpmPackagesRequest) ProtoMessage() {}

func (x *InstallNpmPackagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallNpmPackagesRequest.ProtoReflect.Descriptor instead.
func (*InstallNpmPackagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{52}
}

func (x *InstallNpmPackagesRequest) GetWorkspace() string {
	if x != nil {
		return x.Workspace
	}
	return ""
}

// `InstallNpmPackages` response message.
type InstallNpmPackagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InstallNpmPackagesResponse) Reset() {
	*x = InstallNpmPackagesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallNpmPackagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallNpmPackagesResponse) ProtoMessage() {}

func (x *InstallNpmPackagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallNpmPackagesResponse.ProtoReflect.Descriptor instead.
func (*InstallNpmPackagesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{53}
}

// Represents a Dataform release configuration.
type ReleaseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The release config's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Git commit/tag/branch name at which the repository should be
	// compiled. Must exist in the remote repository. Examples:
	// - a commit SHA: `12ade345`
	// - a tag: `tag1`
	// - a branch name: `branch1`
	GitCommitish string `protobuf:"bytes,2,opt,name=git_commitish,json=gitCommitish,proto3" json:"git_commitish,omitempty"`
	// Optional. If set, fields of `code_compilation_config` override the default
	// compilation settings that are specified in dataform.json.
	CodeCompilationConfig *CodeCompilationConfig `protobuf:"bytes,3,opt,name=code_compilation_config,json=codeCompilationConfig,proto3" json:"code_compilation_config,omitempty"`
	// Optional. Optional schedule (in cron format) for automatic creation of
	// compilation results.
	CronSchedule string `protobuf:"bytes,4,opt,name=cron_schedule,json=cronSchedule,proto3" json:"cron_schedule,omitempty"`
	// Optional. Specifies the time zone to be used when interpreting
	// cron_schedule. Must be a time zone name from the time zone database
	// (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
	// unspecified, the default is UTC.
	TimeZone string `protobuf:"bytes,7,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Output only. Records of the 10 most recent scheduled release attempts,
	// ordered in in descending order of `release_time`. Updated whenever
	// automatic creation of a compilation result is triggered by cron_schedule.
	RecentScheduledReleaseRecords []*ReleaseConfig_ScheduledReleaseRecord `protobuf:"bytes,5,rep,name=recent_scheduled_release_records,json=recentScheduledReleaseRecords,proto3" json:"recent_scheduled_release_records,omitempty"`
	// Optional. The name of the currently released compilation result for this
	// release config. This value is updated when a compilation result is created
	// from this release config, or when this resource is updated by API call
	// (perhaps to roll back to an earlier release). The compilation result must
	// have been created using this release config. Must be in the format
	// `projects/*/locations/*/repositories/*/compilationResults/*`.
	ReleaseCompilationResult string `protobuf:"bytes,6,opt,name=release_compilation_result,json=releaseCompilationResult,proto3" json:"release_compilation_result,omitempty"`
}

func (x *ReleaseConfig) Reset() {
	*x = ReleaseConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReleaseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseConfig) ProtoMessage() {}

func (x *ReleaseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseConfig.ProtoReflect.Descriptor instead.
func (*ReleaseConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{54}
}

func (x *ReleaseConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReleaseConfig) GetGitCommitish() string {
	if x != nil {
		return x.GitCommitish
	}
	return ""
}

func (x *ReleaseConfig) GetCodeCompilationConfig() *CodeCompilationConfig {
	if x != nil {
		return x.CodeCompilationConfig
	}
	return nil
}

func (x *ReleaseConfig) GetCronSchedule() string {
	if x != nil {
		return x.CronSchedule
	}
	return ""
}

func (x *ReleaseConfig) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *ReleaseConfig) GetRecentScheduledReleaseRecords() []*ReleaseConfig_ScheduledReleaseRecord {
	if x != nil {
		return x.RecentScheduledReleaseRecords
	}
	return nil
}

func (x *ReleaseConfig) GetReleaseCompilationResult() string {
	if x != nil {
		return x.ReleaseCompilationResult
	}
	return ""
}

// `ListReleaseConfigs` request message.
type ListReleaseConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository in which to list release configs. Must be in the
	// format `projects/*/locations/*/repositories/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of release configs to return. The server may
	// return fewer items than requested. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListReleaseConfigs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListReleaseConfigs`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListReleaseConfigsRequest) Reset() {
	*x = ListReleaseConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReleaseConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReleaseConfigsRequest) ProtoMessage() {}

func (x *ListReleaseConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReleaseConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListReleaseConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{55}
}

func (x *ListReleaseConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReleaseConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReleaseConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// `ListReleaseConfigs` response message.
type ListReleaseConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of release configs.
	ReleaseConfigs []*ReleaseConfig `protobuf:"bytes,1,rep,name=release_configs,json=releaseConfigs,proto3" json:"release_configs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations which could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListReleaseConfigsResponse) Reset() {
	*x = ListReleaseConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReleaseConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReleaseConfigsResponse) ProtoMessage() {}

func (x *ListReleaseConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReleaseConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListReleaseConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{56}
}

func (x *ListReleaseConfigsResponse) GetReleaseConfigs() []*ReleaseConfig {
	if x != nil {
		return x.ReleaseConfigs
	}
	return nil
}

func (x *ListReleaseConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListReleaseConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// `GetReleaseConfig` request message.
type GetReleaseConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The release config's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReleaseConfigRequest) Reset() {
	*x = GetReleaseConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetReleaseConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReleaseConfigRequest) ProtoMessage() {}

func (x *GetReleaseConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReleaseConfigRequest.ProtoReflect.Descriptor instead.
func (*GetReleaseConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{57}
}

func (x *GetReleaseConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `CreateReleaseConfig` request message.
type CreateReleaseConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository in which to create the release config. Must be in
	// the format `projects/*/locations/*/repositories/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The release config to create.
	ReleaseConfig *ReleaseConfig `protobuf:"bytes,2,opt,name=release_config,json=releaseConfig,proto3" json:"release_config,omitempty"`
	// Required. The ID to use for the release config, which will become the final
	// component of the release config's resource name.
	ReleaseConfigId string `protobuf:"bytes,3,opt,name=release_config_id,json=releaseConfigId,proto3" json:"release_config_id,omitempty"`
}

func (x *CreateReleaseConfigRequest) Reset() {
	*x = CreateReleaseConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateReleaseConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReleaseConfigRequest) ProtoMessage() {}

func (x *CreateReleaseConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReleaseConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateReleaseConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{58}
}

func (x *CreateReleaseConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReleaseConfigRequest) GetReleaseConfig() *ReleaseConfig {
	if x != nil {
		return x.ReleaseConfig
	}
	return nil
}

func (x *CreateReleaseConfigRequest) GetReleaseConfigId() string {
	if x != nil {
		return x.ReleaseConfigId
	}
	return ""
}

// `UpdateReleaseConfig` request message.
type UpdateReleaseConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the fields to be updated in the release config. If left
	// unset, all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The release config to update.
	ReleaseConfig *ReleaseConfig `protobuf:"bytes,2,opt,name=release_config,json=releaseConfig,proto3" json:"release_config,omitempty"`
}

func (x *UpdateReleaseConfigRequest) Reset() {
	*x = UpdateReleaseConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateReleaseConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateReleaseConfigRequest) ProtoMessage() {}

func (x *UpdateReleaseConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateReleaseConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateReleaseConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{59}
}

func (x *UpdateReleaseConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateReleaseConfigRequest) GetReleaseConfig() *ReleaseConfig {
	if x != nil {
		return x.ReleaseConfig
	}
	return nil
}

// `DeleteReleaseConfig` request message.
type DeleteReleaseConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The release config's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteReleaseConfigRequest) Reset() {
	*x = DeleteReleaseConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteReleaseConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReleaseConfigRequest) ProtoMessage() {}

func (x *DeleteReleaseConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReleaseConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteReleaseConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{60}
}

func (x *DeleteReleaseConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents the result of compiling a Dataform project.
type CompilationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The compilation result's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to Source:
	//
	//	*CompilationResult_GitCommitish
	//	*CompilationResult_Workspace
	//	*CompilationResult_ReleaseConfig
	Source isCompilationResult_Source `protobuf_oneof:"source"`
	// Immutable. If set, fields of `code_compilation_config` override the default
	// compilation settings that are specified in dataform.json.
	CodeCompilationConfig *CodeCompilationConfig `protobuf:"bytes,4,opt,name=code_compilation_config,json=codeCompilationConfig,proto3" json:"code_compilation_config,omitempty"`
	// Output only. The fully resolved Git commit SHA of the code that was
	// compiled. Not set for compilation results whose source is a workspace.
	ResolvedGitCommitSha string `protobuf:"bytes,8,opt,name=resolved_git_commit_sha,json=resolvedGitCommitSha,proto3" json:"resolved_git_commit_sha,omitempty"`
	// Output only. The version of `@dataform/core` that was used for compilation.
	DataformCoreVersion string `protobuf:"bytes,5,opt,name=dataform_core_version,json=dataformCoreVersion,proto3" json:"dataform_core_version,omitempty"`
	// Output only. Errors encountered during project compilation.
	CompilationErrors []*CompilationResult_CompilationError `protobuf:"bytes,6,rep,name=compilation_errors,json=compilationErrors,proto3" json:"compilation_errors,omitempty"`
}

func (x *CompilationResult) Reset() {
	*x = CompilationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompilationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompilationResult) ProtoMessage() {}

func (x *CompilationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompilationResult.ProtoReflect.Descriptor instead.
func (*CompilationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{61}
}

func (x *CompilationResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *CompilationResult) GetSource() isCompilationResult_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *CompilationResult) GetGitCommitish() string {
	if x, ok := x.GetSource().(*CompilationResult_GitCommitish); ok {
		return x.GitCommitish
	}
	return ""
}

func (x *CompilationResult) GetWorkspace() string {
	if x, ok := x.GetSource().(*CompilationResult_Workspace); ok {
		return x.Workspace
	}
	return ""
}

func (x *CompilationResult) GetReleaseConfig() string {
	if x, ok := x.GetSource().(*CompilationResult_ReleaseConfig); ok {
		return x.ReleaseConfig
	}
	return ""
}

func (x *CompilationResult) GetCodeCompilationConfig() *CodeCompilationConfig {
	if x != nil {
		return x.CodeCompilationConfig
	}
	return nil
}

func (x *CompilationResult) GetResolvedGitCommitSha() string {
	if x != nil {
		return x.ResolvedGitCommitSha
	}
	return ""
}

func (x *CompilationResult) GetDataformCoreVersion() string {
	if x != nil {
		return x.DataformCoreVersion
	}
	return ""
}

func (x *CompilationResult) GetCompilationErrors() []*CompilationResult_CompilationError {
	if x != nil {
		return x.CompilationErrors
	}
	return nil
}

type isCompilationResult_Source interface {
	isCompilationResult_Source()
}

type CompilationResult_GitCommitish struct {
	// Immutable. Git commit/tag/branch name at which the repository should be
	// compiled. Must exist in the remote repository. Examples:
	// - a commit SHA: `12ade345`
	// - a tag: `tag1`
	// - a branch name: `branch1`
	GitCommitish string `protobuf:"bytes,2,opt,name=git_commitish,json=gitCommitish,proto3,oneof"`
}

type CompilationResult_Workspace struct {
	// Immutable. The name of the workspace to compile. Must be in the format
	// `projects/*/locations/*/repositories/*/workspaces/*`.
	Workspace string `protobuf:"bytes,3,opt,name=workspace,proto3,oneof"`
}

type CompilationResult_ReleaseConfig struct {
	// Immutable. The name of the release config to compile. The release
	// config's 'current_compilation_result' field will be updated to this
	// compilation result. Must be in the format
	// `projects/*/locations/*/repositories/*/releaseConfigs/*`.
	ReleaseConfig string `protobuf:"bytes,7,opt,name=release_config,json=releaseConfig,proto3,oneof"`
}

func (*CompilationResult_GitCommitish) isCompilationResult_Source() {}

func (*CompilationResult_Workspace) isCompilationResult_Source() {}

func (*CompilationResult_ReleaseConfig) isCompilationResult_Source() {}

// Configures various aspects of Dataform code compilation.
type CodeCompilationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The default database (Google Cloud project ID).
	DefaultDatabase string `protobuf:"bytes,1,opt,name=default_database,json=defaultDatabase,proto3" json:"default_database,omitempty"`
	// Optional. The default schema (BigQuery dataset ID).
	DefaultSchema string `protobuf:"bytes,2,opt,name=default_schema,json=defaultSchema,proto3" json:"default_schema,omitempty"`
	// Optional. The default BigQuery location to use. Defaults to "US".
	// See the BigQuery docs for a full list of locations:
	// https://cloud.google.com/bigquery/docs/locations.
	DefaultLocation string `protobuf:"bytes,8,opt,name=default_location,json=defaultLocation,proto3" json:"default_location,omitempty"`
	// Optional. The default schema (BigQuery dataset ID) for assertions.
	AssertionSchema string `protobuf:"bytes,3,opt,name=assertion_schema,json=assertionSchema,proto3" json:"assertion_schema,omitempty"`
	// Optional. User-defined variables that are made available to project code
	// during compilation.
	Vars map[string]string `protobuf:"bytes,4,rep,name=vars,proto3" json:"vars,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The suffix that should be appended to all database (Google Cloud
	// project ID) names.
	DatabaseSuffix string `protobuf:"bytes,5,opt,name=database_suffix,json=databaseSuffix,proto3" json:"database_suffix,omitempty"`
	// Optional. The suffix that should be appended to all schema (BigQuery
	// dataset ID) names.
	SchemaSuffix string `protobuf:"bytes,6,opt,name=schema_suffix,json=schemaSuffix,proto3" json:"schema_suffix,omitempty"`
	// Optional. The prefix that should be prepended to all table names.
	TablePrefix string `protobuf:"bytes,7,opt,name=table_prefix,json=tablePrefix,proto3" json:"table_prefix,omitempty"`
}

func (x *CodeCompilationConfig) Reset() {
	*x = CodeCompilationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CodeCompilationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CodeCompilationConfig) ProtoMessage() {}

func (x *CodeCompilationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CodeCompilationConfig.ProtoReflect.Descriptor instead.
func (*CodeCompilationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{62}
}

func (x *CodeCompilationConfig) GetDefaultDatabase() string {
	if x != nil {
		return x.DefaultDatabase
	}
	return ""
}

func (x *CodeCompilationConfig) GetDefaultSchema() string {
	if x != nil {
		return x.DefaultSchema
	}
	return ""
}

func (x *CodeCompilationConfig) GetDefaultLocation() string {
	if x != nil {
		return x.DefaultLocation
	}
	return ""
}

func (x *CodeCompilationConfig) GetAssertionSchema() string {
	if x != nil {
		return x.AssertionSchema
	}
	return ""
}

func (x *CodeCompilationConfig) GetVars() map[string]string {
	if x != nil {
		return x.Vars
	}
	return nil
}

func (x *CodeCompilationConfig) GetDatabaseSuffix() string {
	if x != nil {
		return x.DatabaseSuffix
	}
	return ""
}

func (x *CodeCompilationConfig) GetSchemaSuffix() string {
	if x != nil {
		return x.SchemaSuffix
	}
	return ""
}

func (x *CodeCompilationConfig) GetTablePrefix() string {
	if x != nil {
		return x.TablePrefix
	}
	return ""
}

// `ListCompilationResults` request message.
type ListCompilationResultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository in which to list compilation results. Must be in
	// the format `projects/*/locations/*/repositories/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of compilation results to return. The server may
	// return fewer items than requested. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListCompilationResults`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCompilationResults`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCompilationResultsRequest) Reset() {
	*x = ListCompilationResultsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCompilationResultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCompilationResultsRequest) ProtoMessage() {}

func (x *ListCompilationResultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCompilationResultsRequest.ProtoReflect.Descriptor instead.
func (*ListCompilationResultsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{63}
}

func (x *ListCompilationResultsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCompilationResultsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCompilationResultsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// `ListCompilationResults` response message.
type ListCompilationResultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of compilation results.
	CompilationResults []*CompilationResult `protobuf:"bytes,1,rep,name=compilation_results,json=compilationResults,proto3" json:"compilation_results,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations which could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCompilationResultsResponse) Reset() {
	*x = ListCompilationResultsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCompilationResultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCompilationResultsResponse) ProtoMessage() {}

func (x *ListCompilationResultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCompilationResultsResponse.ProtoReflect.Descriptor instead.
func (*ListCompilationResultsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{64}
}

func (x *ListCompilationResultsResponse) GetCompilationResults() []*CompilationResult {
	if x != nil {
		return x.CompilationResults
	}
	return nil
}

func (x *ListCompilationResultsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCompilationResultsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// `GetCompilationResult` request message.
type GetCompilationResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The compilation result's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCompilationResultRequest) Reset() {
	*x = GetCompilationResultRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCompilationResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCompilationResultRequest) ProtoMessage() {}

func (x *GetCompilationResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCompilationResultRequest.ProtoReflect.Descriptor instead.
func (*GetCompilationResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{65}
}

func (x *GetCompilationResultRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `CreateCompilationResult` request message.
type CreateCompilationResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository in which to create the compilation result. Must be
	// in the format `projects/*/locations/*/repositories/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The compilation result to create.
	CompilationResult *CompilationResult `protobuf:"bytes,2,opt,name=compilation_result,json=compilationResult,proto3" json:"compilation_result,omitempty"`
}

func (x *CreateCompilationResultRequest) Reset() {
	*x = CreateCompilationResultRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCompilationResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCompilationResultRequest) ProtoMessage() {}

func (x *CreateCompilationResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCompilationResultRequest.ProtoReflect.Descriptor instead.
func (*CreateCompilationResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{66}
}

func (x *CreateCompilationResultRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCompilationResultRequest) GetCompilationResult() *CompilationResult {
	if x != nil {
		return x.CompilationResult
	}
	return nil
}

// Represents an action identifier. If the action writes output, the output
// will be written to the referenced database object.
type Target struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The action's database (Google Cloud project ID) .
	Database string `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	// The action's schema (BigQuery dataset ID), within `database`.
	Schema string `protobuf:"bytes,2,opt,name=schema,proto3" json:"schema,omitempty"`
	// The action's name, within `database` and `schema`.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Target) Reset() {
	*x = Target{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Target) ProtoMessage() {}

func (x *Target) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Target.ProtoReflect.Descriptor instead.
func (*Target) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{67}
}

func (x *Target) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *Target) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

func (x *Target) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Describes a relation and its columns.
type RelationDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A text description of the relation.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// A list of descriptions of columns within the relation.
	Columns []*RelationDescriptor_ColumnDescriptor `protobuf:"bytes,2,rep,name=columns,proto3" json:"columns,omitempty"`
	// A set of BigQuery labels that should be applied to the relation.
	BigqueryLabels map[string]string `protobuf:"bytes,3,rep,name=bigquery_labels,json=bigqueryLabels,proto3" json:"bigquery_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RelationDescriptor) Reset() {
	*x = RelationDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelationDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelationDescriptor) ProtoMessage() {}

func (x *RelationDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelationDescriptor.ProtoReflect.Descriptor instead.
func (*RelationDescriptor) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{68}
}

func (x *RelationDescriptor) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RelationDescriptor) GetColumns() []*RelationDescriptor_ColumnDescriptor {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *RelationDescriptor) GetBigqueryLabels() map[string]string {
	if x != nil {
		return x.BigqueryLabels
	}
	return nil
}

// Represents a single Dataform action in a compilation result.
type CompilationResultAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This action's identifier. Unique within the compilation result.
	Target *Target `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// The action's identifier if the project had been compiled without any
	// overrides configured. Unique within the compilation result.
	CanonicalTarget *Target `protobuf:"bytes,2,opt,name=canonical_target,json=canonicalTarget,proto3" json:"canonical_target,omitempty"`
	// The full path including filename in which this action is located, relative
	// to the workspace root.
	FilePath string `protobuf:"bytes,3,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
	// Types that are assignable to CompiledObject:
	//
	//	*CompilationResultAction_Relation_
	//	*CompilationResultAction_Operations_
	//	*CompilationResultAction_Assertion_
	//	*CompilationResultAction_Declaration_
	CompiledObject isCompilationResultAction_CompiledObject `protobuf_oneof:"compiled_object"`
}

func (x *CompilationResultAction) Reset() {
	*x = CompilationResultAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompilationResultAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompilationResultAction) ProtoMessage() {}

func (x *CompilationResultAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompilationResultAction.ProtoReflect.Descriptor instead.
func (*CompilationResultAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{69}
}

func (x *CompilationResultAction) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *CompilationResultAction) GetCanonicalTarget() *Target {
	if x != nil {
		return x.CanonicalTarget
	}
	return nil
}

func (x *CompilationResultAction) GetFilePath() string {
	if x != nil {
		return x.FilePath
	}
	return ""
}

func (m *CompilationResultAction) GetCompiledObject() isCompilationResultAction_CompiledObject {
	if m != nil {
		return m.CompiledObject
	}
	return nil
}

func (x *CompilationResultAction) GetRelation() *CompilationResultAction_Relation {
	if x, ok := x.GetCompiledObject().(*CompilationResultAction_Relation_); ok {
		return x.Relation
	}
	return nil
}

func (x *CompilationResultAction) GetOperations() *CompilationResultAction_Operations {
	if x, ok := x.GetCompiledObject().(*CompilationResultAction_Operations_); ok {
		return x.Operations
	}
	return nil
}

func (x *CompilationResultAction) GetAssertion() *CompilationResultAction_Assertion {
	if x, ok := x.GetCompiledObject().(*CompilationResultAction_Assertion_); ok {
		return x.Assertion
	}
	return nil
}

func (x *CompilationResultAction) GetDeclaration() *CompilationResultAction_Declaration {
	if x, ok := x.GetCompiledObject().(*CompilationResultAction_Declaration_); ok {
		return x.Declaration
	}
	return nil
}

type isCompilationResultAction_CompiledObject interface {
	isCompilationResultAction_CompiledObject()
}

type CompilationResultAction_Relation_ struct {
	// The database relation created/updated by this action.
	Relation *CompilationResultAction_Relation `protobuf:"bytes,4,opt,name=relation,proto3,oneof"`
}

type CompilationResultAction_Operations_ struct {
	// The database operations executed by this action.
	Operations *CompilationResultAction_Operations `protobuf:"bytes,5,opt,name=operations,proto3,oneof"`
}

type CompilationResultAction_Assertion_ struct {
	// The assertion executed by this action.
	Assertion *CompilationResultAction_Assertion `protobuf:"bytes,6,opt,name=assertion,proto3,oneof"`
}

type CompilationResultAction_Declaration_ struct {
	// The declaration declared by this action.
	Declaration *CompilationResultAction_Declaration `protobuf:"bytes,7,opt,name=declaration,proto3,oneof"`
}

func (*CompilationResultAction_Relation_) isCompilationResultAction_CompiledObject() {}

func (*CompilationResultAction_Operations_) isCompilationResultAction_CompiledObject() {}

func (*CompilationResultAction_Assertion_) isCompilationResultAction_CompiledObject() {}

func (*CompilationResultAction_Declaration_) isCompilationResultAction_CompiledObject() {}

// `QueryCompilationResultActions` request message.
type QueryCompilationResultActionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The compilation result's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Maximum number of compilation results to return. The server may
	// return fewer items than requested. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous
	// `QueryCompilationResultActions` call. Provide this to retrieve the
	// subsequent page.
	//
	// When paginating, all other parameters provided to
	// `QueryCompilationResultActions` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Optional filter for the returned list. Filtering is only
	// currently supported on the `file_path` field.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *QueryCompilationResultActionsRequest) Reset() {
	*x = QueryCompilationResultActionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryCompilationResultActionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryCompilationResultActionsRequest) ProtoMessage() {}

func (x *QueryCompilationResultActionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryCompilationResultActionsRequest.ProtoReflect.Descriptor instead.
func (*QueryCompilationResultActionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{70}
}

func (x *QueryCompilationResultActionsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryCompilationResultActionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *QueryCompilationResultActionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *QueryCompilationResultActionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// `QueryCompilationResultActions` response message.
type QueryCompilationResultActionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of compilation result actions.
	CompilationResultActions []*CompilationResultAction `protobuf:"bytes,1,rep,name=compilation_result_actions,json=compilationResultActions,proto3" json:"compilation_result_actions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *QueryCompilationResultActionsResponse) Reset() {
	*x = QueryCompilationResultActionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryCompilationResultActionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryCompilationResultActionsResponse) ProtoMessage() {}

func (x *QueryCompilationResultActionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryCompilationResultActionsResponse.ProtoReflect.Descriptor instead.
func (*QueryCompilationResultActionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{71}
}

func (x *QueryCompilationResultActionsResponse) GetCompilationResultActions() []*CompilationResultAction {
	if x != nil {
		return x.CompilationResultActions
	}
	return nil
}

func (x *QueryCompilationResultActionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents a Dataform workflow configuration.
type WorkflowConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The workflow config's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the release config whose release_compilation_result
	// should be executed. Must be in the format
	// `projects/*/locations/*/repositories/*/releaseConfigs/*`.
	ReleaseConfig string `protobuf:"bytes,2,opt,name=release_config,json=releaseConfig,proto3" json:"release_config,omitempty"`
	// Optional. If left unset, a default InvocationConfig will be used.
	InvocationConfig *InvocationConfig `protobuf:"bytes,3,opt,name=invocation_config,json=invocationConfig,proto3" json:"invocation_config,omitempty"`
	// Optional. Optional schedule (in cron format) for automatic execution of
	// this workflow config.
	CronSchedule string `protobuf:"bytes,4,opt,name=cron_schedule,json=cronSchedule,proto3" json:"cron_schedule,omitempty"`
	// Optional. Specifies the time zone to be used when interpreting
	// cron_schedule. Must be a time zone name from the time zone database
	// (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). If left
	// unspecified, the default is UTC.
	TimeZone string `protobuf:"bytes,7,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Output only. Records of the 10 most recent scheduled execution attempts,
	// ordered in in descending order of `execution_time`. Updated whenever
	// automatic creation of a workflow invocation is triggered by cron_schedule.
	RecentScheduledExecutionRecords []*WorkflowConfig_ScheduledExecutionRecord `protobuf:"bytes,5,rep,name=recent_scheduled_execution_records,json=recentScheduledExecutionRecords,proto3" json:"recent_scheduled_execution_records,omitempty"`
}

func (x *WorkflowConfig) Reset() {
	*x = WorkflowConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowConfig) ProtoMessage() {}

func (x *WorkflowConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowConfig.ProtoReflect.Descriptor instead.
func (*WorkflowConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{72}
}

func (x *WorkflowConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WorkflowConfig) GetReleaseConfig() string {
	if x != nil {
		return x.ReleaseConfig
	}
	return ""
}

func (x *WorkflowConfig) GetInvocationConfig() *InvocationConfig {
	if x != nil {
		return x.InvocationConfig
	}
	return nil
}

func (x *WorkflowConfig) GetCronSchedule() string {
	if x != nil {
		return x.CronSchedule
	}
	return ""
}

func (x *WorkflowConfig) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *WorkflowConfig) GetRecentScheduledExecutionRecords() []*WorkflowConfig_ScheduledExecutionRecord {
	if x != nil {
		return x.RecentScheduledExecutionRecords
	}
	return nil
}

// Includes various configuration options for a workflow invocation.
// If both `included_targets` and `included_tags` are unset, all actions
// will be included.
type InvocationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The set of action identifiers to include.
	IncludedTargets []*Target `protobuf:"bytes,1,rep,name=included_targets,json=includedTargets,proto3" json:"included_targets,omitempty"`
	// Optional. The set of tags to include.
	IncludedTags []string `protobuf:"bytes,2,rep,name=included_tags,json=includedTags,proto3" json:"included_tags,omitempty"`
	// Optional. When set to true, transitive dependencies of included actions
	// will be executed.
	TransitiveDependenciesIncluded bool `protobuf:"varint,3,opt,name=transitive_dependencies_included,json=transitiveDependenciesIncluded,proto3" json:"transitive_dependencies_included,omitempty"`
	// Optional. When set to true, transitive dependents of included actions will
	// be executed.
	TransitiveDependentsIncluded bool `protobuf:"varint,4,opt,name=transitive_dependents_included,json=transitiveDependentsIncluded,proto3" json:"transitive_dependents_included,omitempty"`
	// Optional. When set to true, any incremental tables will be fully refreshed.
	FullyRefreshIncrementalTablesEnabled bool `protobuf:"varint,5,opt,name=fully_refresh_incremental_tables_enabled,json=fullyRefreshIncrementalTablesEnabled,proto3" json:"fully_refresh_incremental_tables_enabled,omitempty"`
	// Optional. The service account to run workflow invocations under.
	ServiceAccount string `protobuf:"bytes,6,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *InvocationConfig) Reset() {
	*x = InvocationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InvocationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvocationConfig) ProtoMessage() {}

func (x *InvocationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvocationConfig.ProtoReflect.Descriptor instead.
func (*InvocationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{73}
}

func (x *InvocationConfig) GetIncludedTargets() []*Target {
	if x != nil {
		return x.IncludedTargets
	}
	return nil
}

func (x *InvocationConfig) GetIncludedTags() []string {
	if x != nil {
		return x.IncludedTags
	}
	return nil
}

func (x *InvocationConfig) GetTransitiveDependenciesIncluded() bool {
	if x != nil {
		return x.TransitiveDependenciesIncluded
	}
	return false
}

func (x *InvocationConfig) GetTransitiveDependentsIncluded() bool {
	if x != nil {
		return x.TransitiveDependentsIncluded
	}
	return false
}

func (x *InvocationConfig) GetFullyRefreshIncrementalTablesEnabled() bool {
	if x != nil {
		return x.FullyRefreshIncrementalTablesEnabled
	}
	return false
}

func (x *InvocationConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

// `ListWorkflowConfigs` request message.
type ListWorkflowConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository in which to list workflow configs. Must be in the
	// format `projects/*/locations/*/repositories/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of workflow configs to return. The server may
	// return fewer items than requested. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListWorkflowConfigs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListWorkflowConfigs`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListWorkflowConfigsRequest) Reset() {
	*x = ListWorkflowConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkflowConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkflowConfigsRequest) ProtoMessage() {}

func (x *ListWorkflowConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkflowConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListWorkflowConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{74}
}

func (x *ListWorkflowConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkflowConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkflowConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// `ListWorkflowConfigs` response message.
type ListWorkflowConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of workflow configs.
	WorkflowConfigs []*WorkflowConfig `protobuf:"bytes,1,rep,name=workflow_configs,json=workflowConfigs,proto3" json:"workflow_configs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations which could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListWorkflowConfigsResponse) Reset() {
	*x = ListWorkflowConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkflowConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkflowConfigsResponse) ProtoMessage() {}

func (x *ListWorkflowConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkflowConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListWorkflowConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{75}
}

func (x *ListWorkflowConfigsResponse) GetWorkflowConfigs() []*WorkflowConfig {
	if x != nil {
		return x.WorkflowConfigs
	}
	return nil
}

func (x *ListWorkflowConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListWorkflowConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// `GetWorkflowConfig` request message.
type GetWorkflowConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workflow config's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkflowConfigRequest) Reset() {
	*x = GetWorkflowConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkflowConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkflowConfigRequest) ProtoMessage() {}

func (x *GetWorkflowConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkflowConfigRequest.ProtoReflect.Descriptor instead.
func (*GetWorkflowConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{76}
}

func (x *GetWorkflowConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `CreateWorkflowConfig` request message.
type CreateWorkflowConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository in which to create the workflow config. Must be in
	// the format `projects/*/locations/*/repositories/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The workflow config to create.
	WorkflowConfig *WorkflowConfig `protobuf:"bytes,2,opt,name=workflow_config,json=workflowConfig,proto3" json:"workflow_config,omitempty"`
	// Required. The ID to use for the workflow config, which will become the
	// final component of the workflow config's resource name.
	WorkflowConfigId string `protobuf:"bytes,3,opt,name=workflow_config_id,json=workflowConfigId,proto3" json:"workflow_config_id,omitempty"`
}

func (x *CreateWorkflowConfigRequest) Reset() {
	*x = CreateWorkflowConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkflowConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkflowConfigRequest) ProtoMessage() {}

func (x *CreateWorkflowConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkflowConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkflowConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{77}
}

func (x *CreateWorkflowConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkflowConfigRequest) GetWorkflowConfig() *WorkflowConfig {
	if x != nil {
		return x.WorkflowConfig
	}
	return nil
}

func (x *CreateWorkflowConfigRequest) GetWorkflowConfigId() string {
	if x != nil {
		return x.WorkflowConfigId
	}
	return ""
}

// `UpdateWorkflowConfig` request message.
type UpdateWorkflowConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the fields to be updated in the workflow config. If
	// left unset, all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The workflow config to update.
	WorkflowConfig *WorkflowConfig `protobuf:"bytes,2,opt,name=workflow_config,json=workflowConfig,proto3" json:"workflow_config,omitempty"`
}

func (x *UpdateWorkflowConfigRequest) Reset() {
	*x = UpdateWorkflowConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWorkflowConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWorkflowConfigRequest) ProtoMessage() {}

func (x *UpdateWorkflowConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWorkflowConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateWorkflowConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{78}
}

func (x *UpdateWorkflowConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateWorkflowConfigRequest) GetWorkflowConfig() *WorkflowConfig {
	if x != nil {
		return x.WorkflowConfig
	}
	return nil
}

// `DeleteWorkflowConfig` request message.
type DeleteWorkflowConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workflow config's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteWorkflowConfigRequest) Reset() {
	*x = DeleteWorkflowConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWorkflowConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkflowConfigRequest) ProtoMessage() {}

func (x *DeleteWorkflowConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkflowConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkflowConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{79}
}

func (x *DeleteWorkflowConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents a single invocation of a compilation result.
type WorkflowInvocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The workflow invocation's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to CompilationSource:
	//
	//	*WorkflowInvocation_CompilationResult
	//	*WorkflowInvocation_WorkflowConfig
	CompilationSource isWorkflowInvocation_CompilationSource `protobuf_oneof:"compilation_source"`
	// Immutable. If left unset, a default InvocationConfig will be used.
	InvocationConfig *InvocationConfig `protobuf:"bytes,3,opt,name=invocation_config,json=invocationConfig,proto3" json:"invocation_config,omitempty"`
	// Output only. This workflow invocation's current state.
	State WorkflowInvocation_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.dataform.v1beta1.WorkflowInvocation_State" json:"state,omitempty"`
	// Output only. This workflow invocation's timing details.
	InvocationTiming *interval.Interval `protobuf:"bytes,5,opt,name=invocation_timing,json=invocationTiming,proto3" json:"invocation_timing,omitempty"`
}

func (x *WorkflowInvocation) Reset() {
	*x = WorkflowInvocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowInvocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowInvocation) ProtoMessage() {}

func (x *WorkflowInvocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowInvocation.ProtoReflect.Descriptor instead.
func (*WorkflowInvocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{80}
}

func (x *WorkflowInvocation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *WorkflowInvocation) GetCompilationSource() isWorkflowInvocation_CompilationSource {
	if m != nil {
		return m.CompilationSource
	}
	return nil
}

func (x *WorkflowInvocation) GetCompilationResult() string {
	if x, ok := x.GetCompilationSource().(*WorkflowInvocation_CompilationResult); ok {
		return x.CompilationResult
	}
	return ""
}

func (x *WorkflowInvocation) GetWorkflowConfig() string {
	if x, ok := x.GetCompilationSource().(*WorkflowInvocation_WorkflowConfig); ok {
		return x.WorkflowConfig
	}
	return ""
}

func (x *WorkflowInvocation) GetInvocationConfig() *InvocationConfig {
	if x != nil {
		return x.InvocationConfig
	}
	return nil
}

func (x *WorkflowInvocation) GetState() WorkflowInvocation_State {
	if x != nil {
		return x.State
	}
	return WorkflowInvocation_STATE_UNSPECIFIED
}

func (x *WorkflowInvocation) GetInvocationTiming() *interval.Interval {
	if x != nil {
		return x.InvocationTiming
	}
	return nil
}

type isWorkflowInvocation_CompilationSource interface {
	isWorkflowInvocation_CompilationSource()
}

type WorkflowInvocation_CompilationResult struct {
	// Immutable. The name of the compilation result to use for this invocation.
	// Must be in the format
	// `projects/*/locations/*/repositories/*/compilationResults/*`.
	CompilationResult string `protobuf:"bytes,2,opt,name=compilation_result,json=compilationResult,proto3,oneof"`
}

type WorkflowInvocation_WorkflowConfig struct {
	// Immutable. The name of the workflow config to invoke. Must be in the
	// format `projects/*/locations/*/repositories/*/workflowConfigs/*`.
	WorkflowConfig string `protobuf:"bytes,6,opt,name=workflow_config,json=workflowConfig,proto3,oneof"`
}

func (*WorkflowInvocation_CompilationResult) isWorkflowInvocation_CompilationSource() {}

func (*WorkflowInvocation_WorkflowConfig) isWorkflowInvocation_CompilationSource() {}

// `ListWorkflowInvocations` request message.
type ListWorkflowInvocationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the WorkflowInvocation type. Must be in
	// the format `projects/*/locations/*/repositories/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of workflow invocations to return. The server may
	// return fewer items than requested. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListWorkflowInvocations`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListWorkflowInvocations`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. This field only supports ordering by `name`. If unspecified, the
	// server will choose the ordering. If specified, the default order is
	// ascending for the `name` field.
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. Filter for the returned list.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListWorkflowInvocationsRequest) Reset() {
	*x = ListWorkflowInvocationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkflowInvocationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkflowInvocationsRequest) ProtoMessage() {}

func (x *ListWorkflowInvocationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkflowInvocationsRequest.ProtoReflect.Descriptor instead.
func (*ListWorkflowInvocationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{81}
}

func (x *ListWorkflowInvocationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkflowInvocationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkflowInvocationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListWorkflowInvocationsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListWorkflowInvocationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// `ListWorkflowInvocations` response message.
type ListWorkflowInvocationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of workflow invocations.
	WorkflowInvocations []*WorkflowInvocation `protobuf:"bytes,1,rep,name=workflow_invocations,json=workflowInvocations,proto3" json:"workflow_invocations,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations which could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListWorkflowInvocationsResponse) Reset() {
	*x = ListWorkflowInvocationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkflowInvocationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkflowInvocationsResponse) ProtoMessage() {}

func (x *ListWorkflowInvocationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkflowInvocationsResponse.ProtoReflect.Descriptor instead.
func (*ListWorkflowInvocationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{82}
}

func (x *ListWorkflowInvocationsResponse) GetWorkflowInvocations() []*WorkflowInvocation {
	if x != nil {
		return x.WorkflowInvocations
	}
	return nil
}

func (x *ListWorkflowInvocationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListWorkflowInvocationsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// `GetWorkflowInvocation` request message.
type GetWorkflowInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workflow invocation resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkflowInvocationRequest) Reset() {
	*x = GetWorkflowInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkflowInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkflowInvocationRequest) ProtoMessage() {}

func (x *GetWorkflowInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkflowInvocationRequest.ProtoReflect.Descriptor instead.
func (*GetWorkflowInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{83}
}

func (x *GetWorkflowInvocationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `CreateWorkflowInvocation` request message.
type CreateWorkflowInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The repository in which to create the workflow invocation. Must
	// be in the format `projects/*/locations/*/repositories/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The workflow invocation resource to create.
	WorkflowInvocation *WorkflowInvocation `protobuf:"bytes,2,opt,name=workflow_invocation,json=workflowInvocation,proto3" json:"workflow_invocation,omitempty"`
}

func (x *CreateWorkflowInvocationRequest) Reset() {
	*x = CreateWorkflowInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkflowInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkflowInvocationRequest) ProtoMessage() {}

func (x *CreateWorkflowInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkflowInvocationRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkflowInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{84}
}

func (x *CreateWorkflowInvocationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkflowInvocationRequest) GetWorkflowInvocation() *WorkflowInvocation {
	if x != nil {
		return x.WorkflowInvocation
	}
	return nil
}

// `DeleteWorkflowInvocation` request message.
type DeleteWorkflowInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workflow invocation resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteWorkflowInvocationRequest) Reset() {
	*x = DeleteWorkflowInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWorkflowInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkflowInvocationRequest) ProtoMessage() {}

func (x *DeleteWorkflowInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkflowInvocationRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkflowInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{85}
}

func (x *DeleteWorkflowInvocationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// `CancelWorkflowInvocation` request message.
type CancelWorkflowInvocationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workflow invocation resource's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelWorkflowInvocationRequest) Reset() {
	*x = CancelWorkflowInvocationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelWorkflowInvocationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelWorkflowInvocationRequest) ProtoMessage() {}

func (x *CancelWorkflowInvocationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelWorkflowInvocationRequest.ProtoReflect.Descriptor instead.
func (*CancelWorkflowInvocationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{86}
}

func (x *CancelWorkflowInvocationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents a single action in a workflow invocation.
type WorkflowInvocationAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. This action's identifier. Unique within the workflow
	// invocation.
	Target *Target `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. The action's identifier if the project had been compiled
	// without any overrides configured. Unique within the compilation result.
	CanonicalTarget *Target `protobuf:"bytes,2,opt,name=canonical_target,json=canonicalTarget,proto3" json:"canonical_target,omitempty"`
	// Output only. This action's current state.
	State WorkflowInvocationAction_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.dataform.v1beta1.WorkflowInvocationAction_State" json:"state,omitempty"`
	// Output only. If and only if action's state is FAILED a failure reason is
	// set.
	FailureReason string `protobuf:"bytes,7,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
	// Output only. This action's timing details.
	// `start_time` will be set if the action is in [RUNNING, SUCCEEDED,
	// CANCELLED, FAILED] state.
	// `end_time` will be set if the action is in [SUCCEEDED, CANCELLED, FAILED]
	// state.
	InvocationTiming *interval.Interval `protobuf:"bytes,5,opt,name=invocation_timing,json=invocationTiming,proto3" json:"invocation_timing,omitempty"`
	// Output only. The workflow action's bigquery action details.
	BigqueryAction *WorkflowInvocationAction_BigQueryAction `protobuf:"bytes,6,opt,name=bigquery_action,json=bigqueryAction,proto3" json:"bigquery_action,omitempty"`
}

func (x *WorkflowInvocationAction) Reset() {
	*x = WorkflowInvocationAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowInvocationAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowInvocationAction) ProtoMessage() {}

func (x *WorkflowInvocationAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowInvocationAction.ProtoReflect.Descriptor instead.
func (*WorkflowInvocationAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{87}
}

func (x *WorkflowInvocationAction) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *WorkflowInvocationAction) GetCanonicalTarget() *Target {
	if x != nil {
		return x.CanonicalTarget
	}
	return nil
}

func (x *WorkflowInvocationAction) GetState() WorkflowInvocationAction_State {
	if x != nil {
		return x.State
	}
	return WorkflowInvocationAction_PENDING
}

func (x *WorkflowInvocationAction) GetFailureReason() string {
	if x != nil {
		return x.FailureReason
	}
	return ""
}

func (x *WorkflowInvocationAction) GetInvocationTiming() *interval.Interval {
	if x != nil {
		return x.InvocationTiming
	}
	return nil
}

func (x *WorkflowInvocationAction) GetBigqueryAction() *WorkflowInvocationAction_BigQueryAction {
	if x != nil {
		return x.BigqueryAction
	}
	return nil
}

// `QueryWorkflowInvocationActions` request message.
type QueryWorkflowInvocationActionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workflow invocation's name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Maximum number of workflow invocations to return. The server may
	// return fewer items than requested. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous
	// `QueryWorkflowInvocationActions` call. Provide this to retrieve the
	// subsequent page.
	//
	// When paginating, all other parameters provided to
	// `QueryWorkflowInvocationActions` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *QueryWorkflowInvocationActionsRequest) Reset() {
	*x = QueryWorkflowInvocationActionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryWorkflowInvocationActionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryWorkflowInvocationActionsRequest) ProtoMessage() {}

func (x *QueryWorkflowInvocationActionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryWorkflowInvocationActionsRequest.ProtoReflect.Descriptor instead.
func (*QueryWorkflowInvocationActionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{88}
}

func (x *QueryWorkflowInvocationActionsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryWorkflowInvocationActionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *QueryWorkflowInvocationActionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// `QueryWorkflowInvocationActions` response message.
type QueryWorkflowInvocationActionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of workflow invocation actions.
	WorkflowInvocationActions []*WorkflowInvocationAction `protobuf:"bytes,1,rep,name=workflow_invocation_actions,json=workflowInvocationActions,proto3" json:"workflow_invocation_actions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *QueryWorkflowInvocationActionsResponse) Reset() {
	*x = QueryWorkflowInvocationActionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryWorkflowInvocationActionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryWorkflowInvocationActionsResponse) ProtoMessage() {}

func (x *QueryWorkflowInvocationActionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryWorkflowInvocationActionsResponse.ProtoReflect.Descriptor instead.
func (*QueryWorkflowInvocationActionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{89}
}

func (x *QueryWorkflowInvocationActionsResponse) GetWorkflowInvocationActions() []*WorkflowInvocationAction {
	if x != nil {
		return x.WorkflowInvocationActions
	}
	return nil
}

func (x *QueryWorkflowInvocationActionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Controls Git remote configuration for a repository.
type Repository_GitRemoteSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Git remote's URL.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Required. The Git remote's default branch name.
	DefaultBranch string `protobuf:"bytes,2,opt,name=default_branch,json=defaultBranch,proto3" json:"default_branch,omitempty"`
	// Optional. The name of the Secret Manager secret version to use as an
	// authentication token for Git operations. Must be in the format
	// `projects/*/secrets/*/versions/*`.
	AuthenticationTokenSecretVersion string `protobuf:"bytes,3,opt,name=authentication_token_secret_version,json=authenticationTokenSecretVersion,proto3" json:"authentication_token_secret_version,omitempty"`
	// Optional. Authentication fields for remote uris using SSH protocol.
	SshAuthenticationConfig *Repository_GitRemoteSettings_SshAuthenticationConfig `protobuf:"bytes,5,opt,name=ssh_authentication_config,json=sshAuthenticationConfig,proto3" json:"ssh_authentication_config,omitempty"`
	// Output only. Deprecated: The field does not contain any token status
	// information. Instead use
	// https://cloud.google.com/dataform/reference/rest/v1beta1/projects.locations.repositories/computeAccessTokenStatus
	//
	// Deprecated: Marked as deprecated in google/cloud/dataform/v1beta1/dataform.proto.
	TokenStatus Repository_GitRemoteSettings_TokenStatus `protobuf:"varint,4,opt,name=token_status,json=tokenStatus,proto3,enum=google.cloud.dataform.v1beta1.Repository_GitRemoteSettings_TokenStatus" json:"token_status,omitempty"`
}

func (x *Repository_GitRemoteSettings) Reset() {
	*x = Repository_GitRemoteSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Repository_GitRemoteSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repository_GitRemoteSettings) ProtoMessage() {}

func (x *Repository_GitRemoteSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Repository_GitRemoteSettings.ProtoReflect.Descriptor instead.
func (*Repository_GitRemoteSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Repository_GitRemoteSettings) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Repository_GitRemoteSettings) GetDefaultBranch() string {
	if x != nil {
		return x.DefaultBranch
	}
	return ""
}

func (x *Repository_GitRemoteSettings) GetAuthenticationTokenSecretVersion() string {
	if x != nil {
		return x.AuthenticationTokenSecretVersion
	}
	return ""
}

func (x *Repository_GitRemoteSettings) GetSshAuthenticationConfig() *Repository_GitRemoteSettings_SshAuthenticationConfig {
	if x != nil {
		return x.SshAuthenticationConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/dataform/v1beta1/dataform.proto.
func (x *Repository_GitRemoteSettings) GetTokenStatus() Repository_GitRemoteSettings_TokenStatus {
	if x != nil {
		return x.TokenStatus
	}
	return Repository_GitRemoteSettings_TOKEN_STATUS_UNSPECIFIED
}

// Configures workspace compilation overrides for a repository.
// Primarily used by the UI (`console.cloud.google.com`).
// `schema_suffix` and `table_prefix` can have a special expression -
// `${workspaceName}`, which refers to the workspace name from which the
// compilation results will be created. API callers are expected to resolve
// the expression in these overrides and provide them explicitly in
// `code_compilation_config`
// (https://cloud.google.com/dataform/reference/rest/v1beta1/projects.locations.repositories.compilationResults#codecompilationconfig)
// when creating workspace-scoped compilation results.
type Repository_WorkspaceCompilationOverrides struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The default database (Google Cloud project ID).
	DefaultDatabase string `protobuf:"bytes,1,opt,name=default_database,json=defaultDatabase,proto3" json:"default_database,omitempty"`
	// Optional. The suffix that should be appended to all schema (BigQuery
	// dataset ID) names.
	SchemaSuffix string `protobuf:"bytes,2,opt,name=schema_suffix,json=schemaSuffix,proto3" json:"schema_suffix,omitempty"`
	// Optional. The prefix that should be prepended to all table names.
	TablePrefix string `protobuf:"bytes,3,opt,name=table_prefix,json=tablePrefix,proto3" json:"table_prefix,omitempty"`
}

func (x *Repository_WorkspaceCompilationOverrides) Reset() {
	*x = Repository_WorkspaceCompilationOverrides{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Repository_WorkspaceCompilationOverrides) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repository_WorkspaceCompilationOverrides) ProtoMessage() {}

func (x *Repository_WorkspaceCompilationOverrides) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Repository_WorkspaceCompilationOverrides.ProtoReflect.Descriptor instead.
func (*Repository_WorkspaceCompilationOverrides) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Repository_WorkspaceCompilationOverrides) GetDefaultDatabase() string {
	if x != nil {
		return x.DefaultDatabase
	}
	return ""
}

func (x *Repository_WorkspaceCompilationOverrides) GetSchemaSuffix() string {
	if x != nil {
		return x.SchemaSuffix
	}
	return ""
}

func (x *Repository_WorkspaceCompilationOverrides) GetTablePrefix() string {
	if x != nil {
		return x.TablePrefix
	}
	return ""
}

// Configures fields for performing SSH authentication.
type Repository_GitRemoteSettings_SshAuthenticationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Secret Manager secret version to use as a
	// ssh private key for Git operations.
	// Must be in the format `projects/*/secrets/*/versions/*`.
	UserPrivateKeySecretVersion string `protobuf:"bytes,1,opt,name=user_private_key_secret_version,json=userPrivateKeySecretVersion,proto3" json:"user_private_key_secret_version,omitempty"`
	// Required. Content of a public SSH key to verify an identity of a remote
	// Git host.
	HostPublicKey string `protobuf:"bytes,2,opt,name=host_public_key,json=hostPublicKey,proto3" json:"host_public_key,omitempty"`
}

func (x *Repository_GitRemoteSettings_SshAuthenticationConfig) Reset() {
	*x = Repository_GitRemoteSettings_SshAuthenticationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Repository_GitRemoteSettings_SshAuthenticationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repository_GitRemoteSettings_SshAuthenticationConfig) ProtoMessage() {}

func (x *Repository_GitRemoteSettings_SshAuthenticationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Repository_GitRemoteSettings_SshAuthenticationConfig.ProtoReflect.Descriptor instead.
func (*Repository_GitRemoteSettings_SshAuthenticationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Repository_GitRemoteSettings_SshAuthenticationConfig) GetUserPrivateKeySecretVersion() string {
	if x != nil {
		return x.UserPrivateKeySecretVersion
	}
	return ""
}

func (x *Repository_GitRemoteSettings_SshAuthenticationConfig) GetHostPublicKey() string {
	if x != nil {
		return x.HostPublicKey
	}
	return ""
}

// Represents a single file operation to the repository.
type CommitRepositoryChangesRequest_FileOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Operation:
	//
	//	*CommitRepositoryChangesRequest_FileOperation_WriteFile_
	//	*CommitRepositoryChangesRequest_FileOperation_DeleteFile_
	Operation isCommitRepositoryChangesRequest_FileOperation_Operation `protobuf_oneof:"operation"`
}

func (x *CommitRepositoryChangesRequest_FileOperation) Reset() {
	*x = CommitRepositoryChangesRequest_FileOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRepositoryChangesRequest_FileOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRepositoryChangesRequest_FileOperation) ProtoMessage() {}

func (x *CommitRepositoryChangesRequest_FileOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRepositoryChangesRequest_FileOperation.ProtoReflect.Descriptor instead.
func (*CommitRepositoryChangesRequest_FileOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{7, 0}
}

func (m *CommitRepositoryChangesRequest_FileOperation) GetOperation() isCommitRepositoryChangesRequest_FileOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *CommitRepositoryChangesRequest_FileOperation) GetWriteFile() *CommitRepositoryChangesRequest_FileOperation_WriteFile {
	if x, ok := x.GetOperation().(*CommitRepositoryChangesRequest_FileOperation_WriteFile_); ok {
		return x.WriteFile
	}
	return nil
}

func (x *CommitRepositoryChangesRequest_FileOperation) GetDeleteFile() *CommitRepositoryChangesRequest_FileOperation_DeleteFile {
	if x, ok := x.GetOperation().(*CommitRepositoryChangesRequest_FileOperation_DeleteFile_); ok {
		return x.DeleteFile
	}
	return nil
}

type isCommitRepositoryChangesRequest_FileOperation_Operation interface {
	isCommitRepositoryChangesRequest_FileOperation_Operation()
}

type CommitRepositoryChangesRequest_FileOperation_WriteFile_ struct {
	// Represents the write operation.
	WriteFile *CommitRepositoryChangesRequest_FileOperation_WriteFile `protobuf:"bytes,1,opt,name=write_file,json=writeFile,proto3,oneof"`
}

type CommitRepositoryChangesRequest_FileOperation_DeleteFile_ struct {
	// Represents the delete operation.
	DeleteFile *CommitRepositoryChangesRequest_FileOperation_DeleteFile `protobuf:"bytes,2,opt,name=delete_file,json=deleteFile,proto3,oneof"`
}

func (*CommitRepositoryChangesRequest_FileOperation_WriteFile_) isCommitRepositoryChangesRequest_FileOperation_Operation() {
}

func (*CommitRepositoryChangesRequest_FileOperation_DeleteFile_) isCommitRepositoryChangesRequest_FileOperation_Operation() {
}

// Represents the write file operation (for files added or modified).
type CommitRepositoryChangesRequest_FileOperation_WriteFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The file's contents.
	Contents []byte `protobuf:"bytes,1,opt,name=contents,proto3" json:"contents,omitempty"`
}

func (x *CommitRepositoryChangesRequest_FileOperation_WriteFile) Reset() {
	*x = CommitRepositoryChangesRequest_FileOperation_WriteFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRepositoryChangesRequest_FileOperation_WriteFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRepositoryChangesRequest_FileOperation_WriteFile) ProtoMessage() {}

func (x *CommitRepositoryChangesRequest_FileOperation_WriteFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRepositoryChangesRequest_FileOperation_WriteFile.ProtoReflect.Descriptor instead.
func (*CommitRepositoryChangesRequest_FileOperation_WriteFile) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{7, 0, 0}
}

func (x *CommitRepositoryChangesRequest_FileOperation_WriteFile) GetContents() []byte {
	if x != nil {
		return x.Contents
	}
	return nil
}

// Represents the delete file operation.
type CommitRepositoryChangesRequest_FileOperation_DeleteFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CommitRepositoryChangesRequest_FileOperation_DeleteFile) Reset() {
	*x = CommitRepositoryChangesRequest_FileOperation_DeleteFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitRepositoryChangesRequest_FileOperation_DeleteFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitRepositoryChangesRequest_FileOperation_DeleteFile) ProtoMessage() {}

func (x *CommitRepositoryChangesRequest_FileOperation_DeleteFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitRepositoryChangesRequest_FileOperation_DeleteFile.ProtoReflect.Descriptor instead.
func (*CommitRepositoryChangesRequest_FileOperation_DeleteFile) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{7, 0, 1}
}

// Represents the Git state of a file with uncommitted changes.
type FetchFileGitStatusesResponse_UncommittedFileChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The file's full path including filename, relative to the workspace root.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Indicates the status of the file.
	State FetchFileGitStatusesResponse_UncommittedFileChange_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.dataform.v1beta1.FetchFileGitStatusesResponse_UncommittedFileChange_State" json:"state,omitempty"`
}

func (x *FetchFileGitStatusesResponse_UncommittedFileChange) Reset() {
	*x = FetchFileGitStatusesResponse_UncommittedFileChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchFileGitStatusesResponse_UncommittedFileChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchFileGitStatusesResponse_UncommittedFileChange) ProtoMessage() {}

func (x *FetchFileGitStatusesResponse_UncommittedFileChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchFileGitStatusesResponse_UncommittedFileChange.ProtoReflect.Descriptor instead.
func (*FetchFileGitStatusesResponse_UncommittedFileChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{30, 0}
}

func (x *FetchFileGitStatusesResponse_UncommittedFileChange) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *FetchFileGitStatusesResponse_UncommittedFileChange) GetState() FetchFileGitStatusesResponse_UncommittedFileChange_State {
	if x != nil {
		return x.State
	}
	return FetchFileGitStatusesResponse_UncommittedFileChange_STATE_UNSPECIFIED
}

// A record of an attempt to create a compilation result for this release
// config.
type ReleaseConfig_ScheduledReleaseRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp of this release attempt.
	ReleaseTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=release_time,json=releaseTime,proto3" json:"release_time,omitempty"`
	// Types that are assignable to Result:
	//
	//	*ReleaseConfig_ScheduledReleaseRecord_CompilationResult
	//	*ReleaseConfig_ScheduledReleaseRecord_ErrorStatus
	Result isReleaseConfig_ScheduledReleaseRecord_Result `protobuf_oneof:"result"`
}

func (x *ReleaseConfig_ScheduledReleaseRecord) Reset() {
	*x = ReleaseConfig_ScheduledReleaseRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReleaseConfig_ScheduledReleaseRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseConfig_ScheduledReleaseRecord) ProtoMessage() {}

func (x *ReleaseConfig_ScheduledReleaseRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseConfig_ScheduledReleaseRecord.ProtoReflect.Descriptor instead.
func (*ReleaseConfig_ScheduledReleaseRecord) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{54, 0}
}

func (x *ReleaseConfig_ScheduledReleaseRecord) GetReleaseTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReleaseTime
	}
	return nil
}

func (m *ReleaseConfig_ScheduledReleaseRecord) GetResult() isReleaseConfig_ScheduledReleaseRecord_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *ReleaseConfig_ScheduledReleaseRecord) GetCompilationResult() string {
	if x, ok := x.GetResult().(*ReleaseConfig_ScheduledReleaseRecord_CompilationResult); ok {
		return x.CompilationResult
	}
	return ""
}

func (x *ReleaseConfig_ScheduledReleaseRecord) GetErrorStatus() *status.Status {
	if x, ok := x.GetResult().(*ReleaseConfig_ScheduledReleaseRecord_ErrorStatus); ok {
		return x.ErrorStatus
	}
	return nil
}

type isReleaseConfig_ScheduledReleaseRecord_Result interface {
	isReleaseConfig_ScheduledReleaseRecord_Result()
}

type ReleaseConfig_ScheduledReleaseRecord_CompilationResult struct {
	// The name of the created compilation result, if one was successfully
	// created. Must be in the format
	// `projects/*/locations/*/repositories/*/compilationResults/*`.
	CompilationResult string `protobuf:"bytes,2,opt,name=compilation_result,json=compilationResult,proto3,oneof"`
}

type ReleaseConfig_ScheduledReleaseRecord_ErrorStatus struct {
	// The error status encountered upon this attempt to create the
	// compilation result, if the attempt was unsuccessful.
	ErrorStatus *status.Status `protobuf:"bytes,3,opt,name=error_status,json=errorStatus,proto3,oneof"`
}

func (*ReleaseConfig_ScheduledReleaseRecord_CompilationResult) isReleaseConfig_ScheduledReleaseRecord_Result() {
}

func (*ReleaseConfig_ScheduledReleaseRecord_ErrorStatus) isReleaseConfig_ScheduledReleaseRecord_Result() {
}

// An error encountered when attempting to compile a Dataform project.
type CompilationResult_CompilationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The error's top level message.
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Output only. The error's full stack trace.
	Stack string `protobuf:"bytes,2,opt,name=stack,proto3" json:"stack,omitempty"`
	// Output only. The path of the file where this error occurred, if
	// available, relative to the project root.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// Output only. The identifier of the action where this error occurred, if
	// available.
	ActionTarget *Target `protobuf:"bytes,4,opt,name=action_target,json=actionTarget,proto3" json:"action_target,omitempty"`
}

func (x *CompilationResult_CompilationError) Reset() {
	*x = CompilationResult_CompilationError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompilationResult_CompilationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompilationResult_CompilationError) ProtoMessage() {}

func (x *CompilationResult_CompilationError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompilationResult_CompilationError.ProtoReflect.Descriptor instead.
func (*CompilationResult_CompilationError) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{61, 0}
}

func (x *CompilationResult_CompilationError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *CompilationResult_CompilationError) GetStack() string {
	if x != nil {
		return x.Stack
	}
	return ""
}

func (x *CompilationResult_CompilationError) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *CompilationResult_CompilationError) GetActionTarget() *Target {
	if x != nil {
		return x.ActionTarget
	}
	return nil
}

// Describes a column.
type RelationDescriptor_ColumnDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier for the column. Each entry in `path` represents one level
	// of nesting.
	Path []string `protobuf:"bytes,1,rep,name=path,proto3" json:"path,omitempty"`
	// A textual description of the column.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// A list of BigQuery policy tags that will be applied to the column.
	BigqueryPolicyTags []string `protobuf:"bytes,3,rep,name=bigquery_policy_tags,json=bigqueryPolicyTags,proto3" json:"bigquery_policy_tags,omitempty"`
}

func (x *RelationDescriptor_ColumnDescriptor) Reset() {
	*x = RelationDescriptor_ColumnDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RelationDescriptor_ColumnDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelationDescriptor_ColumnDescriptor) ProtoMessage() {}

func (x *RelationDescriptor_ColumnDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelationDescriptor_ColumnDescriptor.ProtoReflect.Descriptor instead.
func (*RelationDescriptor_ColumnDescriptor) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{68, 0}
}

func (x *RelationDescriptor_ColumnDescriptor) GetPath() []string {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *RelationDescriptor_ColumnDescriptor) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RelationDescriptor_ColumnDescriptor) GetBigqueryPolicyTags() []string {
	if x != nil {
		return x.BigqueryPolicyTags
	}
	return nil
}

// Represents a database relation.
type CompilationResultAction_Relation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of actions that this action depends on.
	DependencyTargets []*Target `protobuf:"bytes,1,rep,name=dependency_targets,json=dependencyTargets,proto3" json:"dependency_targets,omitempty"`
	// Whether this action is disabled (i.e. should not be run).
	Disabled bool `protobuf:"varint,2,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Arbitrary, user-defined tags on this action.
	Tags []string `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`
	// Descriptor for the relation and its columns.
	RelationDescriptor *RelationDescriptor `protobuf:"bytes,4,opt,name=relation_descriptor,json=relationDescriptor,proto3" json:"relation_descriptor,omitempty"`
	// The type of this relation.
	RelationType CompilationResultAction_Relation_RelationType `protobuf:"varint,5,opt,name=relation_type,json=relationType,proto3,enum=google.cloud.dataform.v1beta1.CompilationResultAction_Relation_RelationType" json:"relation_type,omitempty"`
	// The SELECT query which returns rows which this relation should contain.
	SelectQuery string `protobuf:"bytes,6,opt,name=select_query,json=selectQuery,proto3" json:"select_query,omitempty"`
	// SQL statements to be executed before creating the relation.
	PreOperations []string `protobuf:"bytes,7,rep,name=pre_operations,json=preOperations,proto3" json:"pre_operations,omitempty"`
	// SQL statements to be executed after creating the relation.
	PostOperations []string `protobuf:"bytes,8,rep,name=post_operations,json=postOperations,proto3" json:"post_operations,omitempty"`
	// Configures `INCREMENTAL_TABLE` settings for this relation. Only set if
	// `relation_type` is `INCREMENTAL_TABLE`.
	IncrementalTableConfig *CompilationResultAction_Relation_IncrementalTableConfig `protobuf:"bytes,9,opt,name=incremental_table_config,json=incrementalTableConfig,proto3" json:"incremental_table_config,omitempty"`
	// The SQL expression used to partition the relation.
	PartitionExpression string `protobuf:"bytes,10,opt,name=partition_expression,json=partitionExpression,proto3" json:"partition_expression,omitempty"`
	// A list of columns or SQL expressions used to cluster the table.
	ClusterExpressions []string `protobuf:"bytes,11,rep,name=cluster_expressions,json=clusterExpressions,proto3" json:"cluster_expressions,omitempty"`
	// Sets the partition expiration in days.
	PartitionExpirationDays int32 `protobuf:"varint,12,opt,name=partition_expiration_days,json=partitionExpirationDays,proto3" json:"partition_expiration_days,omitempty"`
	// Specifies whether queries on this table must include a predicate filter
	// that filters on the partitioning column.
	RequirePartitionFilter bool `protobuf:"varint,13,opt,name=require_partition_filter,json=requirePartitionFilter,proto3" json:"require_partition_filter,omitempty"`
	// Additional options that will be provided as key/value pairs into the
	// options clause of a create table/view statement. See
	// https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language
	// for more information on which options are supported.
	AdditionalOptions map[string]string `protobuf:"bytes,14,rep,name=additional_options,json=additionalOptions,proto3" json:"additional_options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CompilationResultAction_Relation) Reset() {
	*x = CompilationResultAction_Relation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompilationResultAction_Relation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompilationResultAction_Relation) ProtoMessage() {}

func (x *CompilationResultAction_Relation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompilationResultAction_Relation.ProtoReflect.Descriptor instead.
func (*CompilationResultAction_Relation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{69, 0}
}

func (x *CompilationResultAction_Relation) GetDependencyTargets() []*Target {
	if x != nil {
		return x.DependencyTargets
	}
	return nil
}

func (x *CompilationResultAction_Relation) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *CompilationResultAction_Relation) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *CompilationResultAction_Relation) GetRelationDescriptor() *RelationDescriptor {
	if x != nil {
		return x.RelationDescriptor
	}
	return nil
}

func (x *CompilationResultAction_Relation) GetRelationType() CompilationResultAction_Relation_RelationType {
	if x != nil {
		return x.RelationType
	}
	return CompilationResultAction_Relation_RELATION_TYPE_UNSPECIFIED
}

func (x *CompilationResultAction_Relation) GetSelectQuery() string {
	if x != nil {
		return x.SelectQuery
	}
	return ""
}

func (x *CompilationResultAction_Relation) GetPreOperations() []string {
	if x != nil {
		return x.PreOperations
	}
	return nil
}

func (x *CompilationResultAction_Relation) GetPostOperations() []string {
	if x != nil {
		return x.PostOperations
	}
	return nil
}

func (x *CompilationResultAction_Relation) GetIncrementalTableConfig() *CompilationResultAction_Relation_IncrementalTableConfig {
	if x != nil {
		return x.IncrementalTableConfig
	}
	return nil
}

func (x *CompilationResultAction_Relation) GetPartitionExpression() string {
	if x != nil {
		return x.PartitionExpression
	}
	return ""
}

func (x *CompilationResultAction_Relation) GetClusterExpressions() []string {
	if x != nil {
		return x.ClusterExpressions
	}
	return nil
}

func (x *CompilationResultAction_Relation) GetPartitionExpirationDays() int32 {
	if x != nil {
		return x.PartitionExpirationDays
	}
	return 0
}

func (x *CompilationResultAction_Relation) GetRequirePartitionFilter() bool {
	if x != nil {
		return x.RequirePartitionFilter
	}
	return false
}

func (x *CompilationResultAction_Relation) GetAdditionalOptions() map[string]string {
	if x != nil {
		return x.AdditionalOptions
	}
	return nil
}

// Represents a list of arbitrary database operations.
type CompilationResultAction_Operations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of actions that this action depends on.
	DependencyTargets []*Target `protobuf:"bytes,1,rep,name=dependency_targets,json=dependencyTargets,proto3" json:"dependency_targets,omitempty"`
	// Whether this action is disabled (i.e. should not be run).
	Disabled bool `protobuf:"varint,2,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Arbitrary, user-defined tags on this action.
	Tags []string `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`
	// Descriptor for any output relation and its columns. Only set if
	// `has_output` is true.
	RelationDescriptor *RelationDescriptor `protobuf:"bytes,6,opt,name=relation_descriptor,json=relationDescriptor,proto3" json:"relation_descriptor,omitempty"`
	// A list of arbitrary SQL statements that will be executed without
	// alteration.
	Queries []string `protobuf:"bytes,4,rep,name=queries,proto3" json:"queries,omitempty"`
	// Whether these operations produce an output relation.
	HasOutput bool `protobuf:"varint,5,opt,name=has_output,json=hasOutput,proto3" json:"has_output,omitempty"`
}

func (x *CompilationResultAction_Operations) Reset() {
	*x = CompilationResultAction_Operations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompilationResultAction_Operations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompilationResultAction_Operations) ProtoMessage() {}

func (x *CompilationResultAction_Operations) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompilationResultAction_Operations.ProtoReflect.Descriptor instead.
func (*CompilationResultAction_Operations) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{69, 1}
}

func (x *CompilationResultAction_Operations) GetDependencyTargets() []*Target {
	if x != nil {
		return x.DependencyTargets
	}
	return nil
}

func (x *CompilationResultAction_Operations) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *CompilationResultAction_Operations) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *CompilationResultAction_Operations) GetRelationDescriptor() *RelationDescriptor {
	if x != nil {
		return x.RelationDescriptor
	}
	return nil
}

func (x *CompilationResultAction_Operations) GetQueries() []string {
	if x != nil {
		return x.Queries
	}
	return nil
}

func (x *CompilationResultAction_Operations) GetHasOutput() bool {
	if x != nil {
		return x.HasOutput
	}
	return false
}

// Represents an assertion upon a SQL query which is required return zero
// rows.
type CompilationResultAction_Assertion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of actions that this action depends on.
	DependencyTargets []*Target `protobuf:"bytes,1,rep,name=dependency_targets,json=dependencyTargets,proto3" json:"dependency_targets,omitempty"`
	// The parent action of this assertion. Only set if this assertion was
	// automatically generated.
	ParentAction *Target `protobuf:"bytes,5,opt,name=parent_action,json=parentAction,proto3" json:"parent_action,omitempty"`
	// Whether this action is disabled (i.e. should not be run).
	Disabled bool `protobuf:"varint,2,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Arbitrary, user-defined tags on this action.
	Tags []string `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`
	// The SELECT query which must return zero rows in order for this assertion
	// to succeed.
	SelectQuery string `protobuf:"bytes,4,opt,name=select_query,json=selectQuery,proto3" json:"select_query,omitempty"`
	// Descriptor for the assertion's automatically-generated view and its
	// columns.
	RelationDescriptor *RelationDescriptor `protobuf:"bytes,6,opt,name=relation_descriptor,json=relationDescriptor,proto3" json:"relation_descriptor,omitempty"`
}

func (x *CompilationResultAction_Assertion) Reset() {
	*x = CompilationResultAction_Assertion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompilationResultAction_Assertion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompilationResultAction_Assertion) ProtoMessage() {}

func (x *CompilationResultAction_Assertion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompilationResultAction_Assertion.ProtoReflect.Descriptor instead.
func (*CompilationResultAction_Assertion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{69, 2}
}

func (x *CompilationResultAction_Assertion) GetDependencyTargets() []*Target {
	if x != nil {
		return x.DependencyTargets
	}
	return nil
}

func (x *CompilationResultAction_Assertion) GetParentAction() *Target {
	if x != nil {
		return x.ParentAction
	}
	return nil
}

func (x *CompilationResultAction_Assertion) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *CompilationResultAction_Assertion) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *CompilationResultAction_Assertion) GetSelectQuery() string {
	if x != nil {
		return x.SelectQuery
	}
	return ""
}

func (x *CompilationResultAction_Assertion) GetRelationDescriptor() *RelationDescriptor {
	if x != nil {
		return x.RelationDescriptor
	}
	return nil
}

// Represents a relation which is not managed by Dataform but which may be
// referenced by Dataform actions.
type CompilationResultAction_Declaration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Descriptor for the relation and its columns. Used as documentation only,
	// i.e. values here will result in no changes to the relation's metadata.
	RelationDescriptor *RelationDescriptor `protobuf:"bytes,1,opt,name=relation_descriptor,json=relationDescriptor,proto3" json:"relation_descriptor,omitempty"`
}

func (x *CompilationResultAction_Declaration) Reset() {
	*x = CompilationResultAction_Declaration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompilationResultAction_Declaration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompilationResultAction_Declaration) ProtoMessage() {}

func (x *CompilationResultAction_Declaration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompilationResultAction_Declaration.ProtoReflect.Descriptor instead.
func (*CompilationResultAction_Declaration) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{69, 3}
}

func (x *CompilationResultAction_Declaration) GetRelationDescriptor() *RelationDescriptor {
	if x != nil {
		return x.RelationDescriptor
	}
	return nil
}

// Contains settings for relations of type `INCREMENTAL_TABLE`.
type CompilationResultAction_Relation_IncrementalTableConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SELECT query which returns rows which should be inserted into the
	// relation if it already exists and is not being refreshed.
	IncrementalSelectQuery string `protobuf:"bytes,1,opt,name=incremental_select_query,json=incrementalSelectQuery,proto3" json:"incremental_select_query,omitempty"`
	// Whether this table should be protected from being refreshed.
	RefreshDisabled bool `protobuf:"varint,2,opt,name=refresh_disabled,json=refreshDisabled,proto3" json:"refresh_disabled,omitempty"`
	// A set of columns or SQL expressions used to define row uniqueness.
	// If any duplicates are discovered (as defined by `unique_key_parts`),
	// only the newly selected rows (as defined by `incremental_select_query`)
	// will be included in the relation.
	UniqueKeyParts []string `protobuf:"bytes,3,rep,name=unique_key_parts,json=uniqueKeyParts,proto3" json:"unique_key_parts,omitempty"`
	// A SQL expression conditional used to limit the set of existing rows
	// considered for a merge operation (see `unique_key_parts` for more
	// information).
	UpdatePartitionFilter string `protobuf:"bytes,4,opt,name=update_partition_filter,json=updatePartitionFilter,proto3" json:"update_partition_filter,omitempty"`
	// SQL statements to be executed before inserting new rows into the
	// relation.
	IncrementalPreOperations []string `protobuf:"bytes,5,rep,name=incremental_pre_operations,json=incrementalPreOperations,proto3" json:"incremental_pre_operations,omitempty"`
	// SQL statements to be executed after inserting new rows into the
	// relation.
	IncrementalPostOperations []string `protobuf:"bytes,6,rep,name=incremental_post_operations,json=incrementalPostOperations,proto3" json:"incremental_post_operations,omitempty"`
}

func (x *CompilationResultAction_Relation_IncrementalTableConfig) Reset() {
	*x = CompilationResultAction_Relation_IncrementalTableConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompilationResultAction_Relation_IncrementalTableConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompilationResultAction_Relation_IncrementalTableConfig) ProtoMessage() {}

func (x *CompilationResultAction_Relation_IncrementalTableConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompilationResultAction_Relation_IncrementalTableConfig.ProtoReflect.Descriptor instead.
func (*CompilationResultAction_Relation_IncrementalTableConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{69, 0, 0}
}

func (x *CompilationResultAction_Relation_IncrementalTableConfig) GetIncrementalSelectQuery() string {
	if x != nil {
		return x.IncrementalSelectQuery
	}
	return ""
}

func (x *CompilationResultAction_Relation_IncrementalTableConfig) GetRefreshDisabled() bool {
	if x != nil {
		return x.RefreshDisabled
	}
	return false
}

func (x *CompilationResultAction_Relation_IncrementalTableConfig) GetUniqueKeyParts() []string {
	if x != nil {
		return x.UniqueKeyParts
	}
	return nil
}

func (x *CompilationResultAction_Relation_IncrementalTableConfig) GetUpdatePartitionFilter() string {
	if x != nil {
		return x.UpdatePartitionFilter
	}
	return ""
}

func (x *CompilationResultAction_Relation_IncrementalTableConfig) GetIncrementalPreOperations() []string {
	if x != nil {
		return x.IncrementalPreOperations
	}
	return nil
}

func (x *CompilationResultAction_Relation_IncrementalTableConfig) GetIncrementalPostOperations() []string {
	if x != nil {
		return x.IncrementalPostOperations
	}
	return nil
}

// A record of an attempt to create a workflow invocation for this workflow
// config.
type WorkflowConfig_ScheduledExecutionRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The timestamp of this execution attempt.
	ExecutionTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=execution_time,json=executionTime,proto3" json:"execution_time,omitempty"`
	// Types that are assignable to Result:
	//
	//	*WorkflowConfig_ScheduledExecutionRecord_WorkflowInvocation
	//	*WorkflowConfig_ScheduledExecutionRecord_ErrorStatus
	Result isWorkflowConfig_ScheduledExecutionRecord_Result `protobuf_oneof:"result"`
}

func (x *WorkflowConfig_ScheduledExecutionRecord) Reset() {
	*x = WorkflowConfig_ScheduledExecutionRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowConfig_ScheduledExecutionRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowConfig_ScheduledExecutionRecord) ProtoMessage() {}

func (x *WorkflowConfig_ScheduledExecutionRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowConfig_ScheduledExecutionRecord.ProtoReflect.Descriptor instead.
func (*WorkflowConfig_ScheduledExecutionRecord) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{72, 0}
}

func (x *WorkflowConfig_ScheduledExecutionRecord) GetExecutionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExecutionTime
	}
	return nil
}

func (m *WorkflowConfig_ScheduledExecutionRecord) GetResult() isWorkflowConfig_ScheduledExecutionRecord_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *WorkflowConfig_ScheduledExecutionRecord) GetWorkflowInvocation() string {
	if x, ok := x.GetResult().(*WorkflowConfig_ScheduledExecutionRecord_WorkflowInvocation); ok {
		return x.WorkflowInvocation
	}
	return ""
}

func (x *WorkflowConfig_ScheduledExecutionRecord) GetErrorStatus() *status.Status {
	if x, ok := x.GetResult().(*WorkflowConfig_ScheduledExecutionRecord_ErrorStatus); ok {
		return x.ErrorStatus
	}
	return nil
}

type isWorkflowConfig_ScheduledExecutionRecord_Result interface {
	isWorkflowConfig_ScheduledExecutionRecord_Result()
}

type WorkflowConfig_ScheduledExecutionRecord_WorkflowInvocation struct {
	// The name of the created workflow invocation, if one was successfully
	// created. Must be in the format
	// `projects/*/locations/*/repositories/*/workflowInvocations/*`.
	WorkflowInvocation string `protobuf:"bytes,2,opt,name=workflow_invocation,json=workflowInvocation,proto3,oneof"`
}

type WorkflowConfig_ScheduledExecutionRecord_ErrorStatus struct {
	// The error status encountered upon this attempt to create the
	// workflow invocation, if the attempt was unsuccessful.
	ErrorStatus *status.Status `protobuf:"bytes,3,opt,name=error_status,json=errorStatus,proto3,oneof"`
}

func (*WorkflowConfig_ScheduledExecutionRecord_WorkflowInvocation) isWorkflowConfig_ScheduledExecutionRecord_Result() {
}

func (*WorkflowConfig_ScheduledExecutionRecord_ErrorStatus) isWorkflowConfig_ScheduledExecutionRecord_Result() {
}

// Represents a workflow action that will run against BigQuery.
type WorkflowInvocationAction_BigQueryAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The generated BigQuery SQL script that will be executed.
	SqlScript string `protobuf:"bytes,1,opt,name=sql_script,json=sqlScript,proto3" json:"sql_script,omitempty"`
}

func (x *WorkflowInvocationAction_BigQueryAction) Reset() {
	*x = WorkflowInvocationAction_BigQueryAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowInvocationAction_BigQueryAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowInvocationAction_BigQueryAction) ProtoMessage() {}

func (x *WorkflowInvocationAction_BigQueryAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowInvocationAction_BigQueryAction.ProtoReflect.Descriptor instead.
func (*WorkflowInvocationAction_BigQueryAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP(), []int{87, 0}
}

func (x *WorkflowInvocationAction_BigQueryAction) GetSqlScript() string {
	if x != nil {
		return x.SqlScript
	}
	return ""
}

var File_google_cloud_dataform_v1beta1_dataform_proto protoreflect.FileDescriptor

var file_google_cloud_dataform_v1beta1_dataform_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfb, 0x0d, 0x0a, 0x0a, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x70, 0x0a, 0x13, 0x67, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x47, 0x69,
	0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x67, 0x69, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x2a, 0x6e, 0x70, 0x6d, 0x72,
	0x63, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x01, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x26, 0x6e, 0x70, 0x6d, 0x72, 0x63, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x94, 0x01, 0x0a, 0x1f, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x1d, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12,
	0x52, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x47, 0x0a, 0x1c, 0x73, 0x65, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41,
	0x04, 0x52, 0x19, 0x73, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x12, 0x2c, 0x0a, 0x0f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xfb, 0x05, 0x0a, 0x11, 0x47,
	0x69, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x2a, 0x0a, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x42, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x12, 0x81, 0x01, 0x0a, 0x23, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x32, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x20, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x94, 0x01, 0x0a, 0x19, 0x73, 0x73, 0x68, 0x5f,
	0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x47, 0x69, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x53, 0x73, 0x68, 0x41, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x73, 0x73, 0x68, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x71,
	0x0a, 0x0c, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e,
	0x47, 0x69, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x05, 0xe0,
	0x41, 0x03, 0x18, 0x01, 0x52, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x1a, 0xc0, 0x01, 0x0a, 0x17, 0x53, 0x73, 0x68, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x78, 0x0a,
	0x1f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x1b, 0x75, 0x73, 0x65, 0x72,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x0f, 0x68, 0x6f, 0x73, 0x74, 0x5f,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4b, 0x65, 0x79, 0x22, 0x52, 0x0a, 0x0b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x02, 0x12, 0x09, 0x0a,
	0x05, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x03, 0x1a, 0xa1, 0x01, 0x0a, 0x1d, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x12, 0x26, 0x0a, 0x0c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6a, 0xea, 0x41, 0x67, 0x0a, 0x22, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x7d, 0x22, 0xdf, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xb3, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x56, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xd6, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0xab, 0x01, 0x0a,
	0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4e, 0x0a, 0x0a, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x6f, 0x0a, 0x17, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xd1, 0x06, 0x0a, 0x1e,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5b,
	0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3c, 0x0a, 0x18, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x5f, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x48, 0x65, 0x61, 0x64,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53, 0x68, 0x61, 0x12, 0x7a, 0x0a, 0x0f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xc6, 0x02, 0x0a, 0x0d, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x76, 0x0a, 0x0a, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69,
	0x6c, 0x65, 0x48, 0x00, 0x52, 0x09, 0x77, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12,
	0x79, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0a,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x1a, 0x27, 0x0a, 0x09, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x1a, 0x0c, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x8e,
	0x01, 0x0a, 0x13, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x61, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x98, 0x01, 0x0a, 0x19, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53, 0x68,
	0x61, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x38, 0x0a, 0x1a, 0x52, 0x65,
	0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x46, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x22, 0xec, 0x01, 0x0a, 0x27, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x53, 0x68, 0x61, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xae, 0x01, 0x0a, 0x28, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5a, 0x0a, 0x11, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x65, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa5, 0x01, 0x0a, 0x1d, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x91, 0x01, 0x0a,
	0x1e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x47, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xd8, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53, 0x68, 0x61, 0x12,
	0x43, 0x0a, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x52, 0x06, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x0e,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x48,
	0x0a, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x22, 0x6b, 0x0a, 0x29, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xfa, 0x01, 0x0a, 0x2a, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x78, 0x0a, 0x0c, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0b, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x52, 0x0a, 0x0b, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x4f, 0x4b,
	0x45, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x54, 0x5f, 0x46,
	0x4f, 0x55, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x03, 0x22, 0x5c,
	0x0a, 0x1a, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x42, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x39, 0x0a, 0x1b,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x62,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x62,
	0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x22, 0xa7, 0x01, 0x0a, 0x09, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x80,
	0x01, 0xea, 0x41, 0x7d, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x7d, 0x22, 0xde, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0xac, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a,
	0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x0a, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x54, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd1, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x49, 0x64, 0x22, 0x57, 0x0a, 0x16, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x51, 0x0a, 0x0c, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0xca, 0x01, 0x0a, 0x15, 0x50, 0x75, 0x6c, 0x6c,
	0x47, 0x69, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x48, 0x0a, 0x06, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x22, 0x80, 0x01, 0x0a, 0x15, 0x50, 0x75, 0x73, 0x68, 0x47, 0x69, 0x74,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x22, 0x5c, 0x0a, 0x1b, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x46, 0x69, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa2, 0x03, 0x0a, 0x1c, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46,
	0x69, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8b, 0x01, 0x0a, 0x18, 0x75, 0x6e, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46,
	0x69, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x55, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74,
	0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x16, 0x75, 0x6e,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x1a, 0xf3, 0x01, 0x0a, 0x15, 0x55, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x12, 0x6d, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46, 0x69, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x55,
	0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x22, 0x57, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x4f, 0x44,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x48, 0x41, 0x53, 0x5f, 0x43,
	0x4f, 0x4e, 0x46, 0x4c, 0x49, 0x43, 0x54, 0x53, 0x10, 0x04, 0x22, 0x85, 0x01, 0x0a, 0x1a, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x41, 0x68, 0x65, 0x61, 0x64, 0x42, 0x65, 0x68, 0x69,
	0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x42, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x22, 0x69, 0x0a, 0x1b, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x41, 0x68,
	0x65, 0x61, 0x64, 0x42, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x5f, 0x61, 0x68, 0x65,
	0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x73, 0x41, 0x68, 0x65, 0x61, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x73, 0x5f, 0x62, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x42, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x22, 0xef, 0x01,
	0x0a, 0x1d, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x48,
	0x0a, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x22,
	0x93, 0x01, 0x0a, 0x1c, 0x52, 0x65, 0x73, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x19, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6c,
	0x65, 0x61, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05,
	0x63, 0x6c, 0x65, 0x61, 0x6e, 0x22, 0x78, 0x0a, 0x14, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46, 0x69,
	0x6c, 0x65, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x09, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22,
	0x3e, 0x0a, 0x15, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x69, 0x66, 0x66,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x69, 0x66, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x44, 0x69, 0x66, 0x66, 0x22,
	0xc7, 0x01, 0x0a, 0x1d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x1e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x11,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x4f, 0x0a, 0x0e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x14, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x1e, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x22, 0x78, 0x0a, 0x14, 0x4d, 0x61, 0x6b, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x09, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x17, 0x0a, 0x15, 0x4d,
	0x61, 0x6b, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7a, 0x0a, 0x16, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x09, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x22, 0x98, 0x01, 0x0a, 0x14, 0x4d, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x09, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1e, 0x0a, 0x08, 0x6e,
	0x65, 0x77, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x6e, 0x65, 0x77, 0x50, 0x61, 0x74, 0x68, 0x22, 0x17, 0x0a, 0x15, 0x4d,
	0x6f, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x73, 0x0a, 0x0f, 0x52, 0x65, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x37, 0x0a, 0x10, 0x52, 0x65, 0x61,
	0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x22, 0x75, 0x0a, 0x11, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x93, 0x01, 0x0a, 0x0f, 0x4d, 0x6f,
	0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x09, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12,
	0x1e, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6e, 0x65, 0x77, 0x50, 0x61, 0x74, 0x68, 0x22,
	0x12, 0x0a, 0x10, 0x4d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x10, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x13, 0x0a, 0x11, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x64, 0x0a, 0x19, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4e, 0x70, 0x6d, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x09, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x1c, 0x0a, 0x1a, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x4e, 0x70, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa5, 0x07, 0x0a, 0x0d, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x28, 0x0a, 0x0d, 0x67, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x69, 0x73, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x67, 0x69, 0x74,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x69, 0x73, 0x68, 0x12, 0x71, 0x0a, 0x17, 0x63, 0x6f, 0x64,
	0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x63, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d,
	0x63, 0x72, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x72, 0x6f, 0x6e, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x91, 0x01, 0x0a, 0x20, 0x72, 0x65, 0x63,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x5f, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1d, 0x72,
	0x65, 0x63, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x12, 0x6f, 0x0a, 0x1a,
	0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x31, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x18, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0xfb, 0x01,
	0x0a, 0x16, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x3d, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x37, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x3a, 0x8e, 0x01, 0xea, 0x41,
	0x8a, 0x01, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x7d, 0x2f, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0xa5, 0x01, 0x0a,
	0x19, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xbd, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x55, 0x0a, 0x0f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x72, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x5c, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xeb, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x58, 0x0a, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x2f, 0x0a, 0x11, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64,
	0x22, 0xb8, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x58, 0x0a, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5f, 0x0a, 0x1a, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a,
	0x25, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xba, 0x07, 0x0a,
	0x11, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0d, 0x67,
	0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x69, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x67, 0x69, 0x74, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x69, 0x73, 0x68, 0x12, 0x49, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x05, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x56, 0x0a, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x05, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x71, 0x0a, 0x17, 0x63, 0x6f,
	0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x64, 0x65,
	0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x15, 0x63, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a,
	0x17, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f, 0x67, 0x69, 0x74, 0x5f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x47, 0x69, 0x74,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53, 0x68, 0x61, 0x12, 0x37, 0x0a, 0x15, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x43, 0x6f, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x75, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x1a, 0xb6, 0x01, 0x0a, 0x10, 0x43, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x1d,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x19, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x12, 0x4f, 0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x3a, 0x9a, 0x01, 0xea, 0x41, 0x96, 0x01, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x69, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x7d, 0x42,
	0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xe5, 0x03, 0x0a, 0x15, 0x43, 0x6f,
	0x64, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12,
	0x2e, 0x0a, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2e, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x61, 0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12,
	0x57, 0x0a, 0x04, 0x76, 0x61, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x64, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x56, 0x61, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x76, 0x61, 0x72, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78,
	0x12, 0x26, 0x0a, 0x0c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x37, 0x0a, 0x09, 0x56, 0x61, 0x72, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xa9, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcd, 0x01,
	0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x61, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x12, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x64, 0x0a,
	0x1b, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xca, 0x01, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x64, 0x0a, 0x12, 0x63, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x63,
	0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x22, 0x50, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xc3, 0x03, 0x0a, 0x12, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x07, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x6e, 0x0a, 0x0f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x7a, 0x0a, 0x10, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x12, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x54, 0x61, 0x67, 0x73, 0x1a, 0x41, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xde, 0x16, 0x0a, 0x17, 0x43, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x50, 0x0a, 0x10, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x52, 0x0f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x5d, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x63, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x60, 0x0a, 0x09, 0x61, 0x73, 0x73, 0x65, 0x72, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x61,
	0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x0b, 0x64, 0x65, 0x63, 0x6c,
	0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0xe7, 0x0b, 0x0a, 0x08, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a,
	0x12, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x52, 0x11, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x61, 0x67, 0x73, 0x12, 0x62, 0x0a, 0x13, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x52, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x71, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x25, 0x0a,
	0x0e, 0x70, 0x72, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x70,
	0x6f, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x90, 0x01,
	0x0a, 0x18, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x31, 0x0a, 0x14, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x65,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x12, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3a, 0x0a, 0x19, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x79,
	0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x79, 0x73,
	0x12, 0x38, 0x0a, 0x18, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x16, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x85, 0x01, 0x0a, 0x12, 0x61,
	0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x11, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0xdd, 0x02, 0x0a, 0x16, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x38, 0x0a,
	0x18, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x16, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x66, 0x72, 0x65,
	0x73, 0x68, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x75, 0x6e,
	0x69, 0x71, 0x75, 0x65, 0x4b, 0x65, 0x79, 0x50, 0x61, 0x72, 0x74, 0x73, 0x12, 0x36, 0x0a, 0x17,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x3c, 0x0a, 0x1a, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x18, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x6c, 0x50, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x3e, 0x0a, 0x1b, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x19, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x44, 0x0a, 0x16, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x70, 0x0a, 0x0c, 0x52, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x4c, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x41, 0x42, 0x4c, 0x45,
	0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x56, 0x49, 0x45, 0x57, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11,
	0x49, 0x4e, 0x43, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x4c, 0x5f, 0x54, 0x41, 0x42, 0x4c,
	0x45, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x41, 0x54, 0x45, 0x52, 0x49, 0x41, 0x4c, 0x49,
	0x5a, 0x45, 0x44, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x10, 0x04, 0x1a, 0xaf, 0x02, 0x0a, 0x0a, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x54, 0x0a, 0x12, 0x64, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x11, 0x64, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12,
	0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12,
	0x62, 0x0a, 0x13, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52,
	0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x68, 0x61, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x09, 0x68, 0x61, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x1a, 0xe4, 0x02, 0x0a,
	0x09, 0x41, 0x73, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x12, 0x64, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x11, 0x64,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x12, 0x4a, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x0c,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x62, 0x0a, 0x13, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52,
	0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x1a, 0x71, 0x0a, 0x0b, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x13, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x52, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x42, 0x11, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xd0, 0x01, 0x0a, 0x24, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xc5, 0x01, 0x0a,
	0x25, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x74, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x18, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe4, 0x06, 0x0a, 0x0e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x54, 0x0a, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27,
	0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x11, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x72, 0x6f,
	0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x72, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x74, 0x69, 0x6d,
	0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x98, 0x01, 0x0a, 0x22, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x1f, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73,
	0x1a, 0x84, 0x02, 0x0a, 0x18, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x41, 0x0a,
	0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x62, 0x0a, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa,
	0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b,
	0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00,
	0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x08, 0x0a,
	0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x3a, 0x91, 0x01, 0xea, 0x41, 0x8d, 0x01, 0x0a, 0x26,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x63, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0xb8, 0x03, 0x0a, 0x10,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x55, 0x0a, 0x10, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x64, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x54, 0x61, 0x67,
	0x73, 0x12, 0x4d, 0x0a, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x1e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64,
	0x12, 0x49, 0x0a, 0x1e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x74, 0x73, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x28, 0x66,
	0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x69, 0x6e, 0x63,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x24, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68,
	0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xa6, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x57,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xc1, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x58, 0x0a, 0x10, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x5e, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xf1, 0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x22, 0xbc, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5b, 0x0a, 0x0f, 0x77, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x61, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x88, 0x06, 0x0a, 0x12, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x12, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x59, 0x0a,
	0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x28, 0x0a, 0x26,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0e, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x11, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x10, 0x69, 0x6e, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x47, 0x0a, 0x11, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69,
	0x6d, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x22, 0x64, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12,
	0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x3a, 0x9d,
	0x01, 0xea, 0x41, 0x99, 0x01, 0x0a, 0x2a, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x6b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x14,
	0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x22, 0xe7, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xd1,
	0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x64, 0x0a, 0x14, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0x66, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x1f, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x67, 0x0a, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0x0a, 0x1f, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x69, 0x0a, 0x1f, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x98, 0x05, 0x0a, 0x18, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x12, 0x55, 0x0a, 0x10, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x58, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x47, 0x0a, 0x11, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69,
	0x6d, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x74, 0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x34,
	0x0a, 0x0e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x0a, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x71, 0x6c, 0x53, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x22, 0x66, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a,
	0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49, 0x50, 0x50,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10,
	0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x22, 0xb5, 0x01, 0x0a,
	0x25, 0x51, 0x75, 0x65, 0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc9, 0x01, 0x0a, 0x26, 0x51, 0x75, 0x65, 0x72, 0x79, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x77, 0x0a, 0x1b, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x19, 0x77,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x32, 0x9e, 0x5a, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0xcb, 0x01,
	0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0xb5, 0x01, 0x0a, 0x0d,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x44, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xe2, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x6b, 0xda, 0x41, 0x1f,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x2c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0xe4, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x22, 0x6d, 0xda, 0x41, 0x16, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4e, 0x3a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x32, 0x40, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xa8, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb9, 0x01, 0x0a, 0x17, 0x43,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x47, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x01, 0x2a, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0xd1, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x61, 0x64, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x46, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x12, 0x3e, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x89, 0x02, 0x0a, 0x20, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x12, 0x4c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xe1, 0x01, 0x0a, 0x16, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65,
	0x74, 0x63, 0x68, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x91, 0x02, 0x0a, 0x22, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x49, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x12, 0x4e,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0xdf,
	0x01, 0x0a, 0x13, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x42, 0x72,
	0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x42, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74,
	0x63, 0x68, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73,
	0x12, 0xd2, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x53, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0xbf, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe9, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x75, 0xda, 0x41,
	0x1d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22,
	0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x12, 0xb3, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x44, 0x2a, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf0, 0x01, 0x0a, 0x12, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4e, 0x70, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4e, 0x70, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x4e, 0x70, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x3a, 0x01, 0x2a,
	0x22, 0x5a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x4e, 0x70, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x12, 0xb2, 0x01, 0x0a,
	0x0e, 0x50, 0x75, 0x6c, 0x6c, 0x47, 0x69, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x75, 0x6c, 0x6c, 0x47, 0x69, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x52, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a, 0x01, 0x2a, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x75, 0x6c,
	0x6c, 0x12, 0xb2, 0x01, 0x0a, 0x0e, 0x50, 0x75, 0x73, 0x68, 0x47, 0x69, 0x74, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x47, 0x69, 0x74, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a, 0x01, 0x2a, 0x22, 0x47, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x70, 0x75, 0x73, 0x68, 0x12, 0xf0, 0x01, 0x0a, 0x14, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x46, 0x69, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x46, 0x69, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63,
	0x68, 0x46, 0x69, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x59,
	0x12, 0x57, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x46, 0x69, 0x6c, 0x65, 0x47, 0x69,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0xec, 0x01, 0x0a, 0x13, 0x46, 0x65,
	0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x41, 0x68, 0x65, 0x61, 0x64, 0x42, 0x65, 0x68, 0x69, 0x6e,
	0x64, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x41, 0x68, 0x65, 0x61, 0x64, 0x42,
	0x65, 0x68, 0x69, 0x6e, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x47, 0x69, 0x74, 0x41, 0x68, 0x65, 0x61, 0x64, 0x42, 0x65, 0x68, 0x69, 0x6e, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58,
	0x12, 0x56, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x41, 0x68, 0x65,
	0x61, 0x64, 0x42, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x12, 0xc4, 0x01, 0x0a, 0x16, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4e, 0x3a, 0x01, 0x2a, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12,
	0xc1, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x57,
	0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x53,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x01, 0x2a, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65,
	0x73, 0x65, 0x74, 0x12, 0xd9, 0x01, 0x0a, 0x0d, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46, 0x69, 0x6c,
	0x65, 0x44, 0x69, 0x66, 0x66, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x46, 0x69, 0x6c, 0x65, 0x44,
	0x69, 0x66, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x46, 0x69, 0x6c, 0x65, 0x44, 0x69, 0x66, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x12, 0x55, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x69, 0x66, 0x66, 0x12,
	0xfd, 0x01, 0x0a, 0x16, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x66, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x60, 0x12,
	0x5e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0xdc, 0x01, 0x0a, 0x0d, 0x4d, 0x61, 0x6b, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x61, 0x6b, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x6b, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x60, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x01, 0x2a, 0x22, 0x55, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x6d, 0x61, 0x6b, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0xc4,
	0x01, 0x0a, 0x0f, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x62, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x3a, 0x01, 0x2a, 0x22, 0x57, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0xdc, 0x01, 0x0a, 0x0d, 0x4d, 0x6f, 0x76, 0x65, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x76,
	0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x01, 0x2a, 0x22, 0x55, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x12, 0xc5, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x61, 0x64, 0x46, 0x69, 0x6c,
	0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12, 0x50, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x12, 0xb5, 0x01, 0x0a,
	0x0a, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x01, 0x2a,
	0x22, 0x52, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x46, 0x69, 0x6c, 0x65, 0x12, 0xc8, 0x01, 0x0a, 0x08, 0x4d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x5b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x6f, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12,
	0xcc, 0x01, 0x0a, 0x09, 0x57, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x01, 0x2a, 0x22, 0x51, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x77, 0x72, 0x69, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0xe2,
	0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0xcf, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x55,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x89, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x88, 0x01, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x3a, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x12, 0x8b, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65,
	0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x8a, 0x01, 0xda, 0x41, 0x1a, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x67, 0x3a, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x55, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xbf, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x2a, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xf2, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5b, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0xdf, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x59, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8f, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x82, 0x01, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x60, 0x3a, 0x12, 0x63, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x4a,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x84, 0x02, 0x0a, 0x1d, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x12,
	0x50, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x12, 0xe6, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x58, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xd3, 0x01, 0x0a, 0x11, 0x47,
	0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x90, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x8c, 0x01, 0xda, 0x41, 0x29, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0x92, 0x02, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8e, 0x01, 0xda, 0x41, 0x1b, 0x77, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x3a, 0x0f,
	0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32,
	0x57, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x49, 0x2a, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf6, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x12, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xe3, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x5a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x12,
	0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x95, 0x02, 0x0a,
	0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01, 0xda,
	0x41, 0x1a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x62, 0x3a, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0xce, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x5a, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x2a, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd1, 0x01, 0x0a, 0x18, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x57, 0x3a, 0x01, 0x2a, 0x22, 0x52, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b,
	0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0x88, 0x02, 0x0a, 0x1e, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x53, 0x12, 0x51, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xbd, 0x02, 0xea, 0x41, 0x64, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x21, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0d,
	0x44, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x3d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02,
	0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02,
	0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61,
	0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02,
	0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x44, 0x61, 0x74, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataform_v1beta1_dataform_proto_rawDescOnce sync.Once
	file_google_cloud_dataform_v1beta1_dataform_proto_rawDescData = file_google_cloud_dataform_v1beta1_dataform_proto_rawDesc
)

func file_google_cloud_dataform_v1beta1_dataform_proto_rawDescGZIP() []byte {
	file_google_cloud_dataform_v1beta1_dataform_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataform_v1beta1_dataform_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataform_v1beta1_dataform_proto_rawDescData)
	})
	return file_google_cloud_dataform_v1beta1_dataform_proto_rawDescData
}

var file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes = make([]protoimpl.MessageInfo, 112)
var file_google_cloud_dataform_v1beta1_dataform_proto_goTypes = []interface{}{
	(Repository_GitRemoteSettings_TokenStatus)(0),                 // 0: google.cloud.dataform.v1beta1.Repository.GitRemoteSettings.TokenStatus
	(ComputeRepositoryAccessTokenStatusResponse_TokenStatus)(0),   // 1: google.cloud.dataform.v1beta1.ComputeRepositoryAccessTokenStatusResponse.TokenStatus
	(FetchFileGitStatusesResponse_UncommittedFileChange_State)(0), // 2: google.cloud.dataform.v1beta1.FetchFileGitStatusesResponse.UncommittedFileChange.State
	(CompilationResultAction_Relation_RelationType)(0),            // 3: google.cloud.dataform.v1beta1.CompilationResultAction.Relation.RelationType
	(WorkflowInvocation_State)(0),                                 // 4: google.cloud.dataform.v1beta1.WorkflowInvocation.State
	(WorkflowInvocationAction_State)(0),                           // 5: google.cloud.dataform.v1beta1.WorkflowInvocationAction.State
	(*Repository)(nil),                                            // 6: google.cloud.dataform.v1beta1.Repository
	(*ListRepositoriesRequest)(nil),                               // 7: google.cloud.dataform.v1beta1.ListRepositoriesRequest
	(*ListRepositoriesResponse)(nil),                              // 8: google.cloud.dataform.v1beta1.ListRepositoriesResponse
	(*GetRepositoryRequest)(nil),                                  // 9: google.cloud.dataform.v1beta1.GetRepositoryRequest
	(*CreateRepositoryRequest)(nil),                               // 10: google.cloud.dataform.v1beta1.CreateRepositoryRequest
	(*UpdateRepositoryRequest)(nil),                               // 11: google.cloud.dataform.v1beta1.UpdateRepositoryRequest
	(*DeleteRepositoryRequest)(nil),                               // 12: google.cloud.dataform.v1beta1.DeleteRepositoryRequest
	(*CommitRepositoryChangesRequest)(nil),                        // 13: google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest
	(*ReadRepositoryFileRequest)(nil),                             // 14: google.cloud.dataform.v1beta1.ReadRepositoryFileRequest
	(*ReadRepositoryFileResponse)(nil),                            // 15: google.cloud.dataform.v1beta1.ReadRepositoryFileResponse
	(*QueryRepositoryDirectoryContentsRequest)(nil),               // 16: google.cloud.dataform.v1beta1.QueryRepositoryDirectoryContentsRequest
	(*QueryRepositoryDirectoryContentsResponse)(nil),              // 17: google.cloud.dataform.v1beta1.QueryRepositoryDirectoryContentsResponse
	(*FetchRepositoryHistoryRequest)(nil),                         // 18: google.cloud.dataform.v1beta1.FetchRepositoryHistoryRequest
	(*FetchRepositoryHistoryResponse)(nil),                        // 19: google.cloud.dataform.v1beta1.FetchRepositoryHistoryResponse
	(*CommitLogEntry)(nil),                                        // 20: google.cloud.dataform.v1beta1.CommitLogEntry
	(*CommitMetadata)(nil),                                        // 21: google.cloud.dataform.v1beta1.CommitMetadata
	(*ComputeRepositoryAccessTokenStatusRequest)(nil),             // 22: google.cloud.dataform.v1beta1.ComputeRepositoryAccessTokenStatusRequest
	(*ComputeRepositoryAccessTokenStatusResponse)(nil),            // 23: google.cloud.dataform.v1beta1.ComputeRepositoryAccessTokenStatusResponse
	(*FetchRemoteBranchesRequest)(nil),                            // 24: google.cloud.dataform.v1beta1.FetchRemoteBranchesRequest
	(*FetchRemoteBranchesResponse)(nil),                           // 25: google.cloud.dataform.v1beta1.FetchRemoteBranchesResponse
	(*Workspace)(nil),                                             // 26: google.cloud.dataform.v1beta1.Workspace
	(*ListWorkspacesRequest)(nil),                                 // 27: google.cloud.dataform.v1beta1.ListWorkspacesRequest
	(*ListWorkspacesResponse)(nil),                                // 28: google.cloud.dataform.v1beta1.ListWorkspacesResponse
	(*GetWorkspaceRequest)(nil),                                   // 29: google.cloud.dataform.v1beta1.GetWorkspaceRequest
	(*CreateWorkspaceRequest)(nil),                                // 30: google.cloud.dataform.v1beta1.CreateWorkspaceRequest
	(*DeleteWorkspaceRequest)(nil),                                // 31: google.cloud.dataform.v1beta1.DeleteWorkspaceRequest
	(*CommitAuthor)(nil),                                          // 32: google.cloud.dataform.v1beta1.CommitAuthor
	(*PullGitCommitsRequest)(nil),                                 // 33: google.cloud.dataform.v1beta1.PullGitCommitsRequest
	(*PushGitCommitsRequest)(nil),                                 // 34: google.cloud.dataform.v1beta1.PushGitCommitsRequest
	(*FetchFileGitStatusesRequest)(nil),                           // 35: google.cloud.dataform.v1beta1.FetchFileGitStatusesRequest
	(*FetchFileGitStatusesResponse)(nil),                          // 36: google.cloud.dataform.v1beta1.FetchFileGitStatusesResponse
	(*FetchGitAheadBehindRequest)(nil),                            // 37: google.cloud.dataform.v1beta1.FetchGitAheadBehindRequest
	(*FetchGitAheadBehindResponse)(nil),                           // 38: google.cloud.dataform.v1beta1.FetchGitAheadBehindResponse
	(*CommitWorkspaceChangesRequest)(nil),                         // 39: google.cloud.dataform.v1beta1.CommitWorkspaceChangesRequest
	(*ResetWorkspaceChangesRequest)(nil),                          // 40: google.cloud.dataform.v1beta1.ResetWorkspaceChangesRequest
	(*FetchFileDiffRequest)(nil),                                  // 41: google.cloud.dataform.v1beta1.FetchFileDiffRequest
	(*FetchFileDiffResponse)(nil),                                 // 42: google.cloud.dataform.v1beta1.FetchFileDiffResponse
	(*QueryDirectoryContentsRequest)(nil),                         // 43: google.cloud.dataform.v1beta1.QueryDirectoryContentsRequest
	(*QueryDirectoryContentsResponse)(nil),                        // 44: google.cloud.dataform.v1beta1.QueryDirectoryContentsResponse
	(*DirectoryEntry)(nil),                                        // 45: google.cloud.dataform.v1beta1.DirectoryEntry
	(*MakeDirectoryRequest)(nil),                                  // 46: google.cloud.dataform.v1beta1.MakeDirectoryRequest
	(*MakeDirectoryResponse)(nil),                                 // 47: google.cloud.dataform.v1beta1.MakeDirectoryResponse
	(*RemoveDirectoryRequest)(nil),                                // 48: google.cloud.dataform.v1beta1.RemoveDirectoryRequest
	(*MoveDirectoryRequest)(nil),                                  // 49: google.cloud.dataform.v1beta1.MoveDirectoryRequest
	(*MoveDirectoryResponse)(nil),                                 // 50: google.cloud.dataform.v1beta1.MoveDirectoryResponse
	(*ReadFileRequest)(nil),                                       // 51: google.cloud.dataform.v1beta1.ReadFileRequest
	(*ReadFileResponse)(nil),                                      // 52: google.cloud.dataform.v1beta1.ReadFileResponse
	(*RemoveFileRequest)(nil),                                     // 53: google.cloud.dataform.v1beta1.RemoveFileRequest
	(*MoveFileRequest)(nil),                                       // 54: google.cloud.dataform.v1beta1.MoveFileRequest
	(*MoveFileResponse)(nil),                                      // 55: google.cloud.dataform.v1beta1.MoveFileResponse
	(*WriteFileRequest)(nil),                                      // 56: google.cloud.dataform.v1beta1.WriteFileRequest
	(*WriteFileResponse)(nil),                                     // 57: google.cloud.dataform.v1beta1.WriteFileResponse
	(*InstallNpmPackagesRequest)(nil),                             // 58: google.cloud.dataform.v1beta1.InstallNpmPackagesRequest
	(*InstallNpmPackagesResponse)(nil),                            // 59: google.cloud.dataform.v1beta1.InstallNpmPackagesResponse
	(*ReleaseConfig)(nil),                                         // 60: google.cloud.dataform.v1beta1.ReleaseConfig
	(*ListReleaseConfigsRequest)(nil),                             // 61: google.cloud.dataform.v1beta1.ListReleaseConfigsRequest
	(*ListReleaseConfigsResponse)(nil),                            // 62: google.cloud.dataform.v1beta1.ListReleaseConfigsResponse
	(*GetReleaseConfigRequest)(nil),                               // 63: google.cloud.dataform.v1beta1.GetReleaseConfigRequest
	(*CreateReleaseConfigRequest)(nil),                            // 64: google.cloud.dataform.v1beta1.CreateReleaseConfigRequest
	(*UpdateReleaseConfigRequest)(nil),                            // 65: google.cloud.dataform.v1beta1.UpdateReleaseConfigRequest
	(*DeleteReleaseConfigRequest)(nil),                            // 66: google.cloud.dataform.v1beta1.DeleteReleaseConfigRequest
	(*CompilationResult)(nil),                                     // 67: google.cloud.dataform.v1beta1.CompilationResult
	(*CodeCompilationConfig)(nil),                                 // 68: google.cloud.dataform.v1beta1.CodeCompilationConfig
	(*ListCompilationResultsRequest)(nil),                         // 69: google.cloud.dataform.v1beta1.ListCompilationResultsRequest
	(*ListCompilationResultsResponse)(nil),                        // 70: google.cloud.dataform.v1beta1.ListCompilationResultsResponse
	(*GetCompilationResultRequest)(nil),                           // 71: google.cloud.dataform.v1beta1.GetCompilationResultRequest
	(*CreateCompilationResultRequest)(nil),                        // 72: google.cloud.dataform.v1beta1.CreateCompilationResultRequest
	(*Target)(nil),                                                // 73: google.cloud.dataform.v1beta1.Target
	(*RelationDescriptor)(nil),                                    // 74: google.cloud.dataform.v1beta1.RelationDescriptor
	(*CompilationResultAction)(nil),                               // 75: google.cloud.dataform.v1beta1.CompilationResultAction
	(*QueryCompilationResultActionsRequest)(nil),                  // 76: google.cloud.dataform.v1beta1.QueryCompilationResultActionsRequest
	(*QueryCompilationResultActionsResponse)(nil),                 // 77: google.cloud.dataform.v1beta1.QueryCompilationResultActionsResponse
	(*WorkflowConfig)(nil),                                        // 78: google.cloud.dataform.v1beta1.WorkflowConfig
	(*InvocationConfig)(nil),                                      // 79: google.cloud.dataform.v1beta1.InvocationConfig
	(*ListWorkflowConfigsRequest)(nil),                            // 80: google.cloud.dataform.v1beta1.ListWorkflowConfigsRequest
	(*ListWorkflowConfigsResponse)(nil),                           // 81: google.cloud.dataform.v1beta1.ListWorkflowConfigsResponse
	(*GetWorkflowConfigRequest)(nil),                              // 82: google.cloud.dataform.v1beta1.GetWorkflowConfigRequest
	(*CreateWorkflowConfigRequest)(nil),                           // 83: google.cloud.dataform.v1beta1.CreateWorkflowConfigRequest
	(*UpdateWorkflowConfigRequest)(nil),                           // 84: google.cloud.dataform.v1beta1.UpdateWorkflowConfigRequest
	(*DeleteWorkflowConfigRequest)(nil),                           // 85: google.cloud.dataform.v1beta1.DeleteWorkflowConfigRequest
	(*WorkflowInvocation)(nil),                                    // 86: google.cloud.dataform.v1beta1.WorkflowInvocation
	(*ListWorkflowInvocationsRequest)(nil),                        // 87: google.cloud.dataform.v1beta1.ListWorkflowInvocationsRequest
	(*ListWorkflowInvocationsResponse)(nil),                       // 88: google.cloud.dataform.v1beta1.ListWorkflowInvocationsResponse
	(*GetWorkflowInvocationRequest)(nil),                          // 89: google.cloud.dataform.v1beta1.GetWorkflowInvocationRequest
	(*CreateWorkflowInvocationRequest)(nil),                       // 90: google.cloud.dataform.v1beta1.CreateWorkflowInvocationRequest
	(*DeleteWorkflowInvocationRequest)(nil),                       // 91: google.cloud.dataform.v1beta1.DeleteWorkflowInvocationRequest
	(*CancelWorkflowInvocationRequest)(nil),                       // 92: google.cloud.dataform.v1beta1.CancelWorkflowInvocationRequest
	(*WorkflowInvocationAction)(nil),                              // 93: google.cloud.dataform.v1beta1.WorkflowInvocationAction
	(*QueryWorkflowInvocationActionsRequest)(nil),                 // 94: google.cloud.dataform.v1beta1.QueryWorkflowInvocationActionsRequest
	(*QueryWorkflowInvocationActionsResponse)(nil),                // 95: google.cloud.dataform.v1beta1.QueryWorkflowInvocationActionsResponse
	(*Repository_GitRemoteSettings)(nil),                          // 96: google.cloud.dataform.v1beta1.Repository.GitRemoteSettings
	(*Repository_WorkspaceCompilationOverrides)(nil),              // 97: google.cloud.dataform.v1beta1.Repository.WorkspaceCompilationOverrides
	nil, // 98: google.cloud.dataform.v1beta1.Repository.LabelsEntry
	(*Repository_GitRemoteSettings_SshAuthenticationConfig)(nil), // 99: google.cloud.dataform.v1beta1.Repository.GitRemoteSettings.SshAuthenticationConfig
	(*CommitRepositoryChangesRequest_FileOperation)(nil),         // 100: google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperation
	nil, // 101: google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperationsEntry
	(*CommitRepositoryChangesRequest_FileOperation_WriteFile)(nil),  // 102: google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperation.WriteFile
	(*CommitRepositoryChangesRequest_FileOperation_DeleteFile)(nil), // 103: google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperation.DeleteFile
	(*FetchFileGitStatusesResponse_UncommittedFileChange)(nil),      // 104: google.cloud.dataform.v1beta1.FetchFileGitStatusesResponse.UncommittedFileChange
	(*ReleaseConfig_ScheduledReleaseRecord)(nil),                    // 105: google.cloud.dataform.v1beta1.ReleaseConfig.ScheduledReleaseRecord
	(*CompilationResult_CompilationError)(nil),                      // 106: google.cloud.dataform.v1beta1.CompilationResult.CompilationError
	nil, // 107: google.cloud.dataform.v1beta1.CodeCompilationConfig.VarsEntry
	(*RelationDescriptor_ColumnDescriptor)(nil), // 108: google.cloud.dataform.v1beta1.RelationDescriptor.ColumnDescriptor
	nil,                                      // 109: google.cloud.dataform.v1beta1.RelationDescriptor.BigqueryLabelsEntry
	(*CompilationResultAction_Relation)(nil), // 110: google.cloud.dataform.v1beta1.CompilationResultAction.Relation
	(*CompilationResultAction_Operations)(nil),                      // 111: google.cloud.dataform.v1beta1.CompilationResultAction.Operations
	(*CompilationResultAction_Assertion)(nil),                       // 112: google.cloud.dataform.v1beta1.CompilationResultAction.Assertion
	(*CompilationResultAction_Declaration)(nil),                     // 113: google.cloud.dataform.v1beta1.CompilationResultAction.Declaration
	(*CompilationResultAction_Relation_IncrementalTableConfig)(nil), // 114: google.cloud.dataform.v1beta1.CompilationResultAction.Relation.IncrementalTableConfig
	nil, // 115: google.cloud.dataform.v1beta1.CompilationResultAction.Relation.AdditionalOptionsEntry
	(*WorkflowConfig_ScheduledExecutionRecord)(nil), // 116: google.cloud.dataform.v1beta1.WorkflowConfig.ScheduledExecutionRecord
	(*WorkflowInvocationAction_BigQueryAction)(nil), // 117: google.cloud.dataform.v1beta1.WorkflowInvocationAction.BigQueryAction
	(*fieldmaskpb.FieldMask)(nil),                   // 118: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                   // 119: google.protobuf.Timestamp
	(*interval.Interval)(nil),                       // 120: google.type.Interval
	(*status.Status)(nil),                           // 121: google.rpc.Status
	(*emptypb.Empty)(nil),                           // 122: google.protobuf.Empty
}
var file_google_cloud_dataform_v1beta1_dataform_proto_depIdxs = []int32{
	96,  // 0: google.cloud.dataform.v1beta1.Repository.git_remote_settings:type_name -> google.cloud.dataform.v1beta1.Repository.GitRemoteSettings
	97,  // 1: google.cloud.dataform.v1beta1.Repository.workspace_compilation_overrides:type_name -> google.cloud.dataform.v1beta1.Repository.WorkspaceCompilationOverrides
	98,  // 2: google.cloud.dataform.v1beta1.Repository.labels:type_name -> google.cloud.dataform.v1beta1.Repository.LabelsEntry
	6,   // 3: google.cloud.dataform.v1beta1.ListRepositoriesResponse.repositories:type_name -> google.cloud.dataform.v1beta1.Repository
	6,   // 4: google.cloud.dataform.v1beta1.CreateRepositoryRequest.repository:type_name -> google.cloud.dataform.v1beta1.Repository
	118, // 5: google.cloud.dataform.v1beta1.UpdateRepositoryRequest.update_mask:type_name -> google.protobuf.FieldMask
	6,   // 6: google.cloud.dataform.v1beta1.UpdateRepositoryRequest.repository:type_name -> google.cloud.dataform.v1beta1.Repository
	21,  // 7: google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.commit_metadata:type_name -> google.cloud.dataform.v1beta1.CommitMetadata
	101, // 8: google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.file_operations:type_name -> google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperationsEntry
	45,  // 9: google.cloud.dataform.v1beta1.QueryRepositoryDirectoryContentsResponse.directory_entries:type_name -> google.cloud.dataform.v1beta1.DirectoryEntry
	20,  // 10: google.cloud.dataform.v1beta1.FetchRepositoryHistoryResponse.commits:type_name -> google.cloud.dataform.v1beta1.CommitLogEntry
	119, // 11: google.cloud.dataform.v1beta1.CommitLogEntry.commit_time:type_name -> google.protobuf.Timestamp
	32,  // 12: google.cloud.dataform.v1beta1.CommitLogEntry.author:type_name -> google.cloud.dataform.v1beta1.CommitAuthor
	32,  // 13: google.cloud.dataform.v1beta1.CommitMetadata.author:type_name -> google.cloud.dataform.v1beta1.CommitAuthor
	1,   // 14: google.cloud.dataform.v1beta1.ComputeRepositoryAccessTokenStatusResponse.token_status:type_name -> google.cloud.dataform.v1beta1.ComputeRepositoryAccessTokenStatusResponse.TokenStatus
	26,  // 15: google.cloud.dataform.v1beta1.ListWorkspacesResponse.workspaces:type_name -> google.cloud.dataform.v1beta1.Workspace
	26,  // 16: google.cloud.dataform.v1beta1.CreateWorkspaceRequest.workspace:type_name -> google.cloud.dataform.v1beta1.Workspace
	32,  // 17: google.cloud.dataform.v1beta1.PullGitCommitsRequest.author:type_name -> google.cloud.dataform.v1beta1.CommitAuthor
	104, // 18: google.cloud.dataform.v1beta1.FetchFileGitStatusesResponse.uncommitted_file_changes:type_name -> google.cloud.dataform.v1beta1.FetchFileGitStatusesResponse.UncommittedFileChange
	32,  // 19: google.cloud.dataform.v1beta1.CommitWorkspaceChangesRequest.author:type_name -> google.cloud.dataform.v1beta1.CommitAuthor
	45,  // 20: google.cloud.dataform.v1beta1.QueryDirectoryContentsResponse.directory_entries:type_name -> google.cloud.dataform.v1beta1.DirectoryEntry
	68,  // 21: google.cloud.dataform.v1beta1.ReleaseConfig.code_compilation_config:type_name -> google.cloud.dataform.v1beta1.CodeCompilationConfig
	105, // 22: google.cloud.dataform.v1beta1.ReleaseConfig.recent_scheduled_release_records:type_name -> google.cloud.dataform.v1beta1.ReleaseConfig.ScheduledReleaseRecord
	60,  // 23: google.cloud.dataform.v1beta1.ListReleaseConfigsResponse.release_configs:type_name -> google.cloud.dataform.v1beta1.ReleaseConfig
	60,  // 24: google.cloud.dataform.v1beta1.CreateReleaseConfigRequest.release_config:type_name -> google.cloud.dataform.v1beta1.ReleaseConfig
	118, // 25: google.cloud.dataform.v1beta1.UpdateReleaseConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	60,  // 26: google.cloud.dataform.v1beta1.UpdateReleaseConfigRequest.release_config:type_name -> google.cloud.dataform.v1beta1.ReleaseConfig
	68,  // 27: google.cloud.dataform.v1beta1.CompilationResult.code_compilation_config:type_name -> google.cloud.dataform.v1beta1.CodeCompilationConfig
	106, // 28: google.cloud.dataform.v1beta1.CompilationResult.compilation_errors:type_name -> google.cloud.dataform.v1beta1.CompilationResult.CompilationError
	107, // 29: google.cloud.dataform.v1beta1.CodeCompilationConfig.vars:type_name -> google.cloud.dataform.v1beta1.CodeCompilationConfig.VarsEntry
	67,  // 30: google.cloud.dataform.v1beta1.ListCompilationResultsResponse.compilation_results:type_name -> google.cloud.dataform.v1beta1.CompilationResult
	67,  // 31: google.cloud.dataform.v1beta1.CreateCompilationResultRequest.compilation_result:type_name -> google.cloud.dataform.v1beta1.CompilationResult
	108, // 32: google.cloud.dataform.v1beta1.RelationDescriptor.columns:type_name -> google.cloud.dataform.v1beta1.RelationDescriptor.ColumnDescriptor
	109, // 33: google.cloud.dataform.v1beta1.RelationDescriptor.bigquery_labels:type_name -> google.cloud.dataform.v1beta1.RelationDescriptor.BigqueryLabelsEntry
	73,  // 34: google.cloud.dataform.v1beta1.CompilationResultAction.target:type_name -> google.cloud.dataform.v1beta1.Target
	73,  // 35: google.cloud.dataform.v1beta1.CompilationResultAction.canonical_target:type_name -> google.cloud.dataform.v1beta1.Target
	110, // 36: google.cloud.dataform.v1beta1.CompilationResultAction.relation:type_name -> google.cloud.dataform.v1beta1.CompilationResultAction.Relation
	111, // 37: google.cloud.dataform.v1beta1.CompilationResultAction.operations:type_name -> google.cloud.dataform.v1beta1.CompilationResultAction.Operations
	112, // 38: google.cloud.dataform.v1beta1.CompilationResultAction.assertion:type_name -> google.cloud.dataform.v1beta1.CompilationResultAction.Assertion
	113, // 39: google.cloud.dataform.v1beta1.CompilationResultAction.declaration:type_name -> google.cloud.dataform.v1beta1.CompilationResultAction.Declaration
	75,  // 40: google.cloud.dataform.v1beta1.QueryCompilationResultActionsResponse.compilation_result_actions:type_name -> google.cloud.dataform.v1beta1.CompilationResultAction
	79,  // 41: google.cloud.dataform.v1beta1.WorkflowConfig.invocation_config:type_name -> google.cloud.dataform.v1beta1.InvocationConfig
	116, // 42: google.cloud.dataform.v1beta1.WorkflowConfig.recent_scheduled_execution_records:type_name -> google.cloud.dataform.v1beta1.WorkflowConfig.ScheduledExecutionRecord
	73,  // 43: google.cloud.dataform.v1beta1.InvocationConfig.included_targets:type_name -> google.cloud.dataform.v1beta1.Target
	78,  // 44: google.cloud.dataform.v1beta1.ListWorkflowConfigsResponse.workflow_configs:type_name -> google.cloud.dataform.v1beta1.WorkflowConfig
	78,  // 45: google.cloud.dataform.v1beta1.CreateWorkflowConfigRequest.workflow_config:type_name -> google.cloud.dataform.v1beta1.WorkflowConfig
	118, // 46: google.cloud.dataform.v1beta1.UpdateWorkflowConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	78,  // 47: google.cloud.dataform.v1beta1.UpdateWorkflowConfigRequest.workflow_config:type_name -> google.cloud.dataform.v1beta1.WorkflowConfig
	79,  // 48: google.cloud.dataform.v1beta1.WorkflowInvocation.invocation_config:type_name -> google.cloud.dataform.v1beta1.InvocationConfig
	4,   // 49: google.cloud.dataform.v1beta1.WorkflowInvocation.state:type_name -> google.cloud.dataform.v1beta1.WorkflowInvocation.State
	120, // 50: google.cloud.dataform.v1beta1.WorkflowInvocation.invocation_timing:type_name -> google.type.Interval
	86,  // 51: google.cloud.dataform.v1beta1.ListWorkflowInvocationsResponse.workflow_invocations:type_name -> google.cloud.dataform.v1beta1.WorkflowInvocation
	86,  // 52: google.cloud.dataform.v1beta1.CreateWorkflowInvocationRequest.workflow_invocation:type_name -> google.cloud.dataform.v1beta1.WorkflowInvocation
	73,  // 53: google.cloud.dataform.v1beta1.WorkflowInvocationAction.target:type_name -> google.cloud.dataform.v1beta1.Target
	73,  // 54: google.cloud.dataform.v1beta1.WorkflowInvocationAction.canonical_target:type_name -> google.cloud.dataform.v1beta1.Target
	5,   // 55: google.cloud.dataform.v1beta1.WorkflowInvocationAction.state:type_name -> google.cloud.dataform.v1beta1.WorkflowInvocationAction.State
	120, // 56: google.cloud.dataform.v1beta1.WorkflowInvocationAction.invocation_timing:type_name -> google.type.Interval
	117, // 57: google.cloud.dataform.v1beta1.WorkflowInvocationAction.bigquery_action:type_name -> google.cloud.dataform.v1beta1.WorkflowInvocationAction.BigQueryAction
	93,  // 58: google.cloud.dataform.v1beta1.QueryWorkflowInvocationActionsResponse.workflow_invocation_actions:type_name -> google.cloud.dataform.v1beta1.WorkflowInvocationAction
	99,  // 59: google.cloud.dataform.v1beta1.Repository.GitRemoteSettings.ssh_authentication_config:type_name -> google.cloud.dataform.v1beta1.Repository.GitRemoteSettings.SshAuthenticationConfig
	0,   // 60: google.cloud.dataform.v1beta1.Repository.GitRemoteSettings.token_status:type_name -> google.cloud.dataform.v1beta1.Repository.GitRemoteSettings.TokenStatus
	102, // 61: google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperation.write_file:type_name -> google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperation.WriteFile
	103, // 62: google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperation.delete_file:type_name -> google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperation.DeleteFile
	100, // 63: google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperationsEntry.value:type_name -> google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest.FileOperation
	2,   // 64: google.cloud.dataform.v1beta1.FetchFileGitStatusesResponse.UncommittedFileChange.state:type_name -> google.cloud.dataform.v1beta1.FetchFileGitStatusesResponse.UncommittedFileChange.State
	119, // 65: google.cloud.dataform.v1beta1.ReleaseConfig.ScheduledReleaseRecord.release_time:type_name -> google.protobuf.Timestamp
	121, // 66: google.cloud.dataform.v1beta1.ReleaseConfig.ScheduledReleaseRecord.error_status:type_name -> google.rpc.Status
	73,  // 67: google.cloud.dataform.v1beta1.CompilationResult.CompilationError.action_target:type_name -> google.cloud.dataform.v1beta1.Target
	73,  // 68: google.cloud.dataform.v1beta1.CompilationResultAction.Relation.dependency_targets:type_name -> google.cloud.dataform.v1beta1.Target
	74,  // 69: google.cloud.dataform.v1beta1.CompilationResultAction.Relation.relation_descriptor:type_name -> google.cloud.dataform.v1beta1.RelationDescriptor
	3,   // 70: google.cloud.dataform.v1beta1.CompilationResultAction.Relation.relation_type:type_name -> google.cloud.dataform.v1beta1.CompilationResultAction.Relation.RelationType
	114, // 71: google.cloud.dataform.v1beta1.CompilationResultAction.Relation.incremental_table_config:type_name -> google.cloud.dataform.v1beta1.CompilationResultAction.Relation.IncrementalTableConfig
	115, // 72: google.cloud.dataform.v1beta1.CompilationResultAction.Relation.additional_options:type_name -> google.cloud.dataform.v1beta1.CompilationResultAction.Relation.AdditionalOptionsEntry
	73,  // 73: google.cloud.dataform.v1beta1.CompilationResultAction.Operations.dependency_targets:type_name -> google.cloud.dataform.v1beta1.Target
	74,  // 74: google.cloud.dataform.v1beta1.CompilationResultAction.Operations.relation_descriptor:type_name -> google.cloud.dataform.v1beta1.RelationDescriptor
	73,  // 75: google.cloud.dataform.v1beta1.CompilationResultAction.Assertion.dependency_targets:type_name -> google.cloud.dataform.v1beta1.Target
	73,  // 76: google.cloud.dataform.v1beta1.CompilationResultAction.Assertion.parent_action:type_name -> google.cloud.dataform.v1beta1.Target
	74,  // 77: google.cloud.dataform.v1beta1.CompilationResultAction.Assertion.relation_descriptor:type_name -> google.cloud.dataform.v1beta1.RelationDescriptor
	74,  // 78: google.cloud.dataform.v1beta1.CompilationResultAction.Declaration.relation_descriptor:type_name -> google.cloud.dataform.v1beta1.RelationDescriptor
	119, // 79: google.cloud.dataform.v1beta1.WorkflowConfig.ScheduledExecutionRecord.execution_time:type_name -> google.protobuf.Timestamp
	121, // 80: google.cloud.dataform.v1beta1.WorkflowConfig.ScheduledExecutionRecord.error_status:type_name -> google.rpc.Status
	7,   // 81: google.cloud.dataform.v1beta1.Dataform.ListRepositories:input_type -> google.cloud.dataform.v1beta1.ListRepositoriesRequest
	9,   // 82: google.cloud.dataform.v1beta1.Dataform.GetRepository:input_type -> google.cloud.dataform.v1beta1.GetRepositoryRequest
	10,  // 83: google.cloud.dataform.v1beta1.Dataform.CreateRepository:input_type -> google.cloud.dataform.v1beta1.CreateRepositoryRequest
	11,  // 84: google.cloud.dataform.v1beta1.Dataform.UpdateRepository:input_type -> google.cloud.dataform.v1beta1.UpdateRepositoryRequest
	12,  // 85: google.cloud.dataform.v1beta1.Dataform.DeleteRepository:input_type -> google.cloud.dataform.v1beta1.DeleteRepositoryRequest
	13,  // 86: google.cloud.dataform.v1beta1.Dataform.CommitRepositoryChanges:input_type -> google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest
	14,  // 87: google.cloud.dataform.v1beta1.Dataform.ReadRepositoryFile:input_type -> google.cloud.dataform.v1beta1.ReadRepositoryFileRequest
	16,  // 88: google.cloud.dataform.v1beta1.Dataform.QueryRepositoryDirectoryContents:input_type -> google.cloud.dataform.v1beta1.QueryRepositoryDirectoryContentsRequest
	18,  // 89: google.cloud.dataform.v1beta1.Dataform.FetchRepositoryHistory:input_type -> google.cloud.dataform.v1beta1.FetchRepositoryHistoryRequest
	22,  // 90: google.cloud.dataform.v1beta1.Dataform.ComputeRepositoryAccessTokenStatus:input_type -> google.cloud.dataform.v1beta1.ComputeRepositoryAccessTokenStatusRequest
	24,  // 91: google.cloud.dataform.v1beta1.Dataform.FetchRemoteBranches:input_type -> google.cloud.dataform.v1beta1.FetchRemoteBranchesRequest
	27,  // 92: google.cloud.dataform.v1beta1.Dataform.ListWorkspaces:input_type -> google.cloud.dataform.v1beta1.ListWorkspacesRequest
	29,  // 93: google.cloud.dataform.v1beta1.Dataform.GetWorkspace:input_type -> google.cloud.dataform.v1beta1.GetWorkspaceRequest
	30,  // 94: google.cloud.dataform.v1beta1.Dataform.CreateWorkspace:input_type -> google.cloud.dataform.v1beta1.CreateWorkspaceRequest
	31,  // 95: google.cloud.dataform.v1beta1.Dataform.DeleteWorkspace:input_type -> google.cloud.dataform.v1beta1.DeleteWorkspaceRequest
	58,  // 96: google.cloud.dataform.v1beta1.Dataform.InstallNpmPackages:input_type -> google.cloud.dataform.v1beta1.InstallNpmPackagesRequest
	33,  // 97: google.cloud.dataform.v1beta1.Dataform.PullGitCommits:input_type -> google.cloud.dataform.v1beta1.PullGitCommitsRequest
	34,  // 98: google.cloud.dataform.v1beta1.Dataform.PushGitCommits:input_type -> google.cloud.dataform.v1beta1.PushGitCommitsRequest
	35,  // 99: google.cloud.dataform.v1beta1.Dataform.FetchFileGitStatuses:input_type -> google.cloud.dataform.v1beta1.FetchFileGitStatusesRequest
	37,  // 100: google.cloud.dataform.v1beta1.Dataform.FetchGitAheadBehind:input_type -> google.cloud.dataform.v1beta1.FetchGitAheadBehindRequest
	39,  // 101: google.cloud.dataform.v1beta1.Dataform.CommitWorkspaceChanges:input_type -> google.cloud.dataform.v1beta1.CommitWorkspaceChangesRequest
	40,  // 102: google.cloud.dataform.v1beta1.Dataform.ResetWorkspaceChanges:input_type -> google.cloud.dataform.v1beta1.ResetWorkspaceChangesRequest
	41,  // 103: google.cloud.dataform.v1beta1.Dataform.FetchFileDiff:input_type -> google.cloud.dataform.v1beta1.FetchFileDiffRequest
	43,  // 104: google.cloud.dataform.v1beta1.Dataform.QueryDirectoryContents:input_type -> google.cloud.dataform.v1beta1.QueryDirectoryContentsRequest
	46,  // 105: google.cloud.dataform.v1beta1.Dataform.MakeDirectory:input_type -> google.cloud.dataform.v1beta1.MakeDirectoryRequest
	48,  // 106: google.cloud.dataform.v1beta1.Dataform.RemoveDirectory:input_type -> google.cloud.dataform.v1beta1.RemoveDirectoryRequest
	49,  // 107: google.cloud.dataform.v1beta1.Dataform.MoveDirectory:input_type -> google.cloud.dataform.v1beta1.MoveDirectoryRequest
	51,  // 108: google.cloud.dataform.v1beta1.Dataform.ReadFile:input_type -> google.cloud.dataform.v1beta1.ReadFileRequest
	53,  // 109: google.cloud.dataform.v1beta1.Dataform.RemoveFile:input_type -> google.cloud.dataform.v1beta1.RemoveFileRequest
	54,  // 110: google.cloud.dataform.v1beta1.Dataform.MoveFile:input_type -> google.cloud.dataform.v1beta1.MoveFileRequest
	56,  // 111: google.cloud.dataform.v1beta1.Dataform.WriteFile:input_type -> google.cloud.dataform.v1beta1.WriteFileRequest
	61,  // 112: google.cloud.dataform.v1beta1.Dataform.ListReleaseConfigs:input_type -> google.cloud.dataform.v1beta1.ListReleaseConfigsRequest
	63,  // 113: google.cloud.dataform.v1beta1.Dataform.GetReleaseConfig:input_type -> google.cloud.dataform.v1beta1.GetReleaseConfigRequest
	64,  // 114: google.cloud.dataform.v1beta1.Dataform.CreateReleaseConfig:input_type -> google.cloud.dataform.v1beta1.CreateReleaseConfigRequest
	65,  // 115: google.cloud.dataform.v1beta1.Dataform.UpdateReleaseConfig:input_type -> google.cloud.dataform.v1beta1.UpdateReleaseConfigRequest
	66,  // 116: google.cloud.dataform.v1beta1.Dataform.DeleteReleaseConfig:input_type -> google.cloud.dataform.v1beta1.DeleteReleaseConfigRequest
	69,  // 117: google.cloud.dataform.v1beta1.Dataform.ListCompilationResults:input_type -> google.cloud.dataform.v1beta1.ListCompilationResultsRequest
	71,  // 118: google.cloud.dataform.v1beta1.Dataform.GetCompilationResult:input_type -> google.cloud.dataform.v1beta1.GetCompilationResultRequest
	72,  // 119: google.cloud.dataform.v1beta1.Dataform.CreateCompilationResult:input_type -> google.cloud.dataform.v1beta1.CreateCompilationResultRequest
	76,  // 120: google.cloud.dataform.v1beta1.Dataform.QueryCompilationResultActions:input_type -> google.cloud.dataform.v1beta1.QueryCompilationResultActionsRequest
	80,  // 121: google.cloud.dataform.v1beta1.Dataform.ListWorkflowConfigs:input_type -> google.cloud.dataform.v1beta1.ListWorkflowConfigsRequest
	82,  // 122: google.cloud.dataform.v1beta1.Dataform.GetWorkflowConfig:input_type -> google.cloud.dataform.v1beta1.GetWorkflowConfigRequest
	83,  // 123: google.cloud.dataform.v1beta1.Dataform.CreateWorkflowConfig:input_type -> google.cloud.dataform.v1beta1.CreateWorkflowConfigRequest
	84,  // 124: google.cloud.dataform.v1beta1.Dataform.UpdateWorkflowConfig:input_type -> google.cloud.dataform.v1beta1.UpdateWorkflowConfigRequest
	85,  // 125: google.cloud.dataform.v1beta1.Dataform.DeleteWorkflowConfig:input_type -> google.cloud.dataform.v1beta1.DeleteWorkflowConfigRequest
	87,  // 126: google.cloud.dataform.v1beta1.Dataform.ListWorkflowInvocations:input_type -> google.cloud.dataform.v1beta1.ListWorkflowInvocationsRequest
	89,  // 127: google.cloud.dataform.v1beta1.Dataform.GetWorkflowInvocation:input_type -> google.cloud.dataform.v1beta1.GetWorkflowInvocationRequest
	90,  // 128: google.cloud.dataform.v1beta1.Dataform.CreateWorkflowInvocation:input_type -> google.cloud.dataform.v1beta1.CreateWorkflowInvocationRequest
	91,  // 129: google.cloud.dataform.v1beta1.Dataform.DeleteWorkflowInvocation:input_type -> google.cloud.dataform.v1beta1.DeleteWorkflowInvocationRequest
	92,  // 130: google.cloud.dataform.v1beta1.Dataform.CancelWorkflowInvocation:input_type -> google.cloud.dataform.v1beta1.CancelWorkflowInvocationRequest
	94,  // 131: google.cloud.dataform.v1beta1.Dataform.QueryWorkflowInvocationActions:input_type -> google.cloud.dataform.v1beta1.QueryWorkflowInvocationActionsRequest
	8,   // 132: google.cloud.dataform.v1beta1.Dataform.ListRepositories:output_type -> google.cloud.dataform.v1beta1.ListRepositoriesResponse
	6,   // 133: google.cloud.dataform.v1beta1.Dataform.GetRepository:output_type -> google.cloud.dataform.v1beta1.Repository
	6,   // 134: google.cloud.dataform.v1beta1.Dataform.CreateRepository:output_type -> google.cloud.dataform.v1beta1.Repository
	6,   // 135: google.cloud.dataform.v1beta1.Dataform.UpdateRepository:output_type -> google.cloud.dataform.v1beta1.Repository
	122, // 136: google.cloud.dataform.v1beta1.Dataform.DeleteRepository:output_type -> google.protobuf.Empty
	122, // 137: google.cloud.dataform.v1beta1.Dataform.CommitRepositoryChanges:output_type -> google.protobuf.Empty
	15,  // 138: google.cloud.dataform.v1beta1.Dataform.ReadRepositoryFile:output_type -> google.cloud.dataform.v1beta1.ReadRepositoryFileResponse
	17,  // 139: google.cloud.dataform.v1beta1.Dataform.QueryRepositoryDirectoryContents:output_type -> google.cloud.dataform.v1beta1.QueryRepositoryDirectoryContentsResponse
	19,  // 140: google.cloud.dataform.v1beta1.Dataform.FetchRepositoryHistory:output_type -> google.cloud.dataform.v1beta1.FetchRepositoryHistoryResponse
	23,  // 141: google.cloud.dataform.v1beta1.Dataform.ComputeRepositoryAccessTokenStatus:output_type -> google.cloud.dataform.v1beta1.ComputeRepositoryAccessTokenStatusResponse
	25,  // 142: google.cloud.dataform.v1beta1.Dataform.FetchRemoteBranches:output_type -> google.cloud.dataform.v1beta1.FetchRemoteBranchesResponse
	28,  // 143: google.cloud.dataform.v1beta1.Dataform.ListWorkspaces:output_type -> google.cloud.dataform.v1beta1.ListWorkspacesResponse
	26,  // 144: google.cloud.dataform.v1beta1.Dataform.GetWorkspace:output_type -> google.cloud.dataform.v1beta1.Workspace
	26,  // 145: google.cloud.dataform.v1beta1.Dataform.CreateWorkspace:output_type -> google.cloud.dataform.v1beta1.Workspace
	122, // 146: google.cloud.dataform.v1beta1.Dataform.DeleteWorkspace:output_type -> google.protobuf.Empty
	59,  // 147: google.cloud.dataform.v1beta1.Dataform.InstallNpmPackages:output_type -> google.cloud.dataform.v1beta1.InstallNpmPackagesResponse
	122, // 148: google.cloud.dataform.v1beta1.Dataform.PullGitCommits:output_type -> google.protobuf.Empty
	122, // 149: google.cloud.dataform.v1beta1.Dataform.PushGitCommits:output_type -> google.protobuf.Empty
	36,  // 150: google.cloud.dataform.v1beta1.Dataform.FetchFileGitStatuses:output_type -> google.cloud.dataform.v1beta1.FetchFileGitStatusesResponse
	38,  // 151: google.cloud.dataform.v1beta1.Dataform.FetchGitAheadBehind:output_type -> google.cloud.dataform.v1beta1.FetchGitAheadBehindResponse
	122, // 152: google.cloud.dataform.v1beta1.Dataform.CommitWorkspaceChanges:output_type -> google.protobuf.Empty
	122, // 153: google.cloud.dataform.v1beta1.Dataform.ResetWorkspaceChanges:output_type -> google.protobuf.Empty
	42,  // 154: google.cloud.dataform.v1beta1.Dataform.FetchFileDiff:output_type -> google.cloud.dataform.v1beta1.FetchFileDiffResponse
	44,  // 155: google.cloud.dataform.v1beta1.Dataform.QueryDirectoryContents:output_type -> google.cloud.dataform.v1beta1.QueryDirectoryContentsResponse
	47,  // 156: google.cloud.dataform.v1beta1.Dataform.MakeDirectory:output_type -> google.cloud.dataform.v1beta1.MakeDirectoryResponse
	122, // 157: google.cloud.dataform.v1beta1.Dataform.RemoveDirectory:output_type -> google.protobuf.Empty
	50,  // 158: google.cloud.dataform.v1beta1.Dataform.MoveDirectory:output_type -> google.cloud.dataform.v1beta1.MoveDirectoryResponse
	52,  // 159: google.cloud.dataform.v1beta1.Dataform.ReadFile:output_type -> google.cloud.dataform.v1beta1.ReadFileResponse
	122, // 160: google.cloud.dataform.v1beta1.Dataform.RemoveFile:output_type -> google.protobuf.Empty
	55,  // 161: google.cloud.dataform.v1beta1.Dataform.MoveFile:output_type -> google.cloud.dataform.v1beta1.MoveFileResponse
	57,  // 162: google.cloud.dataform.v1beta1.Dataform.WriteFile:output_type -> google.cloud.dataform.v1beta1.WriteFileResponse
	62,  // 163: google.cloud.dataform.v1beta1.Dataform.ListReleaseConfigs:output_type -> google.cloud.dataform.v1beta1.ListReleaseConfigsResponse
	60,  // 164: google.cloud.dataform.v1beta1.Dataform.GetReleaseConfig:output_type -> google.cloud.dataform.v1beta1.ReleaseConfig
	60,  // 165: google.cloud.dataform.v1beta1.Dataform.CreateReleaseConfig:output_type -> google.cloud.dataform.v1beta1.ReleaseConfig
	60,  // 166: google.cloud.dataform.v1beta1.Dataform.UpdateReleaseConfig:output_type -> google.cloud.dataform.v1beta1.ReleaseConfig
	122, // 167: google.cloud.dataform.v1beta1.Dataform.DeleteReleaseConfig:output_type -> google.protobuf.Empty
	70,  // 168: google.cloud.dataform.v1beta1.Dataform.ListCompilationResults:output_type -> google.cloud.dataform.v1beta1.ListCompilationResultsResponse
	67,  // 169: google.cloud.dataform.v1beta1.Dataform.GetCompilationResult:output_type -> google.cloud.dataform.v1beta1.CompilationResult
	67,  // 170: google.cloud.dataform.v1beta1.Dataform.CreateCompilationResult:output_type -> google.cloud.dataform.v1beta1.CompilationResult
	77,  // 171: google.cloud.dataform.v1beta1.Dataform.QueryCompilationResultActions:output_type -> google.cloud.dataform.v1beta1.QueryCompilationResultActionsResponse
	81,  // 172: google.cloud.dataform.v1beta1.Dataform.ListWorkflowConfigs:output_type -> google.cloud.dataform.v1beta1.ListWorkflowConfigsResponse
	78,  // 173: google.cloud.dataform.v1beta1.Dataform.GetWorkflowConfig:output_type -> google.cloud.dataform.v1beta1.WorkflowConfig
	78,  // 174: google.cloud.dataform.v1beta1.Dataform.CreateWorkflowConfig:output_type -> google.cloud.dataform.v1beta1.WorkflowConfig
	78,  // 175: google.cloud.dataform.v1beta1.Dataform.UpdateWorkflowConfig:output_type -> google.cloud.dataform.v1beta1.WorkflowConfig
	122, // 176: google.cloud.dataform.v1beta1.Dataform.DeleteWorkflowConfig:output_type -> google.protobuf.Empty
	88,  // 177: google.cloud.dataform.v1beta1.Dataform.ListWorkflowInvocations:output_type -> google.cloud.dataform.v1beta1.ListWorkflowInvocationsResponse
	86,  // 178: google.cloud.dataform.v1beta1.Dataform.GetWorkflowInvocation:output_type -> google.cloud.dataform.v1beta1.WorkflowInvocation
	86,  // 179: google.cloud.dataform.v1beta1.Dataform.CreateWorkflowInvocation:output_type -> google.cloud.dataform.v1beta1.WorkflowInvocation
	122, // 180: google.cloud.dataform.v1beta1.Dataform.DeleteWorkflowInvocation:output_type -> google.protobuf.Empty
	122, // 181: google.cloud.dataform.v1beta1.Dataform.CancelWorkflowInvocation:output_type -> google.protobuf.Empty
	95,  // 182: google.cloud.dataform.v1beta1.Dataform.QueryWorkflowInvocationActions:output_type -> google.cloud.dataform.v1beta1.QueryWorkflowInvocationActionsResponse
	132, // [132:183] is the sub-list for method output_type
	81,  // [81:132] is the sub-list for method input_type
	81,  // [81:81] is the sub-list for extension type_name
	81,  // [81:81] is the sub-list for extension extendee
	0,   // [0:81] is the sub-list for field type_name
}

func init() { file_google_cloud_dataform_v1beta1_dataform_proto_init() }
func file_google_cloud_dataform_v1beta1_dataform_proto_init() {
	if File_google_cloud_dataform_v1beta1_dataform_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Repository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRepositoriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRepositoriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRepositoryChangesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRepositoryFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRepositoryFileResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryRepositoryDirectoryContentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryRepositoryDirectoryContentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchRepositoryHistoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchRepositoryHistoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeRepositoryAccessTokenStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeRepositoryAccessTokenStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchRemoteBranchesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchRemoteBranchesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Workspace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkspacesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkspacesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWorkspaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitAuthor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PullGitCommitsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PushGitCommitsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchFileGitStatusesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchFileGitStatusesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchGitAheadBehindRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchGitAheadBehindResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitWorkspaceChangesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetWorkspaceChangesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchFileDiffRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchFileDiffResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryDirectoryContentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryDirectoryContentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectoryEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MakeDirectoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MakeDirectoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveDirectoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveDirectoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveDirectoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadFileResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoveFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveFileResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteFileResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallNpmPackagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallNpmPackagesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReleaseConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReleaseConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReleaseConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetReleaseConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateReleaseConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateReleaseConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteReleaseConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompilationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CodeCompilationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCompilationResultsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCompilationResultsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCompilationResultRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCompilationResultRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Target); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelationDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompilationResultAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryCompilationResultActionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryCompilationResultActionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InvocationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkflowConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkflowConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkflowConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkflowConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWorkflowConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWorkflowConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowInvocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkflowInvocationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkflowInvocationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkflowInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkflowInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWorkflowInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelWorkflowInvocationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowInvocationAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryWorkflowInvocationActionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryWorkflowInvocationActionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Repository_GitRemoteSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Repository_WorkspaceCompilationOverrides); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Repository_GitRemoteSettings_SshAuthenticationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRepositoryChangesRequest_FileOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRepositoryChangesRequest_FileOperation_WriteFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitRepositoryChangesRequest_FileOperation_DeleteFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchFileGitStatusesResponse_UncommittedFileChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReleaseConfig_ScheduledReleaseRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompilationResult_CompilationError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RelationDescriptor_ColumnDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[104].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompilationResultAction_Relation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[105].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompilationResultAction_Operations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[106].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompilationResultAction_Assertion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[107].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompilationResultAction_Declaration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[108].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompilationResultAction_Relation_IncrementalTableConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[110].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowConfig_ScheduledExecutionRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[111].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowInvocationAction_BigQueryAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[39].OneofWrappers = []interface{}{
		(*DirectoryEntry_File)(nil),
		(*DirectoryEntry_Directory)(nil),
	}
	file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[61].OneofWrappers = []interface{}{
		(*CompilationResult_GitCommitish)(nil),
		(*CompilationResult_Workspace)(nil),
		(*CompilationResult_ReleaseConfig)(nil),
	}
	file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[69].OneofWrappers = []interface{}{
		(*CompilationResultAction_Relation_)(nil),
		(*CompilationResultAction_Operations_)(nil),
		(*CompilationResultAction_Assertion_)(nil),
		(*CompilationResultAction_Declaration_)(nil),
	}
	file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[80].OneofWrappers = []interface{}{
		(*WorkflowInvocation_CompilationResult)(nil),
		(*WorkflowInvocation_WorkflowConfig)(nil),
	}
	file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[94].OneofWrappers = []interface{}{
		(*CommitRepositoryChangesRequest_FileOperation_WriteFile_)(nil),
		(*CommitRepositoryChangesRequest_FileOperation_DeleteFile_)(nil),
	}
	file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[99].OneofWrappers = []interface{}{
		(*ReleaseConfig_ScheduledReleaseRecord_CompilationResult)(nil),
		(*ReleaseConfig_ScheduledReleaseRecord_ErrorStatus)(nil),
	}
	file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes[110].OneofWrappers = []interface{}{
		(*WorkflowConfig_ScheduledExecutionRecord_WorkflowInvocation)(nil),
		(*WorkflowConfig_ScheduledExecutionRecord_ErrorStatus)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataform_v1beta1_dataform_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   112,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dataform_v1beta1_dataform_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataform_v1beta1_dataform_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataform_v1beta1_dataform_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataform_v1beta1_dataform_proto_msgTypes,
	}.Build()
	File_google_cloud_dataform_v1beta1_dataform_proto = out.File
	file_google_cloud_dataform_v1beta1_dataform_proto_rawDesc = nil
	file_google_cloud_dataform_v1beta1_dataform_proto_goTypes = nil
	file_google_cloud_dataform_v1beta1_dataform_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataformClient is the client API for Dataform service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataformClient interface {
	// Lists Repositories in a given project and location.
	ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error)
	// Fetches a single Repository.
	GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Creates a new Repository in a given project and location.
	CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Updates a single Repository.
	UpdateRepository(ctx context.Context, in *UpdateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Deletes a single Repository.
	DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Applies a Git commit to a Repository. The Repository must not have a value
	// for `git_remote_settings.url`.
	CommitRepositoryChanges(ctx context.Context, in *CommitRepositoryChangesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns the contents of a file (inside a Repository). The Repository
	// must not have a value for `git_remote_settings.url`.
	ReadRepositoryFile(ctx context.Context, in *ReadRepositoryFileRequest, opts ...grpc.CallOption) (*ReadRepositoryFileResponse, error)
	// Returns the contents of a given Repository directory. The Repository must
	// not have a value for `git_remote_settings.url`.
	QueryRepositoryDirectoryContents(ctx context.Context, in *QueryRepositoryDirectoryContentsRequest, opts ...grpc.CallOption) (*QueryRepositoryDirectoryContentsResponse, error)
	// Fetches a Repository's history of commits.  The Repository must not have a
	// value for `git_remote_settings.url`.
	FetchRepositoryHistory(ctx context.Context, in *FetchRepositoryHistoryRequest, opts ...grpc.CallOption) (*FetchRepositoryHistoryResponse, error)
	// Computes a Repository's Git access token status.
	ComputeRepositoryAccessTokenStatus(ctx context.Context, in *ComputeRepositoryAccessTokenStatusRequest, opts ...grpc.CallOption) (*ComputeRepositoryAccessTokenStatusResponse, error)
	// Fetches a Repository's remote branches.
	FetchRemoteBranches(ctx context.Context, in *FetchRemoteBranchesRequest, opts ...grpc.CallOption) (*FetchRemoteBranchesResponse, error)
	// Lists Workspaces in a given Repository.
	ListWorkspaces(ctx context.Context, in *ListWorkspacesRequest, opts ...grpc.CallOption) (*ListWorkspacesResponse, error)
	// Fetches a single Workspace.
	GetWorkspace(ctx context.Context, in *GetWorkspaceRequest, opts ...grpc.CallOption) (*Workspace, error)
	// Creates a new Workspace in a given Repository.
	CreateWorkspace(ctx context.Context, in *CreateWorkspaceRequest, opts ...grpc.CallOption) (*Workspace, error)
	// Deletes a single Workspace.
	DeleteWorkspace(ctx context.Context, in *DeleteWorkspaceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Installs dependency NPM packages (inside a Workspace).
	InstallNpmPackages(ctx context.Context, in *InstallNpmPackagesRequest, opts ...grpc.CallOption) (*InstallNpmPackagesResponse, error)
	// Pulls Git commits from the Repository's remote into a Workspace.
	PullGitCommits(ctx context.Context, in *PullGitCommitsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Pushes Git commits from a Workspace to the Repository's remote.
	PushGitCommits(ctx context.Context, in *PushGitCommitsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Fetches Git statuses for the files in a Workspace.
	FetchFileGitStatuses(ctx context.Context, in *FetchFileGitStatusesRequest, opts ...grpc.CallOption) (*FetchFileGitStatusesResponse, error)
	// Fetches Git ahead/behind against a remote branch.
	FetchGitAheadBehind(ctx context.Context, in *FetchGitAheadBehindRequest, opts ...grpc.CallOption) (*FetchGitAheadBehindResponse, error)
	// Applies a Git commit for uncommitted files in a Workspace.
	CommitWorkspaceChanges(ctx context.Context, in *CommitWorkspaceChangesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Performs a Git reset for uncommitted files in a Workspace.
	ResetWorkspaceChanges(ctx context.Context, in *ResetWorkspaceChangesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Fetches Git diff for an uncommitted file in a Workspace.
	FetchFileDiff(ctx context.Context, in *FetchFileDiffRequest, opts ...grpc.CallOption) (*FetchFileDiffResponse, error)
	// Returns the contents of a given Workspace directory.
	QueryDirectoryContents(ctx context.Context, in *QueryDirectoryContentsRequest, opts ...grpc.CallOption) (*QueryDirectoryContentsResponse, error)
	// Creates a directory inside a Workspace.
	MakeDirectory(ctx context.Context, in *MakeDirectoryRequest, opts ...grpc.CallOption) (*MakeDirectoryResponse, error)
	// Deletes a directory (inside a Workspace) and all of its contents.
	RemoveDirectory(ctx context.Context, in *RemoveDirectoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Moves a directory (inside a Workspace), and all of its contents, to a new
	// location.
	MoveDirectory(ctx context.Context, in *MoveDirectoryRequest, opts ...grpc.CallOption) (*MoveDirectoryResponse, error)
	// Returns the contents of a file (inside a Workspace).
	ReadFile(ctx context.Context, in *ReadFileRequest, opts ...grpc.CallOption) (*ReadFileResponse, error)
	// Deletes a file (inside a Workspace).
	RemoveFile(ctx context.Context, in *RemoveFileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Moves a file (inside a Workspace) to a new location.
	MoveFile(ctx context.Context, in *MoveFileRequest, opts ...grpc.CallOption) (*MoveFileResponse, error)
	// Writes to a file (inside a Workspace).
	WriteFile(ctx context.Context, in *WriteFileRequest, opts ...grpc.CallOption) (*WriteFileResponse, error)
	// Lists ReleaseConfigs in a given Repository.
	ListReleaseConfigs(ctx context.Context, in *ListReleaseConfigsRequest, opts ...grpc.CallOption) (*ListReleaseConfigsResponse, error)
	// Fetches a single ReleaseConfig.
	GetReleaseConfig(ctx context.Context, in *GetReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error)
	// Creates a new ReleaseConfig in a given Repository.
	CreateReleaseConfig(ctx context.Context, in *CreateReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error)
	// Updates a single ReleaseConfig.
	UpdateReleaseConfig(ctx context.Context, in *UpdateReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error)
	// Deletes a single ReleaseConfig.
	DeleteReleaseConfig(ctx context.Context, in *DeleteReleaseConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists CompilationResults in a given Repository.
	ListCompilationResults(ctx context.Context, in *ListCompilationResultsRequest, opts ...grpc.CallOption) (*ListCompilationResultsResponse, error)
	// Fetches a single CompilationResult.
	GetCompilationResult(ctx context.Context, in *GetCompilationResultRequest, opts ...grpc.CallOption) (*CompilationResult, error)
	// Creates a new CompilationResult in a given project and location.
	CreateCompilationResult(ctx context.Context, in *CreateCompilationResultRequest, opts ...grpc.CallOption) (*CompilationResult, error)
	// Returns CompilationResultActions in a given CompilationResult.
	QueryCompilationResultActions(ctx context.Context, in *QueryCompilationResultActionsRequest, opts ...grpc.CallOption) (*QueryCompilationResultActionsResponse, error)
	// Lists WorkflowConfigs in a given Repository.
	ListWorkflowConfigs(ctx context.Context, in *ListWorkflowConfigsRequest, opts ...grpc.CallOption) (*ListWorkflowConfigsResponse, error)
	// Fetches a single WorkflowConfig.
	GetWorkflowConfig(ctx context.Context, in *GetWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error)
	// Creates a new WorkflowConfig in a given Repository.
	CreateWorkflowConfig(ctx context.Context, in *CreateWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error)
	// Updates a single WorkflowConfig.
	UpdateWorkflowConfig(ctx context.Context, in *UpdateWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error)
	// Deletes a single WorkflowConfig.
	DeleteWorkflowConfig(ctx context.Context, in *DeleteWorkflowConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists WorkflowInvocations in a given Repository.
	ListWorkflowInvocations(ctx context.Context, in *ListWorkflowInvocationsRequest, opts ...grpc.CallOption) (*ListWorkflowInvocationsResponse, error)
	// Fetches a single WorkflowInvocation.
	GetWorkflowInvocation(ctx context.Context, in *GetWorkflowInvocationRequest, opts ...grpc.CallOption) (*WorkflowInvocation, error)
	// Creates a new WorkflowInvocation in a given Repository.
	CreateWorkflowInvocation(ctx context.Context, in *CreateWorkflowInvocationRequest, opts ...grpc.CallOption) (*WorkflowInvocation, error)
	// Deletes a single WorkflowInvocation.
	DeleteWorkflowInvocation(ctx context.Context, in *DeleteWorkflowInvocationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Requests cancellation of a running WorkflowInvocation.
	CancelWorkflowInvocation(ctx context.Context, in *CancelWorkflowInvocationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns WorkflowInvocationActions in a given WorkflowInvocation.
	QueryWorkflowInvocationActions(ctx context.Context, in *QueryWorkflowInvocationActionsRequest, opts ...grpc.CallOption) (*QueryWorkflowInvocationActionsResponse, error)
}

type dataformClient struct {
	cc grpc.ClientConnInterface
}

func NewDataformClient(cc grpc.ClientConnInterface) DataformClient {
	return &dataformClient{cc}
}

func (c *dataformClient) ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error) {
	out := new(ListRepositoriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/ListRepositories", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/GetRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/CreateRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) UpdateRepository(ctx context.Context, in *UpdateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/UpdateRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/DeleteRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CommitRepositoryChanges(ctx context.Context, in *CommitRepositoryChangesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/CommitRepositoryChanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ReadRepositoryFile(ctx context.Context, in *ReadRepositoryFileRequest, opts ...grpc.CallOption) (*ReadRepositoryFileResponse, error) {
	out := new(ReadRepositoryFileResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/ReadRepositoryFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) QueryRepositoryDirectoryContents(ctx context.Context, in *QueryRepositoryDirectoryContentsRequest, opts ...grpc.CallOption) (*QueryRepositoryDirectoryContentsResponse, error) {
	out := new(QueryRepositoryDirectoryContentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/QueryRepositoryDirectoryContents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) FetchRepositoryHistory(ctx context.Context, in *FetchRepositoryHistoryRequest, opts ...grpc.CallOption) (*FetchRepositoryHistoryResponse, error) {
	out := new(FetchRepositoryHistoryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/FetchRepositoryHistory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ComputeRepositoryAccessTokenStatus(ctx context.Context, in *ComputeRepositoryAccessTokenStatusRequest, opts ...grpc.CallOption) (*ComputeRepositoryAccessTokenStatusResponse, error) {
	out := new(ComputeRepositoryAccessTokenStatusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/ComputeRepositoryAccessTokenStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) FetchRemoteBranches(ctx context.Context, in *FetchRemoteBranchesRequest, opts ...grpc.CallOption) (*FetchRemoteBranchesResponse, error) {
	out := new(FetchRemoteBranchesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/FetchRemoteBranches", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ListWorkspaces(ctx context.Context, in *ListWorkspacesRequest, opts ...grpc.CallOption) (*ListWorkspacesResponse, error) {
	out := new(ListWorkspacesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/ListWorkspaces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetWorkspace(ctx context.Context, in *GetWorkspaceRequest, opts ...grpc.CallOption) (*Workspace, error) {
	out := new(Workspace)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/GetWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateWorkspace(ctx context.Context, in *CreateWorkspaceRequest, opts ...grpc.CallOption) (*Workspace, error) {
	out := new(Workspace)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/CreateWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) DeleteWorkspace(ctx context.Context, in *DeleteWorkspaceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/DeleteWorkspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) InstallNpmPackages(ctx context.Context, in *InstallNpmPackagesRequest, opts ...grpc.CallOption) (*InstallNpmPackagesResponse, error) {
	out := new(InstallNpmPackagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/InstallNpmPackages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) PullGitCommits(ctx context.Context, in *PullGitCommitsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/PullGitCommits", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) PushGitCommits(ctx context.Context, in *PushGitCommitsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/PushGitCommits", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) FetchFileGitStatuses(ctx context.Context, in *FetchFileGitStatusesRequest, opts ...grpc.CallOption) (*FetchFileGitStatusesResponse, error) {
	out := new(FetchFileGitStatusesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/FetchFileGitStatuses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) FetchGitAheadBehind(ctx context.Context, in *FetchGitAheadBehindRequest, opts ...grpc.CallOption) (*FetchGitAheadBehindResponse, error) {
	out := new(FetchGitAheadBehindResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/FetchGitAheadBehind", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CommitWorkspaceChanges(ctx context.Context, in *CommitWorkspaceChangesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/CommitWorkspaceChanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ResetWorkspaceChanges(ctx context.Context, in *ResetWorkspaceChangesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/ResetWorkspaceChanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) FetchFileDiff(ctx context.Context, in *FetchFileDiffRequest, opts ...grpc.CallOption) (*FetchFileDiffResponse, error) {
	out := new(FetchFileDiffResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/FetchFileDiff", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) QueryDirectoryContents(ctx context.Context, in *QueryDirectoryContentsRequest, opts ...grpc.CallOption) (*QueryDirectoryContentsResponse, error) {
	out := new(QueryDirectoryContentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/QueryDirectoryContents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) MakeDirectory(ctx context.Context, in *MakeDirectoryRequest, opts ...grpc.CallOption) (*MakeDirectoryResponse, error) {
	out := new(MakeDirectoryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/MakeDirectory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) RemoveDirectory(ctx context.Context, in *RemoveDirectoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/RemoveDirectory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) MoveDirectory(ctx context.Context, in *MoveDirectoryRequest, opts ...grpc.CallOption) (*MoveDirectoryResponse, error) {
	out := new(MoveDirectoryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/MoveDirectory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ReadFile(ctx context.Context, in *ReadFileRequest, opts ...grpc.CallOption) (*ReadFileResponse, error) {
	out := new(ReadFileResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/ReadFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) RemoveFile(ctx context.Context, in *RemoveFileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/RemoveFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) MoveFile(ctx context.Context, in *MoveFileRequest, opts ...grpc.CallOption) (*MoveFileResponse, error) {
	out := new(MoveFileResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/MoveFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) WriteFile(ctx context.Context, in *WriteFileRequest, opts ...grpc.CallOption) (*WriteFileResponse, error) {
	out := new(WriteFileResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/WriteFile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ListReleaseConfigs(ctx context.Context, in *ListReleaseConfigsRequest, opts ...grpc.CallOption) (*ListReleaseConfigsResponse, error) {
	out := new(ListReleaseConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/ListReleaseConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetReleaseConfig(ctx context.Context, in *GetReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error) {
	out := new(ReleaseConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/GetReleaseConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateReleaseConfig(ctx context.Context, in *CreateReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error) {
	out := new(ReleaseConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/CreateReleaseConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) UpdateReleaseConfig(ctx context.Context, in *UpdateReleaseConfigRequest, opts ...grpc.CallOption) (*ReleaseConfig, error) {
	out := new(ReleaseConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/UpdateReleaseConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) DeleteReleaseConfig(ctx context.Context, in *DeleteReleaseConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/DeleteReleaseConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ListCompilationResults(ctx context.Context, in *ListCompilationResultsRequest, opts ...grpc.CallOption) (*ListCompilationResultsResponse, error) {
	out := new(ListCompilationResultsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/ListCompilationResults", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetCompilationResult(ctx context.Context, in *GetCompilationResultRequest, opts ...grpc.CallOption) (*CompilationResult, error) {
	out := new(CompilationResult)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/GetCompilationResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateCompilationResult(ctx context.Context, in *CreateCompilationResultRequest, opts ...grpc.CallOption) (*CompilationResult, error) {
	out := new(CompilationResult)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/CreateCompilationResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) QueryCompilationResultActions(ctx context.Context, in *QueryCompilationResultActionsRequest, opts ...grpc.CallOption) (*QueryCompilationResultActionsResponse, error) {
	out := new(QueryCompilationResultActionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/QueryCompilationResultActions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ListWorkflowConfigs(ctx context.Context, in *ListWorkflowConfigsRequest, opts ...grpc.CallOption) (*ListWorkflowConfigsResponse, error) {
	out := new(ListWorkflowConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/ListWorkflowConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetWorkflowConfig(ctx context.Context, in *GetWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error) {
	out := new(WorkflowConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/GetWorkflowConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateWorkflowConfig(ctx context.Context, in *CreateWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error) {
	out := new(WorkflowConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/CreateWorkflowConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) UpdateWorkflowConfig(ctx context.Context, in *UpdateWorkflowConfigRequest, opts ...grpc.CallOption) (*WorkflowConfig, error) {
	out := new(WorkflowConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/UpdateWorkflowConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) DeleteWorkflowConfig(ctx context.Context, in *DeleteWorkflowConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/DeleteWorkflowConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) ListWorkflowInvocations(ctx context.Context, in *ListWorkflowInvocationsRequest, opts ...grpc.CallOption) (*ListWorkflowInvocationsResponse, error) {
	out := new(ListWorkflowInvocationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/ListWorkflowInvocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) GetWorkflowInvocation(ctx context.Context, in *GetWorkflowInvocationRequest, opts ...grpc.CallOption) (*WorkflowInvocation, error) {
	out := new(WorkflowInvocation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/GetWorkflowInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CreateWorkflowInvocation(ctx context.Context, in *CreateWorkflowInvocationRequest, opts ...grpc.CallOption) (*WorkflowInvocation, error) {
	out := new(WorkflowInvocation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/CreateWorkflowInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) DeleteWorkflowInvocation(ctx context.Context, in *DeleteWorkflowInvocationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/DeleteWorkflowInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) CancelWorkflowInvocation(ctx context.Context, in *CancelWorkflowInvocationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/CancelWorkflowInvocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataformClient) QueryWorkflowInvocationActions(ctx context.Context, in *QueryWorkflowInvocationActionsRequest, opts ...grpc.CallOption) (*QueryWorkflowInvocationActionsResponse, error) {
	out := new(QueryWorkflowInvocationActionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataform.v1beta1.Dataform/QueryWorkflowInvocationActions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataformServer is the server API for Dataform service.
type DataformServer interface {
	// Lists Repositories in a given project and location.
	ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error)
	// Fetches a single Repository.
	GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error)
	// Creates a new Repository in a given project and location.
	CreateRepository(context.Context, *CreateRepositoryRequest) (*Repository, error)
	// Updates a single Repository.
	UpdateRepository(context.Context, *UpdateRepositoryRequest) (*Repository, error)
	// Deletes a single Repository.
	DeleteRepository(context.Context, *DeleteRepositoryRequest) (*emptypb.Empty, error)
	// Applies a Git commit to a Repository. The Repository must not have a value
	// for `git_remote_settings.url`.
	CommitRepositoryChanges(context.Context, *CommitRepositoryChangesRequest) (*emptypb.Empty, error)
	// Returns the contents of a file (inside a Repository). The Repository
	// must not have a value for `git_remote_settings.url`.
	ReadRepositoryFile(context.Context, *ReadRepositoryFileRequest) (*ReadRepositoryFileResponse, error)
	// Returns the contents of a given Repository directory. The Repository must
	// not have a value for `git_remote_settings.url`.
	QueryRepositoryDirectoryContents(context.Context, *QueryRepositoryDirectoryContentsRequest) (*QueryRepositoryDirectoryContentsResponse, error)
	// Fetches a Repository's history of commits.  The Repository must not have a
	// value for `git_remote_settings.url`.
	FetchRepositoryHistory(context.Context, *FetchRepositoryHistoryRequest) (*FetchRepositoryHistoryResponse, error)
	// Computes a Repository's Git access token status.
	ComputeRepositoryAccessTokenStatus(context.Context, *ComputeRepositoryAccessTokenStatusRequest) (*ComputeRepositoryAccessTokenStatusResponse, error)
	// Fetches a Repository's remote branches.
	FetchRemoteBranches(context.Context, *FetchRemoteBranchesRequest) (*FetchRemoteBranchesResponse, error)
	// Lists Workspaces in a given Repository.
	ListWorkspaces(context.Context, *ListWorkspacesRequest) (*ListWorkspacesResponse, error)
	// Fetches a single Workspace.
	GetWorkspace(context.Context, *GetWorkspaceRequest) (*Workspace, error)
	// Creates a new Workspace in a given Repository.
	CreateWorkspace(context.Context, *CreateWorkspaceRequest) (*Workspace, error)
	// Deletes a single Workspace.
	DeleteWorkspace(context.Context, *DeleteWorkspaceRequest) (*emptypb.Empty, error)
	// Installs dependency NPM packages (inside a Workspace).
	InstallNpmPackages(context.Context, *InstallNpmPackagesRequest) (*InstallNpmPackagesResponse, error)
	// Pulls Git commits from the Repository's remote into a Workspace.
	PullGitCommits(context.Context, *PullGitCommitsRequest) (*emptypb.Empty, error)
	// Pushes Git commits from a Workspace to the Repository's remote.
	PushGitCommits(context.Context, *PushGitCommitsRequest) (*emptypb.Empty, error)
	// Fetches Git statuses for the files in a Workspace.
	FetchFileGitStatuses(context.Context, *FetchFileGitStatusesRequest) (*FetchFileGitStatusesResponse, error)
	// Fetches Git ahead/behind against a remote branch.
	FetchGitAheadBehind(context.Context, *FetchGitAheadBehindRequest) (*FetchGitAheadBehindResponse, error)
	// Applies a Git commit for uncommitted files in a Workspace.
	CommitWorkspaceChanges(context.Context, *CommitWorkspaceChangesRequest) (*emptypb.Empty, error)
	// Performs a Git reset for uncommitted files in a Workspace.
	ResetWorkspaceChanges(context.Context, *ResetWorkspaceChangesRequest) (*emptypb.Empty, error)
	// Fetches Git diff for an uncommitted file in a Workspace.
	FetchFileDiff(context.Context, *FetchFileDiffRequest) (*FetchFileDiffResponse, error)
	// Returns the contents of a given Workspace directory.
	QueryDirectoryContents(context.Context, *QueryDirectoryContentsRequest) (*QueryDirectoryContentsResponse, error)
	// Creates a directory inside a Workspace.
	MakeDirectory(context.Context, *MakeDirectoryRequest) (*MakeDirectoryResponse, error)
	// Deletes a directory (inside a Workspace) and all of its contents.
	RemoveDirectory(context.Context, *RemoveDirectoryRequest) (*emptypb.Empty, error)
	// Moves a directory (inside a Workspace), and all of its contents, to a new
	// location.
	MoveDirectory(context.Context, *MoveDirectoryRequest) (*MoveDirectoryResponse, error)
	// Returns the contents of a file (inside a Workspace).
	ReadFile(context.Context, *ReadFileRequest) (*ReadFileResponse, error)
	// Deletes a file (inside a Workspace).
	RemoveFile(context.Context, *RemoveFileRequest) (*emptypb.Empty, error)
	// Moves a file (inside a Workspace) to a new location.
	MoveFile(context.Context, *MoveFileRequest) (*MoveFileResponse, error)
	// Writes to a file (inside a Workspace).
	WriteFile(context.Context, *WriteFileRequest) (*WriteFileResponse, error)
	// Lists ReleaseConfigs in a given Repository.
	ListReleaseConfigs(context.Context, *ListReleaseConfigsRequest) (*ListReleaseConfigsResponse, error)
	// Fetches a single ReleaseConfig.
	GetReleaseConfig(context.Context, *GetReleaseConfigRequest) (*ReleaseConfig, error)
	// Creates a new ReleaseConfig in a given Repository.
	CreateReleaseConfig(context.Context, *CreateReleaseConfigRequest) (*ReleaseConfig, error)
	// Updates a single ReleaseConfig.
	UpdateReleaseConfig(context.Context, *UpdateReleaseConfigRequest) (*ReleaseConfig, error)
	// Deletes a single ReleaseConfig.
	DeleteReleaseConfig(context.Context, *DeleteReleaseConfigRequest) (*emptypb.Empty, error)
	// Lists CompilationResults in a given Repository.
	ListCompilationResults(context.Context, *ListCompilationResultsRequest) (*ListCompilationResultsResponse, error)
	// Fetches a single CompilationResult.
	GetCompilationResult(context.Context, *GetCompilationResultRequest) (*CompilationResult, error)
	// Creates a new CompilationResult in a given project and location.
	CreateCompilationResult(context.Context, *CreateCompilationResultRequest) (*CompilationResult, error)
	// Returns CompilationResultActions in a given CompilationResult.
	QueryCompilationResultActions(context.Context, *QueryCompilationResultActionsRequest) (*QueryCompilationResultActionsResponse, error)
	// Lists WorkflowConfigs in a given Repository.
	ListWorkflowConfigs(context.Context, *ListWorkflowConfigsRequest) (*ListWorkflowConfigsResponse, error)
	// Fetches a single WorkflowConfig.
	GetWorkflowConfig(context.Context, *GetWorkflowConfigRequest) (*WorkflowConfig, error)
	// Creates a new WorkflowConfig in a given Repository.
	CreateWorkflowConfig(context.Context, *CreateWorkflowConfigRequest) (*WorkflowConfig, error)
	// Updates a single WorkflowConfig.
	UpdateWorkflowConfig(context.Context, *UpdateWorkflowConfigRequest) (*WorkflowConfig, error)
	// Deletes a single WorkflowConfig.
	DeleteWorkflowConfig(context.Context, *DeleteWorkflowConfigRequest) (*emptypb.Empty, error)
	// Lists WorkflowInvocations in a given Repository.
	ListWorkflowInvocations(context.Context, *ListWorkflowInvocationsRequest) (*ListWorkflowInvocationsResponse, error)
	// Fetches a single WorkflowInvocation.
	GetWorkflowInvocation(context.Context, *GetWorkflowInvocationRequest) (*WorkflowInvocation, error)
	// Creates a new WorkflowInvocation in a given Repository.
	CreateWorkflowInvocation(context.Context, *CreateWorkflowInvocationRequest) (*WorkflowInvocation, error)
	// Deletes a single WorkflowInvocation.
	DeleteWorkflowInvocation(context.Context, *DeleteWorkflowInvocationRequest) (*emptypb.Empty, error)
	// Requests cancellation of a running WorkflowInvocation.
	CancelWorkflowInvocation(context.Context, *CancelWorkflowInvocationRequest) (*emptypb.Empty, error)
	// Returns WorkflowInvocationActions in a given WorkflowInvocation.
	QueryWorkflowInvocationActions(context.Context, *QueryWorkflowInvocationActionsRequest) (*QueryWorkflowInvocationActionsResponse, error)
}

// UnimplementedDataformServer can be embedded to have forward compatible implementations.
type UnimplementedDataformServer struct {
}

func (*UnimplementedDataformServer) ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListRepositories not implemented")
}
func (*UnimplementedDataformServer) GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetRepository not implemented")
}
func (*UnimplementedDataformServer) CreateRepository(context.Context, *CreateRepositoryRequest) (*Repository, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateRepository not implemented")
}
func (*UnimplementedDataformServer) UpdateRepository(context.Context, *UpdateRepositoryRequest) (*Repository, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateRepository not implemented")
}
func (*UnimplementedDataformServer) DeleteRepository(context.Context, *DeleteRepositoryRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteRepository not implemented")
}
func (*UnimplementedDataformServer) CommitRepositoryChanges(context.Context, *CommitRepositoryChangesRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CommitRepositoryChanges not implemented")
}
func (*UnimplementedDataformServer) ReadRepositoryFile(context.Context, *ReadRepositoryFileRequest) (*ReadRepositoryFileResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ReadRepositoryFile not implemented")
}
func (*UnimplementedDataformServer) QueryRepositoryDirectoryContents(context.Context, *QueryRepositoryDirectoryContentsRequest) (*QueryRepositoryDirectoryContentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method QueryRepositoryDirectoryContents not implemented")
}
func (*UnimplementedDataformServer) FetchRepositoryHistory(context.Context, *FetchRepositoryHistoryRequest) (*FetchRepositoryHistoryResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FetchRepositoryHistory not implemented")
}
func (*UnimplementedDataformServer) ComputeRepositoryAccessTokenStatus(context.Context, *ComputeRepositoryAccessTokenStatusRequest) (*ComputeRepositoryAccessTokenStatusResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ComputeRepositoryAccessTokenStatus not implemented")
}
func (*UnimplementedDataformServer) FetchRemoteBranches(context.Context, *FetchRemoteBranchesRequest) (*FetchRemoteBranchesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FetchRemoteBranches not implemented")
}
func (*UnimplementedDataformServer) ListWorkspaces(context.Context, *ListWorkspacesRequest) (*ListWorkspacesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListWorkspaces not implemented")
}
func (*UnimplementedDataformServer) GetWorkspace(context.Context, *GetWorkspaceRequest) (*Workspace, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetWorkspace not implemented")
}
func (*UnimplementedDataformServer) CreateWorkspace(context.Context, *CreateWorkspaceRequest) (*Workspace, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateWorkspace not implemented")
}
func (*UnimplementedDataformServer) DeleteWorkspace(context.Context, *DeleteWorkspaceRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteWorkspace not implemented")
}
func (*UnimplementedDataformServer) InstallNpmPackages(context.Context, *InstallNpmPackagesRequest) (*InstallNpmPackagesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method InstallNpmPackages not implemented")
}
func (*UnimplementedDataformServer) PullGitCommits(context.Context, *PullGitCommitsRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PullGitCommits not implemented")
}
func (*UnimplementedDataformServer) PushGitCommits(context.Context, *PushGitCommitsRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method PushGitCommits not implemented")
}
func (*UnimplementedDataformServer) FetchFileGitStatuses(context.Context, *FetchFileGitStatusesRequest) (*FetchFileGitStatusesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FetchFileGitStatuses not implemented")
}
func (*UnimplementedDataformServer) FetchGitAheadBehind(context.Context, *FetchGitAheadBehindRequest) (*FetchGitAheadBehindResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FetchGitAheadBehind not implemented")
}
func (*UnimplementedDataformServer) CommitWorkspaceChanges(context.Context, *CommitWorkspaceChangesRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CommitWorkspaceChanges not implemented")
}
func (*UnimplementedDataformServer) ResetWorkspaceChanges(context.Context, *ResetWorkspaceChangesRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ResetWorkspaceChanges not implemented")
}
func (*UnimplementedDataformServer) FetchFileDiff(context.Context, *FetchFileDiffRequest) (*FetchFileDiffResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FetchFileDiff not implemented")
}
func (*UnimplementedDataformServer) QueryDirectoryContents(context.Context, *QueryDirectoryContentsRequest) (*QueryDirectoryContentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method QueryDirectoryContents not implemented")
}
func (*UnimplementedDataformServer) MakeDirectory(context.Context, *MakeDirectoryRequest) (*MakeDirectoryResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MakeDirectory not implemented")
}
func (*UnimplementedDataformServer) RemoveDirectory(context.Context, *RemoveDirectoryRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RemoveDirectory not implemented")
}
func (*UnimplementedDataformServer) MoveDirectory(context.Context, *MoveDirectoryRequest) (*MoveDirectoryResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MoveDirectory not implemented")
}
func (*UnimplementedDataformServer) ReadFile(context.Context, *ReadFileRequest) (*ReadFileResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ReadFile not implemented")
}
func (*UnimplementedDataformServer) RemoveFile(context.Context, *RemoveFileRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RemoveFile not implemented")
}
func (*UnimplementedDataformServer) MoveFile(context.Context, *MoveFileRequest) (*MoveFileResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MoveFile not implemented")
}
func (*UnimplementedDataformServer) WriteFile(context.Context, *WriteFileRequest) (*WriteFileResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method WriteFile not implemented")
}
func (*UnimplementedDataformServer) ListReleaseConfigs(context.Context, *ListReleaseConfigsRequest) (*ListReleaseConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListReleaseConfigs not implemented")
}
func (*UnimplementedDataformServer) GetReleaseConfig(context.Context, *GetReleaseConfigRequest) (*ReleaseConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetReleaseConfig not implemented")
}
func (*UnimplementedDataformServer) CreateReleaseConfig(context.Context, *CreateReleaseConfigRequest) (*ReleaseConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateReleaseConfig not implemented")
}
func (*UnimplementedDataformServer) UpdateReleaseConfig(context.Context, *UpdateReleaseConfigRequest) (*ReleaseConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateReleaseConfig not implemented")
}
func (*UnimplementedDataformServer) DeleteReleaseConfig(context.Context, *DeleteReleaseConfigRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteReleaseConfig not implemented")
}
func (*UnimplementedDataformServer) ListCompilationResults(context.Context, *ListCompilationResultsRequest) (*ListCompilationResultsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCompilationResults not implemented")
}
func (*UnimplementedDataformServer) GetCompilationResult(context.Context, *GetCompilationResultRequest) (*CompilationResult, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCompilationResult not implemented")
}
func (*UnimplementedDataformServer) CreateCompilationResult(context.Context, *CreateCompilationResultRequest) (*CompilationResult, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateCompilationResult not implemented")
}
func (*UnimplementedDataformServer) QueryCompilationResultActions(context.Context, *QueryCompilationResultActionsRequest) (*QueryCompilationResultActionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method QueryCompilationResultActions not implemented")
}
func (*UnimplementedDataformServer) ListWorkflowConfigs(context.Context, *ListWorkflowConfigsRequest) (*ListWorkflowConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListWorkflowConfigs not implemented")
}
func (*UnimplementedDataformServer) GetWorkflowConfig(context.Context, *GetWorkflowConfigRequest) (*WorkflowConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetWorkflowConfig not implemented")
}
func (*UnimplementedDataformServer) CreateWorkflowConfig(context.Context, *CreateWorkflowConfigRequest) (*WorkflowConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateWorkflowConfig not implemented")
}
func (*UnimplementedDataformServer) UpdateWorkflowConfig(context.Context, *UpdateWorkflowConfigRequest) (*WorkflowConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateWorkflowConfig not implemented")
}
func (*UnimplementedDataformServer) DeleteWorkflowConfig(context.Context, *DeleteWorkflowConfigRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteWorkflowConfig not implemented")
}
func (*UnimplementedDataformServer) ListWorkflowInvocations(context.Context, *ListWorkflowInvocationsRequest) (*ListWorkflowInvocationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListWorkflowInvocations not implemented")
}
func (*UnimplementedDataformServer) GetWorkflowInvocation(context.Context, *GetWorkflowInvocationRequest) (*WorkflowInvocation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetWorkflowInvocation not implemented")
}
func (*UnimplementedDataformServer) CreateWorkflowInvocation(context.Context, *CreateWorkflowInvocationRequest) (*WorkflowInvocation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateWorkflowInvocation not implemented")
}
func (*UnimplementedDataformServer) DeleteWorkflowInvocation(context.Context, *DeleteWorkflowInvocationRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteWorkflowInvocation not implemented")
}
func (*UnimplementedDataformServer) CancelWorkflowInvocation(context.Context, *CancelWorkflowInvocationRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CancelWorkflowInvocation not implemented")
}
func (*UnimplementedDataformServer) QueryWorkflowInvocationActions(context.Context, *QueryWorkflowInvocationActionsRequest) (*QueryWorkflowInvocationActionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method QueryWorkflowInvocationActions not implemented")
}

func RegisterDataformServer(s *grpc.Server, srv DataformServer) {
	s.RegisterService(&_Dataform_serviceDesc, srv)
}

func _Dataform_ListRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/ListRepositories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListRepositories(ctx, req.(*ListRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/GetRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetRepository(ctx, req.(*GetRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/CreateRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateRepository(ctx, req.(*CreateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_UpdateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).UpdateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/UpdateRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).UpdateRepository(ctx, req.(*UpdateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_DeleteRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).DeleteRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/DeleteRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).DeleteRepository(ctx, req.(*DeleteRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CommitRepositoryChanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRepositoryChangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CommitRepositoryChanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/CommitRepositoryChanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CommitRepositoryChanges(ctx, req.(*CommitRepositoryChangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ReadRepositoryFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadRepositoryFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ReadRepositoryFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/ReadRepositoryFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ReadRepositoryFile(ctx, req.(*ReadRepositoryFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_QueryRepositoryDirectoryContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryRepositoryDirectoryContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).QueryRepositoryDirectoryContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/QueryRepositoryDirectoryContents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).QueryRepositoryDirectoryContents(ctx, req.(*QueryRepositoryDirectoryContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_FetchRepositoryHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchRepositoryHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).FetchRepositoryHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/FetchRepositoryHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).FetchRepositoryHistory(ctx, req.(*FetchRepositoryHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ComputeRepositoryAccessTokenStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeRepositoryAccessTokenStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ComputeRepositoryAccessTokenStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/ComputeRepositoryAccessTokenStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ComputeRepositoryAccessTokenStatus(ctx, req.(*ComputeRepositoryAccessTokenStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_FetchRemoteBranches_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchRemoteBranchesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).FetchRemoteBranches(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/FetchRemoteBranches",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).FetchRemoteBranches(ctx, req.(*FetchRemoteBranchesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ListWorkspaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkspacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListWorkspaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/ListWorkspaces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListWorkspaces(ctx, req.(*ListWorkspacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/GetWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetWorkspace(ctx, req.(*GetWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/CreateWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateWorkspace(ctx, req.(*CreateWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_DeleteWorkspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).DeleteWorkspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/DeleteWorkspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).DeleteWorkspace(ctx, req.(*DeleteWorkspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_InstallNpmPackages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstallNpmPackagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).InstallNpmPackages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/InstallNpmPackages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).InstallNpmPackages(ctx, req.(*InstallNpmPackagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_PullGitCommits_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullGitCommitsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).PullGitCommits(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/PullGitCommits",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).PullGitCommits(ctx, req.(*PullGitCommitsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_PushGitCommits_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushGitCommitsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).PushGitCommits(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/PushGitCommits",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).PushGitCommits(ctx, req.(*PushGitCommitsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_FetchFileGitStatuses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchFileGitStatusesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).FetchFileGitStatuses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/FetchFileGitStatuses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).FetchFileGitStatuses(ctx, req.(*FetchFileGitStatusesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_FetchGitAheadBehind_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchGitAheadBehindRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).FetchGitAheadBehind(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/FetchGitAheadBehind",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).FetchGitAheadBehind(ctx, req.(*FetchGitAheadBehindRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CommitWorkspaceChanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitWorkspaceChangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CommitWorkspaceChanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/CommitWorkspaceChanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CommitWorkspaceChanges(ctx, req.(*CommitWorkspaceChangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ResetWorkspaceChanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetWorkspaceChangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ResetWorkspaceChanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/ResetWorkspaceChanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ResetWorkspaceChanges(ctx, req.(*ResetWorkspaceChangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_FetchFileDiff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchFileDiffRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).FetchFileDiff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/FetchFileDiff",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).FetchFileDiff(ctx, req.(*FetchFileDiffRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_QueryDirectoryContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryDirectoryContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).QueryDirectoryContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/QueryDirectoryContents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).QueryDirectoryContents(ctx, req.(*QueryDirectoryContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_MakeDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MakeDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).MakeDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/MakeDirectory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).MakeDirectory(ctx, req.(*MakeDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_RemoveDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).RemoveDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/RemoveDirectory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).RemoveDirectory(ctx, req.(*RemoveDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_MoveDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).MoveDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/MoveDirectory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).MoveDirectory(ctx, req.(*MoveDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ReadFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ReadFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/ReadFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ReadFile(ctx, req.(*ReadFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_RemoveFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).RemoveFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/RemoveFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).RemoveFile(ctx, req.(*RemoveFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_MoveFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).MoveFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/MoveFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).MoveFile(ctx, req.(*MoveFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_WriteFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).WriteFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/WriteFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).WriteFile(ctx, req.(*WriteFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ListReleaseConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReleaseConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListReleaseConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/ListReleaseConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListReleaseConfigs(ctx, req.(*ListReleaseConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetReleaseConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReleaseConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetReleaseConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/GetReleaseConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetReleaseConfig(ctx, req.(*GetReleaseConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateReleaseConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReleaseConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateReleaseConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/CreateReleaseConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateReleaseConfig(ctx, req.(*CreateReleaseConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_UpdateReleaseConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReleaseConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).UpdateReleaseConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/UpdateReleaseConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).UpdateReleaseConfig(ctx, req.(*UpdateReleaseConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_DeleteReleaseConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReleaseConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).DeleteReleaseConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/DeleteReleaseConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).DeleteReleaseConfig(ctx, req.(*DeleteReleaseConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ListCompilationResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCompilationResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListCompilationResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/ListCompilationResults",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListCompilationResults(ctx, req.(*ListCompilationResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetCompilationResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCompilationResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetCompilationResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/GetCompilationResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetCompilationResult(ctx, req.(*GetCompilationResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateCompilationResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCompilationResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateCompilationResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/CreateCompilationResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateCompilationResult(ctx, req.(*CreateCompilationResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_QueryCompilationResultActions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryCompilationResultActionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).QueryCompilationResultActions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/QueryCompilationResultActions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).QueryCompilationResultActions(ctx, req.(*QueryCompilationResultActionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ListWorkflowConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkflowConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListWorkflowConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/ListWorkflowConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListWorkflowConfigs(ctx, req.(*ListWorkflowConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetWorkflowConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetWorkflowConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/GetWorkflowConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetWorkflowConfig(ctx, req.(*GetWorkflowConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateWorkflowConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkflowConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateWorkflowConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/CreateWorkflowConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateWorkflowConfig(ctx, req.(*CreateWorkflowConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_UpdateWorkflowConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkflowConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).UpdateWorkflowConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/UpdateWorkflowConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).UpdateWorkflowConfig(ctx, req.(*UpdateWorkflowConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_DeleteWorkflowConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkflowConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).DeleteWorkflowConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/DeleteWorkflowConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).DeleteWorkflowConfig(ctx, req.(*DeleteWorkflowConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_ListWorkflowInvocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkflowInvocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).ListWorkflowInvocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/ListWorkflowInvocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).ListWorkflowInvocations(ctx, req.(*ListWorkflowInvocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_GetWorkflowInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).GetWorkflowInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/GetWorkflowInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).GetWorkflowInvocation(ctx, req.(*GetWorkflowInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CreateWorkflowInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkflowInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CreateWorkflowInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/CreateWorkflowInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CreateWorkflowInvocation(ctx, req.(*CreateWorkflowInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_DeleteWorkflowInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkflowInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).DeleteWorkflowInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/DeleteWorkflowInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).DeleteWorkflowInvocation(ctx, req.(*DeleteWorkflowInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_CancelWorkflowInvocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelWorkflowInvocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).CancelWorkflowInvocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/CancelWorkflowInvocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).CancelWorkflowInvocation(ctx, req.(*CancelWorkflowInvocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dataform_QueryWorkflowInvocationActions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWorkflowInvocationActionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataformServer).QueryWorkflowInvocationActions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataform.v1beta1.Dataform/QueryWorkflowInvocationActions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataformServer).QueryWorkflowInvocationActions(ctx, req.(*QueryWorkflowInvocationActionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Dataform_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataform.v1beta1.Dataform",
	HandlerType: (*DataformServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRepositories",
			Handler:    _Dataform_ListRepositories_Handler,
		},
		{
			MethodName: "GetRepository",
			Handler:    _Dataform_GetRepository_Handler,
		},
		{
			MethodName: "CreateRepository",
			Handler:    _Dataform_CreateRepository_Handler,
		},
		{
			MethodName: "UpdateRepository",
			Handler:    _Dataform_UpdateRepository_Handler,
		},
		{
			MethodName: "DeleteRepository",
			Handler:    _Dataform_DeleteRepository_Handler,
		},
		{
			MethodName: "CommitRepositoryChanges",
			Handler:    _Dataform_CommitRepositoryChanges_Handler,
		},
		{
			MethodName: "ReadRepositoryFile",
			Handler:    _Dataform_ReadRepositoryFile_Handler,
		},
		{
			MethodName: "QueryRepositoryDirectoryContents",
			Handler:    _Dataform_QueryRepositoryDirectoryContents_Handler,
		},
		{
			MethodName: "FetchRepositoryHistory",
			Handler:    _Dataform_FetchRepositoryHistory_Handler,
		},
		{
			MethodName: "ComputeRepositoryAccessTokenStatus",
			Handler:    _Dataform_ComputeRepositoryAccessTokenStatus_Handler,
		},
		{
			MethodName: "FetchRemoteBranches",
			Handler:    _Dataform_FetchRemoteBranches_Handler,
		},
		{
			MethodName: "ListWorkspaces",
			Handler:    _Dataform_ListWorkspaces_Handler,
		},
		{
			MethodName: "GetWorkspace",
			Handler:    _Dataform_GetWorkspace_Handler,
		},
		{
			MethodName: "CreateWorkspace",
			Handler:    _Dataform_CreateWorkspace_Handler,
		},
		{
			MethodName: "DeleteWorkspace",
			Handler:    _Dataform_DeleteWorkspace_Handler,
		},
		{
			MethodName: "InstallNpmPackages",
			Handler:    _Dataform_InstallNpmPackages_Handler,
		},
		{
			MethodName: "PullGitCommits",
			Handler:    _Dataform_PullGitCommits_Handler,
		},
		{
			MethodName: "PushGitCommits",
			Handler:    _Dataform_PushGitCommits_Handler,
		},
		{
			MethodName: "FetchFileGitStatuses",
			Handler:    _Dataform_FetchFileGitStatuses_Handler,
		},
		{
			MethodName: "FetchGitAheadBehind",
			Handler:    _Dataform_FetchGitAheadBehind_Handler,
		},
		{
			MethodName: "CommitWorkspaceChanges",
			Handler:    _Dataform_CommitWorkspaceChanges_Handler,
		},
		{
			MethodName: "ResetWorkspaceChanges",
			Handler:    _Dataform_ResetWorkspaceChanges_Handler,
		},
		{
			MethodName: "FetchFileDiff",
			Handler:    _Dataform_FetchFileDiff_Handler,
		},
		{
			MethodName: "QueryDirectoryContents",
			Handler:    _Dataform_QueryDirectoryContents_Handler,
		},
		{
			MethodName: "MakeDirectory",
			Handler:    _Dataform_MakeDirectory_Handler,
		},
		{
			MethodName: "RemoveDirectory",
			Handler:    _Dataform_RemoveDirectory_Handler,
		},
		{
			MethodName: "MoveDirectory",
			Handler:    _Dataform_MoveDirectory_Handler,
		},
		{
			MethodName: "ReadFile",
			Handler:    _Dataform_ReadFile_Handler,
		},
		{
			MethodName: "RemoveFile",
			Handler:    _Dataform_RemoveFile_Handler,
		},
		{
			MethodName: "MoveFile",
			Handler:    _Dataform_MoveFile_Handler,
		},
		{
			MethodName: "WriteFile",
			Handler:    _Dataform_WriteFile_Handler,
		},
		{
			MethodName: "ListReleaseConfigs",
			Handler:    _Dataform_ListReleaseConfigs_Handler,
		},
		{
			MethodName: "GetReleaseConfig",
			Handler:    _Dataform_GetReleaseConfig_Handler,
		},
		{
			MethodName: "CreateReleaseConfig",
			Handler:    _Dataform_CreateReleaseConfig_Handler,
		},
		{
			MethodName: "UpdateReleaseConfig",
			Handler:    _Dataform_UpdateReleaseConfig_Handler,
		},
		{
			MethodName: "DeleteReleaseConfig",
			Handler:    _Dataform_DeleteReleaseConfig_Handler,
		},
		{
			MethodName: "ListCompilationResults",
			Handler:    _Dataform_ListCompilationResults_Handler,
		},
		{
			MethodName: "GetCompilationResult",
			Handler:    _Dataform_GetCompilationResult_Handler,
		},
		{
			MethodName: "CreateCompilationResult",
			Handler:    _Dataform_CreateCompilationResult_Handler,
		},
		{
			MethodName: "QueryCompilationResultActions",
			Handler:    _Dataform_QueryCompilationResultActions_Handler,
		},
		{
			MethodName: "ListWorkflowConfigs",
			Handler:    _Dataform_ListWorkflowConfigs_Handler,
		},
		{
			MethodName: "GetWorkflowConfig",
			Handler:    _Dataform_GetWorkflowConfig_Handler,
		},
		{
			MethodName: "CreateWorkflowConfig",
			Handler:    _Dataform_CreateWorkflowConfig_Handler,
		},
		{
			MethodName: "UpdateWorkflowConfig",
			Handler:    _Dataform_UpdateWorkflowConfig_Handler,
		},
		{
			MethodName: "DeleteWorkflowConfig",
			Handler:    _Dataform_DeleteWorkflowConfig_Handler,
		},
		{
			MethodName: "ListWorkflowInvocations",
			Handler:    _Dataform_ListWorkflowInvocations_Handler,
		},
		{
			MethodName: "GetWorkflowInvocation",
			Handler:    _Dataform_GetWorkflowInvocation_Handler,
		},
		{
			MethodName: "CreateWorkflowInvocation",
			Handler:    _Dataform_CreateWorkflowInvocation_Handler,
		},
		{
			MethodName: "DeleteWorkflowInvocation",
			Handler:    _Dataform_DeleteWorkflowInvocation_Handler,
		},
		{
			MethodName: "CancelWorkflowInvocation",
			Handler:    _Dataform_CancelWorkflowInvocation_Handler,
		},
		{
			MethodName: "QueryWorkflowInvocationActions",
			Handler:    _Dataform_QueryWorkflowInvocationActions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataform/v1beta1/dataform.proto",
}
