// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/container/v1/cluster_service.proto

package containerpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	code "google.golang.org/genproto/googleapis/rpc/code"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// PrivateIPv6GoogleAccess controls whether and how the pods can communicate
// with Google Services through gRPC over IPv6.
type PrivateIPv6GoogleAccess int32

const (
	// Default value. Same as DISABLED
	PrivateIPv6GoogleAccess_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED PrivateIPv6GoogleAccess = 0
	// No private access to or from Google Services
	PrivateIPv6GoogleAccess_PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED PrivateIPv6GoogleAccess = 1
	// Enables private IPv6 access to Google Services from GKE
	PrivateIPv6GoogleAccess_PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE PrivateIPv6GoogleAccess = 2
	// Enables private IPv6 access to and from Google Services
	PrivateIPv6GoogleAccess_PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL PrivateIPv6GoogleAccess = 3
)

// Enum value maps for PrivateIPv6GoogleAccess.
var (
	PrivateIPv6GoogleAccess_name = map[int32]string{
		0: "PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED",
		1: "PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED",
		2: "PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE",
		3: "PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL",
	}
	PrivateIPv6GoogleAccess_value = map[string]int32{
		"PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED":   0,
		"PRIVATE_IPV6_GOOGLE_ACCESS_DISABLED":      1,
		"PRIVATE_IPV6_GOOGLE_ACCESS_TO_GOOGLE":     2,
		"PRIVATE_IPV6_GOOGLE_ACCESS_BIDIRECTIONAL": 3,
	}
)

func (x PrivateIPv6GoogleAccess) Enum() *PrivateIPv6GoogleAccess {
	p := new(PrivateIPv6GoogleAccess)
	*p = x
	return p
}

func (x PrivateIPv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateIPv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[0].Descriptor()
}

func (PrivateIPv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[0]
}

func (x PrivateIPv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateIPv6GoogleAccess.Descriptor instead.
func (PrivateIPv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{0}
}

// UpgradeResourceType is the resource type that is upgrading. It is used
// in upgrade notifications.
type UpgradeResourceType int32

const (
	// Default value. This shouldn't be used.
	UpgradeResourceType_UPGRADE_RESOURCE_TYPE_UNSPECIFIED UpgradeResourceType = 0
	// Master / control plane
	UpgradeResourceType_MASTER UpgradeResourceType = 1
	// Node pool
	UpgradeResourceType_NODE_POOL UpgradeResourceType = 2
)

// Enum value maps for UpgradeResourceType.
var (
	UpgradeResourceType_name = map[int32]string{
		0: "UPGRADE_RESOURCE_TYPE_UNSPECIFIED",
		1: "MASTER",
		2: "NODE_POOL",
	}
	UpgradeResourceType_value = map[string]int32{
		"UPGRADE_RESOURCE_TYPE_UNSPECIFIED": 0,
		"MASTER":                            1,
		"NODE_POOL":                         2,
	}
)

func (x UpgradeResourceType) Enum() *UpgradeResourceType {
	p := new(UpgradeResourceType)
	*p = x
	return p
}

func (x UpgradeResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpgradeResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[1].Descriptor()
}

func (UpgradeResourceType) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[1]
}

func (x UpgradeResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpgradeResourceType.Descriptor instead.
func (UpgradeResourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{1}
}

// The datapath provider selects the implementation of the Kubernetes networking
// model for service resolution and network policy enforcement.
type DatapathProvider int32

const (
	// Default value.
	DatapathProvider_DATAPATH_PROVIDER_UNSPECIFIED DatapathProvider = 0
	// Use the IPTables implementation based on kube-proxy.
	DatapathProvider_LEGACY_DATAPATH DatapathProvider = 1
	// Use the eBPF based GKE Dataplane V2 with additional features. See the [GKE
	// Dataplane V2
	// documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/dataplane-v2)
	// for more.
	DatapathProvider_ADVANCED_DATAPATH DatapathProvider = 2
)

// Enum value maps for DatapathProvider.
var (
	DatapathProvider_name = map[int32]string{
		0: "DATAPATH_PROVIDER_UNSPECIFIED",
		1: "LEGACY_DATAPATH",
		2: "ADVANCED_DATAPATH",
	}
	DatapathProvider_value = map[string]int32{
		"DATAPATH_PROVIDER_UNSPECIFIED": 0,
		"LEGACY_DATAPATH":               1,
		"ADVANCED_DATAPATH":             2,
	}
)

func (x DatapathProvider) Enum() *DatapathProvider {
	p := new(DatapathProvider)
	*p = x
	return p
}

func (x DatapathProvider) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatapathProvider) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[2].Descriptor()
}

func (DatapathProvider) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[2]
}

func (x DatapathProvider) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatapathProvider.Descriptor instead.
func (DatapathProvider) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{2}
}

// Strategy used for node pool update.
type NodePoolUpdateStrategy int32

const (
	// Default value if unset. GKE internally defaults the update strategy to
	// SURGE for unspecified strategies.
	NodePoolUpdateStrategy_NODE_POOL_UPDATE_STRATEGY_UNSPECIFIED NodePoolUpdateStrategy = 0
	// blue-green upgrade.
	NodePoolUpdateStrategy_BLUE_GREEN NodePoolUpdateStrategy = 2
	// SURGE is the traditional way of upgrade a node pool.
	// max_surge and max_unavailable determines the level of upgrade parallelism.
	NodePoolUpdateStrategy_SURGE NodePoolUpdateStrategy = 3
)

// Enum value maps for NodePoolUpdateStrategy.
var (
	NodePoolUpdateStrategy_name = map[int32]string{
		0: "NODE_POOL_UPDATE_STRATEGY_UNSPECIFIED",
		2: "BLUE_GREEN",
		3: "SURGE",
	}
	NodePoolUpdateStrategy_value = map[string]int32{
		"NODE_POOL_UPDATE_STRATEGY_UNSPECIFIED": 0,
		"BLUE_GREEN":                            2,
		"SURGE":                                 3,
	}
)

func (x NodePoolUpdateStrategy) Enum() *NodePoolUpdateStrategy {
	p := new(NodePoolUpdateStrategy)
	*p = x
	return p
}

func (x NodePoolUpdateStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodePoolUpdateStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[3].Descriptor()
}

func (NodePoolUpdateStrategy) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[3]
}

func (x NodePoolUpdateStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodePoolUpdateStrategy.Descriptor instead.
func (NodePoolUpdateStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{3}
}

// Possible values for IP stack type
type StackType int32

const (
	// Default value, will be defaulted as IPV4 only
	StackType_STACK_TYPE_UNSPECIFIED StackType = 0
	// Cluster is IPV4 only
	StackType_IPV4 StackType = 1
	// Cluster can use both IPv4 and IPv6
	StackType_IPV4_IPV6 StackType = 2
)

// Enum value maps for StackType.
var (
	StackType_name = map[int32]string{
		0: "STACK_TYPE_UNSPECIFIED",
		1: "IPV4",
		2: "IPV4_IPV6",
	}
	StackType_value = map[string]int32{
		"STACK_TYPE_UNSPECIFIED": 0,
		"IPV4":                   1,
		"IPV4_IPV6":              2,
	}
)

func (x StackType) Enum() *StackType {
	p := new(StackType)
	*p = x
	return p
}

func (x StackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[4].Descriptor()
}

func (StackType) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[4]
}

func (x StackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StackType.Descriptor instead.
func (StackType) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{4}
}

// Possible values for IPv6 access type
type IPv6AccessType int32

const (
	// Default value, will be defaulted as type external.
	IPv6AccessType_IPV6_ACCESS_TYPE_UNSPECIFIED IPv6AccessType = 0
	// Access type internal (all v6 addresses are internal IPs)
	IPv6AccessType_INTERNAL IPv6AccessType = 1
	// Access type external (all v6 addresses are external IPs)
	IPv6AccessType_EXTERNAL IPv6AccessType = 2
)

// Enum value maps for IPv6AccessType.
var (
	IPv6AccessType_name = map[int32]string{
		0: "IPV6_ACCESS_TYPE_UNSPECIFIED",
		1: "INTERNAL",
		2: "EXTERNAL",
	}
	IPv6AccessType_value = map[string]int32{
		"IPV6_ACCESS_TYPE_UNSPECIFIED": 0,
		"INTERNAL":                     1,
		"EXTERNAL":                     2,
	}
)

func (x IPv6AccessType) Enum() *IPv6AccessType {
	p := new(IPv6AccessType)
	*p = x
	return p
}

func (x IPv6AccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IPv6AccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[5].Descriptor()
}

func (IPv6AccessType) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[5]
}

func (x IPv6AccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IPv6AccessType.Descriptor instead.
func (IPv6AccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{5}
}

// Options for in-transit encryption.
type InTransitEncryptionConfig int32

const (
	// Unspecified, will be inferred as default -
	// IN_TRANSIT_ENCRYPTION_UNSPECIFIED.
	InTransitEncryptionConfig_IN_TRANSIT_ENCRYPTION_CONFIG_UNSPECIFIED InTransitEncryptionConfig = 0
	// In-transit encryption is disabled.
	InTransitEncryptionConfig_IN_TRANSIT_ENCRYPTION_DISABLED InTransitEncryptionConfig = 1
	// Data in-transit is encrypted using inter-node transparent encryption.
	InTransitEncryptionConfig_IN_TRANSIT_ENCRYPTION_INTER_NODE_TRANSPARENT InTransitEncryptionConfig = 2
)

// Enum value maps for InTransitEncryptionConfig.
var (
	InTransitEncryptionConfig_name = map[int32]string{
		0: "IN_TRANSIT_ENCRYPTION_CONFIG_UNSPECIFIED",
		1: "IN_TRANSIT_ENCRYPTION_DISABLED",
		2: "IN_TRANSIT_ENCRYPTION_INTER_NODE_TRANSPARENT",
	}
	InTransitEncryptionConfig_value = map[string]int32{
		"IN_TRANSIT_ENCRYPTION_CONFIG_UNSPECIFIED":     0,
		"IN_TRANSIT_ENCRYPTION_DISABLED":               1,
		"IN_TRANSIT_ENCRYPTION_INTER_NODE_TRANSPARENT": 2,
	}
)

func (x InTransitEncryptionConfig) Enum() *InTransitEncryptionConfig {
	p := new(InTransitEncryptionConfig)
	*p = x
	return p
}

func (x InTransitEncryptionConfig) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InTransitEncryptionConfig) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[6].Descriptor()
}

func (InTransitEncryptionConfig) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[6]
}

func (x InTransitEncryptionConfig) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InTransitEncryptionConfig.Descriptor instead.
func (InTransitEncryptionConfig) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{6}
}

// Possible cgroup modes that can be used.
type LinuxNodeConfig_CgroupMode int32

const (
	// CGROUP_MODE_UNSPECIFIED is when unspecified cgroup configuration is used.
	// The default for the GKE node OS image will be used.
	LinuxNodeConfig_CGROUP_MODE_UNSPECIFIED LinuxNodeConfig_CgroupMode = 0
	// CGROUP_MODE_V1 specifies to use cgroupv1 for the cgroup configuration on
	// the node image.
	LinuxNodeConfig_CGROUP_MODE_V1 LinuxNodeConfig_CgroupMode = 1
	// CGROUP_MODE_V2 specifies to use cgroupv2 for the cgroup configuration on
	// the node image.
	LinuxNodeConfig_CGROUP_MODE_V2 LinuxNodeConfig_CgroupMode = 2
)

// Enum value maps for LinuxNodeConfig_CgroupMode.
var (
	LinuxNodeConfig_CgroupMode_name = map[int32]string{
		0: "CGROUP_MODE_UNSPECIFIED",
		1: "CGROUP_MODE_V1",
		2: "CGROUP_MODE_V2",
	}
	LinuxNodeConfig_CgroupMode_value = map[string]int32{
		"CGROUP_MODE_UNSPECIFIED": 0,
		"CGROUP_MODE_V1":          1,
		"CGROUP_MODE_V2":          2,
	}
)

func (x LinuxNodeConfig_CgroupMode) Enum() *LinuxNodeConfig_CgroupMode {
	p := new(LinuxNodeConfig_CgroupMode)
	*p = x
	return p
}

func (x LinuxNodeConfig_CgroupMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LinuxNodeConfig_CgroupMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[7].Descriptor()
}

func (LinuxNodeConfig_CgroupMode) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[7]
}

func (x LinuxNodeConfig_CgroupMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LinuxNodeConfig_CgroupMode.Descriptor instead.
func (LinuxNodeConfig_CgroupMode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{0, 0}
}

// Possible OS version that can be used.
type WindowsNodeConfig_OSVersion int32

const (
	// When OSVersion is not specified
	WindowsNodeConfig_OS_VERSION_UNSPECIFIED WindowsNodeConfig_OSVersion = 0
	// LTSC2019 specifies to use LTSC2019 as the Windows Servercore Base Image
	WindowsNodeConfig_OS_VERSION_LTSC2019 WindowsNodeConfig_OSVersion = 1
	// LTSC2022 specifies to use LTSC2022 as the Windows Servercore Base Image
	WindowsNodeConfig_OS_VERSION_LTSC2022 WindowsNodeConfig_OSVersion = 2
)

// Enum value maps for WindowsNodeConfig_OSVersion.
var (
	WindowsNodeConfig_OSVersion_name = map[int32]string{
		0: "OS_VERSION_UNSPECIFIED",
		1: "OS_VERSION_LTSC2019",
		2: "OS_VERSION_LTSC2022",
	}
	WindowsNodeConfig_OSVersion_value = map[string]int32{
		"OS_VERSION_UNSPECIFIED": 0,
		"OS_VERSION_LTSC2019":    1,
		"OS_VERSION_LTSC2022":    2,
	}
)

func (x WindowsNodeConfig_OSVersion) Enum() *WindowsNodeConfig_OSVersion {
	p := new(WindowsNodeConfig_OSVersion)
	*p = x
	return p
}

func (x WindowsNodeConfig_OSVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WindowsNodeConfig_OSVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[8].Descriptor()
}

func (WindowsNodeConfig_OSVersion) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[8]
}

func (x WindowsNodeConfig_OSVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WindowsNodeConfig_OSVersion.Descriptor instead.
func (WindowsNodeConfig_OSVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{1, 0}
}

// LocalSsdEncryptionMode specifies the method used for encrypting the Local
// SSDs attached to the node.
type NodeConfig_LocalSsdEncryptionMode int32

const (
	// The given node will be encrypted using keys managed by Google
	// infrastructure and the keys will be deleted when the node is
	// deleted.
	NodeConfig_LOCAL_SSD_ENCRYPTION_MODE_UNSPECIFIED NodeConfig_LocalSsdEncryptionMode = 0
	// The given node will be encrypted using keys managed by Google
	// infrastructure and the keys will be deleted when the node is
	// deleted.
	NodeConfig_STANDARD_ENCRYPTION NodeConfig_LocalSsdEncryptionMode = 1
	// The given node will opt-in for using ephemeral key for
	// encryption of Local SSDs.
	// The Local SSDs will not be able to recover data in case of node
	// crash.
	NodeConfig_EPHEMERAL_KEY_ENCRYPTION NodeConfig_LocalSsdEncryptionMode = 2
)

// Enum value maps for NodeConfig_LocalSsdEncryptionMode.
var (
	NodeConfig_LocalSsdEncryptionMode_name = map[int32]string{
		0: "LOCAL_SSD_ENCRYPTION_MODE_UNSPECIFIED",
		1: "STANDARD_ENCRYPTION",
		2: "EPHEMERAL_KEY_ENCRYPTION",
	}
	NodeConfig_LocalSsdEncryptionMode_value = map[string]int32{
		"LOCAL_SSD_ENCRYPTION_MODE_UNSPECIFIED": 0,
		"STANDARD_ENCRYPTION":                   1,
		"EPHEMERAL_KEY_ENCRYPTION":              2,
	}
)

func (x NodeConfig_LocalSsdEncryptionMode) Enum() *NodeConfig_LocalSsdEncryptionMode {
	p := new(NodeConfig_LocalSsdEncryptionMode)
	*p = x
	return p
}

func (x NodeConfig_LocalSsdEncryptionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeConfig_LocalSsdEncryptionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[9].Descriptor()
}

func (NodeConfig_LocalSsdEncryptionMode) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[9]
}

func (x NodeConfig_LocalSsdEncryptionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeConfig_LocalSsdEncryptionMode.Descriptor instead.
func (NodeConfig_LocalSsdEncryptionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{3, 0}
}

// Possible effective cgroup modes for the node.
type NodeConfig_EffectiveCgroupMode int32

const (
	// EFFECTIVE_CGROUP_MODE_UNSPECIFIED means the cgroup configuration for the
	// node pool is unspecified, i.e. the node pool is a Windows node pool.
	NodeConfig_EFFECTIVE_CGROUP_MODE_UNSPECIFIED NodeConfig_EffectiveCgroupMode = 0
	// CGROUP_MODE_V1 means the node pool is configured to use cgroupv1 for the
	// cgroup configuration.
	NodeConfig_EFFECTIVE_CGROUP_MODE_V1 NodeConfig_EffectiveCgroupMode = 1
	// CGROUP_MODE_V2 means the node pool is configured to use cgroupv2 for the
	// cgroup configuration.
	NodeConfig_EFFECTIVE_CGROUP_MODE_V2 NodeConfig_EffectiveCgroupMode = 2
)

// Enum value maps for NodeConfig_EffectiveCgroupMode.
var (
	NodeConfig_EffectiveCgroupMode_name = map[int32]string{
		0: "EFFECTIVE_CGROUP_MODE_UNSPECIFIED",
		1: "EFFECTIVE_CGROUP_MODE_V1",
		2: "EFFECTIVE_CGROUP_MODE_V2",
	}
	NodeConfig_EffectiveCgroupMode_value = map[string]int32{
		"EFFECTIVE_CGROUP_MODE_UNSPECIFIED": 0,
		"EFFECTIVE_CGROUP_MODE_V1":          1,
		"EFFECTIVE_CGROUP_MODE_V2":          2,
	}
)

func (x NodeConfig_EffectiveCgroupMode) Enum() *NodeConfig_EffectiveCgroupMode {
	p := new(NodeConfig_EffectiveCgroupMode)
	*p = x
	return p
}

func (x NodeConfig_EffectiveCgroupMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeConfig_EffectiveCgroupMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[10].Descriptor()
}

func (NodeConfig_EffectiveCgroupMode) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[10]
}

func (x NodeConfig_EffectiveCgroupMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeConfig_EffectiveCgroupMode.Descriptor instead.
func (NodeConfig_EffectiveCgroupMode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{3, 1}
}

// Node network tier
type NodeNetworkConfig_NetworkPerformanceConfig_Tier int32

const (
	// Default value
	NodeNetworkConfig_NetworkPerformanceConfig_TIER_UNSPECIFIED NodeNetworkConfig_NetworkPerformanceConfig_Tier = 0
	// Higher bandwidth, actual values based on VM size.
	NodeNetworkConfig_NetworkPerformanceConfig_TIER_1 NodeNetworkConfig_NetworkPerformanceConfig_Tier = 1
)

// Enum value maps for NodeNetworkConfig_NetworkPerformanceConfig_Tier.
var (
	NodeNetworkConfig_NetworkPerformanceConfig_Tier_name = map[int32]string{
		0: "TIER_UNSPECIFIED",
		1: "TIER_1",
	}
	NodeNetworkConfig_NetworkPerformanceConfig_Tier_value = map[string]int32{
		"TIER_UNSPECIFIED": 0,
		"TIER_1":           1,
	}
)

func (x NodeNetworkConfig_NetworkPerformanceConfig_Tier) Enum() *NodeNetworkConfig_NetworkPerformanceConfig_Tier {
	p := new(NodeNetworkConfig_NetworkPerformanceConfig_Tier)
	*p = x
	return p
}

func (x NodeNetworkConfig_NetworkPerformanceConfig_Tier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeNetworkConfig_NetworkPerformanceConfig_Tier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[11].Descriptor()
}

func (NodeNetworkConfig_NetworkPerformanceConfig_Tier) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[11]
}

func (x NodeNetworkConfig_NetworkPerformanceConfig_Tier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeNetworkConfig_NetworkPerformanceConfig_Tier.Descriptor instead.
func (NodeNetworkConfig_NetworkPerformanceConfig_Tier) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{5, 0, 0}
}

// Possible types of sandboxes.
type SandboxConfig_Type int32

const (
	// Default value. This should not be used.
	SandboxConfig_UNSPECIFIED SandboxConfig_Type = 0
	// Run sandbox using gvisor.
	SandboxConfig_GVISOR SandboxConfig_Type = 1
)

// Enum value maps for SandboxConfig_Type.
var (
	SandboxConfig_Type_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "GVISOR",
	}
	SandboxConfig_Type_value = map[string]int32{
		"UNSPECIFIED": 0,
		"GVISOR":      1,
	}
)

func (x SandboxConfig_Type) Enum() *SandboxConfig_Type {
	p := new(SandboxConfig_Type)
	*p = x
	return p
}

func (x SandboxConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SandboxConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[12].Descriptor()
}

func (SandboxConfig_Type) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[12]
}

func (x SandboxConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SandboxConfig_Type.Descriptor instead.
func (SandboxConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{9, 0}
}

// Indicates whether to consume capacity from a reservation or not.
type ReservationAffinity_Type int32

const (
	// Default value. This should not be used.
	ReservationAffinity_UNSPECIFIED ReservationAffinity_Type = 0
	// Do not consume from any reserved capacity.
	ReservationAffinity_NO_RESERVATION ReservationAffinity_Type = 1
	// Consume any reservation available.
	ReservationAffinity_ANY_RESERVATION ReservationAffinity_Type = 2
	// Must consume from a specific reservation. Must specify key value fields
	// for specifying the reservations.
	ReservationAffinity_SPECIFIC_RESERVATION ReservationAffinity_Type = 3
)

// Enum value maps for ReservationAffinity_Type.
var (
	ReservationAffinity_Type_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "NO_RESERVATION",
		2: "ANY_RESERVATION",
		3: "SPECIFIC_RESERVATION",
	}
	ReservationAffinity_Type_value = map[string]int32{
		"UNSPECIFIED":          0,
		"NO_RESERVATION":       1,
		"ANY_RESERVATION":      2,
		"SPECIFIC_RESERVATION": 3,
	}
)

func (x ReservationAffinity_Type) Enum() *ReservationAffinity_Type {
	p := new(ReservationAffinity_Type)
	*p = x
	return p
}

func (x ReservationAffinity_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationAffinity_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[13].Descriptor()
}

func (ReservationAffinity_Type) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[13]
}

func (x ReservationAffinity_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationAffinity_Type.Descriptor instead.
func (ReservationAffinity_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{11, 0}
}

// Operator allows user to specify affinity or anti-affinity for the
// given key values.
type SoleTenantConfig_NodeAffinity_Operator int32

const (
	// Invalid or unspecified affinity operator.
	SoleTenantConfig_NodeAffinity_OPERATOR_UNSPECIFIED SoleTenantConfig_NodeAffinity_Operator = 0
	// Affinity operator.
	SoleTenantConfig_NodeAffinity_IN SoleTenantConfig_NodeAffinity_Operator = 1
	// Anti-affinity operator.
	SoleTenantConfig_NodeAffinity_NOT_IN SoleTenantConfig_NodeAffinity_Operator = 2
)

// Enum value maps for SoleTenantConfig_NodeAffinity_Operator.
var (
	SoleTenantConfig_NodeAffinity_Operator_name = map[int32]string{
		0: "OPERATOR_UNSPECIFIED",
		1: "IN",
		2: "NOT_IN",
	}
	SoleTenantConfig_NodeAffinity_Operator_value = map[string]int32{
		"OPERATOR_UNSPECIFIED": 0,
		"IN":                   1,
		"NOT_IN":               2,
	}
)

func (x SoleTenantConfig_NodeAffinity_Operator) Enum() *SoleTenantConfig_NodeAffinity_Operator {
	p := new(SoleTenantConfig_NodeAffinity_Operator)
	*p = x
	return p
}

func (x SoleTenantConfig_NodeAffinity_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SoleTenantConfig_NodeAffinity_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[14].Descriptor()
}

func (SoleTenantConfig_NodeAffinity_Operator) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[14]
}

func (x SoleTenantConfig_NodeAffinity_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SoleTenantConfig_NodeAffinity_Operator.Descriptor instead.
func (SoleTenantConfig_NodeAffinity_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{12, 0, 0}
}

// Possible values for Effect in taint.
type NodeTaint_Effect int32

const (
	// Not set
	NodeTaint_EFFECT_UNSPECIFIED NodeTaint_Effect = 0
	// NoSchedule
	NodeTaint_NO_SCHEDULE NodeTaint_Effect = 1
	// PreferNoSchedule
	NodeTaint_PREFER_NO_SCHEDULE NodeTaint_Effect = 2
	// NoExecute
	NodeTaint_NO_EXECUTE NodeTaint_Effect = 3
)

// Enum value maps for NodeTaint_Effect.
var (
	NodeTaint_Effect_name = map[int32]string{
		0: "EFFECT_UNSPECIFIED",
		1: "NO_SCHEDULE",
		2: "PREFER_NO_SCHEDULE",
		3: "NO_EXECUTE",
	}
	NodeTaint_Effect_value = map[string]int32{
		"EFFECT_UNSPECIFIED": 0,
		"NO_SCHEDULE":        1,
		"PREFER_NO_SCHEDULE": 2,
		"NO_EXECUTE":         3,
	}
)

func (x NodeTaint_Effect) Enum() *NodeTaint_Effect {
	p := new(NodeTaint_Effect)
	*p = x
	return p
}

func (x NodeTaint_Effect) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeTaint_Effect) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[15].Descriptor()
}

func (NodeTaint_Effect) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[15]
}

func (x NodeTaint_Effect) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeTaint_Effect.Descriptor instead.
func (NodeTaint_Effect) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{14, 0}
}

// Load balancer type of ingress service of Cloud Run.
type CloudRunConfig_LoadBalancerType int32

const (
	// Load balancer type for Cloud Run is unspecified.
	CloudRunConfig_LOAD_BALANCER_TYPE_UNSPECIFIED CloudRunConfig_LoadBalancerType = 0
	// Install external load balancer for Cloud Run.
	CloudRunConfig_LOAD_BALANCER_TYPE_EXTERNAL CloudRunConfig_LoadBalancerType = 1
	// Install internal load balancer for Cloud Run.
	CloudRunConfig_LOAD_BALANCER_TYPE_INTERNAL CloudRunConfig_LoadBalancerType = 2
)

// Enum value maps for CloudRunConfig_LoadBalancerType.
var (
	CloudRunConfig_LoadBalancerType_name = map[int32]string{
		0: "LOAD_BALANCER_TYPE_UNSPECIFIED",
		1: "LOAD_BALANCER_TYPE_EXTERNAL",
		2: "LOAD_BALANCER_TYPE_INTERNAL",
	}
	CloudRunConfig_LoadBalancerType_value = map[string]int32{
		"LOAD_BALANCER_TYPE_UNSPECIFIED": 0,
		"LOAD_BALANCER_TYPE_EXTERNAL":    1,
		"LOAD_BALANCER_TYPE_INTERNAL":    2,
	}
)

func (x CloudRunConfig_LoadBalancerType) Enum() *CloudRunConfig_LoadBalancerType {
	p := new(CloudRunConfig_LoadBalancerType)
	*p = x
	return p
}

func (x CloudRunConfig_LoadBalancerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudRunConfig_LoadBalancerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[16].Descriptor()
}

func (CloudRunConfig_LoadBalancerType) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[16]
}

func (x CloudRunConfig_LoadBalancerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudRunConfig_LoadBalancerType.Descriptor instead.
func (CloudRunConfig_LoadBalancerType) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{30, 0}
}

// Allowed Network Policy providers.
type NetworkPolicy_Provider int32

const (
	// Not set
	NetworkPolicy_PROVIDER_UNSPECIFIED NetworkPolicy_Provider = 0
	// Tigera (Calico Felix).
	NetworkPolicy_CALICO NetworkPolicy_Provider = 1
)

// Enum value maps for NetworkPolicy_Provider.
var (
	NetworkPolicy_Provider_name = map[int32]string{
		0: "PROVIDER_UNSPECIFIED",
		1: "CALICO",
	}
	NetworkPolicy_Provider_value = map[string]int32{
		"PROVIDER_UNSPECIFIED": 0,
		"CALICO":               1,
	}
)

func (x NetworkPolicy_Provider) Enum() *NetworkPolicy_Provider {
	p := new(NetworkPolicy_Provider)
	*p = x
	return p
}

func (x NetworkPolicy_Provider) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPolicy_Provider) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[17].Descriptor()
}

func (NetworkPolicy_Provider) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[17]
}

func (x NetworkPolicy_Provider) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPolicy_Provider.Descriptor instead.
func (NetworkPolicy_Provider) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{41, 0}
}

// Binary Authorization mode of operation.
type BinaryAuthorization_EvaluationMode int32

const (
	// Default value
	BinaryAuthorization_EVALUATION_MODE_UNSPECIFIED BinaryAuthorization_EvaluationMode = 0
	// Disable BinaryAuthorization
	BinaryAuthorization_DISABLED BinaryAuthorization_EvaluationMode = 1
	// Enforce Kubernetes admission requests with BinaryAuthorization using the
	// project's singleton policy. This is equivalent to setting the
	// enabled boolean to true.
	BinaryAuthorization_PROJECT_SINGLETON_POLICY_ENFORCE BinaryAuthorization_EvaluationMode = 2
)

// Enum value maps for BinaryAuthorization_EvaluationMode.
var (
	BinaryAuthorization_EvaluationMode_name = map[int32]string{
		0: "EVALUATION_MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "PROJECT_SINGLETON_POLICY_ENFORCE",
	}
	BinaryAuthorization_EvaluationMode_value = map[string]int32{
		"EVALUATION_MODE_UNSPECIFIED":      0,
		"DISABLED":                         1,
		"PROJECT_SINGLETON_POLICY_ENFORCE": 2,
	}
)

func (x BinaryAuthorization_EvaluationMode) Enum() *BinaryAuthorization_EvaluationMode {
	p := new(BinaryAuthorization_EvaluationMode)
	*p = x
	return p
}

func (x BinaryAuthorization_EvaluationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BinaryAuthorization_EvaluationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[18].Descriptor()
}

func (BinaryAuthorization_EvaluationMode) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[18]
}

func (x BinaryAuthorization_EvaluationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BinaryAuthorization_EvaluationMode.Descriptor instead.
func (BinaryAuthorization_EvaluationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{42, 0}
}

// The current status of the cluster.
type Cluster_Status int32

const (
	// Not set.
	Cluster_STATUS_UNSPECIFIED Cluster_Status = 0
	// The PROVISIONING state indicates the cluster is being created.
	Cluster_PROVISIONING Cluster_Status = 1
	// The RUNNING state indicates the cluster has been created and is fully
	// usable.
	Cluster_RUNNING Cluster_Status = 2
	// The RECONCILING state indicates that some work is actively being done on
	// the cluster, such as upgrading the master or node software. Details can
	// be found in the `statusMessage` field.
	Cluster_RECONCILING Cluster_Status = 3
	// The STOPPING state indicates the cluster is being deleted.
	Cluster_STOPPING Cluster_Status = 4
	// The ERROR state indicates the cluster is unusable. It will be
	// automatically deleted. Details can be found in the `statusMessage` field.
	Cluster_ERROR Cluster_Status = 5
	// The DEGRADED state indicates the cluster requires user action to restore
	// full functionality. Details can be found in the `statusMessage` field.
	Cluster_DEGRADED Cluster_Status = 6
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "PROVISIONING",
		2: "RUNNING",
		3: "RECONCILING",
		4: "STOPPING",
		5: "ERROR",
		6: "DEGRADED",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"PROVISIONING":       1,
		"RUNNING":            2,
		"RECONCILING":        3,
		"STOPPING":           4,
		"ERROR":              5,
		"DEGRADED":           6,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[19].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[19]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{45, 0}
}

// Mode defines enablement mode for Compliance Posture.
type CompliancePostureConfig_Mode int32

const (
	// Default value not specified.
	CompliancePostureConfig_MODE_UNSPECIFIED CompliancePostureConfig_Mode = 0
	// Disables Compliance Posture features on the cluster.
	CompliancePostureConfig_DISABLED CompliancePostureConfig_Mode = 1
	// Enables Compliance Posture features on the cluster.
	CompliancePostureConfig_ENABLED CompliancePostureConfig_Mode = 2
)

// Enum value maps for CompliancePostureConfig_Mode.
var (
	CompliancePostureConfig_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "ENABLED",
	}
	CompliancePostureConfig_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"DISABLED":         1,
		"ENABLED":          2,
	}
)

func (x CompliancePostureConfig_Mode) Enum() *CompliancePostureConfig_Mode {
	p := new(CompliancePostureConfig_Mode)
	*p = x
	return p
}

func (x CompliancePostureConfig_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompliancePostureConfig_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[20].Descriptor()
}

func (CompliancePostureConfig_Mode) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[20]
}

func (x CompliancePostureConfig_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompliancePostureConfig_Mode.Descriptor instead.
func (CompliancePostureConfig_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{48, 0}
}

// Mode defines enablement mode for GKE Security posture features.
type SecurityPostureConfig_Mode int32

const (
	// Default value not specified.
	SecurityPostureConfig_MODE_UNSPECIFIED SecurityPostureConfig_Mode = 0
	// Disables Security Posture features on the cluster.
	SecurityPostureConfig_DISABLED SecurityPostureConfig_Mode = 1
	// Applies Security Posture features on the cluster.
	SecurityPostureConfig_BASIC SecurityPostureConfig_Mode = 2
	// Applies the Security Posture off cluster Enterprise level features.
	SecurityPostureConfig_ENTERPRISE SecurityPostureConfig_Mode = 3
)

// Enum value maps for SecurityPostureConfig_Mode.
var (
	SecurityPostureConfig_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "BASIC",
		3: "ENTERPRISE",
	}
	SecurityPostureConfig_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"DISABLED":         1,
		"BASIC":            2,
		"ENTERPRISE":       3,
	}
)

func (x SecurityPostureConfig_Mode) Enum() *SecurityPostureConfig_Mode {
	p := new(SecurityPostureConfig_Mode)
	*p = x
	return p
}

func (x SecurityPostureConfig_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPostureConfig_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[21].Descriptor()
}

func (SecurityPostureConfig_Mode) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[21]
}

func (x SecurityPostureConfig_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPostureConfig_Mode.Descriptor instead.
func (SecurityPostureConfig_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{50, 0}
}

// VulnerabilityMode defines enablement mode for vulnerability scanning.
type SecurityPostureConfig_VulnerabilityMode int32

const (
	// Default value not specified.
	SecurityPostureConfig_VULNERABILITY_MODE_UNSPECIFIED SecurityPostureConfig_VulnerabilityMode = 0
	// Disables vulnerability scanning on the cluster.
	SecurityPostureConfig_VULNERABILITY_DISABLED SecurityPostureConfig_VulnerabilityMode = 1
	// Applies basic vulnerability scanning on the cluster.
	SecurityPostureConfig_VULNERABILITY_BASIC SecurityPostureConfig_VulnerabilityMode = 2
	// Applies the Security Posture's vulnerability on cluster Enterprise level
	// features.
	SecurityPostureConfig_VULNERABILITY_ENTERPRISE SecurityPostureConfig_VulnerabilityMode = 3
)

// Enum value maps for SecurityPostureConfig_VulnerabilityMode.
var (
	SecurityPostureConfig_VulnerabilityMode_name = map[int32]string{
		0: "VULNERABILITY_MODE_UNSPECIFIED",
		1: "VULNERABILITY_DISABLED",
		2: "VULNERABILITY_BASIC",
		3: "VULNERABILITY_ENTERPRISE",
	}
	SecurityPostureConfig_VulnerabilityMode_value = map[string]int32{
		"VULNERABILITY_MODE_UNSPECIFIED": 0,
		"VULNERABILITY_DISABLED":         1,
		"VULNERABILITY_BASIC":            2,
		"VULNERABILITY_ENTERPRISE":       3,
	}
)

func (x SecurityPostureConfig_VulnerabilityMode) Enum() *SecurityPostureConfig_VulnerabilityMode {
	p := new(SecurityPostureConfig_VulnerabilityMode)
	*p = x
	return p
}

func (x SecurityPostureConfig_VulnerabilityMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPostureConfig_VulnerabilityMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[22].Descriptor()
}

func (SecurityPostureConfig_VulnerabilityMode) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[22]
}

func (x SecurityPostureConfig_VulnerabilityMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPostureConfig_VulnerabilityMode.Descriptor instead.
func (SecurityPostureConfig_VulnerabilityMode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{50, 1}
}

// Current status of the operation.
type Operation_Status int32

const (
	// Not set.
	Operation_STATUS_UNSPECIFIED Operation_Status = 0
	// The operation has been created.
	Operation_PENDING Operation_Status = 1
	// The operation is currently running.
	Operation_RUNNING Operation_Status = 2
	// The operation is done, either cancelled or completed.
	Operation_DONE Operation_Status = 3
	// The operation is aborting.
	Operation_ABORTING Operation_Status = 4
)

// Enum value maps for Operation_Status.
var (
	Operation_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "DONE",
		4: "ABORTING",
	}
	Operation_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"PENDING":            1,
		"RUNNING":            2,
		"DONE":               3,
		"ABORTING":           4,
	}
)

func (x Operation_Status) Enum() *Operation_Status {
	p := new(Operation_Status)
	*p = x
	return p
}

func (x Operation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[23].Descriptor()
}

func (Operation_Status) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[23]
}

func (x Operation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_Status.Descriptor instead.
func (Operation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{58, 0}
}

// Operation type categorizes the operation.
type Operation_Type int32

const (
	// Not set.
	Operation_TYPE_UNSPECIFIED Operation_Type = 0
	// The cluster is being created. The cluster should be assumed to be
	// unusable until the operation finishes.
	//
	// In the event of the operation failing, the cluster will enter the [ERROR
	// state][Cluster.Status.ERROR] and eventually be deleted.
	Operation_CREATE_CLUSTER Operation_Type = 1
	// The cluster is being deleted. The cluster should be assumed to be
	// unusable as soon as this operation starts.
	//
	// In the event of the operation failing, the cluster will enter the [ERROR
	// state][Cluster.Status.ERROR] and the deletion will be automatically
	// retried until completed.
	Operation_DELETE_CLUSTER Operation_Type = 2
	// The [cluster
	// version][google.container.v1.ClusterUpdate.desired_master_version] is
	// being updated. Note that this includes "upgrades" to the same version,
	// which are simply a recreation. This also includes
	// [auto-upgrades](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-upgrades#upgrading_automatically).
	// For more details, see [documentation on cluster
	// upgrades](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-upgrades#cluster_upgrades).
	Operation_UPGRADE_MASTER Operation_Type = 3
	// A node pool is being updated. Despite calling this an "upgrade", this
	// includes most forms of updates to node pools. This also includes
	// [auto-upgrades](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-upgrades).
	//
	// This operation sets the
	// [progress][google.container.v1.Operation.progress] field and may be
	// [canceled][google.container.v1.ClusterManager.CancelOperation].
	//
	// The upgrade strategy depends on [node pool
	// configuration](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pool-upgrade-strategies).
	// The nodes are generally still usable during this operation.
	Operation_UPGRADE_NODES Operation_Type = 4
	// A problem has been detected with the control plane and is being repaired.
	// This operation type is initiated by GKE. For more details, see
	// [documentation on
	// repairs](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions#repairs).
	Operation_REPAIR_CLUSTER Operation_Type = 5
	// The cluster is being updated. This is a broad category of operations and
	// includes operations that only change metadata as well as those that must
	// recreate the entire cluster. If the control plane must be recreated, this
	// will cause temporary downtime for zonal clusters.
	//
	// Some features require recreating the nodes as well. Those will be
	// recreated as separate operations and the update may not be completely
	// functional until the node pools recreations finish. Node recreations will
	// generally follow [maintenance
	// policies](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions).
	//
	// Some GKE-initiated operations use this type. This includes certain types
	// of auto-upgrades and incident mitigations.
	Operation_UPDATE_CLUSTER Operation_Type = 6
	// A node pool is being created. The node pool should be assumed to be
	// unusable until this operation finishes. In the event of an error, the
	// node pool may be partially created.
	//
	// If enabled, [node
	// autoprovisioning](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-provisioning)
	// may have automatically initiated such operations.
	Operation_CREATE_NODE_POOL Operation_Type = 7
	// The node pool is being deleted. The node pool should be assumed to be
	// unusable as soon as this operation starts.
	Operation_DELETE_NODE_POOL Operation_Type = 8
	// The node pool's [manamagent][google.container.v1.NodePool.management]
	// field is being updated. These operations only update metadata and may be
	// concurrent with most other operations.
	Operation_SET_NODE_POOL_MANAGEMENT Operation_Type = 9
	// A problem has been detected with nodes and [they are being
	// repaired](https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-repair).
	// This operation type is initiated by GKE, typically automatically. This
	// operation may be concurrent with other operations and there may be
	// multiple repairs occurring on the same node pool.
	Operation_AUTO_REPAIR_NODES Operation_Type = 10
	// Unused. Automatic node upgrade uses
	// [UPGRADE_NODES][google.container.v1.Operation.Type.UPGRADE_NODES].
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Operation_AUTO_UPGRADE_NODES Operation_Type = 11
	// Unused. Updating labels uses
	// [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Operation_SET_LABELS Operation_Type = 12
	// Unused. Updating master auth uses
	// [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Operation_SET_MASTER_AUTH Operation_Type = 13
	// The node pool is being resized. With the exception of resizing to or from
	// size zero, the node pool is generally usable during this operation.
	Operation_SET_NODE_POOL_SIZE Operation_Type = 14
	// Unused. Updating network policy uses
	// [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Operation_SET_NETWORK_POLICY Operation_Type = 15
	// Unused. Updating maintenance policy uses
	// [UPDATE_CLUSTER][google.container.v1.Operation.Type.UPDATE_CLUSTER].
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Operation_SET_MAINTENANCE_POLICY Operation_Type = 16
	// The control plane is being resized. This operation type is initiated by
	// GKE. These operations are often performed preemptively to ensure that the
	// control plane has sufficient resources and is not typically an indication
	// of issues. For more details, see
	// [documentation on
	// resizes](https://cloud.google.com/kubernetes-engine/docs/concepts/maintenance-windows-and-exclusions#repairs).
	Operation_RESIZE_CLUSTER Operation_Type = 18
	// Fleet features of GKE Enterprise are being upgraded. The cluster should
	// be assumed to be blocked for other upgrades until the operation finishes.
	Operation_FLEET_FEATURE_UPGRADE Operation_Type = 19
)

// Enum value maps for Operation_Type.
var (
	Operation_Type_name = map[int32]string{
		0:  "TYPE_UNSPECIFIED",
		1:  "CREATE_CLUSTER",
		2:  "DELETE_CLUSTER",
		3:  "UPGRADE_MASTER",
		4:  "UPGRADE_NODES",
		5:  "REPAIR_CLUSTER",
		6:  "UPDATE_CLUSTER",
		7:  "CREATE_NODE_POOL",
		8:  "DELETE_NODE_POOL",
		9:  "SET_NODE_POOL_MANAGEMENT",
		10: "AUTO_REPAIR_NODES",
		11: "AUTO_UPGRADE_NODES",
		12: "SET_LABELS",
		13: "SET_MASTER_AUTH",
		14: "SET_NODE_POOL_SIZE",
		15: "SET_NETWORK_POLICY",
		16: "SET_MAINTENANCE_POLICY",
		18: "RESIZE_CLUSTER",
		19: "FLEET_FEATURE_UPGRADE",
	}
	Operation_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":         0,
		"CREATE_CLUSTER":           1,
		"DELETE_CLUSTER":           2,
		"UPGRADE_MASTER":           3,
		"UPGRADE_NODES":            4,
		"REPAIR_CLUSTER":           5,
		"UPDATE_CLUSTER":           6,
		"CREATE_NODE_POOL":         7,
		"DELETE_NODE_POOL":         8,
		"SET_NODE_POOL_MANAGEMENT": 9,
		"AUTO_REPAIR_NODES":        10,
		"AUTO_UPGRADE_NODES":       11,
		"SET_LABELS":               12,
		"SET_MASTER_AUTH":          13,
		"SET_NODE_POOL_SIZE":       14,
		"SET_NETWORK_POLICY":       15,
		"SET_MAINTENANCE_POLICY":   16,
		"RESIZE_CLUSTER":           18,
		"FLEET_FEATURE_UPGRADE":    19,
	}
)

func (x Operation_Type) Enum() *Operation_Type {
	p := new(Operation_Type)
	*p = x
	return p
}

func (x Operation_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[24].Descriptor()
}

func (Operation_Type) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[24]
}

func (x Operation_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_Type.Descriptor instead.
func (Operation_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{58, 1}
}

// Operation type: what type update to perform.
type SetMasterAuthRequest_Action int32

const (
	// Operation is unknown and will error out.
	SetMasterAuthRequest_UNKNOWN SetMasterAuthRequest_Action = 0
	// Set the password to a user generated value.
	SetMasterAuthRequest_SET_PASSWORD SetMasterAuthRequest_Action = 1
	// Generate a new password and set it to that.
	SetMasterAuthRequest_GENERATE_PASSWORD SetMasterAuthRequest_Action = 2
	// Set the username.  If an empty username is provided, basic authentication
	// is disabled for the cluster.  If a non-empty username is provided, basic
	// authentication is enabled, with either a provided password or a generated
	// one.
	SetMasterAuthRequest_SET_USERNAME SetMasterAuthRequest_Action = 3
)

// Enum value maps for SetMasterAuthRequest_Action.
var (
	SetMasterAuthRequest_Action_name = map[int32]string{
		0: "UNKNOWN",
		1: "SET_PASSWORD",
		2: "GENERATE_PASSWORD",
		3: "SET_USERNAME",
	}
	SetMasterAuthRequest_Action_value = map[string]int32{
		"UNKNOWN":           0,
		"SET_PASSWORD":      1,
		"GENERATE_PASSWORD": 2,
		"SET_USERNAME":      3,
	}
)

func (x SetMasterAuthRequest_Action) Enum() *SetMasterAuthRequest_Action {
	p := new(SetMasterAuthRequest_Action)
	*p = x
	return p
}

func (x SetMasterAuthRequest_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SetMasterAuthRequest_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[25].Descriptor()
}

func (SetMasterAuthRequest_Action) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[25]
}

func (x SetMasterAuthRequest_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SetMasterAuthRequest_Action.Descriptor instead.
func (SetMasterAuthRequest_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{70, 0}
}

// The current status of the node pool instance.
type NodePool_Status int32

const (
	// Not set.
	NodePool_STATUS_UNSPECIFIED NodePool_Status = 0
	// The PROVISIONING state indicates the node pool is being created.
	NodePool_PROVISIONING NodePool_Status = 1
	// The RUNNING state indicates the node pool has been created
	// and is fully usable.
	NodePool_RUNNING NodePool_Status = 2
	// The RUNNING_WITH_ERROR state indicates the node pool has been created
	// and is partially usable. Some error state has occurred and some
	// functionality may be impaired. Customer may need to reissue a request
	// or trigger a new update.
	NodePool_RUNNING_WITH_ERROR NodePool_Status = 3
	// The RECONCILING state indicates that some work is actively being done on
	// the node pool, such as upgrading node software. Details can
	// be found in the `statusMessage` field.
	NodePool_RECONCILING NodePool_Status = 4
	// The STOPPING state indicates the node pool is being deleted.
	NodePool_STOPPING NodePool_Status = 5
	// The ERROR state indicates the node pool may be unusable. Details
	// can be found in the `statusMessage` field.
	NodePool_ERROR NodePool_Status = 6
)

// Enum value maps for NodePool_Status.
var (
	NodePool_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "PROVISIONING",
		2: "RUNNING",
		3: "RUNNING_WITH_ERROR",
		4: "RECONCILING",
		5: "STOPPING",
		6: "ERROR",
	}
	NodePool_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"PROVISIONING":       1,
		"RUNNING":            2,
		"RUNNING_WITH_ERROR": 3,
		"RECONCILING":        4,
		"STOPPING":           5,
		"ERROR":              6,
	}
)

func (x NodePool_Status) Enum() *NodePool_Status {
	p := new(NodePool_Status)
	*p = x
	return p
}

func (x NodePool_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodePool_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[26].Descriptor()
}

func (NodePool_Status) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[26]
}

func (x NodePool_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodePool_Status.Descriptor instead.
func (NodePool_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{85, 0}
}

// Phase represents the different stages blue-green upgrade is running in.
type NodePool_UpdateInfo_BlueGreenInfo_Phase int32

const (
	// Unspecified phase.
	NodePool_UpdateInfo_BlueGreenInfo_PHASE_UNSPECIFIED NodePool_UpdateInfo_BlueGreenInfo_Phase = 0
	// blue-green upgrade has been initiated.
	NodePool_UpdateInfo_BlueGreenInfo_UPDATE_STARTED NodePool_UpdateInfo_BlueGreenInfo_Phase = 1
	// Start creating green pool nodes.
	NodePool_UpdateInfo_BlueGreenInfo_CREATING_GREEN_POOL NodePool_UpdateInfo_BlueGreenInfo_Phase = 2
	// Start cordoning blue pool nodes.
	NodePool_UpdateInfo_BlueGreenInfo_CORDONING_BLUE_POOL NodePool_UpdateInfo_BlueGreenInfo_Phase = 3
	// Start draining blue pool nodes.
	NodePool_UpdateInfo_BlueGreenInfo_DRAINING_BLUE_POOL NodePool_UpdateInfo_BlueGreenInfo_Phase = 4
	// Start soaking time after draining entire blue pool.
	NodePool_UpdateInfo_BlueGreenInfo_NODE_POOL_SOAKING NodePool_UpdateInfo_BlueGreenInfo_Phase = 5
	// Start deleting blue nodes.
	NodePool_UpdateInfo_BlueGreenInfo_DELETING_BLUE_POOL NodePool_UpdateInfo_BlueGreenInfo_Phase = 6
	// Rollback has been initiated.
	NodePool_UpdateInfo_BlueGreenInfo_ROLLBACK_STARTED NodePool_UpdateInfo_BlueGreenInfo_Phase = 7
)

// Enum value maps for NodePool_UpdateInfo_BlueGreenInfo_Phase.
var (
	NodePool_UpdateInfo_BlueGreenInfo_Phase_name = map[int32]string{
		0: "PHASE_UNSPECIFIED",
		1: "UPDATE_STARTED",
		2: "CREATING_GREEN_POOL",
		3: "CORDONING_BLUE_POOL",
		4: "DRAINING_BLUE_POOL",
		5: "NODE_POOL_SOAKING",
		6: "DELETING_BLUE_POOL",
		7: "ROLLBACK_STARTED",
	}
	NodePool_UpdateInfo_BlueGreenInfo_Phase_value = map[string]int32{
		"PHASE_UNSPECIFIED":   0,
		"UPDATE_STARTED":      1,
		"CREATING_GREEN_POOL": 2,
		"CORDONING_BLUE_POOL": 3,
		"DRAINING_BLUE_POOL":  4,
		"NODE_POOL_SOAKING":   5,
		"DELETING_BLUE_POOL":  6,
		"ROLLBACK_STARTED":    7,
	}
)

func (x NodePool_UpdateInfo_BlueGreenInfo_Phase) Enum() *NodePool_UpdateInfo_BlueGreenInfo_Phase {
	p := new(NodePool_UpdateInfo_BlueGreenInfo_Phase)
	*p = x
	return p
}

func (x NodePool_UpdateInfo_BlueGreenInfo_Phase) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodePool_UpdateInfo_BlueGreenInfo_Phase) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[27].Descriptor()
}

func (NodePool_UpdateInfo_BlueGreenInfo_Phase) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[27]
}

func (x NodePool_UpdateInfo_BlueGreenInfo_Phase) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodePool_UpdateInfo_BlueGreenInfo_Phase.Descriptor instead.
func (NodePool_UpdateInfo_BlueGreenInfo_Phase) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{85, 1, 0, 0}
}

// Type defines the type of placement policy.
type NodePool_PlacementPolicy_Type int32

const (
	// TYPE_UNSPECIFIED specifies no requirements on nodes
	// placement.
	NodePool_PlacementPolicy_TYPE_UNSPECIFIED NodePool_PlacementPolicy_Type = 0
	// COMPACT specifies node placement in the same availability domain to
	// ensure low communication latency.
	NodePool_PlacementPolicy_COMPACT NodePool_PlacementPolicy_Type = 1
)

// Enum value maps for NodePool_PlacementPolicy_Type.
var (
	NodePool_PlacementPolicy_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "COMPACT",
	}
	NodePool_PlacementPolicy_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"COMPACT":          1,
	}
)

func (x NodePool_PlacementPolicy_Type) Enum() *NodePool_PlacementPolicy_Type {
	p := new(NodePool_PlacementPolicy_Type)
	*p = x
	return p
}

func (x NodePool_PlacementPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodePool_PlacementPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[28].Descriptor()
}

func (NodePool_PlacementPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[28]
}

func (x NodePool_PlacementPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodePool_PlacementPolicy_Type.Descriptor instead.
func (NodePool_PlacementPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{85, 2, 0}
}

// Scope of exclusion.
type MaintenanceExclusionOptions_Scope int32

const (
	// NO_UPGRADES excludes all upgrades, including patch upgrades and minor
	// upgrades across control planes and nodes. This is the default exclusion
	// behavior.
	MaintenanceExclusionOptions_NO_UPGRADES MaintenanceExclusionOptions_Scope = 0
	// NO_MINOR_UPGRADES excludes all minor upgrades for the cluster, only
	// patches are allowed.
	MaintenanceExclusionOptions_NO_MINOR_UPGRADES MaintenanceExclusionOptions_Scope = 1
	// NO_MINOR_OR_NODE_UPGRADES excludes all minor upgrades for the cluster,
	// and also exclude all node pool upgrades. Only control
	// plane patches are allowed.
	MaintenanceExclusionOptions_NO_MINOR_OR_NODE_UPGRADES MaintenanceExclusionOptions_Scope = 2
)

// Enum value maps for MaintenanceExclusionOptions_Scope.
var (
	MaintenanceExclusionOptions_Scope_name = map[int32]string{
		0: "NO_UPGRADES",
		1: "NO_MINOR_UPGRADES",
		2: "NO_MINOR_OR_NODE_UPGRADES",
	}
	MaintenanceExclusionOptions_Scope_value = map[string]int32{
		"NO_UPGRADES":               0,
		"NO_MINOR_UPGRADES":         1,
		"NO_MINOR_OR_NODE_UPGRADES": 2,
	}
)

func (x MaintenanceExclusionOptions_Scope) Enum() *MaintenanceExclusionOptions_Scope {
	p := new(MaintenanceExclusionOptions_Scope)
	*p = x
	return p
}

func (x MaintenanceExclusionOptions_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MaintenanceExclusionOptions_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[29].Descriptor()
}

func (MaintenanceExclusionOptions_Scope) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[29]
}

func (x MaintenanceExclusionOptions_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MaintenanceExclusionOptions_Scope.Descriptor instead.
func (MaintenanceExclusionOptions_Scope) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{92, 0}
}

// Defines possible options for autoscaling_profile field.
type ClusterAutoscaling_AutoscalingProfile int32

const (
	// No change to autoscaling configuration.
	ClusterAutoscaling_PROFILE_UNSPECIFIED ClusterAutoscaling_AutoscalingProfile = 0
	// Prioritize optimizing utilization of resources.
	ClusterAutoscaling_OPTIMIZE_UTILIZATION ClusterAutoscaling_AutoscalingProfile = 1
	// Use default (balanced) autoscaling configuration.
	ClusterAutoscaling_BALANCED ClusterAutoscaling_AutoscalingProfile = 2
)

// Enum value maps for ClusterAutoscaling_AutoscalingProfile.
var (
	ClusterAutoscaling_AutoscalingProfile_name = map[int32]string{
		0: "PROFILE_UNSPECIFIED",
		1: "OPTIMIZE_UTILIZATION",
		2: "BALANCED",
	}
	ClusterAutoscaling_AutoscalingProfile_value = map[string]int32{
		"PROFILE_UNSPECIFIED":  0,
		"OPTIMIZE_UTILIZATION": 1,
		"BALANCED":             2,
	}
)

func (x ClusterAutoscaling_AutoscalingProfile) Enum() *ClusterAutoscaling_AutoscalingProfile {
	p := new(ClusterAutoscaling_AutoscalingProfile)
	*p = x
	return p
}

func (x ClusterAutoscaling_AutoscalingProfile) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterAutoscaling_AutoscalingProfile) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[30].Descriptor()
}

func (ClusterAutoscaling_AutoscalingProfile) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[30]
}

func (x ClusterAutoscaling_AutoscalingProfile) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterAutoscaling_AutoscalingProfile.Descriptor instead.
func (ClusterAutoscaling_AutoscalingProfile) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{100, 0}
}

// Location policy specifies how zones are picked when scaling up the
// nodepool.
type NodePoolAutoscaling_LocationPolicy int32

const (
	// Not set.
	NodePoolAutoscaling_LOCATION_POLICY_UNSPECIFIED NodePoolAutoscaling_LocationPolicy = 0
	// BALANCED is a best effort policy that aims to balance the sizes of
	// different zones.
	NodePoolAutoscaling_BALANCED NodePoolAutoscaling_LocationPolicy = 1
	// ANY policy picks zones that have the highest capacity available.
	NodePoolAutoscaling_ANY NodePoolAutoscaling_LocationPolicy = 2
)

// Enum value maps for NodePoolAutoscaling_LocationPolicy.
var (
	NodePoolAutoscaling_LocationPolicy_name = map[int32]string{
		0: "LOCATION_POLICY_UNSPECIFIED",
		1: "BALANCED",
		2: "ANY",
	}
	NodePoolAutoscaling_LocationPolicy_value = map[string]int32{
		"LOCATION_POLICY_UNSPECIFIED": 0,
		"BALANCED":                    1,
		"ANY":                         2,
	}
)

func (x NodePoolAutoscaling_LocationPolicy) Enum() *NodePoolAutoscaling_LocationPolicy {
	p := new(NodePoolAutoscaling_LocationPolicy)
	*p = x
	return p
}

func (x NodePoolAutoscaling_LocationPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodePoolAutoscaling_LocationPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[31].Descriptor()
}

func (NodePoolAutoscaling_LocationPolicy) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[31]
}

func (x NodePoolAutoscaling_LocationPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodePoolAutoscaling_LocationPolicy.Descriptor instead.
func (NodePoolAutoscaling_LocationPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{103, 0}
}

// The type of GPU sharing strategy currently provided.
type GPUSharingConfig_GPUSharingStrategy int32

const (
	// Default value.
	GPUSharingConfig_GPU_SHARING_STRATEGY_UNSPECIFIED GPUSharingConfig_GPUSharingStrategy = 0
	// GPUs are time-shared between containers.
	GPUSharingConfig_TIME_SHARING GPUSharingConfig_GPUSharingStrategy = 1
	// GPUs are shared between containers with NVIDIA MPS.
	GPUSharingConfig_MPS GPUSharingConfig_GPUSharingStrategy = 2
)

// Enum value maps for GPUSharingConfig_GPUSharingStrategy.
var (
	GPUSharingConfig_GPUSharingStrategy_name = map[int32]string{
		0: "GPU_SHARING_STRATEGY_UNSPECIFIED",
		1: "TIME_SHARING",
		2: "MPS",
	}
	GPUSharingConfig_GPUSharingStrategy_value = map[string]int32{
		"GPU_SHARING_STRATEGY_UNSPECIFIED": 0,
		"TIME_SHARING":                     1,
		"MPS":                              2,
	}
)

func (x GPUSharingConfig_GPUSharingStrategy) Enum() *GPUSharingConfig_GPUSharingStrategy {
	p := new(GPUSharingConfig_GPUSharingStrategy)
	*p = x
	return p
}

func (x GPUSharingConfig_GPUSharingStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GPUSharingConfig_GPUSharingStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[32].Descriptor()
}

func (GPUSharingConfig_GPUSharingStrategy) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[32]
}

func (x GPUSharingConfig_GPUSharingStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GPUSharingConfig_GPUSharingStrategy.Descriptor instead.
func (GPUSharingConfig_GPUSharingStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{109, 0}
}

// The GPU driver version to install.
type GPUDriverInstallationConfig_GPUDriverVersion int32

const (
	// Default value is to not install any GPU driver.
	GPUDriverInstallationConfig_GPU_DRIVER_VERSION_UNSPECIFIED GPUDriverInstallationConfig_GPUDriverVersion = 0
	// Disable GPU driver auto installation and needs manual installation
	GPUDriverInstallationConfig_INSTALLATION_DISABLED GPUDriverInstallationConfig_GPUDriverVersion = 1
	// "Default" GPU driver in COS and Ubuntu.
	GPUDriverInstallationConfig_DEFAULT GPUDriverInstallationConfig_GPUDriverVersion = 2
	// "Latest" GPU driver in COS.
	GPUDriverInstallationConfig_LATEST GPUDriverInstallationConfig_GPUDriverVersion = 3
)

// Enum value maps for GPUDriverInstallationConfig_GPUDriverVersion.
var (
	GPUDriverInstallationConfig_GPUDriverVersion_name = map[int32]string{
		0: "GPU_DRIVER_VERSION_UNSPECIFIED",
		1: "INSTALLATION_DISABLED",
		2: "DEFAULT",
		3: "LATEST",
	}
	GPUDriverInstallationConfig_GPUDriverVersion_value = map[string]int32{
		"GPU_DRIVER_VERSION_UNSPECIFIED": 0,
		"INSTALLATION_DISABLED":          1,
		"DEFAULT":                        2,
		"LATEST":                         3,
	}
)

func (x GPUDriverInstallationConfig_GPUDriverVersion) Enum() *GPUDriverInstallationConfig_GPUDriverVersion {
	p := new(GPUDriverInstallationConfig_GPUDriverVersion)
	*p = x
	return p
}

func (x GPUDriverInstallationConfig_GPUDriverVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GPUDriverInstallationConfig_GPUDriverVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[33].Descriptor()
}

func (GPUDriverInstallationConfig_GPUDriverVersion) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[33]
}

func (x GPUDriverInstallationConfig_GPUDriverVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GPUDriverInstallationConfig_GPUDriverVersion.Descriptor instead.
func (GPUDriverInstallationConfig_GPUDriverVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{110, 0}
}

// Mode is the configuration for how to expose metadata to workloads running
// on the node.
type WorkloadMetadataConfig_Mode int32

const (
	// Not set.
	WorkloadMetadataConfig_MODE_UNSPECIFIED WorkloadMetadataConfig_Mode = 0
	// Expose all Compute Engine metadata to pods.
	WorkloadMetadataConfig_GCE_METADATA WorkloadMetadataConfig_Mode = 1
	// Run the GKE Metadata Server on this node. The GKE Metadata Server exposes
	// a metadata API to workloads that is compatible with the V1 Compute
	// Metadata APIs exposed by the Compute Engine and App Engine Metadata
	// Servers. This feature can only be enabled if Workload Identity is enabled
	// at the cluster level.
	WorkloadMetadataConfig_GKE_METADATA WorkloadMetadataConfig_Mode = 2
)

// Enum value maps for WorkloadMetadataConfig_Mode.
var (
	WorkloadMetadataConfig_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "GCE_METADATA",
		2: "GKE_METADATA",
	}
	WorkloadMetadataConfig_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"GCE_METADATA":     1,
		"GKE_METADATA":     2,
	}
)

func (x WorkloadMetadataConfig_Mode) Enum() *WorkloadMetadataConfig_Mode {
	p := new(WorkloadMetadataConfig_Mode)
	*p = x
	return p
}

func (x WorkloadMetadataConfig_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkloadMetadataConfig_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[34].Descriptor()
}

func (WorkloadMetadataConfig_Mode) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[34]
}

func (x WorkloadMetadataConfig_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkloadMetadataConfig_Mode.Descriptor instead.
func (WorkloadMetadataConfig_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{111, 0}
}

// Code for each condition
type StatusCondition_Code int32

const (
	// UNKNOWN indicates a generic condition.
	StatusCondition_UNKNOWN StatusCondition_Code = 0
	// GCE_STOCKOUT indicates that Google Compute Engine resources are
	// temporarily unavailable.
	StatusCondition_GCE_STOCKOUT StatusCondition_Code = 1
	// GKE_SERVICE_ACCOUNT_DELETED indicates that the user deleted their robot
	// service account.
	StatusCondition_GKE_SERVICE_ACCOUNT_DELETED StatusCondition_Code = 2
	// Google Compute Engine quota was exceeded.
	StatusCondition_GCE_QUOTA_EXCEEDED StatusCondition_Code = 3
	// Cluster state was manually changed by an SRE due to a system logic error.
	StatusCondition_SET_BY_OPERATOR StatusCondition_Code = 4
	// Unable to perform an encrypt operation against the CloudKMS key used for
	// etcd level encryption.
	StatusCondition_CLOUD_KMS_KEY_ERROR StatusCondition_Code = 7
	// Cluster CA is expiring soon.
	StatusCondition_CA_EXPIRING StatusCondition_Code = 9
)

// Enum value maps for StatusCondition_Code.
var (
	StatusCondition_Code_name = map[int32]string{
		0: "UNKNOWN",
		1: "GCE_STOCKOUT",
		2: "GKE_SERVICE_ACCOUNT_DELETED",
		3: "GCE_QUOTA_EXCEEDED",
		4: "SET_BY_OPERATOR",
		7: "CLOUD_KMS_KEY_ERROR",
		9: "CA_EXPIRING",
	}
	StatusCondition_Code_value = map[string]int32{
		"UNKNOWN":                     0,
		"GCE_STOCKOUT":                1,
		"GKE_SERVICE_ACCOUNT_DELETED": 2,
		"GCE_QUOTA_EXCEEDED":          3,
		"SET_BY_OPERATOR":             4,
		"CLOUD_KMS_KEY_ERROR":         7,
		"CA_EXPIRING":                 9,
	}
)

func (x StatusCondition_Code) Enum() *StatusCondition_Code {
	p := new(StatusCondition_Code)
	*p = x
	return p
}

func (x StatusCondition_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StatusCondition_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[35].Descriptor()
}

func (StatusCondition_Code) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[35]
}

func (x StatusCondition_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StatusCondition_Code.Descriptor instead.
func (StatusCondition_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{114, 0}
}

// Node network tier
type NetworkConfig_ClusterNetworkPerformanceConfig_Tier int32

const (
	// Default value
	NetworkConfig_ClusterNetworkPerformanceConfig_TIER_UNSPECIFIED NetworkConfig_ClusterNetworkPerformanceConfig_Tier = 0
	// Higher bandwidth, actual values based on VM size.
	NetworkConfig_ClusterNetworkPerformanceConfig_TIER_1 NetworkConfig_ClusterNetworkPerformanceConfig_Tier = 1
)

// Enum value maps for NetworkConfig_ClusterNetworkPerformanceConfig_Tier.
var (
	NetworkConfig_ClusterNetworkPerformanceConfig_Tier_name = map[int32]string{
		0: "TIER_UNSPECIFIED",
		1: "TIER_1",
	}
	NetworkConfig_ClusterNetworkPerformanceConfig_Tier_value = map[string]int32{
		"TIER_UNSPECIFIED": 0,
		"TIER_1":           1,
	}
)

func (x NetworkConfig_ClusterNetworkPerformanceConfig_Tier) Enum() *NetworkConfig_ClusterNetworkPerformanceConfig_Tier {
	p := new(NetworkConfig_ClusterNetworkPerformanceConfig_Tier)
	*p = x
	return p
}

func (x NetworkConfig_ClusterNetworkPerformanceConfig_Tier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkConfig_ClusterNetworkPerformanceConfig_Tier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[36].Descriptor()
}

func (NetworkConfig_ClusterNetworkPerformanceConfig_Tier) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[36]
}

func (x NetworkConfig_ClusterNetworkPerformanceConfig_Tier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkConfig_ClusterNetworkPerformanceConfig_Tier.Descriptor instead.
func (NetworkConfig_ClusterNetworkPerformanceConfig_Tier) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{115, 0, 0}
}

// Channel describes if/how Gateway API should be installed and implemented in
// a cluster.
type GatewayAPIConfig_Channel int32

const (
	// Default value.
	GatewayAPIConfig_CHANNEL_UNSPECIFIED GatewayAPIConfig_Channel = 0
	// Gateway API support is disabled
	GatewayAPIConfig_CHANNEL_DISABLED GatewayAPIConfig_Channel = 1
	// Deprecated: use CHANNEL_STANDARD instead.
	// Gateway API support is enabled, experimental CRDs are installed
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	GatewayAPIConfig_CHANNEL_EXPERIMENTAL GatewayAPIConfig_Channel = 3
	// Gateway API support is enabled, standard CRDs are installed
	GatewayAPIConfig_CHANNEL_STANDARD GatewayAPIConfig_Channel = 4
)

// Enum value maps for GatewayAPIConfig_Channel.
var (
	GatewayAPIConfig_Channel_name = map[int32]string{
		0: "CHANNEL_UNSPECIFIED",
		1: "CHANNEL_DISABLED",
		3: "CHANNEL_EXPERIMENTAL",
		4: "CHANNEL_STANDARD",
	}
	GatewayAPIConfig_Channel_value = map[string]int32{
		"CHANNEL_UNSPECIFIED":  0,
		"CHANNEL_DISABLED":     1,
		"CHANNEL_EXPERIMENTAL": 3,
		"CHANNEL_STANDARD":     4,
	}
)

func (x GatewayAPIConfig_Channel) Enum() *GatewayAPIConfig_Channel {
	p := new(GatewayAPIConfig_Channel)
	*p = x
	return p
}

func (x GatewayAPIConfig_Channel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GatewayAPIConfig_Channel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[37].Descriptor()
}

func (GatewayAPIConfig_Channel) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[37]
}

func (x GatewayAPIConfig_Channel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GatewayAPIConfig_Channel.Descriptor instead.
func (GatewayAPIConfig_Channel) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{116, 0}
}

// The type of the reported issue.
type AutopilotCompatibilityIssue_IssueType int32

const (
	// Default value, should not be used.
	AutopilotCompatibilityIssue_UNSPECIFIED AutopilotCompatibilityIssue_IssueType = 0
	// Indicates that the issue is a known incompatibility between the
	// cluster and Autopilot mode.
	AutopilotCompatibilityIssue_INCOMPATIBILITY AutopilotCompatibilityIssue_IssueType = 1
	// Indicates the issue is an incompatibility if customers take no further
	// action to resolve.
	AutopilotCompatibilityIssue_ADDITIONAL_CONFIG_REQUIRED AutopilotCompatibilityIssue_IssueType = 2
	// Indicates the issue is not an incompatibility, but depending on the
	// workloads business logic, there is a potential that they won't work on
	// Autopilot.
	AutopilotCompatibilityIssue_PASSED_WITH_OPTIONAL_CONFIG AutopilotCompatibilityIssue_IssueType = 3
)

// Enum value maps for AutopilotCompatibilityIssue_IssueType.
var (
	AutopilotCompatibilityIssue_IssueType_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "INCOMPATIBILITY",
		2: "ADDITIONAL_CONFIG_REQUIRED",
		3: "PASSED_WITH_OPTIONAL_CONFIG",
	}
	AutopilotCompatibilityIssue_IssueType_value = map[string]int32{
		"UNSPECIFIED":                 0,
		"INCOMPATIBILITY":             1,
		"ADDITIONAL_CONFIG_REQUIRED":  2,
		"PASSED_WITH_OPTIONAL_CONFIG": 3,
	}
)

func (x AutopilotCompatibilityIssue_IssueType) Enum() *AutopilotCompatibilityIssue_IssueType {
	p := new(AutopilotCompatibilityIssue_IssueType)
	*p = x
	return p
}

func (x AutopilotCompatibilityIssue_IssueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutopilotCompatibilityIssue_IssueType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[38].Descriptor()
}

func (AutopilotCompatibilityIssue_IssueType) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[38]
}

func (x AutopilotCompatibilityIssue_IssueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutopilotCompatibilityIssue_IssueType.Descriptor instead.
func (AutopilotCompatibilityIssue_IssueType) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{124, 0}
}

// Possible values for 'channel'.
type ReleaseChannel_Channel int32

const (
	// No channel specified.
	ReleaseChannel_UNSPECIFIED ReleaseChannel_Channel = 0
	// RAPID channel is offered on an early access basis for customers who want
	// to test new releases.
	//
	// WARNING: Versions available in the RAPID Channel may be subject to
	// unresolved issues with no known workaround and are not subject to any
	// SLAs.
	ReleaseChannel_RAPID ReleaseChannel_Channel = 1
	// Clusters subscribed to REGULAR receive versions that are considered GA
	// quality. REGULAR is intended for production users who want to take
	// advantage of new features.
	ReleaseChannel_REGULAR ReleaseChannel_Channel = 2
	// Clusters subscribed to STABLE receive versions that are known to be
	// stable and reliable in production.
	ReleaseChannel_STABLE ReleaseChannel_Channel = 3
	// Clusters subscribed to EXTENDED receive extended support and availability
	// for versions which are known to be stable and reliable in production.
	ReleaseChannel_EXTENDED ReleaseChannel_Channel = 4
)

// Enum value maps for ReleaseChannel_Channel.
var (
	ReleaseChannel_Channel_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "RAPID",
		2: "REGULAR",
		3: "STABLE",
		4: "EXTENDED",
	}
	ReleaseChannel_Channel_value = map[string]int32{
		"UNSPECIFIED": 0,
		"RAPID":       1,
		"REGULAR":     2,
		"STABLE":      3,
		"EXTENDED":    4,
	}
)

func (x ReleaseChannel_Channel) Enum() *ReleaseChannel_Channel {
	p := new(ReleaseChannel_Channel)
	*p = x
	return p
}

func (x ReleaseChannel_Channel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReleaseChannel_Channel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[39].Descriptor()
}

func (ReleaseChannel_Channel) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[39]
}

func (x ReleaseChannel_Channel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReleaseChannel_Channel.Descriptor instead.
func (ReleaseChannel_Channel) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{126, 0}
}

// Provider lists the various in-cluster DNS providers.
type DNSConfig_Provider int32

const (
	// Default value
	DNSConfig_PROVIDER_UNSPECIFIED DNSConfig_Provider = 0
	// Use GKE default DNS provider(kube-dns) for DNS resolution.
	DNSConfig_PLATFORM_DEFAULT DNSConfig_Provider = 1
	// Use CloudDNS for DNS resolution.
	DNSConfig_CLOUD_DNS DNSConfig_Provider = 2
	// Use KubeDNS for DNS resolution.
	DNSConfig_KUBE_DNS DNSConfig_Provider = 3
)

// Enum value maps for DNSConfig_Provider.
var (
	DNSConfig_Provider_name = map[int32]string{
		0: "PROVIDER_UNSPECIFIED",
		1: "PLATFORM_DEFAULT",
		2: "CLOUD_DNS",
		3: "KUBE_DNS",
	}
	DNSConfig_Provider_value = map[string]int32{
		"PROVIDER_UNSPECIFIED": 0,
		"PLATFORM_DEFAULT":     1,
		"CLOUD_DNS":            2,
		"KUBE_DNS":             3,
	}
)

func (x DNSConfig_Provider) Enum() *DNSConfig_Provider {
	p := new(DNSConfig_Provider)
	*p = x
	return p
}

func (x DNSConfig_Provider) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DNSConfig_Provider) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[40].Descriptor()
}

func (DNSConfig_Provider) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[40]
}

func (x DNSConfig_Provider) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DNSConfig_Provider.Descriptor instead.
func (DNSConfig_Provider) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{130, 0}
}

// DNSScope lists the various scopes of access to cluster DNS records.
type DNSConfig_DNSScope int32

const (
	// Default value, will be inferred as cluster scope.
	DNSConfig_DNS_SCOPE_UNSPECIFIED DNSConfig_DNSScope = 0
	// DNS records are accessible from within the cluster.
	DNSConfig_CLUSTER_SCOPE DNSConfig_DNSScope = 1
	// DNS records are accessible from within the VPC.
	DNSConfig_VPC_SCOPE DNSConfig_DNSScope = 2
)

// Enum value maps for DNSConfig_DNSScope.
var (
	DNSConfig_DNSScope_name = map[int32]string{
		0: "DNS_SCOPE_UNSPECIFIED",
		1: "CLUSTER_SCOPE",
		2: "VPC_SCOPE",
	}
	DNSConfig_DNSScope_value = map[string]int32{
		"DNS_SCOPE_UNSPECIFIED": 0,
		"CLUSTER_SCOPE":         1,
		"VPC_SCOPE":             2,
	}
)

func (x DNSConfig_DNSScope) Enum() *DNSConfig_DNSScope {
	p := new(DNSConfig_DNSScope)
	*p = x
	return p
}

func (x DNSConfig_DNSScope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DNSConfig_DNSScope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[41].Descriptor()
}

func (DNSConfig_DNSScope) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[41]
}

func (x DNSConfig_DNSScope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DNSConfig_DNSScope.Descriptor instead.
func (DNSConfig_DNSScope) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{130, 1}
}

// State of etcd encryption.
type DatabaseEncryption_State int32

const (
	// Should never be set
	DatabaseEncryption_UNKNOWN DatabaseEncryption_State = 0
	// Secrets in etcd are encrypted.
	DatabaseEncryption_ENCRYPTED DatabaseEncryption_State = 1
	// Secrets in etcd are stored in plain text (at etcd level) - this is
	// unrelated to Compute Engine level full disk encryption.
	DatabaseEncryption_DECRYPTED DatabaseEncryption_State = 2
)

// Enum value maps for DatabaseEncryption_State.
var (
	DatabaseEncryption_State_name = map[int32]string{
		0: "UNKNOWN",
		1: "ENCRYPTED",
		2: "DECRYPTED",
	}
	DatabaseEncryption_State_value = map[string]int32{
		"UNKNOWN":   0,
		"ENCRYPTED": 1,
		"DECRYPTED": 2,
	}
)

func (x DatabaseEncryption_State) Enum() *DatabaseEncryption_State {
	p := new(DatabaseEncryption_State)
	*p = x
	return p
}

func (x DatabaseEncryption_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseEncryption_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[42].Descriptor()
}

func (DatabaseEncryption_State) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[42]
}

func (x DatabaseEncryption_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseEncryption_State.Descriptor instead.
func (DatabaseEncryption_State) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{135, 0}
}

// Current State of etcd encryption.
type DatabaseEncryption_CurrentState int32

const (
	// Should never be set
	DatabaseEncryption_CURRENT_STATE_UNSPECIFIED DatabaseEncryption_CurrentState = 0
	// Secrets in etcd are encrypted.
	DatabaseEncryption_CURRENT_STATE_ENCRYPTED DatabaseEncryption_CurrentState = 7
	// Secrets in etcd are stored in plain text (at etcd level) - this is
	// unrelated to Compute Engine level full disk encryption.
	DatabaseEncryption_CURRENT_STATE_DECRYPTED DatabaseEncryption_CurrentState = 2
	// Encryption (or re-encryption with a different CloudKMS key)
	// of Secrets is in progress.
	DatabaseEncryption_CURRENT_STATE_ENCRYPTION_PENDING DatabaseEncryption_CurrentState = 3
	// Encryption (or re-encryption with a different CloudKMS key) of Secrets in
	// etcd encountered an error.
	DatabaseEncryption_CURRENT_STATE_ENCRYPTION_ERROR DatabaseEncryption_CurrentState = 4
	// De-crypting Secrets to plain text in etcd is in progress.
	DatabaseEncryption_CURRENT_STATE_DECRYPTION_PENDING DatabaseEncryption_CurrentState = 5
	// De-crypting Secrets to plain text in etcd encountered an error.
	DatabaseEncryption_CURRENT_STATE_DECRYPTION_ERROR DatabaseEncryption_CurrentState = 6
)

// Enum value maps for DatabaseEncryption_CurrentState.
var (
	DatabaseEncryption_CurrentState_name = map[int32]string{
		0: "CURRENT_STATE_UNSPECIFIED",
		7: "CURRENT_STATE_ENCRYPTED",
		2: "CURRENT_STATE_DECRYPTED",
		3: "CURRENT_STATE_ENCRYPTION_PENDING",
		4: "CURRENT_STATE_ENCRYPTION_ERROR",
		5: "CURRENT_STATE_DECRYPTION_PENDING",
		6: "CURRENT_STATE_DECRYPTION_ERROR",
	}
	DatabaseEncryption_CurrentState_value = map[string]int32{
		"CURRENT_STATE_UNSPECIFIED":        0,
		"CURRENT_STATE_ENCRYPTED":          7,
		"CURRENT_STATE_DECRYPTED":          2,
		"CURRENT_STATE_ENCRYPTION_PENDING": 3,
		"CURRENT_STATE_ENCRYPTION_ERROR":   4,
		"CURRENT_STATE_DECRYPTION_PENDING": 5,
		"CURRENT_STATE_DECRYPTION_ERROR":   6,
	}
)

func (x DatabaseEncryption_CurrentState) Enum() *DatabaseEncryption_CurrentState {
	p := new(DatabaseEncryption_CurrentState)
	*p = x
	return p
}

func (x DatabaseEncryption_CurrentState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseEncryption_CurrentState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[43].Descriptor()
}

func (DatabaseEncryption_CurrentState) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[43]
}

func (x DatabaseEncryption_CurrentState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseEncryption_CurrentState.Descriptor instead.
func (DatabaseEncryption_CurrentState) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{135, 1}
}

// Status shows the current usage of a secondary IP range.
type UsableSubnetworkSecondaryRange_Status int32

const (
	// UNKNOWN is the zero value of the Status enum. It's not a valid status.
	UsableSubnetworkSecondaryRange_UNKNOWN UsableSubnetworkSecondaryRange_Status = 0
	// UNUSED denotes that this range is unclaimed by any cluster.
	UsableSubnetworkSecondaryRange_UNUSED UsableSubnetworkSecondaryRange_Status = 1
	// IN_USE_SERVICE denotes that this range is claimed by cluster(s) for
	// services. User-managed services range can be shared between clusters
	// within the same subnetwork.
	UsableSubnetworkSecondaryRange_IN_USE_SERVICE UsableSubnetworkSecondaryRange_Status = 2
	// IN_USE_SHAREABLE_POD denotes this range was created by the network admin
	// and is currently claimed by a cluster for pods. It can only be used by
	// other clusters as a pod range.
	UsableSubnetworkSecondaryRange_IN_USE_SHAREABLE_POD UsableSubnetworkSecondaryRange_Status = 3
	// IN_USE_MANAGED_POD denotes this range was created by GKE and is claimed
	// for pods. It cannot be used for other clusters.
	UsableSubnetworkSecondaryRange_IN_USE_MANAGED_POD UsableSubnetworkSecondaryRange_Status = 4
)

// Enum value maps for UsableSubnetworkSecondaryRange_Status.
var (
	UsableSubnetworkSecondaryRange_Status_name = map[int32]string{
		0: "UNKNOWN",
		1: "UNUSED",
		2: "IN_USE_SERVICE",
		3: "IN_USE_SHAREABLE_POD",
		4: "IN_USE_MANAGED_POD",
	}
	UsableSubnetworkSecondaryRange_Status_value = map[string]int32{
		"UNKNOWN":              0,
		"UNUSED":               1,
		"IN_USE_SERVICE":       2,
		"IN_USE_SHAREABLE_POD": 3,
		"IN_USE_MANAGED_POD":   4,
	}
)

func (x UsableSubnetworkSecondaryRange_Status) Enum() *UsableSubnetworkSecondaryRange_Status {
	p := new(UsableSubnetworkSecondaryRange_Status)
	*p = x
	return p
}

func (x UsableSubnetworkSecondaryRange_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UsableSubnetworkSecondaryRange_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[44].Descriptor()
}

func (UsableSubnetworkSecondaryRange_Status) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[44]
}

func (x UsableSubnetworkSecondaryRange_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UsableSubnetworkSecondaryRange_Status.Descriptor instead.
func (UsableSubnetworkSecondaryRange_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{138, 0}
}

// Types of notifications currently supported. Can be used to filter what
// notifications are sent.
type NotificationConfig_EventType int32

const (
	// Not set, will be ignored.
	NotificationConfig_EVENT_TYPE_UNSPECIFIED NotificationConfig_EventType = 0
	// Corresponds with UpgradeAvailableEvent.
	NotificationConfig_UPGRADE_AVAILABLE_EVENT NotificationConfig_EventType = 1
	// Corresponds with UpgradeEvent.
	NotificationConfig_UPGRADE_EVENT NotificationConfig_EventType = 2
	// Corresponds with SecurityBulletinEvent.
	NotificationConfig_SECURITY_BULLETIN_EVENT NotificationConfig_EventType = 3
)

// Enum value maps for NotificationConfig_EventType.
var (
	NotificationConfig_EventType_name = map[int32]string{
		0: "EVENT_TYPE_UNSPECIFIED",
		1: "UPGRADE_AVAILABLE_EVENT",
		2: "UPGRADE_EVENT",
		3: "SECURITY_BULLETIN_EVENT",
	}
	NotificationConfig_EventType_value = map[string]int32{
		"EVENT_TYPE_UNSPECIFIED":  0,
		"UPGRADE_AVAILABLE_EVENT": 1,
		"UPGRADE_EVENT":           2,
		"SECURITY_BULLETIN_EVENT": 3,
	}
)

func (x NotificationConfig_EventType) Enum() *NotificationConfig_EventType {
	p := new(NotificationConfig_EventType)
	*p = x
	return p
}

func (x NotificationConfig_EventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NotificationConfig_EventType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[45].Descriptor()
}

func (NotificationConfig_EventType) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[45]
}

func (x NotificationConfig_EventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NotificationConfig_EventType.Descriptor instead.
func (NotificationConfig_EventType) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{146, 0}
}

// The state of the upgrade.
type UpgradeInfoEvent_State int32

const (
	// STATE_UNSPECIFIED indicates the state is unspecified.
	UpgradeInfoEvent_STATE_UNSPECIFIED UpgradeInfoEvent_State = 0
	// STARTED indicates the upgrade has started.
	UpgradeInfoEvent_STARTED UpgradeInfoEvent_State = 3
	// SUCCEEDED indicates the upgrade has completed successfully.
	UpgradeInfoEvent_SUCCEEDED UpgradeInfoEvent_State = 4
	// FAILED indicates the upgrade has failed.
	UpgradeInfoEvent_FAILED UpgradeInfoEvent_State = 5
	// CANCELED indicates the upgrade has canceled.
	UpgradeInfoEvent_CANCELED UpgradeInfoEvent_State = 6
)

// Enum value maps for UpgradeInfoEvent_State.
var (
	UpgradeInfoEvent_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		3: "STARTED",
		4: "SUCCEEDED",
		5: "FAILED",
		6: "CANCELED",
	}
	UpgradeInfoEvent_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTED":           3,
		"SUCCEEDED":         4,
		"FAILED":            5,
		"CANCELED":          6,
	}
)

func (x UpgradeInfoEvent_State) Enum() *UpgradeInfoEvent_State {
	p := new(UpgradeInfoEvent_State)
	*p = x
	return p
}

func (x UpgradeInfoEvent_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpgradeInfoEvent_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[46].Descriptor()
}

func (UpgradeInfoEvent_State) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[46]
}

func (x UpgradeInfoEvent_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpgradeInfoEvent_State.Descriptor instead.
func (UpgradeInfoEvent_State) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{149, 0}
}

// GKE components exposing logs
type LoggingComponentConfig_Component int32

const (
	// Default value. This shouldn't be used.
	LoggingComponentConfig_COMPONENT_UNSPECIFIED LoggingComponentConfig_Component = 0
	// system components
	LoggingComponentConfig_SYSTEM_COMPONENTS LoggingComponentConfig_Component = 1
	// workloads
	LoggingComponentConfig_WORKLOADS LoggingComponentConfig_Component = 2
	// kube-apiserver
	LoggingComponentConfig_APISERVER LoggingComponentConfig_Component = 3
	// kube-scheduler
	LoggingComponentConfig_SCHEDULER LoggingComponentConfig_Component = 4
	// kube-controller-manager
	LoggingComponentConfig_CONTROLLER_MANAGER LoggingComponentConfig_Component = 5
	// kcp-sshd
	LoggingComponentConfig_KCP_SSHD LoggingComponentConfig_Component = 7
	// kcp connection logs
	LoggingComponentConfig_KCP_CONNECTION LoggingComponentConfig_Component = 8
)

// Enum value maps for LoggingComponentConfig_Component.
var (
	LoggingComponentConfig_Component_name = map[int32]string{
		0: "COMPONENT_UNSPECIFIED",
		1: "SYSTEM_COMPONENTS",
		2: "WORKLOADS",
		3: "APISERVER",
		4: "SCHEDULER",
		5: "CONTROLLER_MANAGER",
		7: "KCP_SSHD",
		8: "KCP_CONNECTION",
	}
	LoggingComponentConfig_Component_value = map[string]int32{
		"COMPONENT_UNSPECIFIED": 0,
		"SYSTEM_COMPONENTS":     1,
		"WORKLOADS":             2,
		"APISERVER":             3,
		"SCHEDULER":             4,
		"CONTROLLER_MANAGER":    5,
		"KCP_SSHD":              7,
		"KCP_CONNECTION":        8,
	}
)

func (x LoggingComponentConfig_Component) Enum() *LoggingComponentConfig_Component {
	p := new(LoggingComponentConfig_Component)
	*p = x
	return p
}

func (x LoggingComponentConfig_Component) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggingComponentConfig_Component) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[47].Descriptor()
}

func (LoggingComponentConfig_Component) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[47]
}

func (x LoggingComponentConfig_Component) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggingComponentConfig_Component.Descriptor instead.
func (LoggingComponentConfig_Component) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{155, 0}
}

// Supported Relay modes
type AdvancedDatapathObservabilityConfig_RelayMode int32

const (
	// Default value. This shouldn't be used.
	AdvancedDatapathObservabilityConfig_RELAY_MODE_UNSPECIFIED AdvancedDatapathObservabilityConfig_RelayMode = 0
	// disabled
	AdvancedDatapathObservabilityConfig_DISABLED AdvancedDatapathObservabilityConfig_RelayMode = 1
	// exposed via internal load balancer
	AdvancedDatapathObservabilityConfig_INTERNAL_VPC_LB AdvancedDatapathObservabilityConfig_RelayMode = 3
	// exposed via external load balancer
	AdvancedDatapathObservabilityConfig_EXTERNAL_LB AdvancedDatapathObservabilityConfig_RelayMode = 4
)

// Enum value maps for AdvancedDatapathObservabilityConfig_RelayMode.
var (
	AdvancedDatapathObservabilityConfig_RelayMode_name = map[int32]string{
		0: "RELAY_MODE_UNSPECIFIED",
		1: "DISABLED",
		3: "INTERNAL_VPC_LB",
		4: "EXTERNAL_LB",
	}
	AdvancedDatapathObservabilityConfig_RelayMode_value = map[string]int32{
		"RELAY_MODE_UNSPECIFIED": 0,
		"DISABLED":               1,
		"INTERNAL_VPC_LB":        3,
		"EXTERNAL_LB":            4,
	}
)

func (x AdvancedDatapathObservabilityConfig_RelayMode) Enum() *AdvancedDatapathObservabilityConfig_RelayMode {
	p := new(AdvancedDatapathObservabilityConfig_RelayMode)
	*p = x
	return p
}

func (x AdvancedDatapathObservabilityConfig_RelayMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AdvancedDatapathObservabilityConfig_RelayMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[48].Descriptor()
}

func (AdvancedDatapathObservabilityConfig_RelayMode) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[48]
}

func (x AdvancedDatapathObservabilityConfig_RelayMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AdvancedDatapathObservabilityConfig_RelayMode.Descriptor instead.
func (AdvancedDatapathObservabilityConfig_RelayMode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{158, 0}
}

// Logging component variants.
type LoggingVariantConfig_Variant int32

const (
	// Default value. This shouldn't be used.
	LoggingVariantConfig_VARIANT_UNSPECIFIED LoggingVariantConfig_Variant = 0
	// default logging variant.
	LoggingVariantConfig_DEFAULT LoggingVariantConfig_Variant = 1
	// maximum logging throughput variant.
	LoggingVariantConfig_MAX_THROUGHPUT LoggingVariantConfig_Variant = 2
)

// Enum value maps for LoggingVariantConfig_Variant.
var (
	LoggingVariantConfig_Variant_name = map[int32]string{
		0: "VARIANT_UNSPECIFIED",
		1: "DEFAULT",
		2: "MAX_THROUGHPUT",
	}
	LoggingVariantConfig_Variant_value = map[string]int32{
		"VARIANT_UNSPECIFIED": 0,
		"DEFAULT":             1,
		"MAX_THROUGHPUT":      2,
	}
)

func (x LoggingVariantConfig_Variant) Enum() *LoggingVariantConfig_Variant {
	p := new(LoggingVariantConfig_Variant)
	*p = x
	return p
}

func (x LoggingVariantConfig_Variant) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggingVariantConfig_Variant) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[49].Descriptor()
}

func (LoggingVariantConfig_Variant) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[49]
}

func (x LoggingVariantConfig_Variant) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggingVariantConfig_Variant.Descriptor instead.
func (LoggingVariantConfig_Variant) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{161, 0}
}

// GKE components exposing metrics
type MonitoringComponentConfig_Component int32

const (
	// Default value. This shouldn't be used.
	MonitoringComponentConfig_COMPONENT_UNSPECIFIED MonitoringComponentConfig_Component = 0
	// system components
	MonitoringComponentConfig_SYSTEM_COMPONENTS MonitoringComponentConfig_Component = 1
	// kube-apiserver
	MonitoringComponentConfig_APISERVER MonitoringComponentConfig_Component = 3
	// kube-scheduler
	MonitoringComponentConfig_SCHEDULER MonitoringComponentConfig_Component = 4
	// kube-controller-manager
	MonitoringComponentConfig_CONTROLLER_MANAGER MonitoringComponentConfig_Component = 5
	// Storage
	MonitoringComponentConfig_STORAGE MonitoringComponentConfig_Component = 7
	// Horizontal Pod Autoscaling
	MonitoringComponentConfig_HPA MonitoringComponentConfig_Component = 8
	// Pod
	MonitoringComponentConfig_POD MonitoringComponentConfig_Component = 9
	// DaemonSet
	MonitoringComponentConfig_DAEMONSET MonitoringComponentConfig_Component = 10
	// Deployment
	MonitoringComponentConfig_DEPLOYMENT MonitoringComponentConfig_Component = 11
	// Statefulset
	MonitoringComponentConfig_STATEFULSET MonitoringComponentConfig_Component = 12
	// CADVISOR
	MonitoringComponentConfig_CADVISOR MonitoringComponentConfig_Component = 13
	// KUBELET
	MonitoringComponentConfig_KUBELET MonitoringComponentConfig_Component = 14
	// NVIDIA Data Center GPU Manager (DCGM)
	MonitoringComponentConfig_DCGM MonitoringComponentConfig_Component = 15
)

// Enum value maps for MonitoringComponentConfig_Component.
var (
	MonitoringComponentConfig_Component_name = map[int32]string{
		0:  "COMPONENT_UNSPECIFIED",
		1:  "SYSTEM_COMPONENTS",
		3:  "APISERVER",
		4:  "SCHEDULER",
		5:  "CONTROLLER_MANAGER",
		7:  "STORAGE",
		8:  "HPA",
		9:  "POD",
		10: "DAEMONSET",
		11: "DEPLOYMENT",
		12: "STATEFULSET",
		13: "CADVISOR",
		14: "KUBELET",
		15: "DCGM",
	}
	MonitoringComponentConfig_Component_value = map[string]int32{
		"COMPONENT_UNSPECIFIED": 0,
		"SYSTEM_COMPONENTS":     1,
		"APISERVER":             3,
		"SCHEDULER":             4,
		"CONTROLLER_MANAGER":    5,
		"STORAGE":               7,
		"HPA":                   8,
		"POD":                   9,
		"DAEMONSET":             10,
		"DEPLOYMENT":            11,
		"STATEFULSET":           12,
		"CADVISOR":              13,
		"KUBELET":               14,
		"DCGM":                  15,
	}
)

func (x MonitoringComponentConfig_Component) Enum() *MonitoringComponentConfig_Component {
	p := new(MonitoringComponentConfig_Component)
	*p = x
	return p
}

func (x MonitoringComponentConfig_Component) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MonitoringComponentConfig_Component) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[50].Descriptor()
}

func (MonitoringComponentConfig_Component) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[50]
}

func (x MonitoringComponentConfig_Component) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MonitoringComponentConfig_Component.Descriptor instead.
func (MonitoringComponentConfig_Component) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{162, 0}
}

// Premium tiers for GKE Cluster.
type EnterpriseConfig_ClusterTier int32

const (
	// CLUSTER_TIER_UNSPECIFIED is when cluster_tier is not set.
	EnterpriseConfig_CLUSTER_TIER_UNSPECIFIED EnterpriseConfig_ClusterTier = 0
	// STANDARD indicates a standard GKE cluster.
	EnterpriseConfig_STANDARD EnterpriseConfig_ClusterTier = 1
	// ENTERPRISE indicates a GKE Enterprise cluster.
	EnterpriseConfig_ENTERPRISE EnterpriseConfig_ClusterTier = 2
)

// Enum value maps for EnterpriseConfig_ClusterTier.
var (
	EnterpriseConfig_ClusterTier_name = map[int32]string{
		0: "CLUSTER_TIER_UNSPECIFIED",
		1: "STANDARD",
		2: "ENTERPRISE",
	}
	EnterpriseConfig_ClusterTier_value = map[string]int32{
		"CLUSTER_TIER_UNSPECIFIED": 0,
		"STANDARD":                 1,
		"ENTERPRISE":               2,
	}
)

func (x EnterpriseConfig_ClusterTier) Enum() *EnterpriseConfig_ClusterTier {
	p := new(EnterpriseConfig_ClusterTier)
	*p = x
	return p
}

func (x EnterpriseConfig_ClusterTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnterpriseConfig_ClusterTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[51].Descriptor()
}

func (EnterpriseConfig_ClusterTier) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[51]
}

func (x EnterpriseConfig_ClusterTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnterpriseConfig_ClusterTier.Descriptor instead.
func (EnterpriseConfig_ClusterTier) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{169, 0}
}

// Mode specifies how the secondary boot disk will be used.
// This triggers mode-specified logic in the control plane.
type SecondaryBootDisk_Mode int32

const (
	// MODE_UNSPECIFIED is when mode is not set.
	SecondaryBootDisk_MODE_UNSPECIFIED SecondaryBootDisk_Mode = 0
	// CONTAINER_IMAGE_CACHE is for using the secondary boot disk as
	// a container image cache.
	SecondaryBootDisk_CONTAINER_IMAGE_CACHE SecondaryBootDisk_Mode = 1
)

// Enum value maps for SecondaryBootDisk_Mode.
var (
	SecondaryBootDisk_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "CONTAINER_IMAGE_CACHE",
	}
	SecondaryBootDisk_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED":      0,
		"CONTAINER_IMAGE_CACHE": 1,
	}
)

func (x SecondaryBootDisk_Mode) Enum() *SecondaryBootDisk_Mode {
	p := new(SecondaryBootDisk_Mode)
	*p = x
	return p
}

func (x SecondaryBootDisk_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecondaryBootDisk_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_container_v1_cluster_service_proto_enumTypes[52].Descriptor()
}

func (SecondaryBootDisk_Mode) Type() protoreflect.EnumType {
	return &file_google_container_v1_cluster_service_proto_enumTypes[52]
}

func (x SecondaryBootDisk_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecondaryBootDisk_Mode.Descriptor instead.
func (SecondaryBootDisk_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{171, 0}
}

// Parameters that can be configured on Linux nodes.
type LinuxNodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Linux kernel parameters to be applied to the nodes and all pods running
	// on the nodes.
	//
	// The following parameters are supported.
	//
	// net.core.busy_poll
	// net.core.busy_read
	// net.core.netdev_max_backlog
	// net.core.rmem_max
	// net.core.wmem_default
	// net.core.wmem_max
	// net.core.optmem_max
	// net.core.somaxconn
	// net.ipv4.tcp_rmem
	// net.ipv4.tcp_wmem
	// net.ipv4.tcp_tw_reuse
	// kernel.shmmni
	// kernel.shmmax
	// kernel.shmall
	Sysctls map[string]string `protobuf:"bytes,1,rep,name=sysctls,proto3" json:"sysctls,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// cgroup_mode specifies the cgroup mode to be used on the node.
	CgroupMode LinuxNodeConfig_CgroupMode `protobuf:"varint,2,opt,name=cgroup_mode,json=cgroupMode,proto3,enum=google.container.v1.LinuxNodeConfig_CgroupMode" json:"cgroup_mode,omitempty"`
	// Optional. Amounts for 2M and 1G hugepages
	Hugepages *LinuxNodeConfig_HugepagesConfig `protobuf:"bytes,3,opt,name=hugepages,proto3,oneof" json:"hugepages,omitempty"`
}

func (x *LinuxNodeConfig) Reset() {
	*x = LinuxNodeConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxNodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxNodeConfig) ProtoMessage() {}

func (x *LinuxNodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxNodeConfig.ProtoReflect.Descriptor instead.
func (*LinuxNodeConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{0}
}

func (x *LinuxNodeConfig) GetSysctls() map[string]string {
	if x != nil {
		return x.Sysctls
	}
	return nil
}

func (x *LinuxNodeConfig) GetCgroupMode() LinuxNodeConfig_CgroupMode {
	if x != nil {
		return x.CgroupMode
	}
	return LinuxNodeConfig_CGROUP_MODE_UNSPECIFIED
}

func (x *LinuxNodeConfig) GetHugepages() *LinuxNodeConfig_HugepagesConfig {
	if x != nil {
		return x.Hugepages
	}
	return nil
}

// Parameters that can be configured on Windows nodes.
// Windows Node Config that define the parameters that will be used to
// configure the Windows node pool settings
type WindowsNodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// OSVersion specifies the Windows node config to be used on the node
	OsVersion WindowsNodeConfig_OSVersion `protobuf:"varint,1,opt,name=os_version,json=osVersion,proto3,enum=google.container.v1.WindowsNodeConfig_OSVersion" json:"os_version,omitempty"`
}

func (x *WindowsNodeConfig) Reset() {
	*x = WindowsNodeConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowsNodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowsNodeConfig) ProtoMessage() {}

func (x *WindowsNodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowsNodeConfig.ProtoReflect.Descriptor instead.
func (*WindowsNodeConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{1}
}

func (x *WindowsNodeConfig) GetOsVersion() WindowsNodeConfig_OSVersion {
	if x != nil {
		return x.OsVersion
	}
	return WindowsNodeConfig_OS_VERSION_UNSPECIFIED
}

// Node kubelet configs.
type NodeKubeletConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Control the CPU management policy on the node.
	// See
	// https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/
	//
	// The following values are allowed.
	// * "none": the default, which represents the existing scheduling behavior.
	// * "static": allows pods with certain resource characteristics to be granted
	// increased CPU affinity and exclusivity on the node.
	// The default value is 'none' if unspecified.
	CpuManagerPolicy string `protobuf:"bytes,1,opt,name=cpu_manager_policy,json=cpuManagerPolicy,proto3" json:"cpu_manager_policy,omitempty"`
	// Enable CPU CFS quota enforcement for containers that specify CPU limits.
	//
	// This option is enabled by default which makes kubelet use CFS quota
	// (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to
	// enforce container CPU limits. Otherwise, CPU limits will not be enforced at
	// all.
	//
	// Disable this option to mitigate CPU throttling problems while still having
	// your pods to be in Guaranteed QoS class by specifying the CPU limits.
	//
	// The default value is 'true' if unspecified.
	CpuCfsQuota *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=cpu_cfs_quota,json=cpuCfsQuota,proto3" json:"cpu_cfs_quota,omitempty"`
	// Set the CPU CFS quota period value 'cpu.cfs_period_us'.
	//
	// The string must be a sequence of decimal numbers, each with optional
	// fraction and a unit suffix, such as "300ms".
	// Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".
	// The value must be a positive duration.
	CpuCfsQuotaPeriod string `protobuf:"bytes,3,opt,name=cpu_cfs_quota_period,json=cpuCfsQuotaPeriod,proto3" json:"cpu_cfs_quota_period,omitempty"`
	// Set the Pod PID limits. See
	// https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits
	//
	// Controls the maximum number of processes allowed to run in a pod. The value
	// must be greater than or equal to 1024 and less than 4194304.
	PodPidsLimit int64 `protobuf:"varint,4,opt,name=pod_pids_limit,json=podPidsLimit,proto3" json:"pod_pids_limit,omitempty"`
	// Enable or disable Kubelet read only port.
	InsecureKubeletReadonlyPortEnabled *bool `protobuf:"varint,7,opt,name=insecure_kubelet_readonly_port_enabled,json=insecureKubeletReadonlyPortEnabled,proto3,oneof" json:"insecure_kubelet_readonly_port_enabled,omitempty"`
}

func (x *NodeKubeletConfig) Reset() {
	*x = NodeKubeletConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeKubeletConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeKubeletConfig) ProtoMessage() {}

func (x *NodeKubeletConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeKubeletConfig.ProtoReflect.Descriptor instead.
func (*NodeKubeletConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{2}
}

func (x *NodeKubeletConfig) GetCpuManagerPolicy() string {
	if x != nil {
		return x.CpuManagerPolicy
	}
	return ""
}

func (x *NodeKubeletConfig) GetCpuCfsQuota() *wrapperspb.BoolValue {
	if x != nil {
		return x.CpuCfsQuota
	}
	return nil
}

func (x *NodeKubeletConfig) GetCpuCfsQuotaPeriod() string {
	if x != nil {
		return x.CpuCfsQuotaPeriod
	}
	return ""
}

func (x *NodeKubeletConfig) GetPodPidsLimit() int64 {
	if x != nil {
		return x.PodPidsLimit
	}
	return 0
}

func (x *NodeKubeletConfig) GetInsecureKubeletReadonlyPortEnabled() bool {
	if x != nil && x.InsecureKubeletReadonlyPortEnabled != nil {
		return *x.InsecureKubeletReadonlyPortEnabled
	}
	return false
}

// Parameters that describe the nodes in a cluster.
//
// GKE Autopilot clusters do not
// recognize parameters in `NodeConfig`. Use
// [AutoprovisioningNodePoolDefaults][google.container.v1.AutoprovisioningNodePoolDefaults]
// instead.
type NodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of a Google Compute Engine [machine
	// type](https://cloud.google.com/compute/docs/machine-types)
	//
	// If unspecified, the default machine type is `e2-medium`.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Size of the disk attached to each node, specified in GB.
	// The smallest allowed disk size is 10GB.
	//
	// If unspecified, the default disk size is 100GB.
	DiskSizeGb int32 `protobuf:"varint,2,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// The set of Google API scopes to be made available on all of the
	// node VMs under the "default" service account.
	//
	// The following scopes are recommended, but not required, and by default are
	// not included:
	//
	// * `https://www.googleapis.com/auth/compute` is required for mounting
	// persistent storage on your nodes.
	// * `https://www.googleapis.com/auth/devstorage.read_only` is required for
	// communicating with **gcr.io**
	// (the [Google Container
	// Registry](https://cloud.google.com/container-registry/)).
	//
	// If unspecified, no scopes are added, unless Cloud Logging or Cloud
	// Monitoring are enabled, in which case their required scopes will be added.
	OauthScopes []string `protobuf:"bytes,3,rep,name=oauth_scopes,json=oauthScopes,proto3" json:"oauth_scopes,omitempty"`
	// The Google Cloud Platform Service Account to be used by the node VMs.
	// Specify the email address of the Service Account; otherwise, if no Service
	// Account is specified, the "default" service account is used.
	ServiceAccount string `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The metadata key/value pairs assigned to instances in the cluster.
	//
	// Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes
	// in length. These are reflected as part of a URL in the metadata server.
	// Additionally, to avoid ambiguity, keys must not conflict with any other
	// metadata keys for the project or be one of the reserved keys:
	//
	//   - "cluster-location"
	//   - "cluster-name"
	//   - "cluster-uid"
	//   - "configure-sh"
	//   - "containerd-configure-sh"
	//   - "enable-os-login"
	//   - "gci-ensure-gke-docker"
	//   - "gci-metrics-enabled"
	//   - "gci-update-strategy"
	//   - "instance-template"
	//   - "kube-env"
	//   - "startup-script"
	//   - "user-data"
	//   - "disable-address-manager"
	//   - "windows-startup-script-ps1"
	//   - "common-psm1"
	//   - "k8s-node-setup-psm1"
	//   - "install-ssh-psm1"
	//   - "user-profile-psm1"
	//
	// Values are free-form strings, and only have meaning as interpreted by
	// the image running in the instance. The only restriction placed on them is
	// that each value's size must be less than or equal to 32 KB.
	//
	// The total size of all keys and values must be less than 512 KB.
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The image type to use for this node. Note that for a given image type,
	// the latest version of it will be used. Please see
	// https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
	// available image types.
	ImageType string `protobuf:"bytes,5,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// The map of Kubernetes labels (key/value pairs) to be applied to each node.
	// These will added in addition to any default label(s) that
	// Kubernetes may apply to the node.
	// In case of conflict in label keys, the applied set may differ depending on
	// the Kubernetes version -- it's best to assume the behavior is undefined
	// and conflicts should be avoided.
	// For more information, including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The number of local SSD disks to be attached to the node.
	//
	// The limit for this value is dependent upon the maximum number of
	// disks available on a machine per zone. See:
	// https://cloud.google.com/compute/docs/disks/local-ssd
	// for more information.
	LocalSsdCount int32 `protobuf:"varint,7,opt,name=local_ssd_count,json=localSsdCount,proto3" json:"local_ssd_count,omitempty"`
	// The list of instance tags applied to all nodes. Tags are used to identify
	// valid sources or targets for network firewalls and are specified by
	// the client during cluster or node pool creation. Each tag within the list
	// must comply with RFC1035.
	Tags []string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	// Whether the nodes are created as preemptible VM instances. See:
	// https://cloud.google.com/compute/docs/instances/preemptible for more
	// information about preemptible VM instances.
	Preemptible bool `protobuf:"varint,10,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
	// A list of hardware accelerators to be attached to each node.
	// See https://cloud.google.com/compute/docs/gpus for more information about
	// support for GPUs.
	Accelerators []*AcceleratorConfig `protobuf:"bytes,11,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
	// Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
	// 'pd-balanced')
	//
	// If unspecified, the default disk type is 'pd-standard'
	DiskType string `protobuf:"bytes,12,opt,name=disk_type,json=diskType,proto3" json:"disk_type,omitempty"`
	// Minimum CPU platform to be used by this instance. The instance may be
	// scheduled on the specified or newer CPU platform. Applicable values are the
	// friendly names of CPU platforms, such as
	// `minCpuPlatform: "Intel Haswell"` or
	// `minCpuPlatform: "Intel Sandy Bridge"`. For more
	// information, read [how to specify min CPU
	// platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
	MinCpuPlatform string `protobuf:"bytes,13,opt,name=min_cpu_platform,json=minCpuPlatform,proto3" json:"min_cpu_platform,omitempty"`
	// The workload metadata configuration for this node.
	WorkloadMetadataConfig *WorkloadMetadataConfig `protobuf:"bytes,14,opt,name=workload_metadata_config,json=workloadMetadataConfig,proto3" json:"workload_metadata_config,omitempty"`
	// List of kubernetes taints to be applied to each node.
	//
	// For more information, including usage and the valid values, see:
	// https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
	Taints []*NodeTaint `protobuf:"bytes,15,rep,name=taints,proto3" json:"taints,omitempty"`
	// Sandbox configuration for this node.
	SandboxConfig *SandboxConfig `protobuf:"bytes,17,opt,name=sandbox_config,json=sandboxConfig,proto3" json:"sandbox_config,omitempty"`
	// Setting this field will assign instances of this
	// pool to run on the specified node group. This is useful for running
	// workloads on [sole tenant
	// nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
	NodeGroup string `protobuf:"bytes,18,opt,name=node_group,json=nodeGroup,proto3" json:"node_group,omitempty"`
	// The optional reservation affinity. Setting this field will apply
	// the specified [Zonal Compute
	// Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
	// to this node pool.
	ReservationAffinity *ReservationAffinity `protobuf:"bytes,19,opt,name=reservation_affinity,json=reservationAffinity,proto3" json:"reservation_affinity,omitempty"`
	// Shielded Instance options.
	ShieldedInstanceConfig *ShieldedInstanceConfig `protobuf:"bytes,20,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3" json:"shielded_instance_config,omitempty"`
	// Parameters that can be configured on Linux nodes.
	LinuxNodeConfig *LinuxNodeConfig `protobuf:"bytes,21,opt,name=linux_node_config,json=linuxNodeConfig,proto3" json:"linux_node_config,omitempty"`
	// Node kubelet configs.
	KubeletConfig *NodeKubeletConfig `protobuf:"bytes,22,opt,name=kubelet_config,json=kubeletConfig,proto3" json:"kubelet_config,omitempty"`
	// The Customer Managed Encryption Key used to encrypt the boot disk attached
	// to each node in the node pool. This should be of the form
	// projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
	// For more information about protecting resources with Cloud KMS Keys please
	// see:
	// https://cloud.google.com/compute/docs/disks/customer-managed-encryption
	BootDiskKmsKey string `protobuf:"bytes,23,opt,name=boot_disk_kms_key,json=bootDiskKmsKey,proto3" json:"boot_disk_kms_key,omitempty"`
	// Google Container File System (image streaming) configs.
	GcfsConfig *GcfsConfig `protobuf:"bytes,25,opt,name=gcfs_config,json=gcfsConfig,proto3" json:"gcfs_config,omitempty"`
	// Advanced features for the Compute Engine VM.
	AdvancedMachineFeatures *AdvancedMachineFeatures `protobuf:"bytes,26,opt,name=advanced_machine_features,json=advancedMachineFeatures,proto3" json:"advanced_machine_features,omitempty"`
	// Enable or disable gvnic in the node pool.
	Gvnic *VirtualNIC `protobuf:"bytes,29,opt,name=gvnic,proto3" json:"gvnic,omitempty"`
	// Spot flag for enabling Spot VM, which is a rebrand of
	// the existing preemptible flag.
	Spot bool `protobuf:"varint,32,opt,name=spot,proto3" json:"spot,omitempty"`
	// Confidential nodes config.
	// All the nodes in the node pool will be Confidential VM once enabled.
	ConfidentialNodes *ConfidentialNodes `protobuf:"bytes,35,opt,name=confidential_nodes,json=confidentialNodes,proto3" json:"confidential_nodes,omitempty"`
	// Enable or disable NCCL fast socket for the node pool.
	FastSocket *FastSocket `protobuf:"bytes,36,opt,name=fast_socket,json=fastSocket,proto3,oneof" json:"fast_socket,omitempty"`
	// The resource labels for the node pool to use to annotate any related
	// Google Compute Engine resources.
	ResourceLabels map[string]string `protobuf:"bytes,37,rep,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Logging configuration.
	LoggingConfig *NodePoolLoggingConfig `protobuf:"bytes,38,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Parameters that can be configured on Windows nodes.
	WindowsNodeConfig *WindowsNodeConfig `protobuf:"bytes,39,opt,name=windows_node_config,json=windowsNodeConfig,proto3" json:"windows_node_config,omitempty"`
	// Parameters for using raw-block Local NVMe SSDs.
	LocalNvmeSsdBlockConfig *LocalNvmeSsdBlockConfig `protobuf:"bytes,40,opt,name=local_nvme_ssd_block_config,json=localNvmeSsdBlockConfig,proto3" json:"local_nvme_ssd_block_config,omitempty"`
	// Parameters for the node ephemeral storage using Local SSDs.
	// If unspecified, ephemeral storage is backed by the boot disk.
	EphemeralStorageLocalSsdConfig *EphemeralStorageLocalSsdConfig `protobuf:"bytes,41,opt,name=ephemeral_storage_local_ssd_config,json=ephemeralStorageLocalSsdConfig,proto3" json:"ephemeral_storage_local_ssd_config,omitempty"`
	// Parameters for node pools to be backed by shared sole tenant node groups.
	SoleTenantConfig *SoleTenantConfig `protobuf:"bytes,42,opt,name=sole_tenant_config,json=soleTenantConfig,proto3" json:"sole_tenant_config,omitempty"`
	// Parameters for containerd customization.
	ContainerdConfig *ContainerdConfig `protobuf:"bytes,43,opt,name=containerd_config,json=containerdConfig,proto3" json:"containerd_config,omitempty"`
	// A map of resource manager tag keys and values to be attached to the nodes.
	ResourceManagerTags *ResourceManagerTags `protobuf:"bytes,45,opt,name=resource_manager_tags,json=resourceManagerTags,proto3" json:"resource_manager_tags,omitempty"`
	// Optional. Reserved for future use.
	EnableConfidentialStorage bool `protobuf:"varint,46,opt,name=enable_confidential_storage,json=enableConfidentialStorage,proto3" json:"enable_confidential_storage,omitempty"`
	// List of secondary boot disks attached to the nodes.
	SecondaryBootDisks []*SecondaryBootDisk `protobuf:"bytes,48,rep,name=secondary_boot_disks,json=secondaryBootDisks,proto3" json:"secondary_boot_disks,omitempty"`
	// List of Storage Pools where boot disks are provisioned.
	StoragePools []string `protobuf:"bytes,49,rep,name=storage_pools,json=storagePools,proto3" json:"storage_pools,omitempty"`
	// Secondary boot disk update strategy.
	SecondaryBootDiskUpdateStrategy *SecondaryBootDiskUpdateStrategy `protobuf:"bytes,50,opt,name=secondary_boot_disk_update_strategy,json=secondaryBootDiskUpdateStrategy,proto3,oneof" json:"secondary_boot_disk_update_strategy,omitempty"`
	// Specifies which method should be used for encrypting the
	// Local SSDs attahced to the node.
	LocalSsdEncryptionMode *NodeConfig_LocalSsdEncryptionMode `protobuf:"varint,54,opt,name=local_ssd_encryption_mode,json=localSsdEncryptionMode,proto3,enum=google.container.v1.NodeConfig_LocalSsdEncryptionMode,oneof" json:"local_ssd_encryption_mode,omitempty"`
	// Output only. effective_cgroup_mode is the cgroup mode actually used by the
	// node pool. It is determined by the cgroup mode specified in the
	// LinuxNodeConfig or the default cgroup mode based on the cluster creation
	// version.
	EffectiveCgroupMode NodeConfig_EffectiveCgroupMode `protobuf:"varint,55,opt,name=effective_cgroup_mode,json=effectiveCgroupMode,proto3,enum=google.container.v1.NodeConfig_EffectiveCgroupMode" json:"effective_cgroup_mode,omitempty"`
}

func (x *NodeConfig) Reset() {
	*x = NodeConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeConfig) ProtoMessage() {}

func (x *NodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeConfig.ProtoReflect.Descriptor instead.
func (*NodeConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{3}
}

func (x *NodeConfig) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *NodeConfig) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *NodeConfig) GetOauthScopes() []string {
	if x != nil {
		return x.OauthScopes
	}
	return nil
}

func (x *NodeConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *NodeConfig) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *NodeConfig) GetImageType() string {
	if x != nil {
		return x.ImageType
	}
	return ""
}

func (x *NodeConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *NodeConfig) GetLocalSsdCount() int32 {
	if x != nil {
		return x.LocalSsdCount
	}
	return 0
}

func (x *NodeConfig) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *NodeConfig) GetPreemptible() bool {
	if x != nil {
		return x.Preemptible
	}
	return false
}

func (x *NodeConfig) GetAccelerators() []*AcceleratorConfig {
	if x != nil {
		return x.Accelerators
	}
	return nil
}

func (x *NodeConfig) GetDiskType() string {
	if x != nil {
		return x.DiskType
	}
	return ""
}

func (x *NodeConfig) GetMinCpuPlatform() string {
	if x != nil {
		return x.MinCpuPlatform
	}
	return ""
}

func (x *NodeConfig) GetWorkloadMetadataConfig() *WorkloadMetadataConfig {
	if x != nil {
		return x.WorkloadMetadataConfig
	}
	return nil
}

func (x *NodeConfig) GetTaints() []*NodeTaint {
	if x != nil {
		return x.Taints
	}
	return nil
}

func (x *NodeConfig) GetSandboxConfig() *SandboxConfig {
	if x != nil {
		return x.SandboxConfig
	}
	return nil
}

func (x *NodeConfig) GetNodeGroup() string {
	if x != nil {
		return x.NodeGroup
	}
	return ""
}

func (x *NodeConfig) GetReservationAffinity() *ReservationAffinity {
	if x != nil {
		return x.ReservationAffinity
	}
	return nil
}

func (x *NodeConfig) GetShieldedInstanceConfig() *ShieldedInstanceConfig {
	if x != nil {
		return x.ShieldedInstanceConfig
	}
	return nil
}

func (x *NodeConfig) GetLinuxNodeConfig() *LinuxNodeConfig {
	if x != nil {
		return x.LinuxNodeConfig
	}
	return nil
}

func (x *NodeConfig) GetKubeletConfig() *NodeKubeletConfig {
	if x != nil {
		return x.KubeletConfig
	}
	return nil
}

func (x *NodeConfig) GetBootDiskKmsKey() string {
	if x != nil {
		return x.BootDiskKmsKey
	}
	return ""
}

func (x *NodeConfig) GetGcfsConfig() *GcfsConfig {
	if x != nil {
		return x.GcfsConfig
	}
	return nil
}

func (x *NodeConfig) GetAdvancedMachineFeatures() *AdvancedMachineFeatures {
	if x != nil {
		return x.AdvancedMachineFeatures
	}
	return nil
}

func (x *NodeConfig) GetGvnic() *VirtualNIC {
	if x != nil {
		return x.Gvnic
	}
	return nil
}

func (x *NodeConfig) GetSpot() bool {
	if x != nil {
		return x.Spot
	}
	return false
}

func (x *NodeConfig) GetConfidentialNodes() *ConfidentialNodes {
	if x != nil {
		return x.ConfidentialNodes
	}
	return nil
}

func (x *NodeConfig) GetFastSocket() *FastSocket {
	if x != nil {
		return x.FastSocket
	}
	return nil
}

func (x *NodeConfig) GetResourceLabels() map[string]string {
	if x != nil {
		return x.ResourceLabels
	}
	return nil
}

func (x *NodeConfig) GetLoggingConfig() *NodePoolLoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *NodeConfig) GetWindowsNodeConfig() *WindowsNodeConfig {
	if x != nil {
		return x.WindowsNodeConfig
	}
	return nil
}

func (x *NodeConfig) GetLocalNvmeSsdBlockConfig() *LocalNvmeSsdBlockConfig {
	if x != nil {
		return x.LocalNvmeSsdBlockConfig
	}
	return nil
}

func (x *NodeConfig) GetEphemeralStorageLocalSsdConfig() *EphemeralStorageLocalSsdConfig {
	if x != nil {
		return x.EphemeralStorageLocalSsdConfig
	}
	return nil
}

func (x *NodeConfig) GetSoleTenantConfig() *SoleTenantConfig {
	if x != nil {
		return x.SoleTenantConfig
	}
	return nil
}

func (x *NodeConfig) GetContainerdConfig() *ContainerdConfig {
	if x != nil {
		return x.ContainerdConfig
	}
	return nil
}

func (x *NodeConfig) GetResourceManagerTags() *ResourceManagerTags {
	if x != nil {
		return x.ResourceManagerTags
	}
	return nil
}

func (x *NodeConfig) GetEnableConfidentialStorage() bool {
	if x != nil {
		return x.EnableConfidentialStorage
	}
	return false
}

func (x *NodeConfig) GetSecondaryBootDisks() []*SecondaryBootDisk {
	if x != nil {
		return x.SecondaryBootDisks
	}
	return nil
}

func (x *NodeConfig) GetStoragePools() []string {
	if x != nil {
		return x.StoragePools
	}
	return nil
}

func (x *NodeConfig) GetSecondaryBootDiskUpdateStrategy() *SecondaryBootDiskUpdateStrategy {
	if x != nil {
		return x.SecondaryBootDiskUpdateStrategy
	}
	return nil
}

func (x *NodeConfig) GetLocalSsdEncryptionMode() NodeConfig_LocalSsdEncryptionMode {
	if x != nil && x.LocalSsdEncryptionMode != nil {
		return *x.LocalSsdEncryptionMode
	}
	return NodeConfig_LOCAL_SSD_ENCRYPTION_MODE_UNSPECIFIED
}

func (x *NodeConfig) GetEffectiveCgroupMode() NodeConfig_EffectiveCgroupMode {
	if x != nil {
		return x.EffectiveCgroupMode
	}
	return NodeConfig_EFFECTIVE_CGROUP_MODE_UNSPECIFIED
}

// Specifies options for controlling advanced machine features.
type AdvancedMachineFeatures struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of threads per physical core. To disable simultaneous
	// multithreading (SMT) set this to 1. If unset, the maximum number of threads
	// supported per core by the underlying processor is assumed.
	ThreadsPerCore *int64 `protobuf:"varint,1,opt,name=threads_per_core,json=threadsPerCore,proto3,oneof" json:"threads_per_core,omitempty"`
	// Whether or not to enable nested virtualization (defaults to false).
	EnableNestedVirtualization *bool `protobuf:"varint,2,opt,name=enable_nested_virtualization,json=enableNestedVirtualization,proto3,oneof" json:"enable_nested_virtualization,omitempty"`
}

func (x *AdvancedMachineFeatures) Reset() {
	*x = AdvancedMachineFeatures{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedMachineFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedMachineFeatures) ProtoMessage() {}

func (x *AdvancedMachineFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedMachineFeatures.ProtoReflect.Descriptor instead.
func (*AdvancedMachineFeatures) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{4}
}

func (x *AdvancedMachineFeatures) GetThreadsPerCore() int64 {
	if x != nil && x.ThreadsPerCore != nil {
		return *x.ThreadsPerCore
	}
	return 0
}

func (x *AdvancedMachineFeatures) GetEnableNestedVirtualization() bool {
	if x != nil && x.EnableNestedVirtualization != nil {
		return *x.EnableNestedVirtualization
	}
	return false
}

// Parameters for node pool-level network config.
type NodeNetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input only. Whether to create a new range for pod IPs in this node pool.
	// Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they
	// are not specified.
	//
	// If neither `create_pod_range` or `pod_range` are specified, the
	// cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is
	// used.
	//
	// Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
	//
	// This field cannot be changed after the node pool has been created.
	CreatePodRange bool `protobuf:"varint,4,opt,name=create_pod_range,json=createPodRange,proto3" json:"create_pod_range,omitempty"`
	// The ID of the secondary range for pod IPs.
	// If `create_pod_range` is true, this ID is used for the new range.
	// If `create_pod_range` is false, uses an existing secondary range with this
	// ID.
	//
	// Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
	//
	// This field cannot be changed after the node pool has been created.
	PodRange string `protobuf:"bytes,5,opt,name=pod_range,json=podRange,proto3" json:"pod_range,omitempty"`
	// The IP address range for pod IPs in this node pool.
	//
	// Only applicable if `create_pod_range` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) to pick a specific range to use.
	//
	// Only applicable if `ip_allocation_policy.use_ip_aliases` is true.
	//
	// This field cannot be changed after the node pool has been created.
	PodIpv4CidrBlock string `protobuf:"bytes,6,opt,name=pod_ipv4_cidr_block,json=podIpv4CidrBlock,proto3" json:"pod_ipv4_cidr_block,omitempty"`
	// Whether nodes have internal IP addresses only.
	// If enable_private_nodes is not specified, then the value is derived from
	// [Cluster.NetworkConfig.default_enable_private_nodes][]
	EnablePrivateNodes *bool `protobuf:"varint,9,opt,name=enable_private_nodes,json=enablePrivateNodes,proto3,oneof" json:"enable_private_nodes,omitempty"`
	// Network bandwidth tier configuration.
	NetworkPerformanceConfig *NodeNetworkConfig_NetworkPerformanceConfig `protobuf:"bytes,11,opt,name=network_performance_config,json=networkPerformanceConfig,proto3,oneof" json:"network_performance_config,omitempty"`
	// [PRIVATE FIELD]
	// Pod CIDR size overprovisioning config for the nodepool.
	//
	// Pod CIDR size per node depends on max_pods_per_node. By default, the value
	// of max_pods_per_node is rounded off to next power of 2 and we then double
	// that to get the size of pod CIDR block per node.
	// Example: max_pods_per_node of 30 would result in 64 IPs (/26).
	//
	// This config can disable the doubling of IPs (we still round off to next
	// power of 2)
	// Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
	// overprovisioning is disabled.
	PodCidrOverprovisionConfig *PodCIDROverprovisionConfig `protobuf:"bytes,13,opt,name=pod_cidr_overprovision_config,json=podCidrOverprovisionConfig,proto3" json:"pod_cidr_overprovision_config,omitempty"`
	// We specify the additional node networks for this node pool using this list.
	// Each node network corresponds to an additional interface
	AdditionalNodeNetworkConfigs []*AdditionalNodeNetworkConfig `protobuf:"bytes,14,rep,name=additional_node_network_configs,json=additionalNodeNetworkConfigs,proto3" json:"additional_node_network_configs,omitempty"`
	// We specify the additional pod networks for this node pool using this list.
	// Each pod network corresponds to an additional alias IP range for the node
	AdditionalPodNetworkConfigs []*AdditionalPodNetworkConfig `protobuf:"bytes,15,rep,name=additional_pod_network_configs,json=additionalPodNetworkConfigs,proto3" json:"additional_pod_network_configs,omitempty"`
	// Output only. The utilization of the IPv4 range for the pod.
	// The ratio is Usage/[Total number of IPs in the secondary range],
	// Usage=numNodes*numZones*podIPsPerNode.
	PodIpv4RangeUtilization float64 `protobuf:"fixed64,16,opt,name=pod_ipv4_range_utilization,json=podIpv4RangeUtilization,proto3" json:"pod_ipv4_range_utilization,omitempty"`
}

func (x *NodeNetworkConfig) Reset() {
	*x = NodeNetworkConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeNetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeNetworkConfig) ProtoMessage() {}

func (x *NodeNetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeNetworkConfig.ProtoReflect.Descriptor instead.
func (*NodeNetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{5}
}

func (x *NodeNetworkConfig) GetCreatePodRange() bool {
	if x != nil {
		return x.CreatePodRange
	}
	return false
}

func (x *NodeNetworkConfig) GetPodRange() string {
	if x != nil {
		return x.PodRange
	}
	return ""
}

func (x *NodeNetworkConfig) GetPodIpv4CidrBlock() string {
	if x != nil {
		return x.PodIpv4CidrBlock
	}
	return ""
}

func (x *NodeNetworkConfig) GetEnablePrivateNodes() bool {
	if x != nil && x.EnablePrivateNodes != nil {
		return *x.EnablePrivateNodes
	}
	return false
}

func (x *NodeNetworkConfig) GetNetworkPerformanceConfig() *NodeNetworkConfig_NetworkPerformanceConfig {
	if x != nil {
		return x.NetworkPerformanceConfig
	}
	return nil
}

func (x *NodeNetworkConfig) GetPodCidrOverprovisionConfig() *PodCIDROverprovisionConfig {
	if x != nil {
		return x.PodCidrOverprovisionConfig
	}
	return nil
}

func (x *NodeNetworkConfig) GetAdditionalNodeNetworkConfigs() []*AdditionalNodeNetworkConfig {
	if x != nil {
		return x.AdditionalNodeNetworkConfigs
	}
	return nil
}

func (x *NodeNetworkConfig) GetAdditionalPodNetworkConfigs() []*AdditionalPodNetworkConfig {
	if x != nil {
		return x.AdditionalPodNetworkConfigs
	}
	return nil
}

func (x *NodeNetworkConfig) GetPodIpv4RangeUtilization() float64 {
	if x != nil {
		return x.PodIpv4RangeUtilization
	}
	return 0
}

// AdditionalNodeNetworkConfig is the configuration for additional node networks
// within the NodeNetworkConfig message
type AdditionalNodeNetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the VPC where the additional interface belongs
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Name of the subnetwork where the additional interface belongs
	Subnetwork string `protobuf:"bytes,2,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
}

func (x *AdditionalNodeNetworkConfig) Reset() {
	*x = AdditionalNodeNetworkConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdditionalNodeNetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdditionalNodeNetworkConfig) ProtoMessage() {}

func (x *AdditionalNodeNetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdditionalNodeNetworkConfig.ProtoReflect.Descriptor instead.
func (*AdditionalNodeNetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{6}
}

func (x *AdditionalNodeNetworkConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *AdditionalNodeNetworkConfig) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

// AdditionalPodNetworkConfig is the configuration for additional pod networks
// within the NodeNetworkConfig message
type AdditionalPodNetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the subnetwork where the additional pod network belongs.
	Subnetwork string `protobuf:"bytes,1,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// The name of the secondary range on the subnet which provides IP address for
	// this pod range.
	SecondaryPodRange string `protobuf:"bytes,2,opt,name=secondary_pod_range,json=secondaryPodRange,proto3" json:"secondary_pod_range,omitempty"`
	// The maximum number of pods per node which use this pod network.
	MaxPodsPerNode *MaxPodsConstraint `protobuf:"bytes,3,opt,name=max_pods_per_node,json=maxPodsPerNode,proto3,oneof" json:"max_pods_per_node,omitempty"`
}

func (x *AdditionalPodNetworkConfig) Reset() {
	*x = AdditionalPodNetworkConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdditionalPodNetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdditionalPodNetworkConfig) ProtoMessage() {}

func (x *AdditionalPodNetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdditionalPodNetworkConfig.ProtoReflect.Descriptor instead.
func (*AdditionalPodNetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{7}
}

func (x *AdditionalPodNetworkConfig) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *AdditionalPodNetworkConfig) GetSecondaryPodRange() string {
	if x != nil {
		return x.SecondaryPodRange
	}
	return ""
}

func (x *AdditionalPodNetworkConfig) GetMaxPodsPerNode() *MaxPodsConstraint {
	if x != nil {
		return x.MaxPodsPerNode
	}
	return nil
}

// A set of Shielded Instance options.
type ShieldedInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines whether the instance has Secure Boot enabled.
	//
	// Secure Boot helps ensure that the system only runs authentic software by
	// verifying the digital signature of all boot components, and halting the
	// boot process if signature verification fails.
	EnableSecureBoot bool `protobuf:"varint,1,opt,name=enable_secure_boot,json=enableSecureBoot,proto3" json:"enable_secure_boot,omitempty"`
	// Defines whether the instance has integrity monitoring enabled.
	//
	// Enables monitoring and attestation of the boot integrity of the instance.
	// The attestation is performed against the integrity policy baseline. This
	// baseline is initially derived from the implicitly trusted boot image when
	// the instance is created.
	EnableIntegrityMonitoring bool `protobuf:"varint,2,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3" json:"enable_integrity_monitoring,omitempty"`
}

func (x *ShieldedInstanceConfig) Reset() {
	*x = ShieldedInstanceConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShieldedInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShieldedInstanceConfig) ProtoMessage() {}

func (x *ShieldedInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShieldedInstanceConfig.ProtoReflect.Descriptor instead.
func (*ShieldedInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{8}
}

func (x *ShieldedInstanceConfig) GetEnableSecureBoot() bool {
	if x != nil {
		return x.EnableSecureBoot
	}
	return false
}

func (x *ShieldedInstanceConfig) GetEnableIntegrityMonitoring() bool {
	if x != nil {
		return x.EnableIntegrityMonitoring
	}
	return false
}

// SandboxConfig contains configurations of the sandbox to use for the node.
type SandboxConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the sandbox to use for the node.
	Type SandboxConfig_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.container.v1.SandboxConfig_Type" json:"type,omitempty"`
}

func (x *SandboxConfig) Reset() {
	*x = SandboxConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SandboxConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SandboxConfig) ProtoMessage() {}

func (x *SandboxConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SandboxConfig.ProtoReflect.Descriptor instead.
func (*SandboxConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{9}
}

func (x *SandboxConfig) GetType() SandboxConfig_Type {
	if x != nil {
		return x.Type
	}
	return SandboxConfig_UNSPECIFIED
}

// GcfsConfig contains configurations of Google Container File System
// (image streaming).
type GcfsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to use GCFS.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *GcfsConfig) Reset() {
	*x = GcfsConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcfsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcfsConfig) ProtoMessage() {}

func (x *GcfsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcfsConfig.ProtoReflect.Descriptor instead.
func (*GcfsConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{10}
}

func (x *GcfsConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// [ReservationAffinity](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)
// is the configuration of desired reservation which instances could take
// capacity from.
type ReservationAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Corresponds to the type of reservation consumption.
	ConsumeReservationType ReservationAffinity_Type `protobuf:"varint,1,opt,name=consume_reservation_type,json=consumeReservationType,proto3,enum=google.container.v1.ReservationAffinity_Type" json:"consume_reservation_type,omitempty"`
	// Corresponds to the label key of a reservation resource. To target a
	// SPECIFIC_RESERVATION by name, specify
	// "compute.googleapis.com/reservation-name" as the key and specify the name
	// of your reservation as its value.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// Corresponds to the label value(s) of reservation resource(s).
	Values []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ReservationAffinity) Reset() {
	*x = ReservationAffinity{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReservationAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReservationAffinity) ProtoMessage() {}

func (x *ReservationAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReservationAffinity.ProtoReflect.Descriptor instead.
func (*ReservationAffinity) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{11}
}

func (x *ReservationAffinity) GetConsumeReservationType() ReservationAffinity_Type {
	if x != nil {
		return x.ConsumeReservationType
	}
	return ReservationAffinity_UNSPECIFIED
}

func (x *ReservationAffinity) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *ReservationAffinity) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// SoleTenantConfig contains the NodeAffinities to specify what shared sole
// tenant node groups should back the node pool.
type SoleTenantConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// NodeAffinities used to match to a shared sole tenant node group.
	NodeAffinities []*SoleTenantConfig_NodeAffinity `protobuf:"bytes,1,rep,name=node_affinities,json=nodeAffinities,proto3" json:"node_affinities,omitempty"`
}

func (x *SoleTenantConfig) Reset() {
	*x = SoleTenantConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SoleTenantConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoleTenantConfig) ProtoMessage() {}

func (x *SoleTenantConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoleTenantConfig.ProtoReflect.Descriptor instead.
func (*SoleTenantConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{12}
}

func (x *SoleTenantConfig) GetNodeAffinities() []*SoleTenantConfig_NodeAffinity {
	if x != nil {
		return x.NodeAffinities
	}
	return nil
}

// ContainerdConfig contains configuration to customize containerd.
type ContainerdConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PrivateRegistryAccessConfig is used to configure access configuration
	// for private container registries.
	PrivateRegistryAccessConfig *ContainerdConfig_PrivateRegistryAccessConfig `protobuf:"bytes,1,opt,name=private_registry_access_config,json=privateRegistryAccessConfig,proto3" json:"private_registry_access_config,omitempty"`
}

func (x *ContainerdConfig) Reset() {
	*x = ContainerdConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerdConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerdConfig) ProtoMessage() {}

func (x *ContainerdConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerdConfig.ProtoReflect.Descriptor instead.
func (*ContainerdConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{13}
}

func (x *ContainerdConfig) GetPrivateRegistryAccessConfig() *ContainerdConfig_PrivateRegistryAccessConfig {
	if x != nil {
		return x.PrivateRegistryAccessConfig
	}
	return nil
}

// Kubernetes taint is composed of three fields: key, value, and effect. Effect
// can only be one of three types:  NoSchedule, PreferNoSchedule or NoExecute.
//
// See
// [here](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration)
// for more information, including usage and the valid values.
type NodeTaint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key for taint.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value for taint.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Effect for taint.
	Effect NodeTaint_Effect `protobuf:"varint,3,opt,name=effect,proto3,enum=google.container.v1.NodeTaint_Effect" json:"effect,omitempty"`
}

func (x *NodeTaint) Reset() {
	*x = NodeTaint{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeTaint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeTaint) ProtoMessage() {}

func (x *NodeTaint) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeTaint.ProtoReflect.Descriptor instead.
func (*NodeTaint) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{14}
}

func (x *NodeTaint) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *NodeTaint) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *NodeTaint) GetEffect() NodeTaint_Effect {
	if x != nil {
		return x.Effect
	}
	return NodeTaint_EFFECT_UNSPECIFIED
}

// Collection of Kubernetes [node
// taints](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration).
type NodeTaints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of node taints.
	Taints []*NodeTaint `protobuf:"bytes,1,rep,name=taints,proto3" json:"taints,omitempty"`
}

func (x *NodeTaints) Reset() {
	*x = NodeTaints{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeTaints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeTaints) ProtoMessage() {}

func (x *NodeTaints) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeTaints.ProtoReflect.Descriptor instead.
func (*NodeTaints) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{15}
}

func (x *NodeTaints) GetTaints() []*NodeTaint {
	if x != nil {
		return x.Taints
	}
	return nil
}

// Collection of node-level [Kubernetes
// labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels).
type NodeLabels struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of node label keys and node label values.
	Labels map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *NodeLabels) Reset() {
	*x = NodeLabels{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeLabels) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeLabels) ProtoMessage() {}

func (x *NodeLabels) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeLabels.ProtoReflect.Descriptor instead.
func (*NodeLabels) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{16}
}

func (x *NodeLabels) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Collection of [GCP
// labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels).
type ResourceLabels struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Map of node label keys and node label values.
	Labels map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ResourceLabels) Reset() {
	*x = ResourceLabels{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceLabels) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceLabels) ProtoMessage() {}

func (x *ResourceLabels) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceLabels.ProtoReflect.Descriptor instead.
func (*ResourceLabels) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{17}
}

func (x *ResourceLabels) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Collection of Compute Engine network tags that can be applied to a node's
// underlying VM instance.
type NetworkTags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of network tags.
	Tags []string `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *NetworkTags) Reset() {
	*x = NetworkTags{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkTags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkTags) ProtoMessage() {}

func (x *NetworkTags) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkTags.ProtoReflect.Descriptor instead.
func (*NetworkTags) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{18}
}

func (x *NetworkTags) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// The authentication information for accessing the master endpoint.
// Authentication can be done using HTTP basic auth or using client
// certificates.
type MasterAuth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The username to use for HTTP basic authentication to the master endpoint.
	// For clusters v1.6.0 and later, basic authentication can be disabled by
	// leaving username unspecified (or setting it to the empty string).
	//
	// Warning: basic authentication is deprecated, and will be removed in GKE
	// control plane versions 1.19 and newer. For a list of recommended
	// authentication methods, see:
	// https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// The password to use for HTTP basic authentication to the master endpoint.
	// Because the master endpoint is open to the Internet, you should create a
	// strong password.  If a password is provided for cluster creation, username
	// must be non-empty.
	//
	// Warning: basic authentication is deprecated, and will be removed in GKE
	// control plane versions 1.19 and newer. For a list of recommended
	// authentication methods, see:
	// https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// Configuration for client certificate authentication on the cluster. For
	// clusters before v1.12, if no configuration is specified, a client
	// certificate is issued.
	ClientCertificateConfig *ClientCertificateConfig `protobuf:"bytes,3,opt,name=client_certificate_config,json=clientCertificateConfig,proto3" json:"client_certificate_config,omitempty"`
	// Output only. Base64-encoded public certificate that is the root of
	// trust for the cluster.
	ClusterCaCertificate string `protobuf:"bytes,100,opt,name=cluster_ca_certificate,json=clusterCaCertificate,proto3" json:"cluster_ca_certificate,omitempty"`
	// Output only. Base64-encoded public certificate used by clients to
	// authenticate to the cluster endpoint. Issued only if
	// client_certificate_config is set.
	ClientCertificate string `protobuf:"bytes,101,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// Output only. Base64-encoded private key used by clients to authenticate
	// to the cluster endpoint.
	ClientKey string `protobuf:"bytes,102,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
}

func (x *MasterAuth) Reset() {
	*x = MasterAuth{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MasterAuth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuth) ProtoMessage() {}

func (x *MasterAuth) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuth.ProtoReflect.Descriptor instead.
func (*MasterAuth) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{19}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *MasterAuth) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *MasterAuth) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *MasterAuth) GetClientCertificateConfig() *ClientCertificateConfig {
	if x != nil {
		return x.ClientCertificateConfig
	}
	return nil
}

func (x *MasterAuth) GetClusterCaCertificate() string {
	if x != nil {
		return x.ClusterCaCertificate
	}
	return ""
}

func (x *MasterAuth) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *MasterAuth) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

// Configuration for client certificates on the cluster.
type ClientCertificateConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Issue a client certificate.
	IssueClientCertificate bool `protobuf:"varint,1,opt,name=issue_client_certificate,json=issueClientCertificate,proto3" json:"issue_client_certificate,omitempty"`
}

func (x *ClientCertificateConfig) Reset() {
	*x = ClientCertificateConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClientCertificateConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientCertificateConfig) ProtoMessage() {}

func (x *ClientCertificateConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientCertificateConfig.ProtoReflect.Descriptor instead.
func (*ClientCertificateConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{20}
}

func (x *ClientCertificateConfig) GetIssueClientCertificate() bool {
	if x != nil {
		return x.IssueClientCertificate
	}
	return false
}

// Configuration for the addons that can be automatically spun up in the
// cluster, enabling additional functionality.
type AddonsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for the HTTP (L7) load balancing controller addon, which
	// makes it easy to set up HTTP load balancers for services in a cluster.
	HttpLoadBalancing *HttpLoadBalancing `protobuf:"bytes,1,opt,name=http_load_balancing,json=httpLoadBalancing,proto3" json:"http_load_balancing,omitempty"`
	// Configuration for the horizontal pod autoscaling feature, which
	// increases or decreases the number of replica pods a replication controller
	// has based on the resource usage of the existing pods.
	HorizontalPodAutoscaling *HorizontalPodAutoscaling `protobuf:"bytes,2,opt,name=horizontal_pod_autoscaling,json=horizontalPodAutoscaling,proto3" json:"horizontal_pod_autoscaling,omitempty"`
	// Configuration for the Kubernetes Dashboard.
	// This addon is deprecated, and will be disabled in 1.15. It is recommended
	// to use the Cloud Console to manage and monitor your Kubernetes clusters,
	// workloads and applications. For more information, see:
	// https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	KubernetesDashboard *KubernetesDashboard `protobuf:"bytes,3,opt,name=kubernetes_dashboard,json=kubernetesDashboard,proto3" json:"kubernetes_dashboard,omitempty"`
	// Configuration for NetworkPolicy. This only tracks whether the addon
	// is enabled or not on the Master, it does not track whether network policy
	// is enabled for the nodes.
	NetworkPolicyConfig *NetworkPolicyConfig `protobuf:"bytes,4,opt,name=network_policy_config,json=networkPolicyConfig,proto3" json:"network_policy_config,omitempty"`
	// Configuration for the Cloud Run addon, which allows the user to use a
	// managed Knative service.
	CloudRunConfig *CloudRunConfig `protobuf:"bytes,7,opt,name=cloud_run_config,json=cloudRunConfig,proto3" json:"cloud_run_config,omitempty"`
	// Configuration for NodeLocalDNS, a dns cache running on cluster nodes
	DnsCacheConfig *DnsCacheConfig `protobuf:"bytes,8,opt,name=dns_cache_config,json=dnsCacheConfig,proto3" json:"dns_cache_config,omitempty"`
	// Configuration for the ConfigConnector add-on, a Kubernetes
	// extension to manage hosted GCP services through the Kubernetes API
	ConfigConnectorConfig *ConfigConnectorConfig `protobuf:"bytes,10,opt,name=config_connector_config,json=configConnectorConfig,proto3" json:"config_connector_config,omitempty"`
	// Configuration for the Compute Engine Persistent Disk CSI driver.
	GcePersistentDiskCsiDriverConfig *GcePersistentDiskCsiDriverConfig `protobuf:"bytes,11,opt,name=gce_persistent_disk_csi_driver_config,json=gcePersistentDiskCsiDriverConfig,proto3" json:"gce_persistent_disk_csi_driver_config,omitempty"`
	// Configuration for the GCP Filestore CSI driver.
	GcpFilestoreCsiDriverConfig *GcpFilestoreCsiDriverConfig `protobuf:"bytes,14,opt,name=gcp_filestore_csi_driver_config,json=gcpFilestoreCsiDriverConfig,proto3" json:"gcp_filestore_csi_driver_config,omitempty"`
	// Configuration for the Backup for GKE agent addon.
	GkeBackupAgentConfig *GkeBackupAgentConfig `protobuf:"bytes,16,opt,name=gke_backup_agent_config,json=gkeBackupAgentConfig,proto3" json:"gke_backup_agent_config,omitempty"`
	// Configuration for the Cloud Storage Fuse CSI driver.
	GcsFuseCsiDriverConfig *GcsFuseCsiDriverConfig `protobuf:"bytes,17,opt,name=gcs_fuse_csi_driver_config,json=gcsFuseCsiDriverConfig,proto3" json:"gcs_fuse_csi_driver_config,omitempty"`
	// Optional. Configuration for the StatefulHA add-on.
	StatefulHaConfig *StatefulHAConfig `protobuf:"bytes,18,opt,name=stateful_ha_config,json=statefulHaConfig,proto3" json:"stateful_ha_config,omitempty"`
	// Configuration for the Cloud Storage Parallelstore CSI driver.
	ParallelstoreCsiDriverConfig *ParallelstoreCsiDriverConfig `protobuf:"bytes,19,opt,name=parallelstore_csi_driver_config,json=parallelstoreCsiDriverConfig,proto3" json:"parallelstore_csi_driver_config,omitempty"`
	// Optional. Configuration for Ray Operator addon.
	RayOperatorConfig *RayOperatorConfig `protobuf:"bytes,21,opt,name=ray_operator_config,json=rayOperatorConfig,proto3" json:"ray_operator_config,omitempty"`
}

func (x *AddonsConfig) Reset() {
	*x = AddonsConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddonsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddonsConfig) ProtoMessage() {}

func (x *AddonsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddonsConfig.ProtoReflect.Descriptor instead.
func (*AddonsConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{21}
}

func (x *AddonsConfig) GetHttpLoadBalancing() *HttpLoadBalancing {
	if x != nil {
		return x.HttpLoadBalancing
	}
	return nil
}

func (x *AddonsConfig) GetHorizontalPodAutoscaling() *HorizontalPodAutoscaling {
	if x != nil {
		return x.HorizontalPodAutoscaling
	}
	return nil
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *AddonsConfig) GetKubernetesDashboard() *KubernetesDashboard {
	if x != nil {
		return x.KubernetesDashboard
	}
	return nil
}

func (x *AddonsConfig) GetNetworkPolicyConfig() *NetworkPolicyConfig {
	if x != nil {
		return x.NetworkPolicyConfig
	}
	return nil
}

func (x *AddonsConfig) GetCloudRunConfig() *CloudRunConfig {
	if x != nil {
		return x.CloudRunConfig
	}
	return nil
}

func (x *AddonsConfig) GetDnsCacheConfig() *DnsCacheConfig {
	if x != nil {
		return x.DnsCacheConfig
	}
	return nil
}

func (x *AddonsConfig) GetConfigConnectorConfig() *ConfigConnectorConfig {
	if x != nil {
		return x.ConfigConnectorConfig
	}
	return nil
}

func (x *AddonsConfig) GetGcePersistentDiskCsiDriverConfig() *GcePersistentDiskCsiDriverConfig {
	if x != nil {
		return x.GcePersistentDiskCsiDriverConfig
	}
	return nil
}

func (x *AddonsConfig) GetGcpFilestoreCsiDriverConfig() *GcpFilestoreCsiDriverConfig {
	if x != nil {
		return x.GcpFilestoreCsiDriverConfig
	}
	return nil
}

func (x *AddonsConfig) GetGkeBackupAgentConfig() *GkeBackupAgentConfig {
	if x != nil {
		return x.GkeBackupAgentConfig
	}
	return nil
}

func (x *AddonsConfig) GetGcsFuseCsiDriverConfig() *GcsFuseCsiDriverConfig {
	if x != nil {
		return x.GcsFuseCsiDriverConfig
	}
	return nil
}

func (x *AddonsConfig) GetStatefulHaConfig() *StatefulHAConfig {
	if x != nil {
		return x.StatefulHaConfig
	}
	return nil
}

func (x *AddonsConfig) GetParallelstoreCsiDriverConfig() *ParallelstoreCsiDriverConfig {
	if x != nil {
		return x.ParallelstoreCsiDriverConfig
	}
	return nil
}

func (x *AddonsConfig) GetRayOperatorConfig() *RayOperatorConfig {
	if x != nil {
		return x.RayOperatorConfig
	}
	return nil
}

// Configuration options for the HTTP (L7) load balancing controller addon,
// which makes it easy to set up HTTP load balancers for services in a cluster.
type HttpLoadBalancing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the HTTP Load Balancing controller is enabled in the cluster.
	// When enabled, it runs a small pod in the cluster that manages the load
	// balancers.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *HttpLoadBalancing) Reset() {
	*x = HttpLoadBalancing{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpLoadBalancing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpLoadBalancing) ProtoMessage() {}

func (x *HttpLoadBalancing) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpLoadBalancing.ProtoReflect.Descriptor instead.
func (*HttpLoadBalancing) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{22}
}

func (x *HttpLoadBalancing) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// Configuration options for the horizontal pod autoscaling feature, which
// increases or decreases the number of replica pods a replication controller
// has based on the resource usage of the existing pods.
type HorizontalPodAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Horizontal Pod Autoscaling feature is enabled in the cluster.
	// When enabled, it ensures that metrics are collected into Stackdriver
	// Monitoring.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *HorizontalPodAutoscaling) Reset() {
	*x = HorizontalPodAutoscaling{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HorizontalPodAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HorizontalPodAutoscaling) ProtoMessage() {}

func (x *HorizontalPodAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HorizontalPodAutoscaling.ProtoReflect.Descriptor instead.
func (*HorizontalPodAutoscaling) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{23}
}

func (x *HorizontalPodAutoscaling) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// Configuration for the Kubernetes Dashboard.
type KubernetesDashboard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Kubernetes Dashboard is enabled for this cluster.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *KubernetesDashboard) Reset() {
	*x = KubernetesDashboard{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KubernetesDashboard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesDashboard) ProtoMessage() {}

func (x *KubernetesDashboard) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesDashboard.ProtoReflect.Descriptor instead.
func (*KubernetesDashboard) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{24}
}

func (x *KubernetesDashboard) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// Configuration for NetworkPolicy. This only tracks whether the addon
// is enabled or not on the Master, it does not track whether network policy
// is enabled for the nodes.
type NetworkPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether NetworkPolicy is enabled for this cluster.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *NetworkPolicyConfig) Reset() {
	*x = NetworkPolicyConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicyConfig) ProtoMessage() {}

func (x *NetworkPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicyConfig.ProtoReflect.Descriptor instead.
func (*NetworkPolicyConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{25}
}

func (x *NetworkPolicyConfig) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// Configuration for NodeLocal DNSCache
type DnsCacheConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether NodeLocal DNSCache is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *DnsCacheConfig) Reset() {
	*x = DnsCacheConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DnsCacheConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsCacheConfig) ProtoMessage() {}

func (x *DnsCacheConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsCacheConfig.ProtoReflect.Descriptor instead.
func (*DnsCacheConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{26}
}

func (x *DnsCacheConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for controlling master global access settings.
type PrivateClusterMasterGlobalAccessConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whenever master is accessible globally or not.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *PrivateClusterMasterGlobalAccessConfig) Reset() {
	*x = PrivateClusterMasterGlobalAccessConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivateClusterMasterGlobalAccessConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateClusterMasterGlobalAccessConfig) ProtoMessage() {}

func (x *PrivateClusterMasterGlobalAccessConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateClusterMasterGlobalAccessConfig.ProtoReflect.Descriptor instead.
func (*PrivateClusterMasterGlobalAccessConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{27}
}

func (x *PrivateClusterMasterGlobalAccessConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration options for private clusters.
type PrivateClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether nodes have internal IP addresses only. If enabled, all nodes are
	// given only RFC 1918 private addresses and communicate with the master via
	// private networking.
	//
	// Deprecated: Use
	// [NetworkConfig.default_enable_private_nodes][google.container.v1.NetworkConfig.default_enable_private_nodes]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	EnablePrivateNodes bool `protobuf:"varint,1,opt,name=enable_private_nodes,json=enablePrivateNodes,proto3" json:"enable_private_nodes,omitempty"`
	// Whether the master's internal IP address is used as the cluster endpoint.
	//
	// Deprecated: Use
	// [ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_public_endpoint][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_public_endpoint]
	// instead. Note that the value of enable_public_endpoint is reversed: if
	// enable_private_endpoint is false, then enable_public_endpoint will be true.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	EnablePrivateEndpoint bool `protobuf:"varint,2,opt,name=enable_private_endpoint,json=enablePrivateEndpoint,proto3" json:"enable_private_endpoint,omitempty"`
	// The IP range in CIDR notation to use for the hosted master network. This
	// range will be used for assigning internal IP addresses to the master or
	// set of masters, as well as the ILB VIP. This range must not overlap with
	// any other ranges in use within the cluster's network.
	MasterIpv4CidrBlock string `protobuf:"bytes,3,opt,name=master_ipv4_cidr_block,json=masterIpv4CidrBlock,proto3" json:"master_ipv4_cidr_block,omitempty"`
	// Output only. The internal IP address of this cluster's master endpoint.
	//
	// Deprecated: Use
	// [ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	PrivateEndpoint string `protobuf:"bytes,4,opt,name=private_endpoint,json=privateEndpoint,proto3" json:"private_endpoint,omitempty"`
	// Output only. The external IP address of this cluster's master endpoint.
	//
	// Deprecated:Use
	// [ControlPlaneEndpointsConfig.IPEndpointsConfig.public_endpoint][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.public_endpoint]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	PublicEndpoint string `protobuf:"bytes,5,opt,name=public_endpoint,json=publicEndpoint,proto3" json:"public_endpoint,omitempty"`
	// Output only. The peering name in the customer VPC used by this cluster.
	PeeringName string `protobuf:"bytes,7,opt,name=peering_name,json=peeringName,proto3" json:"peering_name,omitempty"`
	// Controls master global access settings.
	//
	// Deprecated: Use
	// [ControlPlaneEndpointsConfig.IPEndpointsConfig.enable_global_access][]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	MasterGlobalAccessConfig *PrivateClusterMasterGlobalAccessConfig `protobuf:"bytes,8,opt,name=master_global_access_config,json=masterGlobalAccessConfig,proto3" json:"master_global_access_config,omitempty"`
	// Subnet to provision the master's private endpoint during cluster creation.
	// Specified in projects/*/regions/*/subnetworks/* format.
	//
	// Deprecated: Use
	// [ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint_subnetwork][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.private_endpoint_subnetwork]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	PrivateEndpointSubnetwork string `protobuf:"bytes,10,opt,name=private_endpoint_subnetwork,json=privateEndpointSubnetwork,proto3" json:"private_endpoint_subnetwork,omitempty"`
}

func (x *PrivateClusterConfig) Reset() {
	*x = PrivateClusterConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivateClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateClusterConfig) ProtoMessage() {}

func (x *PrivateClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateClusterConfig.ProtoReflect.Descriptor instead.
func (*PrivateClusterConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{28}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *PrivateClusterConfig) GetEnablePrivateNodes() bool {
	if x != nil {
		return x.EnablePrivateNodes
	}
	return false
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *PrivateClusterConfig) GetEnablePrivateEndpoint() bool {
	if x != nil {
		return x.EnablePrivateEndpoint
	}
	return false
}

func (x *PrivateClusterConfig) GetMasterIpv4CidrBlock() string {
	if x != nil {
		return x.MasterIpv4CidrBlock
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *PrivateClusterConfig) GetPrivateEndpoint() string {
	if x != nil {
		return x.PrivateEndpoint
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *PrivateClusterConfig) GetPublicEndpoint() string {
	if x != nil {
		return x.PublicEndpoint
	}
	return ""
}

func (x *PrivateClusterConfig) GetPeeringName() string {
	if x != nil {
		return x.PeeringName
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *PrivateClusterConfig) GetMasterGlobalAccessConfig() *PrivateClusterMasterGlobalAccessConfig {
	if x != nil {
		return x.MasterGlobalAccessConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *PrivateClusterConfig) GetPrivateEndpointSubnetwork() string {
	if x != nil {
		return x.PrivateEndpointSubnetwork
	}
	return ""
}

// Configuration for returning group information from authenticators.
type AuthenticatorGroupsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether this cluster should return group membership lookups
	// during authentication using a group of security groups.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The name of the security group-of-groups to be used. Only relevant
	// if enabled = true.
	SecurityGroup string `protobuf:"bytes,2,opt,name=security_group,json=securityGroup,proto3" json:"security_group,omitempty"`
}

func (x *AuthenticatorGroupsConfig) Reset() {
	*x = AuthenticatorGroupsConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AuthenticatorGroupsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticatorGroupsConfig) ProtoMessage() {}

func (x *AuthenticatorGroupsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticatorGroupsConfig.ProtoReflect.Descriptor instead.
func (*AuthenticatorGroupsConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{29}
}

func (x *AuthenticatorGroupsConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *AuthenticatorGroupsConfig) GetSecurityGroup() string {
	if x != nil {
		return x.SecurityGroup
	}
	return ""
}

// Configuration options for the Cloud Run feature.
type CloudRunConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Cloud Run addon is enabled for this cluster.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Which load balancer type is installed for Cloud Run.
	LoadBalancerType CloudRunConfig_LoadBalancerType `protobuf:"varint,3,opt,name=load_balancer_type,json=loadBalancerType,proto3,enum=google.container.v1.CloudRunConfig_LoadBalancerType" json:"load_balancer_type,omitempty"`
}

func (x *CloudRunConfig) Reset() {
	*x = CloudRunConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudRunConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudRunConfig) ProtoMessage() {}

func (x *CloudRunConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudRunConfig.ProtoReflect.Descriptor instead.
func (*CloudRunConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{30}
}

func (x *CloudRunConfig) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *CloudRunConfig) GetLoadBalancerType() CloudRunConfig_LoadBalancerType {
	if x != nil {
		return x.LoadBalancerType
	}
	return CloudRunConfig_LOAD_BALANCER_TYPE_UNSPECIFIED
}

// Configuration options for the Config Connector add-on.
type ConfigConnectorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Cloud Connector is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ConfigConnectorConfig) Reset() {
	*x = ConfigConnectorConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfigConnectorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigConnectorConfig) ProtoMessage() {}

func (x *ConfigConnectorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigConnectorConfig.ProtoReflect.Descriptor instead.
func (*ConfigConnectorConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{31}
}

func (x *ConfigConnectorConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for the Compute Engine PD CSI driver.
type GcePersistentDiskCsiDriverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Compute Engine PD CSI driver is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *GcePersistentDiskCsiDriverConfig) Reset() {
	*x = GcePersistentDiskCsiDriverConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcePersistentDiskCsiDriverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcePersistentDiskCsiDriverConfig) ProtoMessage() {}

func (x *GcePersistentDiskCsiDriverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcePersistentDiskCsiDriverConfig.ProtoReflect.Descriptor instead.
func (*GcePersistentDiskCsiDriverConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{32}
}

func (x *GcePersistentDiskCsiDriverConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for the GCP Filestore CSI driver.
type GcpFilestoreCsiDriverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the GCP Filestore CSI driver is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *GcpFilestoreCsiDriverConfig) Reset() {
	*x = GcpFilestoreCsiDriverConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcpFilestoreCsiDriverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcpFilestoreCsiDriverConfig) ProtoMessage() {}

func (x *GcpFilestoreCsiDriverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcpFilestoreCsiDriverConfig.ProtoReflect.Descriptor instead.
func (*GcpFilestoreCsiDriverConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{33}
}

func (x *GcpFilestoreCsiDriverConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for the Cloud Storage Fuse CSI driver.
type GcsFuseCsiDriverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Cloud Storage Fuse CSI driver is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *GcsFuseCsiDriverConfig) Reset() {
	*x = GcsFuseCsiDriverConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcsFuseCsiDriverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsFuseCsiDriverConfig) ProtoMessage() {}

func (x *GcsFuseCsiDriverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsFuseCsiDriverConfig.ProtoReflect.Descriptor instead.
func (*GcsFuseCsiDriverConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{34}
}

func (x *GcsFuseCsiDriverConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for the Cloud Storage Parallelstore CSI driver.
type ParallelstoreCsiDriverConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Cloud Storage Parallelstore CSI driver is enabled for this
	// cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ParallelstoreCsiDriverConfig) Reset() {
	*x = ParallelstoreCsiDriverConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ParallelstoreCsiDriverConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParallelstoreCsiDriverConfig) ProtoMessage() {}

func (x *ParallelstoreCsiDriverConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParallelstoreCsiDriverConfig.ProtoReflect.Descriptor instead.
func (*ParallelstoreCsiDriverConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{35}
}

func (x *ParallelstoreCsiDriverConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration options for the Ray Operator add-on.
type RayOperatorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Ray Operator addon is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Optional. Logging configuration for Ray clusters.
	RayClusterLoggingConfig *RayClusterLoggingConfig `protobuf:"bytes,2,opt,name=ray_cluster_logging_config,json=rayClusterLoggingConfig,proto3" json:"ray_cluster_logging_config,omitempty"`
	// Optional. Monitoring configuration for Ray clusters.
	RayClusterMonitoringConfig *RayClusterMonitoringConfig `protobuf:"bytes,3,opt,name=ray_cluster_monitoring_config,json=rayClusterMonitoringConfig,proto3" json:"ray_cluster_monitoring_config,omitempty"`
}

func (x *RayOperatorConfig) Reset() {
	*x = RayOperatorConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RayOperatorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RayOperatorConfig) ProtoMessage() {}

func (x *RayOperatorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RayOperatorConfig.ProtoReflect.Descriptor instead.
func (*RayOperatorConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{36}
}

func (x *RayOperatorConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *RayOperatorConfig) GetRayClusterLoggingConfig() *RayClusterLoggingConfig {
	if x != nil {
		return x.RayClusterLoggingConfig
	}
	return nil
}

func (x *RayOperatorConfig) GetRayClusterMonitoringConfig() *RayClusterMonitoringConfig {
	if x != nil {
		return x.RayClusterMonitoringConfig
	}
	return nil
}

// Configuration for the Backup for GKE Agent.
type GkeBackupAgentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Backup for GKE agent is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *GkeBackupAgentConfig) Reset() {
	*x = GkeBackupAgentConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GkeBackupAgentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeBackupAgentConfig) ProtoMessage() {}

func (x *GkeBackupAgentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeBackupAgentConfig.ProtoReflect.Descriptor instead.
func (*GkeBackupAgentConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{37}
}

func (x *GkeBackupAgentConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for the Stateful HA add-on.
type StatefulHAConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the Stateful HA add-on is enabled for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *StatefulHAConfig) Reset() {
	*x = StatefulHAConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StatefulHAConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatefulHAConfig) ProtoMessage() {}

func (x *StatefulHAConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatefulHAConfig.ProtoReflect.Descriptor instead.
func (*StatefulHAConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{38}
}

func (x *StatefulHAConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration options for the master authorized networks feature. Enabled
// master authorized networks will disallow all external traffic to access
// Kubernetes master through HTTPS except traffic from the given CIDR blocks,
// Google Compute Engine Public IPs and Google Prod IPs.
type MasterAuthorizedNetworksConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether or not master authorized networks is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// cidr_blocks define up to 50 external networks that could access
	// Kubernetes master through HTTPS.
	CidrBlocks []*MasterAuthorizedNetworksConfig_CidrBlock `protobuf:"bytes,2,rep,name=cidr_blocks,json=cidrBlocks,proto3" json:"cidr_blocks,omitempty"`
	// Whether master is accessbile via Google Compute Engine Public IP addresses.
	GcpPublicCidrsAccessEnabled *bool `protobuf:"varint,3,opt,name=gcp_public_cidrs_access_enabled,json=gcpPublicCidrsAccessEnabled,proto3,oneof" json:"gcp_public_cidrs_access_enabled,omitempty"`
	// Whether master authorized networks is enforced on private endpoint or not.
	PrivateEndpointEnforcementEnabled *bool `protobuf:"varint,5,opt,name=private_endpoint_enforcement_enabled,json=privateEndpointEnforcementEnabled,proto3,oneof" json:"private_endpoint_enforcement_enabled,omitempty"`
}

func (x *MasterAuthorizedNetworksConfig) Reset() {
	*x = MasterAuthorizedNetworksConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MasterAuthorizedNetworksConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuthorizedNetworksConfig) ProtoMessage() {}

func (x *MasterAuthorizedNetworksConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuthorizedNetworksConfig.ProtoReflect.Descriptor instead.
func (*MasterAuthorizedNetworksConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{39}
}

func (x *MasterAuthorizedNetworksConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *MasterAuthorizedNetworksConfig) GetCidrBlocks() []*MasterAuthorizedNetworksConfig_CidrBlock {
	if x != nil {
		return x.CidrBlocks
	}
	return nil
}

func (x *MasterAuthorizedNetworksConfig) GetGcpPublicCidrsAccessEnabled() bool {
	if x != nil && x.GcpPublicCidrsAccessEnabled != nil {
		return *x.GcpPublicCidrsAccessEnabled
	}
	return false
}

func (x *MasterAuthorizedNetworksConfig) GetPrivateEndpointEnforcementEnabled() bool {
	if x != nil && x.PrivateEndpointEnforcementEnabled != nil {
		return *x.PrivateEndpointEnforcementEnabled
	}
	return false
}

// Configuration for the legacy Attribute Based Access Control authorization
// mode.
type LegacyAbac struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the ABAC authorizer is enabled for this cluster. When enabled,
	// identities in the system, including service accounts, nodes, and
	// controllers, will have statically granted permissions beyond those
	// provided by the RBAC configuration or IAM.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *LegacyAbac) Reset() {
	*x = LegacyAbac{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LegacyAbac) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LegacyAbac) ProtoMessage() {}

func (x *LegacyAbac) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LegacyAbac.ProtoReflect.Descriptor instead.
func (*LegacyAbac) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{40}
}

func (x *LegacyAbac) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration options for the NetworkPolicy feature.
// https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
type NetworkPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The selected network policy provider.
	Provider NetworkPolicy_Provider `protobuf:"varint,1,opt,name=provider,proto3,enum=google.container.v1.NetworkPolicy_Provider" json:"provider,omitempty"`
	// Whether network policy is enabled on the cluster.
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *NetworkPolicy) Reset() {
	*x = NetworkPolicy{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicy) ProtoMessage() {}

func (x *NetworkPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicy.ProtoReflect.Descriptor instead.
func (*NetworkPolicy) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{41}
}

func (x *NetworkPolicy) GetProvider() NetworkPolicy_Provider {
	if x != nil {
		return x.Provider
	}
	return NetworkPolicy_PROVIDER_UNSPECIFIED
}

func (x *NetworkPolicy) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for Binary Authorization.
type BinaryAuthorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field is deprecated. Leave this unset and instead configure
	// BinaryAuthorization using evaluation_mode. If evaluation_mode is set to
	// anything other than EVALUATION_MODE_UNSPECIFIED, this field is ignored.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Mode of operation for binauthz policy evaluation. If unspecified, defaults
	// to DISABLED.
	EvaluationMode BinaryAuthorization_EvaluationMode `protobuf:"varint,2,opt,name=evaluation_mode,json=evaluationMode,proto3,enum=google.container.v1.BinaryAuthorization_EvaluationMode" json:"evaluation_mode,omitempty"`
}

func (x *BinaryAuthorization) Reset() {
	*x = BinaryAuthorization{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BinaryAuthorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinaryAuthorization) ProtoMessage() {}

func (x *BinaryAuthorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinaryAuthorization.ProtoReflect.Descriptor instead.
func (*BinaryAuthorization) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{42}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *BinaryAuthorization) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *BinaryAuthorization) GetEvaluationMode() BinaryAuthorization_EvaluationMode {
	if x != nil {
		return x.EvaluationMode
	}
	return BinaryAuthorization_EVALUATION_MODE_UNSPECIFIED
}

// [PRIVATE FIELD]
// Config for pod CIDR size overprovisioning.
type PodCIDROverprovisionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Pod CIDR overprovisioning is disabled.
	// Note: Pod CIDR overprovisioning is enabled by default.
	Disable bool `protobuf:"varint,1,opt,name=disable,proto3" json:"disable,omitempty"`
}

func (x *PodCIDROverprovisionConfig) Reset() {
	*x = PodCIDROverprovisionConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PodCIDROverprovisionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PodCIDROverprovisionConfig) ProtoMessage() {}

func (x *PodCIDROverprovisionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PodCIDROverprovisionConfig.ProtoReflect.Descriptor instead.
func (*PodCIDROverprovisionConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{43}
}

func (x *PodCIDROverprovisionConfig) GetDisable() bool {
	if x != nil {
		return x.Disable
	}
	return false
}

// Configuration for controlling how IPs are allocated in the cluster.
type IPAllocationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether alias IPs will be used for pod IPs in the cluster.
	// This is used in conjunction with use_routes. It cannot
	// be true if use_routes is true. If both use_ip_aliases and use_routes are
	// false, then the server picks the default IP allocation mode
	UseIpAliases bool `protobuf:"varint,1,opt,name=use_ip_aliases,json=useIpAliases,proto3" json:"use_ip_aliases,omitempty"`
	// Whether a new subnetwork will be created automatically for the cluster.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	CreateSubnetwork bool `protobuf:"varint,2,opt,name=create_subnetwork,json=createSubnetwork,proto3" json:"create_subnetwork,omitempty"`
	// A custom subnetwork name to be used if `create_subnetwork` is true.  If
	// this field is empty, then an automatic name will be chosen for the new
	// subnetwork.
	SubnetworkName string `protobuf:"bytes,3,opt,name=subnetwork_name,json=subnetworkName,proto3" json:"subnetwork_name,omitempty"`
	// This field is deprecated, use cluster_ipv4_cidr_block.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterIpv4Cidr string `protobuf:"bytes,4,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr,proto3" json:"cluster_ipv4_cidr,omitempty"`
	// This field is deprecated, use node_ipv4_cidr_block.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	NodeIpv4Cidr string `protobuf:"bytes,5,opt,name=node_ipv4_cidr,json=nodeIpv4Cidr,proto3" json:"node_ipv4_cidr,omitempty"`
	// This field is deprecated, use services_ipv4_cidr_block.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ServicesIpv4Cidr string `protobuf:"bytes,6,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr,proto3" json:"services_ipv4_cidr,omitempty"`
	// The name of the secondary range to be used for the cluster CIDR
	// block.  The secondary range will be used for pod IP
	// addresses. This must be an existing secondary range associated
	// with the cluster subnetwork.
	//
	// This field is only applicable with use_ip_aliases is true and
	// create_subnetwork is false.
	ClusterSecondaryRangeName string `protobuf:"bytes,7,opt,name=cluster_secondary_range_name,json=clusterSecondaryRangeName,proto3" json:"cluster_secondary_range_name,omitempty"`
	// The name of the secondary range to be used as for the services
	// CIDR block.  The secondary range will be used for service
	// ClusterIPs. This must be an existing secondary range associated
	// with the cluster subnetwork.
	//
	// This field is only applicable with use_ip_aliases is true and
	// create_subnetwork is false.
	ServicesSecondaryRangeName string `protobuf:"bytes,8,opt,name=services_secondary_range_name,json=servicesSecondaryRangeName,proto3" json:"services_secondary_range_name,omitempty"`
	// The IP address range for the cluster pod IPs. If this field is set, then
	// `cluster.cluster_ipv4_cidr` must be left blank.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ClusterIpv4CidrBlock string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr_block,json=clusterIpv4CidrBlock,proto3" json:"cluster_ipv4_cidr_block,omitempty"`
	// The IP address range of the instance IPs in this cluster.
	//
	// This is applicable only if `create_subnetwork` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	NodeIpv4CidrBlock string `protobuf:"bytes,10,opt,name=node_ipv4_cidr_block,json=nodeIpv4CidrBlock,proto3" json:"node_ipv4_cidr_block,omitempty"`
	// The IP address range of the services IPs in this cluster. If blank, a range
	// will be automatically chosen with the default size.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// Set to blank to have a range chosen with the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	ServicesIpv4CidrBlock string `protobuf:"bytes,11,opt,name=services_ipv4_cidr_block,json=servicesIpv4CidrBlock,proto3" json:"services_ipv4_cidr_block,omitempty"`
	// The IP address range of the Cloud TPUs in this cluster. If unspecified, a
	// range will be automatically chosen with the default size.
	//
	// This field is only applicable when `use_ip_aliases` is true.
	//
	// If unspecified, the range will use the default size.
	//
	// Set to /netmask (e.g. `/14`) to have a range chosen with a specific
	// netmask.
	//
	// Set to a
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
	// `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range
	// to use.
	TpuIpv4CidrBlock string `protobuf:"bytes,13,opt,name=tpu_ipv4_cidr_block,json=tpuIpv4CidrBlock,proto3" json:"tpu_ipv4_cidr_block,omitempty"`
	// Whether routes will be used for pod IPs in the cluster.
	// This is used in conjunction with use_ip_aliases. It cannot be true if
	// use_ip_aliases is true. If both use_ip_aliases and use_routes are false,
	// then the server picks the default IP allocation mode
	UseRoutes bool `protobuf:"varint,15,opt,name=use_routes,json=useRoutes,proto3" json:"use_routes,omitempty"`
	// The IP stack type of the cluster
	StackType StackType `protobuf:"varint,16,opt,name=stack_type,json=stackType,proto3,enum=google.container.v1.StackType" json:"stack_type,omitempty"`
	// The ipv6 access type (internal or external) when create_subnetwork is true
	Ipv6AccessType IPv6AccessType `protobuf:"varint,17,opt,name=ipv6_access_type,json=ipv6AccessType,proto3,enum=google.container.v1.IPv6AccessType" json:"ipv6_access_type,omitempty"`
	// [PRIVATE FIELD]
	// Pod CIDR size overprovisioning config for the cluster.
	//
	// Pod CIDR size per node depends on max_pods_per_node. By default, the value
	// of max_pods_per_node is doubled and then rounded off to next power of 2 to
	// get the size of pod CIDR block per node.
	// Example: max_pods_per_node of 30 would result in 64 IPs (/26).
	//
	// This config can disable the doubling of IPs (we still round off to next
	// power of 2)
	// Example: max_pods_per_node of 30 will result in 32 IPs (/27) when
	// overprovisioning is disabled.
	PodCidrOverprovisionConfig *PodCIDROverprovisionConfig `protobuf:"bytes,21,opt,name=pod_cidr_overprovision_config,json=podCidrOverprovisionConfig,proto3" json:"pod_cidr_overprovision_config,omitempty"`
	// Output only. The subnet's IPv6 CIDR block used by nodes and pods.
	SubnetIpv6CidrBlock string `protobuf:"bytes,22,opt,name=subnet_ipv6_cidr_block,json=subnetIpv6CidrBlock,proto3" json:"subnet_ipv6_cidr_block,omitempty"`
	// Output only. The services IPv6 CIDR block for the cluster.
	ServicesIpv6CidrBlock string `protobuf:"bytes,23,opt,name=services_ipv6_cidr_block,json=servicesIpv6CidrBlock,proto3" json:"services_ipv6_cidr_block,omitempty"`
	// Output only. The additional pod ranges that are added to the cluster.
	// These pod ranges can be used by new node pools to allocate pod IPs
	// automatically. Once the range is removed it will not show up in
	// IPAllocationPolicy.
	AdditionalPodRangesConfig *AdditionalPodRangesConfig `protobuf:"bytes,24,opt,name=additional_pod_ranges_config,json=additionalPodRangesConfig,proto3" json:"additional_pod_ranges_config,omitempty"`
	// Output only. The utilization of the cluster default IPv4 range for the
	// pod. The ratio is Usage/[Total number of IPs in the secondary range],
	// Usage=numNodes*numZones*podIPsPerNode.
	DefaultPodIpv4RangeUtilization float64 `protobuf:"fixed64,25,opt,name=default_pod_ipv4_range_utilization,json=defaultPodIpv4RangeUtilization,proto3" json:"default_pod_ipv4_range_utilization,omitempty"`
}

func (x *IPAllocationPolicy) Reset() {
	*x = IPAllocationPolicy{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IPAllocationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IPAllocationPolicy) ProtoMessage() {}

func (x *IPAllocationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IPAllocationPolicy.ProtoReflect.Descriptor instead.
func (*IPAllocationPolicy) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{44}
}

func (x *IPAllocationPolicy) GetUseIpAliases() bool {
	if x != nil {
		return x.UseIpAliases
	}
	return false
}

func (x *IPAllocationPolicy) GetCreateSubnetwork() bool {
	if x != nil {
		return x.CreateSubnetwork
	}
	return false
}

func (x *IPAllocationPolicy) GetSubnetworkName() string {
	if x != nil {
		return x.SubnetworkName
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *IPAllocationPolicy) GetClusterIpv4Cidr() string {
	if x != nil {
		return x.ClusterIpv4Cidr
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *IPAllocationPolicy) GetNodeIpv4Cidr() string {
	if x != nil {
		return x.NodeIpv4Cidr
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *IPAllocationPolicy) GetServicesIpv4Cidr() string {
	if x != nil {
		return x.ServicesIpv4Cidr
	}
	return ""
}

func (x *IPAllocationPolicy) GetClusterSecondaryRangeName() string {
	if x != nil {
		return x.ClusterSecondaryRangeName
	}
	return ""
}

func (x *IPAllocationPolicy) GetServicesSecondaryRangeName() string {
	if x != nil {
		return x.ServicesSecondaryRangeName
	}
	return ""
}

func (x *IPAllocationPolicy) GetClusterIpv4CidrBlock() string {
	if x != nil {
		return x.ClusterIpv4CidrBlock
	}
	return ""
}

func (x *IPAllocationPolicy) GetNodeIpv4CidrBlock() string {
	if x != nil {
		return x.NodeIpv4CidrBlock
	}
	return ""
}

func (x *IPAllocationPolicy) GetServicesIpv4CidrBlock() string {
	if x != nil {
		return x.ServicesIpv4CidrBlock
	}
	return ""
}

func (x *IPAllocationPolicy) GetTpuIpv4CidrBlock() string {
	if x != nil {
		return x.TpuIpv4CidrBlock
	}
	return ""
}

func (x *IPAllocationPolicy) GetUseRoutes() bool {
	if x != nil {
		return x.UseRoutes
	}
	return false
}

func (x *IPAllocationPolicy) GetStackType() StackType {
	if x != nil {
		return x.StackType
	}
	return StackType_STACK_TYPE_UNSPECIFIED
}

func (x *IPAllocationPolicy) GetIpv6AccessType() IPv6AccessType {
	if x != nil {
		return x.Ipv6AccessType
	}
	return IPv6AccessType_IPV6_ACCESS_TYPE_UNSPECIFIED
}

func (x *IPAllocationPolicy) GetPodCidrOverprovisionConfig() *PodCIDROverprovisionConfig {
	if x != nil {
		return x.PodCidrOverprovisionConfig
	}
	return nil
}

func (x *IPAllocationPolicy) GetSubnetIpv6CidrBlock() string {
	if x != nil {
		return x.SubnetIpv6CidrBlock
	}
	return ""
}

func (x *IPAllocationPolicy) GetServicesIpv6CidrBlock() string {
	if x != nil {
		return x.ServicesIpv6CidrBlock
	}
	return ""
}

func (x *IPAllocationPolicy) GetAdditionalPodRangesConfig() *AdditionalPodRangesConfig {
	if x != nil {
		return x.AdditionalPodRangesConfig
	}
	return nil
}

func (x *IPAllocationPolicy) GetDefaultPodIpv4RangeUtilization() float64 {
	if x != nil {
		return x.DefaultPodIpv4RangeUtilization
	}
	return 0
}

// A Google Kubernetes Engine cluster.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this cluster. The name must be unique within this project
	// and location (e.g. zone or region), and can be up to 40 characters with
	// the following restrictions:
	//
	// * Lowercase letters, numbers, and hyphens only.
	// * Must start with a letter.
	// * Must end with a number or a letter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional description of this cluster.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The number of nodes to create in this cluster. You must ensure that your
	// Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "node_config") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	//
	// This field is deprecated, use node_pool.initial_node_count instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount,proto3" json:"initial_node_count,omitempty"`
	// Parameters used in creating the cluster's nodes.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "initial_node_count") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	// For responses, this field will be populated with the node configuration of
	// the first node pool. (For configuration of each node pool, see
	// `node_pool.config`)
	//
	// If unspecified, the defaults are used.
	// This field is deprecated, use node_pool.config instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	NodeConfig *NodeConfig `protobuf:"bytes,4,opt,name=node_config,json=nodeConfig,proto3" json:"node_config,omitempty"`
	// The authentication information for accessing the master endpoint.
	// If unspecified, the defaults are used:
	// For clusters before v1.12, if master_auth is unspecified, `username` will
	// be set to "admin", a random password will be generated, and a client
	// certificate will be issued.
	MasterAuth *MasterAuth `protobuf:"bytes,5,opt,name=master_auth,json=masterAuth,proto3" json:"master_auth,omitempty"`
	// The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com/kubernetes` - The Cloud Logging
	// service with a Kubernetes-native resource model
	//   - `logging.googleapis.com` - The legacy Cloud Logging service (no longer
	//     available as of GKE 1.15).
	//   - `none` - no logs will be exported from the cluster.
	//
	// If left as an empty string,`logging.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
	LoggingService string `protobuf:"bytes,6,opt,name=logging_service,json=loggingService,proto3" json:"logging_service,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
	// service with a Kubernetes-native resource model
	//   - `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
	//     longer available as of GKE 1.15).
	//   - `none` - No metrics will be exported from the cluster.
	//
	// If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
	MonitoringService string `protobuf:"bytes,7,opt,name=monitoring_service,json=monitoringService,proto3" json:"monitoring_service,omitempty"`
	// The name of the Google Compute Engine
	// [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
	// to which the cluster is connected. If left unspecified, the `default`
	// network will be used.
	Network string `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// The IP address range of the container pods in this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`). Leave blank to have
	// one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
	ClusterIpv4Cidr string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr,proto3" json:"cluster_ipv4_cidr,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,10,opt,name=addons_config,json=addonsConfig,proto3" json:"addons_config,omitempty"`
	// The name of the Google Compute Engine
	// [subnetwork](https://cloud.google.com/compute/docs/subnetworks) to which
	// the cluster is connected.
	Subnetwork string `protobuf:"bytes,11,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// The node pools associated with this cluster.
	// This field should not be set if "node_config" or "initial_node_count" are
	// specified.
	NodePools []*NodePool `protobuf:"bytes,12,rep,name=node_pools,json=nodePools,proto3" json:"node_pools,omitempty"`
	// The list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster's nodes should be located.
	//
	// This field provides a default value if
	// [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
	// are not specified during node pool creation.
	//
	// Warning: changing cluster locations will update the
	// [NodePool.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools#NodePool.FIELDS.locations)
	// of all node pools and will result in nodes being added and/or removed.
	Locations []string `protobuf:"bytes,13,rep,name=locations,proto3" json:"locations,omitempty"`
	// Kubernetes alpha features are enabled on this cluster. This includes alpha
	// API groups (e.g. v1alpha1) and features that may not be production ready in
	// the kubernetes version of the master and nodes.
	// The cluster has no SLA for uptime and master/node upgrades are disabled.
	// Alpha enabled clusters are automatically deleted thirty days after
	// creation.
	EnableKubernetesAlpha bool `protobuf:"varint,14,opt,name=enable_kubernetes_alpha,json=enableKubernetesAlpha,proto3" json:"enable_kubernetes_alpha,omitempty"`
	// The resource labels for the cluster to use to annotate any related
	// Google Compute Engine resources.
	ResourceLabels map[string]string `protobuf:"bytes,15,rep,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The fingerprint of the set of labels for this cluster.
	LabelFingerprint string `protobuf:"bytes,16,opt,name=label_fingerprint,json=labelFingerprint,proto3" json:"label_fingerprint,omitempty"`
	// Configuration for the legacy ABAC authorization mode.
	LegacyAbac *LegacyAbac `protobuf:"bytes,18,opt,name=legacy_abac,json=legacyAbac,proto3" json:"legacy_abac,omitempty"`
	// Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,19,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// Configuration for cluster IP allocation.
	IpAllocationPolicy *IPAllocationPolicy `protobuf:"bytes,20,opt,name=ip_allocation_policy,json=ipAllocationPolicy,proto3" json:"ip_allocation_policy,omitempty"`
	// The configuration options for master authorized networks feature.
	//
	// Deprecated: Use
	// [ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config][google.container.v1.ControlPlaneEndpointsConfig.IPEndpointsConfig.authorized_networks_config]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	MasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,22,opt,name=master_authorized_networks_config,json=masterAuthorizedNetworksConfig,proto3" json:"master_authorized_networks_config,omitempty"`
	// Configure the maintenance policy for this cluster.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,23,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// Configuration for Binary Authorization.
	BinaryAuthorization *BinaryAuthorization `protobuf:"bytes,24,opt,name=binary_authorization,json=binaryAuthorization,proto3" json:"binary_authorization,omitempty"`
	// Cluster-level autoscaling configuration.
	Autoscaling *ClusterAutoscaling `protobuf:"bytes,26,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// Configuration for cluster networking.
	NetworkConfig *NetworkConfig `protobuf:"bytes,27,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// The default constraint on the maximum number of pods that can be run
	// simultaneously on a node in the node pool of this cluster. Only honored
	// if cluster created with IP Alias support.
	DefaultMaxPodsConstraint *MaxPodsConstraint `protobuf:"bytes,30,opt,name=default_max_pods_constraint,json=defaultMaxPodsConstraint,proto3" json:"default_max_pods_constraint,omitempty"`
	// Configuration for exporting resource usages. Resource usage export is
	// disabled when this config is unspecified.
	ResourceUsageExportConfig *ResourceUsageExportConfig `protobuf:"bytes,33,opt,name=resource_usage_export_config,json=resourceUsageExportConfig,proto3" json:"resource_usage_export_config,omitempty"`
	// Configuration controlling RBAC group membership information.
	AuthenticatorGroupsConfig *AuthenticatorGroupsConfig `protobuf:"bytes,34,opt,name=authenticator_groups_config,json=authenticatorGroupsConfig,proto3" json:"authenticator_groups_config,omitempty"`
	// Configuration for private cluster.
	PrivateClusterConfig *PrivateClusterConfig `protobuf:"bytes,37,opt,name=private_cluster_config,json=privateClusterConfig,proto3" json:"private_cluster_config,omitempty"`
	// Configuration of etcd encryption.
	DatabaseEncryption *DatabaseEncryption `protobuf:"bytes,38,opt,name=database_encryption,json=databaseEncryption,proto3" json:"database_encryption,omitempty"`
	// Cluster-level Vertical Pod Autoscaling configuration.
	VerticalPodAutoscaling *VerticalPodAutoscaling `protobuf:"bytes,39,opt,name=vertical_pod_autoscaling,json=verticalPodAutoscaling,proto3" json:"vertical_pod_autoscaling,omitempty"`
	// Shielded Nodes configuration.
	ShieldedNodes *ShieldedNodes `protobuf:"bytes,40,opt,name=shielded_nodes,json=shieldedNodes,proto3" json:"shielded_nodes,omitempty"`
	// Release channel configuration. If left unspecified on cluster creation and
	// a version is specified, the cluster is enrolled in the most mature release
	// channel where the version is available (first checking STABLE, then
	// REGULAR, and finally RAPID). Otherwise, if no release channel
	// configuration and no version is specified, the cluster is enrolled in the
	// REGULAR channel with its default version.
	ReleaseChannel *ReleaseChannel `protobuf:"bytes,41,opt,name=release_channel,json=releaseChannel,proto3" json:"release_channel,omitempty"`
	// Configuration for the use of Kubernetes Service Accounts in GCP IAM
	// policies.
	WorkloadIdentityConfig *WorkloadIdentityConfig `protobuf:"bytes,43,opt,name=workload_identity_config,json=workloadIdentityConfig,proto3" json:"workload_identity_config,omitempty"`
	// Configuration for issuance of mTLS keys and certificates to Kubernetes
	// pods.
	MeshCertificates *MeshCertificates `protobuf:"bytes,67,opt,name=mesh_certificates,json=meshCertificates,proto3" json:"mesh_certificates,omitempty"`
	// Configuration for the fine-grained cost management feature.
	CostManagementConfig *CostManagementConfig `protobuf:"bytes,45,opt,name=cost_management_config,json=costManagementConfig,proto3" json:"cost_management_config,omitempty"`
	// Notification configuration of the cluster.
	NotificationConfig *NotificationConfig `protobuf:"bytes,49,opt,name=notification_config,json=notificationConfig,proto3" json:"notification_config,omitempty"`
	// Configuration of Confidential Nodes.
	// All the nodes in the cluster will be Confidential VM once enabled.
	ConfidentialNodes *ConfidentialNodes `protobuf:"bytes,50,opt,name=confidential_nodes,json=confidentialNodes,proto3" json:"confidential_nodes,omitempty"`
	// Configuration for Identity Service component.
	IdentityServiceConfig *IdentityServiceConfig `protobuf:"bytes,54,opt,name=identity_service_config,json=identityServiceConfig,proto3" json:"identity_service_config,omitempty"`
	// Output only. Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Output only. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field is deprecated, use location instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,101,opt,name=zone,proto3" json:"zone,omitempty"`
	// Output only. The IP address of this cluster's master endpoint.
	// The endpoint can be accessed from the internet at
	// `https://username:password@endpoint/`.
	//
	// See the `masterAuth` property of this resource for username and
	// password information.
	Endpoint string `protobuf:"bytes,102,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// The initial Kubernetes version for this cluster.  Valid versions are those
	// found in validMasterVersions returned by getServerConfig.  The version can
	// be upgraded over time; such upgrades are reflected in
	// currentMasterVersion and currentNodeVersion.
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "","-": picks the default Kubernetes version
	InitialClusterVersion string `protobuf:"bytes,103,opt,name=initial_cluster_version,json=initialClusterVersion,proto3" json:"initial_cluster_version,omitempty"`
	// Output only. The current software version of the master endpoint.
	CurrentMasterVersion string `protobuf:"bytes,104,opt,name=current_master_version,json=currentMasterVersion,proto3" json:"current_master_version,omitempty"`
	// Output only. Deprecated, use
	// [NodePools.version](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters.nodePools)
	// instead. The current version of the node software components. If they are
	// currently at multiple versions because they're in the process of being
	// upgraded, this reflects the minimum version of all nodes.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	CurrentNodeVersion string `protobuf:"bytes,105,opt,name=current_node_version,json=currentNodeVersion,proto3" json:"current_node_version,omitempty"`
	// Output only. The time the cluster was created, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreateTime string `protobuf:"bytes,106,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The current status of this cluster.
	Status Cluster_Status `protobuf:"varint,107,opt,name=status,proto3,enum=google.container.v1.Cluster_Status" json:"status,omitempty"`
	// Output only. Deprecated. Use conditions instead.
	// Additional information about the current status of this
	// cluster, if available.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	StatusMessage string `protobuf:"bytes,108,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. The size of the address space on each node for hosting
	// containers. This is provisioned from within the `container_ipv4_cidr`
	// range. This field will only be set when cluster is in route-based network
	// mode.
	NodeIpv4CidrSize int32 `protobuf:"varint,109,opt,name=node_ipv4_cidr_size,json=nodeIpv4CidrSize,proto3" json:"node_ipv4_cidr_size,omitempty"`
	// Output only. The IP address range of the Kubernetes services in
	// this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `1.2.3.4/29`). Service addresses are
	// typically put in the last `/16` from the container CIDR.
	ServicesIpv4Cidr string `protobuf:"bytes,110,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr,proto3" json:"services_ipv4_cidr,omitempty"`
	// Output only. Deprecated. Use node_pools.instance_group_urls.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	InstanceGroupUrls []string `protobuf:"bytes,111,rep,name=instance_group_urls,json=instanceGroupUrls,proto3" json:"instance_group_urls,omitempty"`
	// Output only. The number of nodes currently in the cluster. Deprecated.
	// Call Kubernetes API directly to retrieve node information.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	CurrentNodeCount int32 `protobuf:"varint,112,opt,name=current_node_count,json=currentNodeCount,proto3" json:"current_node_count,omitempty"`
	// Output only. The time the cluster will be automatically
	// deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ExpireTime string `protobuf:"bytes,113,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
	// or
	// [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
	// in which the cluster resides.
	Location string `protobuf:"bytes,114,opt,name=location,proto3" json:"location,omitempty"`
	// Enable the ability to use Cloud TPUs in this cluster.
	EnableTpu bool `protobuf:"varint,115,opt,name=enable_tpu,json=enableTpu,proto3" json:"enable_tpu,omitempty"`
	// Output only. The IP address range of the Cloud TPUs in this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `1.2.3.4/29`).
	TpuIpv4CidrBlock string `protobuf:"bytes,116,opt,name=tpu_ipv4_cidr_block,json=tpuIpv4CidrBlock,proto3" json:"tpu_ipv4_cidr_block,omitempty"`
	// Which conditions caused the current cluster state.
	Conditions []*StatusCondition `protobuf:"bytes,118,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// Autopilot configuration for the cluster.
	Autopilot *Autopilot `protobuf:"bytes,128,opt,name=autopilot,proto3" json:"autopilot,omitempty"`
	// Output only. Unique id for the cluster.
	Id string `protobuf:"bytes,129,opt,name=id,proto3" json:"id,omitempty"`
	// Default NodePool settings for the entire cluster. These settings are
	// overridden if specified on the specific NodePool object.
	NodePoolDefaults *NodePoolDefaults `protobuf:"bytes,131,opt,name=node_pool_defaults,json=nodePoolDefaults,proto3,oneof" json:"node_pool_defaults,omitempty"`
	// Logging configuration for the cluster.
	LoggingConfig *LoggingConfig `protobuf:"bytes,132,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Monitoring configuration for the cluster.
	MonitoringConfig *MonitoringConfig `protobuf:"bytes,133,opt,name=monitoring_config,json=monitoringConfig,proto3" json:"monitoring_config,omitempty"`
	// Node pool configs that apply to all auto-provisioned node pools
	// in autopilot clusters and node auto-provisioning enabled clusters.
	NodePoolAutoConfig *NodePoolAutoConfig `protobuf:"bytes,136,opt,name=node_pool_auto_config,json=nodePoolAutoConfig,proto3" json:"node_pool_auto_config,omitempty"`
	// This checksum is computed by the server based on the value of cluster
	// fields, and may be sent on update requests to ensure the client has an
	// up-to-date value before proceeding.
	Etag string `protobuf:"bytes,139,opt,name=etag,proto3" json:"etag,omitempty"`
	// Fleet information for the cluster.
	Fleet *Fleet `protobuf:"bytes,140,opt,name=fleet,proto3" json:"fleet,omitempty"`
	// Enable/Disable Security Posture API features for the cluster.
	SecurityPostureConfig *SecurityPostureConfig `protobuf:"bytes,145,opt,name=security_posture_config,json=securityPostureConfig,proto3" json:"security_posture_config,omitempty"`
	// Configuration for all cluster's control plane endpoints.
	ControlPlaneEndpointsConfig *ControlPlaneEndpointsConfig `protobuf:"bytes,146,opt,name=control_plane_endpoints_config,json=controlPlaneEndpointsConfig,proto3" json:"control_plane_endpoints_config,omitempty"`
	// Beta APIs Config
	EnableK8SBetaApis *K8SBetaAPIConfig `protobuf:"bytes,143,opt,name=enable_k8s_beta_apis,json=enableK8sBetaApis,proto3" json:"enable_k8s_beta_apis,omitempty"`
	// GKE Enterprise Configuration.
	EnterpriseConfig *EnterpriseConfig `protobuf:"bytes,149,opt,name=enterprise_config,json=enterpriseConfig,proto3" json:"enterprise_config,omitempty"`
	// Secret CSI driver configuration.
	SecretManagerConfig *SecretManagerConfig `protobuf:"bytes,150,opt,name=secret_manager_config,json=secretManagerConfig,proto3" json:"secret_manager_config,omitempty"`
	// Enable/Disable Compliance Posture features for the cluster.
	CompliancePostureConfig *CompliancePostureConfig `protobuf:"bytes,151,opt,name=compliance_posture_config,json=compliancePostureConfig,proto3" json:"compliance_posture_config,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs *bool `protobuf:"varint,152,opt,name=satisfies_pzs,json=satisfiesPzs,proto3,oneof" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi *bool `protobuf:"varint,153,opt,name=satisfies_pzi,json=satisfiesPzi,proto3,oneof" json:"satisfies_pzi,omitempty"`
	// The Custom keys configuration for the cluster.
	UserManagedKeysConfig *UserManagedKeysConfig `protobuf:"bytes,154,opt,name=user_managed_keys_config,json=userManagedKeysConfig,proto3,oneof" json:"user_managed_keys_config,omitempty"`
	// RBACBindingConfig allows user to restrict ClusterRoleBindings an
	// RoleBindings that can be created.
	RbacBindingConfig *RBACBindingConfig `protobuf:"bytes,156,opt,name=rbac_binding_config,json=rbacBindingConfig,proto3,oneof" json:"rbac_binding_config,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{45}
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Cluster) GetInitialNodeCount() int32 {
	if x != nil {
		return x.InitialNodeCount
	}
	return 0
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Cluster) GetNodeConfig() *NodeConfig {
	if x != nil {
		return x.NodeConfig
	}
	return nil
}

func (x *Cluster) GetMasterAuth() *MasterAuth {
	if x != nil {
		return x.MasterAuth
	}
	return nil
}

func (x *Cluster) GetLoggingService() string {
	if x != nil {
		return x.LoggingService
	}
	return ""
}

func (x *Cluster) GetMonitoringService() string {
	if x != nil {
		return x.MonitoringService
	}
	return ""
}

func (x *Cluster) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Cluster) GetClusterIpv4Cidr() string {
	if x != nil {
		return x.ClusterIpv4Cidr
	}
	return ""
}

func (x *Cluster) GetAddonsConfig() *AddonsConfig {
	if x != nil {
		return x.AddonsConfig
	}
	return nil
}

func (x *Cluster) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *Cluster) GetNodePools() []*NodePool {
	if x != nil {
		return x.NodePools
	}
	return nil
}

func (x *Cluster) GetLocations() []string {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *Cluster) GetEnableKubernetesAlpha() bool {
	if x != nil {
		return x.EnableKubernetesAlpha
	}
	return false
}

func (x *Cluster) GetResourceLabels() map[string]string {
	if x != nil {
		return x.ResourceLabels
	}
	return nil
}

func (x *Cluster) GetLabelFingerprint() string {
	if x != nil {
		return x.LabelFingerprint
	}
	return ""
}

func (x *Cluster) GetLegacyAbac() *LegacyAbac {
	if x != nil {
		return x.LegacyAbac
	}
	return nil
}

func (x *Cluster) GetNetworkPolicy() *NetworkPolicy {
	if x != nil {
		return x.NetworkPolicy
	}
	return nil
}

func (x *Cluster) GetIpAllocationPolicy() *IPAllocationPolicy {
	if x != nil {
		return x.IpAllocationPolicy
	}
	return nil
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Cluster) GetMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if x != nil {
		return x.MasterAuthorizedNetworksConfig
	}
	return nil
}

func (x *Cluster) GetMaintenancePolicy() *MaintenancePolicy {
	if x != nil {
		return x.MaintenancePolicy
	}
	return nil
}

func (x *Cluster) GetBinaryAuthorization() *BinaryAuthorization {
	if x != nil {
		return x.BinaryAuthorization
	}
	return nil
}

func (x *Cluster) GetAutoscaling() *ClusterAutoscaling {
	if x != nil {
		return x.Autoscaling
	}
	return nil
}

func (x *Cluster) GetNetworkConfig() *NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

func (x *Cluster) GetDefaultMaxPodsConstraint() *MaxPodsConstraint {
	if x != nil {
		return x.DefaultMaxPodsConstraint
	}
	return nil
}

func (x *Cluster) GetResourceUsageExportConfig() *ResourceUsageExportConfig {
	if x != nil {
		return x.ResourceUsageExportConfig
	}
	return nil
}

func (x *Cluster) GetAuthenticatorGroupsConfig() *AuthenticatorGroupsConfig {
	if x != nil {
		return x.AuthenticatorGroupsConfig
	}
	return nil
}

func (x *Cluster) GetPrivateClusterConfig() *PrivateClusterConfig {
	if x != nil {
		return x.PrivateClusterConfig
	}
	return nil
}

func (x *Cluster) GetDatabaseEncryption() *DatabaseEncryption {
	if x != nil {
		return x.DatabaseEncryption
	}
	return nil
}

func (x *Cluster) GetVerticalPodAutoscaling() *VerticalPodAutoscaling {
	if x != nil {
		return x.VerticalPodAutoscaling
	}
	return nil
}

func (x *Cluster) GetShieldedNodes() *ShieldedNodes {
	if x != nil {
		return x.ShieldedNodes
	}
	return nil
}

func (x *Cluster) GetReleaseChannel() *ReleaseChannel {
	if x != nil {
		return x.ReleaseChannel
	}
	return nil
}

func (x *Cluster) GetWorkloadIdentityConfig() *WorkloadIdentityConfig {
	if x != nil {
		return x.WorkloadIdentityConfig
	}
	return nil
}

func (x *Cluster) GetMeshCertificates() *MeshCertificates {
	if x != nil {
		return x.MeshCertificates
	}
	return nil
}

func (x *Cluster) GetCostManagementConfig() *CostManagementConfig {
	if x != nil {
		return x.CostManagementConfig
	}
	return nil
}

func (x *Cluster) GetNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.NotificationConfig
	}
	return nil
}

func (x *Cluster) GetConfidentialNodes() *ConfidentialNodes {
	if x != nil {
		return x.ConfidentialNodes
	}
	return nil
}

func (x *Cluster) GetIdentityServiceConfig() *IdentityServiceConfig {
	if x != nil {
		return x.IdentityServiceConfig
	}
	return nil
}

func (x *Cluster) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Cluster) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *Cluster) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *Cluster) GetInitialClusterVersion() string {
	if x != nil {
		return x.InitialClusterVersion
	}
	return ""
}

func (x *Cluster) GetCurrentMasterVersion() string {
	if x != nil {
		return x.CurrentMasterVersion
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Cluster) GetCurrentNodeVersion() string {
	if x != nil {
		return x.CurrentNodeVersion
	}
	return ""
}

func (x *Cluster) GetCreateTime() string {
	if x != nil {
		return x.CreateTime
	}
	return ""
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Cluster) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *Cluster) GetNodeIpv4CidrSize() int32 {
	if x != nil {
		return x.NodeIpv4CidrSize
	}
	return 0
}

func (x *Cluster) GetServicesIpv4Cidr() string {
	if x != nil {
		return x.ServicesIpv4Cidr
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Cluster) GetInstanceGroupUrls() []string {
	if x != nil {
		return x.InstanceGroupUrls
	}
	return nil
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Cluster) GetCurrentNodeCount() int32 {
	if x != nil {
		return x.CurrentNodeCount
	}
	return 0
}

func (x *Cluster) GetExpireTime() string {
	if x != nil {
		return x.ExpireTime
	}
	return ""
}

func (x *Cluster) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Cluster) GetEnableTpu() bool {
	if x != nil {
		return x.EnableTpu
	}
	return false
}

func (x *Cluster) GetTpuIpv4CidrBlock() string {
	if x != nil {
		return x.TpuIpv4CidrBlock
	}
	return ""
}

func (x *Cluster) GetConditions() []*StatusCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *Cluster) GetAutopilot() *Autopilot {
	if x != nil {
		return x.Autopilot
	}
	return nil
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetNodePoolDefaults() *NodePoolDefaults {
	if x != nil {
		return x.NodePoolDefaults
	}
	return nil
}

func (x *Cluster) GetLoggingConfig() *LoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *Cluster) GetMonitoringConfig() *MonitoringConfig {
	if x != nil {
		return x.MonitoringConfig
	}
	return nil
}

func (x *Cluster) GetNodePoolAutoConfig() *NodePoolAutoConfig {
	if x != nil {
		return x.NodePoolAutoConfig
	}
	return nil
}

func (x *Cluster) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Cluster) GetFleet() *Fleet {
	if x != nil {
		return x.Fleet
	}
	return nil
}

func (x *Cluster) GetSecurityPostureConfig() *SecurityPostureConfig {
	if x != nil {
		return x.SecurityPostureConfig
	}
	return nil
}

func (x *Cluster) GetControlPlaneEndpointsConfig() *ControlPlaneEndpointsConfig {
	if x != nil {
		return x.ControlPlaneEndpointsConfig
	}
	return nil
}

func (x *Cluster) GetEnableK8SBetaApis() *K8SBetaAPIConfig {
	if x != nil {
		return x.EnableK8SBetaApis
	}
	return nil
}

func (x *Cluster) GetEnterpriseConfig() *EnterpriseConfig {
	if x != nil {
		return x.EnterpriseConfig
	}
	return nil
}

func (x *Cluster) GetSecretManagerConfig() *SecretManagerConfig {
	if x != nil {
		return x.SecretManagerConfig
	}
	return nil
}

func (x *Cluster) GetCompliancePostureConfig() *CompliancePostureConfig {
	if x != nil {
		return x.CompliancePostureConfig
	}
	return nil
}

func (x *Cluster) GetSatisfiesPzs() bool {
	if x != nil && x.SatisfiesPzs != nil {
		return *x.SatisfiesPzs
	}
	return false
}

func (x *Cluster) GetSatisfiesPzi() bool {
	if x != nil && x.SatisfiesPzi != nil {
		return *x.SatisfiesPzi
	}
	return false
}

func (x *Cluster) GetUserManagedKeysConfig() *UserManagedKeysConfig {
	if x != nil {
		return x.UserManagedKeysConfig
	}
	return nil
}

func (x *Cluster) GetRbacBindingConfig() *RBACBindingConfig {
	if x != nil {
		return x.RbacBindingConfig
	}
	return nil
}

// RBACBindingConfig allows user to restrict ClusterRoleBindings an RoleBindings
// that can be created.
type RBACBindingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Setting this to true will allow any ClusterRoleBinding and RoleBinding
	// with subjets system:anonymous or system:unauthenticated.
	EnableInsecureBindingSystemUnauthenticated *bool `protobuf:"varint,1,opt,name=enable_insecure_binding_system_unauthenticated,json=enableInsecureBindingSystemUnauthenticated,proto3,oneof" json:"enable_insecure_binding_system_unauthenticated,omitempty"`
	// Setting this to true will allow any ClusterRoleBinding and RoleBinding
	// with subjects system:authenticated.
	EnableInsecureBindingSystemAuthenticated *bool `protobuf:"varint,2,opt,name=enable_insecure_binding_system_authenticated,json=enableInsecureBindingSystemAuthenticated,proto3,oneof" json:"enable_insecure_binding_system_authenticated,omitempty"`
}

func (x *RBACBindingConfig) Reset() {
	*x = RBACBindingConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RBACBindingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RBACBindingConfig) ProtoMessage() {}

func (x *RBACBindingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RBACBindingConfig.ProtoReflect.Descriptor instead.
func (*RBACBindingConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{46}
}

func (x *RBACBindingConfig) GetEnableInsecureBindingSystemUnauthenticated() bool {
	if x != nil && x.EnableInsecureBindingSystemUnauthenticated != nil {
		return *x.EnableInsecureBindingSystemUnauthenticated
	}
	return false
}

func (x *RBACBindingConfig) GetEnableInsecureBindingSystemAuthenticated() bool {
	if x != nil && x.EnableInsecureBindingSystemAuthenticated != nil {
		return *x.EnableInsecureBindingSystemAuthenticated
	}
	return false
}

// UserManagedKeysConfig holds the resource address to Keys which are used
// for signing certs and token that are used for communication within cluster.
type UserManagedKeysConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Certificate Authority Service caPool to use for the cluster CA in this
	// cluster.
	ClusterCa string `protobuf:"bytes,10,opt,name=cluster_ca,json=clusterCa,proto3" json:"cluster_ca,omitempty"`
	// Resource path of the Certificate Authority Service caPool to use for the
	// etcd API CA in this cluster.
	EtcdApiCa string `protobuf:"bytes,11,opt,name=etcd_api_ca,json=etcdApiCa,proto3" json:"etcd_api_ca,omitempty"`
	// Resource path of the Certificate Authority Service caPool to use for the
	// etcd peer CA in this cluster.
	EtcdPeerCa string `protobuf:"bytes,12,opt,name=etcd_peer_ca,json=etcdPeerCa,proto3" json:"etcd_peer_ca,omitempty"`
	// The Cloud KMS cryptoKeyVersions to use for signing service account JWTs
	// issued by this cluster.
	//
	// Format:
	// `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
	ServiceAccountSigningKeys []string `protobuf:"bytes,13,rep,name=service_account_signing_keys,json=serviceAccountSigningKeys,proto3" json:"service_account_signing_keys,omitempty"`
	// The Cloud KMS cryptoKeyVersions to use for verifying service account JWTs
	// issued by this cluster.
	//
	// Format:
	// `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{cryptoKey}/cryptoKeyVersions/{cryptoKeyVersion}`
	ServiceAccountVerificationKeys []string `protobuf:"bytes,14,rep,name=service_account_verification_keys,json=serviceAccountVerificationKeys,proto3" json:"service_account_verification_keys,omitempty"`
	// The Certificate Authority Service caPool to use for the aggregation CA in
	// this cluster.
	AggregationCa string `protobuf:"bytes,15,opt,name=aggregation_ca,json=aggregationCa,proto3" json:"aggregation_ca,omitempty"`
	// The Cloud KMS cryptoKey to use for Confidential Hyperdisk on the control
	// plane nodes.
	ControlPlaneDiskEncryptionKey string `protobuf:"bytes,16,opt,name=control_plane_disk_encryption_key,json=controlPlaneDiskEncryptionKey,proto3" json:"control_plane_disk_encryption_key,omitempty"`
	// Resource path of the Cloud KMS cryptoKey to use for encryption of internal
	// etcd backups.
	GkeopsEtcdBackupEncryptionKey string `protobuf:"bytes,17,opt,name=gkeops_etcd_backup_encryption_key,json=gkeopsEtcdBackupEncryptionKey,proto3" json:"gkeops_etcd_backup_encryption_key,omitempty"`
}

func (x *UserManagedKeysConfig) Reset() {
	*x = UserManagedKeysConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserManagedKeysConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserManagedKeysConfig) ProtoMessage() {}

func (x *UserManagedKeysConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserManagedKeysConfig.ProtoReflect.Descriptor instead.
func (*UserManagedKeysConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{47}
}

func (x *UserManagedKeysConfig) GetClusterCa() string {
	if x != nil {
		return x.ClusterCa
	}
	return ""
}

func (x *UserManagedKeysConfig) GetEtcdApiCa() string {
	if x != nil {
		return x.EtcdApiCa
	}
	return ""
}

func (x *UserManagedKeysConfig) GetEtcdPeerCa() string {
	if x != nil {
		return x.EtcdPeerCa
	}
	return ""
}

func (x *UserManagedKeysConfig) GetServiceAccountSigningKeys() []string {
	if x != nil {
		return x.ServiceAccountSigningKeys
	}
	return nil
}

func (x *UserManagedKeysConfig) GetServiceAccountVerificationKeys() []string {
	if x != nil {
		return x.ServiceAccountVerificationKeys
	}
	return nil
}

func (x *UserManagedKeysConfig) GetAggregationCa() string {
	if x != nil {
		return x.AggregationCa
	}
	return ""
}

func (x *UserManagedKeysConfig) GetControlPlaneDiskEncryptionKey() string {
	if x != nil {
		return x.ControlPlaneDiskEncryptionKey
	}
	return ""
}

func (x *UserManagedKeysConfig) GetGkeopsEtcdBackupEncryptionKey() string {
	if x != nil {
		return x.GkeopsEtcdBackupEncryptionKey
	}
	return ""
}

// CompliancePostureConfig defines the settings needed to enable/disable
// features for the Compliance Posture.
type CompliancePostureConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines the enablement mode for Compliance Posture.
	Mode *CompliancePostureConfig_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.container.v1.CompliancePostureConfig_Mode,oneof" json:"mode,omitempty"`
	// List of enabled compliance standards.
	ComplianceStandards []*CompliancePostureConfig_ComplianceStandard `protobuf:"bytes,2,rep,name=compliance_standards,json=complianceStandards,proto3" json:"compliance_standards,omitempty"`
}

func (x *CompliancePostureConfig) Reset() {
	*x = CompliancePostureConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompliancePostureConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompliancePostureConfig) ProtoMessage() {}

func (x *CompliancePostureConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompliancePostureConfig.ProtoReflect.Descriptor instead.
func (*CompliancePostureConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{48}
}

func (x *CompliancePostureConfig) GetMode() CompliancePostureConfig_Mode {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return CompliancePostureConfig_MODE_UNSPECIFIED
}

func (x *CompliancePostureConfig) GetComplianceStandards() []*CompliancePostureConfig_ComplianceStandard {
	if x != nil {
		return x.ComplianceStandards
	}
	return nil
}

// K8sBetaAPIConfig , configuration for beta APIs
type K8SBetaAPIConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enabled k8s beta APIs.
	EnabledApis []string `protobuf:"bytes,1,rep,name=enabled_apis,json=enabledApis,proto3" json:"enabled_apis,omitempty"`
}

func (x *K8SBetaAPIConfig) Reset() {
	*x = K8SBetaAPIConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *K8SBetaAPIConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*K8SBetaAPIConfig) ProtoMessage() {}

func (x *K8SBetaAPIConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use K8SBetaAPIConfig.ProtoReflect.Descriptor instead.
func (*K8SBetaAPIConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{49}
}

func (x *K8SBetaAPIConfig) GetEnabledApis() []string {
	if x != nil {
		return x.EnabledApis
	}
	return nil
}

// SecurityPostureConfig defines the flags needed to enable/disable features for
// the Security Posture API.
type SecurityPostureConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sets which mode to use for Security Posture features.
	Mode *SecurityPostureConfig_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.container.v1.SecurityPostureConfig_Mode,oneof" json:"mode,omitempty"`
	// Sets which mode to use for vulnerability scanning.
	VulnerabilityMode *SecurityPostureConfig_VulnerabilityMode `protobuf:"varint,2,opt,name=vulnerability_mode,json=vulnerabilityMode,proto3,enum=google.container.v1.SecurityPostureConfig_VulnerabilityMode,oneof" json:"vulnerability_mode,omitempty"`
}

func (x *SecurityPostureConfig) Reset() {
	*x = SecurityPostureConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecurityPostureConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityPostureConfig) ProtoMessage() {}

func (x *SecurityPostureConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityPostureConfig.ProtoReflect.Descriptor instead.
func (*SecurityPostureConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{50}
}

func (x *SecurityPostureConfig) GetMode() SecurityPostureConfig_Mode {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return SecurityPostureConfig_MODE_UNSPECIFIED
}

func (x *SecurityPostureConfig) GetVulnerabilityMode() SecurityPostureConfig_VulnerabilityMode {
	if x != nil && x.VulnerabilityMode != nil {
		return *x.VulnerabilityMode
	}
	return SecurityPostureConfig_VULNERABILITY_MODE_UNSPECIFIED
}

// Node pool configs that apply to all auto-provisioned node pools
// in autopilot clusters and node auto-provisioning enabled clusters.
type NodePoolAutoConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of instance tags applied to all nodes. Tags are used to identify
	// valid sources or targets for network firewalls and are specified by
	// the client during cluster creation. Each tag within the list
	// must comply with RFC1035.
	NetworkTags *NetworkTags `protobuf:"bytes,1,opt,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// Resource manager tag keys and values to be attached to the nodes
	// for managing Compute Engine firewalls using Network Firewall Policies.
	ResourceManagerTags *ResourceManagerTags `protobuf:"bytes,2,opt,name=resource_manager_tags,json=resourceManagerTags,proto3" json:"resource_manager_tags,omitempty"`
	// NodeKubeletConfig controls the defaults for autoprovisioned node-pools.
	//
	// Currently only `insecure_kubelet_readonly_port_enabled` can be set here.
	NodeKubeletConfig *NodeKubeletConfig `protobuf:"bytes,3,opt,name=node_kubelet_config,json=nodeKubeletConfig,proto3" json:"node_kubelet_config,omitempty"`
	// Output only. Configuration options for Linux nodes.
	LinuxNodeConfig *LinuxNodeConfig `protobuf:"bytes,4,opt,name=linux_node_config,json=linuxNodeConfig,proto3" json:"linux_node_config,omitempty"`
}

func (x *NodePoolAutoConfig) Reset() {
	*x = NodePoolAutoConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePoolAutoConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePoolAutoConfig) ProtoMessage() {}

func (x *NodePoolAutoConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePoolAutoConfig.ProtoReflect.Descriptor instead.
func (*NodePoolAutoConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{51}
}

func (x *NodePoolAutoConfig) GetNetworkTags() *NetworkTags {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *NodePoolAutoConfig) GetResourceManagerTags() *ResourceManagerTags {
	if x != nil {
		return x.ResourceManagerTags
	}
	return nil
}

func (x *NodePoolAutoConfig) GetNodeKubeletConfig() *NodeKubeletConfig {
	if x != nil {
		return x.NodeKubeletConfig
	}
	return nil
}

func (x *NodePoolAutoConfig) GetLinuxNodeConfig() *LinuxNodeConfig {
	if x != nil {
		return x.LinuxNodeConfig
	}
	return nil
}

// Subset of Nodepool message that has defaults.
type NodePoolDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Subset of NodeConfig message that has defaults.
	NodeConfigDefaults *NodeConfigDefaults `protobuf:"bytes,1,opt,name=node_config_defaults,json=nodeConfigDefaults,proto3" json:"node_config_defaults,omitempty"`
}

func (x *NodePoolDefaults) Reset() {
	*x = NodePoolDefaults{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePoolDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePoolDefaults) ProtoMessage() {}

func (x *NodePoolDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePoolDefaults.ProtoReflect.Descriptor instead.
func (*NodePoolDefaults) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{52}
}

func (x *NodePoolDefaults) GetNodeConfigDefaults() *NodeConfigDefaults {
	if x != nil {
		return x.NodeConfigDefaults
	}
	return nil
}

// Subset of NodeConfig message that has defaults.
type NodeConfigDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// GCFS (Google Container File System, also known as Riptide) options.
	GcfsConfig *GcfsConfig `protobuf:"bytes,1,opt,name=gcfs_config,json=gcfsConfig,proto3" json:"gcfs_config,omitempty"`
	// Logging configuration for node pools.
	LoggingConfig *NodePoolLoggingConfig `protobuf:"bytes,3,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// Parameters for containerd customization.
	ContainerdConfig *ContainerdConfig `protobuf:"bytes,4,opt,name=containerd_config,json=containerdConfig,proto3" json:"containerd_config,omitempty"`
	// NodeKubeletConfig controls the defaults for new node-pools.
	//
	// Currently only `insecure_kubelet_readonly_port_enabled` can be set here.
	NodeKubeletConfig *NodeKubeletConfig `protobuf:"bytes,6,opt,name=node_kubelet_config,json=nodeKubeletConfig,proto3" json:"node_kubelet_config,omitempty"`
}

func (x *NodeConfigDefaults) Reset() {
	*x = NodeConfigDefaults{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeConfigDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeConfigDefaults) ProtoMessage() {}

func (x *NodeConfigDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeConfigDefaults.ProtoReflect.Descriptor instead.
func (*NodeConfigDefaults) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{53}
}

func (x *NodeConfigDefaults) GetGcfsConfig() *GcfsConfig {
	if x != nil {
		return x.GcfsConfig
	}
	return nil
}

func (x *NodeConfigDefaults) GetLoggingConfig() *NodePoolLoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *NodeConfigDefaults) GetContainerdConfig() *ContainerdConfig {
	if x != nil {
		return x.ContainerdConfig
	}
	return nil
}

func (x *NodeConfigDefaults) GetNodeKubeletConfig() *NodeKubeletConfig {
	if x != nil {
		return x.NodeKubeletConfig
	}
	return nil
}

// ClusterUpdate describes an update to the cluster. Exactly one update can
// be applied to a cluster with each request, so at most one field can be
// provided.
type ClusterUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Kubernetes version to change the nodes to (typically an
	// upgrade).
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the Kubernetes master version
	DesiredNodeVersion string `protobuf:"bytes,4,opt,name=desired_node_version,json=desiredNodeVersion,proto3" json:"desired_node_version,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
	// service with a Kubernetes-native resource model
	//   - `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
	//     longer available as of GKE 1.15).
	//   - `none` - No metrics will be exported from the cluster.
	//
	// If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
	DesiredMonitoringService string `protobuf:"bytes,5,opt,name=desired_monitoring_service,json=desiredMonitoringService,proto3" json:"desired_monitoring_service,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	DesiredAddonsConfig *AddonsConfig `protobuf:"bytes,6,opt,name=desired_addons_config,json=desiredAddonsConfig,proto3" json:"desired_addons_config,omitempty"`
	// The node pool to be upgraded. This field is mandatory if
	// "desired_node_version", "desired_image_family" or
	// "desired_node_pool_autoscaling" is specified and there is more than one
	// node pool on the cluster.
	DesiredNodePoolId string `protobuf:"bytes,7,opt,name=desired_node_pool_id,json=desiredNodePoolId,proto3" json:"desired_node_pool_id,omitempty"`
	// The desired image type for the node pool.
	// NOTE: Set the "desired_node_pool" field as well.
	DesiredImageType string `protobuf:"bytes,8,opt,name=desired_image_type,json=desiredImageType,proto3" json:"desired_image_type,omitempty"`
	// Configuration of etcd encryption.
	DesiredDatabaseEncryption *DatabaseEncryption `protobuf:"bytes,46,opt,name=desired_database_encryption,json=desiredDatabaseEncryption,proto3" json:"desired_database_encryption,omitempty"`
	// Configuration for Workload Identity.
	DesiredWorkloadIdentityConfig *WorkloadIdentityConfig `protobuf:"bytes,47,opt,name=desired_workload_identity_config,json=desiredWorkloadIdentityConfig,proto3" json:"desired_workload_identity_config,omitempty"`
	// Configuration for issuance of mTLS keys and certificates to Kubernetes
	// pods.
	DesiredMeshCertificates *MeshCertificates `protobuf:"bytes,67,opt,name=desired_mesh_certificates,json=desiredMeshCertificates,proto3" json:"desired_mesh_certificates,omitempty"`
	// Configuration for Shielded Nodes.
	DesiredShieldedNodes *ShieldedNodes `protobuf:"bytes,48,opt,name=desired_shielded_nodes,json=desiredShieldedNodes,proto3" json:"desired_shielded_nodes,omitempty"`
	// The desired configuration for the fine-grained cost management feature.
	DesiredCostManagementConfig *CostManagementConfig `protobuf:"bytes,49,opt,name=desired_cost_management_config,json=desiredCostManagementConfig,proto3" json:"desired_cost_management_config,omitempty"`
	// DNSConfig contains clusterDNS config for this cluster.
	DesiredDnsConfig *DNSConfig `protobuf:"bytes,53,opt,name=desired_dns_config,json=desiredDnsConfig,proto3" json:"desired_dns_config,omitempty"`
	// Autoscaler configuration for the node pool specified in
	// desired_node_pool_id. If there is only one pool in the
	// cluster and desired_node_pool_id is not provided then
	// the change applies to that single node pool.
	DesiredNodePoolAutoscaling *NodePoolAutoscaling `protobuf:"bytes,9,opt,name=desired_node_pool_autoscaling,json=desiredNodePoolAutoscaling,proto3" json:"desired_node_pool_autoscaling,omitempty"`
	// The desired list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster's nodes should be located.
	//
	// This list must always include the cluster's primary zone.
	//
	// Warning: changing cluster locations will update the locations of all node
	// pools and will result in nodes being added and/or removed.
	DesiredLocations []string `protobuf:"bytes,10,rep,name=desired_locations,json=desiredLocations,proto3" json:"desired_locations,omitempty"`
	// The desired configuration options for master authorized networks feature.
	//
	// Deprecated: Use
	// desired_control_plane_endpoints_config.ip_endpoints_config.authorized_networks_config
	// instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	DesiredMasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,12,opt,name=desired_master_authorized_networks_config,json=desiredMasterAuthorizedNetworksConfig,proto3" json:"desired_master_authorized_networks_config,omitempty"`
	// Cluster-level autoscaling configuration.
	DesiredClusterAutoscaling *ClusterAutoscaling `protobuf:"bytes,15,opt,name=desired_cluster_autoscaling,json=desiredClusterAutoscaling,proto3" json:"desired_cluster_autoscaling,omitempty"`
	// The desired configuration options for the Binary Authorization feature.
	DesiredBinaryAuthorization *BinaryAuthorization `protobuf:"bytes,16,opt,name=desired_binary_authorization,json=desiredBinaryAuthorization,proto3" json:"desired_binary_authorization,omitempty"`
	// The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com/kubernetes` - The Cloud Logging
	// service with a Kubernetes-native resource model
	//   - `logging.googleapis.com` - The legacy Cloud Logging service (no longer
	//     available as of GKE 1.15).
	//   - `none` - no logs will be exported from the cluster.
	//
	// If left as an empty string,`logging.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
	DesiredLoggingService string `protobuf:"bytes,19,opt,name=desired_logging_service,json=desiredLoggingService,proto3" json:"desired_logging_service,omitempty"`
	// The desired configuration for exporting resource usage.
	DesiredResourceUsageExportConfig *ResourceUsageExportConfig `protobuf:"bytes,21,opt,name=desired_resource_usage_export_config,json=desiredResourceUsageExportConfig,proto3" json:"desired_resource_usage_export_config,omitempty"`
	// Cluster-level Vertical Pod Autoscaling configuration.
	DesiredVerticalPodAutoscaling *VerticalPodAutoscaling `protobuf:"bytes,22,opt,name=desired_vertical_pod_autoscaling,json=desiredVerticalPodAutoscaling,proto3" json:"desired_vertical_pod_autoscaling,omitempty"`
	// The desired private cluster configuration. master_global_access_config is
	// the only field that can be changed via this field.
	// See also
	// [ClusterUpdate.desired_enable_private_endpoint][google.container.v1.ClusterUpdate.desired_enable_private_endpoint]
	// for modifying other fields within
	// [PrivateClusterConfig][google.container.v1.PrivateClusterConfig].
	//
	// Deprecated: Use
	// desired_control_plane_endpoints_config.ip_endpoints_config.global_access
	// instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	DesiredPrivateClusterConfig *PrivateClusterConfig `protobuf:"bytes,25,opt,name=desired_private_cluster_config,json=desiredPrivateClusterConfig,proto3" json:"desired_private_cluster_config,omitempty"`
	// The desired config of Intra-node visibility.
	DesiredIntraNodeVisibilityConfig *IntraNodeVisibilityConfig `protobuf:"bytes,26,opt,name=desired_intra_node_visibility_config,json=desiredIntraNodeVisibilityConfig,proto3" json:"desired_intra_node_visibility_config,omitempty"`
	// The desired status of whether to disable default sNAT for this cluster.
	DesiredDefaultSnatStatus *DefaultSnatStatus `protobuf:"bytes,28,opt,name=desired_default_snat_status,json=desiredDefaultSnatStatus,proto3" json:"desired_default_snat_status,omitempty"`
	// The desired release channel configuration.
	DesiredReleaseChannel *ReleaseChannel `protobuf:"bytes,31,opt,name=desired_release_channel,json=desiredReleaseChannel,proto3" json:"desired_release_channel,omitempty"`
	// The desired L4 Internal Load Balancer Subsetting configuration.
	DesiredL4IlbSubsettingConfig *ILBSubsettingConfig `protobuf:"bytes,39,opt,name=desired_l4ilb_subsetting_config,json=desiredL4ilbSubsettingConfig,proto3" json:"desired_l4ilb_subsetting_config,omitempty"`
	// The desired datapath provider for the cluster.
	DesiredDatapathProvider DatapathProvider `protobuf:"varint,50,opt,name=desired_datapath_provider,json=desiredDatapathProvider,proto3,enum=google.container.v1.DatapathProvider" json:"desired_datapath_provider,omitempty"`
	// The desired state of IPv6 connectivity to Google Services.
	DesiredPrivateIpv6GoogleAccess PrivateIPv6GoogleAccess `protobuf:"varint,51,opt,name=desired_private_ipv6_google_access,json=desiredPrivateIpv6GoogleAccess,proto3,enum=google.container.v1.PrivateIPv6GoogleAccess" json:"desired_private_ipv6_google_access,omitempty"`
	// The desired notification configuration.
	DesiredNotificationConfig *NotificationConfig `protobuf:"bytes,55,opt,name=desired_notification_config,json=desiredNotificationConfig,proto3" json:"desired_notification_config,omitempty"`
	// The desired authenticator groups config for the cluster.
	DesiredAuthenticatorGroupsConfig *AuthenticatorGroupsConfig `protobuf:"bytes,63,opt,name=desired_authenticator_groups_config,json=desiredAuthenticatorGroupsConfig,proto3" json:"desired_authenticator_groups_config,omitempty"`
	// The desired logging configuration.
	DesiredLoggingConfig *LoggingConfig `protobuf:"bytes,64,opt,name=desired_logging_config,json=desiredLoggingConfig,proto3" json:"desired_logging_config,omitempty"`
	// The desired monitoring configuration.
	DesiredMonitoringConfig *MonitoringConfig `protobuf:"bytes,65,opt,name=desired_monitoring_config,json=desiredMonitoringConfig,proto3" json:"desired_monitoring_config,omitempty"`
	// The desired Identity Service component configuration.
	DesiredIdentityServiceConfig *IdentityServiceConfig `protobuf:"bytes,66,opt,name=desired_identity_service_config,json=desiredIdentityServiceConfig,proto3" json:"desired_identity_service_config,omitempty"`
	// ServiceExternalIPsConfig specifies the config for the use of Services with
	// ExternalIPs field.
	DesiredServiceExternalIpsConfig *ServiceExternalIPsConfig `protobuf:"bytes,60,opt,name=desired_service_external_ips_config,json=desiredServiceExternalIpsConfig,proto3" json:"desired_service_external_ips_config,omitempty"`
	// Enable/Disable private endpoint for the cluster's master.
	//
	// Deprecated: Use
	// desired_control_plane_endpoints_config.ip_endpoints_config.enable_public_endpoint
	// instead. Note that the value of enable_public_endpoint is reversed: if
	// enable_private_endpoint is false, then enable_public_endpoint will be true.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	DesiredEnablePrivateEndpoint *bool `protobuf:"varint,71,opt,name=desired_enable_private_endpoint,json=desiredEnablePrivateEndpoint,proto3,oneof" json:"desired_enable_private_endpoint,omitempty"`
	// Override the default setting of whether future created
	// nodes have private IP addresses only, namely
	// [NetworkConfig.default_enable_private_nodes][google.container.v1.NetworkConfig.default_enable_private_nodes]
	DesiredDefaultEnablePrivateNodes *bool `protobuf:"varint,72,opt,name=desired_default_enable_private_nodes,json=desiredDefaultEnablePrivateNodes,proto3,oneof" json:"desired_default_enable_private_nodes,omitempty"`
	// [Control plane
	// endpoints][google.container.v1.Cluster.control_plane_endpoints_config]
	// configuration.
	DesiredControlPlaneEndpointsConfig *ControlPlaneEndpointsConfig `protobuf:"bytes,73,opt,name=desired_control_plane_endpoints_config,json=desiredControlPlaneEndpointsConfig,proto3" json:"desired_control_plane_endpoints_config,omitempty"`
	// The Kubernetes version to change the master to.
	//
	// Users may specify either explicit versions offered by
	// Kubernetes Engine or version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the default Kubernetes version
	DesiredMasterVersion string `protobuf:"bytes,100,opt,name=desired_master_version,json=desiredMasterVersion,proto3" json:"desired_master_version,omitempty"`
	// The desired GCFS config for the cluster
	DesiredGcfsConfig *GcfsConfig `protobuf:"bytes,109,opt,name=desired_gcfs_config,json=desiredGcfsConfig,proto3" json:"desired_gcfs_config,omitempty"`
	// The desired network tags that apply to all auto-provisioned node pools
	// in autopilot clusters and node auto-provisioning enabled clusters.
	DesiredNodePoolAutoConfigNetworkTags *NetworkTags `protobuf:"bytes,110,opt,name=desired_node_pool_auto_config_network_tags,json=desiredNodePoolAutoConfigNetworkTags,proto3" json:"desired_node_pool_auto_config_network_tags,omitempty"`
	// The desired config of Gateway API on this cluster.
	DesiredGatewayApiConfig *GatewayAPIConfig `protobuf:"bytes,114,opt,name=desired_gateway_api_config,json=desiredGatewayApiConfig,proto3" json:"desired_gateway_api_config,omitempty"`
	// The current etag of the cluster.
	// If an etag is provided and does not match the current etag of the cluster,
	// update will be blocked and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,115,opt,name=etag,proto3" json:"etag,omitempty"`
	// The desired node pool logging configuration defaults for the cluster.
	DesiredNodePoolLoggingConfig *NodePoolLoggingConfig `protobuf:"bytes,116,opt,name=desired_node_pool_logging_config,json=desiredNodePoolLoggingConfig,proto3" json:"desired_node_pool_logging_config,omitempty"`
	// The desired fleet configuration for the cluster.
	DesiredFleet *Fleet `protobuf:"bytes,117,opt,name=desired_fleet,json=desiredFleet,proto3" json:"desired_fleet,omitempty"`
	// The desired stack type of the cluster.
	// If a stack type is provided and does not match the current stack type of
	// the cluster, update will attempt to change the stack type to the new type.
	DesiredStackType StackType `protobuf:"varint,119,opt,name=desired_stack_type,json=desiredStackType,proto3,enum=google.container.v1.StackType" json:"desired_stack_type,omitempty"`
	// The additional pod ranges to be added to the cluster. These pod ranges
	// can be used by node pools to allocate pod IPs.
	AdditionalPodRangesConfig *AdditionalPodRangesConfig `protobuf:"bytes,120,opt,name=additional_pod_ranges_config,json=additionalPodRangesConfig,proto3" json:"additional_pod_ranges_config,omitempty"`
	// The additional pod ranges that are to be removed from the cluster.
	// The pod ranges specified here must have been specified earlier in the
	// 'additional_pod_ranges_config' argument.
	RemovedAdditionalPodRangesConfig *AdditionalPodRangesConfig `protobuf:"bytes,121,opt,name=removed_additional_pod_ranges_config,json=removedAdditionalPodRangesConfig,proto3" json:"removed_additional_pod_ranges_config,omitempty"`
	// Kubernetes open source beta apis enabled on the cluster. Only beta apis
	EnableK8SBetaApis *K8SBetaAPIConfig `protobuf:"bytes,122,opt,name=enable_k8s_beta_apis,json=enableK8sBetaApis,proto3" json:"enable_k8s_beta_apis,omitempty"`
	// Enable/Disable Security Posture API features for the cluster.
	DesiredSecurityPostureConfig *SecurityPostureConfig `protobuf:"bytes,124,opt,name=desired_security_posture_config,json=desiredSecurityPostureConfig,proto3" json:"desired_security_posture_config,omitempty"`
	// The desired network performance config.
	DesiredNetworkPerformanceConfig *NetworkConfig_ClusterNetworkPerformanceConfig `protobuf:"bytes,125,opt,name=desired_network_performance_config,json=desiredNetworkPerformanceConfig,proto3" json:"desired_network_performance_config,omitempty"`
	// Enable/Disable FQDN Network Policy for the cluster.
	DesiredEnableFqdnNetworkPolicy *bool `protobuf:"varint,126,opt,name=desired_enable_fqdn_network_policy,json=desiredEnableFqdnNetworkPolicy,proto3,oneof" json:"desired_enable_fqdn_network_policy,omitempty"`
	// The desired workload policy configuration for the autopilot cluster.
	DesiredAutopilotWorkloadPolicyConfig *WorkloadPolicyConfig `protobuf:"bytes,128,opt,name=desired_autopilot_workload_policy_config,json=desiredAutopilotWorkloadPolicyConfig,proto3" json:"desired_autopilot_workload_policy_config,omitempty"`
	// Desired Beta APIs to be enabled for cluster.
	DesiredK8SBetaApis *K8SBetaAPIConfig `protobuf:"bytes,131,opt,name=desired_k8s_beta_apis,json=desiredK8sBetaApis,proto3" json:"desired_k8s_beta_apis,omitempty"`
	// The desired containerd config for the cluster.
	DesiredContainerdConfig *ContainerdConfig `protobuf:"bytes,134,opt,name=desired_containerd_config,json=desiredContainerdConfig,proto3" json:"desired_containerd_config,omitempty"`
	// Enable/Disable Multi-Networking for the cluster
	DesiredEnableMultiNetworking *bool `protobuf:"varint,135,opt,name=desired_enable_multi_networking,json=desiredEnableMultiNetworking,proto3,oneof" json:"desired_enable_multi_networking,omitempty"`
	// The desired resource manager tags that apply to all auto-provisioned node
	// pools in autopilot clusters and node auto-provisioning enabled clusters.
	DesiredNodePoolAutoConfigResourceManagerTags *ResourceManagerTags `protobuf:"bytes,136,opt,name=desired_node_pool_auto_config_resource_manager_tags,json=desiredNodePoolAutoConfigResourceManagerTags,proto3" json:"desired_node_pool_auto_config_resource_manager_tags,omitempty"`
	// Specify the details of in-transit encryption.
	DesiredInTransitEncryptionConfig *InTransitEncryptionConfig `protobuf:"varint,137,opt,name=desired_in_transit_encryption_config,json=desiredInTransitEncryptionConfig,proto3,enum=google.container.v1.InTransitEncryptionConfig,oneof" json:"desired_in_transit_encryption_config,omitempty"`
	// Enable/Disable Cilium Clusterwide Network Policy for the cluster.
	DesiredEnableCiliumClusterwideNetworkPolicy *bool `protobuf:"varint,138,opt,name=desired_enable_cilium_clusterwide_network_policy,json=desiredEnableCiliumClusterwideNetworkPolicy,proto3,oneof" json:"desired_enable_cilium_clusterwide_network_policy,omitempty"`
	// Enable/Disable Secret Manager Config.
	DesiredSecretManagerConfig *SecretManagerConfig `protobuf:"bytes,139,opt,name=desired_secret_manager_config,json=desiredSecretManagerConfig,proto3,oneof" json:"desired_secret_manager_config,omitempty"`
	// Enable/Disable Compliance Posture features for the cluster.
	DesiredCompliancePostureConfig *CompliancePostureConfig `protobuf:"bytes,140,opt,name=desired_compliance_posture_config,json=desiredCompliancePostureConfig,proto3,oneof" json:"desired_compliance_posture_config,omitempty"`
	// The desired node kubelet config for the cluster.
	DesiredNodeKubeletConfig *NodeKubeletConfig `protobuf:"bytes,141,opt,name=desired_node_kubelet_config,json=desiredNodeKubeletConfig,proto3" json:"desired_node_kubelet_config,omitempty"`
	// The desired node kubelet config for all auto-provisioned node pools
	// in autopilot clusters and node auto-provisioning enabled clusters.
	DesiredNodePoolAutoConfigKubeletConfig *NodeKubeletConfig `protobuf:"bytes,142,opt,name=desired_node_pool_auto_config_kubelet_config,json=desiredNodePoolAutoConfigKubeletConfig,proto3" json:"desired_node_pool_auto_config_kubelet_config,omitempty"`
	// The Custom keys configuration for the cluster.
	UserManagedKeysConfig *UserManagedKeysConfig `protobuf:"bytes,143,opt,name=user_managed_keys_config,json=userManagedKeysConfig,proto3" json:"user_managed_keys_config,omitempty"`
	// RBACBindingConfig allows user to restrict ClusterRoleBindings an
	// RoleBindings that can be created.
	DesiredRbacBindingConfig *RBACBindingConfig `protobuf:"bytes,144,opt,name=desired_rbac_binding_config,json=desiredRbacBindingConfig,proto3,oneof" json:"desired_rbac_binding_config,omitempty"`
	// The desired enterprise configuration for the cluster.
	DesiredEnterpriseConfig *DesiredEnterpriseConfig `protobuf:"bytes,147,opt,name=desired_enterprise_config,json=desiredEnterpriseConfig,proto3" json:"desired_enterprise_config,omitempty"`
	// The desired Linux node config for all auto-provisioned node pools
	// in autopilot clusters and node auto-provisioning enabled clusters.
	//
	// Currently only `cgroup_mode` can be set here.
	DesiredNodePoolAutoConfigLinuxNodeConfig *LinuxNodeConfig `protobuf:"bytes,150,opt,name=desired_node_pool_auto_config_linux_node_config,json=desiredNodePoolAutoConfigLinuxNodeConfig,proto3" json:"desired_node_pool_auto_config_linux_node_config,omitempty"`
}

func (x *ClusterUpdate) Reset() {
	*x = ClusterUpdate{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterUpdate) ProtoMessage() {}

func (x *ClusterUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterUpdate.ProtoReflect.Descriptor instead.
func (*ClusterUpdate) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{54}
}

func (x *ClusterUpdate) GetDesiredNodeVersion() string {
	if x != nil {
		return x.DesiredNodeVersion
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredMonitoringService() string {
	if x != nil {
		return x.DesiredMonitoringService
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredAddonsConfig() *AddonsConfig {
	if x != nil {
		return x.DesiredAddonsConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredNodePoolId() string {
	if x != nil {
		return x.DesiredNodePoolId
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredImageType() string {
	if x != nil {
		return x.DesiredImageType
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredDatabaseEncryption() *DatabaseEncryption {
	if x != nil {
		return x.DesiredDatabaseEncryption
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredWorkloadIdentityConfig() *WorkloadIdentityConfig {
	if x != nil {
		return x.DesiredWorkloadIdentityConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredMeshCertificates() *MeshCertificates {
	if x != nil {
		return x.DesiredMeshCertificates
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredShieldedNodes() *ShieldedNodes {
	if x != nil {
		return x.DesiredShieldedNodes
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredCostManagementConfig() *CostManagementConfig {
	if x != nil {
		return x.DesiredCostManagementConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredDnsConfig() *DNSConfig {
	if x != nil {
		return x.DesiredDnsConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredNodePoolAutoscaling() *NodePoolAutoscaling {
	if x != nil {
		return x.DesiredNodePoolAutoscaling
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredLocations() []string {
	if x != nil {
		return x.DesiredLocations
	}
	return nil
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *ClusterUpdate) GetDesiredMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if x != nil {
		return x.DesiredMasterAuthorizedNetworksConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredClusterAutoscaling() *ClusterAutoscaling {
	if x != nil {
		return x.DesiredClusterAutoscaling
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredBinaryAuthorization() *BinaryAuthorization {
	if x != nil {
		return x.DesiredBinaryAuthorization
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredLoggingService() string {
	if x != nil {
		return x.DesiredLoggingService
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredResourceUsageExportConfig() *ResourceUsageExportConfig {
	if x != nil {
		return x.DesiredResourceUsageExportConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredVerticalPodAutoscaling() *VerticalPodAutoscaling {
	if x != nil {
		return x.DesiredVerticalPodAutoscaling
	}
	return nil
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *ClusterUpdate) GetDesiredPrivateClusterConfig() *PrivateClusterConfig {
	if x != nil {
		return x.DesiredPrivateClusterConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredIntraNodeVisibilityConfig() *IntraNodeVisibilityConfig {
	if x != nil {
		return x.DesiredIntraNodeVisibilityConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredDefaultSnatStatus() *DefaultSnatStatus {
	if x != nil {
		return x.DesiredDefaultSnatStatus
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredReleaseChannel() *ReleaseChannel {
	if x != nil {
		return x.DesiredReleaseChannel
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredL4IlbSubsettingConfig() *ILBSubsettingConfig {
	if x != nil {
		return x.DesiredL4IlbSubsettingConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredDatapathProvider() DatapathProvider {
	if x != nil {
		return x.DesiredDatapathProvider
	}
	return DatapathProvider_DATAPATH_PROVIDER_UNSPECIFIED
}

func (x *ClusterUpdate) GetDesiredPrivateIpv6GoogleAccess() PrivateIPv6GoogleAccess {
	if x != nil {
		return x.DesiredPrivateIpv6GoogleAccess
	}
	return PrivateIPv6GoogleAccess_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
}

func (x *ClusterUpdate) GetDesiredNotificationConfig() *NotificationConfig {
	if x != nil {
		return x.DesiredNotificationConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredAuthenticatorGroupsConfig() *AuthenticatorGroupsConfig {
	if x != nil {
		return x.DesiredAuthenticatorGroupsConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredLoggingConfig() *LoggingConfig {
	if x != nil {
		return x.DesiredLoggingConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredMonitoringConfig() *MonitoringConfig {
	if x != nil {
		return x.DesiredMonitoringConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredIdentityServiceConfig() *IdentityServiceConfig {
	if x != nil {
		return x.DesiredIdentityServiceConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredServiceExternalIpsConfig() *ServiceExternalIPsConfig {
	if x != nil {
		return x.DesiredServiceExternalIpsConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *ClusterUpdate) GetDesiredEnablePrivateEndpoint() bool {
	if x != nil && x.DesiredEnablePrivateEndpoint != nil {
		return *x.DesiredEnablePrivateEndpoint
	}
	return false
}

func (x *ClusterUpdate) GetDesiredDefaultEnablePrivateNodes() bool {
	if x != nil && x.DesiredDefaultEnablePrivateNodes != nil {
		return *x.DesiredDefaultEnablePrivateNodes
	}
	return false
}

func (x *ClusterUpdate) GetDesiredControlPlaneEndpointsConfig() *ControlPlaneEndpointsConfig {
	if x != nil {
		return x.DesiredControlPlaneEndpointsConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredMasterVersion() string {
	if x != nil {
		return x.DesiredMasterVersion
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredGcfsConfig() *GcfsConfig {
	if x != nil {
		return x.DesiredGcfsConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredNodePoolAutoConfigNetworkTags() *NetworkTags {
	if x != nil {
		return x.DesiredNodePoolAutoConfigNetworkTags
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredGatewayApiConfig() *GatewayAPIConfig {
	if x != nil {
		return x.DesiredGatewayApiConfig
	}
	return nil
}

func (x *ClusterUpdate) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *ClusterUpdate) GetDesiredNodePoolLoggingConfig() *NodePoolLoggingConfig {
	if x != nil {
		return x.DesiredNodePoolLoggingConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredFleet() *Fleet {
	if x != nil {
		return x.DesiredFleet
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredStackType() StackType {
	if x != nil {
		return x.DesiredStackType
	}
	return StackType_STACK_TYPE_UNSPECIFIED
}

func (x *ClusterUpdate) GetAdditionalPodRangesConfig() *AdditionalPodRangesConfig {
	if x != nil {
		return x.AdditionalPodRangesConfig
	}
	return nil
}

func (x *ClusterUpdate) GetRemovedAdditionalPodRangesConfig() *AdditionalPodRangesConfig {
	if x != nil {
		return x.RemovedAdditionalPodRangesConfig
	}
	return nil
}

func (x *ClusterUpdate) GetEnableK8SBetaApis() *K8SBetaAPIConfig {
	if x != nil {
		return x.EnableK8SBetaApis
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredSecurityPostureConfig() *SecurityPostureConfig {
	if x != nil {
		return x.DesiredSecurityPostureConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredNetworkPerformanceConfig() *NetworkConfig_ClusterNetworkPerformanceConfig {
	if x != nil {
		return x.DesiredNetworkPerformanceConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredEnableFqdnNetworkPolicy() bool {
	if x != nil && x.DesiredEnableFqdnNetworkPolicy != nil {
		return *x.DesiredEnableFqdnNetworkPolicy
	}
	return false
}

func (x *ClusterUpdate) GetDesiredAutopilotWorkloadPolicyConfig() *WorkloadPolicyConfig {
	if x != nil {
		return x.DesiredAutopilotWorkloadPolicyConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredK8SBetaApis() *K8SBetaAPIConfig {
	if x != nil {
		return x.DesiredK8SBetaApis
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredContainerdConfig() *ContainerdConfig {
	if x != nil {
		return x.DesiredContainerdConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredEnableMultiNetworking() bool {
	if x != nil && x.DesiredEnableMultiNetworking != nil {
		return *x.DesiredEnableMultiNetworking
	}
	return false
}

func (x *ClusterUpdate) GetDesiredNodePoolAutoConfigResourceManagerTags() *ResourceManagerTags {
	if x != nil {
		return x.DesiredNodePoolAutoConfigResourceManagerTags
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredInTransitEncryptionConfig() InTransitEncryptionConfig {
	if x != nil && x.DesiredInTransitEncryptionConfig != nil {
		return *x.DesiredInTransitEncryptionConfig
	}
	return InTransitEncryptionConfig_IN_TRANSIT_ENCRYPTION_CONFIG_UNSPECIFIED
}

func (x *ClusterUpdate) GetDesiredEnableCiliumClusterwideNetworkPolicy() bool {
	if x != nil && x.DesiredEnableCiliumClusterwideNetworkPolicy != nil {
		return *x.DesiredEnableCiliumClusterwideNetworkPolicy
	}
	return false
}

func (x *ClusterUpdate) GetDesiredSecretManagerConfig() *SecretManagerConfig {
	if x != nil {
		return x.DesiredSecretManagerConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredCompliancePostureConfig() *CompliancePostureConfig {
	if x != nil {
		return x.DesiredCompliancePostureConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredNodeKubeletConfig() *NodeKubeletConfig {
	if x != nil {
		return x.DesiredNodeKubeletConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredNodePoolAutoConfigKubeletConfig() *NodeKubeletConfig {
	if x != nil {
		return x.DesiredNodePoolAutoConfigKubeletConfig
	}
	return nil
}

func (x *ClusterUpdate) GetUserManagedKeysConfig() *UserManagedKeysConfig {
	if x != nil {
		return x.UserManagedKeysConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredRbacBindingConfig() *RBACBindingConfig {
	if x != nil {
		return x.DesiredRbacBindingConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredEnterpriseConfig() *DesiredEnterpriseConfig {
	if x != nil {
		return x.DesiredEnterpriseConfig
	}
	return nil
}

func (x *ClusterUpdate) GetDesiredNodePoolAutoConfigLinuxNodeConfig() *LinuxNodeConfig {
	if x != nil {
		return x.DesiredNodePoolAutoConfigLinuxNodeConfig
	}
	return nil
}

// AdditionalPodRangesConfig is the configuration for additional pod secondary
// ranges supporting the ClusterUpdate message.
type AdditionalPodRangesConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name for pod secondary ipv4 range which has the actual range defined ahead.
	PodRangeNames []string `protobuf:"bytes,1,rep,name=pod_range_names,json=podRangeNames,proto3" json:"pod_range_names,omitempty"`
	// Output only. Information for additional pod range.
	PodRangeInfo []*RangeInfo `protobuf:"bytes,2,rep,name=pod_range_info,json=podRangeInfo,proto3" json:"pod_range_info,omitempty"`
}

func (x *AdditionalPodRangesConfig) Reset() {
	*x = AdditionalPodRangesConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdditionalPodRangesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdditionalPodRangesConfig) ProtoMessage() {}

func (x *AdditionalPodRangesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdditionalPodRangesConfig.ProtoReflect.Descriptor instead.
func (*AdditionalPodRangesConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{55}
}

func (x *AdditionalPodRangesConfig) GetPodRangeNames() []string {
	if x != nil {
		return x.PodRangeNames
	}
	return nil
}

func (x *AdditionalPodRangesConfig) GetPodRangeInfo() []*RangeInfo {
	if x != nil {
		return x.PodRangeInfo
	}
	return nil
}

// RangeInfo contains the range name and the range utilization by this cluster.
type RangeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of a range.
	RangeName string `protobuf:"bytes,1,opt,name=range_name,json=rangeName,proto3" json:"range_name,omitempty"`
	// Output only. The utilization of the range.
	Utilization float64 `protobuf:"fixed64,2,opt,name=utilization,proto3" json:"utilization,omitempty"`
}

func (x *RangeInfo) Reset() {
	*x = RangeInfo{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RangeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RangeInfo) ProtoMessage() {}

func (x *RangeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RangeInfo.ProtoReflect.Descriptor instead.
func (*RangeInfo) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{56}
}

func (x *RangeInfo) GetRangeName() string {
	if x != nil {
		return x.RangeName
	}
	return ""
}

func (x *RangeInfo) GetUtilization() float64 {
	if x != nil {
		return x.Utilization
	}
	return 0
}

// DesiredEnterpriseConfig is a wrapper used for updating enterprise_config.
type DesiredEnterpriseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// desired_tier specifies the desired tier of the cluster.
	DesiredTier EnterpriseConfig_ClusterTier `protobuf:"varint,1,opt,name=desired_tier,json=desiredTier,proto3,enum=google.container.v1.EnterpriseConfig_ClusterTier" json:"desired_tier,omitempty"`
}

func (x *DesiredEnterpriseConfig) Reset() {
	*x = DesiredEnterpriseConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DesiredEnterpriseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DesiredEnterpriseConfig) ProtoMessage() {}

func (x *DesiredEnterpriseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DesiredEnterpriseConfig.ProtoReflect.Descriptor instead.
func (*DesiredEnterpriseConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{57}
}

func (x *DesiredEnterpriseConfig) GetDesiredTier() EnterpriseConfig_ClusterTier {
	if x != nil {
		return x.DesiredTier
	}
	return EnterpriseConfig_CLUSTER_TIER_UNSPECIFIED
}

// This operation resource represents operations that may have happened or are
// happening on the cluster. All fields are output only.
type Operation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The server-assigned ID for the operation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// operation is taking place. This field is deprecated, use location instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Output only. The operation type.
	OperationType Operation_Type `protobuf:"varint,3,opt,name=operation_type,json=operationType,proto3,enum=google.container.v1.Operation_Type" json:"operation_type,omitempty"`
	// Output only. The current status of the operation.
	Status Operation_Status `protobuf:"varint,4,opt,name=status,proto3,enum=google.container.v1.Operation_Status" json:"status,omitempty"`
	// Output only. Detailed operation progress, if available.
	Detail string `protobuf:"bytes,8,opt,name=detail,proto3" json:"detail,omitempty"`
	// Output only. If an error has occurred, a textual description of the error.
	// Deprecated. Use the field error instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Server-defined URI for the operation. Example:
	// `https://container.googleapis.com/v1alpha1/projects/123/locations/us-central1/operations/operation-123`.
	SelfLink string `protobuf:"bytes,6,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Output only. Server-defined URI for the target of the operation. The format
	// of this is a URI to the resource being modified (such as a cluster, node
	// pool, or node). For node pool repairs, there may be multiple nodes being
	// repaired, but only one will be the target.
	//
	// Examples:
	//
	// -
	// ##
	// `https://container.googleapis.com/v1/projects/123/locations/us-central1/clusters/my-cluster`
	//
	// ##
	// `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np`
	//
	// `https://container.googleapis.com/v1/projects/123/zones/us-central1-c/clusters/my-cluster/nodePools/my-np/node/my-node`
	TargetLink string `protobuf:"bytes,7,opt,name=target_link,json=targetLink,proto3" json:"target_link,omitempty"`
	// Output only. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
	// or
	// [region](https://cloud.google.com/compute/docs/regions-zones/regions-zones#available)
	// in which the cluster resides.
	Location string `protobuf:"bytes,9,opt,name=location,proto3" json:"location,omitempty"`
	// Output only. The time the operation started, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	StartTime string `protobuf:"bytes,10,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time the operation completed, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	EndTime string `protobuf:"bytes,11,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Progress information for an operation.
	Progress *OperationProgress `protobuf:"bytes,12,opt,name=progress,proto3" json:"progress,omitempty"`
	// Which conditions caused the current cluster state.
	// Deprecated. Use field error instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterConditions []*StatusCondition `protobuf:"bytes,13,rep,name=cluster_conditions,json=clusterConditions,proto3" json:"cluster_conditions,omitempty"`
	// Which conditions caused the current node pool state.
	// Deprecated. Use field error instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	NodepoolConditions []*StatusCondition `protobuf:"bytes,14,rep,name=nodepool_conditions,json=nodepoolConditions,proto3" json:"nodepool_conditions,omitempty"`
	// The error result of the operation in case of failure.
	Error *status.Status `protobuf:"bytes,15,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Operation) Reset() {
	*x = Operation{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Operation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operation) ProtoMessage() {}

func (x *Operation) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operation.ProtoReflect.Descriptor instead.
func (*Operation) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{58}
}

func (x *Operation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Operation) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *Operation) GetOperationType() Operation_Type {
	if x != nil {
		return x.OperationType
	}
	return Operation_TYPE_UNSPECIFIED
}

func (x *Operation) GetStatus() Operation_Status {
	if x != nil {
		return x.Status
	}
	return Operation_STATUS_UNSPECIFIED
}

func (x *Operation) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Operation) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *Operation) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *Operation) GetTargetLink() string {
	if x != nil {
		return x.TargetLink
	}
	return ""
}

func (x *Operation) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Operation) GetStartTime() string {
	if x != nil {
		return x.StartTime
	}
	return ""
}

func (x *Operation) GetEndTime() string {
	if x != nil {
		return x.EndTime
	}
	return ""
}

func (x *Operation) GetProgress() *OperationProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Operation) GetClusterConditions() []*StatusCondition {
	if x != nil {
		return x.ClusterConditions
	}
	return nil
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *Operation) GetNodepoolConditions() []*StatusCondition {
	if x != nil {
		return x.NodepoolConditions
	}
	return nil
}

func (x *Operation) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// Information about operation (or operation stage) progress.
type OperationProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A non-parameterized string describing an operation stage.
	// Unset for single-stage operations.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Status of an operation stage.
	// Unset for single-stage operations.
	Status Operation_Status `protobuf:"varint,2,opt,name=status,proto3,enum=google.container.v1.Operation_Status" json:"status,omitempty"`
	// Progress metric bundle, for example:
	//
	//	metrics: [{name: "nodes done",     int_value: 15},
	//	          {name: "nodes total",    int_value: 32}]
	//
	// or
	//
	//	metrics: [{name: "progress",       double_value: 0.56},
	//	          {name: "progress scale", double_value: 1.0}]
	Metrics []*OperationProgress_Metric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Substages of an operation or a stage.
	Stages []*OperationProgress `protobuf:"bytes,4,rep,name=stages,proto3" json:"stages,omitempty"`
}

func (x *OperationProgress) Reset() {
	*x = OperationProgress{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationProgress) ProtoMessage() {}

func (x *OperationProgress) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationProgress.ProtoReflect.Descriptor instead.
func (*OperationProgress) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{59}
}

func (x *OperationProgress) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OperationProgress) GetStatus() Operation_Status {
	if x != nil {
		return x.Status
	}
	return Operation_STATUS_UNSPECIFIED
}

func (x *OperationProgress) GetMetrics() []*OperationProgress_Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *OperationProgress) GetStages() []*OperationProgress {
	if x != nil {
		return x.Stages
	}
	return nil
}

// CreateClusterRequest creates a cluster.
type CreateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the parent
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. A [cluster
	// resource](https://cloud.google.com/container-engine/reference/rest/v1/projects.locations.clusters)
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// The parent (project and location) where the cluster will be created.
	// Specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateClusterRequest) Reset() {
	*x = CreateClusterRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateClusterRequest) ProtoMessage() {}

func (x *CreateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{60}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CreateClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CreateClusterRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *CreateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *CreateClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// GetClusterRequest gets the settings of a cluster.
type GetClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to retrieve.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The name (project, location, cluster) of the cluster to retrieve.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetClusterRequest) Reset() {
	*x = GetClusterRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterRequest) ProtoMessage() {}

func (x *GetClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterRequest.ProtoReflect.Descriptor instead.
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{61}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetClusterRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetClusterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *GetClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// UpdateClusterRequest updates the settings of a cluster.
type UpdateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. A description of the update.
	Update *ClusterUpdate `protobuf:"bytes,4,opt,name=update,proto3" json:"update,omitempty"`
	// The name (project, location, cluster) of the cluster to update.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UpdateClusterRequest) Reset() {
	*x = UpdateClusterRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateClusterRequest) ProtoMessage() {}

func (x *UpdateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{62}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *UpdateClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *UpdateClusterRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *UpdateClusterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *UpdateClusterRequest) GetUpdate() *ClusterUpdate {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *UpdateClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// UpdateNodePoolRequests update a node pool's image and/or version.
type UpdateNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Deprecated. The name of the node pool to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// Required. The Kubernetes version to change the nodes to (typically an
	// upgrade).
	//
	// Users may specify either explicit versions offered by Kubernetes Engine or
	// version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the Kubernetes master version
	NodeVersion string `protobuf:"bytes,5,opt,name=node_version,json=nodeVersion,proto3" json:"node_version,omitempty"`
	// Required. The desired image type for the node pool. Please see
	// https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
	// available image types.
	ImageType string `protobuf:"bytes,6,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// The name (project, location, cluster, node pool) of the node pool to
	// update. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,8,opt,name=name,proto3" json:"name,omitempty"`
	// The desired list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// node pool's nodes should be located. Changing the locations for a node pool
	// will result in nodes being either created or removed from the node pool,
	// depending on whether locations are being added or removed.
	Locations []string `protobuf:"bytes,13,rep,name=locations,proto3" json:"locations,omitempty"`
	// The desired workload metadata config for the node pool.
	WorkloadMetadataConfig *WorkloadMetadataConfig `protobuf:"bytes,14,opt,name=workload_metadata_config,json=workloadMetadataConfig,proto3" json:"workload_metadata_config,omitempty"`
	// Upgrade settings control disruption and speed of the upgrade.
	UpgradeSettings *NodePool_UpgradeSettings `protobuf:"bytes,15,opt,name=upgrade_settings,json=upgradeSettings,proto3" json:"upgrade_settings,omitempty"`
	// The desired network tags to be applied to all nodes in the node pool.
	// If this field is not present, the tags will not be changed. Otherwise,
	// the existing network tags will be *replaced* with the provided tags.
	Tags *NetworkTags `protobuf:"bytes,16,opt,name=tags,proto3" json:"tags,omitempty"`
	// The desired node taints to be applied to all nodes in the node pool.
	// If this field is not present, the taints will not be changed. Otherwise,
	// the existing node taints will be *replaced* with the provided taints.
	Taints *NodeTaints `protobuf:"bytes,17,opt,name=taints,proto3" json:"taints,omitempty"`
	// The desired node labels to be applied to all nodes in the node pool.
	// If this field is not present, the labels will not be changed. Otherwise,
	// the existing node labels will be *replaced* with the provided labels.
	Labels *NodeLabels `protobuf:"bytes,18,opt,name=labels,proto3" json:"labels,omitempty"`
	// Parameters that can be configured on Linux nodes.
	LinuxNodeConfig *LinuxNodeConfig `protobuf:"bytes,19,opt,name=linux_node_config,json=linuxNodeConfig,proto3" json:"linux_node_config,omitempty"`
	// Node kubelet configs.
	KubeletConfig *NodeKubeletConfig `protobuf:"bytes,20,opt,name=kubelet_config,json=kubeletConfig,proto3" json:"kubelet_config,omitempty"`
	// Node network config.
	NodeNetworkConfig *NodeNetworkConfig `protobuf:"bytes,21,opt,name=node_network_config,json=nodeNetworkConfig,proto3" json:"node_network_config,omitempty"`
	// GCFS config.
	GcfsConfig *GcfsConfig `protobuf:"bytes,22,opt,name=gcfs_config,json=gcfsConfig,proto3" json:"gcfs_config,omitempty"`
	// Confidential nodes config.
	// All the nodes in the node pool will be Confidential VM once enabled.
	ConfidentialNodes *ConfidentialNodes `protobuf:"bytes,23,opt,name=confidential_nodes,json=confidentialNodes,proto3" json:"confidential_nodes,omitempty"`
	// Enable or disable gvnic on the node pool.
	Gvnic *VirtualNIC `protobuf:"bytes,29,opt,name=gvnic,proto3" json:"gvnic,omitempty"`
	// The current etag of the node pool.
	// If an etag is provided and does not match the current etag of the node
	// pool, update will be blocked and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,30,opt,name=etag,proto3" json:"etag,omitempty"`
	// Enable or disable NCCL fast socket for the node pool.
	FastSocket *FastSocket `protobuf:"bytes,31,opt,name=fast_socket,json=fastSocket,proto3" json:"fast_socket,omitempty"`
	// Logging configuration.
	LoggingConfig *NodePoolLoggingConfig `protobuf:"bytes,32,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	// The resource labels for the node pool to use to annotate any related
	// Google Compute Engine resources.
	ResourceLabels *ResourceLabels `protobuf:"bytes,33,opt,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty"`
	// Parameters that can be configured on Windows nodes.
	WindowsNodeConfig *WindowsNodeConfig `protobuf:"bytes,34,opt,name=windows_node_config,json=windowsNodeConfig,proto3" json:"windows_node_config,omitempty"`
	// A list of hardware accelerators to be attached to each node.
	// See https://cloud.google.com/compute/docs/gpus for more information about
	// support for GPUs.
	Accelerators []*AcceleratorConfig `protobuf:"bytes,35,rep,name=accelerators,proto3" json:"accelerators,omitempty"`
	// Optional. The desired [Google Compute Engine machine
	// type](https://cloud.google.com/compute/docs/machine-types) for nodes in the
	// node pool. Initiates an upgrade operation that migrates the nodes in the
	// node pool to the specified machine type.
	MachineType string `protobuf:"bytes,36,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Optional. The desired disk type (e.g. 'pd-standard', 'pd-ssd' or
	// 'pd-balanced') for nodes in the node pool.
	// Initiates an upgrade operation that migrates the nodes in the
	// node pool to the specified disk type.
	DiskType string `protobuf:"bytes,37,opt,name=disk_type,json=diskType,proto3" json:"disk_type,omitempty"`
	// Optional. The desired disk size for nodes in the node pool specified in GB.
	// The smallest allowed disk size is 10GB.
	// Initiates an upgrade operation that migrates the nodes in the
	// node pool to the specified disk size.
	DiskSizeGb int64 `protobuf:"varint,38,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Desired resource manager tag keys and values to be attached to the nodes
	// for managing Compute Engine firewalls using Network Firewall Policies.
	// Existing tags will be replaced with new values.
	ResourceManagerTags *ResourceManagerTags `protobuf:"bytes,39,opt,name=resource_manager_tags,json=resourceManagerTags,proto3" json:"resource_manager_tags,omitempty"`
	// The desired containerd config for nodes in the node pool.
	// Initiates an upgrade operation that recreates the nodes with the new
	// config.
	ContainerdConfig *ContainerdConfig `protobuf:"bytes,40,opt,name=containerd_config,json=containerdConfig,proto3" json:"containerd_config,omitempty"`
	// Specifies the configuration of queued provisioning.
	QueuedProvisioning *NodePool_QueuedProvisioning `protobuf:"bytes,42,opt,name=queued_provisioning,json=queuedProvisioning,proto3" json:"queued_provisioning,omitempty"`
	// List of Storage Pools where boot disks are provisioned.
	// Existing Storage Pools will be replaced with storage-pools.
	StoragePools []string `protobuf:"bytes,43,rep,name=storage_pools,json=storagePools,proto3" json:"storage_pools,omitempty"`
}

func (x *UpdateNodePoolRequest) Reset() {
	*x = UpdateNodePoolRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNodePoolRequest) ProtoMessage() {}

func (x *UpdateNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNodePoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{63}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *UpdateNodePoolRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *UpdateNodePoolRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *UpdateNodePoolRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *UpdateNodePoolRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetNodeVersion() string {
	if x != nil {
		return x.NodeVersion
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetImageType() string {
	if x != nil {
		return x.ImageType
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetLocations() []string {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetWorkloadMetadataConfig() *WorkloadMetadataConfig {
	if x != nil {
		return x.WorkloadMetadataConfig
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetUpgradeSettings() *NodePool_UpgradeSettings {
	if x != nil {
		return x.UpgradeSettings
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetTags() *NetworkTags {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetTaints() *NodeTaints {
	if x != nil {
		return x.Taints
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetLabels() *NodeLabels {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetLinuxNodeConfig() *LinuxNodeConfig {
	if x != nil {
		return x.LinuxNodeConfig
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetKubeletConfig() *NodeKubeletConfig {
	if x != nil {
		return x.KubeletConfig
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetNodeNetworkConfig() *NodeNetworkConfig {
	if x != nil {
		return x.NodeNetworkConfig
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetGcfsConfig() *GcfsConfig {
	if x != nil {
		return x.GcfsConfig
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetConfidentialNodes() *ConfidentialNodes {
	if x != nil {
		return x.ConfidentialNodes
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetGvnic() *VirtualNIC {
	if x != nil {
		return x.Gvnic
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetFastSocket() *FastSocket {
	if x != nil {
		return x.FastSocket
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetLoggingConfig() *NodePoolLoggingConfig {
	if x != nil {
		return x.LoggingConfig
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetResourceLabels() *ResourceLabels {
	if x != nil {
		return x.ResourceLabels
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetWindowsNodeConfig() *WindowsNodeConfig {
	if x != nil {
		return x.WindowsNodeConfig
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetAccelerators() []*AcceleratorConfig {
	if x != nil {
		return x.Accelerators
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetDiskType() string {
	if x != nil {
		return x.DiskType
	}
	return ""
}

func (x *UpdateNodePoolRequest) GetDiskSizeGb() int64 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *UpdateNodePoolRequest) GetResourceManagerTags() *ResourceManagerTags {
	if x != nil {
		return x.ResourceManagerTags
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetContainerdConfig() *ContainerdConfig {
	if x != nil {
		return x.ContainerdConfig
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetQueuedProvisioning() *NodePool_QueuedProvisioning {
	if x != nil {
		return x.QueuedProvisioning
	}
	return nil
}

func (x *UpdateNodePoolRequest) GetStoragePools() []string {
	if x != nil {
		return x.StoragePools
	}
	return nil
}

// SetNodePoolAutoscalingRequest sets the autoscaler settings of a node pool.
type SetNodePoolAutoscalingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Deprecated. The name of the node pool to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// Required. Autoscaling configuration for the node pool.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,5,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// The name (project, location, cluster, node pool) of the node pool to set
	// autoscaler settings. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetNodePoolAutoscalingRequest) Reset() {
	*x = SetNodePoolAutoscalingRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetNodePoolAutoscalingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetNodePoolAutoscalingRequest) ProtoMessage() {}

func (x *SetNodePoolAutoscalingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetNodePoolAutoscalingRequest.ProtoReflect.Descriptor instead.
func (*SetNodePoolAutoscalingRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{64}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolAutoscalingRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolAutoscalingRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolAutoscalingRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolAutoscalingRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *SetNodePoolAutoscalingRequest) GetAutoscaling() *NodePoolAutoscaling {
	if x != nil {
		return x.Autoscaling
	}
	return nil
}

func (x *SetNodePoolAutoscalingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetLoggingServiceRequest sets the logging service of a cluster.
type SetLoggingServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com/kubernetes` - The Cloud Logging
	// service with a Kubernetes-native resource model
	//   - `logging.googleapis.com` - The legacy Cloud Logging service (no longer
	//     available as of GKE 1.15).
	//   - `none` - no logs will be exported from the cluster.
	//
	// If left as an empty string,`logging.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
	LoggingService string `protobuf:"bytes,4,opt,name=logging_service,json=loggingService,proto3" json:"logging_service,omitempty"`
	// The name (project, location, cluster) of the cluster to set logging.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetLoggingServiceRequest) Reset() {
	*x = SetLoggingServiceRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetLoggingServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetLoggingServiceRequest) ProtoMessage() {}

func (x *SetLoggingServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetLoggingServiceRequest.ProtoReflect.Descriptor instead.
func (*SetLoggingServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{65}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLoggingServiceRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLoggingServiceRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLoggingServiceRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetLoggingServiceRequest) GetLoggingService() string {
	if x != nil {
		return x.LoggingService
	}
	return ""
}

func (x *SetLoggingServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetMonitoringServiceRequest sets the monitoring service of a cluster.
type SetMonitoringServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
	// service with a Kubernetes-native resource model
	//   - `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
	//     longer available as of GKE 1.15).
	//   - `none` - No metrics will be exported from the cluster.
	//
	// If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
	// used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
	MonitoringService string `protobuf:"bytes,4,opt,name=monitoring_service,json=monitoringService,proto3" json:"monitoring_service,omitempty"`
	// The name (project, location, cluster) of the cluster to set monitoring.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetMonitoringServiceRequest) Reset() {
	*x = SetMonitoringServiceRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetMonitoringServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMonitoringServiceRequest) ProtoMessage() {}

func (x *SetMonitoringServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMonitoringServiceRequest.ProtoReflect.Descriptor instead.
func (*SetMonitoringServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{66}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetMonitoringServiceRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetMonitoringServiceRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetMonitoringServiceRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetMonitoringServiceRequest) GetMonitoringService() string {
	if x != nil {
		return x.MonitoringService
	}
	return ""
}

func (x *SetMonitoringServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetAddonsConfigRequest sets the addons associated with the cluster.
type SetAddonsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The desired configurations for the various addons available to
	// run in the cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,4,opt,name=addons_config,json=addonsConfig,proto3" json:"addons_config,omitempty"`
	// The name (project, location, cluster) of the cluster to set addons.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetAddonsConfigRequest) Reset() {
	*x = SetAddonsConfigRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetAddonsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetAddonsConfigRequest) ProtoMessage() {}

func (x *SetAddonsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetAddonsConfigRequest.ProtoReflect.Descriptor instead.
func (*SetAddonsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{67}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetAddonsConfigRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetAddonsConfigRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetAddonsConfigRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetAddonsConfigRequest) GetAddonsConfig() *AddonsConfig {
	if x != nil {
		return x.AddonsConfig
	}
	return nil
}

func (x *SetAddonsConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetLocationsRequest sets the locations of the cluster.
type SetLocationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The desired list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster's nodes should be located. Changing the locations a cluster is in
	// will result in nodes being either created or removed from the cluster,
	// depending on whether locations are being added or removed.
	//
	// This list must always include the cluster's primary zone.
	Locations []string `protobuf:"bytes,4,rep,name=locations,proto3" json:"locations,omitempty"`
	// The name (project, location, cluster) of the cluster to set locations.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetLocationsRequest) Reset() {
	*x = SetLocationsRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetLocationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetLocationsRequest) ProtoMessage() {}

func (x *SetLocationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetLocationsRequest.ProtoReflect.Descriptor instead.
func (*SetLocationsRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{68}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLocationsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLocationsRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLocationsRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetLocationsRequest) GetLocations() []string {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *SetLocationsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// UpdateMasterRequest updates the master of the cluster.
type UpdateMasterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The Kubernetes version to change the master to.
	//
	// Users may specify either explicit versions offered by Kubernetes Engine or
	// version aliases, which have the following behavior:
	//
	// - "latest": picks the highest valid Kubernetes version
	// - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
	// - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
	// - "1.X.Y-gke.N": picks an explicit Kubernetes version
	// - "-": picks the default Kubernetes version
	MasterVersion string `protobuf:"bytes,4,opt,name=master_version,json=masterVersion,proto3" json:"master_version,omitempty"`
	// The name (project, location, cluster) of the cluster to update.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UpdateMasterRequest) Reset() {
	*x = UpdateMasterRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateMasterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMasterRequest) ProtoMessage() {}

func (x *UpdateMasterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMasterRequest.ProtoReflect.Descriptor instead.
func (*UpdateMasterRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{69}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *UpdateMasterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *UpdateMasterRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *UpdateMasterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *UpdateMasterRequest) GetMasterVersion() string {
	if x != nil {
		return x.MasterVersion
	}
	return ""
}

func (x *UpdateMasterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetMasterAuthRequest updates the admin password of a cluster.
type SetMasterAuthRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to upgrade.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The exact form of action to be taken on the master auth.
	Action SetMasterAuthRequest_Action `protobuf:"varint,4,opt,name=action,proto3,enum=google.container.v1.SetMasterAuthRequest_Action" json:"action,omitempty"`
	// Required. A description of the update.
	Update *MasterAuth `protobuf:"bytes,5,opt,name=update,proto3" json:"update,omitempty"`
	// The name (project, location, cluster) of the cluster to set auth.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetMasterAuthRequest) Reset() {
	*x = SetMasterAuthRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetMasterAuthRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMasterAuthRequest) ProtoMessage() {}

func (x *SetMasterAuthRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMasterAuthRequest.ProtoReflect.Descriptor instead.
func (*SetMasterAuthRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{70}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetMasterAuthRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetMasterAuthRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetMasterAuthRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetMasterAuthRequest) GetAction() SetMasterAuthRequest_Action {
	if x != nil {
		return x.Action
	}
	return SetMasterAuthRequest_UNKNOWN
}

func (x *SetMasterAuthRequest) GetUpdate() *MasterAuth {
	if x != nil {
		return x.Update
	}
	return nil
}

func (x *SetMasterAuthRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// DeleteClusterRequest deletes a cluster.
type DeleteClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to delete.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The name (project, location, cluster) of the cluster to delete.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteClusterRequest) Reset() {
	*x = DeleteClusterRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteClusterRequest) ProtoMessage() {}

func (x *DeleteClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{71}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *DeleteClusterRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *DeleteClusterRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *DeleteClusterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *DeleteClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListClustersRequest lists clusters.
type ListClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides, or "-" for all zones. This field has been deprecated and
	// replaced by the parent field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The parent (project and location) where the clusters will be listed.
	// Specified in the format `projects/*/locations/*`.
	// Location "-" matches all zones and all regions.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListClustersRequest) Reset() {
	*x = ListClustersRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersRequest) ProtoMessage() {}

func (x *ListClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersRequest.ProtoReflect.Descriptor instead.
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{72}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *ListClustersRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *ListClustersRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ListClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// ListClustersResponse is the result of ListClustersRequest.
type ListClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of clusters in the project in the specified zone, or
	// across all ones.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// If any zones are listed here, the list of clusters returned
	// may be missing those zones.
	MissingZones []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones,proto3" json:"missing_zones,omitempty"`
}

func (x *ListClustersResponse) Reset() {
	*x = ListClustersResponse{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersResponse) ProtoMessage() {}

func (x *ListClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersResponse.ProtoReflect.Descriptor instead.
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{73}
}

func (x *ListClustersResponse) GetClusters() []*Cluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

func (x *ListClustersResponse) GetMissingZones() []string {
	if x != nil {
		return x.MissingZones
	}
	return nil
}

// GetOperationRequest gets a single operation.
type GetOperationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The server-assigned `name` of the operation.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// The name (project, location, operation id) of the operation to get.
	// Specified in the format `projects/*/locations/*/operations/*`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOperationRequest) Reset() {
	*x = GetOperationRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOperationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOperationRequest) ProtoMessage() {}

func (x *GetOperationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOperationRequest.ProtoReflect.Descriptor instead.
func (*GetOperationRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{74}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetOperationRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetOperationRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetOperationRequest) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *GetOperationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListOperationsRequest lists operations.
type ListOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) to return
	// operations for, or `-` for all zones. This field has been deprecated and
	// replaced by the parent field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The parent (project and location) where the operations will be listed.
	// Specified in the format `projects/*/locations/*`.
	// Location "-" matches all zones and all regions.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListOperationsRequest) Reset() {
	*x = ListOperationsRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOperationsRequest) ProtoMessage() {}

func (x *ListOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{75}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *ListOperationsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *ListOperationsRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ListOperationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// CancelOperationRequest cancels a single operation.
type CancelOperationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// operation resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The server-assigned `name` of the operation.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// The name (project, location, operation id) of the operation to cancel.
	// Specified in the format `projects/*/locations/*/operations/*`.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelOperationRequest) Reset() {
	*x = CancelOperationRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelOperationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelOperationRequest) ProtoMessage() {}

func (x *CancelOperationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelOperationRequest.ProtoReflect.Descriptor instead.
func (*CancelOperationRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{76}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CancelOperationRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CancelOperationRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CancelOperationRequest) GetOperationId() string {
	if x != nil {
		return x.OperationId
	}
	return ""
}

func (x *CancelOperationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListOperationsResponse is the result of ListOperationsRequest.
type ListOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of operations in the project in the specified zone.
	Operations []*Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// If any zones are listed here, the list of operations returned
	// may be missing the operations from those zones.
	MissingZones []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones,proto3" json:"missing_zones,omitempty"`
}

func (x *ListOperationsResponse) Reset() {
	*x = ListOperationsResponse{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOperationsResponse) ProtoMessage() {}

func (x *ListOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{77}
}

func (x *ListOperationsResponse) GetOperations() []*Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListOperationsResponse) GetMissingZones() []string {
	if x != nil {
		return x.MissingZones
	}
	return nil
}

// Gets the current Kubernetes Engine service configuration.
type GetServerConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) to return
	// operations for. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The name (project and location) of the server config to get,
	// specified in the format `projects/*/locations/*`.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServerConfigRequest) Reset() {
	*x = GetServerConfigRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetServerConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServerConfigRequest) ProtoMessage() {}

func (x *GetServerConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServerConfigRequest.ProtoReflect.Descriptor instead.
func (*GetServerConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{78}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetServerConfigRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetServerConfigRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *GetServerConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Kubernetes Engine service configuration.
type ServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of Kubernetes the service deploys by default.
	DefaultClusterVersion string `protobuf:"bytes,1,opt,name=default_cluster_version,json=defaultClusterVersion,proto3" json:"default_cluster_version,omitempty"`
	// List of valid node upgrade target versions, in descending order.
	ValidNodeVersions []string `protobuf:"bytes,3,rep,name=valid_node_versions,json=validNodeVersions,proto3" json:"valid_node_versions,omitempty"`
	// Default image type.
	DefaultImageType string `protobuf:"bytes,4,opt,name=default_image_type,json=defaultImageType,proto3" json:"default_image_type,omitempty"`
	// List of valid image types.
	ValidImageTypes []string `protobuf:"bytes,5,rep,name=valid_image_types,json=validImageTypes,proto3" json:"valid_image_types,omitempty"`
	// List of valid master versions, in descending order.
	ValidMasterVersions []string `protobuf:"bytes,6,rep,name=valid_master_versions,json=validMasterVersions,proto3" json:"valid_master_versions,omitempty"`
	// List of release channel configurations.
	Channels []*ServerConfig_ReleaseChannelConfig `protobuf:"bytes,9,rep,name=channels,proto3" json:"channels,omitempty"`
}

func (x *ServerConfig) Reset() {
	*x = ServerConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerConfig) ProtoMessage() {}

func (x *ServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerConfig.ProtoReflect.Descriptor instead.
func (*ServerConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{79}
}

func (x *ServerConfig) GetDefaultClusterVersion() string {
	if x != nil {
		return x.DefaultClusterVersion
	}
	return ""
}

func (x *ServerConfig) GetValidNodeVersions() []string {
	if x != nil {
		return x.ValidNodeVersions
	}
	return nil
}

func (x *ServerConfig) GetDefaultImageType() string {
	if x != nil {
		return x.DefaultImageType
	}
	return ""
}

func (x *ServerConfig) GetValidImageTypes() []string {
	if x != nil {
		return x.ValidImageTypes
	}
	return nil
}

func (x *ServerConfig) GetValidMasterVersions() []string {
	if x != nil {
		return x.ValidMasterVersions
	}
	return nil
}

func (x *ServerConfig) GetChannels() []*ServerConfig_ReleaseChannelConfig {
	if x != nil {
		return x.Channels
	}
	return nil
}

// CreateNodePoolRequest creates a node pool for a cluster.
type CreateNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the parent
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The node pool to create.
	NodePool *NodePool `protobuf:"bytes,4,opt,name=node_pool,json=nodePool,proto3" json:"node_pool,omitempty"`
	// The parent (project, location, cluster name) where the node pool will be
	// created. Specified in the format
	// `projects/*/locations/*/clusters/*`.
	Parent string `protobuf:"bytes,6,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CreateNodePoolRequest) Reset() {
	*x = CreateNodePoolRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNodePoolRequest) ProtoMessage() {}

func (x *CreateNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNodePoolRequest.ProtoReflect.Descriptor instead.
func (*CreateNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{80}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CreateNodePoolRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CreateNodePoolRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CreateNodePoolRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *CreateNodePoolRequest) GetNodePool() *NodePool {
	if x != nil {
		return x.NodePool
	}
	return nil
}

func (x *CreateNodePoolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// DeleteNodePoolRequest deletes a node pool for a cluster.
type DeleteNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Deprecated. The name of the node pool to delete.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to
	// delete. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteNodePoolRequest) Reset() {
	*x = DeleteNodePoolRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNodePoolRequest) ProtoMessage() {}

func (x *DeleteNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNodePoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{81}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *DeleteNodePoolRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *DeleteNodePoolRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *DeleteNodePoolRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *DeleteNodePoolRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *DeleteNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListNodePoolsRequest lists the node pool(s) for a cluster.
type ListNodePoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the parent
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the parent field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The parent (project, location, cluster name) where the node pools will be
	// listed. Specified in the format `projects/*/locations/*/clusters/*`.
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListNodePoolsRequest) Reset() {
	*x = ListNodePoolsRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListNodePoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNodePoolsRequest) ProtoMessage() {}

func (x *ListNodePoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNodePoolsRequest.ProtoReflect.Descriptor instead.
func (*ListNodePoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{82}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *ListNodePoolsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *ListNodePoolsRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *ListNodePoolsRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *ListNodePoolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// GetNodePoolRequest retrieves a node pool for a cluster.
type GetNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Deprecated. The name of the node pool.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to
	// get. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNodePoolRequest) Reset() {
	*x = GetNodePoolRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNodePoolRequest) ProtoMessage() {}

func (x *GetNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNodePoolRequest.ProtoReflect.Descriptor instead.
func (*GetNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{83}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetNodePoolRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetNodePoolRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetNodePoolRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *GetNodePoolRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *GetNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Settings for blue-green upgrade.
type BlueGreenSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rollout policy controls the general rollout progress of blue-green.
	//
	// Types that are assignable to RolloutPolicy:
	//
	//	*BlueGreenSettings_StandardRolloutPolicy_
	RolloutPolicy isBlueGreenSettings_RolloutPolicy `protobuf_oneof:"rollout_policy"`
	// Time needed after draining entire blue pool. After this period, blue pool
	// will be cleaned up.
	NodePoolSoakDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=node_pool_soak_duration,json=nodePoolSoakDuration,proto3,oneof" json:"node_pool_soak_duration,omitempty"`
}

func (x *BlueGreenSettings) Reset() {
	*x = BlueGreenSettings{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BlueGreenSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlueGreenSettings) ProtoMessage() {}

func (x *BlueGreenSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlueGreenSettings.ProtoReflect.Descriptor instead.
func (*BlueGreenSettings) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{84}
}

func (m *BlueGreenSettings) GetRolloutPolicy() isBlueGreenSettings_RolloutPolicy {
	if m != nil {
		return m.RolloutPolicy
	}
	return nil
}

func (x *BlueGreenSettings) GetStandardRolloutPolicy() *BlueGreenSettings_StandardRolloutPolicy {
	if x, ok := x.GetRolloutPolicy().(*BlueGreenSettings_StandardRolloutPolicy_); ok {
		return x.StandardRolloutPolicy
	}
	return nil
}

func (x *BlueGreenSettings) GetNodePoolSoakDuration() *durationpb.Duration {
	if x != nil {
		return x.NodePoolSoakDuration
	}
	return nil
}

type isBlueGreenSettings_RolloutPolicy interface {
	isBlueGreenSettings_RolloutPolicy()
}

type BlueGreenSettings_StandardRolloutPolicy_ struct {
	// Standard policy for the blue-green upgrade.
	StandardRolloutPolicy *BlueGreenSettings_StandardRolloutPolicy `protobuf:"bytes,1,opt,name=standard_rollout_policy,json=standardRolloutPolicy,proto3,oneof"`
}

func (*BlueGreenSettings_StandardRolloutPolicy_) isBlueGreenSettings_RolloutPolicy() {}

// NodePool contains the name and configuration for a cluster's node pool.
// Node pools are a set of nodes (i.e. VM's), with a common configuration and
// specification, under the control of the cluster master. They may have a set
// of Kubernetes labels applied to them, which may be used to reference them
// during pod scheduling. They may also be resized up or down, to accommodate
// the workload.
type NodePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the node pool.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The node configuration of the pool.
	Config *NodeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// The initial node count for the pool. You must ensure that your
	// Compute Engine [resource quota](https://cloud.google.com/compute/quotas)
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount,proto3" json:"initial_node_count,omitempty"`
	// The list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// NodePool's nodes should be located.
	//
	// If this value is unspecified during node pool creation, the
	// [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations)
	// value will be used, instead.
	//
	// Warning: changing node pool locations will result in nodes being added
	// and/or removed.
	Locations []string `protobuf:"bytes,13,rep,name=locations,proto3" json:"locations,omitempty"`
	// Networking configuration for this NodePool. If specified, it overrides the
	// cluster-level defaults.
	NetworkConfig *NodeNetworkConfig `protobuf:"bytes,14,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// Output only. Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// The version of Kubernetes running on this NodePool's nodes. If unspecified,
	// it defaults as described
	// [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
	Version string `protobuf:"bytes,101,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The resource URLs of the [managed instance
	// groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances)
	// associated with this node pool.
	// During the node pool blue-green upgrade operation, the URLs contain both
	// blue and green resources.
	InstanceGroupUrls []string `protobuf:"bytes,102,rep,name=instance_group_urls,json=instanceGroupUrls,proto3" json:"instance_group_urls,omitempty"`
	// Output only. The status of the nodes in this pool instance.
	Status NodePool_Status `protobuf:"varint,103,opt,name=status,proto3,enum=google.container.v1.NodePool_Status" json:"status,omitempty"`
	// Output only. Deprecated. Use conditions instead.
	// Additional information about the current status of this
	// node pool instance, if available.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	StatusMessage string `protobuf:"bytes,104,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Autoscaler configuration for this NodePool. Autoscaler is enabled
	// only if a valid configuration is present.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,4,opt,name=autoscaling,proto3" json:"autoscaling,omitempty"`
	// NodeManagement configuration for this NodePool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management,proto3" json:"management,omitempty"`
	// The constraint on the maximum number of pods that can be run
	// simultaneously on a node in the node pool.
	MaxPodsConstraint *MaxPodsConstraint `protobuf:"bytes,6,opt,name=max_pods_constraint,json=maxPodsConstraint,proto3" json:"max_pods_constraint,omitempty"`
	// Which conditions caused the current node pool state.
	Conditions []*StatusCondition `protobuf:"bytes,105,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// Output only. The pod CIDR block size per node in this node pool.
	PodIpv4CidrSize int32 `protobuf:"varint,7,opt,name=pod_ipv4_cidr_size,json=podIpv4CidrSize,proto3" json:"pod_ipv4_cidr_size,omitempty"`
	// Upgrade settings control disruption and speed of the upgrade.
	UpgradeSettings *NodePool_UpgradeSettings `protobuf:"bytes,107,opt,name=upgrade_settings,json=upgradeSettings,proto3" json:"upgrade_settings,omitempty"`
	// Specifies the node placement policy.
	PlacementPolicy *NodePool_PlacementPolicy `protobuf:"bytes,108,opt,name=placement_policy,json=placementPolicy,proto3" json:"placement_policy,omitempty"`
	// Output only. Update info contains relevant information during a node
	// pool update.
	UpdateInfo *NodePool_UpdateInfo `protobuf:"bytes,109,opt,name=update_info,json=updateInfo,proto3" json:"update_info,omitempty"`
	// This checksum is computed by the server based on the value of node pool
	// fields, and may be sent on update requests to ensure the client has an
	// up-to-date value before proceeding.
	Etag string `protobuf:"bytes,110,opt,name=etag,proto3" json:"etag,omitempty"`
	// Specifies the configuration of queued provisioning.
	QueuedProvisioning *NodePool_QueuedProvisioning `protobuf:"bytes,112,opt,name=queued_provisioning,json=queuedProvisioning,proto3" json:"queued_provisioning,omitempty"`
	// Enable best effort provisioning for nodes
	BestEffortProvisioning *BestEffortProvisioning `protobuf:"bytes,113,opt,name=best_effort_provisioning,json=bestEffortProvisioning,proto3" json:"best_effort_provisioning,omitempty"`
}

func (x *NodePool) Reset() {
	*x = NodePool{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool) ProtoMessage() {}

func (x *NodePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool.ProtoReflect.Descriptor instead.
func (*NodePool) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{85}
}

func (x *NodePool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NodePool) GetConfig() *NodeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *NodePool) GetInitialNodeCount() int32 {
	if x != nil {
		return x.InitialNodeCount
	}
	return 0
}

func (x *NodePool) GetLocations() []string {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *NodePool) GetNetworkConfig() *NodeNetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

func (x *NodePool) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *NodePool) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *NodePool) GetInstanceGroupUrls() []string {
	if x != nil {
		return x.InstanceGroupUrls
	}
	return nil
}

func (x *NodePool) GetStatus() NodePool_Status {
	if x != nil {
		return x.Status
	}
	return NodePool_STATUS_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *NodePool) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *NodePool) GetAutoscaling() *NodePoolAutoscaling {
	if x != nil {
		return x.Autoscaling
	}
	return nil
}

func (x *NodePool) GetManagement() *NodeManagement {
	if x != nil {
		return x.Management
	}
	return nil
}

func (x *NodePool) GetMaxPodsConstraint() *MaxPodsConstraint {
	if x != nil {
		return x.MaxPodsConstraint
	}
	return nil
}

func (x *NodePool) GetConditions() []*StatusCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *NodePool) GetPodIpv4CidrSize() int32 {
	if x != nil {
		return x.PodIpv4CidrSize
	}
	return 0
}

func (x *NodePool) GetUpgradeSettings() *NodePool_UpgradeSettings {
	if x != nil {
		return x.UpgradeSettings
	}
	return nil
}

func (x *NodePool) GetPlacementPolicy() *NodePool_PlacementPolicy {
	if x != nil {
		return x.PlacementPolicy
	}
	return nil
}

func (x *NodePool) GetUpdateInfo() *NodePool_UpdateInfo {
	if x != nil {
		return x.UpdateInfo
	}
	return nil
}

func (x *NodePool) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *NodePool) GetQueuedProvisioning() *NodePool_QueuedProvisioning {
	if x != nil {
		return x.QueuedProvisioning
	}
	return nil
}

func (x *NodePool) GetBestEffortProvisioning() *BestEffortProvisioning {
	if x != nil {
		return x.BestEffortProvisioning
	}
	return nil
}

// NodeManagement defines the set of node management services turned on for the
// node pool.
type NodeManagement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A flag that specifies whether node auto-upgrade is enabled for the node
	// pool. If enabled, node auto-upgrade helps keep the nodes in your node pool
	// up to date with the latest release version of Kubernetes.
	AutoUpgrade bool `protobuf:"varint,1,opt,name=auto_upgrade,json=autoUpgrade,proto3" json:"auto_upgrade,omitempty"`
	// A flag that specifies whether the node auto-repair is enabled for the node
	// pool. If enabled, the nodes in this node pool will be monitored and, if
	// they fail health checks too many times, an automatic repair action will be
	// triggered.
	AutoRepair bool `protobuf:"varint,2,opt,name=auto_repair,json=autoRepair,proto3" json:"auto_repair,omitempty"`
	// Specifies the Auto Upgrade knobs for the node pool.
	UpgradeOptions *AutoUpgradeOptions `protobuf:"bytes,10,opt,name=upgrade_options,json=upgradeOptions,proto3" json:"upgrade_options,omitempty"`
}

func (x *NodeManagement) Reset() {
	*x = NodeManagement{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeManagement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeManagement) ProtoMessage() {}

func (x *NodeManagement) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeManagement.ProtoReflect.Descriptor instead.
func (*NodeManagement) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{86}
}

func (x *NodeManagement) GetAutoUpgrade() bool {
	if x != nil {
		return x.AutoUpgrade
	}
	return false
}

func (x *NodeManagement) GetAutoRepair() bool {
	if x != nil {
		return x.AutoRepair
	}
	return false
}

func (x *NodeManagement) GetUpgradeOptions() *AutoUpgradeOptions {
	if x != nil {
		return x.UpgradeOptions
	}
	return nil
}

// Best effort provisioning.
type BestEffortProvisioning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When this is enabled, cluster/node pool creations will ignore non-fatal
	// errors like stockout to best provision as many nodes as possible right now
	// and eventually bring up all target number of nodes
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Minimum number of nodes to be provisioned to be considered as succeeded,
	// and the rest of nodes will be provisioned gradually and eventually when
	// stockout issue has been resolved.
	MinProvisionNodes int32 `protobuf:"varint,2,opt,name=min_provision_nodes,json=minProvisionNodes,proto3" json:"min_provision_nodes,omitempty"`
}

func (x *BestEffortProvisioning) Reset() {
	*x = BestEffortProvisioning{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BestEffortProvisioning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BestEffortProvisioning) ProtoMessage() {}

func (x *BestEffortProvisioning) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BestEffortProvisioning.ProtoReflect.Descriptor instead.
func (*BestEffortProvisioning) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{87}
}

func (x *BestEffortProvisioning) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *BestEffortProvisioning) GetMinProvisionNodes() int32 {
	if x != nil {
		return x.MinProvisionNodes
	}
	return 0
}

// AutoUpgradeOptions defines the set of options for the user to control how
// the Auto Upgrades will proceed.
type AutoUpgradeOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. This field is set when upgrades are about to commence
	// with the approximate start time for the upgrades, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	AutoUpgradeStartTime string `protobuf:"bytes,1,opt,name=auto_upgrade_start_time,json=autoUpgradeStartTime,proto3" json:"auto_upgrade_start_time,omitempty"`
	// Output only. This field is set when upgrades are about to commence
	// with the description of the upgrade.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *AutoUpgradeOptions) Reset() {
	*x = AutoUpgradeOptions{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[88]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoUpgradeOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoUpgradeOptions) ProtoMessage() {}

func (x *AutoUpgradeOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[88]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoUpgradeOptions.ProtoReflect.Descriptor instead.
func (*AutoUpgradeOptions) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{88}
}

func (x *AutoUpgradeOptions) GetAutoUpgradeStartTime() string {
	if x != nil {
		return x.AutoUpgradeStartTime
	}
	return ""
}

func (x *AutoUpgradeOptions) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// MaintenancePolicy defines the maintenance policy to be used for the cluster.
type MaintenancePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the maintenance window in which maintenance may be performed.
	Window *MaintenanceWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	// A hash identifying the version of this policy, so that updates to fields of
	// the policy won't accidentally undo intermediate changes (and so that users
	// of the API unaware of some fields won't accidentally remove other fields).
	// Make a `get()` request to the cluster to get the current
	// resource version and include it with requests to set the policy.
	ResourceVersion string `protobuf:"bytes,3,opt,name=resource_version,json=resourceVersion,proto3" json:"resource_version,omitempty"`
}

func (x *MaintenancePolicy) Reset() {
	*x = MaintenancePolicy{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[89]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaintenancePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenancePolicy) ProtoMessage() {}

func (x *MaintenancePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[89]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenancePolicy.ProtoReflect.Descriptor instead.
func (*MaintenancePolicy) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{89}
}

func (x *MaintenancePolicy) GetWindow() *MaintenanceWindow {
	if x != nil {
		return x.Window
	}
	return nil
}

func (x *MaintenancePolicy) GetResourceVersion() string {
	if x != nil {
		return x.ResourceVersion
	}
	return ""
}

// MaintenanceWindow defines the maintenance window to be used for the cluster.
type MaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Policy:
	//
	//	*MaintenanceWindow_DailyMaintenanceWindow
	//	*MaintenanceWindow_RecurringWindow
	Policy isMaintenanceWindow_Policy `protobuf_oneof:"policy"`
	// Exceptions to maintenance window. Non-emergency maintenance should not
	// occur in these windows.
	MaintenanceExclusions map[string]*TimeWindow `protobuf:"bytes,4,rep,name=maintenance_exclusions,json=maintenanceExclusions,proto3" json:"maintenance_exclusions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *MaintenanceWindow) Reset() {
	*x = MaintenanceWindow{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[90]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceWindow) ProtoMessage() {}

func (x *MaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[90]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceWindow.ProtoReflect.Descriptor instead.
func (*MaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{90}
}

func (m *MaintenanceWindow) GetPolicy() isMaintenanceWindow_Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (x *MaintenanceWindow) GetDailyMaintenanceWindow() *DailyMaintenanceWindow {
	if x, ok := x.GetPolicy().(*MaintenanceWindow_DailyMaintenanceWindow); ok {
		return x.DailyMaintenanceWindow
	}
	return nil
}

func (x *MaintenanceWindow) GetRecurringWindow() *RecurringTimeWindow {
	if x, ok := x.GetPolicy().(*MaintenanceWindow_RecurringWindow); ok {
		return x.RecurringWindow
	}
	return nil
}

func (x *MaintenanceWindow) GetMaintenanceExclusions() map[string]*TimeWindow {
	if x != nil {
		return x.MaintenanceExclusions
	}
	return nil
}

type isMaintenanceWindow_Policy interface {
	isMaintenanceWindow_Policy()
}

type MaintenanceWindow_DailyMaintenanceWindow struct {
	// DailyMaintenanceWindow specifies a daily maintenance operation window.
	DailyMaintenanceWindow *DailyMaintenanceWindow `protobuf:"bytes,2,opt,name=daily_maintenance_window,json=dailyMaintenanceWindow,proto3,oneof"`
}

type MaintenanceWindow_RecurringWindow struct {
	// RecurringWindow specifies some number of recurring time periods for
	// maintenance to occur. The time windows may be overlapping. If no
	// maintenance windows are set, maintenance can occur at any time.
	RecurringWindow *RecurringTimeWindow `protobuf:"bytes,3,opt,name=recurring_window,json=recurringWindow,proto3,oneof"`
}

func (*MaintenanceWindow_DailyMaintenanceWindow) isMaintenanceWindow_Policy() {}

func (*MaintenanceWindow_RecurringWindow) isMaintenanceWindow_Policy() {}

// Represents an arbitrary window of time.
type TimeWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Options:
	//
	//	*TimeWindow_MaintenanceExclusionOptions
	Options isTimeWindow_Options `protobuf_oneof:"options"`
	// The time that the window first starts.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time that the window ends. The end time should take place after the
	// start time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TimeWindow) Reset() {
	*x = TimeWindow{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[91]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TimeWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeWindow) ProtoMessage() {}

func (x *TimeWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[91]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeWindow.ProtoReflect.Descriptor instead.
func (*TimeWindow) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{91}
}

func (m *TimeWindow) GetOptions() isTimeWindow_Options {
	if m != nil {
		return m.Options
	}
	return nil
}

func (x *TimeWindow) GetMaintenanceExclusionOptions() *MaintenanceExclusionOptions {
	if x, ok := x.GetOptions().(*TimeWindow_MaintenanceExclusionOptions); ok {
		return x.MaintenanceExclusionOptions
	}
	return nil
}

func (x *TimeWindow) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimeWindow) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isTimeWindow_Options interface {
	isTimeWindow_Options()
}

type TimeWindow_MaintenanceExclusionOptions struct {
	// MaintenanceExclusionOptions provides maintenance exclusion related
	// options.
	MaintenanceExclusionOptions *MaintenanceExclusionOptions `protobuf:"bytes,3,opt,name=maintenance_exclusion_options,json=maintenanceExclusionOptions,proto3,oneof"`
}

func (*TimeWindow_MaintenanceExclusionOptions) isTimeWindow_Options() {}

// Represents the Maintenance exclusion option.
type MaintenanceExclusionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Scope specifies the upgrade scope which upgrades are blocked by the
	// exclusion.
	Scope MaintenanceExclusionOptions_Scope `protobuf:"varint,1,opt,name=scope,proto3,enum=google.container.v1.MaintenanceExclusionOptions_Scope" json:"scope,omitempty"`
}

func (x *MaintenanceExclusionOptions) Reset() {
	*x = MaintenanceExclusionOptions{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[92]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaintenanceExclusionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceExclusionOptions) ProtoMessage() {}

func (x *MaintenanceExclusionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[92]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceExclusionOptions.ProtoReflect.Descriptor instead.
func (*MaintenanceExclusionOptions) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{92}
}

func (x *MaintenanceExclusionOptions) GetScope() MaintenanceExclusionOptions_Scope {
	if x != nil {
		return x.Scope
	}
	return MaintenanceExclusionOptions_NO_UPGRADES
}

// Represents an arbitrary window of time that recurs.
type RecurringTimeWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The window of the first recurrence.
	Window *TimeWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	// An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
	// this window reccurs. They go on for the span of time between the start and
	// end time.
	//
	// For example, to have something repeat every weekday, you'd use:
	// `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR`
	//
	// To repeat some window daily (equivalent to the DailyMaintenanceWindow):
	// `FREQ=DAILY`
	//
	// For the first weekend of every month:
	// `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU`
	//
	// This specifies how frequently the window starts. Eg, if you wanted to have
	// a 9-5 UTC-4 window every weekday, you'd use something like:
	// ```
	// start time = 2019-01-01T09:00:00-0400
	// end time = 2019-01-01T17:00:00-0400
	// recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR
	// ```
	//
	// Windows can span multiple days. Eg, to make the window encompass every
	// weekend from midnight Saturday till the last minute of Sunday UTC:
	// ```
	// start time = 2019-01-05T00:00:00Z
	// end time = 2019-01-07T23:59:00Z
	// recurrence = FREQ=WEEKLY;BYDAY=SA
	// ```
	//
	// Note the start and end time's specific dates are largely arbitrary except
	// to specify duration of the window and when it first starts.
	// The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.
	Recurrence string `protobuf:"bytes,2,opt,name=recurrence,proto3" json:"recurrence,omitempty"`
}

func (x *RecurringTimeWindow) Reset() {
	*x = RecurringTimeWindow{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[93]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RecurringTimeWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecurringTimeWindow) ProtoMessage() {}

func (x *RecurringTimeWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[93]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecurringTimeWindow.ProtoReflect.Descriptor instead.
func (*RecurringTimeWindow) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{93}
}

func (x *RecurringTimeWindow) GetWindow() *TimeWindow {
	if x != nil {
		return x.Window
	}
	return nil
}

func (x *RecurringTimeWindow) GetRecurrence() string {
	if x != nil {
		return x.Recurrence
	}
	return ""
}

// Time window specified for daily maintenance operations.
type DailyMaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time within the maintenance window to start the maintenance operations.
	// Time format should be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
	// format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.
	StartTime string `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Duration of the time window, automatically chosen to be
	// smallest possible in the given scenario.
	// Duration will be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt)
	// format "PTnHnMnS".
	Duration string `protobuf:"bytes,3,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *DailyMaintenanceWindow) Reset() {
	*x = DailyMaintenanceWindow{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[94]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DailyMaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DailyMaintenanceWindow) ProtoMessage() {}

func (x *DailyMaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[94]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DailyMaintenanceWindow.ProtoReflect.Descriptor instead.
func (*DailyMaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{94}
}

func (x *DailyMaintenanceWindow) GetStartTime() string {
	if x != nil {
		return x.StartTime
	}
	return ""
}

func (x *DailyMaintenanceWindow) GetDuration() string {
	if x != nil {
		return x.Duration
	}
	return ""
}

// SetNodePoolManagementRequest sets the node management properties of a node
// pool.
type SetNodePoolManagementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Deprecated. The name of the node pool to update.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// Required. NodeManagement configuration for the node pool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management,proto3" json:"management,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to set
	// management properties. Specified in the format
	// `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetNodePoolManagementRequest) Reset() {
	*x = SetNodePoolManagementRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[95]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetNodePoolManagementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetNodePoolManagementRequest) ProtoMessage() {}

func (x *SetNodePoolManagementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[95]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetNodePoolManagementRequest.ProtoReflect.Descriptor instead.
func (*SetNodePoolManagementRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{95}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolManagementRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolManagementRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolManagementRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolManagementRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *SetNodePoolManagementRequest) GetManagement() *NodeManagement {
	if x != nil {
		return x.Management
	}
	return nil
}

func (x *SetNodePoolManagementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetNodePoolSizeRequest sets the size of a node pool.
type SetNodePoolSizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Deprecated. The name of the node pool to update.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// Required. The desired node count for the pool.
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// The name (project, location, cluster, node pool id) of the node pool to set
	// size.
	// Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetNodePoolSizeRequest) Reset() {
	*x = SetNodePoolSizeRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[96]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetNodePoolSizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetNodePoolSizeRequest) ProtoMessage() {}

func (x *SetNodePoolSizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[96]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetNodePoolSizeRequest.ProtoReflect.Descriptor instead.
func (*SetNodePoolSizeRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{96}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolSizeRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolSizeRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolSizeRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNodePoolSizeRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *SetNodePoolSizeRequest) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *SetNodePoolSizeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// CompleteNodePoolUpgradeRequest sets the name of target node pool to complete
// upgrade.
type CompleteNodePoolUpgradeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name (project, location, cluster, node pool id) of the node pool to
	// complete upgrade.
	// Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CompleteNodePoolUpgradeRequest) Reset() {
	*x = CompleteNodePoolUpgradeRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[97]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompleteNodePoolUpgradeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteNodePoolUpgradeRequest) ProtoMessage() {}

func (x *CompleteNodePoolUpgradeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[97]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteNodePoolUpgradeRequest.ProtoReflect.Descriptor instead.
func (*CompleteNodePoolUpgradeRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{97}
}

func (x *CompleteNodePoolUpgradeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or Failed
// NodePool upgrade. This will be an no-op if the last upgrade successfully
// completed.
type RollbackNodePoolUpgradeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to rollback.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Deprecated. The name of the node pool to rollback.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// The name (project, location, cluster, node pool id) of the node poll to
	// rollback upgrade.
	// Specified in the format `projects/*/locations/*/clusters/*/nodePools/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Option for rollback to ignore the PodDisruptionBudget.
	// Default value is false.
	RespectPdb bool `protobuf:"varint,7,opt,name=respect_pdb,json=respectPdb,proto3" json:"respect_pdb,omitempty"`
}

func (x *RollbackNodePoolUpgradeRequest) Reset() {
	*x = RollbackNodePoolUpgradeRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[98]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RollbackNodePoolUpgradeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackNodePoolUpgradeRequest) ProtoMessage() {}

func (x *RollbackNodePoolUpgradeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[98]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackNodePoolUpgradeRequest.ProtoReflect.Descriptor instead.
func (*RollbackNodePoolUpgradeRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{98}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *RollbackNodePoolUpgradeRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *RollbackNodePoolUpgradeRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *RollbackNodePoolUpgradeRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *RollbackNodePoolUpgradeRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *RollbackNodePoolUpgradeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RollbackNodePoolUpgradeRequest) GetRespectPdb() bool {
	if x != nil {
		return x.RespectPdb
	}
	return false
}

// ListNodePoolsResponse is the result of ListNodePoolsRequest.
type ListNodePoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of node pools for a cluster.
	NodePools []*NodePool `protobuf:"bytes,1,rep,name=node_pools,json=nodePools,proto3" json:"node_pools,omitempty"`
}

func (x *ListNodePoolsResponse) Reset() {
	*x = ListNodePoolsResponse{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[99]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListNodePoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNodePoolsResponse) ProtoMessage() {}

func (x *ListNodePoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[99]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNodePoolsResponse.ProtoReflect.Descriptor instead.
func (*ListNodePoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{99}
}

func (x *ListNodePoolsResponse) GetNodePools() []*NodePool {
	if x != nil {
		return x.NodePools
	}
	return nil
}

// ClusterAutoscaling contains global, per-cluster information
// required by Cluster Autoscaler to automatically adjust
// the size of the cluster and create/delete
// node pools based on the current needs.
type ClusterAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables automatic node pool creation and deletion.
	EnableNodeAutoprovisioning bool `protobuf:"varint,1,opt,name=enable_node_autoprovisioning,json=enableNodeAutoprovisioning,proto3" json:"enable_node_autoprovisioning,omitempty"`
	// Contains global constraints regarding minimum and maximum
	// amount of resources in the cluster.
	ResourceLimits []*ResourceLimit `protobuf:"bytes,2,rep,name=resource_limits,json=resourceLimits,proto3" json:"resource_limits,omitempty"`
	// Defines autoscaling behaviour.
	AutoscalingProfile ClusterAutoscaling_AutoscalingProfile `protobuf:"varint,3,opt,name=autoscaling_profile,json=autoscalingProfile,proto3,enum=google.container.v1.ClusterAutoscaling_AutoscalingProfile" json:"autoscaling_profile,omitempty"`
	// AutoprovisioningNodePoolDefaults contains defaults for a node pool
	// created by NAP.
	AutoprovisioningNodePoolDefaults *AutoprovisioningNodePoolDefaults `protobuf:"bytes,4,opt,name=autoprovisioning_node_pool_defaults,json=autoprovisioningNodePoolDefaults,proto3" json:"autoprovisioning_node_pool_defaults,omitempty"`
	// The list of Google Compute Engine
	// [zones](https://cloud.google.com/compute/docs/zones#available) in which the
	// NodePool's nodes can be created by NAP.
	AutoprovisioningLocations []string `protobuf:"bytes,5,rep,name=autoprovisioning_locations,json=autoprovisioningLocations,proto3" json:"autoprovisioning_locations,omitempty"`
}

func (x *ClusterAutoscaling) Reset() {
	*x = ClusterAutoscaling{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[100]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterAutoscaling) ProtoMessage() {}

func (x *ClusterAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[100]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterAutoscaling.ProtoReflect.Descriptor instead.
func (*ClusterAutoscaling) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{100}
}

func (x *ClusterAutoscaling) GetEnableNodeAutoprovisioning() bool {
	if x != nil {
		return x.EnableNodeAutoprovisioning
	}
	return false
}

func (x *ClusterAutoscaling) GetResourceLimits() []*ResourceLimit {
	if x != nil {
		return x.ResourceLimits
	}
	return nil
}

func (x *ClusterAutoscaling) GetAutoscalingProfile() ClusterAutoscaling_AutoscalingProfile {
	if x != nil {
		return x.AutoscalingProfile
	}
	return ClusterAutoscaling_PROFILE_UNSPECIFIED
}

func (x *ClusterAutoscaling) GetAutoprovisioningNodePoolDefaults() *AutoprovisioningNodePoolDefaults {
	if x != nil {
		return x.AutoprovisioningNodePoolDefaults
	}
	return nil
}

func (x *ClusterAutoscaling) GetAutoprovisioningLocations() []string {
	if x != nil {
		return x.AutoprovisioningLocations
	}
	return nil
}

// AutoprovisioningNodePoolDefaults contains defaults for a node pool created
// by NAP.
type AutoprovisioningNodePoolDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Scopes that are used by NAP when creating node pools.
	OauthScopes []string `protobuf:"bytes,1,rep,name=oauth_scopes,json=oauthScopes,proto3" json:"oauth_scopes,omitempty"`
	// The Google Cloud Platform Service Account to be used by the node VMs.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Specifies the upgrade settings for NAP created node pools
	UpgradeSettings *NodePool_UpgradeSettings `protobuf:"bytes,3,opt,name=upgrade_settings,json=upgradeSettings,proto3" json:"upgrade_settings,omitempty"`
	// Specifies the node management options for NAP created node-pools.
	Management *NodeManagement `protobuf:"bytes,4,opt,name=management,proto3" json:"management,omitempty"`
	// Deprecated. Minimum CPU platform to be used for NAP created node pools.
	// The instance may be scheduled on the specified or newer CPU platform.
	// Applicable values are the friendly names of CPU platforms, such as
	// minCpuPlatform: Intel Haswell or
	// minCpuPlatform: Intel Sandy Bridge. For more
	// information, read [how to specify min CPU
	// platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
	// This field is deprecated, min_cpu_platform should be specified using
	// `cloud.google.com/requested-min-cpu-platform` label selector on the pod.
	// To unset the min cpu platform field pass "automatic"
	// as field value.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	MinCpuPlatform string `protobuf:"bytes,5,opt,name=min_cpu_platform,json=minCpuPlatform,proto3" json:"min_cpu_platform,omitempty"`
	// Size of the disk attached to each node, specified in GB.
	// The smallest allowed disk size is 10GB.
	//
	// If unspecified, the default disk size is 100GB.
	DiskSizeGb int32 `protobuf:"varint,6,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or
	// 'pd-balanced')
	//
	// If unspecified, the default disk type is 'pd-standard'
	DiskType string `protobuf:"bytes,7,opt,name=disk_type,json=diskType,proto3" json:"disk_type,omitempty"`
	// Shielded Instance options.
	ShieldedInstanceConfig *ShieldedInstanceConfig `protobuf:"bytes,8,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3" json:"shielded_instance_config,omitempty"`
	// The Customer Managed Encryption Key used to encrypt the boot disk attached
	// to each node in the node pool. This should be of the form
	// projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME].
	// For more information about protecting resources with Cloud KMS Keys please
	// see:
	// https://cloud.google.com/compute/docs/disks/customer-managed-encryption
	BootDiskKmsKey string `protobuf:"bytes,9,opt,name=boot_disk_kms_key,json=bootDiskKmsKey,proto3" json:"boot_disk_kms_key,omitempty"`
	// The image type to use for NAP created node. Please see
	// https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for
	// available image types.
	ImageType string `protobuf:"bytes,10,opt,name=image_type,json=imageType,proto3" json:"image_type,omitempty"`
	// Enable or disable Kubelet read only port.
	InsecureKubeletReadonlyPortEnabled *bool `protobuf:"varint,13,opt,name=insecure_kubelet_readonly_port_enabled,json=insecureKubeletReadonlyPortEnabled,proto3,oneof" json:"insecure_kubelet_readonly_port_enabled,omitempty"`
}

func (x *AutoprovisioningNodePoolDefaults) Reset() {
	*x = AutoprovisioningNodePoolDefaults{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[101]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoprovisioningNodePoolDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoprovisioningNodePoolDefaults) ProtoMessage() {}

func (x *AutoprovisioningNodePoolDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[101]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoprovisioningNodePoolDefaults.ProtoReflect.Descriptor instead.
func (*AutoprovisioningNodePoolDefaults) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{101}
}

func (x *AutoprovisioningNodePoolDefaults) GetOauthScopes() []string {
	if x != nil {
		return x.OauthScopes
	}
	return nil
}

func (x *AutoprovisioningNodePoolDefaults) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *AutoprovisioningNodePoolDefaults) GetUpgradeSettings() *NodePool_UpgradeSettings {
	if x != nil {
		return x.UpgradeSettings
	}
	return nil
}

func (x *AutoprovisioningNodePoolDefaults) GetManagement() *NodeManagement {
	if x != nil {
		return x.Management
	}
	return nil
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *AutoprovisioningNodePoolDefaults) GetMinCpuPlatform() string {
	if x != nil {
		return x.MinCpuPlatform
	}
	return ""
}

func (x *AutoprovisioningNodePoolDefaults) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *AutoprovisioningNodePoolDefaults) GetDiskType() string {
	if x != nil {
		return x.DiskType
	}
	return ""
}

func (x *AutoprovisioningNodePoolDefaults) GetShieldedInstanceConfig() *ShieldedInstanceConfig {
	if x != nil {
		return x.ShieldedInstanceConfig
	}
	return nil
}

func (x *AutoprovisioningNodePoolDefaults) GetBootDiskKmsKey() string {
	if x != nil {
		return x.BootDiskKmsKey
	}
	return ""
}

func (x *AutoprovisioningNodePoolDefaults) GetImageType() string {
	if x != nil {
		return x.ImageType
	}
	return ""
}

func (x *AutoprovisioningNodePoolDefaults) GetInsecureKubeletReadonlyPortEnabled() bool {
	if x != nil && x.InsecureKubeletReadonlyPortEnabled != nil {
		return *x.InsecureKubeletReadonlyPortEnabled
	}
	return false
}

// Contains information about amount of some resource in the cluster.
// For memory, value should be in GB.
type ResourceLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name "cpu", "memory" or gpu-specific string.
	ResourceType string `protobuf:"bytes,1,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Minimum amount of the resource in the cluster.
	Minimum int64 `protobuf:"varint,2,opt,name=minimum,proto3" json:"minimum,omitempty"`
	// Maximum amount of the resource in the cluster.
	Maximum int64 `protobuf:"varint,3,opt,name=maximum,proto3" json:"maximum,omitempty"`
}

func (x *ResourceLimit) Reset() {
	*x = ResourceLimit{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[102]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceLimit) ProtoMessage() {}

func (x *ResourceLimit) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[102]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceLimit.ProtoReflect.Descriptor instead.
func (*ResourceLimit) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{102}
}

func (x *ResourceLimit) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *ResourceLimit) GetMinimum() int64 {
	if x != nil {
		return x.Minimum
	}
	return 0
}

func (x *ResourceLimit) GetMaximum() int64 {
	if x != nil {
		return x.Maximum
	}
	return 0
}

// NodePoolAutoscaling contains information required by cluster autoscaler to
// adjust the size of the node pool to the current cluster usage.
type NodePoolAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Is autoscaling enabled for this node pool.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Minimum number of nodes for one location in the node pool. Must be greater
	// than or equal to 0 and less than or equal to max_node_count.
	MinNodeCount int32 `protobuf:"varint,2,opt,name=min_node_count,json=minNodeCount,proto3" json:"min_node_count,omitempty"`
	// Maximum number of nodes for one location in the node pool. Must be >=
	// min_node_count. There has to be enough quota to scale up the cluster.
	MaxNodeCount int32 `protobuf:"varint,3,opt,name=max_node_count,json=maxNodeCount,proto3" json:"max_node_count,omitempty"`
	// Can this node pool be deleted automatically.
	Autoprovisioned bool `protobuf:"varint,4,opt,name=autoprovisioned,proto3" json:"autoprovisioned,omitempty"`
	// Location policy used when scaling up a nodepool.
	LocationPolicy NodePoolAutoscaling_LocationPolicy `protobuf:"varint,5,opt,name=location_policy,json=locationPolicy,proto3,enum=google.container.v1.NodePoolAutoscaling_LocationPolicy" json:"location_policy,omitempty"`
	// Minimum number of nodes in the node pool. Must be greater than or equal
	// to 0 and less than or equal to total_max_node_count.
	// The total_*_node_count fields are mutually exclusive with the *_node_count
	// fields.
	TotalMinNodeCount int32 `protobuf:"varint,6,opt,name=total_min_node_count,json=totalMinNodeCount,proto3" json:"total_min_node_count,omitempty"`
	// Maximum number of nodes in the node pool. Must be greater than or equal to
	// total_min_node_count. There has to be enough quota to scale up the cluster.
	// The total_*_node_count fields are mutually exclusive with the *_node_count
	// fields.
	TotalMaxNodeCount int32 `protobuf:"varint,7,opt,name=total_max_node_count,json=totalMaxNodeCount,proto3" json:"total_max_node_count,omitempty"`
}

func (x *NodePoolAutoscaling) Reset() {
	*x = NodePoolAutoscaling{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[103]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePoolAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePoolAutoscaling) ProtoMessage() {}

func (x *NodePoolAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[103]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePoolAutoscaling.ProtoReflect.Descriptor instead.
func (*NodePoolAutoscaling) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{103}
}

func (x *NodePoolAutoscaling) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *NodePoolAutoscaling) GetMinNodeCount() int32 {
	if x != nil {
		return x.MinNodeCount
	}
	return 0
}

func (x *NodePoolAutoscaling) GetMaxNodeCount() int32 {
	if x != nil {
		return x.MaxNodeCount
	}
	return 0
}

func (x *NodePoolAutoscaling) GetAutoprovisioned() bool {
	if x != nil {
		return x.Autoprovisioned
	}
	return false
}

func (x *NodePoolAutoscaling) GetLocationPolicy() NodePoolAutoscaling_LocationPolicy {
	if x != nil {
		return x.LocationPolicy
	}
	return NodePoolAutoscaling_LOCATION_POLICY_UNSPECIFIED
}

func (x *NodePoolAutoscaling) GetTotalMinNodeCount() int32 {
	if x != nil {
		return x.TotalMinNodeCount
	}
	return 0
}

func (x *NodePoolAutoscaling) GetTotalMaxNodeCount() int32 {
	if x != nil {
		return x.TotalMaxNodeCount
	}
	return 0
}

// SetLabelsRequest sets the Google Cloud Platform labels on a Google Container
// Engine cluster, which will in turn set them for Google Compute Engine
// resources used by that cluster
type SetLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The labels to set for that cluster.
	ResourceLabels map[string]string `protobuf:"bytes,4,rep,name=resource_labels,json=resourceLabels,proto3" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The fingerprint of the previous set of labels for this resource,
	// used to detect conflicts. The fingerprint is initially generated by
	// Kubernetes Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash when
	// updating or changing labels. Make a `get()` request to the
	// resource to get the latest fingerprint.
	LabelFingerprint string `protobuf:"bytes,5,opt,name=label_fingerprint,json=labelFingerprint,proto3" json:"label_fingerprint,omitempty"`
	// The name (project, location, cluster name) of the cluster to set labels.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetLabelsRequest) Reset() {
	*x = SetLabelsRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[104]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetLabelsRequest) ProtoMessage() {}

func (x *SetLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[104]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetLabelsRequest.ProtoReflect.Descriptor instead.
func (*SetLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{104}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLabelsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLabelsRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLabelsRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetLabelsRequest) GetResourceLabels() map[string]string {
	if x != nil {
		return x.ResourceLabels
	}
	return nil
}

func (x *SetLabelsRequest) GetLabelFingerprint() string {
	if x != nil {
		return x.LabelFingerprint
	}
	return ""
}

func (x *SetLabelsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetLegacyAbacRequest enables or disables the ABAC authorization mechanism for
// a cluster.
type SetLegacyAbacRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster to update.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Whether ABAC authorization will be enabled in the cluster.
	Enabled bool `protobuf:"varint,4,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The name (project, location, cluster name) of the cluster to set legacy
	// abac. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetLegacyAbacRequest) Reset() {
	*x = SetLegacyAbacRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[105]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetLegacyAbacRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetLegacyAbacRequest) ProtoMessage() {}

func (x *SetLegacyAbacRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[105]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetLegacyAbacRequest.ProtoReflect.Descriptor instead.
func (*SetLegacyAbacRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{105}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLegacyAbacRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLegacyAbacRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetLegacyAbacRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetLegacyAbacRequest) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *SetLegacyAbacRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// StartIPRotationRequest creates a new IP for the cluster and then performs
// a node upgrade on each node pool to point to the new IP.
type StartIPRotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The name (project, location, cluster name) of the cluster to start IP
	// rotation. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// Whether to rotate credentials during IP rotation.
	RotateCredentials bool `protobuf:"varint,7,opt,name=rotate_credentials,json=rotateCredentials,proto3" json:"rotate_credentials,omitempty"`
}

func (x *StartIPRotationRequest) Reset() {
	*x = StartIPRotationRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[106]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartIPRotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartIPRotationRequest) ProtoMessage() {}

func (x *StartIPRotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[106]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartIPRotationRequest.ProtoReflect.Descriptor instead.
func (*StartIPRotationRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{106}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *StartIPRotationRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *StartIPRotationRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *StartIPRotationRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *StartIPRotationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StartIPRotationRequest) GetRotateCredentials() bool {
	if x != nil {
		return x.RotateCredentials
	}
	return false
}

// CompleteIPRotationRequest moves the cluster master back into single-IP mode.
type CompleteIPRotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The name (project, location, cluster name) of the cluster to complete IP
	// rotation. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CompleteIPRotationRequest) Reset() {
	*x = CompleteIPRotationRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[107]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompleteIPRotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteIPRotationRequest) ProtoMessage() {}

func (x *CompleteIPRotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[107]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteIPRotationRequest.ProtoReflect.Descriptor instead.
func (*CompleteIPRotationRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{107}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CompleteIPRotationRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CompleteIPRotationRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *CompleteIPRotationRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *CompleteIPRotationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// AcceleratorConfig represents a Hardware Accelerator request.
type AcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of the accelerator cards exposed to an instance.
	AcceleratorCount int64 `protobuf:"varint,1,opt,name=accelerator_count,json=acceleratorCount,proto3" json:"accelerator_count,omitempty"`
	// The accelerator type resource name. List of supported accelerators
	// [here](https://cloud.google.com/compute/docs/gpus)
	AcceleratorType string `protobuf:"bytes,2,opt,name=accelerator_type,json=acceleratorType,proto3" json:"accelerator_type,omitempty"`
	// Size of partitions to create on the GPU. Valid values are described in the
	// NVIDIA [mig user
	// guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
	GpuPartitionSize string `protobuf:"bytes,3,opt,name=gpu_partition_size,json=gpuPartitionSize,proto3" json:"gpu_partition_size,omitempty"`
	// The configuration for GPU sharing options.
	GpuSharingConfig *GPUSharingConfig `protobuf:"bytes,5,opt,name=gpu_sharing_config,json=gpuSharingConfig,proto3,oneof" json:"gpu_sharing_config,omitempty"`
	// The configuration for auto installation of GPU driver.
	GpuDriverInstallationConfig *GPUDriverInstallationConfig `protobuf:"bytes,6,opt,name=gpu_driver_installation_config,json=gpuDriverInstallationConfig,proto3,oneof" json:"gpu_driver_installation_config,omitempty"`
}

func (x *AcceleratorConfig) Reset() {
	*x = AcceleratorConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[108]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorConfig) ProtoMessage() {}

func (x *AcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[108]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorConfig.ProtoReflect.Descriptor instead.
func (*AcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{108}
}

func (x *AcceleratorConfig) GetAcceleratorCount() int64 {
	if x != nil {
		return x.AcceleratorCount
	}
	return 0
}

func (x *AcceleratorConfig) GetAcceleratorType() string {
	if x != nil {
		return x.AcceleratorType
	}
	return ""
}

func (x *AcceleratorConfig) GetGpuPartitionSize() string {
	if x != nil {
		return x.GpuPartitionSize
	}
	return ""
}

func (x *AcceleratorConfig) GetGpuSharingConfig() *GPUSharingConfig {
	if x != nil {
		return x.GpuSharingConfig
	}
	return nil
}

func (x *AcceleratorConfig) GetGpuDriverInstallationConfig() *GPUDriverInstallationConfig {
	if x != nil {
		return x.GpuDriverInstallationConfig
	}
	return nil
}

// GPUSharingConfig represents the GPU sharing configuration for Hardware
// Accelerators.
type GPUSharingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The max number of containers that can share a physical GPU.
	MaxSharedClientsPerGpu int64 `protobuf:"varint,1,opt,name=max_shared_clients_per_gpu,json=maxSharedClientsPerGpu,proto3" json:"max_shared_clients_per_gpu,omitempty"`
	// The type of GPU sharing strategy to enable on the GPU node.
	GpuSharingStrategy *GPUSharingConfig_GPUSharingStrategy `protobuf:"varint,2,opt,name=gpu_sharing_strategy,json=gpuSharingStrategy,proto3,enum=google.container.v1.GPUSharingConfig_GPUSharingStrategy,oneof" json:"gpu_sharing_strategy,omitempty"`
}

func (x *GPUSharingConfig) Reset() {
	*x = GPUSharingConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[109]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GPUSharingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GPUSharingConfig) ProtoMessage() {}

func (x *GPUSharingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[109]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GPUSharingConfig.ProtoReflect.Descriptor instead.
func (*GPUSharingConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{109}
}

func (x *GPUSharingConfig) GetMaxSharedClientsPerGpu() int64 {
	if x != nil {
		return x.MaxSharedClientsPerGpu
	}
	return 0
}

func (x *GPUSharingConfig) GetGpuSharingStrategy() GPUSharingConfig_GPUSharingStrategy {
	if x != nil && x.GpuSharingStrategy != nil {
		return *x.GpuSharingStrategy
	}
	return GPUSharingConfig_GPU_SHARING_STRATEGY_UNSPECIFIED
}

// GPUDriverInstallationConfig specifies the version of GPU driver to be auto
// installed.
type GPUDriverInstallationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mode for how the GPU driver is installed.
	GpuDriverVersion *GPUDriverInstallationConfig_GPUDriverVersion `protobuf:"varint,1,opt,name=gpu_driver_version,json=gpuDriverVersion,proto3,enum=google.container.v1.GPUDriverInstallationConfig_GPUDriverVersion,oneof" json:"gpu_driver_version,omitempty"`
}

func (x *GPUDriverInstallationConfig) Reset() {
	*x = GPUDriverInstallationConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[110]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GPUDriverInstallationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GPUDriverInstallationConfig) ProtoMessage() {}

func (x *GPUDriverInstallationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[110]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GPUDriverInstallationConfig.ProtoReflect.Descriptor instead.
func (*GPUDriverInstallationConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{110}
}

func (x *GPUDriverInstallationConfig) GetGpuDriverVersion() GPUDriverInstallationConfig_GPUDriverVersion {
	if x != nil && x.GpuDriverVersion != nil {
		return *x.GpuDriverVersion
	}
	return GPUDriverInstallationConfig_GPU_DRIVER_VERSION_UNSPECIFIED
}

// WorkloadMetadataConfig defines the metadata configuration to expose to
// workloads on the node pool.
type WorkloadMetadataConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mode is the configuration for how to expose metadata to workloads running
	// on the node pool.
	Mode WorkloadMetadataConfig_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=google.container.v1.WorkloadMetadataConfig_Mode" json:"mode,omitempty"`
}

func (x *WorkloadMetadataConfig) Reset() {
	*x = WorkloadMetadataConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[111]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkloadMetadataConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadMetadataConfig) ProtoMessage() {}

func (x *WorkloadMetadataConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[111]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadMetadataConfig.ProtoReflect.Descriptor instead.
func (*WorkloadMetadataConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{111}
}

func (x *WorkloadMetadataConfig) GetMode() WorkloadMetadataConfig_Mode {
	if x != nil {
		return x.Mode
	}
	return WorkloadMetadataConfig_MODE_UNSPECIFIED
}

// SetNetworkPolicyRequest enables/disables network policy for a cluster.
type SetNetworkPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Deprecated. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides. This field has been deprecated and replaced by the name
	// field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Deprecated. The name of the cluster.
	// This field has been deprecated and replaced by the name field.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. Configuration options for the NetworkPolicy feature.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,4,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// The name (project, location, cluster name) of the cluster to set networking
	// policy. Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetNetworkPolicyRequest) Reset() {
	*x = SetNetworkPolicyRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[112]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetNetworkPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetNetworkPolicyRequest) ProtoMessage() {}

func (x *SetNetworkPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[112]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetNetworkPolicyRequest.ProtoReflect.Descriptor instead.
func (*SetNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{112}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNetworkPolicyRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNetworkPolicyRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *SetNetworkPolicyRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetNetworkPolicyRequest) GetNetworkPolicy() *NetworkPolicy {
	if x != nil {
		return x.NetworkPolicy
	}
	return nil
}

func (x *SetNetworkPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SetMaintenancePolicyRequest sets the maintenance policy for a cluster.
type SetMaintenancePolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Google Developers Console [project ID or project
	// number](https://cloud.google.com/resource-manager/docs/creating-managing-projects).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The name of the Google Compute Engine
	// [zone](https://cloud.google.com/compute/docs/zones#available) in which the
	// cluster resides.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Required. The name of the cluster to update.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The maintenance policy to be set for the cluster. An empty field
	// clears the existing maintenance policy.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,4,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// The name (project, location, cluster name) of the cluster to set
	// maintenance policy.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SetMaintenancePolicyRequest) Reset() {
	*x = SetMaintenancePolicyRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[113]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetMaintenancePolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMaintenancePolicyRequest) ProtoMessage() {}

func (x *SetMaintenancePolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[113]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMaintenancePolicyRequest.ProtoReflect.Descriptor instead.
func (*SetMaintenancePolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{113}
}

func (x *SetMaintenancePolicyRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SetMaintenancePolicyRequest) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *SetMaintenancePolicyRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *SetMaintenancePolicyRequest) GetMaintenancePolicy() *MaintenancePolicy {
	if x != nil {
		return x.MaintenancePolicy
	}
	return nil
}

func (x *SetMaintenancePolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// StatusCondition describes why a cluster or a node pool has a certain status
// (e.g., ERROR or DEGRADED).
type StatusCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Machine-friendly representation of the condition
	// Deprecated. Use canonical_code instead.
	//
	// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
	Code StatusCondition_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.container.v1.StatusCondition_Code" json:"code,omitempty"`
	// Human-friendly representation of the condition
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Canonical code of the condition.
	CanonicalCode code.Code `protobuf:"varint,3,opt,name=canonical_code,json=canonicalCode,proto3,enum=google.rpc.Code" json:"canonical_code,omitempty"`
}

func (x *StatusCondition) Reset() {
	*x = StatusCondition{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[114]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StatusCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusCondition) ProtoMessage() {}

func (x *StatusCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[114]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusCondition.ProtoReflect.Descriptor instead.
func (*StatusCondition) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{114}
}

// Deprecated: Marked as deprecated in google/container/v1/cluster_service.proto.
func (x *StatusCondition) GetCode() StatusCondition_Code {
	if x != nil {
		return x.Code
	}
	return StatusCondition_UNKNOWN
}

func (x *StatusCondition) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *StatusCondition) GetCanonicalCode() code.Code {
	if x != nil {
		return x.CanonicalCode
	}
	return code.Code(0)
}

// NetworkConfig reports the relative names of network & subnetwork.
type NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative name of the Google Compute Engine
	// [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
	// to which the cluster is connected. Example:
	// projects/my-project/global/networks/my-network
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Output only. The relative name of the Google Compute Engine
	// [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the
	// cluster is connected. Example:
	// projects/my-project/regions/us-central1/subnetworks/my-subnet
	Subnetwork string `protobuf:"bytes,2,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Whether Intra-node visibility is enabled for this cluster.
	// This makes same node pod to pod traffic visible for VPC network.
	EnableIntraNodeVisibility bool `protobuf:"varint,5,opt,name=enable_intra_node_visibility,json=enableIntraNodeVisibility,proto3" json:"enable_intra_node_visibility,omitempty"`
	// Whether the cluster disables default in-node sNAT rules. In-node sNAT rules
	// will be disabled when default_snat_status is disabled. When disabled is set
	// to false, default IP masquerade rules will be applied to the nodes to
	// prevent sNAT on cluster internal traffic.
	DefaultSnatStatus *DefaultSnatStatus `protobuf:"bytes,7,opt,name=default_snat_status,json=defaultSnatStatus,proto3" json:"default_snat_status,omitempty"`
	// Whether L4ILB Subsetting is enabled for this cluster.
	EnableL4IlbSubsetting bool `protobuf:"varint,10,opt,name=enable_l4ilb_subsetting,json=enableL4ilbSubsetting,proto3" json:"enable_l4ilb_subsetting,omitempty"`
	// The desired datapath provider for this cluster. By default, uses the
	// IPTables-based kube-proxy implementation.
	DatapathProvider DatapathProvider `protobuf:"varint,11,opt,name=datapath_provider,json=datapathProvider,proto3,enum=google.container.v1.DatapathProvider" json:"datapath_provider,omitempty"`
	// The desired state of IPv6 connectivity to Google Services.
	// By default, no private IPv6 access to or from Google Services (all access
	// will be via IPv4)
	PrivateIpv6GoogleAccess PrivateIPv6GoogleAccess `protobuf:"varint,12,opt,name=private_ipv6_google_access,json=privateIpv6GoogleAccess,proto3,enum=google.container.v1.PrivateIPv6GoogleAccess" json:"private_ipv6_google_access,omitempty"`
	// DNSConfig contains clusterDNS config for this cluster.
	DnsConfig *DNSConfig `protobuf:"bytes,13,opt,name=dns_config,json=dnsConfig,proto3" json:"dns_config,omitempty"`
	// ServiceExternalIPsConfig specifies if services with externalIPs field are
	// blocked or not.
	ServiceExternalIpsConfig *ServiceExternalIPsConfig `protobuf:"bytes,15,opt,name=service_external_ips_config,json=serviceExternalIpsConfig,proto3" json:"service_external_ips_config,omitempty"`
	// GatewayAPIConfig contains the desired config of Gateway API on this
	// cluster.
	GatewayApiConfig *GatewayAPIConfig `protobuf:"bytes,16,opt,name=gateway_api_config,json=gatewayApiConfig,proto3" json:"gateway_api_config,omitempty"`
	// Whether multi-networking is enabled for this cluster.
	EnableMultiNetworking bool `protobuf:"varint,17,opt,name=enable_multi_networking,json=enableMultiNetworking,proto3" json:"enable_multi_networking,omitempty"`
	// Network bandwidth tier configuration.
	NetworkPerformanceConfig *NetworkConfig_ClusterNetworkPerformanceConfig `protobuf:"bytes,18,opt,name=network_performance_config,json=networkPerformanceConfig,proto3" json:"network_performance_config,omitempty"`
	// Whether FQDN Network Policy is enabled on this cluster.
	EnableFqdnNetworkPolicy *bool `protobuf:"varint,19,opt,name=enable_fqdn_network_policy,json=enableFqdnNetworkPolicy,proto3,oneof" json:"enable_fqdn_network_policy,omitempty"`
	// Specify the details of in-transit encryption.
	// Now named inter-node transparent encryption.
	InTransitEncryptionConfig *InTransitEncryptionConfig `protobuf:"varint,20,opt,name=in_transit_encryption_config,json=inTransitEncryptionConfig,proto3,enum=google.container.v1.InTransitEncryptionConfig,oneof" json:"in_transit_encryption_config,omitempty"`
	// Whether CiliumClusterwideNetworkPolicy is enabled on this cluster.
	EnableCiliumClusterwideNetworkPolicy *bool `protobuf:"varint,21,opt,name=enable_cilium_clusterwide_network_policy,json=enableCiliumClusterwideNetworkPolicy,proto3,oneof" json:"enable_cilium_clusterwide_network_policy,omitempty"`
	// Controls whether by default nodes have private IP addresses only.
	// It is invalid to specify both [PrivateClusterConfig.enablePrivateNodes][]
	// and this field at the same time.
	// To update the default setting, use
	// [ClusterUpdate.desired_default_enable_private_nodes][google.container.v1.ClusterUpdate.desired_default_enable_private_nodes]
	DefaultEnablePrivateNodes *bool `protobuf:"varint,22,opt,name=default_enable_private_nodes,json=defaultEnablePrivateNodes,proto3,oneof" json:"default_enable_private_nodes,omitempty"`
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[115]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[115]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{115}
}

func (x *NetworkConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *NetworkConfig) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *NetworkConfig) GetEnableIntraNodeVisibility() bool {
	if x != nil {
		return x.EnableIntraNodeVisibility
	}
	return false
}

func (x *NetworkConfig) GetDefaultSnatStatus() *DefaultSnatStatus {
	if x != nil {
		return x.DefaultSnatStatus
	}
	return nil
}

func (x *NetworkConfig) GetEnableL4IlbSubsetting() bool {
	if x != nil {
		return x.EnableL4IlbSubsetting
	}
	return false
}

func (x *NetworkConfig) GetDatapathProvider() DatapathProvider {
	if x != nil {
		return x.DatapathProvider
	}
	return DatapathProvider_DATAPATH_PROVIDER_UNSPECIFIED
}

func (x *NetworkConfig) GetPrivateIpv6GoogleAccess() PrivateIPv6GoogleAccess {
	if x != nil {
		return x.PrivateIpv6GoogleAccess
	}
	return PrivateIPv6GoogleAccess_PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED
}

func (x *NetworkConfig) GetDnsConfig() *DNSConfig {
	if x != nil {
		return x.DnsConfig
	}
	return nil
}

func (x *NetworkConfig) GetServiceExternalIpsConfig() *ServiceExternalIPsConfig {
	if x != nil {
		return x.ServiceExternalIpsConfig
	}
	return nil
}

func (x *NetworkConfig) GetGatewayApiConfig() *GatewayAPIConfig {
	if x != nil {
		return x.GatewayApiConfig
	}
	return nil
}

func (x *NetworkConfig) GetEnableMultiNetworking() bool {
	if x != nil {
		return x.EnableMultiNetworking
	}
	return false
}

func (x *NetworkConfig) GetNetworkPerformanceConfig() *NetworkConfig_ClusterNetworkPerformanceConfig {
	if x != nil {
		return x.NetworkPerformanceConfig
	}
	return nil
}

func (x *NetworkConfig) GetEnableFqdnNetworkPolicy() bool {
	if x != nil && x.EnableFqdnNetworkPolicy != nil {
		return *x.EnableFqdnNetworkPolicy
	}
	return false
}

func (x *NetworkConfig) GetInTransitEncryptionConfig() InTransitEncryptionConfig {
	if x != nil && x.InTransitEncryptionConfig != nil {
		return *x.InTransitEncryptionConfig
	}
	return InTransitEncryptionConfig_IN_TRANSIT_ENCRYPTION_CONFIG_UNSPECIFIED
}

func (x *NetworkConfig) GetEnableCiliumClusterwideNetworkPolicy() bool {
	if x != nil && x.EnableCiliumClusterwideNetworkPolicy != nil {
		return *x.EnableCiliumClusterwideNetworkPolicy
	}
	return false
}

func (x *NetworkConfig) GetDefaultEnablePrivateNodes() bool {
	if x != nil && x.DefaultEnablePrivateNodes != nil {
		return *x.DefaultEnablePrivateNodes
	}
	return false
}

// GatewayAPIConfig contains the desired config of Gateway API on this cluster.
type GatewayAPIConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Gateway API release channel to use for Gateway API.
	Channel GatewayAPIConfig_Channel `protobuf:"varint,1,opt,name=channel,proto3,enum=google.container.v1.GatewayAPIConfig_Channel" json:"channel,omitempty"`
}

func (x *GatewayAPIConfig) Reset() {
	*x = GatewayAPIConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[116]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GatewayAPIConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayAPIConfig) ProtoMessage() {}

func (x *GatewayAPIConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[116]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayAPIConfig.ProtoReflect.Descriptor instead.
func (*GatewayAPIConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{116}
}

func (x *GatewayAPIConfig) GetChannel() GatewayAPIConfig_Channel {
	if x != nil {
		return x.Channel
	}
	return GatewayAPIConfig_CHANNEL_UNSPECIFIED
}

// Config to block services with externalIPs field.
type ServiceExternalIPsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Services with ExternalIPs field are allowed or not.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ServiceExternalIPsConfig) Reset() {
	*x = ServiceExternalIPsConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[117]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceExternalIPsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceExternalIPsConfig) ProtoMessage() {}

func (x *ServiceExternalIPsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[117]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceExternalIPsConfig.ProtoReflect.Descriptor instead.
func (*ServiceExternalIPsConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{117}
}

func (x *ServiceExternalIPsConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// GetOpenIDConfigRequest gets the OIDC discovery document for the
// cluster. See the OpenID Connect Discovery 1.0 specification for details.
type GetOpenIDConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The cluster (project, location, cluster name) to get the discovery document
	// for. Specified in the format `projects/*/locations/*/clusters/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *GetOpenIDConfigRequest) Reset() {
	*x = GetOpenIDConfigRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[118]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOpenIDConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOpenIDConfigRequest) ProtoMessage() {}

func (x *GetOpenIDConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[118]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOpenIDConfigRequest.ProtoReflect.Descriptor instead.
func (*GetOpenIDConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{118}
}

func (x *GetOpenIDConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// GetOpenIDConfigResponse is an OIDC discovery document for the cluster.
// See the OpenID Connect Discovery 1.0 specification for details.
type GetOpenIDConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// OIDC Issuer.
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// JSON Web Key uri.
	JwksUri string `protobuf:"bytes,2,opt,name=jwks_uri,json=jwksUri,proto3" json:"jwks_uri,omitempty"`
	// Supported response types.
	ResponseTypesSupported []string `protobuf:"bytes,3,rep,name=response_types_supported,json=responseTypesSupported,proto3" json:"response_types_supported,omitempty"`
	// Supported subject types.
	SubjectTypesSupported []string `protobuf:"bytes,4,rep,name=subject_types_supported,json=subjectTypesSupported,proto3" json:"subject_types_supported,omitempty"`
	// supported ID Token signing Algorithms.
	IdTokenSigningAlgValuesSupported []string `protobuf:"bytes,5,rep,name=id_token_signing_alg_values_supported,json=idTokenSigningAlgValuesSupported,proto3" json:"id_token_signing_alg_values_supported,omitempty"`
	// Supported claims.
	ClaimsSupported []string `protobuf:"bytes,6,rep,name=claims_supported,json=claimsSupported,proto3" json:"claims_supported,omitempty"`
	// Supported grant types.
	GrantTypes []string `protobuf:"bytes,7,rep,name=grant_types,json=grantTypes,proto3" json:"grant_types,omitempty"`
}

func (x *GetOpenIDConfigResponse) Reset() {
	*x = GetOpenIDConfigResponse{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[119]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOpenIDConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOpenIDConfigResponse) ProtoMessage() {}

func (x *GetOpenIDConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[119]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOpenIDConfigResponse.ProtoReflect.Descriptor instead.
func (*GetOpenIDConfigResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{119}
}

func (x *GetOpenIDConfigResponse) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *GetOpenIDConfigResponse) GetJwksUri() string {
	if x != nil {
		return x.JwksUri
	}
	return ""
}

func (x *GetOpenIDConfigResponse) GetResponseTypesSupported() []string {
	if x != nil {
		return x.ResponseTypesSupported
	}
	return nil
}

func (x *GetOpenIDConfigResponse) GetSubjectTypesSupported() []string {
	if x != nil {
		return x.SubjectTypesSupported
	}
	return nil
}

func (x *GetOpenIDConfigResponse) GetIdTokenSigningAlgValuesSupported() []string {
	if x != nil {
		return x.IdTokenSigningAlgValuesSupported
	}
	return nil
}

func (x *GetOpenIDConfigResponse) GetClaimsSupported() []string {
	if x != nil {
		return x.ClaimsSupported
	}
	return nil
}

func (x *GetOpenIDConfigResponse) GetGrantTypes() []string {
	if x != nil {
		return x.GrantTypes
	}
	return nil
}

// GetJSONWebKeysRequest gets the public component of the keys used by the
// cluster to sign token requests. This will be the jwks_uri for the discover
// document returned by getOpenIDConfig. See the OpenID Connect
// Discovery 1.0 specification for details.
type GetJSONWebKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The cluster (project, location, cluster name) to get keys for. Specified in
	// the format `projects/*/locations/*/clusters/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *GetJSONWebKeysRequest) Reset() {
	*x = GetJSONWebKeysRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[120]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetJSONWebKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJSONWebKeysRequest) ProtoMessage() {}

func (x *GetJSONWebKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[120]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJSONWebKeysRequest.ProtoReflect.Descriptor instead.
func (*GetJSONWebKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{120}
}

func (x *GetJSONWebKeysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Jwk is a JSON Web Key as specified in RFC 7517
type Jwk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key Type.
	Kty string `protobuf:"bytes,1,opt,name=kty,proto3" json:"kty,omitempty"`
	// Algorithm.
	Alg string `protobuf:"bytes,2,opt,name=alg,proto3" json:"alg,omitempty"`
	// Permitted uses for the public keys.
	Use string `protobuf:"bytes,3,opt,name=use,proto3" json:"use,omitempty"`
	// Key ID.
	Kid string `protobuf:"bytes,4,opt,name=kid,proto3" json:"kid,omitempty"`
	// Used for RSA keys.
	N string `protobuf:"bytes,5,opt,name=n,proto3" json:"n,omitempty"`
	// Used for RSA keys.
	E string `protobuf:"bytes,6,opt,name=e,proto3" json:"e,omitempty"`
	// Used for ECDSA keys.
	X string `protobuf:"bytes,7,opt,name=x,proto3" json:"x,omitempty"`
	// Used for ECDSA keys.
	Y string `protobuf:"bytes,8,opt,name=y,proto3" json:"y,omitempty"`
	// Used for ECDSA keys.
	Crv string `protobuf:"bytes,9,opt,name=crv,proto3" json:"crv,omitempty"`
}

func (x *Jwk) Reset() {
	*x = Jwk{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[121]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Jwk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Jwk) ProtoMessage() {}

func (x *Jwk) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[121]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Jwk.ProtoReflect.Descriptor instead.
func (*Jwk) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{121}
}

func (x *Jwk) GetKty() string {
	if x != nil {
		return x.Kty
	}
	return ""
}

func (x *Jwk) GetAlg() string {
	if x != nil {
		return x.Alg
	}
	return ""
}

func (x *Jwk) GetUse() string {
	if x != nil {
		return x.Use
	}
	return ""
}

func (x *Jwk) GetKid() string {
	if x != nil {
		return x.Kid
	}
	return ""
}

func (x *Jwk) GetN() string {
	if x != nil {
		return x.N
	}
	return ""
}

func (x *Jwk) GetE() string {
	if x != nil {
		return x.E
	}
	return ""
}

func (x *Jwk) GetX() string {
	if x != nil {
		return x.X
	}
	return ""
}

func (x *Jwk) GetY() string {
	if x != nil {
		return x.Y
	}
	return ""
}

func (x *Jwk) GetCrv() string {
	if x != nil {
		return x.Crv
	}
	return ""
}

// GetJSONWebKeysResponse is a valid JSON Web Key Set as specififed in rfc 7517
type GetJSONWebKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The public component of the keys used by the cluster to sign token
	// requests.
	Keys []*Jwk `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
}

func (x *GetJSONWebKeysResponse) Reset() {
	*x = GetJSONWebKeysResponse{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[122]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetJSONWebKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetJSONWebKeysResponse) ProtoMessage() {}

func (x *GetJSONWebKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[122]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetJSONWebKeysResponse.ProtoReflect.Descriptor instead.
func (*GetJSONWebKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{122}
}

func (x *GetJSONWebKeysResponse) GetKeys() []*Jwk {
	if x != nil {
		return x.Keys
	}
	return nil
}

// CheckAutopilotCompatibilityRequest requests getting the blockers for the
// given operation in the cluster.
type CheckAutopilotCompatibilityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name (project, location, cluster) of the cluster to retrieve.
	// Specified in the format `projects/*/locations/*/clusters/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CheckAutopilotCompatibilityRequest) Reset() {
	*x = CheckAutopilotCompatibilityRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[123]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckAutopilotCompatibilityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckAutopilotCompatibilityRequest) ProtoMessage() {}

func (x *CheckAutopilotCompatibilityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[123]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckAutopilotCompatibilityRequest.ProtoReflect.Descriptor instead.
func (*CheckAutopilotCompatibilityRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{123}
}

func (x *CheckAutopilotCompatibilityRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// AutopilotCompatibilityIssue contains information about a specific
// compatibility issue with Autopilot mode.
type AutopilotCompatibilityIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The last time when this issue was observed.
	LastObservation *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=last_observation,json=lastObservation,proto3" json:"last_observation,omitempty"`
	// The constraint type of the issue.
	ConstraintType string `protobuf:"bytes,2,opt,name=constraint_type,json=constraintType,proto3" json:"constraint_type,omitempty"`
	// The incompatibility type of this issue.
	IncompatibilityType AutopilotCompatibilityIssue_IssueType `protobuf:"varint,3,opt,name=incompatibility_type,json=incompatibilityType,proto3,enum=google.container.v1.AutopilotCompatibilityIssue_IssueType" json:"incompatibility_type,omitempty"`
	// The name of the resources which are subject to this issue.
	Subjects []string `protobuf:"bytes,4,rep,name=subjects,proto3" json:"subjects,omitempty"`
	// A URL to a public documnetation, which addresses resolving this issue.
	DocumentationUrl string `protobuf:"bytes,5,opt,name=documentation_url,json=documentationUrl,proto3" json:"documentation_url,omitempty"`
	// The description of the issue.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *AutopilotCompatibilityIssue) Reset() {
	*x = AutopilotCompatibilityIssue{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[124]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutopilotCompatibilityIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutopilotCompatibilityIssue) ProtoMessage() {}

func (x *AutopilotCompatibilityIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[124]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutopilotCompatibilityIssue.ProtoReflect.Descriptor instead.
func (*AutopilotCompatibilityIssue) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{124}
}

func (x *AutopilotCompatibilityIssue) GetLastObservation() *timestamppb.Timestamp {
	if x != nil {
		return x.LastObservation
	}
	return nil
}

func (x *AutopilotCompatibilityIssue) GetConstraintType() string {
	if x != nil {
		return x.ConstraintType
	}
	return ""
}

func (x *AutopilotCompatibilityIssue) GetIncompatibilityType() AutopilotCompatibilityIssue_IssueType {
	if x != nil {
		return x.IncompatibilityType
	}
	return AutopilotCompatibilityIssue_UNSPECIFIED
}

func (x *AutopilotCompatibilityIssue) GetSubjects() []string {
	if x != nil {
		return x.Subjects
	}
	return nil
}

func (x *AutopilotCompatibilityIssue) GetDocumentationUrl() string {
	if x != nil {
		return x.DocumentationUrl
	}
	return ""
}

func (x *AutopilotCompatibilityIssue) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// CheckAutopilotCompatibilityResponse has a list of compatibility issues.
type CheckAutopilotCompatibilityResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of issues for the given operation.
	Issues []*AutopilotCompatibilityIssue `protobuf:"bytes,1,rep,name=issues,proto3" json:"issues,omitempty"`
	// The summary of the autopilot compatibility response.
	Summary string `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
}

func (x *CheckAutopilotCompatibilityResponse) Reset() {
	*x = CheckAutopilotCompatibilityResponse{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[125]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckAutopilotCompatibilityResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckAutopilotCompatibilityResponse) ProtoMessage() {}

func (x *CheckAutopilotCompatibilityResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[125]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckAutopilotCompatibilityResponse.ProtoReflect.Descriptor instead.
func (*CheckAutopilotCompatibilityResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{125}
}

func (x *CheckAutopilotCompatibilityResponse) GetIssues() []*AutopilotCompatibilityIssue {
	if x != nil {
		return x.Issues
	}
	return nil
}

func (x *CheckAutopilotCompatibilityResponse) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

// ReleaseChannel indicates which release channel a cluster is
// subscribed to. Release channels are arranged in order of risk.
//
// When a cluster is subscribed to a release channel, Google maintains
// both the master version and the node version. Node auto-upgrade
// defaults to true and cannot be disabled.
type ReleaseChannel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// channel specifies which release channel the cluster is subscribed to.
	Channel ReleaseChannel_Channel `protobuf:"varint,1,opt,name=channel,proto3,enum=google.container.v1.ReleaseChannel_Channel" json:"channel,omitempty"`
}

func (x *ReleaseChannel) Reset() {
	*x = ReleaseChannel{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[126]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReleaseChannel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReleaseChannel) ProtoMessage() {}

func (x *ReleaseChannel) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[126]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReleaseChannel.ProtoReflect.Descriptor instead.
func (*ReleaseChannel) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{126}
}

func (x *ReleaseChannel) GetChannel() ReleaseChannel_Channel {
	if x != nil {
		return x.Channel
	}
	return ReleaseChannel_UNSPECIFIED
}

// Configuration for fine-grained cost management feature.
type CostManagementConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the feature is enabled or not.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *CostManagementConfig) Reset() {
	*x = CostManagementConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[127]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CostManagementConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CostManagementConfig) ProtoMessage() {}

func (x *CostManagementConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[127]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CostManagementConfig.ProtoReflect.Descriptor instead.
func (*CostManagementConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{127}
}

func (x *CostManagementConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// IntraNodeVisibilityConfig contains the desired config of the intra-node
// visibility on this cluster.
type IntraNodeVisibilityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables intra node visibility for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *IntraNodeVisibilityConfig) Reset() {
	*x = IntraNodeVisibilityConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[128]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IntraNodeVisibilityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntraNodeVisibilityConfig) ProtoMessage() {}

func (x *IntraNodeVisibilityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[128]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntraNodeVisibilityConfig.ProtoReflect.Descriptor instead.
func (*IntraNodeVisibilityConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{128}
}

func (x *IntraNodeVisibilityConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// ILBSubsettingConfig contains the desired config of L4 Internal LoadBalancer
// subsetting on this cluster.
type ILBSubsettingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables l4 ILB subsetting for this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ILBSubsettingConfig) Reset() {
	*x = ILBSubsettingConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[129]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ILBSubsettingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ILBSubsettingConfig) ProtoMessage() {}

func (x *ILBSubsettingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[129]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ILBSubsettingConfig.ProtoReflect.Descriptor instead.
func (*ILBSubsettingConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{129}
}

func (x *ILBSubsettingConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// DNSConfig contains the desired set of options for configuring clusterDNS.
type DNSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// cluster_dns indicates which in-cluster DNS provider should be used.
	ClusterDns DNSConfig_Provider `protobuf:"varint,1,opt,name=cluster_dns,json=clusterDns,proto3,enum=google.container.v1.DNSConfig_Provider" json:"cluster_dns,omitempty"`
	// cluster_dns_scope indicates the scope of access to cluster DNS records.
	ClusterDnsScope DNSConfig_DNSScope `protobuf:"varint,2,opt,name=cluster_dns_scope,json=clusterDnsScope,proto3,enum=google.container.v1.DNSConfig_DNSScope" json:"cluster_dns_scope,omitempty"`
	// cluster_dns_domain is the suffix used for all cluster service records.
	ClusterDnsDomain string `protobuf:"bytes,3,opt,name=cluster_dns_domain,json=clusterDnsDomain,proto3" json:"cluster_dns_domain,omitempty"`
	// Optional. The domain used in Additive VPC scope.
	AdditiveVpcScopeDnsDomain string `protobuf:"bytes,5,opt,name=additive_vpc_scope_dns_domain,json=additiveVpcScopeDnsDomain,proto3" json:"additive_vpc_scope_dns_domain,omitempty"`
}

func (x *DNSConfig) Reset() {
	*x = DNSConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[130]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DNSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DNSConfig) ProtoMessage() {}

func (x *DNSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[130]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DNSConfig.ProtoReflect.Descriptor instead.
func (*DNSConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{130}
}

func (x *DNSConfig) GetClusterDns() DNSConfig_Provider {
	if x != nil {
		return x.ClusterDns
	}
	return DNSConfig_PROVIDER_UNSPECIFIED
}

func (x *DNSConfig) GetClusterDnsScope() DNSConfig_DNSScope {
	if x != nil {
		return x.ClusterDnsScope
	}
	return DNSConfig_DNS_SCOPE_UNSPECIFIED
}

func (x *DNSConfig) GetClusterDnsDomain() string {
	if x != nil {
		return x.ClusterDnsDomain
	}
	return ""
}

func (x *DNSConfig) GetAdditiveVpcScopeDnsDomain() string {
	if x != nil {
		return x.AdditiveVpcScopeDnsDomain
	}
	return ""
}

// Constraints applied to pods.
type MaxPodsConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Constraint enforced on the max num of pods per node.
	MaxPodsPerNode int64 `protobuf:"varint,1,opt,name=max_pods_per_node,json=maxPodsPerNode,proto3" json:"max_pods_per_node,omitempty"`
}

func (x *MaxPodsConstraint) Reset() {
	*x = MaxPodsConstraint{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[131]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaxPodsConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaxPodsConstraint) ProtoMessage() {}

func (x *MaxPodsConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[131]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaxPodsConstraint.ProtoReflect.Descriptor instead.
func (*MaxPodsConstraint) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{131}
}

func (x *MaxPodsConstraint) GetMaxPodsPerNode() int64 {
	if x != nil {
		return x.MaxPodsPerNode
	}
	return 0
}

// Configuration for the use of Kubernetes Service Accounts in GCP IAM
// policies.
type WorkloadIdentityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The workload pool to attach all Kubernetes service accounts to.
	WorkloadPool string `protobuf:"bytes,2,opt,name=workload_pool,json=workloadPool,proto3" json:"workload_pool,omitempty"`
}

func (x *WorkloadIdentityConfig) Reset() {
	*x = WorkloadIdentityConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[132]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkloadIdentityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadIdentityConfig) ProtoMessage() {}

func (x *WorkloadIdentityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[132]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadIdentityConfig.ProtoReflect.Descriptor instead.
func (*WorkloadIdentityConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{132}
}

func (x *WorkloadIdentityConfig) GetWorkloadPool() string {
	if x != nil {
		return x.WorkloadPool
	}
	return ""
}

// IdentityServiceConfig is configuration for Identity Service which allows
// customers to use external identity providers with the K8S API
type IdentityServiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to enable the Identity Service component
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *IdentityServiceConfig) Reset() {
	*x = IdentityServiceConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[133]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IdentityServiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdentityServiceConfig) ProtoMessage() {}

func (x *IdentityServiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[133]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdentityServiceConfig.ProtoReflect.Descriptor instead.
func (*IdentityServiceConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{133}
}

func (x *IdentityServiceConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration for issuance of mTLS keys and certificates to Kubernetes pods.
type MeshCertificates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// enable_certificates controls issuance of workload mTLS certificates.
	//
	// If set, the GKE Workload Identity Certificates controller and node agent
	// will be deployed in the cluster, which can then be configured by creating a
	// WorkloadCertificateConfig Custom Resource.
	//
	// Requires Workload Identity
	// ([workload_pool][google.container.v1.WorkloadIdentityConfig.workload_pool]
	// must be non-empty).
	EnableCertificates *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enable_certificates,json=enableCertificates,proto3" json:"enable_certificates,omitempty"`
}

func (x *MeshCertificates) Reset() {
	*x = MeshCertificates{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[134]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshCertificates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshCertificates) ProtoMessage() {}

func (x *MeshCertificates) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[134]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshCertificates.ProtoReflect.Descriptor instead.
func (*MeshCertificates) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{134}
}

func (x *MeshCertificates) GetEnableCertificates() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableCertificates
	}
	return nil
}

// Configuration of etcd encryption.
type DatabaseEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of CloudKMS key to use for the encryption of secrets in etcd.
	// Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
	KeyName string `protobuf:"bytes,1,opt,name=key_name,json=keyName,proto3" json:"key_name,omitempty"`
	// The desired state of etcd encryption.
	State DatabaseEncryption_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.container.v1.DatabaseEncryption_State" json:"state,omitempty"`
	// Output only. The current state of etcd encryption.
	CurrentState *DatabaseEncryption_CurrentState `protobuf:"varint,3,opt,name=current_state,json=currentState,proto3,enum=google.container.v1.DatabaseEncryption_CurrentState,oneof" json:"current_state,omitempty"`
	// Output only. Keys in use by the cluster for decrypting
	// existing objects, in addition to the key in `key_name`.
	//
	// Each item is a CloudKMS key resource.
	DecryptionKeys []string `protobuf:"bytes,4,rep,name=decryption_keys,json=decryptionKeys,proto3" json:"decryption_keys,omitempty"`
	// Output only. Records errors seen during DatabaseEncryption update
	// operations.
	LastOperationErrors []*DatabaseEncryption_OperationError `protobuf:"bytes,5,rep,name=last_operation_errors,json=lastOperationErrors,proto3" json:"last_operation_errors,omitempty"`
}

func (x *DatabaseEncryption) Reset() {
	*x = DatabaseEncryption{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[135]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatabaseEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseEncryption) ProtoMessage() {}

func (x *DatabaseEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[135]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseEncryption.ProtoReflect.Descriptor instead.
func (*DatabaseEncryption) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{135}
}

func (x *DatabaseEncryption) GetKeyName() string {
	if x != nil {
		return x.KeyName
	}
	return ""
}

func (x *DatabaseEncryption) GetState() DatabaseEncryption_State {
	if x != nil {
		return x.State
	}
	return DatabaseEncryption_UNKNOWN
}

func (x *DatabaseEncryption) GetCurrentState() DatabaseEncryption_CurrentState {
	if x != nil && x.CurrentState != nil {
		return *x.CurrentState
	}
	return DatabaseEncryption_CURRENT_STATE_UNSPECIFIED
}

func (x *DatabaseEncryption) GetDecryptionKeys() []string {
	if x != nil {
		return x.DecryptionKeys
	}
	return nil
}

func (x *DatabaseEncryption) GetLastOperationErrors() []*DatabaseEncryption_OperationError {
	if x != nil {
		return x.LastOperationErrors
	}
	return nil
}

// ListUsableSubnetworksRequest requests the list of usable subnetworks
// available to a user for creating clusters.
type ListUsableSubnetworksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent project where subnetworks are usable.
	// Specified in the format `projects/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Filtering currently only supports equality on the networkProjectId and must
	// be in the form: "networkProjectId=[PROJECTID]", where `networkProjectId`
	// is the project which owns the listed subnetworks. This defaults to the
	// parent project ID.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The max number of results per page that should be returned. If the number
	// of available results is larger than `page_size`, a `next_page_token` is
	// returned which can be used to get the next page of results in subsequent
	// requests. Acceptable values are 0 to 500, inclusive. (Default: 500)
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Specifies a page token to use. Set this to the nextPageToken returned by
	// previous list requests to get the next page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListUsableSubnetworksRequest) Reset() {
	*x = ListUsableSubnetworksRequest{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[136]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUsableSubnetworksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsableSubnetworksRequest) ProtoMessage() {}

func (x *ListUsableSubnetworksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[136]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUsableSubnetworksRequest.ProtoReflect.Descriptor instead.
func (*ListUsableSubnetworksRequest) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{136}
}

func (x *ListUsableSubnetworksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListUsableSubnetworksRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListUsableSubnetworksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUsableSubnetworksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// ListUsableSubnetworksResponse is the response of
// ListUsableSubnetworksRequest.
type ListUsableSubnetworksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of usable subnetworks in the specified network project.
	Subnetworks []*UsableSubnetwork `protobuf:"bytes,1,rep,name=subnetworks,proto3" json:"subnetworks,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `page_size`, use the
	// `next_page_token` as a value for the query parameter `page_token` in the
	// next request. The value will become empty when there are no more pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListUsableSubnetworksResponse) Reset() {
	*x = ListUsableSubnetworksResponse{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[137]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUsableSubnetworksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsableSubnetworksResponse) ProtoMessage() {}

func (x *ListUsableSubnetworksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[137]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUsableSubnetworksResponse.ProtoReflect.Descriptor instead.
func (*ListUsableSubnetworksResponse) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{137}
}

func (x *ListUsableSubnetworksResponse) GetSubnetworks() []*UsableSubnetwork {
	if x != nil {
		return x.Subnetworks
	}
	return nil
}

func (x *ListUsableSubnetworksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Secondary IP range of a usable subnetwork.
type UsableSubnetworkSecondaryRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name associated with this subnetwork secondary range, used when adding
	// an alias IP range to a VM instance.
	RangeName string `protobuf:"bytes,1,opt,name=range_name,json=rangeName,proto3" json:"range_name,omitempty"`
	// The range of IP addresses belonging to this subnetwork secondary range.
	IpCidrRange string `protobuf:"bytes,2,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// This field is to determine the status of the secondary range programmably.
	Status UsableSubnetworkSecondaryRange_Status `protobuf:"varint,3,opt,name=status,proto3,enum=google.container.v1.UsableSubnetworkSecondaryRange_Status" json:"status,omitempty"`
}

func (x *UsableSubnetworkSecondaryRange) Reset() {
	*x = UsableSubnetworkSecondaryRange{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[138]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UsableSubnetworkSecondaryRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsableSubnetworkSecondaryRange) ProtoMessage() {}

func (x *UsableSubnetworkSecondaryRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[138]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsableSubnetworkSecondaryRange.ProtoReflect.Descriptor instead.
func (*UsableSubnetworkSecondaryRange) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{138}
}

func (x *UsableSubnetworkSecondaryRange) GetRangeName() string {
	if x != nil {
		return x.RangeName
	}
	return ""
}

func (x *UsableSubnetworkSecondaryRange) GetIpCidrRange() string {
	if x != nil {
		return x.IpCidrRange
	}
	return ""
}

func (x *UsableSubnetworkSecondaryRange) GetStatus() UsableSubnetworkSecondaryRange_Status {
	if x != nil {
		return x.Status
	}
	return UsableSubnetworkSecondaryRange_UNKNOWN
}

// UsableSubnetwork resource returns the subnetwork name, its associated network
// and the primary CIDR range.
type UsableSubnetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Subnetwork Name.
	// Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
	Subnetwork string `protobuf:"bytes,1,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Network Name.
	// Example: projects/my-project/global/networks/my-network
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
	// The range of internal addresses that are owned by this subnetwork.
	IpCidrRange string `protobuf:"bytes,3,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// Secondary IP ranges.
	SecondaryIpRanges []*UsableSubnetworkSecondaryRange `protobuf:"bytes,4,rep,name=secondary_ip_ranges,json=secondaryIpRanges,proto3" json:"secondary_ip_ranges,omitempty"`
	// A human readable status message representing the reasons for cases where
	// the caller cannot use the secondary ranges under the subnet. For example if
	// the secondary_ip_ranges is empty due to a permission issue, an insufficient
	// permission message will be given by status_message.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
}

func (x *UsableSubnetwork) Reset() {
	*x = UsableSubnetwork{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[139]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UsableSubnetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsableSubnetwork) ProtoMessage() {}

func (x *UsableSubnetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[139]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsableSubnetwork.ProtoReflect.Descriptor instead.
func (*UsableSubnetwork) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{139}
}

func (x *UsableSubnetwork) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *UsableSubnetwork) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *UsableSubnetwork) GetIpCidrRange() string {
	if x != nil {
		return x.IpCidrRange
	}
	return ""
}

func (x *UsableSubnetwork) GetSecondaryIpRanges() []*UsableSubnetworkSecondaryRange {
	if x != nil {
		return x.SecondaryIpRanges
	}
	return nil
}

func (x *UsableSubnetwork) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

// Configuration for exporting cluster resource usages.
type ResourceUsageExportConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration to use BigQuery as usage export destination.
	BigqueryDestination *ResourceUsageExportConfig_BigQueryDestination `protobuf:"bytes,1,opt,name=bigquery_destination,json=bigqueryDestination,proto3" json:"bigquery_destination,omitempty"`
	// Whether to enable network egress metering for this cluster. If enabled, a
	// daemonset will be created in the cluster to meter network egress traffic.
	EnableNetworkEgressMetering bool `protobuf:"varint,2,opt,name=enable_network_egress_metering,json=enableNetworkEgressMetering,proto3" json:"enable_network_egress_metering,omitempty"`
	// Configuration to enable resource consumption metering.
	ConsumptionMeteringConfig *ResourceUsageExportConfig_ConsumptionMeteringConfig `protobuf:"bytes,3,opt,name=consumption_metering_config,json=consumptionMeteringConfig,proto3" json:"consumption_metering_config,omitempty"`
}

func (x *ResourceUsageExportConfig) Reset() {
	*x = ResourceUsageExportConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[140]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceUsageExportConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceUsageExportConfig) ProtoMessage() {}

func (x *ResourceUsageExportConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[140]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceUsageExportConfig.ProtoReflect.Descriptor instead.
func (*ResourceUsageExportConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{140}
}

func (x *ResourceUsageExportConfig) GetBigqueryDestination() *ResourceUsageExportConfig_BigQueryDestination {
	if x != nil {
		return x.BigqueryDestination
	}
	return nil
}

func (x *ResourceUsageExportConfig) GetEnableNetworkEgressMetering() bool {
	if x != nil {
		return x.EnableNetworkEgressMetering
	}
	return false
}

func (x *ResourceUsageExportConfig) GetConsumptionMeteringConfig() *ResourceUsageExportConfig_ConsumptionMeteringConfig {
	if x != nil {
		return x.ConsumptionMeteringConfig
	}
	return nil
}

// VerticalPodAutoscaling contains global, per-cluster information
// required by Vertical Pod Autoscaler to automatically adjust
// the resources of pods controlled by it.
type VerticalPodAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enables vertical pod autoscaling.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *VerticalPodAutoscaling) Reset() {
	*x = VerticalPodAutoscaling{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[141]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VerticalPodAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerticalPodAutoscaling) ProtoMessage() {}

func (x *VerticalPodAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[141]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerticalPodAutoscaling.ProtoReflect.Descriptor instead.
func (*VerticalPodAutoscaling) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{141}
}

func (x *VerticalPodAutoscaling) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// DefaultSnatStatus contains the desired state of whether default sNAT should
// be disabled on the cluster.
type DefaultSnatStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Disables cluster default sNAT rules.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *DefaultSnatStatus) Reset() {
	*x = DefaultSnatStatus{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[142]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DefaultSnatStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DefaultSnatStatus) ProtoMessage() {}

func (x *DefaultSnatStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[142]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DefaultSnatStatus.ProtoReflect.Descriptor instead.
func (*DefaultSnatStatus) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{142}
}

func (x *DefaultSnatStatus) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// Configuration of Shielded Nodes feature.
type ShieldedNodes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Shielded Nodes features are enabled on all nodes in this cluster.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ShieldedNodes) Reset() {
	*x = ShieldedNodes{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[143]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShieldedNodes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShieldedNodes) ProtoMessage() {}

func (x *ShieldedNodes) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[143]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShieldedNodes.ProtoReflect.Descriptor instead.
func (*ShieldedNodes) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{143}
}

func (x *ShieldedNodes) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration of gVNIC feature.
type VirtualNIC struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether gVNIC features are enabled in the node pool.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *VirtualNIC) Reset() {
	*x = VirtualNIC{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[144]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VirtualNIC) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirtualNIC) ProtoMessage() {}

func (x *VirtualNIC) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[144]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirtualNIC.ProtoReflect.Descriptor instead.
func (*VirtualNIC) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{144}
}

func (x *VirtualNIC) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Configuration of Fast Socket feature.
type FastSocket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Fast Socket features are enabled in the node pool.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *FastSocket) Reset() {
	*x = FastSocket{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[145]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FastSocket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FastSocket) ProtoMessage() {}

func (x *FastSocket) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[145]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FastSocket.ProtoReflect.Descriptor instead.
func (*FastSocket) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{145}
}

func (x *FastSocket) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// NotificationConfig is the configuration of notifications.
type NotificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Notification config for Pub/Sub.
	Pubsub *NotificationConfig_PubSub `protobuf:"bytes,1,opt,name=pubsub,proto3" json:"pubsub,omitempty"`
}

func (x *NotificationConfig) Reset() {
	*x = NotificationConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[146]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationConfig) ProtoMessage() {}

func (x *NotificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[146]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationConfig.ProtoReflect.Descriptor instead.
func (*NotificationConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{146}
}

func (x *NotificationConfig) GetPubsub() *NotificationConfig_PubSub {
	if x != nil {
		return x.Pubsub
	}
	return nil
}

// ConfidentialNodes is configuration for the confidential nodes feature, which
// makes nodes run on confidential VMs.
type ConfidentialNodes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Confidential Nodes feature is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ConfidentialNodes) Reset() {
	*x = ConfidentialNodes{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[147]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConfidentialNodes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfidentialNodes) ProtoMessage() {}

func (x *ConfidentialNodes) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[147]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfidentialNodes.ProtoReflect.Descriptor instead.
func (*ConfidentialNodes) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{147}
}

func (x *ConfidentialNodes) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// UpgradeEvent is a notification sent to customers by the cluster server when
// a resource is upgrading.
type UpgradeEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource type that is upgrading.
	ResourceType UpgradeResourceType `protobuf:"varint,1,opt,name=resource_type,json=resourceType,proto3,enum=google.container.v1.UpgradeResourceType" json:"resource_type,omitempty"`
	// The operation associated with this upgrade.
	Operation string `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// The time when the operation was started.
	OperationStartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=operation_start_time,json=operationStartTime,proto3" json:"operation_start_time,omitempty"`
	// The current version before the upgrade.
	CurrentVersion string `protobuf:"bytes,4,opt,name=current_version,json=currentVersion,proto3" json:"current_version,omitempty"`
	// The target version for the upgrade.
	TargetVersion string `protobuf:"bytes,5,opt,name=target_version,json=targetVersion,proto3" json:"target_version,omitempty"`
	// Optional relative path to the resource. For example in node pool upgrades,
	// the relative path of the node pool.
	Resource string `protobuf:"bytes,6,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *UpgradeEvent) Reset() {
	*x = UpgradeEvent{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[148]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeEvent) ProtoMessage() {}

func (x *UpgradeEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[148]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeEvent.ProtoReflect.Descriptor instead.
func (*UpgradeEvent) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{148}
}

func (x *UpgradeEvent) GetResourceType() UpgradeResourceType {
	if x != nil {
		return x.ResourceType
	}
	return UpgradeResourceType_UPGRADE_RESOURCE_TYPE_UNSPECIFIED
}

func (x *UpgradeEvent) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *UpgradeEvent) GetOperationStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.OperationStartTime
	}
	return nil
}

func (x *UpgradeEvent) GetCurrentVersion() string {
	if x != nil {
		return x.CurrentVersion
	}
	return ""
}

func (x *UpgradeEvent) GetTargetVersion() string {
	if x != nil {
		return x.TargetVersion
	}
	return ""
}

func (x *UpgradeEvent) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

// UpgradeInfoEvent is a notification sent to customers about the upgrade
// information of a resource.
type UpgradeInfoEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource type associated with the upgrade.
	ResourceType UpgradeResourceType `protobuf:"varint,1,opt,name=resource_type,json=resourceType,proto3,enum=google.container.v1.UpgradeResourceType" json:"resource_type,omitempty"`
	// The operation associated with this upgrade.
	Operation string `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// The time when the operation was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time when the operation ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The current version before the upgrade.
	CurrentVersion string `protobuf:"bytes,5,opt,name=current_version,json=currentVersion,proto3" json:"current_version,omitempty"`
	// The target version for the upgrade.
	TargetVersion string `protobuf:"bytes,6,opt,name=target_version,json=targetVersion,proto3" json:"target_version,omitempty"`
	// Optional relative path to the resource. For example in node pool upgrades,
	// the relative path of the node pool.
	Resource string `protobuf:"bytes,7,opt,name=resource,proto3" json:"resource,omitempty"`
	// Output only. The state of the upgrade.
	State UpgradeInfoEvent_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.container.v1.UpgradeInfoEvent_State" json:"state,omitempty"`
	// A brief description of the event.
	Description string `protobuf:"bytes,11,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *UpgradeInfoEvent) Reset() {
	*x = UpgradeInfoEvent{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[149]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeInfoEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeInfoEvent) ProtoMessage() {}

func (x *UpgradeInfoEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[149]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeInfoEvent.ProtoReflect.Descriptor instead.
func (*UpgradeInfoEvent) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{149}
}

func (x *UpgradeInfoEvent) GetResourceType() UpgradeResourceType {
	if x != nil {
		return x.ResourceType
	}
	return UpgradeResourceType_UPGRADE_RESOURCE_TYPE_UNSPECIFIED
}

func (x *UpgradeInfoEvent) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *UpgradeInfoEvent) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *UpgradeInfoEvent) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *UpgradeInfoEvent) GetCurrentVersion() string {
	if x != nil {
		return x.CurrentVersion
	}
	return ""
}

func (x *UpgradeInfoEvent) GetTargetVersion() string {
	if x != nil {
		return x.TargetVersion
	}
	return ""
}

func (x *UpgradeInfoEvent) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *UpgradeInfoEvent) GetState() UpgradeInfoEvent_State {
	if x != nil {
		return x.State
	}
	return UpgradeInfoEvent_STATE_UNSPECIFIED
}

func (x *UpgradeInfoEvent) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// UpgradeAvailableEvent is a notification sent to customers when a new
// available version is released.
type UpgradeAvailableEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The release version available for upgrade.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The resource type of the release version.
	ResourceType UpgradeResourceType `protobuf:"varint,2,opt,name=resource_type,json=resourceType,proto3,enum=google.container.v1.UpgradeResourceType" json:"resource_type,omitempty"`
	// The release channel of the version. If empty, it means a non-channel
	// release.
	ReleaseChannel *ReleaseChannel `protobuf:"bytes,3,opt,name=release_channel,json=releaseChannel,proto3" json:"release_channel,omitempty"`
	// Optional relative path to the resource. For example, the relative path of
	// the node pool.
	Resource string `protobuf:"bytes,4,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *UpgradeAvailableEvent) Reset() {
	*x = UpgradeAvailableEvent{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[150]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeAvailableEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeAvailableEvent) ProtoMessage() {}

func (x *UpgradeAvailableEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[150]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeAvailableEvent.ProtoReflect.Descriptor instead.
func (*UpgradeAvailableEvent) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{150}
}

func (x *UpgradeAvailableEvent) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *UpgradeAvailableEvent) GetResourceType() UpgradeResourceType {
	if x != nil {
		return x.ResourceType
	}
	return UpgradeResourceType_UPGRADE_RESOURCE_TYPE_UNSPECIFIED
}

func (x *UpgradeAvailableEvent) GetReleaseChannel() *ReleaseChannel {
	if x != nil {
		return x.ReleaseChannel
	}
	return nil
}

func (x *UpgradeAvailableEvent) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

// SecurityBulletinEvent is a notification sent to customers when a security
// bulletin has been posted that they are vulnerable to.
type SecurityBulletinEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource type (node/control plane) that has the vulnerability. Multiple
	// notifications (1 notification per resource type) will be sent for a
	// vulnerability that affects > 1 resource type.
	ResourceTypeAffected string `protobuf:"bytes,1,opt,name=resource_type_affected,json=resourceTypeAffected,proto3" json:"resource_type_affected,omitempty"`
	// The ID of the bulletin corresponding to the vulnerability.
	BulletinId string `protobuf:"bytes,2,opt,name=bulletin_id,json=bulletinId,proto3" json:"bulletin_id,omitempty"`
	// The CVEs associated with this bulletin.
	CveIds []string `protobuf:"bytes,3,rep,name=cve_ids,json=cveIds,proto3" json:"cve_ids,omitempty"`
	// The severity of this bulletin as it relates to GKE.
	Severity string `protobuf:"bytes,4,opt,name=severity,proto3" json:"severity,omitempty"`
	// The URI link to the bulletin on the website for more information.
	BulletinUri string `protobuf:"bytes,5,opt,name=bulletin_uri,json=bulletinUri,proto3" json:"bulletin_uri,omitempty"`
	// A brief description of the bulletin. See the bulletin pointed to by the
	// bulletin_uri field for an expanded description.
	BriefDescription string `protobuf:"bytes,6,opt,name=brief_description,json=briefDescription,proto3" json:"brief_description,omitempty"`
	// The GKE minor versions affected by this vulnerability.
	AffectedSupportedMinors []string `protobuf:"bytes,7,rep,name=affected_supported_minors,json=affectedSupportedMinors,proto3" json:"affected_supported_minors,omitempty"`
	// The GKE versions where this vulnerability is patched.
	PatchedVersions []string `protobuf:"bytes,8,rep,name=patched_versions,json=patchedVersions,proto3" json:"patched_versions,omitempty"`
	// This represents a version selected from the patched_versions field that
	// the cluster receiving this notification should most likely want to upgrade
	// to based on its current version. Note that if this notification is being
	// received by a given cluster, it means that this version is currently
	// available as an upgrade target in that cluster's location.
	SuggestedUpgradeTarget string `protobuf:"bytes,9,opt,name=suggested_upgrade_target,json=suggestedUpgradeTarget,proto3" json:"suggested_upgrade_target,omitempty"`
	// If this field is specified, it means there are manual steps that the user
	// must take to make their clusters safe.
	ManualStepsRequired bool `protobuf:"varint,10,opt,name=manual_steps_required,json=manualStepsRequired,proto3" json:"manual_steps_required,omitempty"`
}

func (x *SecurityBulletinEvent) Reset() {
	*x = SecurityBulletinEvent{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[151]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecurityBulletinEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityBulletinEvent) ProtoMessage() {}

func (x *SecurityBulletinEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[151]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityBulletinEvent.ProtoReflect.Descriptor instead.
func (*SecurityBulletinEvent) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{151}
}

func (x *SecurityBulletinEvent) GetResourceTypeAffected() string {
	if x != nil {
		return x.ResourceTypeAffected
	}
	return ""
}

func (x *SecurityBulletinEvent) GetBulletinId() string {
	if x != nil {
		return x.BulletinId
	}
	return ""
}

func (x *SecurityBulletinEvent) GetCveIds() []string {
	if x != nil {
		return x.CveIds
	}
	return nil
}

func (x *SecurityBulletinEvent) GetSeverity() string {
	if x != nil {
		return x.Severity
	}
	return ""
}

func (x *SecurityBulletinEvent) GetBulletinUri() string {
	if x != nil {
		return x.BulletinUri
	}
	return ""
}

func (x *SecurityBulletinEvent) GetBriefDescription() string {
	if x != nil {
		return x.BriefDescription
	}
	return ""
}

func (x *SecurityBulletinEvent) GetAffectedSupportedMinors() []string {
	if x != nil {
		return x.AffectedSupportedMinors
	}
	return nil
}

func (x *SecurityBulletinEvent) GetPatchedVersions() []string {
	if x != nil {
		return x.PatchedVersions
	}
	return nil
}

func (x *SecurityBulletinEvent) GetSuggestedUpgradeTarget() string {
	if x != nil {
		return x.SuggestedUpgradeTarget
	}
	return ""
}

func (x *SecurityBulletinEvent) GetManualStepsRequired() bool {
	if x != nil {
		return x.ManualStepsRequired
	}
	return false
}

// Autopilot is the configuration for Autopilot settings on the cluster.
type Autopilot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable Autopilot
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Workload policy configuration for Autopilot.
	WorkloadPolicyConfig *WorkloadPolicyConfig `protobuf:"bytes,2,opt,name=workload_policy_config,json=workloadPolicyConfig,proto3" json:"workload_policy_config,omitempty"`
}

func (x *Autopilot) Reset() {
	*x = Autopilot{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[152]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Autopilot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Autopilot) ProtoMessage() {}

func (x *Autopilot) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[152]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Autopilot.ProtoReflect.Descriptor instead.
func (*Autopilot) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{152}
}

func (x *Autopilot) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *Autopilot) GetWorkloadPolicyConfig() *WorkloadPolicyConfig {
	if x != nil {
		return x.WorkloadPolicyConfig
	}
	return nil
}

// WorkloadPolicyConfig is the configuration of workload policy for autopilot
// clusters.
type WorkloadPolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, workloads can use NET_ADMIN capability.
	AllowNetAdmin *bool `protobuf:"varint,1,opt,name=allow_net_admin,json=allowNetAdmin,proto3,oneof" json:"allow_net_admin,omitempty"`
}

func (x *WorkloadPolicyConfig) Reset() {
	*x = WorkloadPolicyConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[153]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkloadPolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadPolicyConfig) ProtoMessage() {}

func (x *WorkloadPolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[153]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadPolicyConfig.ProtoReflect.Descriptor instead.
func (*WorkloadPolicyConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{153}
}

func (x *WorkloadPolicyConfig) GetAllowNetAdmin() bool {
	if x != nil && x.AllowNetAdmin != nil {
		return *x.AllowNetAdmin
	}
	return false
}

// LoggingConfig is cluster logging configuration.
type LoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Logging components configuration
	ComponentConfig *LoggingComponentConfig `protobuf:"bytes,1,opt,name=component_config,json=componentConfig,proto3" json:"component_config,omitempty"`
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[154]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[154]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{154}
}

func (x *LoggingConfig) GetComponentConfig() *LoggingComponentConfig {
	if x != nil {
		return x.ComponentConfig
	}
	return nil
}

// LoggingComponentConfig is cluster logging component configuration.
type LoggingComponentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Select components to collect logs. An empty set would disable all logging.
	EnableComponents []LoggingComponentConfig_Component `protobuf:"varint,1,rep,packed,name=enable_components,json=enableComponents,proto3,enum=google.container.v1.LoggingComponentConfig_Component" json:"enable_components,omitempty"`
}

func (x *LoggingComponentConfig) Reset() {
	*x = LoggingComponentConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[155]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingComponentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingComponentConfig) ProtoMessage() {}

func (x *LoggingComponentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[155]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingComponentConfig.ProtoReflect.Descriptor instead.
func (*LoggingComponentConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{155}
}

func (x *LoggingComponentConfig) GetEnableComponents() []LoggingComponentConfig_Component {
	if x != nil {
		return x.EnableComponents
	}
	return nil
}

// RayClusterLoggingConfig specifies configuration of Ray logging.
type RayClusterLoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable log collection for Ray clusters.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *RayClusterLoggingConfig) Reset() {
	*x = RayClusterLoggingConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[156]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RayClusterLoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RayClusterLoggingConfig) ProtoMessage() {}

func (x *RayClusterLoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[156]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RayClusterLoggingConfig.ProtoReflect.Descriptor instead.
func (*RayClusterLoggingConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{156}
}

func (x *RayClusterLoggingConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// MonitoringConfig is cluster monitoring configuration.
type MonitoringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Monitoring components configuration
	ComponentConfig *MonitoringComponentConfig `protobuf:"bytes,1,opt,name=component_config,json=componentConfig,proto3" json:"component_config,omitempty"`
	// Enable Google Cloud Managed Service for Prometheus
	// in the cluster.
	ManagedPrometheusConfig *ManagedPrometheusConfig `protobuf:"bytes,2,opt,name=managed_prometheus_config,json=managedPrometheusConfig,proto3" json:"managed_prometheus_config,omitempty"`
	// Configuration of Advanced Datapath Observability features.
	AdvancedDatapathObservabilityConfig *AdvancedDatapathObservabilityConfig `protobuf:"bytes,3,opt,name=advanced_datapath_observability_config,json=advancedDatapathObservabilityConfig,proto3" json:"advanced_datapath_observability_config,omitempty"`
}

func (x *MonitoringConfig) Reset() {
	*x = MonitoringConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[157]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MonitoringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitoringConfig) ProtoMessage() {}

func (x *MonitoringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[157]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitoringConfig.ProtoReflect.Descriptor instead.
func (*MonitoringConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{157}
}

func (x *MonitoringConfig) GetComponentConfig() *MonitoringComponentConfig {
	if x != nil {
		return x.ComponentConfig
	}
	return nil
}

func (x *MonitoringConfig) GetManagedPrometheusConfig() *ManagedPrometheusConfig {
	if x != nil {
		return x.ManagedPrometheusConfig
	}
	return nil
}

func (x *MonitoringConfig) GetAdvancedDatapathObservabilityConfig() *AdvancedDatapathObservabilityConfig {
	if x != nil {
		return x.AdvancedDatapathObservabilityConfig
	}
	return nil
}

// AdvancedDatapathObservabilityConfig specifies configuration of observability
// features of advanced datapath.
type AdvancedDatapathObservabilityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Expose flow metrics on nodes
	EnableMetrics bool `protobuf:"varint,1,opt,name=enable_metrics,json=enableMetrics,proto3" json:"enable_metrics,omitempty"`
	// Method used to make Relay available
	RelayMode AdvancedDatapathObservabilityConfig_RelayMode `protobuf:"varint,2,opt,name=relay_mode,json=relayMode,proto3,enum=google.container.v1.AdvancedDatapathObservabilityConfig_RelayMode" json:"relay_mode,omitempty"`
	// Enable Relay component
	EnableRelay *bool `protobuf:"varint,3,opt,name=enable_relay,json=enableRelay,proto3,oneof" json:"enable_relay,omitempty"`
}

func (x *AdvancedDatapathObservabilityConfig) Reset() {
	*x = AdvancedDatapathObservabilityConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[158]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedDatapathObservabilityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedDatapathObservabilityConfig) ProtoMessage() {}

func (x *AdvancedDatapathObservabilityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[158]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedDatapathObservabilityConfig.ProtoReflect.Descriptor instead.
func (*AdvancedDatapathObservabilityConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{158}
}

func (x *AdvancedDatapathObservabilityConfig) GetEnableMetrics() bool {
	if x != nil {
		return x.EnableMetrics
	}
	return false
}

func (x *AdvancedDatapathObservabilityConfig) GetRelayMode() AdvancedDatapathObservabilityConfig_RelayMode {
	if x != nil {
		return x.RelayMode
	}
	return AdvancedDatapathObservabilityConfig_RELAY_MODE_UNSPECIFIED
}

func (x *AdvancedDatapathObservabilityConfig) GetEnableRelay() bool {
	if x != nil && x.EnableRelay != nil {
		return *x.EnableRelay
	}
	return false
}

// RayClusterMonitoringConfig specifies monitoring configuration for Ray
// clusters.
type RayClusterMonitoringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable metrics collection for Ray clusters.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *RayClusterMonitoringConfig) Reset() {
	*x = RayClusterMonitoringConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[159]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RayClusterMonitoringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RayClusterMonitoringConfig) ProtoMessage() {}

func (x *RayClusterMonitoringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[159]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RayClusterMonitoringConfig.ProtoReflect.Descriptor instead.
func (*RayClusterMonitoringConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{159}
}

func (x *RayClusterMonitoringConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// NodePoolLoggingConfig specifies logging configuration for nodepools.
type NodePoolLoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Logging variant configuration.
	VariantConfig *LoggingVariantConfig `protobuf:"bytes,1,opt,name=variant_config,json=variantConfig,proto3" json:"variant_config,omitempty"`
}

func (x *NodePoolLoggingConfig) Reset() {
	*x = NodePoolLoggingConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[160]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePoolLoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePoolLoggingConfig) ProtoMessage() {}

func (x *NodePoolLoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[160]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePoolLoggingConfig.ProtoReflect.Descriptor instead.
func (*NodePoolLoggingConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{160}
}

func (x *NodePoolLoggingConfig) GetVariantConfig() *LoggingVariantConfig {
	if x != nil {
		return x.VariantConfig
	}
	return nil
}

// LoggingVariantConfig specifies the behaviour of the logging component.
type LoggingVariantConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Logging variant deployed on nodes.
	Variant LoggingVariantConfig_Variant `protobuf:"varint,1,opt,name=variant,proto3,enum=google.container.v1.LoggingVariantConfig_Variant" json:"variant,omitempty"`
}

func (x *LoggingVariantConfig) Reset() {
	*x = LoggingVariantConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[161]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingVariantConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingVariantConfig) ProtoMessage() {}

func (x *LoggingVariantConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[161]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingVariantConfig.ProtoReflect.Descriptor instead.
func (*LoggingVariantConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{161}
}

func (x *LoggingVariantConfig) GetVariant() LoggingVariantConfig_Variant {
	if x != nil {
		return x.Variant
	}
	return LoggingVariantConfig_VARIANT_UNSPECIFIED
}

// MonitoringComponentConfig is cluster monitoring component configuration.
type MonitoringComponentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Select components to collect metrics. An empty set would disable all
	// monitoring.
	EnableComponents []MonitoringComponentConfig_Component `protobuf:"varint,1,rep,packed,name=enable_components,json=enableComponents,proto3,enum=google.container.v1.MonitoringComponentConfig_Component" json:"enable_components,omitempty"`
}

func (x *MonitoringComponentConfig) Reset() {
	*x = MonitoringComponentConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[162]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MonitoringComponentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitoringComponentConfig) ProtoMessage() {}

func (x *MonitoringComponentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[162]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitoringComponentConfig.ProtoReflect.Descriptor instead.
func (*MonitoringComponentConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{162}
}

func (x *MonitoringComponentConfig) GetEnableComponents() []MonitoringComponentConfig_Component {
	if x != nil {
		return x.EnableComponents
	}
	return nil
}

// ManagedPrometheusConfig defines the configuration for
// Google Cloud Managed Service for Prometheus.
type ManagedPrometheusConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable Managed Collection.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ManagedPrometheusConfig) Reset() {
	*x = ManagedPrometheusConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[163]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ManagedPrometheusConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedPrometheusConfig) ProtoMessage() {}

func (x *ManagedPrometheusConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[163]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedPrometheusConfig.ProtoReflect.Descriptor instead.
func (*ManagedPrometheusConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{163}
}

func (x *ManagedPrometheusConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Fleet is the fleet configuration for the cluster.
type Fleet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Fleet host project(project ID or project number) where this cluster
	// will be registered to. This field cannot be changed after the cluster has
	// been registered.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Output only. The full resource name of the registered fleet membership of
	// the cluster, in the format
	// `//gkehub.googleapis.com/projects/*/locations/*/memberships/*`.
	Membership string `protobuf:"bytes,2,opt,name=membership,proto3" json:"membership,omitempty"`
	// Output only. Whether the cluster has been registered through the fleet
	// API.
	PreRegistered bool `protobuf:"varint,3,opt,name=pre_registered,json=preRegistered,proto3" json:"pre_registered,omitempty"`
}

func (x *Fleet) Reset() {
	*x = Fleet{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[164]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Fleet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fleet) ProtoMessage() {}

func (x *Fleet) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[164]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Fleet.ProtoReflect.Descriptor instead.
func (*Fleet) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{164}
}

func (x *Fleet) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *Fleet) GetMembership() string {
	if x != nil {
		return x.Membership
	}
	return ""
}

func (x *Fleet) GetPreRegistered() bool {
	if x != nil {
		return x.PreRegistered
	}
	return false
}

// Configuration for all of the cluster's control plane endpoints.
type ControlPlaneEndpointsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DNS endpoint configuration.
	DnsEndpointConfig *ControlPlaneEndpointsConfig_DNSEndpointConfig `protobuf:"bytes,1,opt,name=dns_endpoint_config,json=dnsEndpointConfig,proto3" json:"dns_endpoint_config,omitempty"`
	// IP endpoints configuration.
	IpEndpointsConfig *ControlPlaneEndpointsConfig_IPEndpointsConfig `protobuf:"bytes,3,opt,name=ip_endpoints_config,json=ipEndpointsConfig,proto3" json:"ip_endpoints_config,omitempty"`
}

func (x *ControlPlaneEndpointsConfig) Reset() {
	*x = ControlPlaneEndpointsConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[165]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ControlPlaneEndpointsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ControlPlaneEndpointsConfig) ProtoMessage() {}

func (x *ControlPlaneEndpointsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[165]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ControlPlaneEndpointsConfig.ProtoReflect.Descriptor instead.
func (*ControlPlaneEndpointsConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{165}
}

func (x *ControlPlaneEndpointsConfig) GetDnsEndpointConfig() *ControlPlaneEndpointsConfig_DNSEndpointConfig {
	if x != nil {
		return x.DnsEndpointConfig
	}
	return nil
}

func (x *ControlPlaneEndpointsConfig) GetIpEndpointsConfig() *ControlPlaneEndpointsConfig_IPEndpointsConfig {
	if x != nil {
		return x.IpEndpointsConfig
	}
	return nil
}

// LocalNvmeSsdBlockConfig contains configuration for using raw-block local
// NVMe SSDs
type LocalNvmeSsdBlockConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of local NVMe SSDs to use.  The limit for this value is dependent
	// upon the maximum number of disk available on a machine per zone. See:
	// https://cloud.google.com/compute/docs/disks/local-ssd
	// for more information.
	//
	// A zero (or unset) value has different meanings depending on machine type
	// being used:
	// 1. For pre-Gen3 machines, which support flexible numbers of local ssds,
	// zero (or unset) means to disable using local SSDs as ephemeral storage.
	// 2. For Gen3 machines which dictate a specific number of local ssds, zero
	// (or unset) means to use the default number of local ssds that goes with
	// that machine type. For example, for a c3-standard-8-lssd machine, 2 local
	// ssds would be provisioned. For c3-standard-8 (which doesn't support local
	// ssds), 0 will be provisioned. See
	// https://cloud.google.com/compute/docs/disks/local-ssd#choose_number_local_ssds
	// for more info.
	LocalSsdCount int32 `protobuf:"varint,1,opt,name=local_ssd_count,json=localSsdCount,proto3" json:"local_ssd_count,omitempty"`
}

func (x *LocalNvmeSsdBlockConfig) Reset() {
	*x = LocalNvmeSsdBlockConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[166]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalNvmeSsdBlockConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalNvmeSsdBlockConfig) ProtoMessage() {}

func (x *LocalNvmeSsdBlockConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[166]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalNvmeSsdBlockConfig.ProtoReflect.Descriptor instead.
func (*LocalNvmeSsdBlockConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{166}
}

func (x *LocalNvmeSsdBlockConfig) GetLocalSsdCount() int32 {
	if x != nil {
		return x.LocalSsdCount
	}
	return 0
}

// EphemeralStorageLocalSsdConfig contains configuration for the node ephemeral
// storage using Local SSDs.
type EphemeralStorageLocalSsdConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of local SSDs to use to back ephemeral storage. Uses NVMe
	// interfaces.
	//
	// A zero (or unset) value has different meanings depending on machine type
	// being used:
	// 1. For pre-Gen3 machines, which support flexible numbers of local ssds,
	// zero (or unset) means to disable using local SSDs as ephemeral storage. The
	// limit for this value is dependent upon the maximum number of disk
	// available on a machine per zone. See:
	// https://cloud.google.com/compute/docs/disks/local-ssd
	// for more information.
	// 2. For Gen3 machines which dictate a specific number of local ssds, zero
	// (or unset) means to use the default number of local ssds that goes with
	// that machine type. For example, for a c3-standard-8-lssd machine, 2 local
	// ssds would be provisioned. For c3-standard-8 (which doesn't support local
	// ssds), 0 will be provisioned. See
	// https://cloud.google.com/compute/docs/disks/local-ssd#choose_number_local_ssds
	// for more info.
	LocalSsdCount int32 `protobuf:"varint,1,opt,name=local_ssd_count,json=localSsdCount,proto3" json:"local_ssd_count,omitempty"`
}

func (x *EphemeralStorageLocalSsdConfig) Reset() {
	*x = EphemeralStorageLocalSsdConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[167]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EphemeralStorageLocalSsdConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EphemeralStorageLocalSsdConfig) ProtoMessage() {}

func (x *EphemeralStorageLocalSsdConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[167]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EphemeralStorageLocalSsdConfig.ProtoReflect.Descriptor instead.
func (*EphemeralStorageLocalSsdConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{167}
}

func (x *EphemeralStorageLocalSsdConfig) GetLocalSsdCount() int32 {
	if x != nil {
		return x.LocalSsdCount
	}
	return 0
}

// A map of resource manager tag keys and values to be attached to the nodes
// for managing Compute Engine firewalls using Network Firewall Policies.
// Tags must be according to specifications in
// https://cloud.google.com/vpc/docs/tags-firewalls-overview#specifications.
// A maximum of 5 tag key-value pairs can be specified.
// Existing tags will be replaced with new values.
type ResourceManagerTags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TagKeyValue must be in one of the following formats ([KEY]=[VALUE])
	// 1. `tagKeys/{tag_key_id}=tagValues/{tag_value_id}`
	// 2. `{org_id}/{tag_key_name}={tag_value_name}`
	// 3. `{project_id}/{tag_key_name}={tag_value_name}`
	Tags map[string]string `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ResourceManagerTags) Reset() {
	*x = ResourceManagerTags{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[168]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceManagerTags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceManagerTags) ProtoMessage() {}

func (x *ResourceManagerTags) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[168]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceManagerTags.ProtoReflect.Descriptor instead.
func (*ResourceManagerTags) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{168}
}

func (x *ResourceManagerTags) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// EnterpriseConfig is the cluster enterprise configuration.
type EnterpriseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. cluster_tier indicates the effective tier of the cluster.
	ClusterTier EnterpriseConfig_ClusterTier `protobuf:"varint,1,opt,name=cluster_tier,json=clusterTier,proto3,enum=google.container.v1.EnterpriseConfig_ClusterTier" json:"cluster_tier,omitempty"`
	// desired_tier specifies the desired tier of the cluster.
	DesiredTier EnterpriseConfig_ClusterTier `protobuf:"varint,2,opt,name=desired_tier,json=desiredTier,proto3,enum=google.container.v1.EnterpriseConfig_ClusterTier" json:"desired_tier,omitempty"`
}

func (x *EnterpriseConfig) Reset() {
	*x = EnterpriseConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[169]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnterpriseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnterpriseConfig) ProtoMessage() {}

func (x *EnterpriseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[169]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnterpriseConfig.ProtoReflect.Descriptor instead.
func (*EnterpriseConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{169}
}

func (x *EnterpriseConfig) GetClusterTier() EnterpriseConfig_ClusterTier {
	if x != nil {
		return x.ClusterTier
	}
	return EnterpriseConfig_CLUSTER_TIER_UNSPECIFIED
}

func (x *EnterpriseConfig) GetDesiredTier() EnterpriseConfig_ClusterTier {
	if x != nil {
		return x.DesiredTier
	}
	return EnterpriseConfig_CLUSTER_TIER_UNSPECIFIED
}

// SecretManagerConfig is config for secret manager enablement.
type SecretManagerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable/Disable Secret Manager Config.
	Enabled *bool `protobuf:"varint,1,opt,name=enabled,proto3,oneof" json:"enabled,omitempty"`
}

func (x *SecretManagerConfig) Reset() {
	*x = SecretManagerConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[170]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecretManagerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretManagerConfig) ProtoMessage() {}

func (x *SecretManagerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[170]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretManagerConfig.ProtoReflect.Descriptor instead.
func (*SecretManagerConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{170}
}

func (x *SecretManagerConfig) GetEnabled() bool {
	if x != nil && x.Enabled != nil {
		return *x.Enabled
	}
	return false
}

// SecondaryBootDisk represents a persistent disk attached to a node
// with special configurations based on its mode.
type SecondaryBootDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Disk mode (container image cache, etc.)
	Mode SecondaryBootDisk_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.container.v1.SecondaryBootDisk_Mode" json:"mode,omitempty"`
	// Fully-qualified resource ID for an existing disk image.
	DiskImage string `protobuf:"bytes,2,opt,name=disk_image,json=diskImage,proto3" json:"disk_image,omitempty"`
}

func (x *SecondaryBootDisk) Reset() {
	*x = SecondaryBootDisk{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[171]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecondaryBootDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecondaryBootDisk) ProtoMessage() {}

func (x *SecondaryBootDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[171]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecondaryBootDisk.ProtoReflect.Descriptor instead.
func (*SecondaryBootDisk) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{171}
}

func (x *SecondaryBootDisk) GetMode() SecondaryBootDisk_Mode {
	if x != nil {
		return x.Mode
	}
	return SecondaryBootDisk_MODE_UNSPECIFIED
}

func (x *SecondaryBootDisk) GetDiskImage() string {
	if x != nil {
		return x.DiskImage
	}
	return ""
}

// SecondaryBootDiskUpdateStrategy is a placeholder which will be extended
// in the future to define different options for updating secondary boot disks.
type SecondaryBootDiskUpdateStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SecondaryBootDiskUpdateStrategy) Reset() {
	*x = SecondaryBootDiskUpdateStrategy{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[172]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SecondaryBootDiskUpdateStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecondaryBootDiskUpdateStrategy) ProtoMessage() {}

func (x *SecondaryBootDiskUpdateStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[172]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecondaryBootDiskUpdateStrategy.ProtoReflect.Descriptor instead.
func (*SecondaryBootDiskUpdateStrategy) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{172}
}

// Hugepages amount in both 2m and 1g size
type LinuxNodeConfig_HugepagesConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Amount of 2M hugepages
	HugepageSize2M *int32 `protobuf:"varint,1,opt,name=hugepage_size2m,json=hugepageSize2m,proto3,oneof" json:"hugepage_size2m,omitempty"`
	// Optional. Amount of 1G hugepages
	HugepageSize1G *int32 `protobuf:"varint,2,opt,name=hugepage_size1g,json=hugepageSize1g,proto3,oneof" json:"hugepage_size1g,omitempty"`
}

func (x *LinuxNodeConfig_HugepagesConfig) Reset() {
	*x = LinuxNodeConfig_HugepagesConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[173]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinuxNodeConfig_HugepagesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinuxNodeConfig_HugepagesConfig) ProtoMessage() {}

func (x *LinuxNodeConfig_HugepagesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[173]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinuxNodeConfig_HugepagesConfig.ProtoReflect.Descriptor instead.
func (*LinuxNodeConfig_HugepagesConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *LinuxNodeConfig_HugepagesConfig) GetHugepageSize2M() int32 {
	if x != nil && x.HugepageSize2M != nil {
		return *x.HugepageSize2M
	}
	return 0
}

func (x *LinuxNodeConfig_HugepagesConfig) GetHugepageSize1G() int32 {
	if x != nil && x.HugepageSize1G != nil {
		return *x.HugepageSize1G
	}
	return 0
}

// Configuration of all network bandwidth tiers
type NodeNetworkConfig_NetworkPerformanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the total network bandwidth tier for the NodePool.
	TotalEgressBandwidthTier *NodeNetworkConfig_NetworkPerformanceConfig_Tier `protobuf:"varint,1,opt,name=total_egress_bandwidth_tier,json=totalEgressBandwidthTier,proto3,enum=google.container.v1.NodeNetworkConfig_NetworkPerformanceConfig_Tier,oneof" json:"total_egress_bandwidth_tier,omitempty"`
}

func (x *NodeNetworkConfig_NetworkPerformanceConfig) Reset() {
	*x = NodeNetworkConfig_NetworkPerformanceConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[178]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeNetworkConfig_NetworkPerformanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeNetworkConfig_NetworkPerformanceConfig) ProtoMessage() {}

func (x *NodeNetworkConfig_NetworkPerformanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[178]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeNetworkConfig_NetworkPerformanceConfig.ProtoReflect.Descriptor instead.
func (*NodeNetworkConfig_NetworkPerformanceConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *NodeNetworkConfig_NetworkPerformanceConfig) GetTotalEgressBandwidthTier() NodeNetworkConfig_NetworkPerformanceConfig_Tier {
	if x != nil && x.TotalEgressBandwidthTier != nil {
		return *x.TotalEgressBandwidthTier
	}
	return NodeNetworkConfig_NetworkPerformanceConfig_TIER_UNSPECIFIED
}

// Specifies the NodeAffinity key, values, and affinity operator according to
// [shared sole tenant node group
// affinities](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes#node_affinity_and_anti-affinity).
type SoleTenantConfig_NodeAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key for NodeAffinity.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Operator for NodeAffinity.
	Operator SoleTenantConfig_NodeAffinity_Operator `protobuf:"varint,2,opt,name=operator,proto3,enum=google.container.v1.SoleTenantConfig_NodeAffinity_Operator" json:"operator,omitempty"`
	// Values for NodeAffinity.
	Values []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *SoleTenantConfig_NodeAffinity) Reset() {
	*x = SoleTenantConfig_NodeAffinity{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[179]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SoleTenantConfig_NodeAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SoleTenantConfig_NodeAffinity) ProtoMessage() {}

func (x *SoleTenantConfig_NodeAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[179]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SoleTenantConfig_NodeAffinity.ProtoReflect.Descriptor instead.
func (*SoleTenantConfig_NodeAffinity) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{12, 0}
}

func (x *SoleTenantConfig_NodeAffinity) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SoleTenantConfig_NodeAffinity) GetOperator() SoleTenantConfig_NodeAffinity_Operator {
	if x != nil {
		return x.Operator
	}
	return SoleTenantConfig_NodeAffinity_OPERATOR_UNSPECIFIED
}

func (x *SoleTenantConfig_NodeAffinity) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// PrivateRegistryAccessConfig contains access configuration for
// private container registries.
type ContainerdConfig_PrivateRegistryAccessConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Private registry access is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Private registry access configuration.
	CertificateAuthorityDomainConfig []*ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig `protobuf:"bytes,2,rep,name=certificate_authority_domain_config,json=certificateAuthorityDomainConfig,proto3" json:"certificate_authority_domain_config,omitempty"`
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig) Reset() {
	*x = ContainerdConfig_PrivateRegistryAccessConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[180]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerdConfig_PrivateRegistryAccessConfig) ProtoMessage() {}

func (x *ContainerdConfig_PrivateRegistryAccessConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[180]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerdConfig_PrivateRegistryAccessConfig.ProtoReflect.Descriptor instead.
func (*ContainerdConfig_PrivateRegistryAccessConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{13, 0}
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig) GetCertificateAuthorityDomainConfig() []*ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig {
	if x != nil {
		return x.CertificateAuthorityDomainConfig
	}
	return nil
}

// CertificateAuthorityDomainConfig configures one or more fully qualified
// domain names (FQDN) to a specific certificate.
type ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of fully qualified domain names (FQDN).
	// Specifying port is supported.
	// Wilcards are NOT supported.
	// Examples:
	// - my.customdomain.com
	// - 10.0.1.2:5000
	Fqdns []string `protobuf:"bytes,1,rep,name=fqdns,proto3" json:"fqdns,omitempty"`
	// Certificate access config. The following are supported:
	// - GCPSecretManagerCertificateConfig
	//
	// Types that are assignable to CertificateConfig:
	//
	//	*ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GcpSecretManagerCertificateConfig
	CertificateConfig isContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_CertificateConfig `protobuf_oneof:"certificate_config"`
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig) Reset() {
	*x = ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[181]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig) ProtoMessage() {
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[181]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig.ProtoReflect.Descriptor instead.
func (*ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{13, 0, 0}
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig) GetFqdns() []string {
	if x != nil {
		return x.Fqdns
	}
	return nil
}

func (m *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig) GetCertificateConfig() isContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_CertificateConfig {
	if m != nil {
		return m.CertificateConfig
	}
	return nil
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig) GetGcpSecretManagerCertificateConfig() *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig {
	if x, ok := x.GetCertificateConfig().(*ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GcpSecretManagerCertificateConfig); ok {
		return x.GcpSecretManagerCertificateConfig
	}
	return nil
}

type isContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_CertificateConfig interface {
	isContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_CertificateConfig()
}

type ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GcpSecretManagerCertificateConfig struct {
	// Google Secret Manager (GCP) certificate configuration.
	GcpSecretManagerCertificateConfig *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig `protobuf:"bytes,2,opt,name=gcp_secret_manager_certificate_config,json=gcpSecretManagerCertificateConfig,proto3,oneof"`
}

func (*ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GcpSecretManagerCertificateConfig) isContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_CertificateConfig() {
}

// GCPSecretManagerCertificateConfig configures a secret from
// [Google Secret Manager](https://cloud.google.com/secret-manager).
type ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Secret URI, in the form
	// "projects/$PROJECT_ID/secrets/$SECRET_NAME/versions/$VERSION".
	// Version can be fixed (e.g. "2") or "latest"
	SecretUri string `protobuf:"bytes,1,opt,name=secret_uri,json=secretUri,proto3" json:"secret_uri,omitempty"`
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig) Reset() {
	*x = ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[182]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig) ProtoMessage() {
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[182]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig.ProtoReflect.Descriptor instead.
func (*ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{13, 0, 0, 0}
}

func (x *ContainerdConfig_PrivateRegistryAccessConfig_CertificateAuthorityDomainConfig_GCPSecretManagerCertificateConfig) GetSecretUri() string {
	if x != nil {
		return x.SecretUri
	}
	return ""
}

// CidrBlock contains an optional name and one CIDR block.
type MasterAuthorizedNetworksConfig_CidrBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// display_name is an optional field for users to identify CIDR blocks.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// cidr_block must be specified in CIDR notation.
	CidrBlock string `protobuf:"bytes,2,opt,name=cidr_block,json=cidrBlock,proto3" json:"cidr_block,omitempty"`
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) Reset() {
	*x = MasterAuthorizedNetworksConfig_CidrBlock{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[185]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuthorizedNetworksConfig_CidrBlock) ProtoMessage() {}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[185]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuthorizedNetworksConfig_CidrBlock.ProtoReflect.Descriptor instead.
func (*MasterAuthorizedNetworksConfig_CidrBlock) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{39, 0}
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) GetCidrBlock() string {
	if x != nil {
		return x.CidrBlock
	}
	return ""
}

// Defines the details of a compliance standard.
type CompliancePostureConfig_ComplianceStandard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the compliance standard.
	Standard *string `protobuf:"bytes,1,opt,name=standard,proto3,oneof" json:"standard,omitempty"`
}

func (x *CompliancePostureConfig_ComplianceStandard) Reset() {
	*x = CompliancePostureConfig_ComplianceStandard{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[187]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompliancePostureConfig_ComplianceStandard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompliancePostureConfig_ComplianceStandard) ProtoMessage() {}

func (x *CompliancePostureConfig_ComplianceStandard) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[187]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompliancePostureConfig_ComplianceStandard.ProtoReflect.Descriptor instead.
func (*CompliancePostureConfig_ComplianceStandard) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{48, 0}
}

func (x *CompliancePostureConfig_ComplianceStandard) GetStandard() string {
	if x != nil && x.Standard != nil {
		return *x.Standard
	}
	return ""
}

// Progress metric is (string, int|float|string) pair.
type OperationProgress_Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Metric name, e.g., "nodes total", "percent done".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Strictly one of the values is required.
	//
	// Types that are assignable to Value:
	//
	//	*OperationProgress_Metric_IntValue
	//	*OperationProgress_Metric_DoubleValue
	//	*OperationProgress_Metric_StringValue
	Value isOperationProgress_Metric_Value `protobuf_oneof:"value"`
}

func (x *OperationProgress_Metric) Reset() {
	*x = OperationProgress_Metric{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[188]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationProgress_Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationProgress_Metric) ProtoMessage() {}

func (x *OperationProgress_Metric) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[188]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationProgress_Metric.ProtoReflect.Descriptor instead.
func (*OperationProgress_Metric) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{59, 0}
}

func (x *OperationProgress_Metric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *OperationProgress_Metric) GetValue() isOperationProgress_Metric_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *OperationProgress_Metric) GetIntValue() int64 {
	if x, ok := x.GetValue().(*OperationProgress_Metric_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *OperationProgress_Metric) GetDoubleValue() float64 {
	if x, ok := x.GetValue().(*OperationProgress_Metric_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (x *OperationProgress_Metric) GetStringValue() string {
	if x, ok := x.GetValue().(*OperationProgress_Metric_StringValue); ok {
		return x.StringValue
	}
	return ""
}

type isOperationProgress_Metric_Value interface {
	isOperationProgress_Metric_Value()
}

type OperationProgress_Metric_IntValue struct {
	// For metrics with integer value.
	IntValue int64 `protobuf:"varint,2,opt,name=int_value,json=intValue,proto3,oneof"`
}

type OperationProgress_Metric_DoubleValue struct {
	// For metrics with floating point value.
	DoubleValue float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type OperationProgress_Metric_StringValue struct {
	// For metrics with custom values (ratios, visual progress, etc.).
	StringValue string `protobuf:"bytes,4,opt,name=string_value,json=stringValue,proto3,oneof"`
}

func (*OperationProgress_Metric_IntValue) isOperationProgress_Metric_Value() {}

func (*OperationProgress_Metric_DoubleValue) isOperationProgress_Metric_Value() {}

func (*OperationProgress_Metric_StringValue) isOperationProgress_Metric_Value() {}

// ReleaseChannelConfig exposes configuration for a release channel.
type ServerConfig_ReleaseChannelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The release channel this configuration applies to.
	Channel ReleaseChannel_Channel `protobuf:"varint,1,opt,name=channel,proto3,enum=google.container.v1.ReleaseChannel_Channel" json:"channel,omitempty"`
	// The default version for newly created clusters on the channel.
	DefaultVersion string `protobuf:"bytes,2,opt,name=default_version,json=defaultVersion,proto3" json:"default_version,omitempty"`
	// List of valid versions for the channel.
	ValidVersions []string `protobuf:"bytes,4,rep,name=valid_versions,json=validVersions,proto3" json:"valid_versions,omitempty"`
	// The auto upgrade target version for clusters on the channel.
	UpgradeTargetVersion string `protobuf:"bytes,5,opt,name=upgrade_target_version,json=upgradeTargetVersion,proto3" json:"upgrade_target_version,omitempty"`
}

func (x *ServerConfig_ReleaseChannelConfig) Reset() {
	*x = ServerConfig_ReleaseChannelConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[189]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerConfig_ReleaseChannelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerConfig_ReleaseChannelConfig) ProtoMessage() {}

func (x *ServerConfig_ReleaseChannelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[189]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerConfig_ReleaseChannelConfig.ProtoReflect.Descriptor instead.
func (*ServerConfig_ReleaseChannelConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{79, 0}
}

func (x *ServerConfig_ReleaseChannelConfig) GetChannel() ReleaseChannel_Channel {
	if x != nil {
		return x.Channel
	}
	return ReleaseChannel_UNSPECIFIED
}

func (x *ServerConfig_ReleaseChannelConfig) GetDefaultVersion() string {
	if x != nil {
		return x.DefaultVersion
	}
	return ""
}

func (x *ServerConfig_ReleaseChannelConfig) GetValidVersions() []string {
	if x != nil {
		return x.ValidVersions
	}
	return nil
}

func (x *ServerConfig_ReleaseChannelConfig) GetUpgradeTargetVersion() string {
	if x != nil {
		return x.UpgradeTargetVersion
	}
	return ""
}

// Standard rollout policy is the default policy for blue-green.
type BlueGreenSettings_StandardRolloutPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Blue pool size to drain in a batch.
	//
	// Types that are assignable to UpdateBatchSize:
	//
	//	*BlueGreenSettings_StandardRolloutPolicy_BatchPercentage
	//	*BlueGreenSettings_StandardRolloutPolicy_BatchNodeCount
	UpdateBatchSize isBlueGreenSettings_StandardRolloutPolicy_UpdateBatchSize `protobuf_oneof:"update_batch_size"`
	// Soak time after each batch gets drained. Default to zero.
	BatchSoakDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=batch_soak_duration,json=batchSoakDuration,proto3,oneof" json:"batch_soak_duration,omitempty"`
}

func (x *BlueGreenSettings_StandardRolloutPolicy) Reset() {
	*x = BlueGreenSettings_StandardRolloutPolicy{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[190]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BlueGreenSettings_StandardRolloutPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BlueGreenSettings_StandardRolloutPolicy) ProtoMessage() {}

func (x *BlueGreenSettings_StandardRolloutPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[190]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BlueGreenSettings_StandardRolloutPolicy.ProtoReflect.Descriptor instead.
func (*BlueGreenSettings_StandardRolloutPolicy) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{84, 0}
}

func (m *BlueGreenSettings_StandardRolloutPolicy) GetUpdateBatchSize() isBlueGreenSettings_StandardRolloutPolicy_UpdateBatchSize {
	if m != nil {
		return m.UpdateBatchSize
	}
	return nil
}

func (x *BlueGreenSettings_StandardRolloutPolicy) GetBatchPercentage() float32 {
	if x, ok := x.GetUpdateBatchSize().(*BlueGreenSettings_StandardRolloutPolicy_BatchPercentage); ok {
		return x.BatchPercentage
	}
	return 0
}

func (x *BlueGreenSettings_StandardRolloutPolicy) GetBatchNodeCount() int32 {
	if x, ok := x.GetUpdateBatchSize().(*BlueGreenSettings_StandardRolloutPolicy_BatchNodeCount); ok {
		return x.BatchNodeCount
	}
	return 0
}

func (x *BlueGreenSettings_StandardRolloutPolicy) GetBatchSoakDuration() *durationpb.Duration {
	if x != nil {
		return x.BatchSoakDuration
	}
	return nil
}

type isBlueGreenSettings_StandardRolloutPolicy_UpdateBatchSize interface {
	isBlueGreenSettings_StandardRolloutPolicy_UpdateBatchSize()
}

type BlueGreenSettings_StandardRolloutPolicy_BatchPercentage struct {
	// Percentage of the blue pool nodes to drain in a batch.
	// The range of this field should be (0.0, 1.0].
	BatchPercentage float32 `protobuf:"fixed32,1,opt,name=batch_percentage,json=batchPercentage,proto3,oneof"`
}

type BlueGreenSettings_StandardRolloutPolicy_BatchNodeCount struct {
	// Number of blue nodes to drain in a batch.
	BatchNodeCount int32 `protobuf:"varint,2,opt,name=batch_node_count,json=batchNodeCount,proto3,oneof"`
}

func (*BlueGreenSettings_StandardRolloutPolicy_BatchPercentage) isBlueGreenSettings_StandardRolloutPolicy_UpdateBatchSize() {
}

func (*BlueGreenSettings_StandardRolloutPolicy_BatchNodeCount) isBlueGreenSettings_StandardRolloutPolicy_UpdateBatchSize() {
}

// These upgrade settings control the level of parallelism and the level of
// disruption caused by an upgrade.
//
// maxUnavailable controls the number of nodes that can be simultaneously
// unavailable.
//
// maxSurge controls the number of additional nodes that can be added to the
// node pool temporarily for the time of the upgrade to increase the number of
// available nodes.
//
// (maxUnavailable + maxSurge) determines the level of parallelism (how many
// nodes are being upgraded at the same time).
//
// Note: upgrades inevitably introduce some disruption since workloads need to
// be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0,
// this holds true. (Disruption stays within the limits of
// PodDisruptionBudget, if it is configured.)
//
// Consider a hypothetical node pool with 5 nodes having maxSurge=2,
// maxUnavailable=1. This means the upgrade process upgrades 3 nodes
// simultaneously. It creates 2 additional (upgraded) nodes, then it brings
// down 3 old (not yet upgraded) nodes at the same time. This ensures that
// there are always at least 4 nodes available.
//
// These upgrade settings configure the upgrade strategy for the node pool.
// Use strategy to switch between the strategies applied to the node pool.
//
// If the strategy is ROLLING, use max_surge and max_unavailable to control
// the level of parallelism and the level of disruption caused by upgrade.
// 1. maxSurge controls the number of additional nodes that can be added to
// the node pool temporarily for the time of the upgrade to increase the
// number of available nodes.
// 2. maxUnavailable controls the number of nodes that can be simultaneously
// unavailable.
// 3. (maxUnavailable + maxSurge) determines the level of parallelism (how
// many nodes are being upgraded at the same time).
//
// If the strategy is BLUE_GREEN, use blue_green_settings to configure the
// blue-green upgrade related settings.
// 1. standard_rollout_policy is the default policy. The policy is used to
// control the way blue pool gets drained. The draining is executed in the
// batch mode. The batch size could be specified as either percentage of the
// node pool size or the number of nodes. batch_soak_duration is the soak
// time after each batch gets drained.
// 2. node_pool_soak_duration is the soak time after all blue nodes are
// drained. After this period, the blue pool nodes will be deleted.
type NodePool_UpgradeSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of nodes that can be created beyond the current size
	// of the node pool during the upgrade process.
	MaxSurge int32 `protobuf:"varint,1,opt,name=max_surge,json=maxSurge,proto3" json:"max_surge,omitempty"`
	// The maximum number of nodes that can be simultaneously unavailable during
	// the upgrade process. A node is considered available if its status is
	// Ready.
	MaxUnavailable int32 `protobuf:"varint,2,opt,name=max_unavailable,json=maxUnavailable,proto3" json:"max_unavailable,omitempty"`
	// Update strategy of the node pool.
	Strategy *NodePoolUpdateStrategy `protobuf:"varint,3,opt,name=strategy,proto3,enum=google.container.v1.NodePoolUpdateStrategy,oneof" json:"strategy,omitempty"`
	// Settings for blue-green upgrade strategy.
	BlueGreenSettings *BlueGreenSettings `protobuf:"bytes,4,opt,name=blue_green_settings,json=blueGreenSettings,proto3,oneof" json:"blue_green_settings,omitempty"`
}

func (x *NodePool_UpgradeSettings) Reset() {
	*x = NodePool_UpgradeSettings{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[191]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePool_UpgradeSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool_UpgradeSettings) ProtoMessage() {}

func (x *NodePool_UpgradeSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[191]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool_UpgradeSettings.ProtoReflect.Descriptor instead.
func (*NodePool_UpgradeSettings) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{85, 0}
}

func (x *NodePool_UpgradeSettings) GetMaxSurge() int32 {
	if x != nil {
		return x.MaxSurge
	}
	return 0
}

func (x *NodePool_UpgradeSettings) GetMaxUnavailable() int32 {
	if x != nil {
		return x.MaxUnavailable
	}
	return 0
}

func (x *NodePool_UpgradeSettings) GetStrategy() NodePoolUpdateStrategy {
	if x != nil && x.Strategy != nil {
		return *x.Strategy
	}
	return NodePoolUpdateStrategy_NODE_POOL_UPDATE_STRATEGY_UNSPECIFIED
}

func (x *NodePool_UpgradeSettings) GetBlueGreenSettings() *BlueGreenSettings {
	if x != nil {
		return x.BlueGreenSettings
	}
	return nil
}

// UpdateInfo contains resource (instance groups, etc), status and other
// intermediate information relevant to a node pool upgrade.
type NodePool_UpdateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information of a blue-green upgrade.
	BlueGreenInfo *NodePool_UpdateInfo_BlueGreenInfo `protobuf:"bytes,1,opt,name=blue_green_info,json=blueGreenInfo,proto3" json:"blue_green_info,omitempty"`
}

func (x *NodePool_UpdateInfo) Reset() {
	*x = NodePool_UpdateInfo{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[192]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePool_UpdateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool_UpdateInfo) ProtoMessage() {}

func (x *NodePool_UpdateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[192]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool_UpdateInfo.ProtoReflect.Descriptor instead.
func (*NodePool_UpdateInfo) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{85, 1}
}

func (x *NodePool_UpdateInfo) GetBlueGreenInfo() *NodePool_UpdateInfo_BlueGreenInfo {
	if x != nil {
		return x.BlueGreenInfo
	}
	return nil
}

// PlacementPolicy defines the placement policy used by the node pool.
type NodePool_PlacementPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of placement.
	Type NodePool_PlacementPolicy_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.container.v1.NodePool_PlacementPolicy_Type" json:"type,omitempty"`
	// Optional. TPU placement topology for pod slice node pool.
	// https://cloud.google.com/tpu/docs/types-topologies#tpu_topologies
	TpuTopology string `protobuf:"bytes,2,opt,name=tpu_topology,json=tpuTopology,proto3" json:"tpu_topology,omitempty"`
	// If set, refers to the name of a custom resource policy supplied by the
	// user. The resource policy must be in the same project and region as the
	// node pool. If not found, InvalidArgument error is returned.
	PolicyName string `protobuf:"bytes,3,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
}

func (x *NodePool_PlacementPolicy) Reset() {
	*x = NodePool_PlacementPolicy{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[193]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePool_PlacementPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool_PlacementPolicy) ProtoMessage() {}

func (x *NodePool_PlacementPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[193]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool_PlacementPolicy.ProtoReflect.Descriptor instead.
func (*NodePool_PlacementPolicy) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{85, 2}
}

func (x *NodePool_PlacementPolicy) GetType() NodePool_PlacementPolicy_Type {
	if x != nil {
		return x.Type
	}
	return NodePool_PlacementPolicy_TYPE_UNSPECIFIED
}

func (x *NodePool_PlacementPolicy) GetTpuTopology() string {
	if x != nil {
		return x.TpuTopology
	}
	return ""
}

func (x *NodePool_PlacementPolicy) GetPolicyName() string {
	if x != nil {
		return x.PolicyName
	}
	return ""
}

// QueuedProvisioning defines the queued provisioning used by the node pool.
type NodePool_QueuedProvisioning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Denotes that this nodepool is QRM specific, meaning nodes can be only
	// obtained through queuing via the Cluster Autoscaler ProvisioningRequest
	// API.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *NodePool_QueuedProvisioning) Reset() {
	*x = NodePool_QueuedProvisioning{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[194]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePool_QueuedProvisioning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool_QueuedProvisioning) ProtoMessage() {}

func (x *NodePool_QueuedProvisioning) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[194]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool_QueuedProvisioning.ProtoReflect.Descriptor instead.
func (*NodePool_QueuedProvisioning) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{85, 3}
}

func (x *NodePool_QueuedProvisioning) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Information relevant to blue-green upgrade.
type NodePool_UpdateInfo_BlueGreenInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Current blue-green upgrade phase.
	Phase NodePool_UpdateInfo_BlueGreenInfo_Phase `protobuf:"varint,1,opt,name=phase,proto3,enum=google.container.v1.NodePool_UpdateInfo_BlueGreenInfo_Phase" json:"phase,omitempty"`
	// The resource URLs of the [managed instance groups]
	// (/compute/docs/instance-groups/creating-groups-of-managed-instances)
	// associated with blue pool.
	BlueInstanceGroupUrls []string `protobuf:"bytes,2,rep,name=blue_instance_group_urls,json=blueInstanceGroupUrls,proto3" json:"blue_instance_group_urls,omitempty"`
	// The resource URLs of the [managed instance groups]
	// (/compute/docs/instance-groups/creating-groups-of-managed-instances)
	// associated with green pool.
	GreenInstanceGroupUrls []string `protobuf:"bytes,3,rep,name=green_instance_group_urls,json=greenInstanceGroupUrls,proto3" json:"green_instance_group_urls,omitempty"`
	// Time to start deleting blue pool to complete blue-green upgrade,
	// in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	BluePoolDeletionStartTime string `protobuf:"bytes,4,opt,name=blue_pool_deletion_start_time,json=bluePoolDeletionStartTime,proto3" json:"blue_pool_deletion_start_time,omitempty"`
	// Version of green pool.
	GreenPoolVersion string `protobuf:"bytes,5,opt,name=green_pool_version,json=greenPoolVersion,proto3" json:"green_pool_version,omitempty"`
}

func (x *NodePool_UpdateInfo_BlueGreenInfo) Reset() {
	*x = NodePool_UpdateInfo_BlueGreenInfo{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[195]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodePool_UpdateInfo_BlueGreenInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool_UpdateInfo_BlueGreenInfo) ProtoMessage() {}

func (x *NodePool_UpdateInfo_BlueGreenInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[195]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool_UpdateInfo_BlueGreenInfo.ProtoReflect.Descriptor instead.
func (*NodePool_UpdateInfo_BlueGreenInfo) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{85, 1, 0}
}

func (x *NodePool_UpdateInfo_BlueGreenInfo) GetPhase() NodePool_UpdateInfo_BlueGreenInfo_Phase {
	if x != nil {
		return x.Phase
	}
	return NodePool_UpdateInfo_BlueGreenInfo_PHASE_UNSPECIFIED
}

func (x *NodePool_UpdateInfo_BlueGreenInfo) GetBlueInstanceGroupUrls() []string {
	if x != nil {
		return x.BlueInstanceGroupUrls
	}
	return nil
}

func (x *NodePool_UpdateInfo_BlueGreenInfo) GetGreenInstanceGroupUrls() []string {
	if x != nil {
		return x.GreenInstanceGroupUrls
	}
	return nil
}

func (x *NodePool_UpdateInfo_BlueGreenInfo) GetBluePoolDeletionStartTime() string {
	if x != nil {
		return x.BluePoolDeletionStartTime
	}
	return ""
}

func (x *NodePool_UpdateInfo_BlueGreenInfo) GetGreenPoolVersion() string {
	if x != nil {
		return x.GreenPoolVersion
	}
	return ""
}

// Configuration of network bandwidth tiers
type NetworkConfig_ClusterNetworkPerformanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the total network bandwidth tier for NodePools in the cluster.
	TotalEgressBandwidthTier *NetworkConfig_ClusterNetworkPerformanceConfig_Tier `protobuf:"varint,1,opt,name=total_egress_bandwidth_tier,json=totalEgressBandwidthTier,proto3,enum=google.container.v1.NetworkConfig_ClusterNetworkPerformanceConfig_Tier,oneof" json:"total_egress_bandwidth_tier,omitempty"`
}

func (x *NetworkConfig_ClusterNetworkPerformanceConfig) Reset() {
	*x = NetworkConfig_ClusterNetworkPerformanceConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[198]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkConfig_ClusterNetworkPerformanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig_ClusterNetworkPerformanceConfig) ProtoMessage() {}

func (x *NetworkConfig_ClusterNetworkPerformanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[198]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig_ClusterNetworkPerformanceConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig_ClusterNetworkPerformanceConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{115, 0}
}

func (x *NetworkConfig_ClusterNetworkPerformanceConfig) GetTotalEgressBandwidthTier() NetworkConfig_ClusterNetworkPerformanceConfig_Tier {
	if x != nil && x.TotalEgressBandwidthTier != nil {
		return *x.TotalEgressBandwidthTier
	}
	return NetworkConfig_ClusterNetworkPerformanceConfig_TIER_UNSPECIFIED
}

// OperationError records errors seen from CloudKMS keys
// encountered during updates to DatabaseEncryption configuration.
type DatabaseEncryption_OperationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CloudKMS key resource that had the error.
	KeyName string `protobuf:"bytes,1,opt,name=key_name,json=keyName,proto3" json:"key_name,omitempty"`
	// Description of the error seen during the operation.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Time when the CloudKMS error was seen.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *DatabaseEncryption_OperationError) Reset() {
	*x = DatabaseEncryption_OperationError{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[199]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatabaseEncryption_OperationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseEncryption_OperationError) ProtoMessage() {}

func (x *DatabaseEncryption_OperationError) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[199]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseEncryption_OperationError.ProtoReflect.Descriptor instead.
func (*DatabaseEncryption_OperationError) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{135, 0}
}

func (x *DatabaseEncryption_OperationError) GetKeyName() string {
	if x != nil {
		return x.KeyName
	}
	return ""
}

func (x *DatabaseEncryption_OperationError) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *DatabaseEncryption_OperationError) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

// Parameters for using BigQuery as the destination of resource usage export.
type ResourceUsageExportConfig_BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of a BigQuery Dataset.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
}

func (x *ResourceUsageExportConfig_BigQueryDestination) Reset() {
	*x = ResourceUsageExportConfig_BigQueryDestination{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[200]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceUsageExportConfig_BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceUsageExportConfig_BigQueryDestination) ProtoMessage() {}

func (x *ResourceUsageExportConfig_BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[200]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceUsageExportConfig_BigQueryDestination.ProtoReflect.Descriptor instead.
func (*ResourceUsageExportConfig_BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{140, 0}
}

func (x *ResourceUsageExportConfig_BigQueryDestination) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

// Parameters for controlling consumption metering.
type ResourceUsageExportConfig_ConsumptionMeteringConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to enable consumption metering for this cluster. If enabled, a
	// second BigQuery table will be created to hold resource consumption
	// records.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *ResourceUsageExportConfig_ConsumptionMeteringConfig) Reset() {
	*x = ResourceUsageExportConfig_ConsumptionMeteringConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[201]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceUsageExportConfig_ConsumptionMeteringConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceUsageExportConfig_ConsumptionMeteringConfig) ProtoMessage() {}

func (x *ResourceUsageExportConfig_ConsumptionMeteringConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[201]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceUsageExportConfig_ConsumptionMeteringConfig.ProtoReflect.Descriptor instead.
func (*ResourceUsageExportConfig_ConsumptionMeteringConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{140, 1}
}

func (x *ResourceUsageExportConfig_ConsumptionMeteringConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Pub/Sub specific notification config.
type NotificationConfig_PubSub struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Enable notifications for Pub/Sub.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The desired Pub/Sub topic to which notifications will be
	// sent by GKE. Format is `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// Allows filtering to one or more specific event types. If no filter is
	// specified, or if a filter is specified with no event types, all event
	// types will be sent
	Filter *NotificationConfig_Filter `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *NotificationConfig_PubSub) Reset() {
	*x = NotificationConfig_PubSub{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[202]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotificationConfig_PubSub) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationConfig_PubSub) ProtoMessage() {}

func (x *NotificationConfig_PubSub) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[202]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationConfig_PubSub.ProtoReflect.Descriptor instead.
func (*NotificationConfig_PubSub) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{146, 0}
}

func (x *NotificationConfig_PubSub) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *NotificationConfig_PubSub) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *NotificationConfig_PubSub) GetFilter() *NotificationConfig_Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

// Allows filtering to one or more specific event types. If event types are
// present, those and only those event types will be transmitted to the
// cluster. Other types will be skipped. If no filter is specified, or no
// event types are present, all event types will be sent
type NotificationConfig_Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Event types to allowlist.
	EventType []NotificationConfig_EventType `protobuf:"varint,1,rep,packed,name=event_type,json=eventType,proto3,enum=google.container.v1.NotificationConfig_EventType" json:"event_type,omitempty"`
}

func (x *NotificationConfig_Filter) Reset() {
	*x = NotificationConfig_Filter{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[203]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NotificationConfig_Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationConfig_Filter) ProtoMessage() {}

func (x *NotificationConfig_Filter) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[203]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationConfig_Filter.ProtoReflect.Descriptor instead.
func (*NotificationConfig_Filter) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{146, 1}
}

func (x *NotificationConfig_Filter) GetEventType() []NotificationConfig_EventType {
	if x != nil {
		return x.EventType
	}
	return nil
}

// Describes the configuration of a DNS endpoint.
type ControlPlaneEndpointsConfig_DNSEndpointConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The cluster's DNS endpoint configuration.
	// A DNS format address. This is accessible from the public internet.
	// Ex: uid.us-central1.gke.goog.
	// Always present, but the behavior may change according to the value of
	// [DNSEndpointConfig.allow_external_traffic][google.container.v1.ControlPlaneEndpointsConfig.DNSEndpointConfig.allow_external_traffic].
	Endpoint string `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Controls whether user traffic is allowed over this endpoint. Note that
	// GCP-managed services may still use the endpoint even if this is false.
	AllowExternalTraffic *bool `protobuf:"varint,3,opt,name=allow_external_traffic,json=allowExternalTraffic,proto3,oneof" json:"allow_external_traffic,omitempty"`
}

func (x *ControlPlaneEndpointsConfig_DNSEndpointConfig) Reset() {
	*x = ControlPlaneEndpointsConfig_DNSEndpointConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[204]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ControlPlaneEndpointsConfig_DNSEndpointConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ControlPlaneEndpointsConfig_DNSEndpointConfig) ProtoMessage() {}

func (x *ControlPlaneEndpointsConfig_DNSEndpointConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[204]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ControlPlaneEndpointsConfig_DNSEndpointConfig.ProtoReflect.Descriptor instead.
func (*ControlPlaneEndpointsConfig_DNSEndpointConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{165, 0}
}

func (x *ControlPlaneEndpointsConfig_DNSEndpointConfig) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *ControlPlaneEndpointsConfig_DNSEndpointConfig) GetAllowExternalTraffic() bool {
	if x != nil && x.AllowExternalTraffic != nil {
		return *x.AllowExternalTraffic
	}
	return false
}

// IP endpoints configuration.
type ControlPlaneEndpointsConfig_IPEndpointsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls whether to allow direct IP access.
	Enabled *bool `protobuf:"varint,1,opt,name=enabled,proto3,oneof" json:"enabled,omitempty"`
	// Controls whether the control plane allows access through a public IP.
	// It is invalid to specify both
	// [PrivateClusterConfig.enablePrivateEndpoint][] and this field at the same
	// time.
	EnablePublicEndpoint *bool `protobuf:"varint,2,opt,name=enable_public_endpoint,json=enablePublicEndpoint,proto3,oneof" json:"enable_public_endpoint,omitempty"`
	// Controls whether the control plane's private endpoint is accessible from
	// sources in other regions.
	// It is invalid to specify both
	// [PrivateClusterMasterGlobalAccessConfig.enabled][google.container.v1.PrivateClusterMasterGlobalAccessConfig.enabled]
	// and this field at the same time.
	GlobalAccess *bool `protobuf:"varint,3,opt,name=global_access,json=globalAccess,proto3,oneof" json:"global_access,omitempty"`
	// Configuration of authorized networks. If enabled, restricts access to the
	// control plane based on source IP.
	// It is invalid to specify both
	// [Cluster.masterAuthorizedNetworksConfig][] and this field at the same
	// time.
	AuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,4,opt,name=authorized_networks_config,json=authorizedNetworksConfig,proto3" json:"authorized_networks_config,omitempty"`
	// Output only. The external IP address of this cluster's control plane.
	// Only populated if enabled.
	PublicEndpoint string `protobuf:"bytes,5,opt,name=public_endpoint,json=publicEndpoint,proto3" json:"public_endpoint,omitempty"`
	// Output only. The internal IP address of this cluster's control plane.
	// Only populated if enabled.
	PrivateEndpoint string `protobuf:"bytes,6,opt,name=private_endpoint,json=privateEndpoint,proto3" json:"private_endpoint,omitempty"`
	// Subnet to provision the master's private endpoint during cluster
	// creation. Specified in projects/*/regions/*/subnetworks/* format. It is
	// invalid to specify both
	// [PrivateClusterConfig.privateEndpointSubnetwork][] and this field at the
	// same time.
	PrivateEndpointSubnetwork string `protobuf:"bytes,7,opt,name=private_endpoint_subnetwork,json=privateEndpointSubnetwork,proto3" json:"private_endpoint_subnetwork,omitempty"`
}

func (x *ControlPlaneEndpointsConfig_IPEndpointsConfig) Reset() {
	*x = ControlPlaneEndpointsConfig_IPEndpointsConfig{}
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[205]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ControlPlaneEndpointsConfig_IPEndpointsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ControlPlaneEndpointsConfig_IPEndpointsConfig) ProtoMessage() {}

func (x *ControlPlaneEndpointsConfig_IPEndpointsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_container_v1_cluster_service_proto_msgTypes[205]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ControlPlaneEndpointsConfig_IPEndpointsConfig.ProtoReflect.Descriptor instead.
func (*ControlPlaneEndpointsConfig_IPEndpointsConfig) Descriptor() ([]byte, []int) {
	return file_google_container_v1_cluster_service_proto_rawDescGZIP(), []int{165, 1}
}

func (x *ControlPlaneEndpointsConfig_IPEndpointsConfig) GetEnabled() bool {
	if x != nil && x.Enabled != nil {
		return *x.Enabled
	}
	return false
}

func (x *ControlPlaneEndpointsConfig_IPEndpointsConfig) GetEnablePublicEndpoint() bool {
	if x != nil && x.EnablePublicEndpoint != nil {
		return *x.EnablePublicEndpoint
	}
	return false
}

func (x *ControlPlaneEndpointsConfig_IPEndpointsConfig) GetGlobalAccess() bool {
	if x != nil && x.GlobalAccess != nil {
		return *x.GlobalAccess
	}
	return false
}

func (x *ControlPlaneEndpointsConfig_IPEndpointsConfig) GetAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if x != nil {
		return x.AuthorizedNetworksConfig
	}
	return nil
}

func (x *ControlPlaneEndpointsConfig_IPEndpointsConfig) GetPublicEndpoint() string {
	if x != nil {
		return x.PublicEndpoint
	}
	return ""
}

func (x *ControlPlaneEndpointsConfig_IPEndpointsConfig) GetPrivateEndpoint() string {
	if x != nil {
		return x.PrivateEndpoint
	}
	return ""
}

func (x *ControlPlaneEndpointsConfig_IPEndpointsConfig) GetPrivateEndpointSubnetwork() string {
	if x != nil {
		return x.PrivateEndpointSubnetwork
	}
	return ""
}

var File_google_container_v1_cluster_service_proto protoreflect.FileDescriptor

var file_google_container_v1_cluster_service_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f,
	0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xcd, 0x04, 0x0a, 0x0f, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x07, 0x73, 0x79, 0x73, 0x63, 0x74, 0x6c, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e,
	0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x79, 0x73,
	0x63, 0x74, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x73, 0x79, 0x73, 0x63, 0x74,
	0x6c, 0x73, 0x12, 0x50, 0x0a, 0x0b, 0x63, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x63, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x5c, 0x0a, 0x09, 0x68, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x48, 0x75,
	0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x09, 0x68, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x73, 0x88,
	0x01, 0x01, 0x1a, 0x9f, 0x01, 0x0a, 0x0f, 0x48, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x0f, 0x68, 0x75, 0x67, 0x65, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x32, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x68, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x32, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x0f, 0x68, 0x75, 0x67,
	0x65, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x31, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0e, 0x68, 0x75, 0x67, 0x65, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x31, 0x67, 0x88, 0x01, 0x01, 0x42, 0x12, 0x0a, 0x10,
	0x5f, 0x68, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x32, 0x6d,
	0x42, 0x12, 0x0a, 0x10, 0x5f, 0x68, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x31, 0x67, 0x1a, 0x3a, 0x0a, 0x0c, 0x53, 0x79, 0x73, 0x63, 0x74, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x51, 0x0a, 0x0a, 0x43, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b,
	0x0a, 0x17, 0x43, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x43,
	0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x56, 0x31, 0x10, 0x01, 0x12,
	0x12, 0x0a, 0x0e, 0x43, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x56,
	0x32, 0x10, 0x02, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x68, 0x75, 0x67, 0x65, 0x70, 0x61, 0x67, 0x65,
	0x73, 0x22, 0xbf, 0x01, 0x0a, 0x11, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e, 0x6f, 0x64,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x0a, 0x6f, 0x73, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4f, 0x53, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f,
	0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x59, 0x0a, 0x09, 0x4f, 0x53, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x16, 0x4f, 0x53, 0x5f, 0x56, 0x45, 0x52, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x17, 0x0a, 0x13, 0x4f, 0x53, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x4c, 0x54, 0x53, 0x43, 0x32, 0x30, 0x31, 0x39, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x4f, 0x53,
	0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x54, 0x53, 0x43, 0x32, 0x30, 0x32,
	0x32, 0x10, 0x02, 0x22, 0xdc, 0x02, 0x0a, 0x11, 0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65,
	0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x70, 0x75,
	0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63, 0x70, 0x75, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3e, 0x0a, 0x0d, 0x63, 0x70, 0x75, 0x5f, 0x63,
	0x66, 0x73, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x63, 0x70, 0x75, 0x43,
	0x66, 0x73, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x14, 0x63, 0x70, 0x75, 0x5f, 0x63,
	0x66, 0x73, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x70, 0x75, 0x43, 0x66, 0x73, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x6f, 0x64, 0x5f,
	0x70, 0x69, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0c, 0x70, 0x6f, 0x64, 0x50, 0x69, 0x64, 0x73, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x57,
	0x0a, 0x26, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x6b, 0x75, 0x62, 0x65, 0x6c,
	0x65, 0x74, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00,
	0x52, 0x22, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65,
	0x74, 0x52, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x42, 0x29, 0x0a, 0x27, 0x5f, 0x69, 0x6e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x65, 0x5f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x61,
	0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x22, 0xa3, 0x1b, 0x0a, 0x0a, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x61,
	0x75, 0x74, 0x68, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a,
	0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x73, 0x64, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x53, 0x73, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x20, 0x0a,
	0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x12,
	0x4a, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x61,
	0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x69, 0x6e, 0x5f,
	0x63, 0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x43, 0x70, 0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x12, 0x65, 0x0a, 0x18, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x06, 0x74, 0x61, 0x69,
	0x6e, 0x74, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x74, 0x61, 0x69, 0x6e, 0x74,
	0x73, 0x12, 0x49, 0x0a, 0x0e, 0x73, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x5b, 0x0a, 0x14, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x79, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x79, 0x52, 0x13, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x65, 0x0a, 0x18, 0x73, 0x68, 0x69, 0x65,
	0x6c, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x73, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65,
	0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x50, 0x0a, 0x11, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0f, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x4d, 0x0a, 0x0e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0d, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x29, 0x0a, 0x11, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6b, 0x6d,
	0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x62, 0x6f, 0x6f,
	0x74, 0x44, 0x69, 0x73, 0x6b, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x67,
	0x63, 0x66, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x66, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0a, 0x67, 0x63, 0x66, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x68, 0x0a,
	0x19, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x17,
	0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x35, 0x0a, 0x05, 0x67, 0x76, 0x6e, 0x69, 0x63,
	0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72,
	0x74, 0x75, 0x61, 0x6c, 0x4e, 0x49, 0x43, 0x52, 0x05, 0x67, 0x76, 0x6e, 0x69, 0x63, 0x12, 0x12,
	0x0a, 0x04, 0x73, 0x70, 0x6f, 0x74, 0x18, 0x20, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x73, 0x70,
	0x6f, 0x74, 0x12, 0x55, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x0b, 0x66, 0x61, 0x73,
	0x74, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x73, 0x74, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x48,
	0x00, 0x52, 0x0a, 0x66, 0x61, 0x73, 0x74, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x88, 0x01, 0x01,
	0x12, 0x5c, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x25, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x51,
	0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x56, 0x0a, 0x13, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e,
	0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a, 0x1b, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x5f, 0x6e, 0x76, 0x6d, 0x65, 0x5f, 0x73, 0x73, 0x64, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x4e, 0x76, 0x6d, 0x65, 0x53, 0x73,
	0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x17, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x4e, 0x76, 0x6d, 0x65, 0x53, 0x73, 0x64, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7f, 0x0a, 0x22, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72,
	0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x5f, 0x73, 0x73, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x29, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61,
	0x6c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x53, 0x73, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1e, 0x65, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61,
	0x6c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x53, 0x73, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x12, 0x73, 0x6f, 0x6c, 0x65, 0x5f, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x2a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x65, 0x54, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x73, 0x6f, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x11, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x5c, 0x0a, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x52, 0x13, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x12, 0x43, 0x0a,
	0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x2e, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x12, 0x58, 0x0a, 0x14, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f,
	0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x30, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x42, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x12, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x61, 0x72, 0x79, 0x42, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x23, 0x0a, 0x0d,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x31, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x12, 0x87, 0x01, 0x0a, 0x23, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f,
	0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x42,
	0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x01, 0x52, 0x1f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61,
	0x72, 0x79, 0x42, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x88, 0x01, 0x01, 0x12, 0x76, 0x0a, 0x19, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x73, 0x64, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x36, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x53, 0x73, 0x64, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x02, 0x52, 0x16, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x53,
	0x73, 0x64, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x6c, 0x0a, 0x15, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x63, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x37, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x6f, 0x64,
	0x65, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x41, 0x0a, 0x13, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7a, 0x0a, 0x16,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x53, 0x73, 0x64, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x29, 0x0a, 0x25, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f,
	0x53, 0x53, 0x44, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x45, 0x4e,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x50,
	0x48, 0x45, 0x4d, 0x45, 0x52, 0x41, 0x4c, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x45, 0x4e, 0x43, 0x52,
	0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x78, 0x0a, 0x13, 0x45, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x25, 0x0a, 0x21, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x47, 0x52,
	0x4f, 0x55, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x5f, 0x43, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f,
	0x56, 0x31, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x46, 0x46, 0x45, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x5f, 0x43, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x56, 0x32,
	0x10, 0x02, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x6f, 0x63, 0x6b,
	0x65, 0x74, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x73, 0x64, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0xc5, 0x01, 0x0a, 0x17, 0x41, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00,
	0x52, 0x0e, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x72, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x45, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x1a, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x4e, 0x65, 0x73, 0x74, 0x65, 0x64, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x42,
	0x1f, 0x0a, 0x1d, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x5f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x99, 0x08, 0x0a, 0x11, 0x4e, 0x6f, 0x64, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x64,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x6f, 0x64, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6f, 0x64, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x2d, 0x0a, 0x13, 0x70, 0x6f, 0x64, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63,
	0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x70, 0x6f, 0x64, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x12, 0x35, 0x0a, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x00, 0x52, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x4e, 0x6f, 0x64, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x82, 0x01, 0x0a, 0x1a, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x01,
	0x52, 0x18, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x72, 0x0a,
	0x1d, 0x70, 0x6f, 0x64, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x43, 0x49,
	0x44, 0x52, 0x4f, 0x76, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1a, 0x70, 0x6f, 0x64, 0x43, 0x69, 0x64, 0x72, 0x4f, 0x76,
	0x65, 0x72, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x77, 0x0a, 0x1f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1c, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x74, 0x0a, 0x1e, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x1b, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50,
	0x6f, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x12, 0x40, 0x0a, 0x1a, 0x70, 0x6f, 0x64, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x70, 0x6f, 0x64, 0x49, 0x70,
	0x76, 0x34, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0xef, 0x01, 0x0a, 0x18, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65,
	0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x88, 0x01, 0x0a, 0x1b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x5f, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x69, 0x65, 0x72, 0x48, 0x00, 0x52, 0x18, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x61, 0x6e, 0x64, 0x77, 0x69,
	0x64, 0x74, 0x68, 0x54, 0x69, 0x65, 0x72, 0x88, 0x01, 0x01, 0x22, 0x28, 0x0a, 0x04, 0x54, 0x69,
	0x65, 0x72, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x49, 0x45, 0x52,
	0x5f, 0x31, 0x10, 0x01, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x65,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f,
	0x74, 0x69, 0x65, 0x72, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x42, 0x1d, 0x0a,
	0x1b, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x57, 0x0a, 0x1b,
	0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0xda, 0x01, 0x0a, 0x1a, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x64, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x56, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6f, 0x64, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x50, 0x6f,
	0x64, 0x73, 0x50, 0x65, 0x72, 0x4e, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12,
	0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6f, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x16, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a,
	0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62,
	0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x12, 0x3e, 0x0a, 0x1b, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74,
	0x79, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x22, 0x71, 0x0a, 0x0d, 0x53,
	0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x61, 0x6e, 0x64, 0x62, 0x6f, 0x78, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x23, 0x0a, 0x04, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x47, 0x56, 0x49, 0x53, 0x4f, 0x52, 0x10, 0x01, 0x22, 0x26,
	0x0a, 0x0a, 0x47, 0x63, 0x66, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x84, 0x02, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x67,
	0x0a, 0x18, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x16, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x22, 0x5a, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f,
	0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x13,
	0x0a, 0x0f, 0x41, 0x4e, 0x59, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x43, 0x5f,
	0x52, 0x45, 0x53, 0x45, 0x52, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x22, 0xbd, 0x02,
	0x0a, 0x10, 0x53, 0x6f, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x5b, 0x0a, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x52,
	0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x1a,
	0xcb, 0x01, 0x0a, 0x0c, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x57, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x22, 0x38, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12,
	0x18, 0x0a, 0x14, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x49, 0x4e, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x10, 0x02, 0x22, 0xfa, 0x05,
	0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x86, 0x01, 0x0a, 0x1e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1b,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xdc, 0x04, 0x0a, 0x1b,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0xb1, 0x01, 0x0a, 0x23, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x20, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xee, 0x02, 0x0a, 0x20, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14,
	0x0a, 0x05, 0x66, 0x71, 0x64, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x66,
	0x71, 0x64, 0x6e, 0x73, 0x12, 0xd9, 0x01, 0x0a, 0x25, 0x67, 0x63, 0x70, 0x5f, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x84, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x43, 0x50, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x21, 0x67,
	0x63, 0x70, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x1a, 0x42, 0x0a, 0x21, 0x47, 0x43, 0x50, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x55, 0x72, 0x69, 0x42, 0x14, 0x0a, 0x12, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xcd, 0x01, 0x0a, 0x09, 0x4e,
	0x6f, 0x64, 0x65, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x3d, 0x0a, 0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x61, 0x69, 0x6e, 0x74,
	0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x52, 0x06, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x22,
	0x59, 0x0a, 0x06, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x46, 0x46,
	0x45, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45,
	0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x5f,
	0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f,
	0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x45, 0x10, 0x03, 0x22, 0x44, 0x0a, 0x0a, 0x4e, 0x6f,
	0x64, 0x65, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x36, 0x0a, 0x06, 0x74, 0x61, 0x69, 0x6e,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x54, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x73,
	0x22, 0x8c, 0x01, 0x0a, 0x0a, 0x4e, 0x6f, 0x64, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x43, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x94, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x47, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x21, 0x0a, 0x0b, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x54, 0x61, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x22, 0xc9, 0x02, 0x0a, 0x0a, 0x4d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x12, 0x1e, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x68, 0x0a, 0x19, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x17, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x39, 0x0a, 0x16, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x61,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x64, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x32, 0x0a,
	0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x66, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x4b, 0x65, 0x79, 0x22, 0x53, 0x0a, 0x17, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x38, 0x0a, 0x18, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x16, 0x69, 0x73, 0x73, 0x75, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x22, 0x91, 0x0b, 0x0a, 0x0c, 0x41,
	0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x13, 0x68,
	0x74, 0x74, 0x70, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69,
	0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x74, 0x74, 0x70, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67,
	0x52, 0x11, 0x68, 0x74, 0x74, 0x70, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x69, 0x6e, 0x67, 0x12, 0x6b, 0x0a, 0x1a, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61,
	0x6c, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f,
	0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x18, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74,
	0x61, 0x6c, 0x50, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x12, 0x5f, 0x0a, 0x14, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x5f, 0x64,
	0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x44,
	0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x42, 0x02, 0x18, 0x01, 0x52, 0x13, 0x6b, 0x75,
	0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x12, 0x5c, 0x0a, 0x15, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x4d, 0x0a, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d,
	0x0a, 0x10, 0x64, 0x6e, 0x73, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6e, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x64,
	0x6e, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x62, 0x0a,
	0x17, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x86, 0x01, 0x0a, 0x25, 0x67, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x63, 0x73, 0x69, 0x5f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x65, 0x50, 0x65, 0x72, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x20, 0x67, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x73, 0x69, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x76, 0x0a, 0x1f, 0x67, 0x63,
	0x70, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x73, 0x69, 0x5f,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x70, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1b, 0x67, 0x63, 0x70, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x60, 0x0a, 0x17, 0x67, 0x6b, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14,
	0x67, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x1a, 0x67, 0x63, 0x73, 0x5f, 0x66, 0x75, 0x73, 0x65,
	0x5f, 0x63, 0x73, 0x69, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x63, 0x73, 0x46, 0x75, 0x73, 0x65, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x67, 0x63, 0x73, 0x46, 0x75, 0x73, 0x65, 0x43, 0x73,
	0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a,
	0x12, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6c, 0x5f, 0x68, 0x61, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6c, 0x48, 0x41, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x74, 0x61, 0x74, 0x65, 0x66, 0x75, 0x6c, 0x48,
	0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x78, 0x0a, 0x1f, 0x70, 0x61, 0x72, 0x61, 0x6c,
	0x6c, 0x65, 0x6c, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x73, 0x69, 0x5f, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x1c, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x5b, 0x0a, 0x13, 0x72, 0x61, 0x79, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x61, 0x79,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x2f,
	0x0a, 0x11, 0x48, 0x74, 0x74, 0x70, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x69, 0x6e, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22,
	0x36, 0x0a, 0x18, 0x48, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x50, 0x6f, 0x64,
	0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x31, 0x0a, 0x13, 0x4b, 0x75, 0x62, 0x65, 0x72,
	0x6e, 0x65, 0x74, 0x65, 0x73, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x1a,
	0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x31, 0x0a, 0x13, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x2a, 0x0a,
	0x0e, 0x44, 0x6e, 0x73, 0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x42, 0x0a, 0x26, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x8b, 0x04,
	0x0a, 0x14, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x17,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x16, 0x6d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x30, 0x0a,
	0x10, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x0f,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12,
	0x2e, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52,
	0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12,
	0x26, 0x0a, 0x0c, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x65, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x7e, 0x0a, 0x1b, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x18, 0x6d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x0a, 0x1b, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x19, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x5c, 0x0a, 0x19, 0x41,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x8a, 0x02, 0x0a, 0x0e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x62, 0x0a, 0x12, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x52, 0x75, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x6c, 0x6f, 0x61, 0x64,
	0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x22, 0x78, 0x0a, 0x10,
	0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x22, 0x0a, 0x1e, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45,
	0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c,
	0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52,
	0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41,
	0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x31, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x3c, 0x0a, 0x20, 0x47, 0x63, 0x65,
	0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x73,
	0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x37, 0x0a, 0x1b, 0x47, 0x63, 0x70, 0x46, 0x69,
	0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x22, 0x32, 0x0a, 0x16, 0x47, 0x63, 0x73, 0x46, 0x75, 0x73, 0x65, 0x43, 0x73, 0x69, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x22, 0x38, 0x0a, 0x1c, 0x50, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x73, 0x69, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x96,
	0x02, 0x0a, 0x11, 0x52, 0x61, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x6e,
	0x0a, 0x1a, 0x72, 0x61, 0x79, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x79, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x72, 0x61, 0x79, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x77,
	0x0a, 0x1d, 0x72, 0x61, 0x79, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x79, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x72, 0x61, 0x79,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x30, 0x0a, 0x14, 0x47, 0x6b, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x2c, 0x0a, 0x10, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x66, 0x75, 0x6c, 0x48, 0x41, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xd7, 0x03, 0x0a, 0x1e, 0x4d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x12, 0x5e, 0x0a, 0x0b, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43,
	0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x0a, 0x63, 0x69, 0x64, 0x72, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x73, 0x12, 0x49, 0x0a, 0x1f, 0x67, 0x63, 0x70, 0x5f, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52,
	0x1b, 0x67, 0x63, 0x70, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x43, 0x69, 0x64, 0x72, 0x73, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x54, 0x0a, 0x24, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52,
	0x21, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x88, 0x01, 0x01, 0x1a, 0x4d, 0x0a, 0x09, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x69, 0x64, 0x72, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x67, 0x63, 0x70, 0x5f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x65, 0x6e,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x22, 0x26, 0x0a, 0x0a, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x41, 0x62, 0x61, 0x63, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xa4, 0x01, 0x0a, 0x0d, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x47, 0x0a, 0x08, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x30,
	0x0a, 0x08, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x52,
	0x4f, 0x56, 0x49, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x41, 0x4c, 0x49, 0x43, 0x4f, 0x10, 0x01,
	0x22, 0xfc, 0x01, 0x0a, 0x13, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x60, 0x0a, 0x0f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0e, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x65, 0x0a, 0x0e, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x56,
	0x41, 0x4c, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44,
	0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x24, 0x0a, 0x20, 0x50, 0x52, 0x4f,
	0x4a, 0x45, 0x43, 0x54, 0x5f, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x54, 0x4f, 0x4e, 0x5f, 0x50,
	0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x10, 0x02, 0x22,
	0x36, 0x0a, 0x1a, 0x50, 0x6f, 0x64, 0x43, 0x49, 0x44, 0x52, 0x4f, 0x76, 0x65, 0x72, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a,
	0x07, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xd0, 0x09, 0x0a, 0x12, 0x49, 0x50, 0x41, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x24,
	0x0a, 0x0e, 0x75, 0x73, 0x65, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x49, 0x70, 0x41, 0x6c, 0x69,
	0x61, 0x73, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x73,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x11, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x12, 0x28, 0x0a, 0x0e, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x70, 0x76, 0x34,
	0x43, 0x69, 0x64, 0x72, 0x12, 0x30, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x70,
	0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x12, 0x3f, 0x0a, 0x1c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x19, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x1d, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x17, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x12, 0x2f, 0x0a, 0x14, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63,
	0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x11, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x12, 0x37, 0x0a, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x69,
	0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x70,
	0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x2d, 0x0a, 0x13, 0x74,
	0x70, 0x75, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x74, 0x70, 0x75, 0x49, 0x70, 0x76,
	0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x73,
	0x65, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09,
	0x75, 0x73, 0x65, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x3d, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x10, 0x69, 0x70, 0x76, 0x36,
	0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x50, 0x76, 0x36, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x69, 0x70, 0x76, 0x36, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x72, 0x0a, 0x1d, 0x70, 0x6f, 0x64, 0x5f, 0x63,
	0x69, 0x64, 0x72, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x64, 0x43, 0x49, 0x44, 0x52, 0x4f, 0x76, 0x65, 0x72,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x1a, 0x70, 0x6f, 0x64, 0x43, 0x69, 0x64, 0x72, 0x4f, 0x76, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x38, 0x0a, 0x16, 0x73,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x13, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49, 0x70, 0x76, 0x36, 0x43, 0x69, 0x64, 0x72,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x3c, 0x0a, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x70, 0x76, 0x36, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x12, 0x74, 0x0a, 0x1c, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19,
	0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x22, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x5f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x19, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1e, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x50, 0x6f, 0x64, 0x49, 0x70, 0x76, 0x34, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x55,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf9, 0x29, 0x0a, 0x07, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x12,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x44,
	0x0a, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61,
	0x75, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x52, 0x0a, 0x6d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x12, 0x27, 0x0a, 0x0f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x2d, 0x0a, 0x12, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2a, 0x0a, 0x11, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34,
	0x43, 0x69, 0x64, 0x72, 0x12, 0x46, 0x0a, 0x0d, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c,
	0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x0a,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3c, 0x0a, 0x0a,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x09, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x5f, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x41, 0x6c, 0x70, 0x68, 0x61,
	0x12, 0x59, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x46, 0x69, 0x6e,
	0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x6c, 0x65, 0x67, 0x61,
	0x63, 0x79, 0x5f, 0x61, 0x62, 0x61, 0x63, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x41, 0x62, 0x61, 0x63, 0x52, 0x0a,
	0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x41, 0x62, 0x61, 0x63, 0x12, 0x49, 0x0a, 0x0e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x59, 0x0a, 0x14, 0x69, 0x70, 0x5f, 0x61, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x50, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x12, 0x69, 0x70,
	0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x82, 0x01, 0x0a, 0x21, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x17, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5b, 0x0a, 0x14,
	0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0b, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x12, 0x49, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x65, 0x0a, 0x1b, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70,
	0x6f, 0x64, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x1e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x78, 0x50, 0x6f,
	0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x18, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x4d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x6f, 0x0a, 0x1c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x19, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6e, 0x0a, 0x1b, 0x61, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x19, 0x61, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x16, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x14, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x65, 0x0a, 0x18, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x70,
	0x6f, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x27,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x69,
	0x63, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x52, 0x16, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x49, 0x0a, 0x0e, 0x73, 0x68, 0x69,
	0x65, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x28, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64,
	0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x0d, 0x73, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x4e,
	0x6f, 0x64, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x52, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x12, 0x65, 0x0a, 0x18, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x2b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x11, 0x6d, 0x65, 0x73,
	0x68, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x43,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x52, 0x10, 0x6d, 0x65, 0x73,
	0x68, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x5f, 0x0a,
	0x16, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x63, 0x6f, 0x73, 0x74, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58,
	0x0a, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x31, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x32,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x11, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12,
	0x62, 0x0a, 0x17, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x36, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x65, 0x6c,
	0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x65, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x66, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x36, 0x0a, 0x17, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x67, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x15, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x16, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x68, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x14, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x69, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x12, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x6a, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x6b, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2c, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x6c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0,
	0x41, 0x03, 0x18, 0x01, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x32, 0x0a, 0x13, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x70, 0x76, 0x34,
	0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x6d, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x70, 0x76, 0x34, 0x43,
	0x69, 0x64, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x6e, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x12, 0x35, 0x0a, 0x13, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x75, 0x72, 0x6c,
	0x73, 0x18, 0x6f, 0x20, 0x03, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x11,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x72, 0x6c,
	0x73, 0x12, 0x33, 0x0a, 0x12, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x70, 0x20, 0x01, 0x28, 0x05, 0x42, 0x05, 0xe0,
	0x41, 0x03, 0x18, 0x01, 0x52, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x64,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x71, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x72, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a,
	0x0a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x70, 0x75, 0x18, 0x73, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x09, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x70, 0x75, 0x12, 0x32, 0x0a, 0x13,
	0x74, 0x70, 0x75, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x18, 0x74, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10,
	0x74, 0x70, 0x75, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b,
	0x12, 0x44, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x76,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x6f, 0x70, 0x69,
	0x6c, 0x6f, 0x74, 0x18, 0x80, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x70, 0x69, 0x6c, 0x6f, 0x74, 0x52, 0x09, 0x61, 0x75, 0x74, 0x6f,
	0x70, 0x69, 0x6c, 0x6f, 0x74, 0x12, 0x14, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x81, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x59, 0x0a, 0x12, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x83, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x48,
	0x00, 0x52, 0x10, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x84, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x53, 0x0a, 0x11, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x85, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b, 0x0a, 0x15, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x88, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x12, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x13, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x8b, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x31, 0x0a, 0x05, 0x66, 0x6c, 0x65,
	0x65, 0x74, 0x18, 0x8c, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x6c, 0x65, 0x65, 0x74, 0x52, 0x05, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x12, 0x63, 0x0a, 0x17,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x91, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x76, 0x0a, 0x1e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x92, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1b, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57, 0x0a, 0x14, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6b, 0x38, 0x73, 0x5f, 0x62, 0x65, 0x74, 0x61, 0x5f, 0x61, 0x70, 0x69,
	0x73, 0x18, 0x8f, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b,
	0x38, 0x73, 0x42, 0x65, 0x74, 0x61, 0x41, 0x50, 0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x11, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4b, 0x38, 0x73, 0x42, 0x65, 0x74, 0x61, 0x41, 0x70,
	0x69, 0x73, 0x12, 0x53, 0x0a, 0x11, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x95, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d, 0x0a, 0x15, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x96, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x13, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x69, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x97, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x17, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x2e, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70,
	0x7a, 0x73, 0x18, 0x98, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01,
	0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x2e, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70,
	0x7a, 0x69, 0x18, 0x99, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x02,
	0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x88, 0x01,
	0x01, 0x12, 0x69, 0x0a, 0x18, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x9a, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x03, 0x52, 0x15, 0x75, 0x73, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x4b,
	0x65, 0x79, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x5c, 0x0a, 0x13,
	0x72, 0x62, 0x61, 0x63, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x9c, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x42, 0x41, 0x43, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x04, 0x52, 0x11, 0x72, 0x62, 0x61, 0x63, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x1a, 0x41, 0x0a, 0x13, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x77, 0x0a,
	0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55,
	0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0f,
	0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52,
	0x41, 0x44, 0x45, 0x44, 0x10, 0x06, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x42,
	0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a,
	0x69, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x16,
	0x0a, 0x14, 0x5f, 0x72, 0x62, 0x61, 0x63, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xc5, 0x02, 0x0a, 0x11, 0x52, 0x42, 0x41, 0x43, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x2e,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f,
	0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x75,
	0x6e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x2a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x55, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x2c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x28, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x88, 0x01, 0x01, 0x42, 0x31, 0x0a, 0x2f, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x75, 0x6e,
	0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x2f, 0x0a,
	0x2d, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x65, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x22, 0x93,
	0x06, 0x0a, 0x15, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x4b, 0x65,
	0x79, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41,
	0x21, 0x0a, 0x1f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x61, 0x12, 0x44, 0x0a,
	0x0b, 0x65, 0x74, 0x63, 0x64, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x63, 0x61, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x09, 0x65, 0x74, 0x63, 0x64, 0x41, 0x70,
	0x69, 0x43, 0x61, 0x12, 0x46, 0x0a, 0x0c, 0x65, 0x74, 0x63, 0x64, 0x5f, 0x70, 0x65, 0x65, 0x72,
	0x5f, 0x63, 0x61, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x0a, 0x65, 0x74, 0x63, 0x64, 0x50, 0x65, 0x65, 0x72, 0x43, 0x61, 0x12, 0x6e, 0x0a, 0x1c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73,
	0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x78, 0x0a, 0x21, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x76,
	0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73,
	0x18, 0x0e, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x1e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x4b, 0x0a, 0x0e, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa,
	0x41, 0x21, 0x0a, 0x1f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x50,
	0x6f, 0x6f, 0x6c, 0x52, 0x0d, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x61, 0x12, 0x77, 0x0a, 0x21, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x1d, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x77, 0x0a, 0x21, 0x67,
	0x6b, 0x65, 0x6f, 0x70, 0x73, 0x5f, 0x65, 0x74, 0x63, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x1d, 0x67, 0x6b, 0x65, 0x6f, 0x70, 0x73, 0x45, 0x74, 0x63,
	0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x22, 0xdf, 0x02, 0x0a, 0x17, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x4a, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x48, 0x00, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x72, 0x0a, 0x14,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x6e, 0x64,
	0x61, 0x72, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x52, 0x13, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x73,
	0x1a, 0x42, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74,
	0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x12, 0x1f, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61,
	0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x73, 0x74, 0x61, 0x6e,
	0x64, 0x61, 0x72, 0x64, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x73, 0x74, 0x61, 0x6e,
	0x64, 0x61, 0x72, 0x64, 0x22, 0x37, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x42, 0x07, 0x0a,
	0x05, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x35, 0x0a, 0x10, 0x4b, 0x38, 0x73, 0x42, 0x65, 0x74,
	0x61, 0x41, 0x50, 0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x41, 0x70, 0x69, 0x73, 0x22, 0xc7, 0x03,
	0x0a, 0x15, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x48, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x70, 0x0a, 0x12, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x01, 0x52, 0x11, 0x76,
	0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x64, 0x65,
	0x88, 0x01, 0x01, 0x22, 0x45, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x4e,
	0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x10, 0x03, 0x22, 0x8a, 0x01, 0x0a, 0x11, 0x56,
	0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x22, 0x0a, 0x1e, 0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42,
	0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x17, 0x0a, 0x13, 0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x56, 0x55, 0x4c,
	0x4e, 0x45, 0x52, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x45, 0x4e, 0x54, 0x45, 0x52,
	0x50, 0x52, 0x49, 0x53, 0x45, 0x10, 0x03, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x42, 0x15, 0x0a, 0x13, 0x5f, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0xe6, 0x02, 0x0a, 0x12, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43,
	0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54,
	0x61, 0x67, 0x73, 0x12, 0x5c, 0x0a, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x52, 0x13, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x54, 0x61, 0x67,
	0x73, 0x12, 0x56, 0x0a, 0x13, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65,
	0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x11, 0x6c, 0x69, 0x6e,
	0x75, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78,
	0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0f, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x6d, 0x0a, 0x10, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x59, 0x0a, 0x14, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x12, 0x6e, 0x6f, 0x64,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x22,
	0xd5, 0x02, 0x0a, 0x12, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x67, 0x63, 0x66, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x63, 0x66, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x67, 0x63,
	0x66, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x51, 0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x4c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x11, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x56, 0x0a, 0x13, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xc9, 0x35, 0x0a, 0x0d, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x4e, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x1a, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x18, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x55, 0x0a, 0x15, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x2f, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49,
	0x64, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x67, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x2e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x19, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x74, 0x0a, 0x20, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x2f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x1d, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61,
	0x0a, 0x19, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x73, 0x68, 0x5f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x43, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x52, 0x17, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x73, 0x12, 0x58, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x68, 0x69,
	0x65, 0x6c, 0x64, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x30, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64,
	0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x14, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x68,
	0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x6e, 0x0a, 0x1e, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x31, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x73, 0x74, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1b,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x43, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x12, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x35, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x4e,
	0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x44, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6b, 0x0a, 0x1d, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x61,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x1a, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x10, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x91, 0x01, 0x0a, 0x29, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x25, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72,
	0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x19, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x12, 0x6a, 0x0a, 0x1c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x62, 0x69, 0x6e, 0x61,
	0x72, 0x79, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x1a, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x7e, 0x0a, 0x24, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x55, 0x73, 0x61, 0x67, 0x65, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x50, 0x6f, 0x64,
	0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x1d, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x72, 0x0a, 0x1e, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x19, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7e,
	0x0a, 0x24, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x72, 0x61, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x72, 0x61, 0x4e, 0x6f, 0x64, 0x65, 0x56, 0x69, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x20, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x72, 0x61, 0x4e, 0x6f, 0x64, 0x65, 0x56, 0x69,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65,
	0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x73, 0x6e, 0x61, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x1c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x53, 0x6e, 0x61, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x18, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x6e, 0x61, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5b, 0x0a, 0x17, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x5f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c,
	0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x15, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x12, 0x6f, 0x0a, 0x1f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6c, 0x34,
	0x69, 0x6c, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x4c, 0x42, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4c, 0x34,
	0x69, 0x6c, 0x62, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x19, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x18, 0x32, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x70, 0x61, 0x74, 0x68, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x17, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x70, 0x61, 0x74, 0x68, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x78, 0x0a, 0x22, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x33, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x49, 0x50, 0x76, 0x36, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x52, 0x1e, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x49, 0x70, 0x76, 0x36, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x12, 0x67, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x37, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x19,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7d, 0x0a, 0x23, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74,
	0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x3f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x41,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x58, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x40, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x61, 0x0a, 0x19, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x41, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x17, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x71, 0x0a, 0x1f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x42, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1c, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a, 0x23, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x3c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x50, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x1f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x1f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x47, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02,
	0x18, 0x01, 0x48, 0x00, 0x52, 0x1c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x53, 0x0a, 0x24, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x48, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x84, 0x01, 0x0a, 0x26, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x49, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x22, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61,
	0x6e, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x64, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x14, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x13, 0x64, 0x65, 0x73, 0x69, 0x72,
	0x65, 0x64, 0x5f, 0x67, 0x63, 0x66, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x6d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x66, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x47, 0x63,
	0x66, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7a, 0x0a, 0x2a, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x61, 0x75,
	0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x6e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x52, 0x24,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41,
	0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x54, 0x61, 0x67, 0x73, 0x12, 0x62, 0x0a, 0x1a, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x72, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x50, 0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x17, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41,
	0x70, 0x69, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x73, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x72, 0x0a, 0x20,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x74, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x1c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3f, 0x0a, 0x0d, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x18, 0x75, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6c,
	0x65, 0x65, 0x74, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x46, 0x6c, 0x65, 0x65,
	0x74, 0x12, 0x4c, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x77, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x6f, 0x0a, 0x1c, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f,
	0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x78, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x19, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x50, 0x6f, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x7e, 0x0a, 0x24, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x79, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50,
	0x6f, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x20,
	0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x50, 0x6f, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x56, 0x0a, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6b, 0x38, 0x73, 0x5f, 0x62,
	0x65, 0x74, 0x61, 0x5f, 0x61, 0x70, 0x69, 0x73, 0x18, 0x7a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x38, 0x73, 0x42, 0x65, 0x74, 0x61, 0x41, 0x50, 0x49, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4b, 0x38, 0x73,
	0x42, 0x65, 0x74, 0x61, 0x41, 0x70, 0x69, 0x73, 0x12, 0x71, 0x0a, 0x1f, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x7c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1c, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8f, 0x01, 0x0a, 0x22,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x7d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1f, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a,
	0x22, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x66, 0x71, 0x64, 0x6e, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x7e, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x1e, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x71, 0x64, 0x6e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x88, 0x01, 0x01, 0x12, 0x82,
	0x01, 0x0a, 0x28, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x70,
	0x69, 0x6c, 0x6f, 0x74, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x80, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x24, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x41, 0x75, 0x74, 0x6f, 0x70, 0x69, 0x6c, 0x6f, 0x74, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x15, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6b,
	0x38, 0x73, 0x5f, 0x62, 0x65, 0x74, 0x61, 0x5f, 0x61, 0x70, 0x69, 0x73, 0x18, 0x83, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x38, 0x73, 0x42, 0x65, 0x74,
	0x61, 0x41, 0x50, 0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x4b, 0x38, 0x73, 0x42, 0x65, 0x74, 0x61, 0x41, 0x70, 0x69, 0x73, 0x12, 0x62,
	0x0a, 0x19, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x86, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x17, 0x64, 0x65, 0x73, 0x69, 0x72,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x4b, 0x0a, 0x1f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x87, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x1c,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x75, 0x6c,
	0x74, 0x69, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12,
	0x94, 0x01, 0x0a, 0x33, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x88, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x52, 0x2c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x24, 0x64, 0x65, 0x73, 0x69, 0x72,
	0x65, 0x64, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x89, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x04, 0x52, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x49, 0x6e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x6b, 0x0a,
	0x30, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x77, 0x69,
	0x64, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x8a, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x2b, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x77, 0x69, 0x64, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x88, 0x01, 0x01, 0x12, 0x71, 0x0a, 0x1d, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x8b, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x06, 0x52, 0x1a,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x7d, 0x0a,
	0x21, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x8c, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x07, 0x52, 0x1e, 0x64, 0x65, 0x73, 0x69, 0x72,
	0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x66, 0x0a, 0x1b,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6b, 0x75, 0x62,
	0x65, 0x6c, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x8d, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62,
	0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x18, 0x64, 0x65, 0x73, 0x69,
	0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x85, 0x01, 0x0a, 0x2c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64,
	0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x8e, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x26, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4b,
	0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x18,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x8f, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x4b, 0x65, 0x79, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x75, 0x73, 0x65,
	0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x6b, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x62,
	0x61, 0x63, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x90, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x42, 0x41, 0x43, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x08, 0x52, 0x18, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x52, 0x62, 0x61, 0x63, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12,
	0x69, 0x0a, 0x19, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x93, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x17, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x88, 0x01, 0x0a, 0x2f, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6c, 0x69, 0x6e,
	0x75, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x96,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75,
	0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x28, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65,
	0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x73, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x71, 0x64, 0x6e, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x64, 0x65,
	0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x42, 0x27, 0x0a,
	0x25, 0x5f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x33, 0x0a, 0x31, 0x5f, 0x64, 0x65, 0x73, 0x69, 0x72,
	0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x77, 0x69, 0x64, 0x65, 0x5f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x20, 0x0a, 0x1e, 0x5f,
	0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x24, 0x0a,
	0x22, 0x5f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x72, 0x62, 0x61, 0x63, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0x8e, 0x01, 0x0a, 0x19, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x50, 0x6f, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x6f, 0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x6f, 0x64, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x0e, 0x70, 0x6f, 0x64,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x70, 0x6f, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x22, 0x56, 0x0a, 0x09, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x0a, 0x17,
	0x44, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x69, 0x72,
	0x65, 0x64, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54, 0x69, 0x65, 0x72,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x54, 0x69, 0x65, 0x72, 0x22, 0x8a, 0x0a,
	0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12,
	0x4f, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x42, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x12, 0x2c, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01,
	0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x20, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x24, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x08,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x57, 0x0a, 0x12, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x11, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59,
	0x0a, 0x13, 0x6e, 0x6f, 0x64, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12, 0x6e, 0x6f, 0x64, 0x65, 0x70, 0x6f, 0x6f, 0x6c, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x22, 0x52, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a,
	0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12,
	0x08, 0x0a, 0x04, 0x44, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x42, 0x4f,
	0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x22, 0xc0, 0x03, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x12,
	0x0a, 0x0e, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x5f, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52,
	0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x5f, 0x4e, 0x4f,
	0x44, 0x45, 0x53, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x5f,
	0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x55, 0x50, 0x44,
	0x41, 0x54, 0x45, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x06, 0x12, 0x14, 0x0a,
	0x10, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x50, 0x4f, 0x4f,
	0x4c, 0x10, 0x07, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x4e, 0x4f,
	0x44, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10, 0x08, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x45, 0x54,
	0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47,
	0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x09, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x55, 0x54, 0x4f, 0x5f,
	0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x53, 0x10, 0x0a, 0x12, 0x1a,
	0x0a, 0x12, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x5f, 0x4e,
	0x4f, 0x44, 0x45, 0x53, 0x10, 0x0b, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x12, 0x0a, 0x0a, 0x53, 0x45,
	0x54, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x53, 0x10, 0x0c, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x17,
	0x0a, 0x0f, 0x53, 0x45, 0x54, 0x5f, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x41, 0x55, 0x54,
	0x48, 0x10, 0x0d, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x45, 0x54, 0x5f, 0x4e,
	0x4f, 0x44, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x10, 0x0e, 0x12,
	0x1a, 0x0a, 0x12, 0x53, 0x45, 0x54, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x50,
	0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x0f, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x1e, 0x0a, 0x16, 0x53,
	0x45, 0x54, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x50,
	0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x10, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x52,
	0x45, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x12, 0x12,
	0x19, 0x0a, 0x15, 0x46, 0x4c, 0x45, 0x45, 0x54, 0x5f, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45,
	0x5f, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x10, 0x13, 0x22, 0x85, 0x03, 0x0a, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x47, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x3e, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x1a, 0x93, 0x01, 0x0a,
	0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1d, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16,
	0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x3b, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x85, 0x01, 0x0a, 0x11,
	0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xc9, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x3f, 0x0a, 0x06, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x91, 0x0f, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x26, 0x0a,
	0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x18, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x58, 0x0a, 0x10, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x75, 0x70, 0x67,
	0x72, 0x61, 0x64, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x34, 0x0a, 0x04,
	0x74, 0x61, 0x67, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x52, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x12, 0x37, 0x0a, 0x06, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x61, 0x69,
	0x6e, 0x74, 0x73, 0x52, 0x06, 0x74, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x50, 0x0a, 0x11, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x4e, 0x6f, 0x64, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x0e, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x13, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6e, 0x6f, 0x64, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a,
	0x0b, 0x67, 0x63, 0x66, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x66, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0a, 0x67, 0x63, 0x66, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x55, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x4e, 0x6f,
	0x64, 0x65, 0x73, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x35, 0x0a, 0x05, 0x67, 0x76, 0x6e, 0x69, 0x63, 0x18,
	0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x74,
	0x75, 0x61, 0x6c, 0x4e, 0x49, 0x43, 0x52, 0x05, 0x67, 0x76, 0x6e, 0x69, 0x63, 0x12, 0x12, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x12, 0x40, 0x0a, 0x0b, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x73,
	0x74, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x0a, 0x66, 0x61, 0x73, 0x74, 0x53, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x51, 0x0a, 0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x56, 0x0a, 0x13, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x22, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x4e,
	0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x0c,
	0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x23, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x24, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x20, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x25, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x25, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x67, 0x62, 0x18, 0x26, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x5c, 0x0a, 0x15, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x74, 0x61,
	0x67, 0x73, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x54, 0x61,
	0x67, 0x73, 0x52, 0x13, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x12, 0x52, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x28, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x13, 0x71,
	0x75, 0x65, 0x75, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x12, 0x71, 0x75, 0x65, 0x75,
	0x65, 0x64, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x23,
	0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18,
	0x2b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x73, 0x22, 0x88, 0x02, 0x0a, 0x1d, 0x53, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x6e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x4f, 0x0a, 0x0b, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xba,
	0x01, 0x0a, 0x18, 0x53, 0x65, 0x74, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16,
	0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc3, 0x01, 0x0a, 0x1b,
	0x53, 0x65, 0x74, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16,
	0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x12, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xd7, 0x01, 0x0a, 0x16, 0x53, 0x65, 0x74, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0d, 0x61, 0x64,
	0x64, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x64, 0x64, 0x6f, 0x6e,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x13,
	0x53, 0x65, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21,
	0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x21, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb3, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x2a,
	0x0a, 0x0e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe7,
	0x02, 0x0a, 0x14, 0x53, 0x65, 0x74, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x4d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x41, 0x75, 0x74, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x50, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x10, 0x0a,
	0x0c, 0x53, 0x45, 0x54, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x10, 0x01, 0x12,
	0x15, 0x0a, 0x11, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x41, 0x53, 0x53,
	0x57, 0x4f, 0x52, 0x44, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x45, 0x54, 0x5f, 0x55, 0x53,
	0x45, 0x52, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x03, 0x22, 0x88, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x68, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x75, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5a,
	0x6f, 0x6e, 0x65, 0x73, 0x22, 0x8b, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x25, 0x0a, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x6a, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16,
	0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x8e,
	0x01, 0x0a, 0x16, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x25, 0x0a, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x7d, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0c, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x22, 0x67,
	0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbe, 0x04, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x17, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x2e, 0x0a, 0x13, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x2c, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a,
	0x0a, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x52,
	0x0a, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x73, 0x1a, 0xe3, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x45, 0x0a, 0x07, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x14, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xce, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a,
	0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x3f, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xaf, 0x01, 0x0a, 0x15, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21,
	0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x24, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x6e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8c, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12,
	0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xac, 0x01, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x24, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x80, 0x04, 0x0a, 0x11, 0x42, 0x6c,
	0x75, 0x65, 0x47, 0x72, 0x65, 0x65, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x76, 0x0a, 0x17, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x47, 0x72, 0x65, 0x65, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72,
	0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x48, 0x00,
	0x52, 0x15, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x55, 0x0a, 0x17, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x73, 0x6f, 0x61, 0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x14, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x53,
	0x6f, 0x61, 0x6b, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x1a, 0xed,
	0x01, 0x0a, 0x15, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x52, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2b, 0x0a, 0x10, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x02, 0x48, 0x00, 0x52, 0x0f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x00, 0x52, 0x0e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x4e, 0x0a, 0x13, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x6f, 0x61, 0x6b, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x11, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x53, 0x6f, 0x61, 0x6b, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01,
	0x01, 0x42, 0x13, 0x0a, 0x11, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x73, 0x6f, 0x61, 0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x10,
	0x0a, 0x0e, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x73,
	0x6f, 0x61, 0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc2, 0x14, 0x0a,
	0x08, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x10, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x4e, 0x6f, 0x64, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x64,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x65,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a,
	0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x75, 0x72, 0x6c, 0x73, 0x18, 0x66, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x72,
	0x6c, 0x73, 0x12, 0x41, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x67, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2c, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x68, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0,
	0x41, 0x03, 0x18, 0x01, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x4a, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x52, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12,
	0x43, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6f, 0x64, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x50, 0x6f,
	0x64, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x0a,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x69, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x30, 0x0a, 0x12, 0x70, 0x6f, 0x64, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63,
	0x69, 0x64, 0x72, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x6f, 0x64, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x6b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x55, 0x70,
	0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x75,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x58,
	0x0a, 0x10, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x6c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4e, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x6d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x6e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x61, 0x0a, 0x13,
	0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x18, 0x70, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x12, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12,
	0x65, 0x0a, 0x18, 0x62, 0x65, 0x73, 0x74, 0x5f, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x71, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x65, 0x73, 0x74, 0x45, 0x66, 0x66, 0x6f,
	0x72, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x16,
	0x62, 0x65, 0x73, 0x74, 0x45, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x1a, 0xa7, 0x02, 0x0a, 0x0f, 0x55, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61,
	0x78, 0x5f, 0x73, 0x75, 0x72, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x6d,
	0x61, 0x78, 0x53, 0x75, 0x72, 0x67, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x75,
	0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0e, 0x6d, 0x61, 0x78, 0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x4c, 0x0a, 0x08, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48,
	0x00, 0x52, 0x08, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x88, 0x01, 0x01, 0x12, 0x5b,
	0x0a, 0x13, 0x62, 0x6c, 0x75, 0x65, 0x5f, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x47, 0x72, 0x65, 0x65, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x48, 0x01, 0x52, 0x11, 0x62, 0x6c, 0x75, 0x65, 0x47, 0x72, 0x65, 0x65, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x62, 0x6c, 0x75,
	0x65, 0x5f, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x1a, 0xfa, 0x04, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x5e, 0x0a, 0x0f, 0x62, 0x6c, 0x75, 0x65, 0x5f, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x47, 0x72, 0x65, 0x65, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x0d, 0x62, 0x6c, 0x75, 0x65, 0x47, 0x72, 0x65, 0x65, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x1a,
	0x8b, 0x04, 0x0a, 0x0d, 0x42, 0x6c, 0x75, 0x65, 0x47, 0x72, 0x65, 0x65, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x52, 0x0a, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x47,
	0x72, 0x65, 0x65, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x52, 0x05,
	0x70, 0x68, 0x61, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x18, 0x62, 0x6c, 0x75, 0x65, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x75, 0x72, 0x6c,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x62, 0x6c, 0x75, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x39,
	0x0a, 0x19, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x16, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x1d, 0x62, 0x6c, 0x75,
	0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x19, 0x62, 0x6c, 0x75, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x67,
	0x72, 0x65, 0x65, 0x6e, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x50, 0x6f,
	0x6f, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x01, 0x0a, 0x05, 0x50, 0x68,
	0x61, 0x73, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x48, 0x41, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x55, 0x50,
	0x44, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x17,
	0x0a, 0x13, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x47, 0x52, 0x45, 0x45, 0x4e,
	0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x4f, 0x52, 0x44, 0x4f,
	0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x42, 0x4c, 0x55, 0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10, 0x03,
	0x12, 0x16, 0x0a, 0x12, 0x44, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x42, 0x4c, 0x55,
	0x45, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x4f, 0x44, 0x45,
	0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x5f, 0x53, 0x4f, 0x41, 0x4b, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12,
	0x16, 0x0a, 0x12, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x42, 0x4c, 0x55, 0x45,
	0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10, 0x06, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c, 0x4c, 0x42,
	0x41, 0x43, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x07, 0x1a, 0xcd, 0x01,
	0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x46, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x74, 0x70, 0x75,
	0x5f, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x74, 0x70, 0x75, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67,
	0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x29, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x10, 0x01, 0x1a, 0x2e, 0x0a,
	0x12, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x81, 0x01,
	0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12,
	0x16, 0x0a, 0x12, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e,
	0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50,
	0x50, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x06, 0x22, 0xa6, 0x01, 0x0a, 0x0e, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x75, 0x70, 0x67,
	0x72, 0x61, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x61, 0x75, 0x74, 0x6f,
	0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f,
	0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75,
	0x74, 0x6f, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x12, 0x50, 0x0a, 0x0f, 0x75, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0e, 0x75, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x62, 0x0a, 0x16, 0x42, 0x65,
	0x73, 0x74, 0x45, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2e,
	0x0a, 0x13, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x6d, 0x69, 0x6e,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x22, 0x77,
	0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3a, 0x0a, 0x17, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x75, 0x70, 0x67,
	0x72, 0x61, 0x64, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x61, 0x75, 0x74, 0x6f,
	0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7e, 0x0a, 0x11, 0x4d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3e, 0x0a, 0x06,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x52, 0x06, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x29, 0x0a, 0x10,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xc2, 0x03, 0x0a, 0x11, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x67, 0x0a,
	0x18, 0x64, 0x61, 0x69, 0x6c, 0x79, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x69, 0x6c, 0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x16,
	0x64, 0x61, 0x69, 0x6c, 0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x55, 0x0a, 0x10, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67,
	0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x65,
	0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x78, 0x0a,
	0x16, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x15, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x69, 0x0a, 0x1a, 0x4d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x35, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x81, 0x02, 0x0a,
	0x0a, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x76, 0x0a, 0x1d, 0x6d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x1b, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xbb, 0x01, 0x0a, 0x1b, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x4c, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x22, 0x4e,
	0x0a, 0x05, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x5f, 0x55, 0x50,
	0x47, 0x52, 0x41, 0x44, 0x45, 0x53, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x4f, 0x5f, 0x4d,
	0x49, 0x4e, 0x4f, 0x52, 0x5f, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x53, 0x10, 0x01, 0x12,
	0x1d, 0x0a, 0x19, 0x4e, 0x4f, 0x5f, 0x4d, 0x49, 0x4e, 0x4f, 0x52, 0x5f, 0x4f, 0x52, 0x5f, 0x4e,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x53, 0x10, 0x02, 0x22, 0x6e,
	0x0a, 0x13, 0x52, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x37, 0x0a, 0x06, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x06, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x1e,
	0x0a, 0x0a, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x58,
	0x0a, 0x16, 0x44, 0x61, 0x69, 0x6c, 0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x02, 0x0a, 0x1c, 0x53, 0x65, 0x74,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04,
	0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x48, 0x0a,
	0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x16,
	0x53, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a,
	0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x34, 0x0a, 0x1e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x1e, 0x52, 0x6f, 0x6c,
	0x6c, 0x62, 0x61, 0x63, 0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x55, 0x70, 0x67,
	0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16,
	0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0c, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x70,
	0x64, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x50, 0x64, 0x62, 0x22, 0x55, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a,
	0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x22, 0xad, 0x04, 0x0a, 0x12,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x12, 0x40, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x4e, 0x6f, 0x64, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x12, 0x4b, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x73, 0x12, 0x6b, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x84,
	0x01, 0x0a, 0x23, 0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x73, 0x52, 0x20, 0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x1a, 0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x19, 0x61, 0x75, 0x74, 0x6f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0x55, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52,
	0x4f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a, 0x45, 0x5f,
	0x55, 0x54, 0x49, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x02, 0x22, 0xaf, 0x05, 0x0a, 0x20,
	0x41, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x53, 0x63, 0x6f,
	0x70, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x58, 0x0a, 0x10,
	0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x43, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x10, 0x6d,
	0x69, 0x6e, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x6d, 0x69, 0x6e, 0x43, 0x70,
	0x75, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x1b, 0x0a, 0x09, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x65, 0x0a, 0x18, 0x73, 0x68, 0x69, 0x65,
	0x6c, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x73, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65,
	0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x29, 0x0a, 0x11, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6b, 0x6d, 0x73,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x62, 0x6f, 0x6f, 0x74,
	0x44, 0x69, 0x73, 0x6b, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x57, 0x0a, 0x26, 0x69, 0x6e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x5f, 0x72, 0x65,
	0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x22, 0x69, 0x6e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x65, 0x4b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x52, 0x65, 0x61, 0x64,
	0x6f, 0x6e, 0x6c, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88,
	0x01, 0x01, 0x42, 0x29, 0x0a, 0x27, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f,
	0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79,
	0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x68, 0x0a,
	0x0d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07,
	0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x22, 0xb3, 0x03, 0x0a, 0x13, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12,
	0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x69, 0x6e,
	0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x24, 0x0a, 0x0e, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x4e, 0x6f, 0x64, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f,
	0x61, 0x75, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x12,
	0x60, 0x0a, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x2f, 0x0a, 0x14, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x4d, 0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x14, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x6d, 0x61, 0x78, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x4d, 0x61, 0x78, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0x48, 0x0a, 0x0e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e, 0x59, 0x10, 0x02, 0x22, 0xe2, 0x02,
	0x0a, 0x10, 0x53, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a,
	0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x67, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x30, 0x0a, 0x11, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a,
	0x41, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xa7, 0x01, 0x0a, 0x14, 0x53, 0x65, 0x74, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79,
	0x41, 0x62, 0x61, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16,
	0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb9, 0x01, 0x0a,
	0x16, 0x53, 0x74, 0x61, 0x72, 0x74, 0x49, 0x50, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x43, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x22, 0x8d, 0x01, 0x0a, 0x19, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x50, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x03, 0x0a, 0x11, 0x41, 0x63, 0x63,
	0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b,
	0x0a, 0x11, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x61, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x61,
	0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x67, 0x70, 0x75, 0x5f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x67, 0x70, 0x75, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x58, 0x0a, 0x12, 0x67, 0x70, 0x75, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x50, 0x55, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10, 0x67, 0x70, 0x75, 0x53, 0x68,
	0x61, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x7a,
	0x0a, 0x1e, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x50, 0x55,
	0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x01, 0x52, 0x1b, 0x67, 0x70, 0x75, 0x44,
	0x72, 0x69, 0x76, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xaf, 0x02, 0x0a, 0x10, 0x47, 0x50, 0x55, 0x53, 0x68, 0x61, 0x72,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x1a, 0x6d, 0x61, 0x78,
	0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x67, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x6d,
	0x61, 0x78, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x50,
	0x65, 0x72, 0x47, 0x70, 0x75, 0x12, 0x6f, 0x0a, 0x14, 0x67, 0x70, 0x75, 0x5f, 0x73, 0x68, 0x61,
	0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x50, 0x55, 0x53, 0x68, 0x61,
	0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x50, 0x55, 0x53, 0x68,
	0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52,
	0x12, 0x67, 0x70, 0x75, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x88, 0x01, 0x01, 0x22, 0x55, 0x0a, 0x12, 0x47, 0x50, 0x55, 0x53, 0x68, 0x61,
	0x72, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x24, 0x0a, 0x20,
	0x47, 0x50, 0x55, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x52, 0x41,
	0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x50, 0x53, 0x10, 0x02, 0x42, 0x17, 0x0a,
	0x15, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0x96, 0x02, 0x0a, 0x1b, 0x47, 0x50, 0x55, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x12, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x50, 0x55, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x50, 0x55, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x67, 0x70, 0x75, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x22, 0x6a, 0x0a, 0x10,
	0x47, 0x50, 0x55, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x1e, 0x47, 0x50, 0x55, 0x5f, 0x44, 0x52, 0x49, 0x56, 0x45, 0x52, 0x5f, 0x56,
	0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x4c, 0x41, 0x54, 0x45, 0x53, 0x54, 0x10, 0x03, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xa0, 0x01, 0x0a, 0x16, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x04, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x22, 0x40, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10,
	0x0a, 0x0c, 0x47, 0x43, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x10, 0x01,
	0x12, 0x10, 0x0a, 0x0c, 0x47, 0x4b, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41,
	0x10, 0x02, 0x22, 0xdb, 0x01, 0x0a, 0x17, 0x53, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x64, 0x12, 0x16, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x4e, 0x0a, 0x0e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xee, 0x01, 0x0a, 0x1b, 0x53, 0x65, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x5a, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xc7, 0x02, 0x0a, 0x0f, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x37, 0x0a, 0x0e, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x0d, 0x63, 0x61,
	0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x04,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x43, 0x4b, 0x4f, 0x55,
	0x54, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x47, 0x4b, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49,
	0x43, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x47, 0x43, 0x45, 0x5f, 0x51, 0x55, 0x4f, 0x54,
	0x41, 0x5f, 0x45, 0x58, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f,
	0x53, 0x45, 0x54, 0x5f, 0x42, 0x59, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x10,
	0x04, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x4b, 0x4d, 0x53, 0x5f, 0x4b,
	0x45, 0x59, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x07, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x41,
	0x5f, 0x45, 0x58, 0x50, 0x49, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x22, 0x85, 0x0d, 0x0a, 0x0d,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x23, 0x0a, 0x0a,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x3f, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x72,
	0x61, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49,
	0x6e, 0x74, 0x72, 0x61, 0x4e, 0x6f, 0x64, 0x65, 0x56, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x12, 0x56, 0x0a, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x6e,
	0x61, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x6e, 0x61,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x11, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x53, 0x6e, 0x61, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x34, 0x69, 0x6c, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x4c, 0x34, 0x69, 0x6c, 0x62, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x12, 0x52, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x70, 0x61, 0x74, 0x68, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x70, 0x61, 0x74, 0x68, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x69, 0x0a, 0x1a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x49, 0x50, 0x76, 0x36, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x17, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x49, 0x70, 0x76, 0x36, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x3d, 0x0a, 0x0a, 0x64, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x4e, 0x53, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x64, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x6c, 0x0a, 0x1b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x50, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53,
	0x0a, 0x12, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x50, 0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x10, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x70, 0x69, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x36, 0x0a, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x75, 0x6c, 0x74,
	0x69, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x80, 0x01, 0x0a, 0x1a,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x18, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40,
	0x0a, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x71, 0x64, 0x6e, 0x5f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x00, 0x52, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x71, 0x64, 0x6e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x88, 0x01, 0x01,
	0x12, 0x74, 0x0a, 0x1c, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x01, 0x52, 0x19, 0x69, 0x6e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x5b, 0x0a, 0x28, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x77,
	0x69, 0x64, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x24, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x77,
	0x69, 0x64, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x88, 0x01, 0x01, 0x12, 0x44, 0x0a, 0x1c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x19, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x88, 0x01, 0x01, 0x1a, 0xf9, 0x01, 0x0a, 0x1f, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8b, 0x01,
	0x0a, 0x1b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62,
	0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x69, 0x65, 0x72, 0x48, 0x00, 0x52, 0x18,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x61, 0x6e, 0x64, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x54, 0x69, 0x65, 0x72, 0x88, 0x01, 0x01, 0x22, 0x28, 0x0a, 0x04, 0x54,
	0x69, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x49, 0x45,
	0x52, 0x5f, 0x31, 0x10, 0x01, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x5f, 0x74, 0x69, 0x65, 0x72, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x66, 0x71, 0x64, 0x6e, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x2b, 0x0a, 0x29, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x77,
	0x69, 0x64, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x73, 0x22, 0xc9, 0x01, 0x0a, 0x10, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41,
	0x50, 0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x41, 0x50, 0x49, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x22, 0x6c, 0x0a, 0x07, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x17, 0x0a, 0x13,
	0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c,
	0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x14, 0x43,
	0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x52, 0x49, 0x4d, 0x45, 0x4e,
	0x54, 0x41, 0x4c, 0x10, 0x03, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0